/*========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/


/*
 * File:	m4_functions.c
 * Purpose:	m4 functions. 
 *
 * Notes:		
 */

#include "typedefs.h"
#include "typedefs_UINT8.h"

#if defined (__ICCARM__)
#pragma diag_suppress=Pe618
#endif

#include "S32V234.h"  /* include peripheral declarations */

#if defined (__ICCARM__)
#pragma diag_warning=Pe618
#endif

typedef struct {
	uint32_t reg_r[4];
	uint32_t reg_r12;
	uint32_t reg_lr;
	uint32_t reg_pc;
	uint32_t xpsr;
}EXCEPTION_FRAME_T;

EXCEPTION_FRAME_T *excep_ptr;

//static void hard_fault_handler( EXCEPTION_FRAME_T *) __attribute__( ( naked ) );
uint32_t hard_fault_num = 0;

void m4_hard_fault_routine(EXCEPTION_FRAME_T *excep_ptr)
{
   if(CM4_0.HFSR.B.FORCED)
   {
//   	  printf("A forced hard fault, generated by escalation of another fault with configurable priority that cannot be handled, either because of priority or because it is disabled");
      if(CM4_0.CFSR.R & 0x400)
      {
//	  	printf("Imprecise data bus error. Fault Address is not known. Return address should be correct in stack frame");
		CM4_0.CFSR.R = 0x400;
		(*(uint32_t*)0x3ef03000)++;
	    *(uint32_t*)0x3ef03000 = (*(uint32_t*)0x3ef03000);
      }
	  if(CM4_0.CFSR.R & 0x200)
	  {
	     if(excep_ptr->reg_pc & 0x2)
		 	excep_ptr->reg_pc+=2;
		 else if (((*(uint32_t *) excep_ptr->reg_pc)&0xF8000000)>0xE0000000)   //32 bit thumb2 instruction
		 	excep_ptr->reg_pc+=4;
		 else                                                     //16 bit thumb instruction
		 	excep_ptr->reg_pc+=2;
//	  	 printf("Precise data bus error. The PC value stacked for the exception return points to the instruction that caused the fault. incrementing the address to avoid fault loop");
		 CM4_0.CFSR.R = 0x200;
		 (*(uint32_t*)0x3ef03004)++;
	     *(uint32_t*)0x3ef03004 = (*(uint32_t*)0x3ef03004);
	  }
	  CM4_0.HFSR.R = 0x40000000;
   }
   if(CM4_0.CFSR.R & 0x8000)
   {
//      printf("exception due to accessing 0x%x address", &CM4_0.BFAR.R);
	  CM4_0.CFSR.R = 0x8000;
   }
   hard_fault_num++;
}

