/*========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/

 /*
 *	fpu_init.c	-	init FPU
 *
 */


#if defined (__ICCARM__)
#pragma diag_suppress=Pe618
#endif

#include "S32V234.h"  /* include peripheral declarations */

#if defined (__ICCARM__)
#pragma diag_warning=Pe618
#endif

#ifndef __IO
#ifdef __cplusplus
  #define   __I     volatile             /*!< Defines 'read only' permissions                 */
#else
  #define   __I     volatile const       /*!< Defines 'read only' permissions                 */
#endif
#define     __O     volatile             /*!< Defines 'write only' permissions                */
#define     __IO    volatile             /*!< Defines 'read / write' permissions              */
#endif

#define SCS_BASE            (0xE000E000UL)                            /*!< System Control Space Base Address  */

typedef struct {
  __IO unsigned long CPACR;                   /*!< Offset: 0x088 (R/W)  Coprocessor Access Control Register */
} CPACR_Type;


#define SCB_BASE            (SCS_BASE +  0x0D00UL)                    /*!< System Control Block Base Address  */
#define CPACR_BASE          (SCB_BASE +  0x088UL)                    /*!< Coprocessor Access Control Register  */

#define SCB_CPACR           ((CPACR_Type     *)     CPACR_BASE     )   /*!< CPACR configuration struct          */

#define FPU_BASE          (SCS_BASE +  0x0F30UL)                    /*!< Floating Point Unit                */
#define FPU               ((FPU_Type       *)     FPU_BASE      )   /*!< Floating Point Unit                */

void init_FPU (void) {
#if ((defined (__VFP_FP__) && !defined(__SOFTFP__)) ||  (defined (__ICCARM__) && defined(__ARMVFP__)))
	SCB_CPACR->CPACR |= ((3UL << 10*2) | (3UL << 11*2));    /* set CP10, CP11 Full Access */
#endif /* #if defined (__VFP_FP__) && !defined(__SOFTFP__)*/


}
