/*
 * Copyright (c) 2015 - 2016, Freescale Semiconductor, Inc.
 * Copyright 2017 NXP
 * All rights reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED  WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

 /*
 *	data_init.c	-	clear bss, copy initialized data
 */

#include "S32V234.h"

extern unsigned int __bss_start__;
extern unsigned int __bss_end__;

void init_data (void)
{
    uint32_t* bss_begin = (uint32_t*)&__bss_start__;
    uint32_t* bss_end   = (uint32_t*)&__bss_end__;
    uint8_t * data_ram, * data_rom, * data_rom_end;
   
    uint32_t n;
    
    while(bss_begin < bss_end)
    {
        *bss_begin = 0;
        bss_begin++;
    }
    
    /* Get the addresses for the .data section (initialized data section) */

    extern  uint32_t __DATA_ROM[];
    extern  uint32_t __DATA_RAM[];
    extern  uint32_t __DATA_END[];
    data_ram = (uint8_t *)__DATA_RAM;
    data_rom = (uint8_t *)__DATA_ROM;
    data_rom_end  = (uint8_t *)__DATA_END;
    n = data_rom_end - data_rom;

    /* Copy initialized data from ROM to RAM */
    while (n--)
    {
        *data_ram++ = *data_rom++;
    }
    
        
}

