/*****************************************************************************
 *
 * NXP Confidential Proprietary
 *
 * Copyright (c) 2018 NXP Semiconductor;
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/
ENTRY(Reset_Handler)

/*
To use "new" operator with EWL in C++ project the following symbol shall be defined
*/
/*EXTERN(_ZN10__cxxabiv119__terminate_handlerE)*/

STACK_SIZE = DEFINED(__stack_size__) ? __stack_size__ : 0x2000;
HEAP_SIZE  = DEFINED(__heap_size__)  ? __heap_size__  : 0x2000;
    
MEMORY {
    SRAM                : ORIGIN = 0x3E800000,              LENGTH = 1024K - 4K /* EDMA Descriptor Area (0x1000 bytes) from 0x3EBFF000*/
    TCM_DATA            : ORIGIN = 0x3E000000,              LENGTH = 32K
    TCM_CODE            : ORIGIN = 0x1E000000,              LENGTH = 32K
}
   
SECTIONS
{
    
    /* Interrupt vectors area */
    .intvec            : 
	{
	    M4_0_VECTOR_TABLE = .;
		M4_0_VECTOR_RAM = .;
	    *(.intvec*)
		M4_0_VECTOR_SIZE = .;
	}  > SRAM

    /* The program code and other data goes into internal flash */
    .text :
    {
    *(.text)                 /* .text sections (code) */
    *(.text*)                /* .text* sections (code) */
    *(.rodata)               /* .rodata sections (constants, strings, etc.) */
    *(.rodata*)              /* .rodata* sections (constants, strings, etc.) */
    *(.glue_7)               /* glue arm to thumb code */
    *(.glue_7t)              /* glue thumb to arm code */
    *(.syscall*)
    *(.secinfo*)
    *(.jcr*)
    *(.eh_frame)
    KEEP (*(.init))
    KEEP (*(.fini))
    } > SRAM

	.ARM.extab        ALIGN(4)             : 
    {
     *(.ARM.extab*)
    } > SRAM

    .ctors :
    {
        __CTOR_LIST__ = .;
        /* gcc uses crtbegin.o to find the start of
           the constructors, so we make sure it is
           first.  Because this is a wildcard, it
           doesn't matter if the user does not
           actually link against crtbegin.o; the
           linker won't look for a file to match a
           wildcard.  The wildcard also means that it
           doesn't matter which directory crtbegin.o
           is in.  */
        KEEP (*crtbegin.o(.ctors))
        KEEP (*crtbegin?.o(.ctors))
        /* We don't want to include the .ctor section from
           from the crtend.o file until after the sorted ctors.
           The .ctor section from the crtend file contains the
           end of ctors marker and it must be last */
        KEEP (*(EXCLUDE_FILE(*crtend?.o *crtend.o) .ctors))
        KEEP (*(SORT(.ctors.*)))
        KEEP (*(.ctors))
        __CTOR_END__ = .;
    } > SRAM

    .dtors :
    {
        __DTOR_LIST__ = .;
        KEEP (*crtbegin.o(.dtors))
        KEEP (*crtbegin?.o(.dtors))
        KEEP (*(EXCLUDE_FILE(*crtend?.o *crtend.o) .dtors))
        KEEP (*(SORT(.dtors.*)))
        KEEP (*(.dtors))
        __DTOR_END__ = .;
    } > SRAM

    .preinit_array :
    {
        PROVIDE_HIDDEN (__preinit_array_start = .);
        KEEP (*(.preinit_array*))
        PROVIDE_HIDDEN (__preinit_array_end = .);
    } > SRAM

    .init_array :
    {
        PROVIDE_HIDDEN (__init_array_start = .);
        KEEP (*(SORT(.init_array.*)))
        KEEP (*(.init_array*))
        PROVIDE_HIDDEN (__init_array_end = .);
    } > SRAM
    
    .fini_array :
    {
        PROVIDE_HIDDEN (__fini_array_start = .);
        KEEP (*(SORT(.fini_array.*)))
        KEEP (*(.fini_array*))
        PROVIDE_HIDDEN (__fini_array_end = .);
    } > SRAM


	.ARM.exidx  	  ALIGN(0)             : 
	{
		__exidx_start = .;
		*(.ARM.exidx*)
		__exidx_end = .;
	} > SRAM
    .rodata 	      ALIGN(0)             : {*(.rodata*)} > SRAM
	.sdabase 	      ALIGN(16)            : {*(.sdabase*)} > SRAM
	.sdata 	          ALIGN(0)             : {*(.sdata*)} > SRAM
	.sdata2 	      ALIGN(0)             : {*(.sdata2*)} > SRAM
	.sbss 	          ALIGN(0)             : {*(.sbss*)} > SRAM
	.data 	          ALIGN(4)             : 
	{
	    __DATA_RAM = .;
        __DATA_ROM = .;
	    *(.data*)
		__DATA_END = .;
	} > SRAM
	
	.bss ALIGN(16) :
    {
        _BSS_BEGIN = .;
        __bss_start__ = .;
        *(.bss*)       /* Zero-filled run time allocate data memory */
        *(COMMON)        
        __bss_end__ = .;
        _BSS_END = .;
    }  > SRAM
    
	.CodeRelocateRam  ALIGN(0)  : 
	{
	    CODE_RELOCATE_SRAM = .;
	    CODE_RELOCATE_ROM = .;
	    *(.CodeRelocateRam*)
		CODE_RELOCATE_ROM_END = .;
	} > SRAM

	/* stack and heap shall be located in the same memory region */
	.heap     ORIGIN(TCM_DATA): 
    {
    	. = ALIGN(8);
        __end__ = .;
        _end = .;
    	PROVIDE(end = .);
        __HeapBase = .;
    	. += HEAP_SIZE;
        __HeapLimit = .;
    }  > TCM_DATA   

    .stack   :
    {
        . = ALIGN(8);
        . += STACK_SIZE;
        __CM4_0_STACK_ADDRESS = .; 
    } > TCM_DATA

    __StackTop   = ORIGIN(TCM_DATA) + LENGTH(TCM_DATA);
    __StackLimit = __StackTop - STACK_SIZE;
    PROVIDE(__stack = __StackTop);
    
    __SRAM_START_ADDRESS__ = ORIGIN(SRAM); 
    __RAM_SIZE__ = LENGTH(SRAM);

    __TCM_DATA_START_ADDRESS__ = ORIGIN(TCM_DATA); 
    __TCM_DATA_SIZE__ = LENGTH(TCM_DATA);

    /* Labels required by EWL */
    __START_BSS = __bss_start__;
    __END_BSS = __bss_end__;
    __SP_INIT = __StackTop;  

    .ARM.attributes 0 : { *(.ARM.attributes) }
    
    ASSERT(__StackLimit >= __HeapLimit, "region TCM_DATA overflowed with stack and heap")    
}