/*****************************************************************************
 *
 * NXP Confidential Proprietary
 *
 * Copyright (c) 2018 NXP Semiconductor;
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/
ENTRY(Reset_Handler)

/*
To use "new" operator with EWL in C++ project the following symbol shall be defined
*/
/*EXTERN(_ZN10__cxxabiv119__terminate_handlerE)*/

STACK_SIZE = DEFINED(__stack_size__) ? __stack_size__ : 0x2000;
HEAP_SIZE  = DEFINED(__heap_size__)  ? __heap_size__  : 0x2000;
M_VECTOR_RAM_SIZE = DEFINED(__ram_vector_table__) ? 0x0800 : 0x0;

FLASH_START_ADDRESS = 0x20000000;
FLASH_SIZE = 0x4000000; /* 64Mb */
RAM_START_ADDRESS = 0x3E800000;
RAM_SIZE = 0x100000; /* 1024K */

FLASH_CONFIG_OFFSET = 0x200;
FLASH_APP_HDR_OFFSET = 0x1000; 
VECTOR_OFFSET = 0x1400;    /* It was shifted by 800 to align the address for VTOR 
                           limitation of aligning the offset to the no of exception 
                           entries in the vectoor table. For TR since M4 has 239 interrupts, 
                           it should be 256 WORD aligned. */

FLASH_CONFIG_SIZE = 0x140; /* 318 bytes */
FLASH_APP_HDR_SIZE = 0x40;
FLASH_BOOT_DATA_SIZE = 0xC;
FLASH_DCD_SIZE = 0x30;
VECTOR_TABLE_SIZE = 0x800;
FLASH_CODE_SIZE = FLASH_SIZE - VECTOR_TABLE_SIZE - VECTOR_OFFSET;


FLASH_CONFIG_ADDRESS = FLASH_START_ADDRESS + FLASH_CONFIG_OFFSET;
FLASH_APP_HDR_ADDRESS = FLASH_START_ADDRESS + FLASH_APP_HDR_OFFSET;
FLASH_BOOT_DATA_ADDRESS = FLASH_APP_HDR_ADDRESS + FLASH_APP_HDR_SIZE;
FLASH_DCD_ADDRESS = FLASH_BOOT_DATA_ADDRESS + FLASH_BOOT_DATA_SIZE + 0x4;
VECTOR_TABLE_ADDRESS = FLASH_START_ADDRESS + VECTOR_OFFSET;
FLASH_CODE_ADDRESS =  VECTOR_TABLE_ADDRESS + VECTOR_TABLE_SIZE;
    
MEMORY {
    FLASH_CTX	        : ORIGIN = 0x3e800000,	  					       LENGTH = 0x200
    FLASH_CONFIG        : ORIGIN = 0x3e800000 + 0x200,                     LENGTH = 0x140
    FLASH_APP_HDR       : ORIGIN = 0x3e800000 + 0x1000,                    LENGTH = 0x40
    FLASH_BOOT_DATA     : ORIGIN = 0x3e800000 + 0x1000 + 0x40,             LENGTH = 0xC
    FLASH_DCD           : ORIGIN = 0x3e800000 + 0x1000 + 0x40 + 0xC + 0x4, LENGTH = 0x30 
    VECTOR_TABLE        : ORIGIN = 0x3e800000 + 0x1400,                    LENGTH = 0x800
    FLASH               : ORIGIN = 0x3e800000 + 0x1400 + 0x800,            LENGTH = 0x4000000 - 0x800 - 0x1400
    SRAM                : ORIGIN = 0x3E900000,                             LENGTH = 0x2FF000 /* EDMA Descriptor Area (0x1000 bytes) from 0x3EBFF000*/
    TCM_DATA            : ORIGIN = 0x3E000000,                             LENGTH = 0x4000
}
   
/* Define output sections */
SECTIONS
{
    /* Interrupt vectors area */
    .intvec            : 
    {
         __VECTOR_TABLE = .;
        M4_0_VECTOR_TABLE = .;
        M4_0_VECTOR_RAM = .;
        *(.intvec*)
        M4_0_VECTOR_SIZE = .;
    }  > VECTOR_TABLE

    .QSPIFlashCtx :
    {
    KEEP(*(.QSPIFlashCtx))    /* QSPI FLASH Context */
    } > FLASH_CTX
    
    .QSPIFlashConfig :
    {
    KEEP(*(.QSPIFlashConfig))    /* QSPI FLASH cofig param */
    } > FLASH_CONFIG
    
    .flash_app_hdr :
    {
    KEEP(*(.flash_app_hdr))    /* flash app header */
    } > FLASH_APP_HDR
    
    .flash_boot_data :
    {
    KEEP(*(.flash_boot_data))    /* flash app header */
    } > FLASH_BOOT_DATA
    
    .flash_dcd :
    {
    KEEP(*(.flash_dcd))    /* flash app header */
    } > FLASH_DCD
    
    /* The program code and other data goes into internal flash */
    .text :
    {
    *(.text)                 /* .text sections (code) */
    *(.text*)                /* .text* sections (code) */
    *(.rodata)               /* .rodata sections (constants, strings, etc.) */
    *(.rodata*)              /* .rodata* sections (constants, strings, etc.) */
    *(.glue_7)               /* glue arm to thumb code */
    *(.glue_7t)              /* glue thumb to arm code */
    *(.eh_frame)
    KEEP (*(.init))
    KEEP (*(.fini))
    } > FLASH
    
    .ARM.extab  ALIGN(4) :
    {
    *(.ARM.extab* .gnu.linkonce.armextab.*)
    } > FLASH
    
    .ARM :
    {
    __exidx_start = .;
    *(.ARM.exidx*)
    __exidx_end = .;
    } > FLASH
    
    .ctors :
    {
    __CTOR_LIST__ = .;
    /* gcc uses crtbegin.o to find the start of
        the constructors, so we make sure it is
        first.  Because this is a wildcard, it
        doesn't matter if the user does not
        actually link against crtbegin.o; the
        linker won't look for a file to match a
        wildcard.  The wildcard also means that it
        doesn't matter which directory crtbegin.o
        is in.  */
    KEEP (*crtbegin.o(.ctors))
    KEEP (*crtbegin?.o(.ctors))
    /* We don't want to include the .ctor section from
        from the crtend.o file until after the sorted ctors.
        The .ctor section from the crtend file contains the
        end of ctors marker and it must be last */
    KEEP (*(EXCLUDE_FILE(*crtend?.o *crtend.o) .ctors))
    KEEP (*(SORT(.ctors.*)))
    KEEP (*(.ctors))
    __CTOR_END__ = .;
    } > FLASH
    
    .dtors :
    {
    __DTOR_LIST__ = .;
    KEEP (*crtbegin.o(.dtors))
    KEEP (*crtbegin?.o(.dtors))
    KEEP (*(EXCLUDE_FILE(*crtend?.o *crtend.o) .dtors))
    KEEP (*(SORT(.dtors.*)))
    KEEP (*(.dtors))
    __DTOR_END__ = .;
    } > FLASH
    
    .preinit_array :
    {
    PROVIDE_HIDDEN (__preinit_array_start = .);
    KEEP (*(.preinit_array*))
    PROVIDE_HIDDEN (__preinit_array_end = .);
    } > FLASH
    
    .init_array :
    {
    PROVIDE_HIDDEN (__init_array_start = .);
    KEEP (*(SORT(.init_array.*)))
    KEEP (*(.init_array*))
    PROVIDE_HIDDEN (__init_array_end = .);
    } > FLASH
    
    .fini_array :
    {
    PROVIDE_HIDDEN (__fini_array_start = .);
    KEEP (*(SORT(.fini_array.*)))
    KEEP (*(.fini_array*))
    PROVIDE_HIDDEN (__fini_array_end = .);
    } > FLASH
    
    __etext = .;    /* define a global symbol at end of code */
    __DATA_ROM = .; /* Symbol is used by startup for data initialization */
    
    .interrupts_ram :
    {
    . = ALIGN(4);
    __VECTOR_RAM__ = .;
    __interrupts_ram_start__ = .; /* Create a global symbol at data start */
    *(.m_interrupts_ram)     /* This is a user defined section */
    . += M_VECTOR_RAM_SIZE;
    . = ALIGN(4);
    __interrupts_ram_end__ = .; /* Define a global symbol at data end */
    } > SRAM
    
    __VECTOR_RAM = DEFINED(__ram_vector_table__) ? __VECTOR_RAM__ : ORIGIN(VECTOR_TABLE);
    __RAM_VECTOR_TABLE_SIZE_BYTES = DEFINED(__ram_vector_table__) ? (__interrupts_ram_end__ - __interrupts_ram_start__) : 0x0;
    
    .data : AT(__DATA_ROM)
    {
    . = ALIGN(4);
    __DATA_RAM = .;
    __data_start__ = .;      /* create a global symbol at data start */
    *(.data)                 /* .data sections */
    *(.data*)                /* .data* sections */
    KEEP(*(.jcr*))
    . = ALIGN(4);
    __data_end__ = .;        /* define a global symbol at data end */
    } > SRAM
    
    __DATA_END = __DATA_ROM + (__data_end__ - __data_start__);
    
    /* Uninitialized data section */
    .bss :
    {
    /* This is used by the startup in order to initialize the .bss section */
    . = ALIGN(4);
    __START_BSS = .;
    __bss_start__ = .;
    *(.bss)
    *(.bss*)
    *(COMMON)
    . = ALIGN(4);
    __bss_end__ = .;
    __END_BSS = .;
    } > SRAM
    
    .CodeRelocateRam  ALIGN(0)  : 
    {
        CODE_RELOCATE_SRAM = .;
        CODE_RELOCATE_ROM = .;
        *(.CodeRelocateRam*)
        CODE_RELOCATE_ROM_END = .;
    } > SRAM
    
    .heap ORIGIN(TCM_DATA) :
    {
    . = ALIGN(8);
    __end__ = .;
    _end = .;
    PROVIDE(end = .);
    __HeapBase = .;
    . += HEAP_SIZE;
    __HeapLimit = .;
    } > TCM_DATA
    
    .stack   :
    {
        . = ALIGN(8);
        . += STACK_SIZE;
        __CM4_0_STACK_ADDRESS = .; 
    } > TCM_DATA
    
    /* Initializes stack on the end of block */
    __StackTop   = ORIGIN(TCM_DATA) + LENGTH(TCM_DATA);
    __StackLimit = __StackTop - STACK_SIZE;
    PROVIDE(__stack = __StackTop);
    
    __SRAM_START_ADDRESS__ = ORIGIN(SRAM); 
    __RAM_SIZE__ = LENGTH(SRAM);

    __TCM_DATA_START_ADDRESS__ = ORIGIN(TCM_DATA); 
    __TCM_DATA_SIZE__ = LENGTH(TCM_DATA);

    /* Labels required by EWL */
    __START_BSS = __bss_start__;
    __END_BSS = __bss_end__;
    __SP_INIT = __StackTop;  
    
    .ARM.attributes 0 : { *(.ARM.attributes) }
    
    ASSERT(__StackLimit >= __HeapLimit, "region TCM_DATA overflowed with stack and heap")
}

