/*========================================================================*
*                          Copyright 2018 NXP.

* This software is owned or controlled by NXP and may only be used strictly
* in accordance with the applicable license terms. By expressly accepting
* such terms or by downloading, installing, activating and/or otherwise
* using the software, you are agreeing that you have read, and that you
* agree to comply with and are bound by, such license terms. If you do not
* agree to be bound by the applicable license terms, then you may not retain,
* install, activate or otherwise use the software.
*
 **************************************************************************/
 
/* Linker script to configure memory regions. */
MEMORY
{
    DUMMY_FLASH     : ORIGIN = 0x20000000,                             LENGTH = 0x200
	FLASH_CONFIG    : ORIGIN = 0x20000000 + 0x200,                     LENGTH = 0x140
	FLASH_APP_HDR   : ORIGIN = 0x20000000 + 0x1000,                    LENGTH = 0x40
	FLASH_BOOT_DATA : ORIGIN = 0x20000000 + 0x1000 + 0x40,             LENGTH = 0x10
	FLASH_DCD       : ORIGIN = 0x20000000 + 0x1000 + 0x40 + 0x10,	   LENGTH = 0x50 /* Needs to be big enough for new DCD commands */ 
	FLASH (rx)      : ORIGIN = 0x20010000,                             LENGTH = 0x02000000 - 0x10000
	RAM   (rwx)     : ORIGIN = 0x3E900000,                             LENGTH = 0x40000
}

/* Library configurations */

/* Linker script to place sections and symbol values. Should be used together
 * with other linker script that defines memory regions FLASH and RAM.
 * It references following symbols, which must be defined in code:
 *   Reset_Handler : Entry of reset handler
 *
 * It defines following symbols, which code can use without definition:
 *   __exidx_start
 *   __exidx_end
 *   __etext
 *   __data_start__
 *   __preinit_array_start
 *   __preinit_array_end
 *   __init_array_start
 *   __init_array_end
 *   __fini_array_start
 *   __fini_array_end
 *   __data_end__
 *   __bss_start__
 *   __bss_end__
 *   __end__
 *   end
 *   __HeapLimit
 *   __StackLimit
 *   __StackTop
 *   __stack
 *   __Vectors_End
 *   __Vectors_Size
 */
ENTRY(Reset_Handler)

SECTIONS
{

  	.DUMMY :
 	 {
  	  KEEP(*(.DUMMY))    /* QSPI FLASH cofig param */
 	 } > DUMMY_FLASH
 	 
	.QSPIFlashConfig :
	{
		KEEP(*(.QSPIFlashConfig))    /* QSPI FLASH cofig param */
	} > FLASH_CONFIG

	.flash_app_hdr :
	{
		KEEP(*(.flash_app_hdr))    /* flash app header */
	} > FLASH_APP_HDR

	.flash_boot_data :
	{
		KEEP(*(.flash_boot_data))    /* flash app header */
	} > FLASH_BOOT_DATA

	.flash_dcd :
	{
	 KEEP(*(.flash_dcd))    /* flash app header */
	} > FLASH_DCD

	.text :
	{
		KEEP(*(.startup))

		KEEP(*(.vectors))
		__Vectors_End = .;
		__Vectors_Size = __Vectors_End - __Vectors;
		__end__ = .;

		*(.text*)

		KEEP(*(.init))
		KEEP(*(.fini))

		/* .ctors */
		*crtbegin.o(.ctors)
		*crtbegin?.o(.ctors)
		*(EXCLUDE_FILE(*crtend?.o *crtend.o) .ctors)
		*(SORT(.ctors.*))
		*(.ctors)

		/* .dtors */
		*crtbegin.o(.dtors)
		*crtbegin?.o(.dtors)
		*(EXCLUDE_FILE(*crtend?.o *crtend.o) .dtors)
		*(SORT(.dtors.*))
		*(.dtors)

		*(.rodata*)
		*(.gcc_except_table*)

		KEEP(*(.eh_frame*))
	} > FLASH

	.ARM.extab :
	{
		*(.ARM.extab* .gnu.linkonce.armextab.*)
	} > FLASH

	__exidx_start = .;
	.ARM.exidx :
	{
		*(.ARM.exidx* .gnu.linkonce.armexidx.*)
	} > FLASH
	__exidx_end = .;

	. = ALIGN(8);
	__etext = .; 

	.data : AT (__etext)
	{
		__data_start__ = .;
		*(vtable)
		*(.data*)

		. = ALIGN(8);
		/* preinit data */
		PROVIDE_HIDDEN (__preinit_array_start = .);
		KEEP(*(.preinit_array))
		PROVIDE_HIDDEN (__preinit_array_end = .);

		. = ALIGN(8);
		/* init data */
		PROVIDE_HIDDEN (__init_array_start = .);
		KEEP(*(SORT(.init_array.*)))
		KEEP(*(.init_array))
		PROVIDE_HIDDEN (__init_array_end = .);

		. = ALIGN(8);
		/* finit data */
		PROVIDE_HIDDEN (__fini_array_start = .);
		KEEP(*(SORT(.fini_array.*)))
		KEEP(*(.fini_array))
		PROVIDE_HIDDEN (__fini_array_end = .);

		KEEP(*(.jcr*))
		. = ALIGN(8);
		/* All data end */
		__data_end__ = .;

	} > RAM

	.bss :
	{
		. = ALIGN(8);
		__bss_start__ = .;
		*(.bss*)
		*(COMMON)
		. = ALIGN(8);
		__bss_end__ = .;
	} > RAM

	.heap (COPY):
	{
		__HeapBase = .;
		__end__ = .;
		end = __end__;
		KEEP(*(.heap*))
		__HeapLimit = .;
	} > RAM

	/* .stack_dummy section doesn't contains any symbols. It is only
	 * used for linker to calculate size of stack sections, and assign
	 * values to stack symbols later */
	.stack_dummy (COPY):
	{
		KEEP(*(.stack*))
	} > RAM

	/* Set stack top to end of RAM, and stack limit move down by
	 * size of stack_dummy section */
	__StackTop = ORIGIN(RAM) + LENGTH(RAM);
	__StackLimit = __StackTop - SIZEOF(.stack_dummy);
	PROVIDE(__stack = __StackTop);

	/* Check if data + heap + stack exceeds RAM limit */
	ASSERT(__StackLimit >= __HeapLimit, "region RAM overflowed with stack")
	__RAM_START_ADDRESS__ = ORIGIN(RAM); 
	__RAM_SIZE__ = LENGTH(RAM);
}
