/*****************************************************************************
 *
 * Copyright (c) 2018 NXP
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/
    .syntax unified
    .arch armv7-m

    .extern __StackTop

#ifdef START_FROM_FLASH
 .extern    __SRAM_START_ADDRESS__
 .extern    __RAM_SIZE__
#endif

    .section .intvec, "a"
    .align 2
    .globl __isr_vector
__isr_vector:
    .long   __StackTop                                      /* Top of Stack */
    .long   Reset_Handler                                   /* Reset Handler */
    .long   NMI_Handler                                     /* NMI Handler*/
    .long   HardFault_Handler                               /* Hard Fault Handler*/
    .long   0                                               /* Reserved*/
    .long   BusFault_Handler                                /* Bus Fault Handler*/
    .long   UsageFault_Handler                              /* Usage Fault Handler*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   SVC_Handler                                     /* SVCall Handler*/
    .long   DebugMon_Handler                                /* Debug Monitor Handler*/
    .long   0                                               /* Reserved*/
    .long   PendSV_Handler                                  /* PendSV Handler*/
    .long   SysTick_Handler                                 /* SysTick Handler*/

                                                            /* CPU to CPU and Directed Interrupts*/
    .long   CPU_CPU0_IRQHandler                             /* CPU to CPU int0 */
    .long   CPU_CPU1_IRQHandler                             /* CPU to CPU int1 */
    .long   CPU_CPU2_IRQHandler                             /* CPU to CPU int2 */
    .long   CPU_CPU3_IRQHandler                             /* CPU to CPU int3 */
    .long   0                                               /* Reserved*/
    .long   CPU_MCM_IRQHandler                              /* Directed Cortex-M4 (= MCM) */
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
                                                            /* On-Platform Vectors */
    .long   DMA0_Ch0_Ch15_IRQHandler                        /* DMA Channel 0-15 Transfer Complete*/
    .long   DMA0_Ch16_Ch31_IRQHandler                       /* DMA Channel 16-31 Transfer Complete*/
    .long   DMA0_Ch0_Ch31_Error_IRQHandler                  /* DMA Error Interrupt Channels 0-31*/
    .long   SWT0_IRQHandler                                 /* Software Watchdog Timer 0 */
    .long   SWT1_IRQHandler                                 /* Software Watchdog Timer 1 */
    .long   SWT2_IRQHandler                                 /* Software Watchdog Timer 2 */
    .long   0                                               /* SWT for S32V234 */
    .long   0                                               /* SWT for S32V234 */
    .long   ERM_SB_IRQHandler                               /* Single bit ECC error */
    .long   ERM_MB_IRQHandler                               /* Multi bit ECC error */
    .long   CSE_IRQ_IRQHandler                              /* CSE Command Complete */
    .long   STM0_IRQHandler                                 /* System Timer Module 0 */
    .long   STM1_IRQHandler                                 /* System Timer Module 1 */
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
                                                            /* Off-Platform Vectors */
    .long   QSPI_IRQHandler                                 /* QuadSPI IRQ */
    .long   STCU_IRQHandler                                 /* MBIST IRQ */
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   USDHC_IRQHandler                                /* USDHC IRQ */
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   PIT_RTI0_IRQHandler                             /* 6 interrupts (one per channel) */
    .long   PIT_RTI1_IRQHandler                             /* 4 interrupts (one per channel) */
    .long   FTM0_IRQHandler                                 /* FTM0 single interrupt vector for all sources*/
    .long   FTM1_IRQHandler                                 /* FTM1 single interrupt vector for all sources*/
    .long   ENET_Timer_IRQHandler                           /* ENET Timer IRQ */
    .long   ENET_TX_IRQHandler                              /* ENET TX IRQ */
    .long   ENET_RX_IRQHandler                              /* ENET RX IRQ */
    .long   ENET_Err_IRQHandler                             /* ENET Error/Generic IRQ */
    .long   SAR_ADC_IRQHandler                              /* EOC, ERR, WD */
    .long   0                                               /* Reserved*/
    .long   CAN0_IRQHandler                                 /* FlexCAN0 FLEXCAN_ESR[ERR_INT], FLEXCAN_ESR_BOFF | FLEXCAN_Transmit_Warning | FLEXCAN_Receive_Warning | FLEXCAN_ERRSR[HANCEIF] | FLEXCAN_ERRSR[FANCEIF] | FLEXCAN_ERRSR[CEIF] or-ed together*/
    .long   CAN0_Buff_IRQHandler                            /* FlexCAN0 FLEXCAN_BUFF_00_63 */
    .long   CAN1_IRQHandler                                 /* FlexCAN1 FLEXCAN_ESR[ERR_INT], FLEXCAN_ESR_BOFF | FLEXCAN_Transmit_Warning | FLEXCAN_Receive_Warning | FLEXCAN_ERRSR[HANCEIF] | FLEXCAN_ERRSR[FANCEIF] | FLEXCAN_ERRSR[CEIF] or-ed together*/
    .long   CAN1_Buff_IRQHandler                            /* FlexCAN1 FLEXCAN_BUFF_00_63 */
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   FR_xRNEIF_IRQHandler                            /* Flexray LRNEIF | DRNEIF */
    .long   FR_xRCEIF_IRQHandler                            /* Flexray LRCEIF | DRCEIF */
    .long   FR_FAFAIF_IRQHandler                            /* Flexray FAFAIF */
    .long   FR_FAFBIF_IRQHandler                            /* Flexray FAFBIF */
    .long   FR_WUPIF_IRQHandler                             /* Flexray WUPIF */
    .long   FR_PRIF_IRQHandler                              /* Flexray PRIF */
    .long   FR_CHIF_IRQHandler                              /* Flexray CHIF */
    .long   FR_TBIF_IRQHandler                              /* Flexray TBIF */
    .long   FR_RBIF_IRQHandler                              /* Flexray RBIF */
    .long   FR_MIF_IRQHandler                               /* Flexray MIF */
    .long   Linflex_D0_IRQHandler                           /* RX, TX and ERR or-ed together */
    .long   Linflex_D1_IRQHandler                           /* RX, TX and ERR or-ed together */
    .long   SPI0_IRQHandler                                 /* Serial peripheral Interface 0 */
    .long   SPI1_IRQHandler                                 /* Serial peripheral Interface 1 */
    .long   SPI2_IRQHandler                                 /* Serial peripheral Interface 2 */
    .long   SPI3_IRQHandler                                 /* Serial peripheral Interface 3 */
    .long   CMU7_IRQHandler                                 /* FIRC3 Clock Fail */
    .long   0                                               /* Reserved */
    .long   I2C0_IRQHandler                                 /* Inter-integrated circuit 0 */
    .long   I2C1_IRQHandler                                 /* Inter-integrated circuit 1 */
    .long   I2C2_IRQHandler                                 /* Inter-integrated circuit 2 */
    .long   SIUL_IRQHandler                                 /* Pin interrupts all or-ed together */
    .long   MC_ME_IRQHandler                                /* Mode Transition Interrupt, Invalid Mode Interrupt, Invalid Mode Config */
    .long   MC_RGM_IRQHandler                               /* Functional reset alternate event interrupt */
    .long   PMC_IRQHandler                                  /* IRQ */
    .long   FCCU_ALARM_IRQHandler                           /* FCCU Interrupt request (ALARM state) */
    .long   FCCU_MISC_IRQHandler                            /* FCCU Interrupt request (miscellaneous conditions) */
    .long   SIPI1_IRQHandler                                /* Read interrupt channel 1 */
    .long   SIPI2_IRQHandler                                /* Read interrupt channel 2 */
    .long   SIPI3_IRQHandler                                /* Read interrupt channel 3 */
    .long   SIPI4_IRQHandler                                /* Read interrupt channel 4 */
    .long   SIPI_TRIG_IRQHandler                            /* Trigger command */
    .long   SIPI_ERR_IRQHandler                             /* Err1, Err2 */
    .long   LFAST_IRQHandler                                /* Tx interrupt, Tx exception, Rx interrupt, Rx exception, Rx ICLC: all or-ed together */
    .long   FastDMA_TC_IRQHandler                           /* FastDMA Transfer Complete */
    .long   FastDMA_ERR_IRQHandler                          /* FastDMA error | CRC error */
    .long   HPSMI_ERR_IRQHandler                            /* ECC error, MPU error, Exception interrupt */
    .long   0                                               /* Reserved */
    .long   HPSMI_WTP_IRQHandler                            /* Watchpoint hit */
    .long   MEW0_IRQHandler                                 /* Watchpoint hit */
    .long   MEW1_IRQHandler                                 /* Watchpoint hit */
    .long   SSE_IRQHandler                                  /* Combined interrupt (OUT2, OUT3) */
    .long   MIPI_CSI_2_0_Camera_IRQHandler                  /* Interrupt generation on error Interrupt at PHY , Protocol or Packet level */
    .long   MIPI_CSI_2_1_Camera_IRQHandler                  /* Interrupt generation on error Interrupt at PHY , Protocol or Packet level */
    .long   MIPI_CSI_2_Bridge0_IRQHandler                   /* Interrupt generation for the virtual channels and embedded data at start of frame */
    .long   MIPI_CSI_2_Bridge1_IRQHandler                   /* Interrupt generation for the virtual channels and embedded data at start of frame */
    .long   DCU_2D_ACE_IRQHandler                           /* IRQ */
    .long   VIU0_IRQHandler                                 /* Or-ed IRQ */
    .long   DEC200_IRQHandler                               /* Flush done/error interrupt */
    .long   ENC200_IRQHandler                               /* Flush done/error interrupt */
    .long   TMU_IRQHandler                                  /* Or-ed IRQ */
    .long   VIU1_IRQHandler                                 /* Or-ed IRQ */
    .long   GC3000_IRQHandler                               /* One interrupt signal */
    .long   0                                               /* PCIE for S32V234 */
    .long   0                                               /* PCIE for S32V234 */
    .long   0                                               /* PCIE for S32V234 */
    .long   0                                               /* PCIE for S32V234 */
    .long   0                                               /* PCIE for S32V234 */
    .long   0                                               /* PCIE for S32V234 */
    .long   0                                               /* PCIE for S32V234 */
    .long   APEX_CL0_IRQHandler                             /* Global interrupt */
    .long   APEX_CL1_IRQHandler                             /* Global interrupt */
    .long   CCI_400_IRQHandler                              /* nERRORIRQ, nEVNTCNTOVERFLOW[4:0] */
    .long   VSEQ_PAR_IRQHandler                             /* Code & Data RAM or CRAM parity error | PRAM parity error */
    .long   VSEQ_MSG_READY_IRQHandler                       /* Message-ready */
    .long   VSEQ_MSG_ACK_IRQHandler                         /* Message-ack */
    .long   VSEQ_INT_ERR_IRQHandler                         /* Seq_int_err */
    .long   VSEQ_DMA_IRQHandler                             /* Internal DMA done */
    .long   VSEQ_IPUS_IRQHandler                            /* IPUS Done */
    .long   VSEQ_IPUV_IRQHandler                            /* IPUV Done */
    .long   VSEQ_MISC_IRQHandler                            /* Other/Misc peripherals Done */
    .long   VSEQ_TRIG0_IRQHandler                           /* Event trigger 0 */
    .long   VSEQ_TRIG1_IRQHandler                           /* Event trigger 1 */
    .long   VSEQ_TRIG2_IRQHandler                           /* Event trigger 2 */
    .long   VSEQ_TRIG3_IRQHandler                           /* Event trigger 3 */
    .long   VSEQ_TRIG4_IRQHandler                           /* Event trigger 4 */
    .long   VSEQ_TRIG5_IRQHandler                           /* Event trigger 5 */
    .long   VSEQ_TRIG6_IRQHandler                           /* Event trigger 6 */
    .long   VSEQ_TRIG7_IRQHandler                           /* Event trigger 7 */
    .long   JPEG_SOI_IRQHandler                             /* SOI */
    .long   JPEG_EOI_IRQHandler                             /* EOI */
    .long   JPEG_FIFO1_IRQHandler                           /* st_fifo_watermark_1 */
    .long   JPEG_FIFO2_IRQHandler                           /* st_fifo_watermark_2 */
    .long   JPEG_FIFO3_IRQHandler                           /* st_fifo_watermark_3 */
    .long   JPEG_FIFO4_IRQHandler                           /* st_fifo_watermark_4 */
    .long   JPEG_ERR_IRQHandler                             /* Config_err */
    .long   JPEG_ROW_IRQHandler                             /* mcu_row_done */
    .long   H264_GT0_IRQHandler                             /* grt_than_thr_ch_0 */
    .long   H264_EOF0_IRQHandler                            /* EOF_0 */
    .long   H264_EOF1_IRQHandler                            /* EOF_1 */
    .long   H264_EOF2_IRQHandler                            /* EOF_2 */
    .long   H264_EOF3_IRQHandler                            /* EOF_3 */
    .long   H264_FIFO1_IRQHandler                           /* st_fifo_watermark_1 */
    .long   H264_FIFO2_IRQHandler                           /* st_fifo_watermark_2 */
    .long   H264_FIFO3_IRQHandler                           /* st_fifo_watermark_3 */
    .long   H264_FIFO4_IRQHandler                           /* st_fifo_watermark_4 */
    .long   H264_ERR_IRQHandler                             /* Err_irq or-ed with oos */
    .long   H264_MBROW0_IRQHandler                          /* MBROW_done_0 */
    .long   H264_MBROW1_IRQHandler                          /* MBROW_done_1 */
    .long   H264_MBROW2_IRQHandler                          /* MBROW_done_2 */
    .long   H264_MBROW3_IRQHandler                          /* MBROW_done_3 */
    .long   H264_VF_IRQHandler                              /* video_frame_done */
    .long   H264_NR_IRQHandler                              /* bs_new_row */
    .long   H264_CB_ALARM_IRQHandler                        /* cb_alarm_int */
    .long   H264_LINE_IRQHandler                            /* vi_line_int */
    .long   H264_LCOUNT_ALARM_IRQHandler                    /* vi_lcount_alarm_int */
    .long   H264_OOS_IRQHandler                             /* encoder_oos */
    .long   H264_FETCH_16_IRQHandler                        /* FETCH_16_DONE */
    .long   H264_FETCH_16_FF_OVF_IRQHandler                 /* FETCH_16_FF_OVF_INT */
    .long   H264_ALL_IRQHandler                             /* Or-ed irq */
    .long   CA53_COMM_0_0_IRQHandler                        /* nCOMMIRQ[0] Cluster 0 */
    .long   CA53_COMM_0_1_IRQHandler                        /* nCOMMIRQ[1] Cluster 0 */
    .long   CA53_COMM_1_0_IRQHandler                        /* nCOMMIRQ[0] Cluster 1 */
    .long   CA53_COMM_1_1_IRQHandler                        /* nCOMMIRQ[1] Cluster 1 */
    .long   CA53_PMU_0_0_IRQHandler                         /* nPMUIRQ[0] Cluster 0 */
    .long   CA53_PMU_0_1_IRQHandler                         /* nPMUIRQ[1] Cluster 0 */
    .long   CA53_PMU_1_0_IRQHandler                         /* nPMUIRQ[0] Cluster 1 */
    .long   CA53_PMU_1_1_IRQHandler                         /* nPMUIRQ[1] Cluster 1 */
    .long   CA53_CTI_0_0_IRQHandler                         /* CTIIRQ[0] Cluster 0 */
    .long   CA53_CTI_0_1_IRQHandler                         /* CTIIRQ[1] Cluster 0 */
    .long   CA53_CTI_1_0_IRQHandler                         /* CTIIRQ[0] Cluster 1 */
    .long   CA53_CTI_1_1_IRQHandler                         /* CTIIRQ[1] Cluster 1 */
    .long   CA53_AXI_0_IRQHandler                           /* nEXTERRIRQ Cluster 0 AXI write error */
    .long   CA53_AXI_1_IRQHandler                           /* nEXTERRIRQ Cluster 1 AXI write error */
    .long   CA53_L2_0_IRQHandler                            /* nINTERRIRQ Cluster 0 L2 RAM double-bit ECC error */
    .long   CA53_L2_1_IRQHandler                            /* nINTERRIRQ Cluster 1 L2 RAM double-bit ECC error */
    .long   XOSC_IRQHandler                                 /* Counter expired */
    .long   0xFFFFFFFF                                      /* Reserved for user TRIM value*/

    .size    __isr_vector, . - __isr_vector

    .text
    .thumb

/* Reset Handler */

    .thumb_func
    .align 2
    .globl   Reset_Handler
    .weak    Reset_Handler
    .type    Reset_Handler, %function
Reset_Handler:
    mov     r0,#0                   
    mov     r1,#0
    mov     r2,#0
    mov     r3,#0
    mov     r4,#0
    mov     r5,#0
    mov     r6,#0
    mov     r7,#0
    mov     r8,r7
    mov     r9,r7
    mov     r10,r7
    mov     r11,r7
    mov     r12,r7
  
// set stack   
    ldr r0, =__StackTop
    mov sp, r0
    
// Disable Watchdog
    movw     r0,#0xA010   // swt0_sr (0x4000a010)
    movt     r0,#0x4000
	movw     r1,#0xC520
	str      r1, [r0]
	movw     r1,#0xD928
	str      r1, [r0]
	movw     r0,#0xA000   // swto_cr (0x4000A000)
	movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0xFF00
	str      r1, [r0]

    movw     r0,#0x6010   //swt4_sr (0x40086010UL)
    movt     r0,#0x4008
	movw     r1,#0xC520   //key
	str      r1, [r0]
	movw     r1,#0xD928
	str      r1, [r0]
	movw     r0,#0x6000   //swt4_cr (0x40086000UL)
	movt     r0,#0x4008
	movw     r1,#0x0000  //swt disable
	movt     r1,#0xFF00
	str      r1, [r0]


// TCM data memory init

    movw     r0,#0x3000   // mm.l $40003000 $00000040
    movt     r0,#0x4000
	movw     r1,#0x0040
	movt     r1,#0x0000
	str      r1, [r0]

    movw     r0,#0x3004   // mm.l $40003004 $03030000
    movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0x0303
	str      r1, [r0]

    movw     r0,#0x3008   // mm.l $40003008 $00400000
    movt     r0,#0x4000

    ldr r1, =__TCM_DATA_SIZE__
	str      r1, [r0]

    movw     r0,#0x300C   // mm.l $4000300C $00000000
    movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0x0000
	str      r1, [r0]

    movw     r0,#0x3010   // mm.l $40003010 $3e800000
    movt     r0,#0x4000

    ldr r1, =__TCM_DATA_START_ADDRESS__
	str      r1, [r0]

    movw     r0,#0x3014   // mm.l $40003014 $00010008
    movt     r0,#0x4000
	movw     r1,#0x0008
	movt     r1,#0x0001
	str      r1, [r0]

    movw     r0,#0x3018   // mm.l $40003018 $00000000
    movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0x0000
	str      r1, [r0]

    movw     r0,#0x301C   // mm.l $4000301C $00010089
    movt     r0,#0x4000
	movw     r1,#0x0001
	movt     r1,#0x0001
	str      r1, [r0]

.sram_loop_tcm:
    movw     r0,#0x301C
    movt     r0,#0x4000
	ldr	r3, [r0]
	and	r3, r3, #128
	cmp	r3, #128
	bne	.sram_loop_tcm
    
#ifdef START_FROM_FLASH

// ECC init of SRAM with use eDMA TCD0

    movw     r0,#0x3000   // mm.l $40003000 $00000040
    movt     r0,#0x4000
	movw     r1,#0x0040
	movt     r1,#0x0000
	str      r1, [r0]

    movw     r0,#0x3004   // mm.l $40003004 $03030000
    movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0x0303
	str      r1, [r0]

    movw     r0,#0x3008   // mm.l $40003008 $00400000
    movt     r0,#0x4000

    ldr r1, =__RAM_SIZE__
	str      r1, [r0]

    movw     r0,#0x300C   // mm.l $4000300C $00000000
    movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0x0000
	str      r1, [r0]

    movw     r0,#0x3010   // mm.l $40003010 $3e800000
    movt     r0,#0x4000

    ldr r1, =__SRAM_START_ADDRESS__
	str      r1, [r0]

    movw     r0,#0x3014   // mm.l $40003014 $00010008
    movt     r0,#0x4000
	movw     r1,#0x0008
	movt     r1,#0x0001
	str      r1, [r0]

    movw     r0,#0x3018   // mm.l $40003018 $00000000
    movt     r0,#0x4000
	movw     r1,#0x0000
	movt     r1,#0x0000
	str      r1, [r0]

    movw     r0,#0x301C   // mm.l $4000301C $00010089
    movt     r0,#0x4000
	movw     r1,#0x0001
	movt     r1,#0x0001
	str      r1, [r0]

.sram_loop:
    movw     r0,#0x301C
    movt     r0,#0x4000
	ldr	r3, [r0]
	and	r3, r3, #128
	cmp	r3, #128
	bne	.sram_loop

#endif
    
    bl init_data
#if defined (__VFP_FP__) && !defined(__SOFTFP__)    
    bl init_FPU
#endif /* #if defined (__VFP_FP__) && !defined(__SOFTFP__)*/    

#ifndef __START
#define __START _start
#endif
    bl __START

JumpToSelf:
    b       JumpToSelf

    .ltorg
    .size Reset_Handler, . - Reset_Handler

    .align  1
    .thumb_func
    .weak DefaultISR
    .type DefaultISR, %function
DefaultISR:
    b       DefaultISR
    .size DefaultISR, . - DefaultISR

/*    Macro to define default handlers. Default handler
 *    will be weak symbol and just dead loops. They can be
 *    overwritten by other handlers */
    .macro def_irq_handler	handler_name
    .weak \handler_name
    .set  \handler_name, DefaultISR
    .endm

/* Exception Handlers */
    def_irq_handler    NMI_Handler
    def_irq_handler    HardFault_Handler
    def_irq_handler    BusFault_Handler
    def_irq_handler    UsageFault_Handler
    def_irq_handler    SVC_Handler
    def_irq_handler    DebugMon_Handler
    def_irq_handler    PendSV_Handler
    def_irq_handler    SysTick_Handler
    def_irq_handler    CPU_CPU0_IRQHandler
    def_irq_handler    CPU_CPU1_IRQHandler
    def_irq_handler    CPU_CPU2_IRQHandler
    def_irq_handler    CPU_CPU3_IRQHandler
    def_irq_handler    CPU_MCM_IRQHandler
    def_irq_handler    DMA0_Ch0_Ch15_IRQHandler
    def_irq_handler    DMA0_Ch16_Ch31_IRQHandler
    def_irq_handler    DMA0_Ch0_Ch31_Error_IRQHandler
    def_irq_handler    SWT0_IRQHandler
    def_irq_handler    SWT1_IRQHandler
    def_irq_handler    SWT2_IRQHandler
    def_irq_handler    ERM_SB_IRQHandler
    def_irq_handler    ERM_MB_IRQHandler
    def_irq_handler    CSE_IRQ_IRQHandler
    def_irq_handler    STM0_IRQHandler
    def_irq_handler    STM1_IRQHandler
    def_irq_handler    QSPI_IRQHandler
    def_irq_handler    STCU_IRQHandler
    def_irq_handler    USDHC_IRQHandler
    def_irq_handler    PIT_RTI0_IRQHandler
    def_irq_handler    PIT_RTI1_IRQHandler
    def_irq_handler    FTM0_IRQHandler
    def_irq_handler    FTM1_IRQHandler
    def_irq_handler    ENET_Timer_IRQHandler
    def_irq_handler    ENET_TX_IRQHandler
    def_irq_handler    ENET_RX_IRQHandler
    def_irq_handler    ENET_Err_IRQHandler
    def_irq_handler    SAR_ADC_IRQHandler
    def_irq_handler    CAN0_IRQHandler
    def_irq_handler    CAN0_Buff_IRQHandler
    def_irq_handler    CAN1_IRQHandler
    def_irq_handler    CAN1_Buff_IRQHandler
    def_irq_handler    FR_xRNEIF_IRQHandler
    def_irq_handler    FR_xRCEIF_IRQHandler
    def_irq_handler    FR_FAFAIF_IRQHandler
    def_irq_handler    FR_FAFBIF_IRQHandler
    def_irq_handler    FR_WUPIF_IRQHandler
    def_irq_handler    FR_PRIF_IRQHandler
    def_irq_handler    FR_CHIF_IRQHandler
    def_irq_handler    FR_TBIF_IRQHandler
    def_irq_handler    FR_RBIF_IRQHandler
    def_irq_handler    FR_MIF_IRQHandler
    def_irq_handler    Linflex_D0_IRQHandler
    def_irq_handler    Linflex_D1_IRQHandler
    def_irq_handler    SPI0_IRQHandler
    def_irq_handler    SPI1_IRQHandler
    def_irq_handler    SPI2_IRQHandler
    def_irq_handler    SPI3_IRQHandler
    def_irq_handler    CMU7_IRQHandler
    def_irq_handler    I2C0_IRQHandler
    def_irq_handler    I2C1_IRQHandler
    def_irq_handler    I2C2_IRQHandler
    def_irq_handler    SIUL_IRQHandler
    def_irq_handler    MC_ME_IRQHandler
    def_irq_handler    MC_RGM_IRQHandler
    def_irq_handler    PMC_IRQHandler
    def_irq_handler    FCCU_ALARM_IRQHandler
    def_irq_handler    FCCU_MISC_IRQHandler
    def_irq_handler    SIPI1_IRQHandler
    def_irq_handler    SIPI2_IRQHandler
    def_irq_handler    SIPI3_IRQHandler
    def_irq_handler    SIPI4_IRQHandler
    def_irq_handler    SIPI_TRIG_IRQHandler
    def_irq_handler    SIPI_ERR_IRQHandler
    def_irq_handler    LFAST_IRQHandler
    def_irq_handler    FastDMA_TC_IRQHandler
    def_irq_handler    FastDMA_ERR_IRQHandler
    def_irq_handler    HPSMI_ERR_IRQHandler
    def_irq_handler    HPSMI_WTP_IRQHandler
    def_irq_handler    MEW0_IRQHandler
    def_irq_handler    MEW1_IRQHandler
    def_irq_handler    SSE_IRQHandler
    def_irq_handler    MIPI_CSI_2_0_Camera_IRQHandler
    def_irq_handler    MIPI_CSI_2_1_Camera_IRQHandler
    def_irq_handler    MIPI_CSI_2_Bridge0_IRQHandler
    def_irq_handler    MIPI_CSI_2_Bridge1_IRQHandler
    def_irq_handler    DCU_2D_ACE_IRQHandler
    def_irq_handler    VIU0_IRQHandler
    def_irq_handler    DEC200_IRQHandler
    def_irq_handler    ENC200_IRQHandler
    def_irq_handler    TMU_IRQHandler
    def_irq_handler    VIU1_IRQHandler
    def_irq_handler    GC3000_IRQHandler
    def_irq_handler    APEX_CL0_IRQHandler
    def_irq_handler    APEX_CL1_IRQHandler
    def_irq_handler    CCI_400_IRQHandler
    def_irq_handler    VSEQ_PAR_IRQHandler
    def_irq_handler    VSEQ_MSG_READY_IRQHandler
    def_irq_handler    VSEQ_MSG_ACK_IRQHandler
    def_irq_handler    VSEQ_INT_ERR_IRQHandler
    def_irq_handler    VSEQ_DMA_IRQHandler
    def_irq_handler    VSEQ_IPUS_IRQHandler
    def_irq_handler    VSEQ_IPUV_IRQHandler
    def_irq_handler    VSEQ_MISC_IRQHandler
    def_irq_handler    VSEQ_TRIG0_IRQHandler
    def_irq_handler    VSEQ_TRIG1_IRQHandler
    def_irq_handler    VSEQ_TRIG2_IRQHandler
    def_irq_handler    VSEQ_TRIG3_IRQHandler
    def_irq_handler    VSEQ_TRIG4_IRQHandler
    def_irq_handler    VSEQ_TRIG5_IRQHandler
    def_irq_handler    VSEQ_TRIG6_IRQHandler
    def_irq_handler    VSEQ_TRIG7_IRQHandler
    def_irq_handler    JPEG_SOI_IRQHandler
    def_irq_handler    JPEG_EOI_IRQHandler
    def_irq_handler    JPEG_FIFO1_IRQHandler
    def_irq_handler    JPEG_FIFO2_IRQHandler
    def_irq_handler    JPEG_FIFO3_IRQHandler
    def_irq_handler    JPEG_FIFO4_IRQHandler
    def_irq_handler    JPEG_ERR_IRQHandler
    def_irq_handler    JPEG_ROW_IRQHandler
    def_irq_handler    H264_GT0_IRQHandler
    def_irq_handler    H264_EOF0_IRQHandler
    def_irq_handler    H264_EOF1_IRQHandler
    def_irq_handler    H264_EOF2_IRQHandler
    def_irq_handler    H264_EOF3_IRQHandler
    def_irq_handler    H264_FIFO1_IRQHandler
    def_irq_handler    H264_FIFO2_IRQHandler
    def_irq_handler    H264_FIFO3_IRQHandler
    def_irq_handler    H264_FIFO4_IRQHandler
    def_irq_handler    H264_ERR_IRQHandler
    def_irq_handler    H264_MBROW0_IRQHandler
    def_irq_handler    H264_MBROW1_IRQHandler
    def_irq_handler    H264_MBROW2_IRQHandler
    def_irq_handler    H264_MBROW3_IRQHandler
    def_irq_handler    H264_VF_IRQHandler
    def_irq_handler    H264_NR_IRQHandler
    def_irq_handler    H264_CB_ALARM_IRQHandler
    def_irq_handler    H264_LINE_IRQHandler
    def_irq_handler    H264_LCOUNT_ALARM_IRQHandler
    def_irq_handler    H264_OOS_IRQHandler
    def_irq_handler    H264_FETCH_16_IRQHandler
    def_irq_handler    H264_FETCH_16_FF_OVF_IRQHandler
    def_irq_handler    H264_ALL_IRQHandler
    def_irq_handler    CA53_COMM_0_0_IRQHandler
    def_irq_handler    CA53_COMM_0_1_IRQHandler
    def_irq_handler    CA53_COMM_1_0_IRQHandler
    def_irq_handler    CA53_COMM_1_1_IRQHandler
    def_irq_handler    CA53_PMU_0_0_IRQHandler
    def_irq_handler    CA53_PMU_0_1_IRQHandler
    def_irq_handler    CA53_PMU_1_0_IRQHandler
    def_irq_handler    CA53_PMU_1_1_IRQHandler
    def_irq_handler    CA53_CTI_0_0_IRQHandler
    def_irq_handler    CA53_CTI_0_1_IRQHandler
    def_irq_handler    CA53_CTI_1_0_IRQHandler
    def_irq_handler    CA53_CTI_1_1_IRQHandler
    def_irq_handler    CA53_AXI_0_IRQHandler
    def_irq_handler    CA53_AXI_1_IRQHandler
    def_irq_handler    CA53_L2_0_IRQHandler
    def_irq_handler    CA53_L2_1_IRQHandler
    def_irq_handler    XOSC_IRQHandler

    .end

     
