/*****************************************************************************
 *
 * Copyright (c) 2018 NXP
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/


#if defined (__ICCARM__)
#pragma diag_suppress=Pe618
#endif

#include "S32V232.h"  /* include peripheral declarations */

#if defined (__ICCARM__)
#pragma diag_warning=Pe618
#endif

#ifndef __IO
#ifdef __cplusplus
  #define   __I     volatile             /*!< Defines 'read only' permissions                 */
#else
  #define   __I     volatile const       /*!< Defines 'read only' permissions                 */
#endif
#define     __O     volatile             /*!< Defines 'write only' permissions                */
#define     __IO    volatile             /*!< Defines 'read / write' permissions              */
#endif

#define SCS_BASE            (0xE000E000UL)                            /*!< System Control Space Base Address  */

typedef struct {
  __IO unsigned long CPACR;                   /*!< Offset: 0x088 (R/W)  Coprocessor Access Control Register */
} CPACR_Type;


#define SCB_BASE            (SCS_BASE +  0x0D00UL)                    /*!< System Control Block Base Address  */
#define CPACR_BASE          (SCB_BASE +  0x088UL)                    /*!< Coprocessor Access Control Register  */

#define SCB_CPACR           ((CPACR_Type     *)     CPACR_BASE     )   /*!< CPACR configuration struct          */

#define FPU_BASE          (SCS_BASE +  0x0F30UL)                    /*!< Floating Point Unit                */
#define FPU               ((FPU_Type       *)     FPU_BASE      )   /*!< Floating Point Unit                */

void init_FPU (void) {
#if ((defined (__VFP_FP__) && !defined(__SOFTFP__)) ||  (defined (__ICCARM__) && defined(__ARMVFP__)))
	SCB_CPACR->CPACR |= ((3UL << 10*2) | (3UL << 11*2));    /* set CP10, CP11 Full Access */
#endif /* #if defined (__VFP_FP__) && !defined(__SOFTFP__)*/


}
