/*****************************************************************************
 *
 * Copyright (c) 2018 NXP
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#include "S32V232.h"

#define _RPC_MODE

#ifdef _RPC_MODE
const uint8_t __attribute__((section (".QSPIFlashConfig"))) config_param[318] = {
0x01/*DQS Config : enable config*/,0x01/*DQS Config*/,0x01/*DQS Config*/,0x01/*DQS Config*/,0x01/*Hold Delay : Data aligned with 2x serial flash half clock*/,0x00/*Half Speed Phase Selection*/,0x00/*Half Speed Delay Selection*/,
0x00/*Reserved*/, 0x00/*Serial Clock Configuration*/,0x00/*Serial Clock Configuration*/,0x00/*Serial Clock Configuration*/,0x00/*Serial Clock Configuration*/,0x00/*SoC Configuration*/,0x00/*SoC Configuration*/,
0x00/*SoC Configuration*/,0x00/*SoC Configuration*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Chip Select hold time*/,0x00/*Chip Select hold time*/,0x00/*Chip Select hold time*/,
0x00/*Chip Select hold time*/,0x00/*Chip Select setup time*/,0x00/*Chip Select setup time*/,0x00/*Chip Select setup time*/,0x00/*Chip Select setup time*/,0x00/*Serial Flash A1 size*/,0x00/*Serial Flash A1 size*/,
0x00/*Serial Flash A1 size*/,0x40/*Serial Flash A1 size*/,0x00/*Serial Flash A2 size*/,0x00/*Serial Flash A2 size*/,0x00/*Serial Flash A2 size*/,0x00/*Serial Flash A2 size*/,0x00/*Serial Flash B1 size- IGNORED in RPC mode*/,
0x00/*Serial Flash B1 size*/,0x00/*Serial Flash B1 size*/,0x00/*Serial Flash B1 size*/,0x00/*Serial Flash B2 size*/,0x00/*Serial Flash B2 size*/,0x00/*Serial Flash B2 size*/,0x00/*Serial Flash B2 size*/,
0x03/*Serial Clock Frequency - 80 MHz*/,0x00/*Serial Clock Frequency*/,0x00/*Serial Clock Frequency*/,0x00/*Serial Clock Frequency*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Reserved*/,
0x00/*Mode of operation- IGNORED in RPC mode*/,0x00/*Serial Flash Port B Selection- IGNORED in RPC mode*/,0x01/*Dual Data Rate mode - Always enabled in RPC mode*/,0x01/*Data Strobe Signal - Always enabled in RPC mode*/,
0x00/*Parallel Mode enable - IGNORED in RPC mode*/,0x00/*CS1 on Port A*/,0x00/*CS1 on Port B*/,0x00/*Full Speed Phase Selection*/,0x00/*Full Speed Delay Selection*/,0x00/*DDR Sampling Point, No need because DQS enabled*/,
/*Flash specific LUT */0xA0,0x47,0x18,0x2B,0x10,0x4F,0x0F,0x0F,0x80,/* 128 bytes*/0x3B,0x00,0x03,/*STOP - 8pads*/0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#else
const uint8_t __attribute__((section (".QSPIFlashConfig"))) config_param[318] = {
0x00/*DQS Config*/,0x00/*DQS Config*/,0x00/*DQS Config*/,0x00/*DQS Config*/,0x00/*Hold Delay*/,0x00/*Half Speed Phase Selection*/,0x00/*Half Speed Delay Selection*/,0x00/*Reserved*/,
0x00/*Serial Clock Configuration*/,0x00/*Serial Clock Configuration*/,0x00/*Serial Clock Configuration*/,0x00/*Serial Clock Configuration*/,0x00/*SoC Configuration*/,0x00/*SoC Configuration*/,0x00/*SoC Configuration*/,
0x00/*SoC Configuration*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Chip Select hold time*/,0x00/*Chip Select hold time*/,0x00/*Chip Select hold time*/,0x00/*Chip Select hold time*/,
0x00/*Chip Select setup time*/,0x00/*Chip Select setup time*/,0x00/*Chip Select setup time*/,0x00/*Chip Select setup time*/,0x00/*Serial Flash A1 size*/,0x00/*Serial Flash A1 size*/,
0x80/*Serial Flash A1 size*/,0x00/*Serial Flash A1 size*/,0x00/*Serial Flash A2 size*/,0x00/*Serial Flash A2 size*/,0x80/*Serial Flash A2 size*/,0x00/*Serial Flash A2 size*/,
0x00/*Serial Flash B1 size*/,0x00/*Serial Flash B1 size*/,0x80/*Serial Flash B1 size*/,0x00/*Serial Flash B1 size*/,0x00/*Serial Flash B2 size*/,0x00/*Serial Flash B2 size*/,0x80/*Serial Flash B2 size*/,
0x00/*Serial Flash B2 size*/,0x00/*Serial Clock Frequency*/,0x00/*Serial Clock Frequency*/,0x00/*Serial Clock Frequency*/,0x00/*Serial Clock Frequency*/,0x00/*Reserved*/,0x00/*Reserved*/,
0x00/*Reserved*/,0x00/*Reserved*/,0x01/*Mode of operation*/,0x00/*Serial Flash Port B Selection*/,0x00/*Dual Data Rate mode*/,0x00/*Data Strobe Signal*/,0x00/*Parallel Mode enable*/,
0x01/*CS1 on Port A*/,0x01/*CS1 on Port B*/,0x00/*Full Speed Phase Selection*/,0x00/*Full Speed Delay Selection*/,0x00/*DDR Sampling Point*/,/*Flash specific LUT */0x03,0x04,0x18,0x08,0x08,0x1c,0x00,0x24,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#endif


/* Unsigned integer types */
extern void __startup(void);

struct BOOT_DATA_T {
    /* Start address of the image */
	const uint32_t start;
    /* Size of the image */
	const uint32_t size;
    /* Plugin Flag */
	const uint32_t plugin;
} const __attribute__((section (".flash_boot_data")))  boot_data = {
	0x20000000,
    0x02000000,
    0x00000000
};

#define HAB_HDR(tag, len, par) {(tag),{(len)>>8, (len)}, (par)}
#define HAB_TAG_DCD  0xd2       /**< Device Configuration Data */
#define HAB_TAG_DCD_VER  0x50       /**< Device Configuration Data version*/
#define DCD_HEADER(x) HAB_HDR(HAB_TAG_DCD,sizeof(x)+sizeof(uint32_t),HAB_TAG_DCD_VER)
#define DCD_WRITE_PAR(bytes, mask,set)        (((bytes) & 0x7) | ((mask)<<3) | ((set)<<4))
#define cpu_be_16(x) ((((x)& 0xFF) << 8) | (((x) & 0xFF00) >> 8))
#define cpu_be_32(x)(((cpu_be_16((x)& 0xFFFF)) << 16) | (cpu_be_16((x) >>16)))
#define HAB_CMD_NOP 0xc0  /**< No Operation */
#define HAB_CMD_WRT_DAT 0xcc  /**< Write Data */
#define HAB_CMD_CHK_DAT 0xcf  /**< Check Data */


struct  hab_ivt {
    /** @ref hdr with tag #HAB_TAG_IVT, length and HAB version fields
     * Tag Length Version
     * Tag: A single byte field set to 0xD1.
	   Length: a two byte field in big endian format containing the overall length of the IVT, in
				bytes, including the header. (The length is fixed and must have a value of 40 bytes)
	   Version: A single byte field set to 0x50
     *  (see @ref data)
     */
	const uint32_t hdr;
    /** Absolute address of the first instruction to execute from the
     *  image
     */
	const uint32_t entry;
    /** Reserved in this version of HAB: should be NULL. */
    const uint32_t reserved1;
    /** Absolute address of the image DCD: may be NULL. */
    const uint32_t dcd;
    /** Absolute address of the Boot Data: may be NULL, but not interpreted
     *  any further by HAB
     */
    const uint32_t boot_data;
    /** Absolute address of the IVT.*/
    const uint32_t self;
    /** Absolute address of the image Secure Callback Image.*/
    const uint32_t secure_callback;
    /** Absolute Address of Self Test Image. */
    const uint32_t self_test;
    /** Authentication Length */
    const uint32_t auth_len;
    /** Reserved in this version of HAB: should be zero. */
    const uint32_t reserved2;
} ;

const uint8_t __attribute__((section (".flash_dcd"))) dcd_param[] = {
0xD2, 0x00, 0x34, 0x50,  // DCD Header
0xCC, 0x00, 0x24, 0x04,  // Write Command
0x40, 0x03, 0xC2, 0x80,  // FXOSC REGISTER
0x01, 0x80, 0x20, 0xF0,  // Enable with full 1x overdrive
0x40, 0x04, 0xA0, 0x2C, // MC_ME_DRUN_MC
0x00, 0x10, 0x00, 0x21, // SYSCLK = FXOSC
0x40, 0x04, 0xA0, 0x04,
0x30, 0x00, 0x5A, 0xF0, // KEY
0x40, 0x04, 0xA0, 0x04,
0x30, 0x00, 0xA5, 0x0F, // INVERTED KEY
// ADD COMMAND TO CHECK FOR COMPLETION - STRICTLY SPEAKING WE NEED THIS
0xCF, 0x00, 0x0C, 0x0C, // POLL FOR BIT CLEAR
0x40, 0x04, 0xA0, 0x00, // Global Status Register (MC_ME_GS)
0x08, 0x00, 0x00, 0x00, // S_MTRANS -- 0 - Mode transition process not active; 1 - Mode transition ongoing
};

struct hab_ivt   __attribute__((section (".flash_app_hdr")))  start_app = {
    0x502800d1, /* hdr */
	0x20010000, /* entry point to startup code (__startup)*/
    0x00000000, /* reserved1 */
	0x20001050, /* dcd */
	0x20001040, /* boot data */
	0x20001000, /* self */
    0x0, /*secure_callback*/
    0x0, /*self test*/
	0x0, /*auth len*/
    0x0, /*resv2*/
};
