/*
 * Copyright (c) 2016 Freescale Semiconductor
 * Copyright 2017 NXP
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of NXP nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * \file    ipuv_mem_map.h
 * \brief   ISP runtime firmware definitions
 * \author
 * \author
 * \version 0.1
 * \date    27-04-2016
 * \note    initial version
 ****************************************************************************/

#ifndef IPUVMEMMAP_H
#define IPUVMEMMAP_H

/*****************************************************************
*
* D_IPUV_SYN Registers
*
******************************************************************/




/* Instance D_IPUV_SYN */

#define D_IPUV_SYN_BASEADDRESS         0x40042000

/* Register definitions */

/* 0 */
#define D_IPUV_SYN_HOST_START_OFF 0x00000000
#define D_IPUV_SYN_HOST_START                (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_HOST_START_OFF))
#define D_IPUV_SYN_X_HOST_START(x)           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_HOST_START_OFF + ((x)*0x0)))

#define D_IPUV_SYN_HOST_START_RESET_VALUE    0x00000000
#define D_IPUV_SYN_HOST_START_VOLATILE       0x0
#define D_IPUV_SYN_HOST_START_BITFIELD_MASK  0x00FF00FF
#define D_IPUV_SYN_HOST_START_RWMASK         0x000000FF
#define D_IPUV_SYN_HOST_START_ROMASK         0x00FF0000
#define D_IPUV_SYN_HOST_START_WOMASK         0x00000000
#define D_IPUV_SYN_HOST_START_UNUSED_MASK    0xFF00FF00

/* 0 */
#define D_IPUV_SYN_HOST_STATUS_OFF 0x00000004
#define D_IPUV_SYN_HOST_STATUS               (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_HOST_STATUS_OFF))
#define D_IPUV_SYN_X_HOST_STATUS(x)          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_HOST_STATUS_OFF + ((x)*0x0)))

#define D_IPUV_SYN_HOST_STATUS_RESET_VALUE   0x00000000
#define D_IPUV_SYN_HOST_STATUS_VOLATILE      0x0
#define D_IPUV_SYN_HOST_STATUS_BITFIELD_MASK 0xFFFF0703
#define D_IPUV_SYN_HOST_STATUS_RWMASK        0x00000003
#define D_IPUV_SYN_HOST_STATUS_ROMASK        0xFFFF0700
#define D_IPUV_SYN_HOST_STATUS_WOMASK        0x00000000
#define D_IPUV_SYN_HOST_STATUS_UNUSED_MASK   0x0000F8FC

/* 0 */
#define D_IPUV_SYN_HOST_POS_OFF 0x00000008
#define D_IPUV_SYN_HOST_POS                  (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_HOST_POS_OFF))
#define D_IPUV_SYN_X_HOST_POS(x)             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_HOST_POS_OFF + ((x)*0x0)))

#define D_IPUV_SYN_HOST_POS_RESET_VALUE      0x00000000
#define D_IPUV_SYN_HOST_POS_VOLATILE         0x0
#define D_IPUV_SYN_HOST_POS_BITFIELD_MASK    0xFFFFFFFF
#define D_IPUV_SYN_HOST_POS_RWMASK           0xFFFFFFFF
#define D_IPUV_SYN_HOST_POS_ROMASK           0x00000000
#define D_IPUV_SYN_HOST_POS_WOMASK           0x00000000
#define D_IPUV_SYN_HOST_POS_UNUSED_MASK      0x00000000

/* 0 */
#define D_IPUV_SYN_HOST_CURRPOS_OFF 0x0000000C
#define D_IPUV_SYN_HOST_CURRPOS              (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_HOST_CURRPOS_OFF))
#define D_IPUV_SYN_X_HOST_CURRPOS(x)         (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_HOST_CURRPOS_OFF + ((x)*0x0)))

#define D_IPUV_SYN_HOST_CURRPOS_RESET_VALUE  0x00000000
#define D_IPUV_SYN_HOST_CURRPOS_VOLATILE     0x0
#define D_IPUV_SYN_HOST_CURRPOS_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_HOST_CURRPOS_RWMASK       0x00000000
#define D_IPUV_SYN_HOST_CURRPOS_ROMASK       0xFFFFFFFF
#define D_IPUV_SYN_HOST_CURRPOS_WOMASK       0x00000000
#define D_IPUV_SYN_HOST_CURRPOS_UNUSED_MASK  0x00000000

/* 0 */
#define D_IPUV_SYN_HOST_XCFG_OFF 0x00000010
#define D_IPUV_SYN_HOST_XCFG                 (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_HOST_XCFG_OFF))
#define D_IPUV_SYN_X_HOST_XCFG(x)            (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_HOST_XCFG_OFF + ((x)*0x0)))

#define D_IPUV_SYN_HOST_XCFG_RESET_VALUE     0x00000000
#define D_IPUV_SYN_HOST_XCFG_VOLATILE        0x0
#define D_IPUV_SYN_HOST_XCFG_BITFIELD_MASK   0xFFFF0003
#define D_IPUV_SYN_HOST_XCFG_RWMASK          0xFFFF0003
#define D_IPUV_SYN_HOST_XCFG_ROMASK          0x00000000
#define D_IPUV_SYN_HOST_XCFG_WOMASK          0x00000000
#define D_IPUV_SYN_HOST_XCFG_UNUSED_MASK     0x0000FFFC

/* 0 */
#define D_IPUV_SYN_HOST_CURRXCFG_OFF 0x00000014
#define D_IPUV_SYN_HOST_CURRXCFG             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_HOST_CURRXCFG_OFF))
#define D_IPUV_SYN_X_HOST_CURRXCFG(x)        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_HOST_CURRXCFG_OFF + ((x)*0x0)))

#define D_IPUV_SYN_HOST_CURRXCFG_RESET_VALUE 0x00000000
#define D_IPUV_SYN_HOST_CURRXCFG_VOLATILE    0x0
#define D_IPUV_SYN_HOST_CURRXCFG_BITFIELD_MASK 0xFFFF0003
#define D_IPUV_SYN_HOST_CURRXCFG_RWMASK      0x00000000
#define D_IPUV_SYN_HOST_CURRXCFG_ROMASK      0xFFFF0003
#define D_IPUV_SYN_HOST_CURRXCFG_WOMASK      0x00000000
#define D_IPUV_SYN_HOST_CURRXCFG_UNUSED_MASK 0x0000FFFC

/* 0 */
#define D_IPUV_SYN_HOST_INACFG_OFF 0x00000018
#define D_IPUV_SYN_HOST_INACFG               (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_HOST_INACFG_OFF))
#define D_IPUV_SYN_X_HOST_INACFG(x)          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_HOST_INACFG_OFF + ((x)*0x0)))

#define D_IPUV_SYN_HOST_INACFG_RESET_VALUE   0x00010001
#define D_IPUV_SYN_HOST_INACFG_VOLATILE      0x0
#define D_IPUV_SYN_HOST_INACFG_BITFIELD_MASK 0x1F071F07
#define D_IPUV_SYN_HOST_INACFG_RWMASK        0x00001F07
#define D_IPUV_SYN_HOST_INACFG_ROMASK        0x1F070000
#define D_IPUV_SYN_HOST_INACFG_WOMASK        0x00000000
#define D_IPUV_SYN_HOST_INACFG_UNUSED_MASK   0xE0F8E0F8

/* 0 */
#define D_IPUV_SYN_HOST_OUTCFG_OFF 0x00000024
#define D_IPUV_SYN_HOST_OUTCFG               (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_HOST_OUTCFG_OFF))
#define D_IPUV_SYN_X_HOST_OUTCFG(x)          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_HOST_OUTCFG_OFF + ((x)*0x0)))

#define D_IPUV_SYN_HOST_OUTCFG_RESET_VALUE   0x00010001
#define D_IPUV_SYN_HOST_OUTCFG_VOLATILE      0x0
#define D_IPUV_SYN_HOST_OUTCFG_BITFIELD_MASK 0x07030703
#define D_IPUV_SYN_HOST_OUTCFG_RWMASK        0x00000703
#define D_IPUV_SYN_HOST_OUTCFG_ROMASK        0x07030000
#define D_IPUV_SYN_HOST_OUTCFG_WOMASK        0x00000000
#define D_IPUV_SYN_HOST_OUTCFG_UNUSED_MASK   0xF8FCF8FC

/* 0 */
#define D_IPUV_SYN_HOST_IMEMA_OFF 0x00000040
#define D_IPUV_SYN_HOST_IMEMA                (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_HOST_IMEMA_OFF))
#define D_IPUV_SYN_X_HOST_IMEMA(x)           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_HOST_IMEMA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_HOST_IMEMA_RESET_VALUE    0x00000000
#define D_IPUV_SYN_HOST_IMEMA_VOLATILE       0x0
#define D_IPUV_SYN_HOST_IMEMA_BITFIELD_MASK  0x0000003F
#define D_IPUV_SYN_HOST_IMEMA_RWMASK         0x0000003F
#define D_IPUV_SYN_HOST_IMEMA_ROMASK         0x00000000
#define D_IPUV_SYN_HOST_IMEMA_WOMASK         0x00000000
#define D_IPUV_SYN_HOST_IMEMA_UNUSED_MASK    0xFFFFFFC0

/* 0 */
#define D_IPUV_SYN_HOST_IMEMD_OFF 0x00000044
#define D_IPUV_SYN_HOST_IMEMD                (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_HOST_IMEMD_OFF))
#define D_IPUV_SYN_X_HOST_IMEMD(x)           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_HOST_IMEMD_OFF + ((x)*0x0)))

#define D_IPUV_SYN_HOST_IMEMD_RESET_VALUE    0x00000000
#define D_IPUV_SYN_HOST_IMEMD_VOLATILE       0x0
#define D_IPUV_SYN_HOST_IMEMD_BITFIELD_MASK  0xFFFFFFFF
#define D_IPUV_SYN_HOST_IMEMD_RWMASK         0xFFFFFFFF
#define D_IPUV_SYN_HOST_IMEMD_ROMASK         0x00000000
#define D_IPUV_SYN_HOST_IMEMD_WOMASK         0x00000000
#define D_IPUV_SYN_HOST_IMEMD_UNUSED_MASK    0x00000000

/* 0 */
#define D_IPUV_SYN_HOST_DREGA_OFF 0x00000048
#define D_IPUV_SYN_HOST_DREGA                (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_HOST_DREGA_OFF))
#define D_IPUV_SYN_X_HOST_DREGA(x)           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_HOST_DREGA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_HOST_DREGA_RESET_VALUE    0x00000000
#define D_IPUV_SYN_HOST_DREGA_VOLATILE       0x0
#define D_IPUV_SYN_HOST_DREGA_BITFIELD_MASK  0x000000FF
#define D_IPUV_SYN_HOST_DREGA_RWMASK         0x000000FF
#define D_IPUV_SYN_HOST_DREGA_ROMASK         0x00000000
#define D_IPUV_SYN_HOST_DREGA_WOMASK         0x00000000
#define D_IPUV_SYN_HOST_DREGA_UNUSED_MASK    0xFFFFFF00

/* 0 */
#define D_IPUV_SYN_HOST_DREGD_OFF 0x0000004C
#define D_IPUV_SYN_HOST_DREGD                (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_HOST_DREGD_OFF))
#define D_IPUV_SYN_X_HOST_DREGD(x)           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_HOST_DREGD_OFF + ((x)*0x0)))

#define D_IPUV_SYN_HOST_DREGD_RESET_VALUE    0x00000000
#define D_IPUV_SYN_HOST_DREGD_VOLATILE       0x0
#define D_IPUV_SYN_HOST_DREGD_BITFIELD_MASK  0x0000FFFF
#define D_IPUV_SYN_HOST_DREGD_RWMASK         0x0000FFFF
#define D_IPUV_SYN_HOST_DREGD_ROMASK         0x00000000
#define D_IPUV_SYN_HOST_DREGD_WOMASK         0x00000000
#define D_IPUV_SYN_HOST_DREGD_UNUSED_MASK    0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_LINE0_LEN_INA_OFF 0x00000104
#define D_IPUV_SYN_S_LINE0_LEN_INA           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE0_LEN_INA_OFF))
#define D_IPUV_SYN_X_S_LINE0_LEN_INA(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE0_LEN_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE0_LEN_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE0_LEN_INA_VOLATILE  0x0
#define D_IPUV_SYN_S_LINE0_LEN_INA_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_LINE0_LEN_INA_RWMASK    0x0000FFFF
#define D_IPUV_SYN_S_LINE0_LEN_INA_ROMASK    0x00000000
#define D_IPUV_SYN_S_LINE0_LEN_INA_WOMASK    0x00000000
#define D_IPUV_SYN_S_LINE0_LEN_INA_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_LINE1_LEN_INA_OFF 0x00000110
#define D_IPUV_SYN_S_LINE1_LEN_INA           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE1_LEN_INA_OFF))
#define D_IPUV_SYN_X_S_LINE1_LEN_INA(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE1_LEN_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE1_LEN_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE1_LEN_INA_VOLATILE  0x0
#define D_IPUV_SYN_S_LINE1_LEN_INA_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_LINE1_LEN_INA_RWMASK    0x0000FFFF
#define D_IPUV_SYN_S_LINE1_LEN_INA_ROMASK    0x00000000
#define D_IPUV_SYN_S_LINE1_LEN_INA_WOMASK    0x00000000
#define D_IPUV_SYN_S_LINE1_LEN_INA_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_LINE2_LEN_INA_OFF 0x0000011C
#define D_IPUV_SYN_S_LINE2_LEN_INA           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE2_LEN_INA_OFF))
#define D_IPUV_SYN_X_S_LINE2_LEN_INA(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE2_LEN_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE2_LEN_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE2_LEN_INA_VOLATILE  0x0
#define D_IPUV_SYN_S_LINE2_LEN_INA_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_LINE2_LEN_INA_RWMASK    0x0000FFFF
#define D_IPUV_SYN_S_LINE2_LEN_INA_ROMASK    0x00000000
#define D_IPUV_SYN_S_LINE2_LEN_INA_WOMASK    0x00000000
#define D_IPUV_SYN_S_LINE2_LEN_INA_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_LINE3_LEN_INA_OFF 0x00000144
#define D_IPUV_SYN_S_LINE3_LEN_INA           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE3_LEN_INA_OFF))
#define D_IPUV_SYN_X_S_LINE3_LEN_INA(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE3_LEN_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE3_LEN_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE3_LEN_INA_VOLATILE  0x0
#define D_IPUV_SYN_S_LINE3_LEN_INA_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_LINE3_LEN_INA_RWMASK    0x0000FFFF
#define D_IPUV_SYN_S_LINE3_LEN_INA_ROMASK    0x00000000
#define D_IPUV_SYN_S_LINE3_LEN_INA_WOMASK    0x00000000
#define D_IPUV_SYN_S_LINE3_LEN_INA_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_LINE4_LEN_INA_OFF 0x00000150
#define D_IPUV_SYN_S_LINE4_LEN_INA           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE4_LEN_INA_OFF))
#define D_IPUV_SYN_X_S_LINE4_LEN_INA(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE4_LEN_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE4_LEN_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE4_LEN_INA_VOLATILE  0x0
#define D_IPUV_SYN_S_LINE4_LEN_INA_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_LINE4_LEN_INA_RWMASK    0x0000FFFF
#define D_IPUV_SYN_S_LINE4_LEN_INA_ROMASK    0x00000000
#define D_IPUV_SYN_S_LINE4_LEN_INA_WOMASK    0x00000000
#define D_IPUV_SYN_S_LINE4_LEN_INA_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_CH0_CFG_INA_OFF 0x00000108
#define D_IPUV_SYN_S_CH0_CFG_INA             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CH0_CFG_INA_OFF))
#define D_IPUV_SYN_X_S_CH0_CFG_INA(x)        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CH0_CFG_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CH0_CFG_INA_RESET_VALUE 0x00050000
#define D_IPUV_SYN_S_CH0_CFG_INA_VOLATILE    0x0
#define D_IPUV_SYN_S_CH0_CFG_INA_BITFIELD_MASK 0x37FFFFFF
#define D_IPUV_SYN_S_CH0_CFG_INA_RWMASK      0x37FFFFFF
#define D_IPUV_SYN_S_CH0_CFG_INA_ROMASK      0x00000000
#define D_IPUV_SYN_S_CH0_CFG_INA_WOMASK      0x00000000
#define D_IPUV_SYN_S_CH0_CFG_INA_UNUSED_MASK 0xC8000000

/* 0 */
#define D_IPUV_SYN_S_CH1_CFG_INA_OFF 0x00000114
#define D_IPUV_SYN_S_CH1_CFG_INA             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CH1_CFG_INA_OFF))
#define D_IPUV_SYN_X_S_CH1_CFG_INA(x)        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CH1_CFG_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CH1_CFG_INA_RESET_VALUE 0x00050000
#define D_IPUV_SYN_S_CH1_CFG_INA_VOLATILE    0x0
#define D_IPUV_SYN_S_CH1_CFG_INA_BITFIELD_MASK 0x37FFFFFF
#define D_IPUV_SYN_S_CH1_CFG_INA_RWMASK      0x37FFFFFF
#define D_IPUV_SYN_S_CH1_CFG_INA_ROMASK      0x00000000
#define D_IPUV_SYN_S_CH1_CFG_INA_WOMASK      0x00000000
#define D_IPUV_SYN_S_CH1_CFG_INA_UNUSED_MASK 0xC8000000

/* 0 */
#define D_IPUV_SYN_S_CH2_CFG_INA_OFF 0x00000120
#define D_IPUV_SYN_S_CH2_CFG_INA             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CH2_CFG_INA_OFF))
#define D_IPUV_SYN_X_S_CH2_CFG_INA(x)        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CH2_CFG_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CH2_CFG_INA_RESET_VALUE 0x00050000
#define D_IPUV_SYN_S_CH2_CFG_INA_VOLATILE    0x0
#define D_IPUV_SYN_S_CH2_CFG_INA_BITFIELD_MASK 0x37FFFFFF
#define D_IPUV_SYN_S_CH2_CFG_INA_RWMASK      0x37FFFFFF
#define D_IPUV_SYN_S_CH2_CFG_INA_ROMASK      0x00000000
#define D_IPUV_SYN_S_CH2_CFG_INA_WOMASK      0x00000000
#define D_IPUV_SYN_S_CH2_CFG_INA_UNUSED_MASK 0xC8000000

/* 0 */
#define D_IPUV_SYN_S_CH3_CFG_INA_OFF 0x00000148
#define D_IPUV_SYN_S_CH3_CFG_INA             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CH3_CFG_INA_OFF))
#define D_IPUV_SYN_X_S_CH3_CFG_INA(x)        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CH3_CFG_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CH3_CFG_INA_RESET_VALUE 0x00050000
#define D_IPUV_SYN_S_CH3_CFG_INA_VOLATILE    0x0
#define D_IPUV_SYN_S_CH3_CFG_INA_BITFIELD_MASK 0x37FFFFFF
#define D_IPUV_SYN_S_CH3_CFG_INA_RWMASK      0x37FFFFFF
#define D_IPUV_SYN_S_CH3_CFG_INA_ROMASK      0x00000000
#define D_IPUV_SYN_S_CH3_CFG_INA_WOMASK      0x00000000
#define D_IPUV_SYN_S_CH3_CFG_INA_UNUSED_MASK 0xC8000000

/* 0 */
#define D_IPUV_SYN_S_CH4_CFG_INA_OFF 0x00000154
#define D_IPUV_SYN_S_CH4_CFG_INA             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CH4_CFG_INA_OFF))
#define D_IPUV_SYN_X_S_CH4_CFG_INA(x)        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CH4_CFG_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CH4_CFG_INA_RESET_VALUE 0x00050000
#define D_IPUV_SYN_S_CH4_CFG_INA_VOLATILE    0x0
#define D_IPUV_SYN_S_CH4_CFG_INA_BITFIELD_MASK 0x37FFFFFF
#define D_IPUV_SYN_S_CH4_CFG_INA_RWMASK      0x37FFFFFF
#define D_IPUV_SYN_S_CH4_CFG_INA_ROMASK      0x00000000
#define D_IPUV_SYN_S_CH4_CFG_INA_WOMASK      0x00000000
#define D_IPUV_SYN_S_CH4_CFG_INA_UNUSED_MASK 0xC8000000

/* 0 */
#define D_IPUV_SYN_S_LINE0_ADDR_INA_OFF 0x0000010C
#define D_IPUV_SYN_S_LINE0_ADDR_INA          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE0_ADDR_INA_OFF))
#define D_IPUV_SYN_X_S_LINE0_ADDR_INA(x)     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE0_ADDR_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE0_ADDR_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE0_ADDR_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_LINE0_ADDR_INA_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_LINE0_ADDR_INA_RWMASK   0xFFFFFFFF
#define D_IPUV_SYN_S_LINE0_ADDR_INA_ROMASK   0x00000000
#define D_IPUV_SYN_S_LINE0_ADDR_INA_WOMASK   0x00000000
#define D_IPUV_SYN_S_LINE0_ADDR_INA_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_S_LINE1_ADDR_INA_OFF 0x00000118
#define D_IPUV_SYN_S_LINE1_ADDR_INA          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE1_ADDR_INA_OFF))
#define D_IPUV_SYN_X_S_LINE1_ADDR_INA(x)     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE1_ADDR_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE1_ADDR_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE1_ADDR_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_LINE1_ADDR_INA_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_LINE1_ADDR_INA_RWMASK   0xFFFFFFFF
#define D_IPUV_SYN_S_LINE1_ADDR_INA_ROMASK   0x00000000
#define D_IPUV_SYN_S_LINE1_ADDR_INA_WOMASK   0x00000000
#define D_IPUV_SYN_S_LINE1_ADDR_INA_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_S_LINE2_ADDR_INA_OFF 0x00000124
#define D_IPUV_SYN_S_LINE2_ADDR_INA          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE2_ADDR_INA_OFF))
#define D_IPUV_SYN_X_S_LINE2_ADDR_INA(x)     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE2_ADDR_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE2_ADDR_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE2_ADDR_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_LINE2_ADDR_INA_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_LINE2_ADDR_INA_RWMASK   0xFFFFFFFF
#define D_IPUV_SYN_S_LINE2_ADDR_INA_ROMASK   0x00000000
#define D_IPUV_SYN_S_LINE2_ADDR_INA_WOMASK   0x00000000
#define D_IPUV_SYN_S_LINE2_ADDR_INA_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_S_LINE3_ADDR_INA_OFF 0x0000014C
#define D_IPUV_SYN_S_LINE3_ADDR_INA          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE3_ADDR_INA_OFF))
#define D_IPUV_SYN_X_S_LINE3_ADDR_INA(x)     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE3_ADDR_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE3_ADDR_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE3_ADDR_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_LINE3_ADDR_INA_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_LINE3_ADDR_INA_RWMASK   0xFFFFFFFF
#define D_IPUV_SYN_S_LINE3_ADDR_INA_ROMASK   0x00000000
#define D_IPUV_SYN_S_LINE3_ADDR_INA_WOMASK   0x00000000
#define D_IPUV_SYN_S_LINE3_ADDR_INA_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_S_LINE4_ADDR_INA_OFF 0x00000158
#define D_IPUV_SYN_S_LINE4_ADDR_INA          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE4_ADDR_INA_OFF))
#define D_IPUV_SYN_X_S_LINE4_ADDR_INA(x)     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE4_ADDR_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE4_ADDR_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE4_ADDR_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_LINE4_ADDR_INA_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_LINE4_ADDR_INA_RWMASK   0xFFFFFFFF
#define D_IPUV_SYN_S_LINE4_ADDR_INA_ROMASK   0x00000000
#define D_IPUV_SYN_S_LINE4_ADDR_INA_WOMASK   0x00000000
#define D_IPUV_SYN_S_LINE4_ADDR_INA_UNUSED_MASK 0x00000000

/*To be compatible with backward version*/
/* 0 */
#define D_IPUV_SYN_S_LINE0_LEN_INB_OFF 0x00000144
#define D_IPUV_SYN_S_LINE0_LEN_INB           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE0_LEN_INB_OFF))
#define D_IPUV_SYN_X_S_LINE0_LEN_INB(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE0_LEN_INB_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE0_LEN_INB_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE0_LEN_INB_VOLATILE  0x0
#define D_IPUV_SYN_S_LINE0_LEN_INB_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_LINE0_LEN_INB_RWMASK    0x0000FFFF
#define D_IPUV_SYN_S_LINE0_LEN_INB_ROMASK    0x00000000
#define D_IPUV_SYN_S_LINE0_LEN_INB_WOMASK    0x00000000
#define D_IPUV_SYN_S_LINE0_LEN_INB_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_LINE1_LEN_INB_OFF 0x00000150
#define D_IPUV_SYN_S_LINE1_LEN_INB           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE1_LEN_INB_OFF))
#define D_IPUV_SYN_X_S_LINE1_LEN_INB(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE1_LEN_INB_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE1_LEN_INB_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE1_LEN_INB_VOLATILE  0x0
#define D_IPUV_SYN_S_LINE1_LEN_INB_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_LINE1_LEN_INB_RWMASK    0x0000FFFF
#define D_IPUV_SYN_S_LINE1_LEN_INB_ROMASK    0x00000000
#define D_IPUV_SYN_S_LINE1_LEN_INB_WOMASK    0x00000000
#define D_IPUV_SYN_S_LINE1_LEN_INB_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_CH0_CFG_INB_OFF 0x00000148
#define D_IPUV_SYN_S_CH0_CFG_INB             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CH0_CFG_INB_OFF))
#define D_IPUV_SYN_X_S_CH0_CFG_INB(x)        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CH0_CFG_INB_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CH0_CFG_INB_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CH0_CFG_INB_VOLATILE    0x0
#define D_IPUV_SYN_S_CH0_CFG_INB_BITFIELD_MASK 0x37FFFFFF
#define D_IPUV_SYN_S_CH0_CFG_INB_RWMASK      0x37FFFFFF
#define D_IPUV_SYN_S_CH0_CFG_INB_ROMASK      0x00000000
#define D_IPUV_SYN_S_CH0_CFG_INB_WOMASK      0x00000000
#define D_IPUV_SYN_S_CH0_CFG_INB_UNUSED_MASK 0xC8000000

/* 0 */
#define D_IPUV_SYN_S_CH1_CFG_INB_OFF 0x00000154
#define D_IPUV_SYN_S_CH1_CFG_INB             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CH1_CFG_INB_OFF))
#define D_IPUV_SYN_X_S_CH1_CFG_INB(x)        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CH1_CFG_INB_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CH1_CFG_INB_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CH1_CFG_INB_VOLATILE    0x0
#define D_IPUV_SYN_S_CH1_CFG_INB_BITFIELD_MASK 0x37FFFFFF
#define D_IPUV_SYN_S_CH1_CFG_INB_RWMASK      0x37FFFFFF
#define D_IPUV_SYN_S_CH1_CFG_INB_ROMASK      0x00000000
#define D_IPUV_SYN_S_CH1_CFG_INB_WOMASK      0x00000000
#define D_IPUV_SYN_S_CH1_CFG_INB_UNUSED_MASK 0xC8000000

/* 1 */
#define D_IPUV_SYN_S_LINE0_ADDR_INB_OFF 0x0000014C
#define D_IPUV_SYN_S_LINE0_ADDR_INB          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE0_ADDR_INB_OFF))
#define D_IPUV_SYN_X_S_LINE0_ADDR_INB(x)     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE0_ADDR_INB_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE0_ADDR_INB_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE0_ADDR_INB_VOLATILE 0x0
#define D_IPUV_SYN_S_LINE0_ADDR_INB_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_LINE0_ADDR_INB_RWMASK   0xFFFFFFFF
#define D_IPUV_SYN_S_LINE0_ADDR_INB_ROMASK   0x00000000
#define D_IPUV_SYN_S_LINE0_ADDR_INB_WOMASK   0x00000000
#define D_IPUV_SYN_S_LINE0_ADDR_INB_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_S_LINE1_ADDR_INB_OFF 0x00000158
#define D_IPUV_SYN_S_LINE1_ADDR_INB          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE1_ADDR_INB_OFF))
#define D_IPUV_SYN_X_S_LINE1_ADDR_INB(x)     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE1_ADDR_INB_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE1_ADDR_INB_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE1_ADDR_INB_VOLATILE 0x0
#define D_IPUV_SYN_S_LINE1_ADDR_INB_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_LINE1_ADDR_INB_RWMASK   0xFFFFFFFF
#define D_IPUV_SYN_S_LINE1_ADDR_INB_ROMASK   0x00000000
#define D_IPUV_SYN_S_LINE1_ADDR_INB_WOMASK   0x00000000
#define D_IPUV_SYN_S_LINE1_ADDR_INB_UNUSED_MASK 0x00000000
/******************End******************************/

/* 0 */
#define D_IPUV_SYN_S_LINE0_LEN_OUT_OFF 0x000001C4
#define D_IPUV_SYN_S_LINE0_LEN_OUT           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE0_LEN_OUT_OFF))
#define D_IPUV_SYN_X_S_LINE0_LEN_OUT(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE0_LEN_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE0_LEN_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE0_LEN_OUT_VOLATILE  0x0
#define D_IPUV_SYN_S_LINE0_LEN_OUT_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_LINE0_LEN_OUT_RWMASK    0x0000FFFF
#define D_IPUV_SYN_S_LINE0_LEN_OUT_ROMASK    0x00000000
#define D_IPUV_SYN_S_LINE0_LEN_OUT_WOMASK    0x00000000
#define D_IPUV_SYN_S_LINE0_LEN_OUT_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_LINE1_LEN_OUT_OFF 0x000001D0
#define D_IPUV_SYN_S_LINE1_LEN_OUT           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE1_LEN_OUT_OFF))
#define D_IPUV_SYN_X_S_LINE1_LEN_OUT(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE1_LEN_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE1_LEN_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE1_LEN_OUT_VOLATILE  0x0
#define D_IPUV_SYN_S_LINE1_LEN_OUT_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_LINE1_LEN_OUT_RWMASK    0x0000FFFF
#define D_IPUV_SYN_S_LINE1_LEN_OUT_ROMASK    0x00000000
#define D_IPUV_SYN_S_LINE1_LEN_OUT_WOMASK    0x00000000
#define D_IPUV_SYN_S_LINE1_LEN_OUT_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_LINE2_LEN_OUT_OFF 0x000001DC
#define D_IPUV_SYN_S_LINE2_LEN_OUT           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE2_LEN_OUT_OFF))
#define D_IPUV_SYN_X_S_LINE2_LEN_OUT(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE2_LEN_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE2_LEN_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE2_LEN_OUT_VOLATILE  0x0
#define D_IPUV_SYN_S_LINE2_LEN_OUT_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_LINE2_LEN_OUT_RWMASK    0x0000FFFF
#define D_IPUV_SYN_S_LINE2_LEN_OUT_ROMASK    0x00000000
#define D_IPUV_SYN_S_LINE2_LEN_OUT_WOMASK    0x00000000
#define D_IPUV_SYN_S_LINE2_LEN_OUT_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_CH0_CFG_OUT_OFF 0x000001C8
#define D_IPUV_SYN_S_CH0_CFG_OUT             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CH0_CFG_OUT_OFF))
#define D_IPUV_SYN_X_S_CH0_CFG_OUT(x)        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CH0_CFG_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CH0_CFG_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CH0_CFG_OUT_VOLATILE    0x0
#define D_IPUV_SYN_S_CH0_CFG_OUT_BITFIELD_MASK 0x30030000
#define D_IPUV_SYN_S_CH0_CFG_OUT_RWMASK      0x30030000
#define D_IPUV_SYN_S_CH0_CFG_OUT_ROMASK      0x00000000
#define D_IPUV_SYN_S_CH0_CFG_OUT_WOMASK      0x00000000
#define D_IPUV_SYN_S_CH0_CFG_OUT_UNUSED_MASK 0xCFFCFFFF

/* 0 */
#define D_IPUV_SYN_S_CH1_CFG_OUT_OFF 0x000001D4
#define D_IPUV_SYN_S_CH1_CFG_OUT             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CH1_CFG_OUT_OFF))
#define D_IPUV_SYN_X_S_CH1_CFG_OUT(x)        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CH1_CFG_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CH1_CFG_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CH1_CFG_OUT_VOLATILE    0x0
#define D_IPUV_SYN_S_CH1_CFG_OUT_BITFIELD_MASK 0x30030000
#define D_IPUV_SYN_S_CH1_CFG_OUT_RWMASK      0x30030000
#define D_IPUV_SYN_S_CH1_CFG_OUT_ROMASK      0x00000000
#define D_IPUV_SYN_S_CH1_CFG_OUT_WOMASK      0x00000000
#define D_IPUV_SYN_S_CH1_CFG_OUT_UNUSED_MASK 0xCFFCFFFF

/* 0 */
#define D_IPUV_SYN_S_CH2_CFG_OUT_OFF 0x000001E0
#define D_IPUV_SYN_S_CH2_CFG_OUT             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CH2_CFG_OUT_OFF))
#define D_IPUV_SYN_X_S_CH2_CFG_OUT(x)        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CH2_CFG_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CH2_CFG_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CH2_CFG_OUT_VOLATILE    0x0
#define D_IPUV_SYN_S_CH2_CFG_OUT_BITFIELD_MASK 0x30030000
#define D_IPUV_SYN_S_CH2_CFG_OUT_RWMASK      0x30030000
#define D_IPUV_SYN_S_CH2_CFG_OUT_ROMASK      0x00000000
#define D_IPUV_SYN_S_CH2_CFG_OUT_WOMASK      0x00000000
#define D_IPUV_SYN_S_CH2_CFG_OUT_UNUSED_MASK 0xCFFCFFFF

/* 0 */
#define D_IPUV_SYN_S_LINE0_ADDR_OUT_OFF 0x000001CC
#define D_IPUV_SYN_S_LINE0_ADDR_OUT          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE0_ADDR_OUT_OFF))
#define D_IPUV_SYN_X_S_LINE0_ADDR_OUT(x)     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE0_ADDR_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE0_ADDR_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE0_ADDR_OUT_VOLATILE 0x0
#define D_IPUV_SYN_S_LINE0_ADDR_OUT_BITFIELD_MASK 0xFFFFFFF8
#define D_IPUV_SYN_S_LINE0_ADDR_OUT_RWMASK   0xFFFFFFF8
#define D_IPUV_SYN_S_LINE0_ADDR_OUT_ROMASK   0x00000000
#define D_IPUV_SYN_S_LINE0_ADDR_OUT_WOMASK   0x00000000
#define D_IPUV_SYN_S_LINE0_ADDR_OUT_UNUSED_MASK 0x00000007

/* 0 */
#define D_IPUV_SYN_S_LINE1_ADDR_OUT_OFF 0x000001D8
#define D_IPUV_SYN_S_LINE1_ADDR_OUT          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE1_ADDR_OUT_OFF))
#define D_IPUV_SYN_X_S_LINE1_ADDR_OUT(x)     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE1_ADDR_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE1_ADDR_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE1_ADDR_OUT_VOLATILE 0x0
#define D_IPUV_SYN_S_LINE1_ADDR_OUT_BITFIELD_MASK 0xFFFFFFF8
#define D_IPUV_SYN_S_LINE1_ADDR_OUT_RWMASK   0xFFFFFFF8
#define D_IPUV_SYN_S_LINE1_ADDR_OUT_ROMASK   0x00000000
#define D_IPUV_SYN_S_LINE1_ADDR_OUT_WOMASK   0x00000000
#define D_IPUV_SYN_S_LINE1_ADDR_OUT_UNUSED_MASK 0x00000007

/* 0 */
#define D_IPUV_SYN_S_LINE2_ADDR_OUT_OFF 0x000001E4
#define D_IPUV_SYN_S_LINE2_ADDR_OUT          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_LINE2_ADDR_OUT_OFF))
#define D_IPUV_SYN_X_S_LINE2_ADDR_OUT(x)     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_LINE2_ADDR_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_LINE2_ADDR_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_LINE2_ADDR_OUT_VOLATILE 0x0
#define D_IPUV_SYN_S_LINE2_ADDR_OUT_BITFIELD_MASK 0xFFFFFFF8
#define D_IPUV_SYN_S_LINE2_ADDR_OUT_RWMASK   0xFFFFFFF8
#define D_IPUV_SYN_S_LINE2_ADDR_OUT_ROMASK   0x00000000
#define D_IPUV_SYN_S_LINE2_ADDR_OUT_WOMASK   0x00000000
#define D_IPUV_SYN_S_LINE2_ADDR_OUT_UNUSED_MASK 0x00000007

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_OFF 0x00000204
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE0_LEN_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE0_LEN_INA(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE0_LEN_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_ROMASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_OFF 0x00000208
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_CH0_CFG_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_CH0_CFG_INA(x)   (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_CH0_CFG_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_BITFIELD_MASK 0xF7FFFFFF
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_ROMASK 0xF7FFFFFF
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_UNUSED_MASK 0x08000000

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_OFF 0x0000020C
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE0_ADDR_INA(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_ROMASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA_OFF 0x00000210
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE1_LEN_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE1_LEN_INA(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE1_LEN_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA_ROMASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_OFF 0x00000214
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_CH1_CFG_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_CH1_CFG_INA(x)   (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_CH1_CFG_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_BITFIELD_MASK 0x37FFFFFF
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_ROMASK 0x37FFFFFF
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_UNUSED_MASK 0xC8000000

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_OFF 0x00000218
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE1_ADDR_INA(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_ROMASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA_OFF 0x0000021C
#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE2_LEN_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE2_LEN_INA(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE2_LEN_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA_ROMASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_OFF 0x00000220
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_CH2_CFG_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_CH2_CFG_INA(x)   (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_CH2_CFG_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_BITFIELD_MASK 0x3F7FFFFF
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_ROMASK 0x3F7FFFFF
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_UNUSED_MASK 0xC0800000

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_OFF 0x00000224
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE2_ADDR_INA(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_ROMASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA_OFF 0x00000244
#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE3_LEN_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE3_LEN_INA(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE3_LEN_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA_ROMASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_OFF 0x00000248
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_CH3_CFG_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_CH3_CFG_INA(x)   (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_CH3_CFG_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_BITFIELD_MASK 0x3F7FFFFF
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_ROMASK 0x3F7FFFFF
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_UNUSED_MASK 0xC0800000

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_OFF 0x0000024C
#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE3_ADDR_INA(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_ROMASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA_OFF 0x00000250
#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE4_LEN_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE4_LEN_INA(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE4_LEN_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA_ROMASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_OFF 0x00000254
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_CH4_CFG_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_CH4_CFG_INA(x)   (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_CH4_CFG_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_BITFIELD_MASK 0x3F7FFFFF
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_ROMASK 0x3F7FFFFF
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_UNUSED_MASK 0xC0800000

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_OFF 0x00000258
#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE4_ADDR_INA(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_ROMASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_UNUSED_MASK 0x00000000

/*To be compatible with backward version*/
/* 0 */
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB_OFF 0x00000244
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE0_LEN_INB_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE0_LEN_INB(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE0_LEN_INB_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB_ROMASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_OFF 0x00000248
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_CH0_CFG_INB_OFF))
#define D_IPUV_SYN_X_S_CURR_CH0_CFG_INB(x)   (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_CH0_CFG_INB_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_BITFIELD_MASK 0x377FFFFF
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_ROMASK 0x377FFFFF
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_UNUSED_MASK 0xC8800000

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_OFF 0x0000024C
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE0_ADDR_INB(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_ROMASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB_OFF 0x00000250
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE1_LEN_INB_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE1_LEN_INB(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE1_LEN_INB_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB_ROMASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_OFF 0x00000254
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_CH1_CFG_INB_OFF))
#define D_IPUV_SYN_X_S_CURR_CH1_CFG_INB(x)   (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_CH1_CFG_INB_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_BITFIELD_MASK 0xF77FFFFF
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_ROMASK 0xF77FFFFF
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_UNUSED_MASK 0x08800000

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_OFF 0x00000258
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE1_ADDR_INB(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_ROMASK 0xFFFFFFFF
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_UNUSED_MASK 0x00000000
/******************End******************************/

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_OFF 0x000002C4
#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE0_LEN_OUT(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_ROMASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_OFF 0x000002C8
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_CH0_CFG_OUT_OFF))
#define D_IPUV_SYN_X_S_CURR_CH0_CFG_OUT(x)   (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_CH0_CFG_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_BITFIELD_MASK 0x30030000
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_ROMASK 0x30030000
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_UNUSED_MASK 0xCFFCFFFF

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_OFF 0x000002CC
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE0_ADDR_OUT(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_BITFIELD_MASK 0xFFFFFFF8
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_ROMASK 0xFFFFFFF8
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_UNUSED_MASK 0x00000007

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_OFF 0x000002D0
#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE1_LEN_OUT(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_ROMASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_OFF 0x000002D4
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_CH1_CFG_OUT_OFF))
#define D_IPUV_SYN_X_S_CURR_CH1_CFG_OUT(x)   (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_CH1_CFG_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_BITFIELD_MASK 0x30030000
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_ROMASK 0x30030000
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_UNUSED_MASK 0xCFFCFFFF

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_OFF 0x000002D8
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE1_ADDR_OUT(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_BITFIELD_MASK 0xFFFFFFF8
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_ROMASK 0xFFFFFFF8
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_UNUSED_MASK 0x00000007

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_OFF 0x000002DC
#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE2_LEN_OUT(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_BITFIELD_MASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_ROMASK 0x0000FFFF
#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_UNUSED_MASK 0xFFFF0000

/* 0 */
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_OFF 0x000002E0
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_CH2_CFG_OUT_OFF))
#define D_IPUV_SYN_X_S_CURR_CH2_CFG_OUT(x)   (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_CH2_CFG_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_BITFIELD_MASK 0x30030000
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_ROMASK 0x30030000
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_UNUSED_MASK 0xCFFCFFFF

/* 0 */
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_OFF 0x000002E4
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_OFF))
#define D_IPUV_SYN_X_S_CURR_LINE2_ADDR_OUT(x) (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_VOLATILE 0x0
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_BITFIELD_MASK 0xFFFFFFF8
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_RWMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_ROMASK 0xFFFFFFF8
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_WOMASK 0x00000000
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_UNUSED_MASK 0x00000007

/* 0 */
#define D_IPUV_SYN_DEBUG_MS_OFF 0x00000400
#define D_IPUV_SYN_DEBUG_MS                  (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_DEBUG_MS_OFF))
#define D_IPUV_SYN_X_DEBUG_MS(x)             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_DEBUG_MS_OFF + ((x)*0x0)))

#define D_IPUV_SYN_DEBUG_MS_RESET_VALUE      0x00000000
#define D_IPUV_SYN_DEBUG_MS_VOLATILE         0x0
#define D_IPUV_SYN_DEBUG_MS_BITFIELD_MASK    0xFE0F0001
#define D_IPUV_SYN_DEBUG_MS_RWMASK           0xFE0F0001
#define D_IPUV_SYN_DEBUG_MS_ROMASK           0x00000000
#define D_IPUV_SYN_DEBUG_MS_WOMASK           0x00000000
#define D_IPUV_SYN_DEBUG_MS_UNUSED_MASK      0x01F0FFFE

/* 0 */
#define D_IPUV_SYN_DEBUG_BKPT_STAT_OFF 0x00000404
#define D_IPUV_SYN_DEBUG_BKPT_STAT           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_DEBUG_BKPT_STAT_OFF))
#define D_IPUV_SYN_X_DEBUG_BKPT_STAT(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_DEBUG_BKPT_STAT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_DEBUG_BKPT_STAT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_DEBUG_BKPT_STAT_VOLATILE  0x0
#define D_IPUV_SYN_DEBUG_BKPT_STAT_BITFIELD_MASK 0x01FF0001
#define D_IPUV_SYN_DEBUG_BKPT_STAT_RWMASK    0x01FF0000
#define D_IPUV_SYN_DEBUG_BKPT_STAT_ROMASK    0x00000001
#define D_IPUV_SYN_DEBUG_BKPT_STAT_WOMASK    0x00000000
#define D_IPUV_SYN_DEBUG_BKPT_STAT_UNUSED_MASK 0xFE00FFFE

/* 0 */
#define D_IPUV_SYN_DEBUG_BKPT_POS_OFF 0x00000408
#define D_IPUV_SYN_DEBUG_BKPT_POS            (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_DEBUG_BKPT_POS_OFF))
#define D_IPUV_SYN_X_DEBUG_BKPT_POS(x)       (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_DEBUG_BKPT_POS_OFF + ((x)*0x0)))

#define D_IPUV_SYN_DEBUG_BKPT_POS_RESET_VALUE 0x00000000
#define D_IPUV_SYN_DEBUG_BKPT_POS_VOLATILE   0x0
#define D_IPUV_SYN_DEBUG_BKPT_POS_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_DEBUG_BKPT_POS_RWMASK     0xFFFFFFFF
#define D_IPUV_SYN_DEBUG_BKPT_POS_ROMASK     0x00000000
#define D_IPUV_SYN_DEBUG_BKPT_POS_WOMASK     0x00000000
#define D_IPUV_SYN_DEBUG_BKPT_POS_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_OFF 0x0000040C
#define D_IPUV_SYN_DEBUG_BKPT_ADDR           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_DEBUG_BKPT_ADDR_OFF))
#define D_IPUV_SYN_X_DEBUG_BKPT_ADDR(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_DEBUG_BKPT_ADDR_OFF + ((x)*0x0)))

#define D_IPUV_SYN_DEBUG_BKPT_ADDR_RESET_VALUE 0x00000000
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_VOLATILE  0x0
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_BITFIELD_MASK 0xFFFFFF00
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_RWMASK    0xFFFFFF00
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_ROMASK    0x00000000
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_WOMASK    0x00000000
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_UNUSED_MASK 0x000000FF

/* 0 */
#define D_IPUV_SYN_DEBUG_DI_OFF 0x00000410
#define D_IPUV_SYN_DEBUG_DI                  (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_DEBUG_DI_OFF))
#define D_IPUV_SYN_X_DEBUG_DI(x)             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_DEBUG_DI_OFF + ((x)*0x0)))

#define D_IPUV_SYN_DEBUG_DI_RESET_VALUE      0x00000000
#define D_IPUV_SYN_DEBUG_DI_VOLATILE         0x0
#define D_IPUV_SYN_DEBUG_DI_BITFIELD_MASK    0xFFFFFFFF
#define D_IPUV_SYN_DEBUG_DI_RWMASK           0xFFFFFFFF
#define D_IPUV_SYN_DEBUG_DI_ROMASK           0x00000000
#define D_IPUV_SYN_DEBUG_DI_WOMASK           0x00000000
#define D_IPUV_SYN_DEBUG_DI_UNUSED_MASK      0x00000000

/* 0 */
#define D_IPUV_SYN_DEBUG_CORE_STAT_OFF 0x00000414
#define D_IPUV_SYN_DEBUG_CORE_STAT           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_DEBUG_CORE_STAT_OFF))
#define D_IPUV_SYN_X_DEBUG_CORE_STAT(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_DEBUG_CORE_STAT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_DEBUG_CORE_STAT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_DEBUG_CORE_STAT_VOLATILE  0x0
#define D_IPUV_SYN_DEBUG_CORE_STAT_BITFIELD_MASK 0x0F0000FF
#define D_IPUV_SYN_DEBUG_CORE_STAT_RWMASK    0x00000000
#define D_IPUV_SYN_DEBUG_CORE_STAT_ROMASK    0x0F0000FF
#define D_IPUV_SYN_DEBUG_CORE_STAT_WOMASK    0x00000000
#define D_IPUV_SYN_DEBUG_CORE_STAT_UNUSED_MASK 0xF0FFFF00

/* 0 */
#define D_IPUV_SYN_PMONITOR_CTRL_OFF 0x00000500
#define D_IPUV_SYN_PMONITOR_CTRL             (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_PMONITOR_CTRL_OFF))
#define D_IPUV_SYN_X_PMONITOR_CTRL(x)        (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_PMONITOR_CTRL_OFF + ((x)*0x0)))

#define D_IPUV_SYN_PMONITOR_CTRL_RESET_VALUE 0x00000000
#define D_IPUV_SYN_PMONITOR_CTRL_VOLATILE    0x0
#define D_IPUV_SYN_PMONITOR_CTRL_BITFIELD_MASK 0x001F1F1F
#define D_IPUV_SYN_PMONITOR_CTRL_RWMASK      0x000F1F1F
#define D_IPUV_SYN_PMONITOR_CTRL_ROMASK      0x00100000
#define D_IPUV_SYN_PMONITOR_CTRL_WOMASK      0x00000000
#define D_IPUV_SYN_PMONITOR_CTRL_UNUSED_MASK 0xFFE0E0E0

/* 0 */
#define D_IPUV_SYN_PMONITOR_SAMPLE_OFF 0x00000504
#define D_IPUV_SYN_PMONITOR_SAMPLE           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_PMONITOR_SAMPLE_OFF))
#define D_IPUV_SYN_X_PMONITOR_SAMPLE(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_PMONITOR_SAMPLE_OFF + ((x)*0x0)))

#define D_IPUV_SYN_PMONITOR_SAMPLE_RESET_VALUE 0x00000000
#define D_IPUV_SYN_PMONITOR_SAMPLE_VOLATILE  0x0
#define D_IPUV_SYN_PMONITOR_SAMPLE_BITFIELD_MASK 0x0000001F
#define D_IPUV_SYN_PMONITOR_SAMPLE_RWMASK    0x0000001F
#define D_IPUV_SYN_PMONITOR_SAMPLE_ROMASK    0x00000000
#define D_IPUV_SYN_PMONITOR_SAMPLE_WOMASK    0x00000000
#define D_IPUV_SYN_PMONITOR_SAMPLE_UNUSED_MASK 0xFFFFFFE0

/* 0 */
#define D_IPUV_SYN_STALL_STREAMIN_OFF 0x00000508
#define D_IPUV_SYN_STALL_STREAMIN            (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_STALL_STREAMIN_OFF))
#define D_IPUV_SYN_X_STALL_STREAMIN(x)       (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_STALL_STREAMIN_OFF + ((x)*0x0)))

#define D_IPUV_SYN_STALL_STREAMIN_RESET_VALUE 0x00000000
#define D_IPUV_SYN_STALL_STREAMIN_VOLATILE   0x0
#define D_IPUV_SYN_STALL_STREAMIN_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_STALL_STREAMIN_RWMASK     0x00000000
#define D_IPUV_SYN_STALL_STREAMIN_ROMASK     0xFFFFFFFF
#define D_IPUV_SYN_STALL_STREAMIN_WOMASK     0x00000000
#define D_IPUV_SYN_STALL_STREAMIN_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_STALL_STREAMOUT_OFF 0x0000050C
#define D_IPUV_SYN_STALL_STREAMOUT           (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_STALL_STREAMOUT_OFF))
#define D_IPUV_SYN_X_STALL_STREAMOUT(x)      (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_STALL_STREAMOUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_STALL_STREAMOUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_STALL_STREAMOUT_VOLATILE  0x0
#define D_IPUV_SYN_STALL_STREAMOUT_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_STALL_STREAMOUT_RWMASK    0x00000000
#define D_IPUV_SYN_STALL_STREAMOUT_ROMASK    0xFFFFFFFF
#define D_IPUV_SYN_STALL_STREAMOUT_WOMASK    0x00000000
#define D_IPUV_SYN_STALL_STREAMOUT_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_STALL_STREAMINOUT_OFF 0x00000510
#define D_IPUV_SYN_STALL_STREAMINOUT         (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_STALL_STREAMINOUT_OFF))
#define D_IPUV_SYN_X_STALL_STREAMINOUT(x)    (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_STALL_STREAMINOUT_OFF + ((x)*0x0)))

#define D_IPUV_SYN_STALL_STREAMINOUT_RESET_VALUE 0x00000000
#define D_IPUV_SYN_STALL_STREAMINOUT_VOLATILE 0x0
#define D_IPUV_SYN_STALL_STREAMINOUT_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_STALL_STREAMINOUT_RWMASK  0x00000000
#define D_IPUV_SYN_STALL_STREAMINOUT_ROMASK  0xFFFFFFFF
#define D_IPUV_SYN_STALL_STREAMINOUT_WOMASK  0x00000000
#define D_IPUV_SYN_STALL_STREAMINOUT_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_STALL_DATAHAZARD_OFF 0x00000514
#define D_IPUV_SYN_STALL_DATAHAZARD          (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_STALL_DATAHAZARD_OFF))
#define D_IPUV_SYN_X_STALL_DATAHAZARD(x)     (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_STALL_DATAHAZARD_OFF + ((x)*0x0)))

#define D_IPUV_SYN_STALL_DATAHAZARD_RESET_VALUE 0x00000000
#define D_IPUV_SYN_STALL_DATAHAZARD_VOLATILE 0x0
#define D_IPUV_SYN_STALL_DATAHAZARD_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_STALL_DATAHAZARD_RWMASK   0x00000000
#define D_IPUV_SYN_STALL_DATAHAZARD_ROMASK   0xFFFFFFFF
#define D_IPUV_SYN_STALL_DATAHAZARD_WOMASK   0x00000000
#define D_IPUV_SYN_STALL_DATAHAZARD_UNUSED_MASK 0x00000000

/* 0 */
#define D_IPUV_SYN_EXEC_COUNTER_OFF 0x00000518
#define D_IPUV_SYN_EXEC_COUNTER              (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_EXEC_COUNTER_OFF))
#define D_IPUV_SYN_X_EXEC_COUNTER(x)         (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_EXEC_COUNTER_OFF + ((x)*0x0)))

#define D_IPUV_SYN_EXEC_COUNTER_RESET_VALUE  0x00000000
#define D_IPUV_SYN_EXEC_COUNTER_VOLATILE     0x0
#define D_IPUV_SYN_EXEC_COUNTER_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYN_EXEC_COUNTER_RWMASK       0x00000000
#define D_IPUV_SYN_EXEC_COUNTER_ROMASK       0xFFFFFFFF
#define D_IPUV_SYN_EXEC_COUNTER_WOMASK       0x00000000
#define D_IPUV_SYN_EXEC_COUNTER_UNUSED_MASK  0x00000000

/* 0 */
#define D_IPUV_SYN_IMEM_ERROR_INJECT_ADDR_OFF 0x00000580
#define D_IPUV_SYN_IMEM_ERROR_INJECT_ADDR              (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_IMEM_ERROR_INJECT_ADDR_OFF))
#define D_IPUV_SYN_X_IMEM_ERROR_INJECT_ADDR(x)         (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_IMEM_ERROR_INJECT_ADDR_OFF + ((x)*0x0)))

#define D_IPUV_SYN_IMEM_ERROR_INJECT_ADDR_RESET_VALUE  0x00000000
#define D_IPUV_SYN_IMEM_ERROR_INJECT_ADDR_VOLATILE     0x0
#define D_IPUV_SYN_IMEM_ERROR_INJECT_ADDR_BITFIELD_MASK 0x0000003F
#define D_IPUV_SYN_IMEM_ERROR_INJECT_ADDR_RWMASK       0x0000003F
#define D_IPUV_SYN_IMEM_ERROR_INJECT_ADDR_ROMASK       0x00000000
#define D_IPUV_SYN_IMEM_ERROR_INJECT_ADDR_WOMASK       0x00000000
#define D_IPUV_SYN_IMEM_ERROR_INJECT_ADDR_UNUSED_MASK  0xFFFFFFC0

/* 0 */
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR0_OFF 0x00000584
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR0              (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYNC_IMEM_ERROR_VECTOR0_OFF))
#define D_IPUV_SYN_X_IMEM_ERROR_VECTOR0(x)         (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYNC_IMEM_ERROR_VECTOR0_OFF + ((x)*0x0)))

#define D_IPUV_SYNC_IMEM_ERROR_VECTOR0_RESET_VALUE  0x00000000
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR0_VOLATILE     0x0
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR0_BITFIELD_MASK 0xFFFFFFFF
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR0_RWMASK       0xFFFFFFFF
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR0_ROMASK       0x00000000
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR0_WOMASK       0x00000000
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR0_UNUSED_MASK  0x00000000

/* 0 */
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR1_OFF 0x00000588
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR1              (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYNC_IMEM_ERROR_VECTOR1_OFF))
#define D_IPUV_SYN_X_IMEM_ERROR_VECTOR1(x)         (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYNC_IMEM_ERROR_VECTOR1_OFF + ((x)*0x0)))

#define D_IPUV_SYNC_IMEM_ERROR_VECTOR1_RESET_VALUE  0x00000000
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR1_VOLATILE     0x0
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR1_BITFIELD_MASK 0x1000007F
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR1_RWMASK       0x1000007F
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR1_ROMASK       0x00000000
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR1_WOMASK       0x00000000
#define D_IPUV_SYNC_IMEM_ERROR_VECTOR1_UNUSED_MASK  0xEFFFFF80

/* 0 */
#define D_IPUV_SYNC_IMEM_ERROR_INJECT_STAT_OFF 0x0000058C
#define D_IPUV_SYNC_IMEM_ERROR_INJECT_STAT              (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYNC_IMEM_ERROR_INJECT_STAT_OFF))
#define D_IPUV_SYN_X_IMEM_ERROR_INJECT_STAT(x)         (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYNC_IMEM_ERROR_INJECT_STAT_OFF + ((x)*0x0)))

#define D_IPUV_SYNC_IMEM_ERROR_INJECT_STAT_RESET_VALUE  0x00000000
#define D_IPUV_SYNC_IMEM_ERROR_INJECT_STAT_VOLATILE     0x0
#define D_IPUV_SYNC_IMEM_ERROR_INJECT_STAT_BITFIELD_MASK 0x10003F03
#define D_IPUV_SYNC_IMEM_ERROR_INJECT_STAT_RWMASK       0x10000000
#define D_IPUV_SYNC_IMEM_ERROR_INJECT_STAT_ROMASK       0x00003F03
#define D_IPUV_SYNC_IMEM_ERROR_INJECT_STAT_WOMASK       0x00000000
#define D_IPUV_SYNC_IMEM_ERROR_INJECT_STAT_UNUSED_MASK  0xEFFFC0FC

/* 0 */
#define D_IPUV_SYN_RESET_REG_OFF 0x00000600
#define D_IPUV_SYN_RESET_REG                 (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS+D_IPUV_SYN_RESET_REG_OFF))
#define D_IPUV_SYN_X_RESET_REG(x)            (*(vuint32_t *) (D_IPUV_SYN_BASEADDRESS  + D_IPUV_SYN_RESET_REG_OFF + ((x)*0x0)))

#define D_IPUV_SYN_RESET_REG_RESET_VALUE     0x00000000
#define D_IPUV_SYN_RESET_REG_VOLATILE        0x0
#define D_IPUV_SYN_RESET_REG_BITFIELD_MASK   0x00000003
#define D_IPUV_SYN_RESET_REG_RWMASK          0x00000003
#define D_IPUV_SYN_RESET_REG_ROMASK          0x00000000
#define D_IPUV_SYN_RESET_REG_WOMASK          0x00000000
#define D_IPUV_SYN_RESET_REG_UNUSED_MASK     0xFFFFFFFC


/* Field definitions for HOST_START */

#define D_IPUV_SYN_HOST_START_NSA_VALUE(x)   (((x)&0x000000FF)<<0)
#define D_IPUV_SYN_HOST_START_NSA_MSB        (7)
#define D_IPUV_SYN_HOST_START_NSA_LSB        (0)
#define D_IPUV_SYN_HOST_START_NSA_MASK       (0x000000FF)
#define D_IPUV_SYN_HOST_START_NSA            ((D_IPUV_SYN_HOST_START_NSA_MASK) << (D_IPUV_SYN_HOST_START_NSA_LSB))

#define D_IPUV_SYN_HOST_START_CSA_VALUE(x)   (((x)&0x000000FF)<<16)
#define D_IPUV_SYN_HOST_START_CSA_MSB        (23)
#define D_IPUV_SYN_HOST_START_CSA_LSB        (16)
#define D_IPUV_SYN_HOST_START_CSA_MASK       (0x000000FF)
#define D_IPUV_SYN_HOST_START_CSA            ((D_IPUV_SYN_HOST_START_CSA_MASK) << (D_IPUV_SYN_HOST_START_CSA_LSB))



/* Field definitions for HOST_STATUS */

#define D_IPUV_SYN_HOST_STATUS_N_EVENTS_VALUE(x) (((x)&0x00000003)<<0)
#define D_IPUV_SYN_HOST_STATUS_N_EVENTS_MSB  (1)
#define D_IPUV_SYN_HOST_STATUS_N_EVENTS_LSB  (0)
#define D_IPUV_SYN_HOST_STATUS_N_EVENTS_MASK (0x00000003)
#define D_IPUV_SYN_HOST_STATUS_N_EVENTS      ((D_IPUV_SYN_HOST_STATUS_N_EVENTS_MASK) << (D_IPUV_SYN_HOST_STATUS_N_EVENTS_LSB))

#define D_IPUV_SYN_HOST_STATUS_CORESTATUS_VALUE(x) (((x)&0x00000003)<<8)
#define D_IPUV_SYN_HOST_STATUS_CORESTATUS_MSB (9)
#define D_IPUV_SYN_HOST_STATUS_CORESTATUS_LSB (8)
#define D_IPUV_SYN_HOST_STATUS_CORESTATUS_MASK (0x00000003)
#define D_IPUV_SYN_HOST_STATUS_CORESTATUS    ((D_IPUV_SYN_HOST_STATUS_CORESTATUS_MASK) << (D_IPUV_SYN_HOST_STATUS_CORESTATUS_LSB))

#define D_IPUV_SYN_HOST_STATUS_DEBUGSTATUS_VALUE(x) (((x)&0x00000001)<<10)
#define D_IPUV_SYN_HOST_STATUS_DEBUGSTATUS_BIT (10)
#define D_IPUV_SYN_HOST_STATUS_DEBUGSTATUS   ((1) << (D_IPUV_SYN_HOST_STATUS_DEBUGSTATUS_BIT))

#define D_IPUV_SYN_HOST_STATUS_REMAIN_PIXELS_VALUE(x) (((x)&0x0000FFFF)<<16)
#define D_IPUV_SYN_HOST_STATUS_REMAIN_PIXELS_MSB (31)
#define D_IPUV_SYN_HOST_STATUS_REMAIN_PIXELS_LSB (16)
#define D_IPUV_SYN_HOST_STATUS_REMAIN_PIXELS_MASK (0x0000FFFF)
#define D_IPUV_SYN_HOST_STATUS_REMAIN_PIXELS ((D_IPUV_SYN_HOST_STATUS_REMAIN_PIXELS_MASK) << (D_IPUV_SYN_HOST_STATUS_REMAIN_PIXELS_LSB))



/* Field definitions for HOST_POS */

#define D_IPUV_SYN_HOST_POS_YPOS_VALUE(x)    (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_HOST_POS_YPOS_MSB         (15)
#define D_IPUV_SYN_HOST_POS_YPOS_LSB         (0)
#define D_IPUV_SYN_HOST_POS_YPOS_MASK        (0x0000FFFF)
#define D_IPUV_SYN_HOST_POS_YPOS             ((D_IPUV_SYN_HOST_POS_YPOS_MASK) << (D_IPUV_SYN_HOST_POS_YPOS_LSB))

#define D_IPUV_SYN_HOST_POS_XPOS_VALUE(x)    (((x)&0x0000FFFF)<<16)
#define D_IPUV_SYN_HOST_POS_XPOS_MSB         (31)
#define D_IPUV_SYN_HOST_POS_XPOS_LSB         (16)
#define D_IPUV_SYN_HOST_POS_XPOS_MASK        (0x0000FFFF)
#define D_IPUV_SYN_HOST_POS_XPOS             ((D_IPUV_SYN_HOST_POS_XPOS_MASK) << (D_IPUV_SYN_HOST_POS_XPOS_LSB))



/* Field definitions for HOST_CURRPOS */

#define D_IPUV_SYN_HOST_CURRPOS_CURR_YPOS_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_HOST_CURRPOS_CURR_YPOS_MSB (15)
#define D_IPUV_SYN_HOST_CURRPOS_CURR_YPOS_LSB (0)
#define D_IPUV_SYN_HOST_CURRPOS_CURR_YPOS_MASK (0x0000FFFF)
#define D_IPUV_SYN_HOST_CURRPOS_CURR_YPOS    ((D_IPUV_SYN_HOST_CURRPOS_CURR_YPOS_MASK) << (D_IPUV_SYN_HOST_CURRPOS_CURR_YPOS_LSB))

#define D_IPUV_SYN_HOST_CURRPOS_CURR_XPOS_VALUE(x) (((x)&0x0000FFFF)<<16)
#define D_IPUV_SYN_HOST_CURRPOS_CURR_XPOS_MSB (31)
#define D_IPUV_SYN_HOST_CURRPOS_CURR_XPOS_LSB (16)
#define D_IPUV_SYN_HOST_CURRPOS_CURR_XPOS_MASK (0x0000FFFF)
#define D_IPUV_SYN_HOST_CURRPOS_CURR_XPOS    ((D_IPUV_SYN_HOST_CURRPOS_CURR_XPOS_MASK) << (D_IPUV_SYN_HOST_CURRPOS_CURR_XPOS_LSB))



/* Field definitions for HOST_XCFG */

#define D_IPUV_SYN_HOST_XCFG_XSTEP_VALUE(x)  (((x)&0x00000003)<<0)
#define D_IPUV_SYN_HOST_XCFG_XSTEP_MSB       (1)
#define D_IPUV_SYN_HOST_XCFG_XSTEP_LSB       (0)
#define D_IPUV_SYN_HOST_XCFG_XSTEP_MASK      (0x00000003)
#define D_IPUV_SYN_HOST_XCFG_XSTEP           ((D_IPUV_SYN_HOST_XCFG_XSTEP_MASK) << (D_IPUV_SYN_HOST_XCFG_XSTEP_LSB))

#define D_IPUV_SYN_HOST_XCFG_XSIZE_VALUE(x)  (((x)&0x0000FFFF)<<16)
#define D_IPUV_SYN_HOST_XCFG_XSIZE_MSB       (31)
#define D_IPUV_SYN_HOST_XCFG_XSIZE_LSB       (16)
#define D_IPUV_SYN_HOST_XCFG_XSIZE_MASK      (0x0000FFFF)
#define D_IPUV_SYN_HOST_XCFG_XSIZE           ((D_IPUV_SYN_HOST_XCFG_XSIZE_MASK) << (D_IPUV_SYN_HOST_XCFG_XSIZE_LSB))



/* Field definitions for HOST_CURRXCFG */

#define D_IPUV_SYN_HOST_CURRXCFG_CURR_XSTEP_VALUE(x) (((x)&0x00000003)<<0)
#define D_IPUV_SYN_HOST_CURRXCFG_CURR_XSTEP_MSB (1)
#define D_IPUV_SYN_HOST_CURRXCFG_CURR_XSTEP_LSB (0)
#define D_IPUV_SYN_HOST_CURRXCFG_CURR_XSTEP_MASK (0x00000003)
#define D_IPUV_SYN_HOST_CURRXCFG_CURR_XSTEP  ((D_IPUV_SYN_HOST_CURRXCFG_CURR_XSTEP_MASK) << (D_IPUV_SYN_HOST_CURRXCFG_CURR_XSTEP_LSB))

#define D_IPUV_SYN_HOST_CURRXCFG_CURR_XSIZE_VALUE(x) (((x)&0x0000FFFF)<<16)
#define D_IPUV_SYN_HOST_CURRXCFG_CURR_XSIZE_MSB (31)
#define D_IPUV_SYN_HOST_CURRXCFG_CURR_XSIZE_LSB (16)
#define D_IPUV_SYN_HOST_CURRXCFG_CURR_XSIZE_MASK (0x0000FFFF)
#define D_IPUV_SYN_HOST_CURRXCFG_CURR_XSIZE  ((D_IPUV_SYN_HOST_CURRXCFG_CURR_XSIZE_MASK) << (D_IPUV_SYN_HOST_CURRXCFG_CURR_XSIZE_LSB))



/* Field definitions for HOST_INACFG */

#define D_IPUV_SYN_HOST_INACFG_INA_SHIFT_VALUE(x) (((x)&0x00000003)<<0)
#define D_IPUV_SYN_HOST_INACFG_INA_SHIFT_MSB (1)
#define D_IPUV_SYN_HOST_INACFG_INA_SHIFT_LSB (0)
#define D_IPUV_SYN_HOST_INACFG_INA_SHIFT_MASK (0x00000003)
#define D_IPUV_SYN_HOST_INACFG_INA_SHIFT     ((D_IPUV_SYN_HOST_INACFG_INA_SHIFT_MASK) << (D_IPUV_SYN_HOST_INACFG_INA_SHIFT_LSB))

#define D_IPUV_SYN_HOST_INACFG_EN_LINE0_VALUE(x) (((x)&0x00000001)<<8)
#define D_IPUV_SYN_HOST_INACFG_EN_LINE0_BIT  (8)
#define D_IPUV_SYN_HOST_INACFG_EN_LINE0      ((1) << (D_IPUV_SYN_HOST_INACFG_EN_LINE0_BIT))

#define D_IPUV_SYN_HOST_INACFG_EN_LINE1_VALUE(x) (((x)&0x00000001)<<9)
#define D_IPUV_SYN_HOST_INACFG_EN_LINE1_BIT  (9)
#define D_IPUV_SYN_HOST_INACFG_EN_LINE1      ((1) << (D_IPUV_SYN_HOST_INACFG_EN_LINE1_BIT))

#define D_IPUV_SYN_HOST_INACFG_EN_LINE2_VALUE(x) (((x)&0x00000001)<<10)
#define D_IPUV_SYN_HOST_INACFG_EN_LINE2_BIT  (10)
#define D_IPUV_SYN_HOST_INACFG_EN_LINE2      ((1) << (D_IPUV_SYN_HOST_INACFG_EN_LINE2_BIT))

#define D_IPUV_SYN_HOST_INACFG_EN_LINE3_VALUE(x) (((x)&0x00000001)<<11)
#define D_IPUV_SYN_HOST_INACFG_EN_LINE3_BIT  (11)
#define D_IPUV_SYN_HOST_INACFG_EN_LINE3      ((1) << (D_IPUV_SYN_HOST_INACFG_EN_LINE3_BIT))

#define D_IPUV_SYN_HOST_INACFG_EN_LINE4_VALUE(x) (((x)&0x00000001)<<12)
#define D_IPUV_SYN_HOST_INACFG_EN_LINE4_BIT  (12)
#define D_IPUV_SYN_HOST_INACFG_EN_LINE4      ((1) << (D_IPUV_SYN_HOST_INACFG_EN_LINE4_BIT))

#define D_IPUV_SYN_HOST_INACFG_NHOOD_VALUE(x) (((x)&0x00000001)<<2)
#define D_IPUV_SYN_HOST_INACFG_NHOOD_BIT     (2)
#define D_IPUV_SYN_HOST_INACFG_NHOOD         ((1) << (D_IPUV_SYN_HOST_INACFG_NHOOD_BIT))

#define D_IPUV_SYN_HOST_INACFG_CURR_INA_SHIFT_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_HOST_INACFG_CURR_INA_SHIFT_MSB (17)
#define D_IPUV_SYN_HOST_INACFG_CURR_INA_SHIFT_LSB (16)
#define D_IPUV_SYN_HOST_INACFG_CURR_INA_SHIFT_MASK (0x00000003)
#define D_IPUV_SYN_HOST_INACFG_CURR_INA_SHIFT ((D_IPUV_SYN_HOST_INACFG_CURR_INA_SHIFT_MASK) << (D_IPUV_SYN_HOST_INACFG_CURR_INA_SHIFT_LSB))

#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE0_VALUE(x) (((x)&0x00000001)<<24)
#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE0_BIT (24)
#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE0 ((1) << (D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE0_BIT))

#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE1_VALUE(x) (((x)&0x00000001)<<25)
#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE1_BIT (25)
#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE1 ((1) << (D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE1_BIT))

#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE2_VALUE(x) (((x)&0x00000001)<<26)
#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE2_BIT (26)
#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE2 ((1) << (D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE2_BIT))

#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE3_VALUE(x) (((x)&0x00000001)<<27)
#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE3_BIT (27)
#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE3 ((1) << (D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE3_BIT))

#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE4_VALUE(x) (((x)&0x00000001)<<28)
#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE4_BIT (28)
#define D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE4 ((1) << (D_IPUV_SYN_HOST_INACFG_CURR_EN_LINE4_BIT))

#define D_IPUV_SYN_HOST_INACFG_CURR_NHOOD_VALUE(x) (((x)&0x00000001)<<18)
#define D_IPUV_SYN_HOST_INACFG_CURR_NHOOD_BIT (18)
#define D_IPUV_SYN_HOST_INACFG_CURR_NHOOD    ((1) << (D_IPUV_SYN_HOST_INACFG_CURR_NHOOD_BIT))

/* Field definitions for HOST_OUTCFG */

#define D_IPUV_SYN_HOST_OUTCFG_EN_OUT0_VALUE(x) (((x)&0x00000001)<<8)
#define D_IPUV_SYN_HOST_OUTCFG_EN_OUT0_BIT   (8)
#define D_IPUV_SYN_HOST_OUTCFG_EN_OUT0       ((1) << (D_IPUV_SYN_HOST_OUTCFG_EN_OUT0_BIT))

#define D_IPUV_SYN_HOST_OUTCFG_EN_OUT1_VALUE(x) (((x)&0x00000001)<<9)
#define D_IPUV_SYN_HOST_OUTCFG_EN_OUT1_BIT   (9)
#define D_IPUV_SYN_HOST_OUTCFG_EN_OUT1       ((1) << (D_IPUV_SYN_HOST_OUTCFG_EN_OUT1_BIT))

#define D_IPUV_SYN_HOST_OUTCFG_EN_OUT2_VALUE(x) (((x)&0x00000001)<<10)
#define D_IPUV_SYN_HOST_OUTCFG_EN_OUT2_BIT   (10)
#define D_IPUV_SYN_HOST_OUTCFG_EN_OUT2       ((1) << (D_IPUV_SYN_HOST_OUTCFG_EN_OUT2_BIT))

#define D_IPUV_SYN_HOST_OUTCFG_CURR_EN_OUT0_VALUE(x) (((x)&0x00000001)<<24)
#define D_IPUV_SYN_HOST_OUTCFG_CURR_EN_OUT0_BIT (24)
#define D_IPUV_SYN_HOST_OUTCFG_CURR_EN_OUT0  ((1) << (D_IPUV_SYN_HOST_OUTCFG_CURR_EN_OUT0_BIT))

#define D_IPUV_SYN_HOST_OUTCFG_CURR_EN_OUT1_VALUE(x) (((x)&0x00000001)<<25)
#define D_IPUV_SYN_HOST_OUTCFG_CURR_EN_OUT1_BIT (25)
#define D_IPUV_SYN_HOST_OUTCFG_CURR_EN_OUT1  ((1) << (D_IPUV_SYN_HOST_OUTCFG_CURR_EN_OUT1_BIT))

#define D_IPUV_SYN_HOST_OUTCFG_CURR_EN_OUT2_VALUE(x) (((x)&0x00000001)<<26)
#define D_IPUV_SYN_HOST_OUTCFG_CURR_EN_OUT2_BIT (26)
#define D_IPUV_SYN_HOST_OUTCFG_CURR_EN_OUT2  ((1) << (D_IPUV_SYN_HOST_OUTCFG_CURR_EN_OUT2_BIT))


/* Field definitions for HOST_IMEMA */

#define D_IPUV_SYN_HOST_IMEMA_IADDR_VALUE(x) (((x)&0x0000003F)<<0)
#define D_IPUV_SYN_HOST_IMEMA_IADDR_MSB      (5)
#define D_IPUV_SYN_HOST_IMEMA_IADDR_LSB      (0)
#define D_IPUV_SYN_HOST_IMEMA_IADDR_MASK     (0x0000003F)
#define D_IPUV_SYN_HOST_IMEMA_IADDR          ((D_IPUV_SYN_HOST_IMEMA_IADDR_MASK) << (D_IPUV_SYN_HOST_IMEMA_IADDR_LSB))



/* Field definitions for HOST_IMEMD */

#define D_IPUV_SYN_HOST_IMEMD_DATA_VALUE(x)  (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_HOST_IMEMD_DATA_MSB       (31)
#define D_IPUV_SYN_HOST_IMEMD_DATA_LSB       (0)
#define D_IPUV_SYN_HOST_IMEMD_DATA_MASK      (0xFFFFFFFF)
#define D_IPUV_SYN_HOST_IMEMD_DATA           ((D_IPUV_SYN_HOST_IMEMD_DATA_MASK) << (D_IPUV_SYN_HOST_IMEMD_DATA_LSB))



/* Field definitions for HOST_DREGA */

#define D_IPUV_SYN_HOST_DREGA_DMEMA_VALUE(x) (((x)&0x000000FF)<<0)
#define D_IPUV_SYN_HOST_DREGA_DMEMA_MSB      (7)
#define D_IPUV_SYN_HOST_DREGA_DMEMA_LSB      (0)
#define D_IPUV_SYN_HOST_DREGA_DMEMA_MASK     (0x000000FF)
#define D_IPUV_SYN_HOST_DREGA_DMEMA          ((D_IPUV_SYN_HOST_DREGA_DMEMA_MASK) << (D_IPUV_SYN_HOST_DREGA_DMEMA_LSB))



/* Field definitions for HOST_DREGD */

#define D_IPUV_SYN_HOST_DREGD_DMEMD_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_HOST_DREGD_DMEMD_MSB      (15)
#define D_IPUV_SYN_HOST_DREGD_DMEMD_LSB      (0)
#define D_IPUV_SYN_HOST_DREGD_DMEMD_MASK     (0x0000FFFF)
#define D_IPUV_SYN_HOST_DREGD_DMEMD          ((D_IPUV_SYN_HOST_DREGD_DMEMD_MASK) << (D_IPUV_SYN_HOST_DREGD_DMEMD_LSB))


/* Field definitions for S_LINE0_LEN_INA */

#define D_IPUV_SYN_S_LINE0_LEN_INA_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_LINE0_LEN_INA_LENGTH_MSB (15)
#define D_IPUV_SYN_S_LINE0_LEN_INA_LENGTH_LSB (0)
#define D_IPUV_SYN_S_LINE0_LEN_INA_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_LINE0_LEN_INA_LENGTH    ((D_IPUV_SYN_S_LINE0_LEN_INA_LENGTH_MASK) << (D_IPUV_SYN_S_LINE0_LEN_INA_LENGTH_LSB))



/* Field definitions for S_LINE1_LEN_INA */

#define D_IPUV_SYN_S_LINE1_LEN_INA_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_LINE1_LEN_INA_LENGTH_MSB (15)
#define D_IPUV_SYN_S_LINE1_LEN_INA_LENGTH_LSB (0)
#define D_IPUV_SYN_S_LINE1_LEN_INA_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_LINE1_LEN_INA_LENGTH    ((D_IPUV_SYN_S_LINE1_LEN_INA_LENGTH_MASK) << (D_IPUV_SYN_S_LINE1_LEN_INA_LENGTH_LSB))



/* Field definitions for S_LINE2_LEN_INA */

#define D_IPUV_SYN_S_LINE2_LEN_INA_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_LINE2_LEN_INA_LENGTH_MSB (15)
#define D_IPUV_SYN_S_LINE2_LEN_INA_LENGTH_LSB (0)
#define D_IPUV_SYN_S_LINE2_LEN_INA_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_LINE2_LEN_INA_LENGTH    ((D_IPUV_SYN_S_LINE2_LEN_INA_LENGTH_MASK) << (D_IPUV_SYN_S_LINE2_LEN_INA_LENGTH_LSB))


/* Field definitions for S_LINE3_LEN_INA */

#define D_IPUV_SYN_S_LINE3_LEN_INA_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_LINE3_LEN_INA_LENGTH_MSB (15)
#define D_IPUV_SYN_S_LINE3_LEN_INA_LENGTH_LSB (0)
#define D_IPUV_SYN_S_LINE3_LEN_INA_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_LINE3_LEN_INA_LENGTH    ((D_IPUV_SYN_S_LINE3_LEN_INA_LENGTH_MASK) << (D_IPUV_SYN_S_LINE3_LEN_INA_LENGTH_LSB))

/* Field definitions for S_LINE4_LEN_INA */

#define D_IPUV_SYN_S_LINE4_LEN_INA_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_LINE4_LEN_INA_LENGTH_MSB (15)
#define D_IPUV_SYN_S_LINE4_LEN_INA_LENGTH_LSB (0)
#define D_IPUV_SYN_S_LINE4_LEN_INA_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_LINE4_LEN_INA_LENGTH    ((D_IPUV_SYN_S_LINE4_LEN_INA_LENGTH_MASK) << (D_IPUV_SYN_S_LINE4_LEN_INA_LENGTH_LSB))


/* Field definitions for S_CH0_CFG_INA */

#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_VAL ((D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CH0_CFG_INA_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CH0_CFG_INA_STEP_MSB    (17)
#define D_IPUV_SYN_S_CH0_CFG_INA_STEP_LSB    (16)
#define D_IPUV_SYN_S_CH0_CFG_INA_STEP_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH0_CFG_INA_STEP        ((D_IPUV_SYN_S_CH0_CFG_INA_STEP_MASK) << (D_IPUV_SYN_S_CH0_CFG_INA_STEP_LSB))

#define D_IPUV_SYN_S_CH0_CFG_INA_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CH0_CFG_INA_RPT_MSB     (19)
#define D_IPUV_SYN_S_CH0_CFG_INA_RPT_LSB     (18)
#define D_IPUV_SYN_S_CH0_CFG_INA_RPT_MASK    (0x00000003)
#define D_IPUV_SYN_S_CH0_CFG_INA_RPT         ((D_IPUV_SYN_S_CH0_CFG_INA_RPT_MASK) << (D_IPUV_SYN_S_CH0_CFG_INA_RPT_LSB))

#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_MODE_MSB (22)
#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_MODE_LSB (20)
#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_MODE ((D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_MODE_MASK) << (D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_MODE_LSB))

#define D_IPUV_SYN_S_CH0_CFG_INA_REVERSE_VALUE(x) (((x)&0x00000001)<<23)
#define D_IPUV_SYN_S_CH0_CFG_INA_REVERSE_BIT (23)
#define D_IPUV_SYN_S_CH0_CFG_INA_REVERSE     ((1) << (D_IPUV_SYN_S_CH0_CFG_INA_REVERSE_BIT))

#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_WIDTH ((D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CH0_CFG_INA_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CH0_CFG_INA_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CH0_CFG_INA_TYPE_MSB    (29)
#define D_IPUV_SYN_S_CH0_CFG_INA_TYPE_LSB    (28)
#define D_IPUV_SYN_S_CH0_CFG_INA_TYPE_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH0_CFG_INA_TYPE        ((D_IPUV_SYN_S_CH0_CFG_INA_TYPE_MASK) << (D_IPUV_SYN_S_CH0_CFG_INA_TYPE_LSB))



/* Field definitions for S_CH1_CFG_INA */

#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_VAL ((D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CH1_CFG_INA_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CH1_CFG_INA_STEP_MSB    (17)
#define D_IPUV_SYN_S_CH1_CFG_INA_STEP_LSB    (16)
#define D_IPUV_SYN_S_CH1_CFG_INA_STEP_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH1_CFG_INA_STEP        ((D_IPUV_SYN_S_CH1_CFG_INA_STEP_MASK) << (D_IPUV_SYN_S_CH1_CFG_INA_STEP_LSB))

#define D_IPUV_SYN_S_CH1_CFG_INA_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CH1_CFG_INA_RPT_MSB     (19)
#define D_IPUV_SYN_S_CH1_CFG_INA_RPT_LSB     (18)
#define D_IPUV_SYN_S_CH1_CFG_INA_RPT_MASK    (0x00000003)
#define D_IPUV_SYN_S_CH1_CFG_INA_RPT         ((D_IPUV_SYN_S_CH1_CFG_INA_RPT_MASK) << (D_IPUV_SYN_S_CH1_CFG_INA_RPT_LSB))

#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_MODE_MSB (22)
#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_MODE_LSB (20)
#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_MODE ((D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_MODE_MASK) << (D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_MODE_LSB))

#define D_IPUV_SYN_S_CH1_CFG_INA_REVERSE_VALUE(x) (((x)&0x00000001)<<23)
#define D_IPUV_SYN_S_CH1_CFG_INA_REVERSE_BIT (23)
#define D_IPUV_SYN_S_CH1_CFG_INA_REVERSE     ((1) << (D_IPUV_SYN_S_CH1_CFG_INA_REVERSE_BIT))

#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_WIDTH ((D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CH1_CFG_INA_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CH1_CFG_INA_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CH1_CFG_INA_TYPE_MSB    (29)
#define D_IPUV_SYN_S_CH1_CFG_INA_TYPE_LSB    (28)
#define D_IPUV_SYN_S_CH1_CFG_INA_TYPE_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH1_CFG_INA_TYPE        ((D_IPUV_SYN_S_CH1_CFG_INA_TYPE_MASK) << (D_IPUV_SYN_S_CH1_CFG_INA_TYPE_LSB))



/* Field definitions for S_CH2_CFG_INA */

#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_VAL ((D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CH2_CFG_INA_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CH2_CFG_INA_STEP_MSB    (17)
#define D_IPUV_SYN_S_CH2_CFG_INA_STEP_LSB    (16)
#define D_IPUV_SYN_S_CH2_CFG_INA_STEP_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH2_CFG_INA_STEP        ((D_IPUV_SYN_S_CH2_CFG_INA_STEP_MASK) << (D_IPUV_SYN_S_CH2_CFG_INA_STEP_LSB))

#define D_IPUV_SYN_S_CH2_CFG_INA_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CH2_CFG_INA_RPT_MSB     (19)
#define D_IPUV_SYN_S_CH2_CFG_INA_RPT_LSB     (18)
#define D_IPUV_SYN_S_CH2_CFG_INA_RPT_MASK    (0x00000003)
#define D_IPUV_SYN_S_CH2_CFG_INA_RPT         ((D_IPUV_SYN_S_CH2_CFG_INA_RPT_MASK) << (D_IPUV_SYN_S_CH2_CFG_INA_RPT_LSB))

#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_MODE_MSB (22)
#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_MODE_LSB (20)
#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_MODE ((D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_MODE_MASK) << (D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_MODE_LSB))

#define D_IPUV_SYN_S_CH2_CFG_INA_REVERSE_VALUE(x) (((x)&0x00000001)<<23)
#define D_IPUV_SYN_S_CH2_CFG_INA_REVERSE_BIT (23)
#define D_IPUV_SYN_S_CH2_CFG_INA_REVERSE     ((1) << (D_IPUV_SYN_S_CH2_CFG_INA_REVERSE_BIT))

#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_WIDTH ((D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CH2_CFG_INA_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CH2_CFG_INA_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CH2_CFG_INA_TYPE_MSB    (29)
#define D_IPUV_SYN_S_CH2_CFG_INA_TYPE_LSB    (28)
#define D_IPUV_SYN_S_CH2_CFG_INA_TYPE_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH2_CFG_INA_TYPE        ((D_IPUV_SYN_S_CH2_CFG_INA_TYPE_MASK) << (D_IPUV_SYN_S_CH2_CFG_INA_TYPE_LSB))

/* Field definitions for S_CH3_CFG_INA */

#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_VAL ((D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CH3_CFG_INA_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CH3_CFG_INA_STEP_MSB    (17)
#define D_IPUV_SYN_S_CH3_CFG_INA_STEP_LSB    (16)
#define D_IPUV_SYN_S_CH3_CFG_INA_STEP_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH3_CFG_INA_STEP        ((D_IPUV_SYN_S_CH3_CFG_INA_STEP_MASK) << (D_IPUV_SYN_S_CH3_CFG_INA_STEP_LSB))

#define D_IPUV_SYN_S_CH3_CFG_INA_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CH3_CFG_INA_RPT_MSB     (19)
#define D_IPUV_SYN_S_CH3_CFG_INA_RPT_LSB     (18)
#define D_IPUV_SYN_S_CH3_CFG_INA_RPT_MASK    (0x00000003)
#define D_IPUV_SYN_S_CH3_CFG_INA_RPT         ((D_IPUV_SYN_S_CH3_CFG_INA_RPT_MASK) << (D_IPUV_SYN_S_CH3_CFG_INA_RPT_LSB))

#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_MODE_MSB (22)
#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_MODE_LSB (20)
#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_MODE ((D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_MODE_MASK) << (D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_MODE_LSB))

#define D_IPUV_SYN_S_CH3_CFG_INA_REVERSE_VALUE(x) (((x)&0x00000001)<<23)
#define D_IPUV_SYN_S_CH3_CFG_INA_REVERSE_BIT (23)
#define D_IPUV_SYN_S_CH3_CFG_INA_REVERSE     ((1) << (D_IPUV_SYN_S_CH3_CFG_INA_REVERSE_BIT))

#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_WIDTH ((D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CH3_CFG_INA_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CH3_CFG_INA_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CH3_CFG_INA_TYPE_MSB    (29)
#define D_IPUV_SYN_S_CH3_CFG_INA_TYPE_LSB    (28)
#define D_IPUV_SYN_S_CH3_CFG_INA_TYPE_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH3_CFG_INA_TYPE        ((D_IPUV_SYN_S_CH3_CFG_INA_TYPE_MASK) << (D_IPUV_SYN_S_CH3_CFG_INA_TYPE_LSB))

/* Field definitions for S_CH4_CFG_INA */

#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_VAL ((D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CH4_CFG_INA_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CH4_CFG_INA_STEP_MSB    (17)
#define D_IPUV_SYN_S_CH4_CFG_INA_STEP_LSB    (16)
#define D_IPUV_SYN_S_CH4_CFG_INA_STEP_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH4_CFG_INA_STEP        ((D_IPUV_SYN_S_CH4_CFG_INA_STEP_MASK) << (D_IPUV_SYN_S_CH4_CFG_INA_STEP_LSB))

#define D_IPUV_SYN_S_CH4_CFG_INA_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CH4_CFG_INA_RPT_MSB     (19)
#define D_IPUV_SYN_S_CH4_CFG_INA_RPT_LSB     (18)
#define D_IPUV_SYN_S_CH4_CFG_INA_RPT_MASK    (0x00000003)
#define D_IPUV_SYN_S_CH4_CFG_INA_RPT         ((D_IPUV_SYN_S_CH4_CFG_INA_RPT_MASK) << (D_IPUV_SYN_S_CH4_CFG_INA_RPT_LSB))

#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_MODE_MSB (22)
#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_MODE_LSB (20)
#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_MODE ((D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_MODE_MASK) << (D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_MODE_LSB))

#define D_IPUV_SYN_S_CH4_CFG_INA_REVERSE_VALUE(x) (((x)&0x00000001)<<23)
#define D_IPUV_SYN_S_CH4_CFG_INA_REVERSE_BIT (23)
#define D_IPUV_SYN_S_CH4_CFG_INA_REVERSE     ((1) << (D_IPUV_SYN_S_CH4_CFG_INA_REVERSE_BIT))

#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_WIDTH ((D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CH4_CFG_INA_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CH4_CFG_INA_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CH4_CFG_INA_TYPE_MSB    (29)
#define D_IPUV_SYN_S_CH4_CFG_INA_TYPE_LSB    (28)
#define D_IPUV_SYN_S_CH4_CFG_INA_TYPE_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH4_CFG_INA_TYPE        ((D_IPUV_SYN_S_CH4_CFG_INA_TYPE_MASK) << (D_IPUV_SYN_S_CH4_CFG_INA_TYPE_LSB))


/* Field definitions for S_LINE0_ADDR_INA */

#define D_IPUV_SYN_S_LINE0_ADDR_INA_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_LINE0_ADDR_INA_ADDR_MSB (31)
#define D_IPUV_SYN_S_LINE0_ADDR_INA_ADDR_LSB (0)
#define D_IPUV_SYN_S_LINE0_ADDR_INA_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_LINE0_ADDR_INA_ADDR     ((D_IPUV_SYN_S_LINE0_ADDR_INA_ADDR_MASK) << (D_IPUV_SYN_S_LINE0_ADDR_INA_ADDR_LSB))



/* Field definitions for S_LINE1_ADDR_INA */

#define D_IPUV_SYN_S_LINE1_ADDR_INA_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_LINE1_ADDR_INA_ADDR_MSB (31)
#define D_IPUV_SYN_S_LINE1_ADDR_INA_ADDR_LSB (0)
#define D_IPUV_SYN_S_LINE1_ADDR_INA_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_LINE1_ADDR_INA_ADDR     ((D_IPUV_SYN_S_LINE1_ADDR_INA_ADDR_MASK) << (D_IPUV_SYN_S_LINE1_ADDR_INA_ADDR_LSB))



/* Field definitions for S_LINE2_ADDR_INA */

#define D_IPUV_SYN_S_LINE2_ADDR_INA_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_LINE2_ADDR_INA_ADDR_MSB (31)
#define D_IPUV_SYN_S_LINE2_ADDR_INA_ADDR_LSB (0)
#define D_IPUV_SYN_S_LINE2_ADDR_INA_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_LINE2_ADDR_INA_ADDR     ((D_IPUV_SYN_S_LINE2_ADDR_INA_ADDR_MASK) << (D_IPUV_SYN_S_LINE2_ADDR_INA_ADDR_LSB))


/* Field definitions for S_LINE3_ADDR_INA */

#define D_IPUV_SYN_S_LINE3_ADDR_INA_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_LINE3_ADDR_INA_ADDR_MSB (31)
#define D_IPUV_SYN_S_LINE3_ADDR_INA_ADDR_LSB (0)
#define D_IPUV_SYN_S_LINE3_ADDR_INA_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_LINE3_ADDR_INA_ADDR     ((D_IPUV_SYN_S_LINE3_ADDR_INA_ADDR_MASK) << (D_IPUV_SYN_S_LINE3_ADDR_INA_ADDR_LSB))


/* Field definitions for S_LINE4_ADDR_INA */

#define D_IPUV_SYN_S_LINE4_ADDR_INA_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_LINE4_ADDR_INA_ADDR_MSB (31)
#define D_IPUV_SYN_S_LINE4_ADDR_INA_ADDR_LSB (0)
#define D_IPUV_SYN_S_LINE4_ADDR_INA_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_LINE4_ADDR_INA_ADDR     ((D_IPUV_SYN_S_LINE4_ADDR_INA_ADDR_MASK) << (D_IPUV_SYN_S_LINE4_ADDR_INA_ADDR_LSB))

/*To be compatible with backward version*/
/* Field definitions for S_LINE0_LEN_INB */

#define D_IPUV_SYN_S_LINE0_LEN_INB_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_LINE0_LEN_INB_LENGTH_MSB (15)
#define D_IPUV_SYN_S_LINE0_LEN_INB_LENGTH_LSB (0)
#define D_IPUV_SYN_S_LINE0_LEN_INB_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_LINE0_LEN_INB_LENGTH    ((D_IPUV_SYN_S_LINE0_LEN_INB_LENGTH_MASK) << (D_IPUV_SYN_S_LINE0_LEN_INB_LENGTH_LSB))



/* Field definitions for S_LINE1_LEN_INB */

#define D_IPUV_SYN_S_LINE1_LEN_INB_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_LINE1_LEN_INB_LENGTH_MSB (15)
#define D_IPUV_SYN_S_LINE1_LEN_INB_LENGTH_LSB (0)
#define D_IPUV_SYN_S_LINE1_LEN_INB_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_LINE1_LEN_INB_LENGTH    ((D_IPUV_SYN_S_LINE1_LEN_INB_LENGTH_MASK) << (D_IPUV_SYN_S_LINE1_LEN_INB_LENGTH_LSB))

/* Field definitions for S_CH0_CFG_INB */

#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_VAL ((D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CH0_CFG_INB_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CH0_CFG_INB_STEP_MSB    (17)
#define D_IPUV_SYN_S_CH0_CFG_INB_STEP_LSB    (16)
#define D_IPUV_SYN_S_CH0_CFG_INB_STEP_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH0_CFG_INB_STEP        ((D_IPUV_SYN_S_CH0_CFG_INB_STEP_MASK) << (D_IPUV_SYN_S_CH0_CFG_INB_STEP_LSB))

#define D_IPUV_SYN_S_CH0_CFG_INB_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CH0_CFG_INB_RPT_MSB     (19)
#define D_IPUV_SYN_S_CH0_CFG_INB_RPT_LSB     (18)
#define D_IPUV_SYN_S_CH0_CFG_INB_RPT_MASK    (0x00000003)
#define D_IPUV_SYN_S_CH0_CFG_INB_RPT         ((D_IPUV_SYN_S_CH0_CFG_INB_RPT_MASK) << (D_IPUV_SYN_S_CH0_CFG_INB_RPT_LSB))

#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_MODE_MSB (22)
#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_MODE_LSB (20)
#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_MODE ((D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_MODE_MASK) << (D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_MODE_LSB))

#define D_IPUV_SYN_S_CH0_CFG_INB_REVERSE_VALUE(x) (((x)&0x00000001)<<23)
#define D_IPUV_SYN_S_CH0_CFG_INB_REVERSE_BIT (23)
#define D_IPUV_SYN_S_CH0_CFG_INB_REVERSE     ((1) << (D_IPUV_SYN_S_CH0_CFG_INB_REVERSE_BIT))

#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_WIDTH ((D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CH0_CFG_INB_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CH0_CFG_INB_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CH0_CFG_INB_TYPE_MSB    (29)
#define D_IPUV_SYN_S_CH0_CFG_INB_TYPE_LSB    (28)
#define D_IPUV_SYN_S_CH0_CFG_INB_TYPE_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH0_CFG_INB_TYPE        ((D_IPUV_SYN_S_CH0_CFG_INB_TYPE_MASK) << (D_IPUV_SYN_S_CH0_CFG_INB_TYPE_LSB))



/* Field definitions for S_CH1_CFG_INB */

#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_VAL ((D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CH1_CFG_INB_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CH1_CFG_INB_STEP_MSB    (17)
#define D_IPUV_SYN_S_CH1_CFG_INB_STEP_LSB    (16)
#define D_IPUV_SYN_S_CH1_CFG_INB_STEP_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH1_CFG_INB_STEP        ((D_IPUV_SYN_S_CH1_CFG_INB_STEP_MASK) << (D_IPUV_SYN_S_CH1_CFG_INB_STEP_LSB))

#define D_IPUV_SYN_S_CH1_CFG_INB_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CH1_CFG_INB_RPT_MSB     (19)
#define D_IPUV_SYN_S_CH1_CFG_INB_RPT_LSB     (18)
#define D_IPUV_SYN_S_CH1_CFG_INB_RPT_MASK    (0x00000003)
#define D_IPUV_SYN_S_CH1_CFG_INB_RPT         ((D_IPUV_SYN_S_CH1_CFG_INB_RPT_MASK) << (D_IPUV_SYN_S_CH1_CFG_INB_RPT_LSB))

#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_MODE_MSB (22)
#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_MODE_LSB (20)
#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_MODE ((D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_MODE_MASK) << (D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_MODE_LSB))

#define D_IPUV_SYN_S_CH1_CFG_INB_REVERSE_VALUE(x) (((x)&0x00000001)<<23)
#define D_IPUV_SYN_S_CH1_CFG_INB_REVERSE_BIT (23)
#define D_IPUV_SYN_S_CH1_CFG_INB_REVERSE     ((1) << (D_IPUV_SYN_S_CH1_CFG_INB_REVERSE_BIT))

#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_WIDTH ((D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CH1_CFG_INB_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CH1_CFG_INB_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CH1_CFG_INB_TYPE_MSB    (29)
#define D_IPUV_SYN_S_CH1_CFG_INB_TYPE_LSB    (28)
#define D_IPUV_SYN_S_CH1_CFG_INB_TYPE_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH1_CFG_INB_TYPE        ((D_IPUV_SYN_S_CH1_CFG_INB_TYPE_MASK) << (D_IPUV_SYN_S_CH1_CFG_INB_TYPE_LSB))

/* Field definitions for S_LINE0_ADDR_INB */

#define D_IPUV_SYN_S_LINE0_ADDR_INB_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_LINE0_ADDR_INB_ADDR_MSB (31)
#define D_IPUV_SYN_S_LINE0_ADDR_INB_ADDR_LSB (0)
#define D_IPUV_SYN_S_LINE0_ADDR_INB_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_LINE0_ADDR_INB_ADDR     ((D_IPUV_SYN_S_LINE0_ADDR_INB_ADDR_MASK) << (D_IPUV_SYN_S_LINE0_ADDR_INB_ADDR_LSB))



/* Field definitions for S_LINE1_ADDR_INB */

#define D_IPUV_SYN_S_LINE1_ADDR_INB_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_LINE1_ADDR_INB_ADDR_MSB (31)
#define D_IPUV_SYN_S_LINE1_ADDR_INB_ADDR_LSB (0)
#define D_IPUV_SYN_S_LINE1_ADDR_INB_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_LINE1_ADDR_INB_ADDR     ((D_IPUV_SYN_S_LINE1_ADDR_INB_ADDR_MASK) << (D_IPUV_SYN_S_LINE1_ADDR_INB_ADDR_LSB))
/******************End******************************/


/* Field definitions for S_LINE0_LEN_OUT */

#define D_IPUV_SYN_S_LINE0_LEN_OUT_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_LINE0_LEN_OUT_LENGTH_MSB (15)
#define D_IPUV_SYN_S_LINE0_LEN_OUT_LENGTH_LSB (0)
#define D_IPUV_SYN_S_LINE0_LEN_OUT_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_LINE0_LEN_OUT_LENGTH    ((D_IPUV_SYN_S_LINE0_LEN_OUT_LENGTH_MASK) << (D_IPUV_SYN_S_LINE0_LEN_OUT_LENGTH_LSB))



/* Field definitions for S_LINE1_LEN_OUT */

#define D_IPUV_SYN_S_LINE1_LEN_OUT_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_LINE1_LEN_OUT_LENGTH_MSB (15)
#define D_IPUV_SYN_S_LINE1_LEN_OUT_LENGTH_LSB (0)
#define D_IPUV_SYN_S_LINE1_LEN_OUT_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_LINE1_LEN_OUT_LENGTH    ((D_IPUV_SYN_S_LINE1_LEN_OUT_LENGTH_MASK) << (D_IPUV_SYN_S_LINE1_LEN_OUT_LENGTH_LSB))



/* Field definitions for S_LINE2_LEN_OUT */

#define D_IPUV_SYN_S_LINE2_LEN_OUT_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_LINE2_LEN_OUT_LENGTH_MSB (15)
#define D_IPUV_SYN_S_LINE2_LEN_OUT_LENGTH_LSB (0)
#define D_IPUV_SYN_S_LINE2_LEN_OUT_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_LINE2_LEN_OUT_LENGTH    ((D_IPUV_SYN_S_LINE2_LEN_OUT_LENGTH_MASK) << (D_IPUV_SYN_S_LINE2_LEN_OUT_LENGTH_LSB))



/* Field definitions for S_CH0_CFG_OUT */

#define D_IPUV_SYN_S_CH0_CFG_OUT_SKIP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CH0_CFG_OUT_SKIP_MSB    (17)
#define D_IPUV_SYN_S_CH0_CFG_OUT_SKIP_LSB    (16)
#define D_IPUV_SYN_S_CH0_CFG_OUT_SKIP_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH0_CFG_OUT_SKIP        ((D_IPUV_SYN_S_CH0_CFG_OUT_SKIP_MASK) << (D_IPUV_SYN_S_CH0_CFG_OUT_SKIP_LSB))

#define D_IPUV_SYN_S_CH0_CFG_OUT_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CH0_CFG_OUT_TYPE_MSB    (29)
#define D_IPUV_SYN_S_CH0_CFG_OUT_TYPE_LSB    (28)
#define D_IPUV_SYN_S_CH0_CFG_OUT_TYPE_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH0_CFG_OUT_TYPE        ((D_IPUV_SYN_S_CH0_CFG_OUT_TYPE_MASK) << (D_IPUV_SYN_S_CH0_CFG_OUT_TYPE_LSB))



/* Field definitions for S_CH1_CFG_OUT */

#define D_IPUV_SYN_S_CH1_CFG_OUT_SKIP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CH1_CFG_OUT_SKIP_MSB    (17)
#define D_IPUV_SYN_S_CH1_CFG_OUT_SKIP_LSB    (16)
#define D_IPUV_SYN_S_CH1_CFG_OUT_SKIP_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH1_CFG_OUT_SKIP        ((D_IPUV_SYN_S_CH1_CFG_OUT_SKIP_MASK) << (D_IPUV_SYN_S_CH1_CFG_OUT_SKIP_LSB))

#define D_IPUV_SYN_S_CH1_CFG_OUT_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CH1_CFG_OUT_TYPE_MSB    (29)
#define D_IPUV_SYN_S_CH1_CFG_OUT_TYPE_LSB    (28)
#define D_IPUV_SYN_S_CH1_CFG_OUT_TYPE_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH1_CFG_OUT_TYPE        ((D_IPUV_SYN_S_CH1_CFG_OUT_TYPE_MASK) << (D_IPUV_SYN_S_CH1_CFG_OUT_TYPE_LSB))



/* Field definitions for S_CH2_CFG_OUT */

#define D_IPUV_SYN_S_CH2_CFG_OUT_SKIP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CH2_CFG_OUT_SKIP_MSB    (17)
#define D_IPUV_SYN_S_CH2_CFG_OUT_SKIP_LSB    (16)
#define D_IPUV_SYN_S_CH2_CFG_OUT_SKIP_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH2_CFG_OUT_SKIP        ((D_IPUV_SYN_S_CH2_CFG_OUT_SKIP_MASK) << (D_IPUV_SYN_S_CH2_CFG_OUT_SKIP_LSB))

#define D_IPUV_SYN_S_CH2_CFG_OUT_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CH2_CFG_OUT_TYPE_MSB    (29)
#define D_IPUV_SYN_S_CH2_CFG_OUT_TYPE_LSB    (28)
#define D_IPUV_SYN_S_CH2_CFG_OUT_TYPE_MASK   (0x00000003)
#define D_IPUV_SYN_S_CH2_CFG_OUT_TYPE        ((D_IPUV_SYN_S_CH2_CFG_OUT_TYPE_MASK) << (D_IPUV_SYN_S_CH2_CFG_OUT_TYPE_LSB))



/* Field definitions for S_LINE0_ADDR_OUT */

#define D_IPUV_SYN_S_LINE0_ADDR_OUT_ADDR_VALUE(x) (((x)&0x1FFFFFFF)<<3)
#define D_IPUV_SYN_S_LINE0_ADDR_OUT_ADDR_MSB (31)
#define D_IPUV_SYN_S_LINE0_ADDR_OUT_ADDR_LSB (3)
#define D_IPUV_SYN_S_LINE0_ADDR_OUT_ADDR_MASK (0x1FFFFFFF)
#define D_IPUV_SYN_S_LINE0_ADDR_OUT_ADDR     ((D_IPUV_SYN_S_LINE0_ADDR_OUT_ADDR_MASK) << (D_IPUV_SYN_S_LINE0_ADDR_OUT_ADDR_LSB))



/* Field definitions for S_LINE1_ADDR_OUT */

#define D_IPUV_SYN_S_LINE1_ADDR_OUT_ADDR_VALUE(x) (((x)&0x1FFFFFFF)<<3)
#define D_IPUV_SYN_S_LINE1_ADDR_OUT_ADDR_MSB (31)
#define D_IPUV_SYN_S_LINE1_ADDR_OUT_ADDR_LSB (3)
#define D_IPUV_SYN_S_LINE1_ADDR_OUT_ADDR_MASK (0x1FFFFFFF)
#define D_IPUV_SYN_S_LINE1_ADDR_OUT_ADDR     ((D_IPUV_SYN_S_LINE1_ADDR_OUT_ADDR_MASK) << (D_IPUV_SYN_S_LINE1_ADDR_OUT_ADDR_LSB))



/* Field definitions for S_LINE2_ADDR_OUT */

#define D_IPUV_SYN_S_LINE2_ADDR_OUT_ADDR_VALUE(x) (((x)&0x1FFFFFFF)<<3)
#define D_IPUV_SYN_S_LINE2_ADDR_OUT_ADDR_MSB (31)
#define D_IPUV_SYN_S_LINE2_ADDR_OUT_ADDR_LSB (3)
#define D_IPUV_SYN_S_LINE2_ADDR_OUT_ADDR_MASK (0x1FFFFFFF)
#define D_IPUV_SYN_S_LINE2_ADDR_OUT_ADDR     ((D_IPUV_SYN_S_LINE2_ADDR_OUT_ADDR_MASK) << (D_IPUV_SYN_S_LINE2_ADDR_OUT_ADDR_LSB))


/* Field definitions for S_CURR_LINE0_LEN_INA */

#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_LENGTH_MSB (15)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_LENGTH_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_LENGTH ((D_IPUV_SYN_S_CURR_LINE0_LEN_INA_LENGTH_MASK) << (D_IPUV_SYN_S_CURR_LINE0_LEN_INA_LENGTH_LSB))

#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_Reserved_VALUE(x) (((x)&0x0000FFFF)<<16)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_Reserved_MSB (31)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_Reserved_LSB (16)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_Reserved_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INA_Reserved ((D_IPUV_SYN_S_CURR_LINE0_LEN_INA_Reserved_MASK) << (D_IPUV_SYN_S_CURR_LINE0_LEN_INA_Reserved_LSB))



/* Field definitions for S_CURR_CH0_CFG_INA */

#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_VAL ((D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_STEP_MSB (17)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_STEP_LSB (16)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_STEP_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_STEP   ((D_IPUV_SYN_S_CURR_CH0_CFG_INA_STEP_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_INA_STEP_LSB))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_RPT_MSB (19)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_RPT_LSB (18)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_RPT_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_RPT    ((D_IPUV_SYN_S_CURR_CH0_CFG_INA_RPT_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_INA_RPT_LSB))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_MODE_MSB (22)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_MODE_LSB (20)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_MODE ((D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_MODE_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_MODE_LSB))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REVERSE_VALUE(x) (((x)&0x00000001)<<23)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REVERSE_BIT (23)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REVERSE ((1) << (D_IPUV_SYN_S_CURR_CH0_CFG_INA_REVERSE_BIT))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_WIDTH ((D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_INA_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_TYPE_MSB (29)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_TYPE_LSB (28)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_TYPE_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_TYPE   ((D_IPUV_SYN_S_CURR_CH0_CFG_INA_TYPE_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_INA_TYPE_LSB))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_Reserved_VALUE(x) (((x)&0x00000003)<<30)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_Reserved_MSB (31)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_Reserved_LSB (30)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_Reserved_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INA_Reserved ((D_IPUV_SYN_S_CURR_CH0_CFG_INA_Reserved_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_INA_Reserved_LSB))



/* Field definitions for S_CURR_LINE0_ADDR_INA */

#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_ADDR_MSB (31)
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_ADDR_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_ADDR ((D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_ADDR_MASK) << (D_IPUV_SYN_S_CURR_LINE0_ADDR_INA_ADDR_LSB))



/* Field definitions for S_CURR_LINE1_LEN_INA */

#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA_LENGTH_MSB (15)
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA_LENGTH_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INA_LENGTH ((D_IPUV_SYN_S_CURR_LINE1_LEN_INA_LENGTH_MASK) << (D_IPUV_SYN_S_CURR_LINE1_LEN_INA_LENGTH_LSB))



/* Field definitions for S_CURR_CH1_CFG_INA */

#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_VAL ((D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_STEP_MSB (17)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_STEP_LSB (16)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_STEP_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_STEP   ((D_IPUV_SYN_S_CURR_CH1_CFG_INA_STEP_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_INA_STEP_LSB))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_RPT_MSB (19)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_RPT_LSB (18)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_RPT_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_RPT    ((D_IPUV_SYN_S_CURR_CH1_CFG_INA_RPT_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_INA_RPT_LSB))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_MODE_MSB (22)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_MODE_LSB (20)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_MODE ((D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_MODE_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_MODE_LSB))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_Reverse_VALUE(x) (((x)&0x00000001)<<23)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_Reverse_BIT (23)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_Reverse ((1) << (D_IPUV_SYN_S_CURR_CH1_CFG_INA_Reverse_BIT))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_WIDTH ((D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_INA_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_TYPE_MSB (29)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_TYPE_LSB (28)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_TYPE_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INA_TYPE   ((D_IPUV_SYN_S_CURR_CH1_CFG_INA_TYPE_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_INA_TYPE_LSB))



/* Field definitions for S_CURR_LINE1_ADDR_INA */

#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_ADDR_MSB (31)
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_ADDR_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_ADDR ((D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_ADDR_MASK) << (D_IPUV_SYN_S_CURR_LINE1_ADDR_INA_ADDR_LSB))



/* Field definitions for S_CURR_LINE2_LEN_INA */

#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA_LENGTH_MSB (15)
#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA_LENGTH_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_LINE2_LEN_INA_LENGTH ((D_IPUV_SYN_S_CURR_LINE2_LEN_INA_LENGTH_MASK) << (D_IPUV_SYN_S_CURR_LINE2_LEN_INA_LENGTH_LSB))



/* Field definitions for S_CURR_CH2_CFG_INA */

#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_VAL ((D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_STEP_MSB (17)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_STEP_LSB (16)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_STEP_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_STEP   ((D_IPUV_SYN_S_CURR_CH2_CFG_INA_STEP_MASK) << (D_IPUV_SYN_S_CURR_CH2_CFG_INA_STEP_LSB))

#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_RPT_MSB (19)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_RPT_LSB (18)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_RPT_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_RPT    ((D_IPUV_SYN_S_CURR_CH2_CFG_INA_RPT_MASK) << (D_IPUV_SYN_S_CURR_CH2_CFG_INA_RPT_LSB))

#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_MODE_MSB (22)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_MODE_LSB (20)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_MODE ((D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_MODE_MASK) << (D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_MODE_LSB))

#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_WIDTH ((D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CURR_CH2_CFG_INA_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_Reserved_VALUE(x) (((x)&0x00000001)<<27)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_Reserved_BIT (27)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_Reserved ((1) << (D_IPUV_SYN_S_CURR_CH2_CFG_INA_Reserved_BIT))

#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_TYPE_MSB (29)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_TYPE_LSB (28)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_TYPE_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH2_CFG_INA_TYPE   ((D_IPUV_SYN_S_CURR_CH2_CFG_INA_TYPE_MASK) << (D_IPUV_SYN_S_CURR_CH2_CFG_INA_TYPE_LSB))



/* Field definitions for S_CURR_LINE2_ADDR_INA */

#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_ADDR_MSB (31)
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_ADDR_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_ADDR ((D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_ADDR_MASK) << (D_IPUV_SYN_S_CURR_LINE2_ADDR_INA_ADDR_LSB))


/* Field definitions for S_CURR_LINE3_LEN_INA */

#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA_LENGTH_MSB (15)
#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA_LENGTH_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_LINE3_LEN_INA_LENGTH ((D_IPUV_SYN_S_CURR_LINE3_LEN_INA_LENGTH_MASK) << (D_IPUV_SYN_S_CURR_LINE3_LEN_INA_LENGTH_LSB))



/* Field definitions for S_CURR_CH3_CFG_INA */

#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_VAL ((D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_STEP_MSB (17)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_STEP_LSB (16)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_STEP_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_STEP   ((D_IPUV_SYN_S_CURR_CH3_CFG_INA_STEP_MASK) << (D_IPUV_SYN_S_CURR_CH3_CFG_INA_STEP_LSB))

#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_RPT_MSB (19)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_RPT_LSB (18)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_RPT_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_RPT    ((D_IPUV_SYN_S_CURR_CH3_CFG_INA_RPT_MASK) << (D_IPUV_SYN_S_CURR_CH3_CFG_INA_RPT_LSB))

#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_MODE_MSB (22)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_MODE_LSB (20)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_MODE ((D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_MODE_MASK) << (D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_MODE_LSB))

#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_WIDTH ((D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CURR_CH3_CFG_INA_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_Reserved_VALUE(x) (((x)&0x00000001)<<27)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_Reserved_BIT (27)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_Reserved ((1) << (D_IPUV_SYN_S_CURR_CH3_CFG_INA_Reserved_BIT))

#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_TYPE_MSB (29)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_TYPE_LSB (28)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_TYPE_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH3_CFG_INA_TYPE   ((D_IPUV_SYN_S_CURR_CH3_CFG_INA_TYPE_MASK) << (D_IPUV_SYN_S_CURR_CH3_CFG_INA_TYPE_LSB))



/* Field definitions for S_CURR_LINE3_ADDR_INA */

#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_ADDR_MSB (31)
#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_ADDR_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_ADDR ((D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_ADDR_MASK) << (D_IPUV_SYN_S_CURR_LINE3_ADDR_INA_ADDR_LSB))

/* Field definitions for S_CURR_LINE4_LEN_INA */

#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA_LENGTH_MSB (15)
#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA_LENGTH_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_LINE4_LEN_INA_LENGTH ((D_IPUV_SYN_S_CURR_LINE4_LEN_INA_LENGTH_MASK) << (D_IPUV_SYN_S_CURR_LINE4_LEN_INA_LENGTH_LSB))



/* Field definitions for S_CURR_CH4_CFG_INA */

#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_VAL ((D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_STEP_MSB (17)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_STEP_LSB (16)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_STEP_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_STEP   ((D_IPUV_SYN_S_CURR_CH4_CFG_INA_STEP_MASK) << (D_IPUV_SYN_S_CURR_CH4_CFG_INA_STEP_LSB))

#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_RPT_MSB (19)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_RPT_LSB (18)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_RPT_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_RPT    ((D_IPUV_SYN_S_CURR_CH4_CFG_INA_RPT_MASK) << (D_IPUV_SYN_S_CURR_CH4_CFG_INA_RPT_LSB))

#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_MODE_MSB (22)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_MODE_LSB (20)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_MODE ((D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_MODE_MASK) << (D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_MODE_LSB))

#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_WIDTH ((D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CURR_CH4_CFG_INA_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_Reserved_VALUE(x) (((x)&0x00000001)<<27)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_Reserved_BIT (27)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_Reserved ((1) << (D_IPUV_SYN_S_CURR_CH4_CFG_INA_Reserved_BIT))

#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_TYPE_MSB (29)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_TYPE_LSB (28)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_TYPE_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH4_CFG_INA_TYPE   ((D_IPUV_SYN_S_CURR_CH4_CFG_INA_TYPE_MASK) << (D_IPUV_SYN_S_CURR_CH4_CFG_INA_TYPE_LSB))


/* Field definitions for S_CURR_LINE4_ADDR_INA */

#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_ADDR_MSB (31)
#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_ADDR_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_ADDR ((D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_ADDR_MASK) << (D_IPUV_SYN_S_CURR_LINE4_ADDR_INA_ADDR_LSB))


/*To be compatible with backward version*/
/* Field definitions for S_CURR_LINE0_LEN_INB */

#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB_LENGTH_MSB (15)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB_LENGTH_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_INB_LENGTH ((D_IPUV_SYN_S_CURR_LINE0_LEN_INB_LENGTH_MASK) << (D_IPUV_SYN_S_CURR_LINE0_LEN_INB_LENGTH_LSB))



/* Field definitions for S_CURR_CH0_CFG_INB */

#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_VAL ((D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_STEP_MSB (17)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_STEP_LSB (16)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_STEP_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_STEP   ((D_IPUV_SYN_S_CURR_CH0_CFG_INB_STEP_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_INB_STEP_LSB))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_RPT_MSB (19)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_RPT_LSB (18)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_RPT_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_RPT    ((D_IPUV_SYN_S_CURR_CH0_CFG_INB_RPT_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_INB_RPT_LSB))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_MODE_MSB (22)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_MODE_LSB (20)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_MODE ((D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_MODE_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_MODE_LSB))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_WIDTH ((D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_INB_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_TYPE_MSB (29)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_TYPE_LSB (28)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_TYPE_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH0_CFG_INB_TYPE   ((D_IPUV_SYN_S_CURR_CH0_CFG_INB_TYPE_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_INB_TYPE_LSB))



/* Field definitions for S_CURR_LINE0_ADDR_INB */

#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_ADDR_MSB (31)
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_ADDR_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_ADDR ((D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_ADDR_MASK) << (D_IPUV_SYN_S_CURR_LINE0_ADDR_INB_ADDR_LSB))



/* Field definitions for S_CURR_LINE1_LEN_INB */

#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB_LENGTH_MSB (15)
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB_LENGTH_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_LINE1_LEN_INB_LENGTH ((D_IPUV_SYN_S_CURR_LINE1_LEN_INB_LENGTH_MASK) << (D_IPUV_SYN_S_CURR_LINE1_LEN_INB_LENGTH_LSB))



/* Field definitions for S_CURR_CH1_CFG_INB */

#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_VAL_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_VAL_MSB (15)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_VAL_LSB (0)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_VAL_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_VAL ((D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_VAL_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_VAL_LSB))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_STEP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_STEP_MSB (17)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_STEP_LSB (16)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_STEP_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_STEP   ((D_IPUV_SYN_S_CURR_CH1_CFG_INB_STEP_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_INB_STEP_LSB))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_RPT_VALUE(x) (((x)&0x00000003)<<18)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_RPT_MSB (19)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_RPT_LSB (18)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_RPT_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_RPT    ((D_IPUV_SYN_S_CURR_CH1_CFG_INB_RPT_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_INB_RPT_LSB))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPEAT_MODE_VALUE(x) (((x)&0x00000007)<<20)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPEAT_MODE_MSB (22)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPEAT_MODE_LSB (20)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPEAT_MODE_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPEAT_MODE ((D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPEAT_MODE_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPEAT_MODE_LSB))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_WIDTH_VALUE(x) (((x)&0x00000007)<<24)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_WIDTH_MSB (26)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_WIDTH_LSB (24)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_WIDTH_MASK (0x00000007)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_WIDTH ((D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_WIDTH_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_INB_REPLACE_WIDTH_LSB))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_TYPE_MSB (29)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_TYPE_LSB (28)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_TYPE_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_TYPE   ((D_IPUV_SYN_S_CURR_CH1_CFG_INB_TYPE_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_INB_TYPE_LSB))

#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_Reserved_VALUE(x) (((x)&0x00000003)<<30)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_Reserved_MSB (31)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_Reserved_LSB (30)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_Reserved_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH1_CFG_INB_Reserved ((D_IPUV_SYN_S_CURR_CH1_CFG_INB_Reserved_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_INB_Reserved_LSB))



/* Field definitions for S_CURR_LINE1_ADDR_INB */

#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_ADDR_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_ADDR_MSB (31)
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_ADDR_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_ADDR_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_ADDR ((D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_ADDR_MASK) << (D_IPUV_SYN_S_CURR_LINE1_ADDR_INB_ADDR_LSB))
/******************End******************************/

/* Field definitions for S_CURR_LINE0_LEN_OUT */

#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_LENGTH_MSB (15)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_LENGTH_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_LENGTH ((D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_LENGTH_MASK) << (D_IPUV_SYN_S_CURR_LINE0_LEN_OUT_LENGTH_LSB))



/* Field definitions for S_CURR_CH0_CFG_OUT */

#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_SKIP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_SKIP_MSB (17)
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_SKIP_LSB (16)
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_SKIP_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_SKIP   ((D_IPUV_SYN_S_CURR_CH0_CFG_OUT_SKIP_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_OUT_SKIP_LSB))

#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_TYPE_MSB (29)
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_TYPE_LSB (28)
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_TYPE_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH0_CFG_OUT_TYPE   ((D_IPUV_SYN_S_CURR_CH0_CFG_OUT_TYPE_MASK) << (D_IPUV_SYN_S_CURR_CH0_CFG_OUT_TYPE_LSB))



/* Field definitions for S_CURR_LINE0_ADDR_OUT */

#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_ADDR_VALUE(x) (((x)&0x1FFFFFFF)<<3)
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_ADDR_MSB (31)
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_ADDR_LSB (3)
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_ADDR_MASK (0x1FFFFFFF)
#define D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_ADDR ((D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_ADDR_MASK) << (D_IPUV_SYN_S_CURR_LINE0_ADDR_OUT_ADDR_LSB))



/* Field definitions for S_CURR_LINE1_LEN_OUT */

#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_LENGTH_MSB (15)
#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_LENGTH_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_LENGTH ((D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_LENGTH_MASK) << (D_IPUV_SYN_S_CURR_LINE1_LEN_OUT_LENGTH_LSB))



/* Field definitions for S_CURR_CH1_CFG_OUT */

#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_SKIP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_SKIP_MSB (17)
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_SKIP_LSB (16)
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_SKIP_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_SKIP   ((D_IPUV_SYN_S_CURR_CH1_CFG_OUT_SKIP_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_OUT_SKIP_LSB))

#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_TYPE_MSB (29)
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_TYPE_LSB (28)
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_TYPE_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH1_CFG_OUT_TYPE   ((D_IPUV_SYN_S_CURR_CH1_CFG_OUT_TYPE_MASK) << (D_IPUV_SYN_S_CURR_CH1_CFG_OUT_TYPE_LSB))



/* Field definitions for S_CURR_LINE1_ADDR_OUT */

#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_ADDR_VALUE(x) (((x)&0x1FFFFFFF)<<3)
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_ADDR_MSB (31)
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_ADDR_LSB (3)
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_ADDR_MASK (0x1FFFFFFF)
#define D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_ADDR ((D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_ADDR_MASK) << (D_IPUV_SYN_S_CURR_LINE1_ADDR_OUT_ADDR_LSB))



/* Field definitions for S_CURR_LINE2_LEN_OUT */

#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_LENGTH_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_LENGTH_MSB (15)
#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_LENGTH_LSB (0)
#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_LENGTH_MASK (0x0000FFFF)
#define D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_LENGTH ((D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_LENGTH_MASK) << (D_IPUV_SYN_S_CURR_LINE2_LEN_OUT_LENGTH_LSB))



/* Field definitions for S_CURR_CH2_CFG_OUT */

#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_SKIP_VALUE(x) (((x)&0x00000003)<<16)
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_SKIP_MSB (17)
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_SKIP_LSB (16)
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_SKIP_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_SKIP   ((D_IPUV_SYN_S_CURR_CH2_CFG_OUT_SKIP_MASK) << (D_IPUV_SYN_S_CURR_CH2_CFG_OUT_SKIP_LSB))

#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_Reserved_VALUE(x) (((x)&0x00000003)<<30)
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_Reserved_MSB (31)
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_Reserved_LSB (30)
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_Reserved_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_Reserved ((D_IPUV_SYN_S_CURR_CH2_CFG_OUT_Reserved_MASK) << (D_IPUV_SYN_S_CURR_CH2_CFG_OUT_Reserved_LSB))

#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_TYPE_VALUE(x) (((x)&0x00000003)<<28)
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_TYPE_MSB (29)
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_TYPE_LSB (28)
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_TYPE_MASK (0x00000003)
#define D_IPUV_SYN_S_CURR_CH2_CFG_OUT_TYPE   ((D_IPUV_SYN_S_CURR_CH2_CFG_OUT_TYPE_MASK) << (D_IPUV_SYN_S_CURR_CH2_CFG_OUT_TYPE_LSB))



/* Field definitions for S_CURR_LINE2_ADDR_OUT */

#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_ADDR_VALUE(x) (((x)&0x1FFFFFFF)<<3)
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_ADDR_MSB (31)
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_ADDR_LSB (3)
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_ADDR_MASK (0x1FFFFFFF)
#define D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_ADDR ((D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_ADDR_MASK) << (D_IPUV_SYN_S_CURR_LINE2_ADDR_OUT_ADDR_LSB))



/* Field definitions for DEBUG_MS */

#define D_IPUV_SYN_DEBUG_MS_DBG_ACT_VALUE(x) (((x)&0x00000001)<<0)
#define D_IPUV_SYN_DEBUG_MS_DBG_ACT_BIT      (0)
#define D_IPUV_SYN_DEBUG_MS_DBG_ACT          ((1) << (D_IPUV_SYN_DEBUG_MS_DBG_ACT_BIT))

#define D_IPUV_SYN_DEBUG_MS_STEP_VALUE(x)    (((x)&0x0000000F)<<16)
#define D_IPUV_SYN_DEBUG_MS_STEP_MSB         (19)
#define D_IPUV_SYN_DEBUG_MS_STEP_LSB         (16)
#define D_IPUV_SYN_DEBUG_MS_STEP_MASK        (0x0000000F)
#define D_IPUV_SYN_DEBUG_MS_STEP             ((D_IPUV_SYN_DEBUG_MS_STEP_MASK) << (D_IPUV_SYN_DEBUG_MS_STEP_LSB))

#define D_IPUV_SYN_DEBUG_MS_B_XPOS_VALUE(x)  (((x)&0x00000001)<<25)
#define D_IPUV_SYN_DEBUG_MS_B_XPOS_BIT       (25)
#define D_IPUV_SYN_DEBUG_MS_B_XPOS           ((1) << (D_IPUV_SYN_DEBUG_MS_B_XPOS_BIT))

#define D_IPUV_SYN_DEBUG_MS_B_YPOS_VALUE(x)  (((x)&0x00000001)<<26)
#define D_IPUV_SYN_DEBUG_MS_B_YPOS_BIT       (26)
#define D_IPUV_SYN_DEBUG_MS_B_YPOS           ((1) << (D_IPUV_SYN_DEBUG_MS_B_YPOS_BIT))

#define D_IPUV_SYN_DEBUG_MS_B_POS_VALUE(x)   (((x)&0x00000001)<<27)
#define D_IPUV_SYN_DEBUG_MS_B_POS_BIT        (27)
#define D_IPUV_SYN_DEBUG_MS_B_POS            ((1) << (D_IPUV_SYN_DEBUG_MS_B_POS_BIT))

#define D_IPUV_SYN_DEBUG_MS_B_IADDR_VALUE(x) (((x)&0x00000001)<<28)
#define D_IPUV_SYN_DEBUG_MS_B_IADDR_BIT      (28)
#define D_IPUV_SYN_DEBUG_MS_B_IADDR          ((1) << (D_IPUV_SYN_DEBUG_MS_B_IADDR_BIT))

#define D_IPUV_SYN_DEBUG_MS_B_RADDR_VALUE(x) (((x)&0x00000001)<<29)
#define D_IPUV_SYN_DEBUG_MS_B_RADDR_BIT      (29)
#define D_IPUV_SYN_DEBUG_MS_B_RADDR          ((1) << (D_IPUV_SYN_DEBUG_MS_B_RADDR_BIT))

#define D_IPUV_SYN_DEBUG_MS_B_WADDR_VALUE(x) (((x)&0x00000001)<<30)
#define D_IPUV_SYN_DEBUG_MS_B_WADDR_BIT      (30)
#define D_IPUV_SYN_DEBUG_MS_B_WADDR          ((1) << (D_IPUV_SYN_DEBUG_MS_B_WADDR_BIT))

#define D_IPUV_SYN_DEBUG_MS_B_FINISH_VALUE(x) (((x)&0x00000001)<<31)
#define D_IPUV_SYN_DEBUG_MS_B_FINISH_BIT     (31)
#define D_IPUV_SYN_DEBUG_MS_B_FINISH         ((1) << (D_IPUV_SYN_DEBUG_MS_B_FINISH_BIT))



/* Field definitions for DEBUG_BKPT_STAT */

#define D_IPUV_SYN_DEBUG_BKPT_STAT_H_DBG_VALUE(x) (((x)&0x00000001)<<0)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_H_DBG_BIT (0)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_H_DBG     ((1) << (D_IPUV_SYN_DEBUG_BKPT_STAT_H_DBG_BIT))

#define D_IPUV_SYN_DEBUG_BKPT_STAT_DBG_VALUE(x) (((x)&0x00000001)<<16)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_DBG_BIT   (16)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_DBG       ((1) << (D_IPUV_SYN_DEBUG_BKPT_STAT_DBG_BIT))

#define D_IPUV_SYN_DEBUG_BKPT_STAT_XPOS_VALUE(x) (((x)&0x00000001)<<17)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_XPOS_BIT  (17)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_XPOS      ((1) << (D_IPUV_SYN_DEBUG_BKPT_STAT_XPOS_BIT))

#define D_IPUV_SYN_DEBUG_BKPT_STAT_YPOS_VALUE(x) (((x)&0x00000001)<<18)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_YPOS_BIT  (18)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_YPOS      ((1) << (D_IPUV_SYN_DEBUG_BKPT_STAT_YPOS_BIT))

#define D_IPUV_SYN_DEBUG_BKPT_STAT_POS_VALUE(x) (((x)&0x00000001)<<19)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_POS_BIT   (19)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_POS       ((1) << (D_IPUV_SYN_DEBUG_BKPT_STAT_POS_BIT))

#define D_IPUV_SYN_DEBUG_BKPT_STAT_IADDR_VALUE(x) (((x)&0x00000001)<<20)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_IADDR_BIT (20)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_IADDR     ((1) << (D_IPUV_SYN_DEBUG_BKPT_STAT_IADDR_BIT))

#define D_IPUV_SYN_DEBUG_BKPT_STAT_RADDR_VALUE(x) (((x)&0x00000001)<<21)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_RADDR_BIT (21)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_RADDR     ((1) << (D_IPUV_SYN_DEBUG_BKPT_STAT_RADDR_BIT))

#define D_IPUV_SYN_DEBUG_BKPT_STAT_WADDR_VALUE(x) (((x)&0x00000001)<<22)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_WADDR_BIT (22)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_WADDR     ((1) << (D_IPUV_SYN_DEBUG_BKPT_STAT_WADDR_BIT))

#define D_IPUV_SYN_DEBUG_BKPT_STAT_FINISH_VALUE(x) (((x)&0x00000001)<<23)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_FINISH_BIT (23)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_FINISH    ((1) << (D_IPUV_SYN_DEBUG_BKPT_STAT_FINISH_BIT))

#define D_IPUV_SYN_DEBUG_BKPT_STAT_DI_VALUE(x) (((x)&0x00000001)<<24)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_DI_BIT    (24)
#define D_IPUV_SYN_DEBUG_BKPT_STAT_DI        ((1) << (D_IPUV_SYN_DEBUG_BKPT_STAT_DI_BIT))



/* Field definitions for DEBUG_BKPT_POS */

#define D_IPUV_SYN_DEBUG_BKPT_POS_YPOS_VALUE(x) (((x)&0x0000FFFF)<<0)
#define D_IPUV_SYN_DEBUG_BKPT_POS_YPOS_MSB   (15)
#define D_IPUV_SYN_DEBUG_BKPT_POS_YPOS_LSB   (0)
#define D_IPUV_SYN_DEBUG_BKPT_POS_YPOS_MASK  (0x0000FFFF)
#define D_IPUV_SYN_DEBUG_BKPT_POS_YPOS       ((D_IPUV_SYN_DEBUG_BKPT_POS_YPOS_MASK) << (D_IPUV_SYN_DEBUG_BKPT_POS_YPOS_LSB))

#define D_IPUV_SYN_DEBUG_BKPT_POS_XPOS_VALUE(x) (((x)&0x0000FFFF)<<16)
#define D_IPUV_SYN_DEBUG_BKPT_POS_XPOS_MSB   (31)
#define D_IPUV_SYN_DEBUG_BKPT_POS_XPOS_LSB   (16)
#define D_IPUV_SYN_DEBUG_BKPT_POS_XPOS_MASK  (0x0000FFFF)
#define D_IPUV_SYN_DEBUG_BKPT_POS_XPOS       ((D_IPUV_SYN_DEBUG_BKPT_POS_XPOS_MASK) << (D_IPUV_SYN_DEBUG_BKPT_POS_XPOS_LSB))



/* Field definitions for DEBUG_BKPT_ADDR */

#define D_IPUV_SYN_DEBUG_BKPT_ADDR_DWADDR_VALUE(x) (((x)&0x000000FF)<<8)
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_DWADDR_MSB (15)
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_DWADDR_LSB (8)
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_DWADDR_MASK (0x000000FF)
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_DWADDR    ((D_IPUV_SYN_DEBUG_BKPT_ADDR_DWADDR_MASK) << (D_IPUV_SYN_DEBUG_BKPT_ADDR_DWADDR_LSB))

#define D_IPUV_SYN_DEBUG_BKPT_ADDR_DRADDR_VALUE(x) (((x)&0x000000FF)<<16)
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_DRADDR_MSB (23)
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_DRADDR_LSB (16)
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_DRADDR_MASK (0x000000FF)
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_DRADDR    ((D_IPUV_SYN_DEBUG_BKPT_ADDR_DRADDR_MASK) << (D_IPUV_SYN_DEBUG_BKPT_ADDR_DRADDR_LSB))

#define D_IPUV_SYN_DEBUG_BKPT_ADDR_IADDR_VALUE(x) (((x)&0x000000FF)<<24)
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_IADDR_MSB (31)
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_IADDR_LSB (24)
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_IADDR_MASK (0x000000FF)
#define D_IPUV_SYN_DEBUG_BKPT_ADDR_IADDR     ((D_IPUV_SYN_DEBUG_BKPT_ADDR_IADDR_MASK) << (D_IPUV_SYN_DEBUG_BKPT_ADDR_IADDR_LSB))



/* Field definitions for DEBUG_DI */

#define D_IPUV_SYN_DEBUG_DI_INSTR_VALUE(x)   (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_DEBUG_DI_INSTR_MSB        (31)
#define D_IPUV_SYN_DEBUG_DI_INSTR_LSB        (0)
#define D_IPUV_SYN_DEBUG_DI_INSTR_MASK       (0xFFFFFFFF)
#define D_IPUV_SYN_DEBUG_DI_INSTR            ((D_IPUV_SYN_DEBUG_DI_INSTR_MASK) << (D_IPUV_SYN_DEBUG_DI_INSTR_LSB))



/* Field definitions for DEBUG_CORE_STAT */

#define D_IPUV_SYN_DEBUG_CORE_STAT_PC_VALUE(x) (((x)&0x000000FF)<<0)
#define D_IPUV_SYN_DEBUG_CORE_STAT_PC_MSB    (7)
#define D_IPUV_SYN_DEBUG_CORE_STAT_PC_LSB    (0)
#define D_IPUV_SYN_DEBUG_CORE_STAT_PC_MASK   (0x000000FF)
#define D_IPUV_SYN_DEBUG_CORE_STAT_PC        ((D_IPUV_SYN_DEBUG_CORE_STAT_PC_MASK) << (D_IPUV_SYN_DEBUG_CORE_STAT_PC_LSB))

#define D_IPUV_SYN_DEBUG_CORE_STAT_OV_VALUE(x) (((x)&0x00000001)<<24)
#define D_IPUV_SYN_DEBUG_CORE_STAT_OV_BIT    (24)
#define D_IPUV_SYN_DEBUG_CORE_STAT_OV        ((1) << (D_IPUV_SYN_DEBUG_CORE_STAT_OV_BIT))

#define D_IPUV_SYN_DEBUG_CORE_STAT_C_VALUE(x) (((x)&0x00000001)<<25)
#define D_IPUV_SYN_DEBUG_CORE_STAT_C_BIT     (25)
#define D_IPUV_SYN_DEBUG_CORE_STAT_C         ((1) << (D_IPUV_SYN_DEBUG_CORE_STAT_C_BIT))

#define D_IPUV_SYN_DEBUG_CORE_STAT_Z_VALUE(x) (((x)&0x00000001)<<26)
#define D_IPUV_SYN_DEBUG_CORE_STAT_Z_BIT     (26)
#define D_IPUV_SYN_DEBUG_CORE_STAT_Z         ((1) << (D_IPUV_SYN_DEBUG_CORE_STAT_Z_BIT))

#define D_IPUV_SYN_DEBUG_CORE_STAT_N_VALUE(x) (((x)&0x00000001)<<27)
#define D_IPUV_SYN_DEBUG_CORE_STAT_N_BIT     (27)
#define D_IPUV_SYN_DEBUG_CORE_STAT_N         ((1) << (D_IPUV_SYN_DEBUG_CORE_STAT_N_BIT))



/* Field definitions for PMONITOR_CTRL */

#define D_IPUV_SYN_PMONITOR_CTRL_EN_S_SIN_VALUE(x) (((x)&0x00000001)<<0)
#define D_IPUV_SYN_PMONITOR_CTRL_EN_S_SIN_BIT (0)
#define D_IPUV_SYN_PMONITOR_CTRL_EN_S_SIN    ((1) << (D_IPUV_SYN_PMONITOR_CTRL_EN_S_SIN_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_EN_S_SOUT_VALUE(x) (((x)&0x00000001)<<1)
#define D_IPUV_SYN_PMONITOR_CTRL_EN_S_SOUT_BIT (1)
#define D_IPUV_SYN_PMONITOR_CTRL_EN_S_SOUT   ((1) << (D_IPUV_SYN_PMONITOR_CTRL_EN_S_SOUT_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_EN_S_SINOUT_VALUE(x) (((x)&0x00000001)<<2)
#define D_IPUV_SYN_PMONITOR_CTRL_EN_S_SINOUT_BIT (2)
#define D_IPUV_SYN_PMONITOR_CTRL_EN_S_SINOUT ((1) << (D_IPUV_SYN_PMONITOR_CTRL_EN_S_SINOUT_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_EN_S_DH_VALUE(x) (((x)&0x00000001)<<3)
#define D_IPUV_SYN_PMONITOR_CTRL_EN_S_DH_BIT (3)
#define D_IPUV_SYN_PMONITOR_CTRL_EN_S_DH     ((1) << (D_IPUV_SYN_PMONITOR_CTRL_EN_S_DH_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_EN_EX_CNT_VALUE(x) (((x)&0x00000001)<<4)
#define D_IPUV_SYN_PMONITOR_CTRL_EN_EX_CNT_BIT (4)
#define D_IPUV_SYN_PMONITOR_CTRL_EN_EX_CNT   ((1) << (D_IPUV_SYN_PMONITOR_CTRL_EN_EX_CNT_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_STOP_S_SIN_VALUE(x) (((x)&0x00000001)<<8)
#define D_IPUV_SYN_PMONITOR_CTRL_STOP_S_SIN_BIT (8)
#define D_IPUV_SYN_PMONITOR_CTRL_STOP_S_SIN  ((1) << (D_IPUV_SYN_PMONITOR_CTRL_STOP_S_SIN_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_STOP_S_SOUT_VALUE(x) (((x)&0x00000001)<<9)
#define D_IPUV_SYN_PMONITOR_CTRL_STOP_S_SOUT_BIT (9)
#define D_IPUV_SYN_PMONITOR_CTRL_STOP_S_SOUT ((1) << (D_IPUV_SYN_PMONITOR_CTRL_STOP_S_SOUT_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_STOP_S_SINOUT_VALUE(x) (((x)&0x00000001)<<10)
#define D_IPUV_SYN_PMONITOR_CTRL_STOP_S_SINOUT_BIT (10)
#define D_IPUV_SYN_PMONITOR_CTRL_STOP_S_SINOUT ((1) << (D_IPUV_SYN_PMONITOR_CTRL_STOP_S_SINOUT_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_STOP_S_DH_VALUE(x) (((x)&0x00000001)<<11)
#define D_IPUV_SYN_PMONITOR_CTRL_STOP_S_DH_BIT (11)
#define D_IPUV_SYN_PMONITOR_CTRL_STOP_S_DH   ((1) << (D_IPUV_SYN_PMONITOR_CTRL_STOP_S_DH_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_STOP_EX_CNT_VALUE(x) (((x)&0x00000001)<<12)
#define D_IPUV_SYN_PMONITOR_CTRL_STOP_EX_CNT_BIT (12)
#define D_IPUV_SYN_PMONITOR_CTRL_STOP_EX_CNT ((1) << (D_IPUV_SYN_PMONITOR_CTRL_STOP_EX_CNT_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_INIT_S_SIN_VALUE(x) (((x)&0x00000001)<<16)
#define D_IPUV_SYN_PMONITOR_CTRL_INIT_S_SIN_BIT (16)
#define D_IPUV_SYN_PMONITOR_CTRL_INIT_S_SIN  ((1) << (D_IPUV_SYN_PMONITOR_CTRL_INIT_S_SIN_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_INIT_S_SOUT_VALUE(x) (((x)&0x00000001)<<17)
#define D_IPUV_SYN_PMONITOR_CTRL_INIT_S_SOUT_BIT (17)
#define D_IPUV_SYN_PMONITOR_CTRL_INIT_S_SOUT ((1) << (D_IPUV_SYN_PMONITOR_CTRL_INIT_S_SOUT_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_INIT_S_SINOUT_VALUE(x) (((x)&0x00000001)<<18)
#define D_IPUV_SYN_PMONITOR_CTRL_INIT_S_SINOUT_BIT (18)
#define D_IPUV_SYN_PMONITOR_CTRL_INIT_S_SINOUT ((1) << (D_IPUV_SYN_PMONITOR_CTRL_INIT_S_SINOUT_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_INIT_S_DH_VALUE(x) (((x)&0x00000001)<<19)
#define D_IPUV_SYN_PMONITOR_CTRL_INIT_S_DH_BIT (19)
#define D_IPUV_SYN_PMONITOR_CTRL_INIT_S_DH   ((1) << (D_IPUV_SYN_PMONITOR_CTRL_INIT_S_DH_BIT))

#define D_IPUV_SYN_PMONITOR_CTRL_INIT_EX_CNT_VALUE(x) (((x)&0x00000001)<<20)
#define D_IPUV_SYN_PMONITOR_CTRL_INIT_EX_CNT_BIT (20)
#define D_IPUV_SYN_PMONITOR_CTRL_INIT_EX_CNT ((1) << (D_IPUV_SYN_PMONITOR_CTRL_INIT_EX_CNT_BIT))



/* Field definitions for PMONITOR_SAMPLE */

#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_SIN_VALUE(x) (((x)&0x00000001)<<0)
#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_SIN_BIT (0)
#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_SIN ((1) << (D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_SIN_BIT))

#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_SOUT_VALUE(x) (((x)&0x00000001)<<1)
#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_SOUT_BIT (1)
#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_SOUT ((1) << (D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_SOUT_BIT))

#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_SINOUT_VALUE(x) (((x)&0x00000001)<<2)
#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_SINOUT_BIT (2)
#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_SINOUT ((1) << (D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_SINOUT_BIT))

#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_DH_VALUE(x) (((x)&0x00000001)<<3)
#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_DH_BIT (3)
#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_DH ((1) << (D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_S_DH_BIT))

#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_EX_CNT_VALUE(x) (((x)&0x00000001)<<4)
#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_EX_CNT_BIT (4)
#define D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_EX_CNT ((1) << (D_IPUV_SYN_PMONITOR_SAMPLE_SAMPLE_EX_CNT_BIT))



/* Field definitions for STALL_STREAMIN */

#define D_IPUV_SYN_STALL_STREAMIN_STALLS_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_STALL_STREAMIN_STALLS_MSB (31)
#define D_IPUV_SYN_STALL_STREAMIN_STALLS_LSB (0)
#define D_IPUV_SYN_STALL_STREAMIN_STALLS_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_STALL_STREAMIN_STALLS     ((D_IPUV_SYN_STALL_STREAMIN_STALLS_MASK) << (D_IPUV_SYN_STALL_STREAMIN_STALLS_LSB))



/* Field definitions for STALL_STREAMOUT */

#define D_IPUV_SYN_STALL_STREAMOUT_STALLS_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_STALL_STREAMOUT_STALLS_MSB (31)
#define D_IPUV_SYN_STALL_STREAMOUT_STALLS_LSB (0)
#define D_IPUV_SYN_STALL_STREAMOUT_STALLS_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_STALL_STREAMOUT_STALLS    ((D_IPUV_SYN_STALL_STREAMOUT_STALLS_MASK) << (D_IPUV_SYN_STALL_STREAMOUT_STALLS_LSB))



/* Field definitions for STALL_STREAMINOUT */

#define D_IPUV_SYN_STALL_STREAMINOUT_STALLS_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_STALL_STREAMINOUT_STALLS_MSB (31)
#define D_IPUV_SYN_STALL_STREAMINOUT_STALLS_LSB (0)
#define D_IPUV_SYN_STALL_STREAMINOUT_STALLS_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_STALL_STREAMINOUT_STALLS  ((D_IPUV_SYN_STALL_STREAMINOUT_STALLS_MASK) << (D_IPUV_SYN_STALL_STREAMINOUT_STALLS_LSB))



/* Field definitions for STALL_DATAHAZARD */

#define D_IPUV_SYN_STALL_DATAHAZARD_STALLS_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_STALL_DATAHAZARD_STALLS_MSB (31)
#define D_IPUV_SYN_STALL_DATAHAZARD_STALLS_LSB (0)
#define D_IPUV_SYN_STALL_DATAHAZARD_STALLS_MASK (0xFFFFFFFF)
#define D_IPUV_SYN_STALL_DATAHAZARD_STALLS   ((D_IPUV_SYN_STALL_DATAHAZARD_STALLS_MASK) << (D_IPUV_SYN_STALL_DATAHAZARD_STALLS_LSB))



/* Field definitions for EXEC_COUNTER */

#define D_IPUV_SYN_EXEC_COUNTER_CYCLES_VALUE(x) (((x)&0xFFFFFFFF)<<0)
#define D_IPUV_SYN_EXEC_COUNTER_CYCLES_MSB   (31)
#define D_IPUV_SYN_EXEC_COUNTER_CYCLES_LSB   (0)
#define D_IPUV_SYN_EXEC_COUNTER_CYCLES_MASK  (0xFFFFFFFF)
#define D_IPUV_SYN_EXEC_COUNTER_CYCLES       ((D_IPUV_SYN_EXEC_COUNTER_CYCLES_MASK) << (D_IPUV_SYN_EXEC_COUNTER_CYCLES_LSB))



/* Field definitions for RESET_REG */

#define D_IPUV_SYN_RESET_REG_SOFT_RESET_VALUE(x) (((x)&0x00000001)<<0)
#define D_IPUV_SYN_RESET_REG_SOFT_RESET_BIT  (0)
#define D_IPUV_SYN_RESET_REG_SOFT_RESET      ((1) << (D_IPUV_SYN_RESET_REG_SOFT_RESET_BIT))

#define D_IPUV_SYN_RESET_REG_HARD_RESET_VALUE(x) (((x)&0x00000001)<<1)
#define D_IPUV_SYN_RESET_REG_HARD_RESET_BIT  (1)
#define D_IPUV_SYN_RESET_REG_HARD_RESET      ((1) << (D_IPUV_SYN_RESET_REG_HARD_RESET_BIT))

#endif /* IPUVMEMMAP_H */

