/**************************************************************************
 * FILE NAME: S32S247TV.h                                                 *
 * REVISION:  1.13                                                        *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the S32S247TV.                                                         *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
 * ---   -----------  ---------    ---------------------                  *
 * 1.0   Mihai Volmer 25-Aug-17    Initial release based                  *
 *                                 on RM rev.1 DraftB                     *
 *                                                                        *
 * 1.1   Mihai Volmer 10-Nov-17    Updated the header file based          *
 *                                 on RM rev.1 DraftC                     *
 *                                                                        *
 * 1.2   Mihai Volmer 17-Nov-17    Temporarily removed the                *
 *                                 PCIe peripherals                       *
 *                                                                        *
 * 1.3   Mihai Volmer 03-Jan-18    Updated the header file based          *
 *                                 on RM rev.1 DraftD                     *
 *                                                                        *
 * 1.4   Mihai Volmer 16-Mar-18    Updated the header file based          *
 *                                 on RM rev.1 DraftF                     *
 *                                                                        *
 * 1.5   Taru Shree   22-June-18   Generated the header file based        *
 *                                 on RM rev.1 DraftH                     *
 *                                                                        *
 * 1.6   Taru Shree   02-Aug-18    Generated the header file based        *
 *                                 on RM rev.1 DraftI                     *
 *                                                                        *
 * 1.7   Taru Shree   27-Aug-18    Generated the header file based        *
 *                                 on RM rev.1 DraftK                     *
 *                                                                        *
 * 1.8   Taru Shree   17-Oct-18    Generated the header file based        *
 *                                 on RM rev.1 DraftL                     *
 *                                                                        *
 * 1.9   Taru Shree   25-Oct-18    MDM_AP registers were updated          *
 *                                                                        *
 * 1.10  Taru Shree   13-Nov-18    Name changed from S32S247(cut 0.8)     *
 *                                 to S32S247TV                           *
 *                                                                        *
 * 1.11  Taru Shree   06-Feb-19    Initial release based on               *
 *                                 RM rev.1 DraftO                        *
 *                                                                        *
 * 1.12  Taru Shree   06-March-19  1)Representation of few registers in   *
 *                                 following blocks is changed(in arrays)-*
 *								   EMIOS,ETIMER,PSI5_S,SBSW,SRX,TMU,      *
 *                                 MC_CGM and XRDC.                       *
 *                                 2)All internal blocks are removed.     *
 *                                 3)OFF-CC & ON-CC NOCs are included.    *
 *                                                                        *
 * 1.13  Taru Shree   07-March-19  OFF-CC & ON-CC NOCs are removed.       *
 *                                                                        *
 *========================================================================*
 * Copyright 2013-2016 Freescale Semiconductor, Inc.                      *
 * Copyright 2016-2019 NXP                                                *
 *                                                                        *
 *  THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR         *****
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES *
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.   *
 *  IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,       *
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES        *
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR        *
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)        *
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,       *
 *  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING     *
 *  IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF            *
 *  THE POSSIBILITY OF SUCH DAMAGE.                                           *
 *                                                                        *****
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _S32S247TV_H_
#define _S32S247TV_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif
#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wpedantic"
#endif


/* ============================================================================
   =============================== Module: AIPS_LITE ==========================
   ============================================================================ */

typedef union AIPS_LITE_MPRA_union_tag { /* Master Privilege Register A */
  vuint32_t R;
  struct {
    vuint32_t MPL7:1;                  /* Master 7 Privilege Level */
    vuint32_t MTW7:1;                  /* Master 7 Trusted for Writes */
    vuint32_t MTR7:1;                  /* Master 7 Trusted for Read */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t MPL6:1;                  /* Master 6 Privilege Level */
    vuint32_t MTW6:1;                  /* Master 6 Trusted for Writes */
    vuint32_t MTR6:1;                  /* Master 6 Trusted for Read */
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t MPL5:1;                  /* Master 5 Privilege Level */
    vuint32_t MTW5:1;                  /* Master 5 Trusted For Writes */
    vuint32_t MTR5:1;                  /* Master 5 Trusted For Read */
    vuint32_t _unused_11:1;            /* Reserved */
    vuint32_t MPL4:1;                  /* Master 4 Privilege Level */
    vuint32_t MTW4:1;                  /* Master 4 Trusted For Writes */
    vuint32_t MTR4:1;                  /* Master 4 Trusted For Read */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t MPL3:1;                  /* Master 3 Privilege Level */
    vuint32_t MTW3:1;                  /* Master 3 Trusted For Writes */
    vuint32_t MTR3:1;                  /* Master 3 Trusted For Read */
    vuint32_t _unused_19:1;            /* Reserved */
    vuint32_t MPL2:1;                  /* Master 2 Privilege Level */
    vuint32_t MTW2:1;                  /* Master 2 Trusted For Writes */
    vuint32_t MTR2:1;                  /* Master 2 Trusted For Read */
    vuint32_t _unused_23:1;            /* Reserved */
    vuint32_t MPL1:1;                  /* Master 1 Privilege Level */
    vuint32_t MTW1:1;                  /* Master 1 Trusted for Writes */
    vuint32_t MTR1:1;                  /* Master 1 Trusted for Read */
    vuint32_t _unused_27:1;            /* Reserved */
    vuint32_t MPL0:1;                  /* Master 0 Privilege Level */
    vuint32_t MTW0:1;                  /* Master 0 Trusted For Writes */
    vuint32_t MTR0:1;                  /* Master 0 Trusted For Read */
    vuint32_t _unused_31:1;            /* Reserved */
  } B;
} AIPS_LITE_MPRA_tag;

typedef union AIPS_LITE_PACRA_union_tag { /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* Reserved */
    vuint32_t _unused_4:4;             /* Reserved */
    vuint32_t _unused_8:4;             /* Reserved */
    vuint32_t _unused_12:4;            /* Reserved */
    vuint32_t _unused_16:4;            /* Reserved */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t _unused_23:1;            /* Reserved */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t _unused_27:1;            /* Reserved */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t _unused_31:1;            /* Reserved */
  } B;
} AIPS_LITE_PACRA_tag;

typedef union AIPS_LITE_OPACRA_union_tag { /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t TP7:1;                   /* Trusted Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t _unused_11:1;            /* Reserved */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t _unused_19:1;            /* Reserved */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t _unused_23:1;            /* Reserved */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t _unused_27:1;            /* Reserved */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t _unused_31:1;            /* Reserved */
  } B;
} AIPS_LITE_OPACRA_tag;

typedef union AIPS_LITE_OPACRB_union_tag { /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* Reserved */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t _unused_11:1;            /* Reserved */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t _unused_19:1;            /* Reserved */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t _unused_23:1;            /* Reserved */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t _unused_27:1;            /* Reserved */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t _unused_31:1;            /* Reserved */
  } B;
} AIPS_LITE_OPACRB_tag;

typedef union AIPS_LITE_OPACRC_union_tag { /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* Reserved */
    vuint32_t _unused_4:4;             /* Reserved */
    vuint32_t _unused_8:4;             /* Reserved */
    vuint32_t _unused_12:4;            /* Reserved */
    vuint32_t _unused_16:4;            /* Reserved */
    vuint32_t _unused_20:4;            /* Reserved */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t _unused_27:1;            /* Reserved */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t _unused_31:1;            /* Reserved */
  } B;
} AIPS_LITE_OPACRC_tag;

typedef union AIPS_LITE_OPACRD_union_tag { /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* Reserved */
    vuint32_t _unused_4:4;             /* Reserved */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t _unused_11:1;            /* Reserved */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t _unused_16:4;            /* Reserved */
    vuint32_t _unused_20:4;            /* Reserved */
    vuint32_t _unused_24:4;            /* Reserved */
    vuint32_t _unused_28:4;            /* Reserved */
  } B;
} AIPS_LITE_OPACRD_tag;

typedef union AIPS_LITE_OPACRE_union_tag { /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* Reserved */
    vuint32_t _unused_4:4;             /* Reserved */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t _unused_11:1;            /* Reserved */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t _unused_19:1;            /* Reserved */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t _unused_23:1;            /* Reserved */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t _unused_27:1;            /* Reserved */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t _unused_31:1;            /* Reserved */
  } B;
} AIPS_LITE_OPACRE_tag;

typedef union AIPS_LITE_OPACRF_union_tag { /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* Reserved */
    vuint32_t _unused_4:4;             /* Reserved */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t _unused_11:1;            /* Reserved */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t _unused_19:1;            /* Reserved */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t _unused_23:1;            /* Reserved */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t _unused_27:1;            /* Reserved */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t _unused_31:1;            /* Reserved */
  } B;
} AIPS_LITE_OPACRF_tag;

struct AIPS_LITE_tag {
  AIPS_LITE_MPRA_tag MPRA;             /* Master Privilege Register A */
  uint8_t AIPS_LITE_reserved0[28];
  AIPS_LITE_PACRA_tag PACRA;           /* Peripheral Access Control Register */
  uint8_t AIPS_LITE_reserved1[28];
  AIPS_LITE_OPACRA_tag OPACRA;         /* Off-Platform Peripheral Access Control Register */
  AIPS_LITE_OPACRB_tag OPACRB;         /* Off-Platform Peripheral Access Control Register */
  AIPS_LITE_OPACRC_tag OPACRC;         /* Off-Platform Peripheral Access Control Register */
  AIPS_LITE_OPACRD_tag OPACRD;         /* Off-Platform Peripheral Access Control Register */
  AIPS_LITE_OPACRE_tag OPACRE;         /* Off-Platform Peripheral Access Control Register */
  AIPS_LITE_OPACRF_tag OPACRF;         /* Off-Platform Peripheral Access Control Register */
};


/* ============================================================================
   =============================== Module: ATP ================================
   ============================================================================ */

typedef union ATP_PLLC_union_tag {     /* PLL Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:23;
    vuint32_t PLLBYP:1;                /* PLL Clock Bypass */
    vuint32_t _unused_24:7;
    vuint32_t PLLPD:1;                 /* PLL Reset */
  } B;
} ATP_PLLC_tag;

typedef union ATP_PLLS_union_tag {     /* PLL Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t LOCK:1;                  /* PLL Lock Status */
    vuint32_t LOL:1;                   /* PLL Loss of Lock Status */
    vuint32_t _unused_4:28;
  } B;
} ATP_PLLS_tag;

typedef union ATP_PLLDIV_union_tag {   /* PLL Divider */
  vuint32_t R;
  struct {
    vuint32_t MFID:8;                  /* PLL Multiplication Factor Integer Divider */
    vuint32_t _unused_8:4;
    vuint32_t RDIV:3;                  /* PLL Input Clock Predivider */
    vuint32_t _unused_15:1;
    vuint32_t ODIV1:6;                 /* PLL Output Division Factor 1 */
    vuint32_t _unused_22:3;
    vuint32_t _unused_25:6;
    vuint32_t _unused_31:1;
  } B;
} ATP_PLLDIV_tag;

typedef union ATP_PLLCKMUX_union_tag { /* PLL Clock MUX */
  vuint32_t R;
  struct {
    vuint32_t REFCLKSEL:2;             /* Reference Clock Selection */
    vuint32_t _unused_2:30;
  } B;
} ATP_PLLCKMUX_tag;

typedef union ATP_ALS_union_tag {      /* AL Status */
  vuint32_t R;
  struct {
    vuint32_t AS:1;                    /* Aurora Status */
    vuint32_t CS:1;                    /* Channel Status */
    vuint32_t TS:2;                    /* Training Status */
    vuint32_t _unused_4:5;
    vuint32_t PRST:1;                  /* Channel Partner Reset */
    vuint32_t TXCFG:3;                 /* TX Lane Configuration */
    vuint32_t _unused_13:2;
    vuint32_t _unused_15:4;
    vuint32_t _unused_19:1;
    vuint32_t _unused_20:1;
    vuint32_t _unused_21:1;
    vuint32_t _unused_22:10;
  } B;
} ATP_ALS_tag;

typedef union ATP_ALGC_union_tag {     /* AL General Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t CCOEN:1;                 /* Clock Compensation Override Enable */
    vuint32_t CRCEN:1;                 /* CRC Enable */
    vuint32_t _unused_4:4;
    vuint32_t _unused_8:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_10:3;
    vuint32_t _unused_13:1;
    vuint32_t PCRST:1;                 /* Protocol Converter Reset */
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:1;
    vuint32_t _unused_17:1;
    vuint32_t _unused_18:12;
    vuint32_t _unused_30:1;
    vuint32_t RST:1;                   /* Aurora Channel Reset */
  } B;
} ATP_ALGC_tag;

typedef union ATP_ALTC_union_tag {     /* AL Training Control */
  vuint32_t R;
  struct {
    vuint32_t VTC:4;                   /* Verify Timer Count */
    vuint32_t _unused_4:6;
    vuint32_t BTC:4;                   /* Bond Timer Count */
    vuint32_t _unused_14:5;
    vuint32_t ATC:4;                   /* Align Timer Count */
    vuint32_t _unused_23:3;
    vuint32_t _unused_26:1;
    vuint32_t _unused_27:1;
    vuint32_t VHD:1;                   /* Hold in Verify */
    vuint32_t BHD:1;                   /* Hold in Bond */
    vuint32_t AHD:1;                   /* Hold in Align */
    vuint32_t STE:1;                   /* Static Training Enable */
  } B;
} ATP_ALTC_tag;

typedef union ATP_LVDSTX_union_tag {   /* LVDS TX IO Configuration */
  vuint32_t R;
  struct {
    vuint32_t TXAMODE:1;
    vuint32_t CREF_EN:1;               /* Current Reference Enable */
    vuint32_t TX_TREF_EN:1;            /* TX LVDS Termination Reference Enable */
    vuint32_t _unused_3:2;
    vuint32_t PREMPH:2;                /* Pre-Emphasis Configuration */
    vuint32_t _unused_7:1;
    vuint32_t _unused_8:4;
    vuint32_t _unused_12:5;
    vuint32_t _unused_17:15;
  } B;
} ATP_LVDSTX_tag;

typedef union ATP_LVDSRX_union_tag {   /* LVDS RX IO Configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t RXICE:1;
    vuint32_t _unused_2:1;
    vuint32_t RXCB:1;                  /* RX LVDS Current Boost */
    vuint32_t _unused_4:12;
    vuint32_t RX_TREF_EN:1;            /* RX LVDS Termination Reference Enable */
    vuint32_t _unused_17:15;
  } B;
} ATP_LVDSRX_tag;

typedef union ATP_LVDSTXOBE_union_tag { /* LVDS TX OBE Configuration */
  vuint32_t R;
  struct {
    vuint32_t OBETX0:1;
    vuint32_t OBETX1:1;
    vuint32_t OBETX2:1;
    vuint32_t OBETX3:1;
    vuint32_t _unused_4:28;
  } B;
} ATP_LVDSTXOBE_tag;

typedef union ATP_CIAC_union_tag {     /* CIA Control */
  vuint32_t R;
  struct {
    vuint32_t NUM_LANE:4;              /* Number of Aurora Lanes */
    vuint32_t TPIUCM:3;                /* TPIU Control Mode */
    vuint32_t _unused_7:1;
    vuint32_t DBITR:1;
    vuint32_t DBYTER:1;
    vuint32_t _unused_10:4;
    vuint32_t _unused_14:2;
    vuint32_t _unused_16:12;
    vuint32_t _unused_28:4;
  } B;
} ATP_CIAC_tag;

typedef union ATP_ATPE_union_tag {     /* Aurora Trace Port Enable */
  vuint32_t R;
  struct {
    vuint32_t ATPEN:1;
    vuint32_t APHYEN:1;
    vuint32_t _unused_2:30;
  } B;
} ATP_ATPE_tag;

typedef union ATP_ITCTRL_union_tag {   /* Integration Mode Control */
  vuint32_t R;
  struct {
    vuint32_t IME:1;
    vuint32_t _unused_1:31;
  } B;
} ATP_ITCTRL_tag;

typedef union ATP_CLAIMSET_union_tag { /* Claim Tag Set */
  vuint32_t R;
  struct {
    vuint32_t SET:32;
  } B;
} ATP_CLAIMSET_tag;

typedef union ATP_CLAIMCLR_union_tag { /* Claim Tag Clear */
  vuint32_t R;
  struct {
    vuint32_t CLR:32;
  } B;
} ATP_CLAIMCLR_tag;

typedef union ATP_DEVAFF0_union_tag {  /* Device Affinity 0 */
  vuint32_t R;
  struct {
    vuint32_t DEVAFF0:32;              /* Value of this field is set to 0x24. */
  } B;
} ATP_DEVAFF0_tag;

typedef union ATP_DEVAFF1_union_tag {  /* Device Affinity 1 */
  vuint32_t R;
  struct {
    vuint32_t DEVAFF1:32;              /* Value of this field is set to 0x24. */
  } B;
} ATP_DEVAFF1_tag;

typedef union ATP_LAR_union_tag {      /* Lock Access Register */
  vuint32_t R;
  struct {
    vuint32_t KEY:32;
  } B;
} ATP_LAR_tag;

typedef union ATP_LSR_union_tag {      /* Lock Status Register */
  vuint32_t R;
  struct {
    vuint32_t SLI:1;
    vuint32_t SLK:1;
    vuint32_t NTT:1;
    vuint32_t _unused_3:29;
  } B;
} ATP_LSR_tag;

typedef union ATP_AUTHSTATUS_union_tag { /* Authentication Status */
  vuint32_t R;
  struct {
    vuint32_t AUTHSTATUS:8;
    vuint32_t _unused_8:24;
  } B;
} ATP_AUTHSTATUS_tag;

typedef union ATP_DEVARCH_union_tag {  /* Device Architecture */
  vuint32_t R;
  struct {
    vuint32_t ARCHID:16;               /* Architecture ID */
    vuint32_t REVISION:4;              /* Architecture revision */
    vuint32_t PRESENT:1;               /* Indicates the presence of this register. */
    vuint32_t ARCHITECT:11;            /* Defines the architect of the component. */
  } B;
} ATP_DEVARCH_tag;

typedef union ATP_DEVID2_union_tag {   /* Device Configuration 2 */
  vuint32_t R;
  struct {
    vuint32_t DEVID2:32;
  } B;
} ATP_DEVID2_tag;

typedef union ATP_DEVID1_union_tag {   /* Device Configuration 1 */
  vuint32_t R;
  struct {
    vuint32_t DEVID1:32;
  } B;
} ATP_DEVID1_tag;

typedef union ATP_DEVID_union_tag {    /* Device Configuration */
  vuint32_t R;
  struct {
    vuint32_t DEVID:32;
  } B;
} ATP_DEVID_tag;

typedef union ATP_DEVTYPE_union_tag {  /* Device Type Identifier */
  vuint32_t R;
  struct {
    vuint32_t MAJOR:4;                 /* Major Type */
    vuint32_t SUB:4;                   /* Sub Type */
    vuint32_t _unused_8:24;
  } B;
} ATP_DEVTYPE_tag;

typedef union ATP_PIDR4_union_tag {    /* Peripheral Identification Register 4 */
  vuint32_t R;
  struct {
    vuint32_t DES_2:4;                 /* JEP106 Continuation Code */
    vuint32_t SIZE:4;                  /* 4KB Count */
    vuint32_t _unused_8:24;
  } B;
} ATP_PIDR4_tag;

typedef union ATP_PIDR5_union_tag {    /* Peripheral Identification Register 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t _unused_8:24;
  } B;
} ATP_PIDR5_tag;

typedef union ATP_PIDR6_union_tag {    /* Peripheral Identification Register 6 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t _unused_8:24;
  } B;
} ATP_PIDR6_tag;

typedef union ATP_PIDR7_union_tag {    /* Peripheral Identification Register 7 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;
    vuint32_t _unused_8:24;
  } B;
} ATP_PIDR7_tag;

typedef union ATP_PIDR0_union_tag {    /* Peripheral Identification Register 0 */
  vuint32_t R;
  struct {
    vuint32_t PART_0:8;                /* Part number, bits[7:0] */
    vuint32_t _unused_8:24;
  } B;
} ATP_PIDR0_tag;

typedef union ATP_PIDR1_union_tag {    /* Peripheral Identification Register 1 */
  vuint32_t R;
  struct {
    vuint32_t PART_1:4;                /* Part number, bits[11:8] */
    vuint32_t DES_0:4;                 /* JEP106 identification code, bits[3:0] */
    vuint32_t _unused_8:24;
  } B;
} ATP_PIDR1_tag;

typedef union ATP_PIDR2_union_tag {    /* Peripheral Identification Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DES_1:3;                 /* JEP106 identification code, bits[6:4] */
    vuint32_t JEDEC:1;
    vuint32_t REVISION:4;              /* Revision */
    vuint32_t _unused_8:24;
  } B;
} ATP_PIDR2_tag;

typedef union ATP_PIDR3_union_tag {    /* Peripheral Identification Register 3 */
  vuint32_t R;
  struct {
    vuint32_t REVAND:4;                /* RevAnd */
    vuint32_t CMOD:4;                  /* Customer Modified */
    vuint32_t _unused_8:24;
  } B;
} ATP_PIDR3_tag;

typedef union ATP_CIDR0_union_tag {    /* Component Identification Register 0 */
  vuint32_t R;
  struct {
    vuint32_t PRMBL_0:8;               /* Preamble */
    vuint32_t _unused_8:24;
  } B;
} ATP_CIDR0_tag;

typedef union ATP_CIDR1_union_tag {    /* Component Identification Register 1 */
  vuint32_t R;
  struct {
    vuint32_t PRMBL_1:4;               /* Preamble */
    vuint32_t CLASS:4;                 /* Component class */
    vuint32_t _unused_8:24;
  } B;
} ATP_CIDR1_tag;

typedef union ATP_CIDR2_union_tag {    /* Component Identification Register 2 */
  vuint32_t R;
  struct {
    vuint32_t PRMBL_2:8;               /* Preamble */
    vuint32_t _unused_8:24;
  } B;
} ATP_CIDR2_tag;

typedef union ATP_CIDR3_union_tag {    /* Component Identification Register 3 */
  vuint32_t R;
  struct {
    vuint32_t PRMBL_3:8;               /* Preamble */
    vuint32_t _unused_8:24;
  } B;
} ATP_CIDR3_tag;

struct ATP_tag {
  ATP_PLLC_tag PLLC;                   /* PLL Control */
  ATP_PLLS_tag PLLS;                   /* PLL Status */
  ATP_PLLDIV_tag PLLDIV;               /* PLL Divider */
  uint8_t ATP_reserved0[20];
  ATP_PLLCKMUX_tag PLLCKMUX;           /* PLL Clock MUX */
  uint8_t ATP_reserved1[732];
  ATP_ALS_tag ALS;                     /* AL Status */
  uint8_t ATP_reserved2[4];
  ATP_ALGC_tag ALGC;                   /* AL General Control */
  ATP_ALTC_tag ALTC;                   /* AL Training Control */
  uint8_t ATP_reserved3[304];
  ATP_LVDSTX_tag LVDSTX;               /* LVDS TX IO Configuration */
  ATP_LVDSRX_tag LVDSRX;               /* LVDS RX IO Configuration */
  ATP_LVDSTXOBE_tag LVDSTXOBE;         /* LVDS TX OBE Configuration */
  uint8_t ATP_reserved4[52];
  ATP_CIAC_tag CIAC;                   /* CIA Control */
  uint8_t ATP_reserved5[4];
  ATP_ATPE_tag ATPE;                   /* Aurora Trace Port Enable */
  uint8_t ATP_reserved6[2676];
  ATP_ITCTRL_tag ITCTRL;               /* Integration Mode Control */
  uint8_t ATP_reserved7[156];
  ATP_CLAIMSET_tag CLAIMSET;           /* Claim Tag Set */
  ATP_CLAIMCLR_tag CLAIMCLR;           /* Claim Tag Clear */
  ATP_DEVAFF0_tag DEVAFF0;             /* Device Affinity 0 */
  ATP_DEVAFF1_tag DEVAFF1;             /* Device Affinity 1 */
  ATP_LAR_tag LAR;                     /* Lock Access Register */
  ATP_LSR_tag LSR;                     /* Lock Status Register */
  ATP_AUTHSTATUS_tag AUTHSTATUS;       /* Authentication Status */
  ATP_DEVARCH_tag DEVARCH;             /* Device Architecture */
  ATP_DEVID2_tag DEVID2;               /* Device Configuration 2 */
  ATP_DEVID1_tag DEVID1;               /* Device Configuration 1 */
  ATP_DEVID_tag DEVID;                 /* Device Configuration */
  ATP_DEVTYPE_tag DEVTYPE;             /* Device Type Identifier */
  ATP_PIDR4_tag PIDR4;                 /* Peripheral Identification Register 4 */
  ATP_PIDR5_tag PIDR5;                 /* Peripheral Identification Register 5 */
  ATP_PIDR6_tag PIDR6;                 /* Peripheral Identification Register 6 */
  ATP_PIDR7_tag PIDR7;                 /* Peripheral Identification Register 7 */
  ATP_PIDR0_tag PIDR0;                 /* Peripheral Identification Register 0 */
  ATP_PIDR1_tag PIDR1;                 /* Peripheral Identification Register 1 */
  ATP_PIDR2_tag PIDR2;                 /* Peripheral Identification Register 2 */
  ATP_PIDR3_tag PIDR3;                 /* Peripheral Identification Register 3 */
  ATP_CIDR0_tag CIDR0;                 /* Component Identification Register 0 */
  ATP_CIDR1_tag CIDR1;                 /* Component Identification Register 1 */
  ATP_CIDR2_tag CIDR2;                 /* Component Identification Register 2 */
  ATP_CIDR3_tag CIDR3;                 /* Component Identification Register 3 */
};


/* ============================================================================
   =============================== Module: BOOT_SOC ===========================
   ============================================================================ */

typedef union BOOT_SOC_BOOT_GPR_BMR1_union_tag { /* Boot Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t BOOT_CFG:32;             /* Boot Configuration */
  } B;
} BOOT_SOC_BOOT_GPR_BMR1_tag;

typedef union BOOT_SOC_BOOT_GPR_BMR2_union_tag { /* Boot Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;
    vuint32_t FUSE_SEL:1;              /* FUSE_SEL value from fuses. This fuse indicates if boot configuration is to be fetched from RCON Pads or BOOT_CFG fuses. */
    vuint32_t _unused_5:19;
    vuint32_t BMODE2:1;                /* BMODE2 pin value latched at phase3 deassertion. */
    vuint32_t BMODE1:1;                /* BMODE1 pin value latched at phase3 deassertion. */
    vuint32_t _unused_26:6;
  } B;
} BOOT_SOC_BOOT_GPR_BMR2_tag;

struct BOOT_SOC_tag {
  BOOT_SOC_BOOT_GPR_BMR1_tag BOOT_GPR_BMR1; /* Boot Configuration Register 1 */
  BOOT_SOC_BOOT_GPR_BMR2_tag BOOT_GPR_BMR2; /* Boot Configuration Register 2 */
};


/* ============================================================================
   =============================== Module: C55FP ==============================
   ============================================================================ */

typedef union C55FP_MCR_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t EHV:1;                   /* Enable High Voltage */
    vuint32_t ESUS:1;                  /* Erase Suspend */
    vuint32_t ERS:1;                   /* Erase */
    vuint32_t PSUS:1;                  /* Program Suspend */
    vuint32_t PGM:1;                   /* Program */
    vuint32_t _unused_5:1;             /* Reserved */
    vuint32_t FPGM:1;                  /* Factory Fast Program */
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t PECIE:1;                 /* Program/Erase Complete Interrupt Enable */
    vuint32_t PEG:1;                   /* Program/Erase Good */
    vuint32_t DONE:1;                  /* State Machine Status */
    vuint32_t PEAS:1;                  /* Program Access Space */
    vuint32_t RE:1;                    /* Reset Error */
    vuint32_t SBC:1;                   /* Single Bit Correction */
    vuint32_t RWE:1;                   /* Read-While-Write Event Error */
    vuint32_t EER:1;                   /* ECC Event Error */
    vuint32_t PES:1;                   /* Program and Erase Sequence Error */
    vuint32_t PEP:1;                   /* Program and Erase Protection Error */
    vuint32_t _unused_18:2;            /* Reserved */
    vuint32_t FEV:1;                   /* Factory Erase Voltage Available */
    vuint32_t HT:1;                    /* High Temperature Enabled */
    vuint32_t _unused_22:6;            /* Reserved */
    vuint32_t EEE:1;                   /* ECC after ECC Error */
    vuint32_t AEE:1;                   /* Address Encode Error */
    vuint32_t RRE:1;                   /* Read Reference Error */
    vuint32_t RVE:1;                   /* Read Voltage Error */
  } B;
} C55FP_MCR_tag;

typedef union C55FP_MCRE_union_tag {   /* Extended Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t N16KL:3;                 /* n16Kl */
    vuint32_t N32KL:3;                 /* n32Kl */
    vuint32_t N64KL:3;                 /* n64Kl */
    vuint32_t N16KM:3;                 /* n16Km */
    vuint32_t N32KM:3;                 /* n32Km */
    vuint32_t N64KM:3;                 /* n64Km */
    vuint32_t N16KH:3;                 /* n16Kh */
    vuint32_t N32KH:3;                 /* n32Kh */
    vuint32_t N64KH:3;                 /* n64Kh */
    vuint32_t N256K:5;                 /* n256K */
  } B;
} C55FP_MCRE_tag;

typedef union C55FP_CTL_union_tag {    /* Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t L0:1;                    /* Level Zero Reservation */
    vuint32_t L1:1;                    /* Level One Reservation */
    vuint32_t _unused_2:6;             /* Reserved */
    vuint32_t RWSC:5;                  /* Wait State Control */
    vuint32_t APC:3;                   /* Address Pipeline Control */
    vuint32_t L0MI:4;                  /* Level Zero Master ID */
    vuint32_t L1MI:4;                  /* Level One Master ID */
    vuint32_t _unused_24:8;            /* Reserved */
  } B;
} C55FP_CTL_tag;

typedef union C55FP_LOCK0_union_tag {  /* Lock 0 register */
  vuint32_t R;
  struct {
    vuint32_t MIDLOCK:16;              /* Mid Block Lock [15:0] */
    vuint32_t LOWLOCK:14;              /* Low Block Lock [13:0] */
    vuint32_t _unused_30:1;            /* Reserved */
    vuint32_t TSLOCK:1;                /* UTest NVM Lock. */
  } B;
} C55FP_LOCK0_tag;

typedef union C55FP_LOCK1_union_tag {  /* Lock 1 register */
  vuint32_t R;
  struct {
    vuint32_t HIGHLOCK:16;             /* High Block Lock [15:0] */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} C55FP_LOCK1_tag;

typedef union C55FP_LOCK2_union_tag {  /* Lock 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KLOCK:32;            /* 256 KB Block Lock [31:0] */
  } B;
} C55FP_LOCK2_tag;

typedef union C55FP_LOCK3_union_tag {  /* Lock 3 register */
  vuint32_t R;
  struct {
    vuint32_t A256KLOCK:16;            /* 256 KB Block Lock [47:32] */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} C55FP_LOCK3_tag;

typedef union C55FP_SEL0_union_tag {   /* Select 0 register */
  vuint32_t R;
  struct {
    vuint32_t MIDSEL:16;               /* Mid Block Select [15:0] */
    vuint32_t LOWSEL:14;               /* LOW Block Select [13:0] */
    vuint32_t _unused_30:2;            /* Reserved */
  } B;
} C55FP_SEL0_tag;

typedef union C55FP_SEL1_union_tag {   /* Select 1 register */
  vuint32_t R;
  struct {
    vuint32_t HIGHSEL:16;              /* High Block Select [15:0] */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} C55FP_SEL1_tag;

typedef union C55FP_SEL2_union_tag {   /* Select 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KSEL:32;             /* 256 KB Block Select [31:0] */
  } B;
} C55FP_SEL2_tag;

typedef union C55FP_SEL3_union_tag {   /* Select 3 register */
  vuint32_t R;
  struct {
    vuint32_t A256KSEL:16;             /* 256 KB Block Select [47:32] */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} C55FP_SEL3_tag;

typedef union C55FP_ADR_union_tag {    /* Address register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;             /* Reserved */
    vuint32_t ADDR:20;                 /* Address */
    vuint32_t A16K:1;                  /* a16k */
    vuint32_t A32K:1;                  /* a32k */
    vuint32_t A64K:1;                  /* a64k */
    vuint32_t A256K:1;                 /* Address 256 KB region */
    vuint32_t AL:1;                    /* Address Low region */
    vuint32_t AM:1;                    /* Address Mid region */
    vuint32_t AH:1;                    /* Address High region */
    vuint32_t AMEM:1;                  /* Address Memory region */
    vuint32_t SAD:1;                   /* SAD */
  } B;
} C55FP_ADR_tag;

typedef union C55FP_UT0_union_tag {    /* UTest 0 register */
  vuint32_t R;
  struct {
    vuint32_t AID:1;                   /* AID */
    vuint32_t AIE:1;                   /* AIE */
    vuint32_t AIS:1;                   /* AIS */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t MRV:1;                   /* MRV */
    vuint32_t MRE:1;                   /* MRE */
    vuint32_t AISUS:1;                 /* AISUS */
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t AIBPE:1;                 /* AIBPE */
    vuint32_t NAIBP:1;                 /* NAIBP */
    vuint32_t _unused_10:2;            /* Reserved */
    vuint32_t EIE:1;                   /* ECC Data Input Enable */
    vuint32_t EDIE:1;                  /* EDC after ECC Data Input Enable */
    vuint32_t AEIE:1;                  /* Address Encode Invert Enable */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t CPE:1;                   /* Customer Programmable EDC after ECC Detection */
    vuint32_t CPA:1;                   /* Customer Programmable Address Encode Detection */
    vuint32_t CPR:1;                   /* Customer Programmable Read Voltage and Reference Detection */
    vuint32_t _unused_19:11;           /* Reserved */
    vuint32_t SBCE:1;                  /* SBCE */
    vuint32_t UTE:1;                   /* U-Test Enable */
  } B;
} C55FP_UT0_tag;

typedef union C55FP_UM_union_tag {     /* UMISRn register */
  vuint32_t R;
  struct {
    vuint32_t MISR:32;                 /* MISR[31:0] */
  } B;
} C55FP_UM_tag;

typedef union C55FP_UM9_union_tag {    /* UMISR9 register */
  vuint32_t R;
  struct {
    vuint32_t MISR:1;                  /* MISR[288] */
    vuint32_t _unused_1:31;            /* Reserved */
  } B;
} C55FP_UM9_tag;

typedef union C55FP_OPP0_union_tag {   /* Over-Program Protection 0 register */
  vuint32_t R;
  struct {
    vuint32_t MIDOPP:16;               /* Mid Block Over-Program Protection [15:0] */
    vuint32_t LOWOPP:14;               /* Low Block Over-Program Protection [13:0] */
    vuint32_t _unused_30:2;            /* Reserved */
  } B;
} C55FP_OPP0_tag;

typedef union C55FP_OPP1_union_tag {   /* Over-Program Protection 1 register */
  vuint32_t R;
  struct {
    vuint32_t HIGHOPP:16;              /* High Block Over-Program Protection [15:0] */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} C55FP_OPP1_tag;

typedef union C55FP_OPP2_union_tag {   /* Over-Program Protection 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KOPP:32;             /* 256K Block Over-Program Protection [31:0] */
  } B;
} C55FP_OPP2_tag;

typedef union C55FP_OPP3_union_tag {   /* Over-Program Protection 3 register */
  vuint32_t R;
  struct {
    vuint32_t A256KOPP:16;             /* 256K Block Over-Program Protection [47:32] */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} C55FP_OPP3_tag;

typedef union C55FP_TMD_union_tag {    /* Test Mode Disable Password Check register */
  vuint32_t R;
  struct {
    vuint32_t PWD:32;                  /* Password challenge */
  } B;
} C55FP_TMD_tag;

typedef union C55FP_ELOCK0_union_tag { /* Erase Hardware Lock 0 Register */
  vuint32_t R;
  struct {
    vuint32_t EMIDLOCK:16;             /* Erase Mid Block Lock [15:0] */
    vuint32_t ELOWLOCK:14;             /* Erase Low Block Lock[13:0] */
    vuint32_t _unused_30:1;            /* Reserved */
    vuint32_t ETSLOCK:1;               /* Erase UTest NVM Lock */
  } B;
} C55FP_ELOCK0_tag;

typedef union C55FP_ELOCK1_union_tag { /* Erase Hardware Lock 1 Register */
  vuint32_t R;
  struct {
    vuint32_t EHIGHLOCK:16;            /* Erase High Block Lock [15:0] */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} C55FP_ELOCK1_tag;

typedef union C55FP_ELOCK2_union_tag { /* Erase Hardware Lock 2 Register */
  vuint32_t R;
  struct {
    vuint32_t E256KLOCK:32;            /* Erase 256K Block Lock [31:0] */
  } B;
} C55FP_ELOCK2_tag;

typedef union C55FP_ELOCK3_union_tag { /* Erase Hardware Lock 3 Register */
  vuint32_t R;
  struct {
    vuint32_t E256KLOCK:16;            /* Erase 256K Block Lock [47:32] */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} C55FP_ELOCK3_tag;

typedef union C55FP_PLOCK0_union_tag { /* Program Hardware Lock 0 Register */
  vuint32_t R;
  struct {
    vuint32_t PMIDLOCK:16;             /* Program Mid Block Lock [15:0] */
    vuint32_t PLOWLOCK:14;             /* Program Low Block Lock [13:0] */
    vuint32_t _unused_30:1;            /* Reserved */
    vuint32_t PTSLOCK:1;               /* Program UTest NVM Lock */
  } B;
} C55FP_PLOCK0_tag;

typedef union C55FP_PLOCK1_union_tag { /* Program Hardware Lock 1 Register */
  vuint32_t R;
  struct {
    vuint32_t PHIGHLOCK:16;            /* Program High Block Lock [15:0] */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} C55FP_PLOCK1_tag;

typedef union C55FP_PLOCK2_union_tag { /* Program Hardware Lock 2 Register */
  vuint32_t R;
  struct {
    vuint32_t P256KLOCK:32;            /* Program 256K Block Lock [31:0] */
  } B;
} C55FP_PLOCK2_tag;

typedef union C55FP_PLOCK3_union_tag { /* Program Hardware Lock 3 Register */
  vuint32_t R;
  struct {
    vuint32_t P256KLOCK:16;            /* Program 256K Block Lock [47:32] */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} C55FP_PLOCK3_tag;

typedef union C55FP_UD0_union_tag {    /* UTest Data 0 Register */
  vuint32_t R;
  struct {
    vuint32_t EDATA:32;                /* ECC Data [31:0] */
  } B;
} C55FP_UD0_tag;

typedef union C55FP_UD1_union_tag {    /* UTest Data 1 Register */
  vuint32_t R;
  struct {
    vuint32_t EDATA:32;                /* ECC Data [63:32] */
  } B;
} C55FP_UD1_tag;

typedef union C55FP_UD2_union_tag {    /* UTest Data 2 Register */
  vuint32_t R;
  struct {
    vuint32_t EDATAC:8;                /* ECC Data Check Bits [7:0] */
    vuint32_t _unused_8:20;            /* Reserved */
    vuint32_t ED0:1;                   /* ECC Logic Check Double Word 0 */
    vuint32_t ED1:1;                   /* ECC Logic Check Double Word 1 */
    vuint32_t ED2:1;                   /* ECC Logic Check Double Word 2 */
    vuint32_t ED3:1;                   /* ECC Logic Check Double Word 3 */
  } B;
} C55FP_UD2_tag;

typedef union C55FP_UD3_union_tag {    /* UTest Data 3 Register */
  vuint32_t R;
  struct {
    vuint32_t EDDATA:32;               /* EDC after ECC Data [31:0] */
  } B;
} C55FP_UD3_tag;

typedef union C55FP_UD4_union_tag {    /* UTest Data 4 Register */
  vuint32_t R;
  struct {
    vuint32_t EDDATA:32;               /* EDC after ECC Data [63:31] */
  } B;
} C55FP_UD4_tag;

typedef union C55FP_UD5_union_tag {    /* UTest Data 5 Register */
  vuint32_t R;
  struct {
    vuint32_t EDDATAC:8;               /* EDC after ECC Data Check Bits [7:0] */
    vuint32_t _unused_8:20;            /* Reserved */
    vuint32_t EDD0:1;                  /* EDC after ECC Logic Check Double Word 0 */
    vuint32_t EDD1:1;                  /* EDC after ECC Logic Check Double Word 1 */
    vuint32_t EDD2:1;                  /* EDC after ECC Logic Check Double Word 2 */
    vuint32_t EDD3:1;                  /* EDC after ECC Logic Check Double Word 3 */
  } B;
} C55FP_UD5_tag;

typedef union C55FP_UA0_union_tag {    /* UTest Address 0 Register */
  vuint32_t R;
  struct {
    vuint32_t AEI:32;                  /* Address Encode Invert [31:0] */
  } B;
} C55FP_UA0_tag;

typedef union C55FP_UA1_union_tag {    /* UTest Address 1 Register */
  vuint32_t R;
  struct {
    vuint32_t AEI:24;                  /* Address Encode Invert [55:32] */
    vuint32_t _unused_24:8;            /* Reserved */
  } B;
} C55FP_UA1_tag;

typedef union C55FP_XMCR_union_tag {   /* Express Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t XEHV:1;                  /* Express Enable High Voltage */
    vuint32_t _unused_1:1;             /* Reserved */
    vuint32_t XDOK:1;                  /* Express Data OK */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t XPGM:1;                  /* Express Program */
    vuint32_t XPEG:1;                  /* Express Program Good */
    vuint32_t XDONE:1;                 /* Express State Machine Status */
    vuint32_t XADDR:16;                /* Express Address */
    vuint32_t X16K:1;                  /* Express 16 KB region */
    vuint32_t X32K:1;                  /* Express 32 KB region */
    vuint32_t X64K:1;                  /* Express 64 KB region */
    vuint32_t _unused_26:1;            /* Reserved */
    vuint32_t XL:1;                    /* Express Low Region */
    vuint32_t XM:1;                    /* Express Mid Region */
    vuint32_t XH:1;                    /* Express High Region */
    vuint32_t XMEM:1;                  /* Express Memory Region */
    vuint32_t _unused_31:1;            /* Reserved */
  } B;
} C55FP_XMCR_tag;

typedef union C55FP_XDATA_union_tag {  /* Express Data Register */
  vuint32_t R;
  struct {
    vuint32_t XPDATA:32;               /* XPDATA */
  } B;
} C55FP_XDATA_tag;

struct C55FP_tag {
  C55FP_MCR_tag MCR;                   /* Module Configuration Register */
  uint8_t C55FP_reserved0[4];
  C55FP_MCRE_tag MCRE;                 /* Extended Module Configuration Register */
  C55FP_CTL_tag CTL;                   /* Module Control Register */
  C55FP_LOCK0_tag LOCK0;               /* Lock 0 register */
  C55FP_LOCK1_tag LOCK1;               /* Lock 1 register */
  C55FP_LOCK2_tag LOCK2;               /* Lock 2 register */
  C55FP_LOCK3_tag LOCK3;               /* Lock 3 register */
  uint8_t C55FP_reserved1[24];
  C55FP_SEL0_tag SEL0;                 /* Select 0 register */
  C55FP_SEL1_tag SEL1;                 /* Select 1 register */
  C55FP_SEL2_tag SEL2;                 /* Select 2 register */
  C55FP_SEL3_tag SEL3;                 /* Select 3 register */
  uint8_t C55FP_reserved2[8];
  C55FP_ADR_tag ADR;                   /* Address register */
  C55FP_UT0_tag UT0;                   /* UTest 0 register */
  C55FP_UM_tag UM[9];                  /* UMISRn register */
  C55FP_UM9_tag UM9;                   /* UMISR9 register */
  C55FP_OPP0_tag OPP0;                 /* Over-Program Protection 0 register */
  C55FP_OPP1_tag OPP1;                 /* Over-Program Protection 1 register */
  C55FP_OPP2_tag OPP2;                 /* Over-Program Protection 2 register */
  C55FP_OPP3_tag OPP3;                 /* Over-Program Protection 3 register */
  C55FP_TMD_tag TMD;                   /* Test Mode Disable Password Check register */
  uint8_t C55FP_reserved3[12];
  C55FP_ELOCK0_tag ELOCK0;             /* Erase Hardware Lock 0 Register */
  C55FP_ELOCK1_tag ELOCK1;             /* Erase Hardware Lock 1 Register */
  C55FP_ELOCK2_tag ELOCK2;             /* Erase Hardware Lock 2 Register */
  C55FP_ELOCK3_tag ELOCK3;             /* Erase Hardware Lock 3 Register */
  C55FP_PLOCK0_tag PLOCK0;             /* Program Hardware Lock 0 Register */
  C55FP_PLOCK1_tag PLOCK1;             /* Program Hardware Lock 1 Register */
  C55FP_PLOCK2_tag PLOCK2;             /* Program Hardware Lock 2 Register */
  C55FP_PLOCK3_tag PLOCK3;             /* Program Hardware Lock 3 Register */
  uint8_t C55FP_reserved4[16];
  C55FP_UD0_tag UD0;                   /* UTest Data 0 Register */
  C55FP_UD1_tag UD1;                   /* UTest Data 1 Register */
  C55FP_UD2_tag UD2;                   /* UTest Data 2 Register */
  C55FP_UD3_tag UD3;                   /* UTest Data 3 Register */
  C55FP_UD4_tag UD4;                   /* UTest Data 4 Register */
  C55FP_UD5_tag UD5;                   /* UTest Data 5 Register */
  C55FP_UA0_tag UA0;                   /* UTest Address 0 Register */
  C55FP_UA1_tag UA1;                   /* UTest Address 1 Register */
  C55FP_XMCR_tag XMCR;                 /* Express Module Configuration Register */
  uint8_t C55FP_reserved5[12];
  C55FP_XDATA_tag XDATA[32];           /* Express Data Register */
};


/* ============================================================================
   =============================== Module: CMU_FC =============================
   ============================================================================ */

typedef union CMU_FC_GCR_union_tag {   /* Global Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FCE:1;                   /* Frequency Check Enable */
    vuint32_t _unused_1:31;
  } B;
} CMU_FC_GCR_tag;

typedef union CMU_FC_RCCR_union_tag {  /* Reference Count Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REF_CNT:16;              /* Reference clock count */
    vuint32_t _unused_16:16;
  } B;
} CMU_FC_RCCR_tag;

typedef union CMU_FC_HTCR_union_tag {  /* High Threshold Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t HFREF:24;                /* High frequency reference threshold */
    vuint32_t _unused_24:8;
  } B;
} CMU_FC_HTCR_tag;

typedef union CMU_FC_LTCR_union_tag {  /* Low Threshold Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t LFREF:24;                /* Low Frequency Reference Threshold */
    vuint32_t _unused_24:8;
  } B;
} CMU_FC_LTCR_tag;

typedef union CMU_FC_SR_union_tag {    /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t FLL:1;                   /* Frequency lower than low frequency reference threshold event status */
    vuint32_t FHH:1;                   /* Frequency higher than high frequency reference threshold event status */
    vuint32_t STATE:2;                 /* CMU_FC State */
    vuint32_t RS:1;                    /* Run Status */
    vuint32_t _unused_5:27;
  } B;
} CMU_FC_SR_tag;

typedef union CMU_FC_IER_union_tag {   /* Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t FLLIE:1;                 /* Frequency Lower than Low Frequency Reference Threshold Synchronous Interrupt Enable */
    vuint32_t FHHIE:1;                 /* Frequency Higher than High Frequency Reference Threshold Synchronous Interrupt Enable */
    vuint32_t FLLAIE:1;                /* Frequency Lower than Low Frequency Reference Threshold Asynchronous Interrupt Enable */
    vuint32_t FHHAIE:1;                /* Frequency Higher than High Frequency Reference Threshold Asynchronous Interrupt Enable */
    vuint32_t _unused_4:28;
  } B;
} CMU_FC_IER_tag;

struct CMU_FC_tag {
  CMU_FC_GCR_tag GCR;                  /* Global Configuration Register */
  CMU_FC_RCCR_tag RCCR;                /* Reference Count Configuration Register */
  CMU_FC_HTCR_tag HTCR;                /* High Threshold Configuration Register */
  CMU_FC_LTCR_tag LTCR;                /* Low Threshold Configuration Register */
  CMU_FC_SR_tag SR;                    /* Status Register */
  CMU_FC_IER_tag IER;                  /* Interrupt Enable Register */
};


/* ============================================================================
   =============================== Module: CMU_FM =============================
   ============================================================================ */

typedef union CMU_FM_GCR_union_tag {   /* CMU Frequency Meter Global Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FME:1;                   /* Frequency Meter Enable */
    vuint32_t _unused_1:31;            /* Reserved */
  } B;
} CMU_FM_GCR_tag;

typedef union CMU_FM_RCCR_union_tag {  /* CMU Frequency Meter Reference Count Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REF_CNT:16;              /* Reference Clock Count */
    vuint32_t _unused_16:16;
  } B;
} CMU_FM_RCCR_tag;

typedef union CMU_FM_SR_union_tag {    /* CMU Frequency Meter Status Register */
  vuint32_t R;
  struct {
    vuint32_t FMC:1;                   /* Frequency Meter Operation Complete */
    vuint32_t FMTO:1;                  /* Frequency Meter Time Out */
    vuint32_t STATE:2;                 /* Module State */
    vuint32_t RS:1;                    /* Run Status */
    vuint32_t _unused_5:3;             /* Reserved */
    vuint32_t MET_CNT:24;              /* Meter Clock Count */
  } B;
} CMU_FM_SR_tag;

typedef union CMU_FM_IER_union_tag {   /* CMU Frequency Meter Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t FMCIE:1;                 /* Frequency Meter Complete Interrupt Enable */
    vuint32_t _unused_1:31;            /* Reserved */
  } B;
} CMU_FM_IER_tag;

struct CMU_FM_tag {
  CMU_FM_GCR_tag GCR;                  /* CMU Frequency Meter Global Configuration Register */
  CMU_FM_RCCR_tag RCCR;                /* CMU Frequency Meter Reference Count Configuration Register */
  CMU_FM_SR_tag SR;                    /* CMU Frequency Meter Status Register */
  CMU_FM_IER_tag IER;                  /* CMU Frequency Meter Interrupt Enable Register */
};


/* ============================================================================
   =============================== Module: CORE_PLL ===========================
   ============================================================================ */

typedef union CORE_PLL_PLLCR_union_tag { /* PLL Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:31;            /* Reserved */
    vuint32_t PLLPD:1;                 /* PLL power down */
  } B;
} CORE_PLL_PLLCR_tag;

typedef union CORE_PLL_PLLSR_union_tag { /* PLL status register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;
    vuint32_t LOCK:1;                  /* Lock status */
    vuint32_t LOL:1;                   /* Loss-Of-Lock flag */
    vuint32_t _unused_4:28;
  } B;
} CORE_PLL_PLLSR_tag;

typedef union CORE_PLL_PLLDV_union_tag { /* PLL Divider */
  vuint32_t R;
  struct {
    vuint32_t MFI:8;                   /* Integer portion of loop divider. */
    vuint32_t _unused_8:4;
    vuint32_t RDIV:3;                  /* Input clock predivider */
    vuint32_t _unused_15:1;
    vuint32_t _unused_16:6;
    vuint32_t _unused_22:3;
    vuint32_t _unused_25:6;
    vuint32_t _unused_31:1;
  } B;
} CORE_PLL_PLLDV_tag;

typedef union CORE_PLL_PLLFM_union_tag { /* PLL Frequency Modulation */
  vuint32_t R;
  struct {
    vuint32_t STEPNO:11;               /* Number of steps of modulation period/frequency modulation */
    vuint32_t _unused_11:5;
    vuint32_t STEPSIZE:10;             /* Frequency modulation step size */
    vuint32_t _unused_26:3;
    vuint32_t SPREADCTL:1;             /* Modulation type selection */
    vuint32_t SSCGBYP:1;               /* SSCG bypass */
    vuint32_t _unused_31:1;
  } B;
} CORE_PLL_PLLFM_tag;

typedef union CORE_PLL_PLLFD_union_tag { /* PLL Fractional Divider */
  vuint32_t R;
  struct {
    vuint32_t MFN:15;                  /* Numerator of fractional loop division factor */
    vuint32_t _unused_15:1;
    vuint32_t DITHER_EN:1;             /* Dither enable */
    vuint32_t _unused_17:1;
    vuint32_t DTHRCTL:4;               /* Dither control */
    vuint32_t _unused_22:6;
    vuint32_t _unused_28:1;
    vuint32_t _unused_29:1;
    vuint32_t SDMEN:1;                 /* Sigma-delta modulation enable */
    vuint32_t _unused_31:1;
  } B;
} CORE_PLL_PLLFD_tag;

typedef union CORE_PLL_PLLCLKMUX_union_tag { /* PLL Clock Multiplexer */
  vuint32_t R;
  struct {
    vuint32_t REFCLKSEL:1;             /* Reference clock select */
    vuint32_t _unused_1:31;
  } B;
} CORE_PLL_PLLCLKMUX_tag;

typedef union CORE_PLL_PLLODIV_union_tag { /* PLL Output Divider */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;             /* Reserved (for internal use only) */
    vuint32_t _unused_2:14;
    vuint32_t DIV:8;                   /* Division value */
    vuint32_t _unused_24:7;
    vuint32_t DE:1;                    /* Divider enable */
  } B;
} CORE_PLL_PLLODIV_tag;

struct CORE_PLL_tag {
  CORE_PLL_PLLCR_tag PLLCR;            /* PLL Control Register */
  CORE_PLL_PLLSR_tag PLLSR;            /* PLL status register */
  CORE_PLL_PLLDV_tag PLLDV;            /* PLL Divider */
  CORE_PLL_PLLFM_tag PLLFM;            /* PLL Frequency Modulation */
  CORE_PLL_PLLFD_tag PLLFD;            /* PLL Fractional Divider */
  uint8_t CORE_PLL_reserved0[12];
  CORE_PLL_PLLCLKMUX_tag PLLCLKMUX;    /* PLL Clock Multiplexer */
  uint8_t CORE_PLL_reserved1[92];
  CORE_PLL_PLLODIV_tag PLLODIV[2];     /* PLL Output Divider */
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

typedef union CRC_CFG1_union_tag {     /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t INV:1;                   /* Inversion selection */
    vuint32_t SWAP:1;                  /* Swap selection */
    vuint32_t POLYG:2;                 /* Polynomial selection */
    vuint32_t SWAP_BITWISE:1;          /* Swap CRC_INP bit-wise */
    vuint32_t SWAP_BYTEWISE:1;         /* Swap CRC_INP byte-wise */
    vuint32_t _unused_6:18;            /* Reserved */
    vuint32_t _unused_24:8;            /* Reserved */
  } B;
} CRC_CFG1_tag;

typedef union CRC_INP1_union_tag {     /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t INP:32;                  /* Input data for the CRC computation */
  } B;
} CRC_INP1_tag;

typedef union CRC_CSTAT1_union_tag {   /* Current Status Register */
  vuint32_t R;
  struct {
    vuint32_t CSTAT:32;                /* CRC signature status */
  } B;
} CRC_CSTAT1_tag;

typedef union CRC_OUTP1_union_tag {    /* Output Register */
  vuint32_t R;
  struct {
    vuint32_t OUTP:32;                 /* Final CRC signature */
  } B;
} CRC_OUTP1_tag;

typedef union CRC_CFG2_union_tag {     /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t INV:1;                   /* Inversion selection */
    vuint32_t SWAP:1;                  /* Swap selection */
    vuint32_t POLYG:2;                 /* Polynomial selection */
    vuint32_t SWAP_BITWISE:1;          /* Swap CRC_INP bit-wise */
    vuint32_t SWAP_BYTEWISE:1;         /* Swap CRC_INP byte-wise */
    vuint32_t _unused_6:18;            /* Reserved */
    vuint32_t _unused_24:8;            /* Reserved */
  } B;
} CRC_CFG2_tag;

typedef union CRC_INP2_union_tag {     /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t INP:32;                  /* Input data for the CRC computation */
  } B;
} CRC_INP2_tag;

typedef union CRC_CSTAT2_union_tag {   /* Current Status Register */
  vuint32_t R;
  struct {
    vuint32_t CSTAT:32;                /* CRC signature status */
  } B;
} CRC_CSTAT2_tag;

typedef union CRC_OUTP2_union_tag {    /* Output Register */
  vuint32_t R;
  struct {
    vuint32_t OUTP:32;                 /* Final CRC signature */
  } B;
} CRC_OUTP2_tag;

typedef union CRC_CFG3_union_tag {     /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t INV:1;                   /* Inversion selection */
    vuint32_t SWAP:1;                  /* Swap selection */
    vuint32_t POLYG:2;                 /* Polynomial selection */
    vuint32_t SWAP_BITWISE:1;          /* Swap CRC_INP bit-wise */
    vuint32_t SWAP_BYTEWISE:1;         /* Swap CRC_INP byte-wise */
    vuint32_t _unused_6:18;            /* Reserved */
    vuint32_t _unused_24:8;            /* Reserved */
  } B;
} CRC_CFG3_tag;

typedef union CRC_INP3_union_tag {     /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t INP:32;                  /* Input data for the CRC computation */
  } B;
} CRC_INP3_tag;

typedef union CRC_CSTAT3_union_tag {   /* Current Status Register */
  vuint32_t R;
  struct {
    vuint32_t CSTAT:32;                /* CRC signature status */
  } B;
} CRC_CSTAT3_tag;

typedef union CRC_OUTP3_union_tag {    /* Output Register */
  vuint32_t R;
  struct {
    vuint32_t OUTP:32;                 /* Final CRC signature */
  } B;
} CRC_OUTP3_tag;

struct CRC_tag {
  CRC_CFG1_tag CFG1;                   /* Configuration Register */
  CRC_INP1_tag INP1;                   /* Input Register */
  CRC_CSTAT1_tag CSTAT1;               /* Current Status Register */
  CRC_OUTP1_tag OUTP1;                 /* Output Register */
  CRC_CFG2_tag CFG2;                   /* Configuration Register */
  CRC_INP2_tag INP2;                   /* Input Register */
  CRC_CSTAT2_tag CSTAT2;               /* Current Status Register */
  CRC_OUTP2_tag OUTP2;                 /* Output Register */
  CRC_CFG3_tag CFG3;                   /* Configuration Register */
  CRC_INP3_tag INP3;                   /* Input Register */
  CRC_CSTAT3_tag CSTAT3;               /* Current Status Register */
  CRC_OUTP3_tag OUTP3;                 /* Output Register */
};


/* ============================================================================
   =============================== Module: CTU ================================
   ============================================================================ */

typedef union CTU_TGSISR_union_tag {   /* Trigger Generator Subunit Input Selection Register */
  vuint32_t R;
  struct {
    vuint32_t I0_RE:1;                 /* Input 0 Rising Edge Enable. */
    vuint32_t I0_FE:1;                 /* Input 0 Falling Edge Enable. */
    vuint32_t I1_RE:1;                 /* Input 1 Rising edge Enable */
    vuint32_t I1_FE:1;                 /* Input 1 Falling Edge Enable. */
    vuint32_t I2_RE:1;                 /* Input 2 Rising Edge Enable. */
    vuint32_t I2_FE:1;                 /* Input 2 Falling Edge Enable. */
    vuint32_t I3_RE:1;                 /* Input 3 Rising edge Enable */
    vuint32_t I3_FE:1;                 /* Input 3 Falling Edge Enable. */
    vuint32_t I4_RE:1;                 /* Input 4 Rising Edge Enable. */
    vuint32_t I4_FE:1;                 /* Input 4 Falling Edge Enable. */
    vuint32_t I5_RE:1;                 /* Input 5 Rising Edge Enable. */
    vuint32_t I5_FE:1;                 /* Input 5 Falling Edge Enable. */
    vuint32_t I6_RE:1;                 /* Input 6 Rising Edge Enable. */
    vuint32_t I6_FE:1;                 /* Input 6 Falling Edge Enable. */
    vuint32_t I7_RE:1;                 /* Input 7 Rising Edge Enable. */
    vuint32_t I7_FE:1;                 /* Input 7 Falling Edge Enable. */
    vuint32_t I8_RE:1;                 /* Input 8 Rising Edge Enable. */
    vuint32_t I8_FE:1;                 /* Input 8 Falling Edge Enable. */
    vuint32_t I9_RE:1;                 /* Input 9 Rising Edge Enable. */
    vuint32_t I9_FE:1;                 /* Input 9 Falling Edge Enable. */
    vuint32_t I10_RE:1;                /* Input 10 Rising Edge Enable. */
    vuint32_t I10_FE:1;                /* Input 10 Falling Edge Enable. */
    vuint32_t I11_RE:1;                /* Input 11 Rising Edge Enable. */
    vuint32_t I11_FE:1;                /* Input 11 Falling Edge Enable. */
    vuint32_t I12_RE:1;                /* Input 12 Rising Edge Enable. */
    vuint32_t I12_FE:1;                /* Input 12 Falling Edge Enable. */
    vuint32_t I13_RE:1;                /* Input 13 Rising Edge Enable. */
    vuint32_t I13_FE:1;                /* Input 13 Falling Edge Enable. */
    vuint32_t I14_RE:1;                /* Input 14 Rising Edge Enable. */
    vuint32_t I14_FE:1;                /* Input 14 Falling Edge Enable. */
    vuint32_t I15_RE:1;                /* Input 15 Rising Edge Enable. */
    vuint32_t I15_FE:1;                /* Input 15 Falling Edge Enable. */
  } B;
} CTU_TGSISR_tag;

typedef union CTU_T0CR_union_tag {     /* Trigger Compare Register */
  vuint16_t R;
  struct {
    vuint16_t TCRV:16;                 /* Trigger Compare Register Value */
  } B;
} CTU_T0CR_tag;

typedef union CTU_TGSCR_union_tag {    /* Trigger Generator Subunit Control Register */
  vuint16_t R;
  struct {
    vuint16_t TGS_M:1;                 /* Trigger Generator Subunit Mode */
    vuint16_t MRS_SM:5;
    vuint16_t PRES:2;
    vuint16_t ET_TM:1;
    vuint16_t _unused_9:7;             /* Reserved */
  } B;
} CTU_TGSCR_tag;

typedef union CTU_T2CR_union_tag {     /* Trigger Compare Register */
  vuint16_t R;
  struct {
    vuint16_t TCRV:16;                 /* Trigger Compare Register Value */
  } B;
} CTU_T2CR_tag;

typedef union CTU_T1CR_union_tag {     /* Trigger Compare Register */
  vuint16_t R;
  struct {
    vuint16_t TCRV:16;                 /* Trigger Compare Register Value */
  } B;
} CTU_T1CR_tag;

typedef union CTU_T4CR_union_tag {     /* Trigger Compare Register */
  vuint16_t R;
  struct {
    vuint16_t TCRV:16;                 /* Trigger Compare Register Value */
  } B;
} CTU_T4CR_tag;

typedef union CTU_T3CR_union_tag {     /* Trigger Compare Register */
  vuint16_t R;
  struct {
    vuint16_t TCRV:16;                 /* Trigger Compare Register Value */
  } B;
} CTU_T3CR_tag;

typedef union CTU_T6CR_union_tag {     /* Trigger Compare Register */
  vuint16_t R;
  struct {
    vuint16_t TCRV:16;                 /* Trigger Compare Register Value */
  } B;
} CTU_T6CR_tag;

typedef union CTU_T5CR_union_tag {     /* Trigger Compare Register */
  vuint16_t R;
  struct {
    vuint16_t TCRV:16;                 /* Trigger Compare Register Value */
  } B;
} CTU_T5CR_tag;

typedef union CTU_TGSCCR_union_tag {   /* TGS Counter Compare Register */
  vuint16_t R;
  struct {
    vuint16_t TGSCCV:16;
  } B;
} CTU_TGSCCR_tag;

typedef union CTU_T7CR_union_tag {     /* Trigger Compare Register */
  vuint16_t R;
  struct {
    vuint16_t TCRV:16;                 /* Trigger Compare Register Value */
  } B;
} CTU_T7CR_tag;

typedef union CTU_TGSCRR_union_tag {   /* TGS Counter Reload Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;            /* Reserved */
    vuint32_t TGSCRV:16;               /* TGSCRV */
  } B;
} CTU_TGSCRR_tag;

typedef union CTU_CLCR1_union_tag {    /* Commands List Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t T0_INDEX:5;
    vuint32_t _unused_5:3;             /* Reserved */
    vuint32_t T1_INDEX:5;
    vuint32_t _unused_13:3;            /* Reserved */
    vuint32_t T2_INDEX:5;
    vuint32_t _unused_21:3;            /* Reserved */
    vuint32_t T3_INDEX:5;
    vuint32_t _unused_29:3;            /* Reserved */
  } B;
} CTU_CLCR1_tag;

typedef union CTU_CLCR2_union_tag {    /* Commands List Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t T4_INDEX:5;
    vuint32_t _unused_5:3;             /* Reserved */
    vuint32_t T5_INDEX:5;
    vuint32_t _unused_13:3;            /* Reserved */
    vuint32_t T6_INDEX:5;
    vuint32_t _unused_21:3;            /* Reserved */
    vuint32_t T7_INDEX:5;              /* T7_INDEX */
    vuint32_t _unused_29:3;            /* Reserved */
  } B;
} CTU_CLCR2_tag;

typedef union CTU_THCR1_union_tag {    /* Trigger Handler Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t T0_ADCE:1;
    vuint32_t T0_T1E:1;
    vuint32_t T0_T2E:1;
    vuint32_t T0_T3E:1;
    vuint32_t T0_T4E:1;
    vuint32_t T0_ETE:1;
    vuint32_t T0_E:1;
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t T1_ADCE:1;
    vuint32_t T1_T1E:1;
    vuint32_t T1_T2E:1;
    vuint32_t T1_T3E:1;
    vuint32_t T1_T4E:1;
    vuint32_t T1_ETE:1;
    vuint32_t T1_E:1;
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t T2_ADCE:1;
    vuint32_t T2_T1E:1;
    vuint32_t T2_T2E:1;
    vuint32_t T2_T3E:1;
    vuint32_t T2_T4E:1;
    vuint32_t T2_ETE:1;
    vuint32_t T2_E:1;
    vuint32_t _unused_23:1;            /* Reserved */
    vuint32_t T3_ADCE:1;
    vuint32_t T3_T1E:1;
    vuint32_t T3_T2E:1;
    vuint32_t T3_T3E:1;
    vuint32_t T3_T4E:1;
    vuint32_t T3_ETE:1;
    vuint32_t T3_E:1;
    vuint32_t _unused_31:1;            /* Reserved */
  } B;
} CTU_THCR1_tag;

typedef union CTU_THCR2_union_tag {    /* Trigger Handler Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t T4_ADCE:1;
    vuint32_t T4_T1E:1;
    vuint32_t T4_T2E:1;
    vuint32_t T4_T3E:1;
    vuint32_t T4_T4E:1;
    vuint32_t T4_ETE:1;
    vuint32_t T4_E:1;
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t T5_ADCE:1;
    vuint32_t T5_T1E:1;
    vuint32_t T5_T2E:1;
    vuint32_t T5_T3E:1;
    vuint32_t T5_T4E:1;
    vuint32_t T5_ETE:1;
    vuint32_t T5_E:1;
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t T6_ADCE:1;
    vuint32_t T6_T1E:1;
    vuint32_t T6_T2E:1;
    vuint32_t T6_T3E:1;
    vuint32_t T6_T4E:1;
    vuint32_t T6_ETE:1;
    vuint32_t T6_E:1;
    vuint32_t _unused_23:1;            /* Reserved */
    vuint32_t T7_ADCE:1;
    vuint32_t T7_T1E:1;
    vuint32_t T7_T2E:1;
    vuint32_t T7_T3E:1;
    vuint32_t T7_T4E:1;
    vuint32_t T7_ETE:1;
    vuint32_t T7_E:1;
    vuint32_t _unused_31:1;            /* Reserved */
  } B;
} CTU_THCR2_tag;

typedef union CTU_CLR_C__CLR_B__CLR_A__CLR_A_union_tag { /* Commands List Register A for ADC single-conversion mode commands */
  vuint16_t R;
  struct {
    vuint16_t CH:4;                    /* ADC Port channel number. */
    vuint16_t _unused_4:1;             /* Reserved */
    vuint16_t SU:1;                    /* ADC Port A / Port B selection. */
    vuint16_t _unused_6:3;             /* Reserved */
    vuint16_t ST0:1;                   /* ST0 */
    vuint16_t FIFO:3;                  /* FIFO used for ADC Port A / Port B. */
    vuint16_t CMS:1;
    vuint16_t LC:1;                    /* Last Command bit */
    vuint16_t CIR:1;
  } B;
} CTU_CLR_C__CLR_B__CLR_A__CLR_A_tag;

typedef union CTU_CLR_C__CLR_B__CLR_A__CLR_B_union_tag { /* Command List Register B for ADC dual-conversion mode commands */
  vuint16_t R;
  struct {
    vuint16_t CH_A:4;                  /* ADC Port A channel number. */
    vuint16_t _unused_4:1;             /* Reserved. */
    vuint16_t CH_B:4;                  /* ADC Port B channel number. */
    vuint16_t ST0:1;                   /* Sel-Test mode control 0. Must be 0 in this register format. */
    vuint16_t FIFO:3;                  /* FIFO used for ADC Port A / Port B. */
    vuint16_t CMS:1;
    vuint16_t LC:1;                    /* Last Command bit */
    vuint16_t CIR:1;
  } B;
} CTU_CLR_C__CLR_B__CLR_A__CLR_B_tag;

typedef union CTU_CLR_C__CLR_B__CLR_A__CLR_C_union_tag { /* Command List Register C for self-test commands */
  vuint16_t R;
  struct {
    vuint16_t BSIZE:7;                 /* Burst size of the algorithm iteration */
    vuint16_t ALG:2;                   /* Algorithm scheduled */
    vuint16_t ST0:1;
    vuint16_t _unused_10:1;            /* Reserved */
    vuint16_t ST_SU:1;
    vuint16_t ST_CMS:1;
    vuint16_t ST1:1;
    vuint16_t LC:1;
    vuint16_t CIR:1;
  } B;
} CTU_CLR_C__CLR_B__CLR_A__CLR_C_tag;

typedef union CTU_CLR_C__CLR_B__CLR_A__union_tag {
  CTU_CLR_C__CLR_B__CLR_A__CLR_A_tag CLR_A[24]; /* Commands List Register A for ADC single-conversion mode commands */
  CTU_CLR_C__CLR_B__CLR_A__CLR_B_tag CLR_B[24]; /* Command List Register B for ADC dual-conversion mode commands */
  CTU_CLR_C__CLR_B__CLR_A__CLR_C_tag CLR_C[24]; /* Command List Register C for self-test commands */
} CTU_CLR_C__CLR_B__CLR_A__tag;

typedef union CTU_FDCR_union_tag {     /* FIFO DMA Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;            /* Reserved */
    vuint32_t DE0:1;
    vuint32_t DE1:1;
    vuint32_t DE2:1;
    vuint32_t DE3:1;
    vuint32_t _unused_20:4;            /* Reserved */
    vuint32_t _unused_24:1;            /* Reserved */
    vuint32_t _unused_25:1;            /* Reserved */
    vuint32_t _unused_26:1;            /* Reserved */
    vuint32_t _unused_27:1;            /* Reserved */
    vuint32_t _unused_28:4;            /* Reserved */
  } B;
} CTU_FDCR_tag;

typedef union CTU_FCR_union_tag {      /* FIFO Control Register */
  vuint32_t R;
  struct {
    vuint32_t FULL_EN0:1;
    vuint32_t EMPTY_EN0:1;
    vuint32_t OF_EN0:1;
    vuint32_t OR_EN0:1;
    vuint32_t FULL_EN1:1;
    vuint32_t EMPTY_EN1:1;
    vuint32_t OF_EN1:1;
    vuint32_t OR_EN1:1;
    vuint32_t FULL_EN2:1;
    vuint32_t EMPTY_EN2:1;
    vuint32_t OF_EN2:1;
    vuint32_t OR_EN2:1;
    vuint32_t FULL_EN3:1;
    vuint32_t EMPTY_EN3:1;
    vuint32_t OF_EN3:1;
    vuint32_t OR_EN3:1;
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} CTU_FCR_tag;

typedef union CTU_FTH_union_tag {      /* FIFO Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t TH0:8;
    vuint32_t TH1:8;
    vuint32_t TH2:8;
    vuint32_t TH3:8;
  } B;
} CTU_FTH_tag;

typedef union CTU_FST_union_tag {      /* FIFO Status Register */
  vuint32_t R;
  struct {
    vuint32_t FULL0:1;
    vuint32_t EMP0:1;
    vuint32_t OF0:1;
    vuint32_t OR0:1;
    vuint32_t FULL1:1;                 /* FULL1 */
    vuint32_t EMP1:1;
    vuint32_t OF1:1;
    vuint32_t OR1:1;
    vuint32_t FULL2:1;
    vuint32_t EMP2:1;
    vuint32_t OF2:1;
    vuint32_t OR2:1;
    vuint32_t FULL3:1;
    vuint32_t EMP3:1;
    vuint32_t OF3:1;
    vuint32_t OR3:1;
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} CTU_FST_tag;

typedef union CTU_FR_union_tag {       /* FIFO Right Aligned Data Register */
  vuint32_t R;
  struct {
    vuint32_t DATA:12;
    vuint32_t _unused_12:4;            /* Reserved */
    vuint32_t N_CH:4;
    vuint32_t ADC:1;                   /* This bit indicates from which ADC Port the value in the DATA field corresponds to. */
    vuint32_t _unused_21:11;           /* Reserved */
  } B;
} CTU_FR_tag;

typedef union CTU_FL_union_tag {       /* FIFO Signed Left Aligned Data Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;             /* Reserved */
    vuint32_t LA_DATA:12;              /* LA_DATA */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t N_CH:4;
    vuint32_t ADC:1;                   /* This bit indicates from which ADC Port the value in the DATA field corresponds to. */
    vuint32_t _unused_21:11;           /* Reserved */
  } B;
} CTU_FL_tag;

typedef union CTU_IFR_union_tag {      /* Interrupt Flag Register */
  vuint16_t R;
  struct {
    vuint16_t MRS_I:1;
    vuint16_t T0_I:1;
    vuint16_t T1_I:1;
    vuint16_t T2_I:1;
    vuint16_t T3_I:1;
    vuint16_t T4_I:1;
    vuint16_t T5_I:1;
    vuint16_t T6_I:1;
    vuint16_t T7_I:1;
    vuint16_t ADC_I:1;
    vuint16_t SERR_A:1;
    vuint16_t SERR_B:1;
    vuint16_t _unused_12:4;            /* Reserved */
  } B;
} CTU_IFR_tag;

typedef union CTU_EFR_union_tag {      /* Error Flag Register */
  vuint16_t R;
  struct {
    vuint16_t MRS_RE:1;
    vuint16_t SM_TO:1;
    vuint16_t ICE:1;
    vuint16_t MRS_O:1;
    vuint16_t TGS_OSM:1;
    vuint16_t ADC_OE:1;
    vuint16_t T1_OE:1;
    vuint16_t T2_OE:1;
    vuint16_t T3_OE:1;
    vuint16_t T4_OE:1;
    vuint16_t ERRCMP:1;
    vuint16_t ET_OE:1;
    vuint16_t CS:1;
    vuint16_t LIST_BE:1;
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} CTU_EFR_tag;

typedef union CTU_COTR_union_tag {     /* Control ON Time Register */
  vuint16_t R;
  struct {
    vuint16_t COTGT:8;                 /* COTGT */
    vuint16_t _unused_8:8;             /* Reserved */
  } B;
} CTU_COTR_tag;

typedef union CTU_IR_union_tag {       /* Interrupt/DMA Register */
  vuint16_t R;
  struct {
    vuint16_t IEE:1;
    vuint16_t MRS_IE:1;
    vuint16_t MRS_DMAE:1;
    vuint16_t DMA_DE:1;
    vuint16_t SAF_CNT_A_EN:1;          /* Enable the ADC Port A counter to check the conversion time. */
    vuint16_t SAF_CNT_B_EN:1;          /* Enable the ADC Port B counter to check the conversion time. */
    vuint16_t _unused_6:2;             /* Reserved */
    vuint16_t T0_IE:1;                 /* Trigger 0 Interrupt Enable */
    vuint16_t T1_IE:1;                 /* Trigger 1 Interrupt Enable */
    vuint16_t T2_IE:1;                 /* Trigger 2 Interrupt Enable */
    vuint16_t T3_IE:1;                 /* Trigger 3 Interrupt Enable */
    vuint16_t T4_IE:1;                 /* Trigger 4 Interrupt Enable */
    vuint16_t T5_IE:1;                 /* Trigger 5 Interrupt Enable */
    vuint16_t T6_IE:1;                 /* Trigger 6 Interrupt Enable */
    vuint16_t T7_IE:1;                 /* Trigger 7 Interrupt Enable */
  } B;
} CTU_IR_tag;

typedef union CTU_DFR_union_tag {      /* Digital Filter Register */
  vuint16_t R;
  struct {
    vuint16_t FILTER_N:8;
    vuint16_t _unused_8:8;             /* Reserved */
  } B;
} CTU_DFR_tag;

typedef union CTU_CR_union_tag {       /* Control Register */
  vuint16_t R;
  struct {
    vuint16_t TGSISR_RE:1;
    vuint16_t GRE:1;
    vuint16_t MRS_SG:1;
    vuint16_t FGRE:1;
    vuint16_t CGRE:1;
    vuint16_t DFE:1;
    vuint16_t CTU_ODIS:1;
    vuint16_t CTU_ADC_R:1;
    vuint16_t T0_SG:1;
    vuint16_t T1_SG:1;
    vuint16_t T2_SG:1;
    vuint16_t T3_SG:1;
    vuint16_t T4_SG:1;
    vuint16_t T5_SG:1;
    vuint16_t T6_SG:1;
    vuint16_t T7_SG:1;
  } B;
} CTU_CR_tag;

typedef union CTU_EXPBR_union_tag {    /* Expected Value B Register */
  vuint16_t R;
  struct {
    vuint16_t EXPB:16;                 /* This value is the expected number of system clock cycles needed by ADC Port B to complete a conversion. */
  } B;
} CTU_EXPBR_tag;

typedef union CTU_EXPAR_union_tag {    /* Expected Value A Register */
  vuint16_t R;
  struct {
    vuint16_t EXPA:16;                 /* This value is the expected number of system clock cycles needed by ADC Port A to complete a conversion. */
  } B;
} CTU_EXPAR_tag;

typedef union CTU_CNTRNGR_union_tag {  /* Counter Range Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:16;            /* Reserved */
    vuint32_t CNTRNG:8;                /* CNTRNG */
    vuint32_t _unused_24:8;            /* Reserved */
  } B;
} CTU_CNTRNGR_tag;

typedef union CTU_LISTCSR_union_tag {  /* List Control/Status Register */
  vuint32_t R;
  struct {
    vuint32_t PAR_LIST:1;
    vuint32_t _unused_1:15;            /* Reserved */
    vuint32_t LIST0_ADDR:5;            /* List Address 0. Indicates the command address being executed when LIST_BE flag in EFR register was set. */
    vuint32_t _unused_21:2;            /* Reserved */
    vuint32_t LIST0_BLK:1;
    vuint32_t LIST1_ADDR:5;
    vuint32_t _unused_29:2;            /* Reserved */
    vuint32_t LIST1_BLK:1;
  } B;
} CTU_LISTCSR_tag;

struct CTU_tag {
  CTU_TGSISR_tag TGSISR;               /* Trigger Generator Subunit Input Selection Register */
  CTU_T0CR_tag T0CR;                   /* Trigger Compare Register */
  CTU_TGSCR_tag TGSCR;                 /* Trigger Generator Subunit Control Register */
  CTU_T2CR_tag T2CR;                   /* Trigger Compare Register */
  CTU_T1CR_tag T1CR;                   /* Trigger Compare Register */
  CTU_T4CR_tag T4CR;                   /* Trigger Compare Register */
  CTU_T3CR_tag T3CR;                   /* Trigger Compare Register */
  CTU_T6CR_tag T6CR;                   /* Trigger Compare Register */
  CTU_T5CR_tag T5CR;                   /* Trigger Compare Register */
  CTU_TGSCCR_tag TGSCCR;               /* TGS Counter Compare Register */
  CTU_T7CR_tag T7CR;                   /* Trigger Compare Register */
  CTU_TGSCRR_tag TGSCRR;               /* TGS Counter Reload Register */
  CTU_CLCR1_tag CLCR1;                 /* Commands List Control Register 1 */
  CTU_CLCR2_tag CLCR2;                 /* Commands List Control Register 2 */
  CTU_THCR1_tag THCR1;                 /* Trigger Handler Control Register 1 */
  CTU_THCR2_tag THCR2;                 /* Trigger Handler Control Register 2 */
  CTU_CLR_C__CLR_B__CLR_A__tag CLR_C__CLR_B__CLR_A_;
  uint8_t CTU_reserved0[16];
  CTU_FDCR_tag FDCR;                   /* FIFO DMA Control Register */
  CTU_FCR_tag FCR;                     /* FIFO Control Register */
  CTU_FTH_tag FTH;                     /* FIFO Threshold Register */
  uint8_t CTU_reserved1[4];
  CTU_FST_tag FST;                     /* FIFO Status Register */
  CTU_FR_tag FR[4];                    /* FIFO Right Aligned Data Register */
  uint8_t CTU_reserved2[16];
  CTU_FL_tag FL[4];                    /* FIFO Signed Left Aligned Data Register */
  uint8_t CTU_reserved3[16];
  CTU_IFR_tag IFR;                     /* Interrupt Flag Register */
  CTU_EFR_tag EFR;                     /* Error Flag Register */
  CTU_COTR_tag COTR;                   /* Control ON Time Register */
  CTU_IR_tag IR;                       /* Interrupt/DMA Register */
  CTU_DFR_tag DFR;                     /* Digital Filter Register */
  CTU_CR_tag CR;                       /* Control Register */
  CTU_EXPBR_tag EXPBR;                 /* Expected Value B Register */
  CTU_EXPAR_tag EXPAR;                 /* Expected Value A Register */
  CTU_CNTRNGR_tag CNTRNGR;             /* Counter Range Register */
  CTU_LISTCSR_tag LISTCSR;             /* List Control/Status Register */
};


/* ============================================================================
   =============================== Module: DFS ================================
   ============================================================================ */

typedef union DFS_PORTSR_union_tag {   /* Port status register */
  vuint32_t R;
  struct {
    vuint32_t PORTSTAT:6;              /* Port status */
    vuint32_t _unused_6:26;
  } B;
} DFS_PORTSR_tag;

typedef union DFS_PORTLOLSR_union_tag { /* Port Loss of Lock Status */
  vuint32_t R;
  struct {
    vuint32_t LOLF0:1;                 /* Loss of lock flag */
    vuint32_t LOLF1:1;                 /* Loss of lock flag */
    vuint32_t LOLF2:1;                 /* Loss of lock flag */
    vuint32_t LOLF3:1;                 /* Loss of lock flag */
    vuint32_t LOLF4:1;                 /* Loss of lock flag */
    vuint32_t LOLF5:1;                 /* Loss of lock flag */
    vuint32_t _unused_6:26;
  } B;
} DFS_PORTLOLSR_tag;

typedef union DFS_PORTRESET_union_tag { /* Port Reset */
  vuint32_t R;
  struct {
    vuint32_t RESET0:1;
    vuint32_t RESET1:1;
    vuint32_t RESET2:1;
    vuint32_t RESET3:1;
    vuint32_t RESET4:1;
    vuint32_t RESET5:1;
    vuint32_t _unused_6:26;
  } B;
} DFS_PORTRESET_tag;

typedef union DFS_CTL_union_tag {      /* Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;
    vuint32_t DFS_RESET:1;
    vuint32_t _unused_2:30;
  } B;
} DFS_CTL_tag;

typedef union DFS_DVPORT_union_tag {   /* Divider for Port 0 */
  vuint32_t R;
  struct {
    vuint32_t MFN:6;
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t MFI:8;
    vuint32_t _unused_16:16;
  } B;
} DFS_DVPORT_tag;

struct DFS_tag {
  uint8_t DFS_reserved0[12];
  DFS_PORTSR_tag PORTSR;               /* Port status register */
  DFS_PORTLOLSR_tag PORTLOLSR;         /* Port Loss of Lock Status */
  DFS_PORTRESET_tag PORTRESET;         /* Port Reset */
  DFS_CTL_tag CTL;                     /* Control */
  DFS_DVPORT_tag DVPORT[6];            /* Divider for Port 0 */
};


/* ============================================================================
   =============================== Module: DIPORTSD ===========================
   ============================================================================ */

typedef union DIPORTSD_ECR_union_tag { /* Error and Control Register */
  vuint32_t R;
  struct {
    vuint32_t NCRC_ERR_EN:1;           /* Normal Mode CRC Error Enable */
    vuint32_t MFRM_ERR_EN:1;           /* Message Frame Error Enable */
    vuint32_t MID_ERR_EN:1;            /* Message ID Error Enable */
    vuint32_t MPRC_ERR_EN:1;           /* Message Processing Error Enable */
    vuint32_t MADD_ERR_EN:1;           /* Message Address Error Enable */
    vuint32_t RSP_ERR_EN:1;            /* Response Error Enable */
    vuint32_t _unused_6:26;
  } B;
} DIPORTSD_ECR_tag;

typedef union DIPORTSD_SESR_union_tag { /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t NCRC_ERR:1;              /* Normal Mode CRC Error Status */
    vuint32_t MFRM_ERR:1;              /* Message Frame Error Status */
    vuint32_t MID_ERR:1;               /* Message ID Error Status */
    vuint32_t MPRC_ERR:1;              /* Message Processing Error Status */
    vuint32_t MADD_ERR:1;              /* Message Address Error Status */
    vuint32_t RSP_ERR:1;               /* Response Error Status */
    vuint32_t _unused_6:26;
  } B;
} DIPORTSD_SESR_tag;

typedef union DIPORTSD_QOS_union_tag { /* Quality Of Service */
  vuint32_t R;
  struct {
    vuint32_t SQOS:2;                  /* Quality of Service */
    vuint32_t _unused_2:6;
    vuint32_t AABW:5;                  /* Active AXI Bandwidth */
    vuint32_t _unused_13:19;
  } B;
} DIPORTSD_QOS_tag;

typedef union DIPORTSD_SIGEN_union_tag { /* Signaling Enable */
  vuint32_t R;
  struct {
    vuint32_t SIGEN:8;                 /* Signaling Enable */
    vuint32_t _unused_8:24;
  } B;
} DIPORTSD_SIGEN_tag;

typedef union DIPORTSD_RSRV0_union_tag { /* Reserved 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:3;             /* Reserved. Do not change field value. */
    vuint32_t _unused_3:29;
  } B;
} DIPORTSD_RSRV0_tag;

typedef union DIPORTSD_LAR0_union_tag { /* Logical Address Region 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Logical Address for Expansion Region 0 */
  } B;
} DIPORTSD_LAR0_tag;

typedef union DIPORTSD_PAR0_union_tag { /* Physical Address Region 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Physical Address for Expansion Region 0 */
  } B;
} DIPORTSD_PAR0_tag;

typedef union DIPORTSD_RS0_union_tag { /* Region Size 0 */
  vuint32_t R;
  struct {
    vuint32_t BLOCK_SIZE:5;            /* Block Size of the Expansion Address Region 0 */
    vuint32_t _unused_5:27;
  } B;
} DIPORTSD_RS0_tag;

typedef union DIPORTSD_LAR1_union_tag { /* Logical Address Region 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Logical Address for Expansion Region 1 */
  } B;
} DIPORTSD_LAR1_tag;

typedef union DIPORTSD_PAR1_union_tag { /* Physical Address Region 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Physical Address for Expansion Region 1 */
  } B;
} DIPORTSD_PAR1_tag;

typedef union DIPORTSD_RS1_union_tag { /* Region Size 1 */
  vuint32_t R;
  struct {
    vuint32_t BLOCK_SIZE:5;            /* Block Size of the Expansion Address Region 1 */
    vuint32_t _unused_5:27;
  } B;
} DIPORTSD_RS1_tag;

typedef union DIPORTSD_LAR2_union_tag { /* Logical Address Region 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Logical Address for Expansion Region 2 */
  } B;
} DIPORTSD_LAR2_tag;

typedef union DIPORTSD_PAR2_union_tag { /* Physical Address Region 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Physical Address for Expansion Region 2 */
  } B;
} DIPORTSD_PAR2_tag;

typedef union DIPORTSD_RS2_union_tag { /* Region Size 2 */
  vuint32_t R;
  struct {
    vuint32_t BLOCK_SIZE:5;            /* Block Size of the Expansion Address Region 2 */
    vuint32_t _unused_5:27;
  } B;
} DIPORTSD_RS2_tag;

typedef union DIPORTSD_LAR3_union_tag { /* Logical Address Region 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Logical Address for Expansion Region 3 */
  } B;
} DIPORTSD_LAR3_tag;

typedef union DIPORTSD_PAR3_union_tag { /* Physical Address Region 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Physical Address for Expansion Region 3 */
  } B;
} DIPORTSD_PAR3_tag;

typedef union DIPORTSD_RS3_union_tag { /* Region Size 3 */
  vuint32_t R;
  struct {
    vuint32_t BLOCK_SIZE:5;            /* Block Size of the Expansion Address Region 3 */
    vuint32_t _unused_5:27;
  } B;
} DIPORTSD_RS3_tag;

typedef union DIPORTSD_LAR4_union_tag { /* Logical Address Region 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Logical Address for Expansion Region 4 */
  } B;
} DIPORTSD_LAR4_tag;

typedef union DIPORTSD_PAR4_union_tag { /* Physical Address Region 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Physical Address for Expansion Region 4 */
  } B;
} DIPORTSD_PAR4_tag;

typedef union DIPORTSD_RS4_union_tag { /* Region Size 4 */
  vuint32_t R;
  struct {
    vuint32_t BLOCK_SIZE:5;            /* Block Size of the Expansion Address Region 4 */
    vuint32_t _unused_5:27;
  } B;
} DIPORTSD_RS4_tag;

typedef union DIPORTSD_LAR5_union_tag { /* Logical Address Region 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Logical Address for Expansion Region 5 */
  } B;
} DIPORTSD_LAR5_tag;

typedef union DIPORTSD_PAR5_union_tag { /* Physical Address Region 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Physical Address for Expansion Region 5 */
  } B;
} DIPORTSD_PAR5_tag;

typedef union DIPORTSD_RS5_union_tag { /* Region Size 5 */
  vuint32_t R;
  struct {
    vuint32_t BLOCK_SIZE:5;            /* Block Size of the Expansion Address Region 5 */
    vuint32_t _unused_5:27;
  } B;
} DIPORTSD_RS5_tag;

typedef union DIPORTSD_LAR6_union_tag { /* Logical Address Region 6 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Logical Address for Expansion Region 6 */
  } B;
} DIPORTSD_LAR6_tag;

typedef union DIPORTSD_PAR6_union_tag { /* Physical Address Region 6 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Physical Address for Expansion Region 6 */
  } B;
} DIPORTSD_PAR6_tag;

typedef union DIPORTSD_RS6_union_tag { /* Region Size 6 */
  vuint32_t R;
  struct {
    vuint32_t BLOCK_SIZE:5;            /* Block Size of the Expansion Address Region 6 */
    vuint32_t _unused_5:27;
  } B;
} DIPORTSD_RS6_tag;

typedef union DIPORTSD_LAR7_union_tag { /* Logical Address Region 7 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Logical Address for Expansion Region 7 */
  } B;
} DIPORTSD_LAR7_tag;

typedef union DIPORTSD_PAR7_union_tag { /* Physical Address Region 7 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:12;
    vuint32_t START_ADDR:20;           /* Starting Physical Address for Expansion Region 7 */
  } B;
} DIPORTSD_PAR7_tag;

typedef union DIPORTSD_RS7_union_tag { /* Region Size 7 */
  vuint32_t R;
  struct {
    vuint32_t BLOCK_SIZE:5;            /* Block Size of the Expansion Address Region 7 */
    vuint32_t _unused_5:27;
  } B;
} DIPORTSD_RS7_tag;

typedef union DIPORTSD_RSRV1_union_tag { /* Reserved 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;             /* Reserved. Do not change field value. */
    vuint32_t _unused_8:11;
    vuint32_t _unused_19:5;            /* Reserved. Do not change field value. */
    vuint32_t _unused_24:6;
    vuint32_t _unused_30:2;            /* Reserved. Do not change field value. */
  } B;
} DIPORTSD_RSRV1_tag;

typedef union DIPORTSD_RSRV2_union_tag { /* Reserved 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} DIPORTSD_RSRV2_tag;

typedef union DIPORTSD_RSRV3_union_tag { /* Reserved 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} DIPORTSD_RSRV3_tag;

typedef union DIPORTSD_RSRV4_union_tag { /* Reserved 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} DIPORTSD_RSRV4_tag;

typedef union DIPORTSD_RSRV5_union_tag { /* Reserved 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} DIPORTSD_RSRV5_tag;

struct DIPORTSD_tag {
  uint8_t DIPORTSD_reserved0[256];
  DIPORTSD_ECR_tag ECR;                /* Error and Control Register */
  DIPORTSD_SESR_tag SESR;              /* Error Status Register */
  DIPORTSD_QOS_tag QOS;                /* Quality Of Service */
  DIPORTSD_SIGEN_tag SIGEN;            /* Signaling Enable */
  uint8_t DIPORTSD_reserved1[8];
  DIPORTSD_RSRV0_tag RSRV0;            /* Reserved 0 */
  uint8_t DIPORTSD_reserved2[12];
  DIPORTSD_LAR0_tag LAR0;              /* Logical Address Region 0 */
  DIPORTSD_PAR0_tag PAR0;              /* Physical Address Region 0 */
  DIPORTSD_RS0_tag RS0;                /* Region Size 0 */
  DIPORTSD_LAR1_tag LAR1;              /* Logical Address Region 1 */
  DIPORTSD_PAR1_tag PAR1;              /* Physical Address Region 1 */
  DIPORTSD_RS1_tag RS1;                /* Region Size 1 */
  DIPORTSD_LAR2_tag LAR2;              /* Logical Address Region 2 */
  DIPORTSD_PAR2_tag PAR2;              /* Physical Address Region 2 */
  DIPORTSD_RS2_tag RS2;                /* Region Size 2 */
  DIPORTSD_LAR3_tag LAR3;              /* Logical Address Region 3 */
  DIPORTSD_PAR3_tag PAR3;              /* Physical Address Region 3 */
  DIPORTSD_RS3_tag RS3;                /* Region Size 3 */
  DIPORTSD_LAR4_tag LAR4;              /* Logical Address Region 4 */
  DIPORTSD_PAR4_tag PAR4;              /* Physical Address Region 4 */
  DIPORTSD_RS4_tag RS4;                /* Region Size 4 */
  DIPORTSD_LAR5_tag LAR5;              /* Logical Address Region 5 */
  DIPORTSD_PAR5_tag PAR5;              /* Physical Address Region 5 */
  DIPORTSD_RS5_tag RS5;                /* Region Size 5 */
  DIPORTSD_LAR6_tag LAR6;              /* Logical Address Region 6 */
  DIPORTSD_PAR6_tag PAR6;              /* Physical Address Region 6 */
  DIPORTSD_RS6_tag RS6;                /* Region Size 6 */
  DIPORTSD_LAR7_tag LAR7;              /* Logical Address Region 7 */
  DIPORTSD_PAR7_tag PAR7;              /* Physical Address Region 7 */
  DIPORTSD_RS7_tag RS7;                /* Region Size 7 */
  uint8_t DIPORTSD_reserved3[120];
  DIPORTSD_RSRV1_tag RSRV1;            /* Reserved 1 */
  DIPORTSD_RSRV2_tag RSRV2;            /* Reserved 2 */
  DIPORTSD_RSRV3_tag RSRV3;            /* Reserved 3 */
  DIPORTSD_RSRV4_tag RSRV4;            /* Reserved 4 */
  DIPORTSD_RSRV5_tag RSRV5;            /* Reserved 5 */
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

typedef union DMAMUX_CHCFG_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_CHCFG_tag;

struct DMAMUX_tag {
  DMAMUX_CHCFG_tag CHCFG[16];          /* Channel Configuration register */
};


/* ============================================================================
   =============================== Module: DMAMUX_AE ==========================
   ============================================================================ */

typedef union DMAMUX_AE_CHCFG_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
  } B;
} DMAMUX_AE_CHCFG_tag;

struct DMAMUX_AE_tag {
  DMAMUX_AE_CHCFG_tag CHCFG[16];       /* Channel Configuration register */
};


/* ============================================================================
   =============================== Module: DMA_CRC ============================
   ============================================================================ */

typedef union DMA_CRC_GEC_union_tag {  /* Global Enable CRC Register */
  vuint32_t R;
  struct {
    vuint32_t GBL_EN:1;                /* Global Enable bit */
    vuint32_t _unused_1:31;            /* Reserved */
  } B;
} DMA_CRC_GEC_tag;

typedef union DMA_CRC_CTL0_union_tag { /* CRC Control Register */
  vuint32_t R;
  struct {
    vuint32_t CH_SEL:6;                /* Channel Select */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t POLY_SEL:4;              /* Polynomial Select */
    vuint32_t _unused_12:3;            /* Reserved */
    vuint32_t INIT_SEL:1;              /* Initial values of the CRC */
    vuint32_t MODE:3;                  /* CRC Mode */
    vuint32_t _unused_19:12;           /* Reserved */
    vuint32_t EN:1;                    /* CRC Logic */
  } B;
} DMA_CRC_CTL0_tag;

typedef union DMA_CRC_ICRC0_union_tag { /* Initial CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t INI_CRC_VAL:32;          /* Initial CRC Value */
  } B;
} DMA_CRC_ICRC0_tag;

typedef union DMA_CRC_FCRC0_union_tag { /* Final CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t CHKSUM_VAL:32;           /* Final CRC Value */
  } B;
} DMA_CRC_FCRC0_tag;

typedef union DMA_CRC_CTL1_union_tag { /* CRC Control Register */
  vuint32_t R;
  struct {
    vuint32_t CH_SEL:6;                /* Channel Select */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t POLY_SEL:4;              /* Polynomial Select */
    vuint32_t _unused_12:3;            /* Reserved */
    vuint32_t INIT_SEL:1;              /* Initial values of the CRC */
    vuint32_t MODE:3;                  /* CRC Mode */
    vuint32_t _unused_19:12;           /* Reserved */
    vuint32_t EN:1;                    /* CRC Logic */
  } B;
} DMA_CRC_CTL1_tag;

typedef union DMA_CRC_ICRC1_union_tag { /* Initial CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t INI_CRC_VAL:32;          /* Initial CRC Value */
  } B;
} DMA_CRC_ICRC1_tag;

typedef union DMA_CRC_FCRC1_union_tag { /* Final CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t CHKSUM_VAL:32;           /* Final CRC Value */
  } B;
} DMA_CRC_FCRC1_tag;

typedef union DMA_CRC_CTL2_union_tag { /* CRC Control Register */
  vuint32_t R;
  struct {
    vuint32_t CH_SEL:6;                /* Channel Select */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t POLY_SEL:4;              /* Polynomial Select */
    vuint32_t _unused_12:3;            /* Reserved */
    vuint32_t INIT_SEL:1;              /* Initial values of the CRC */
    vuint32_t MODE:3;                  /* CRC Mode */
    vuint32_t _unused_19:12;           /* Reserved */
    vuint32_t EN:1;                    /* CRC Logic */
  } B;
} DMA_CRC_CTL2_tag;

typedef union DMA_CRC_ICRC2_union_tag { /* Initial CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t INI_CRC_VAL:32;          /* Initial CRC Value */
  } B;
} DMA_CRC_ICRC2_tag;

typedef union DMA_CRC_FCRC2_union_tag { /* Final CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t CHKSUM_VAL:32;           /* Final CRC Value */
  } B;
} DMA_CRC_FCRC2_tag;

typedef union DMA_CRC_CTL3_union_tag { /* CRC Control Register */
  vuint32_t R;
  struct {
    vuint32_t CH_SEL:6;                /* Channel Select */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t POLY_SEL:4;              /* Polynomial Select */
    vuint32_t _unused_12:3;            /* Reserved */
    vuint32_t INIT_SEL:1;              /* Initial values of the CRC */
    vuint32_t MODE:3;                  /* CRC Mode */
    vuint32_t _unused_19:12;           /* Reserved */
    vuint32_t EN:1;                    /* CRC Logic */
  } B;
} DMA_CRC_CTL3_tag;

typedef union DMA_CRC_ICRC3_union_tag { /* Initial CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t INI_CRC_VAL:32;          /* Initial CRC Value */
  } B;
} DMA_CRC_ICRC3_tag;

typedef union DMA_CRC_FCRC3_union_tag { /* Final CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t CHKSUM_VAL:32;           /* Final CRC Value */
  } B;
} DMA_CRC_FCRC3_tag;

typedef union DMA_CRC_CTL4_union_tag { /* CRC Control Register */
  vuint32_t R;
  struct {
    vuint32_t CH_SEL:6;                /* Channel Select */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t POLY_SEL:4;              /* Polynomial Select */
    vuint32_t _unused_12:3;            /* Reserved */
    vuint32_t INIT_SEL:1;              /* Initial values of the CRC */
    vuint32_t MODE:3;                  /* CRC Mode */
    vuint32_t _unused_19:12;           /* Reserved */
    vuint32_t EN:1;                    /* CRC Logic */
  } B;
} DMA_CRC_CTL4_tag;

typedef union DMA_CRC_ICRC4_union_tag { /* Initial CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t INI_CRC_VAL:32;          /* Initial CRC Value */
  } B;
} DMA_CRC_ICRC4_tag;

typedef union DMA_CRC_FCRC4_union_tag { /* Final CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t CHKSUM_VAL:32;           /* Final CRC Value */
  } B;
} DMA_CRC_FCRC4_tag;

typedef union DMA_CRC_CTL5_union_tag { /* CRC Control Register */
  vuint32_t R;
  struct {
    vuint32_t CH_SEL:6;                /* Channel Select */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t POLY_SEL:4;              /* Polynomial Select */
    vuint32_t _unused_12:3;            /* Reserved */
    vuint32_t INIT_SEL:1;              /* Initial values of the CRC */
    vuint32_t MODE:3;                  /* CRC Mode */
    vuint32_t _unused_19:12;           /* Reserved */
    vuint32_t EN:1;                    /* CRC Logic */
  } B;
} DMA_CRC_CTL5_tag;

typedef union DMA_CRC_ICRC5_union_tag { /* Initial CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t INI_CRC_VAL:32;          /* Initial CRC Value */
  } B;
} DMA_CRC_ICRC5_tag;

typedef union DMA_CRC_FCRC5_union_tag { /* Final CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t CHKSUM_VAL:32;           /* Final CRC Value */
  } B;
} DMA_CRC_FCRC5_tag;

typedef union DMA_CRC_CTL6_union_tag { /* CRC Control Register */
  vuint32_t R;
  struct {
    vuint32_t CH_SEL:6;                /* Channel Select */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t POLY_SEL:4;              /* Polynomial Select */
    vuint32_t _unused_12:3;            /* Reserved */
    vuint32_t INIT_SEL:1;              /* Initial values of the CRC */
    vuint32_t MODE:3;                  /* CRC Mode */
    vuint32_t _unused_19:12;           /* Reserved */
    vuint32_t EN:1;                    /* CRC Logic */
  } B;
} DMA_CRC_CTL6_tag;

typedef union DMA_CRC_ICRC6_union_tag { /* Initial CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t INI_CRC_VAL:32;          /* Initial CRC Value */
  } B;
} DMA_CRC_ICRC6_tag;

typedef union DMA_CRC_FCRC6_union_tag { /* Final CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t CHKSUM_VAL:32;           /* Final CRC Value */
  } B;
} DMA_CRC_FCRC6_tag;

typedef union DMA_CRC_CTL7_union_tag { /* CRC Control Register */
  vuint32_t R;
  struct {
    vuint32_t CH_SEL:6;                /* Channel Select */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t POLY_SEL:4;              /* Polynomial Select */
    vuint32_t _unused_12:3;            /* Reserved */
    vuint32_t INIT_SEL:1;              /* Initial values of the CRC */
    vuint32_t MODE:3;                  /* CRC Mode */
    vuint32_t _unused_19:12;           /* Reserved */
    vuint32_t EN:1;                    /* CRC Logic */
  } B;
} DMA_CRC_CTL7_tag;

typedef union DMA_CRC_ICRC7_union_tag { /* Initial CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t INI_CRC_VAL:32;          /* Initial CRC Value */
  } B;
} DMA_CRC_ICRC7_tag;

typedef union DMA_CRC_FCRC7_union_tag { /* Final CRC Value Register */
  vuint32_t R;
  struct {
    vuint32_t CHKSUM_VAL:32;           /* Final CRC Value */
  } B;
} DMA_CRC_FCRC7_tag;

struct DMA_CRC_tag {
  DMA_CRC_GEC_tag GEC;                 /* Global Enable CRC Register */
  uint8_t DMA_CRC_reserved0[12];
  DMA_CRC_CTL0_tag CTL0;               /* CRC Control Register */
  DMA_CRC_ICRC0_tag ICRC0;             /* Initial CRC Value Register */
  DMA_CRC_FCRC0_tag FCRC0;             /* Final CRC Value Register */
  uint8_t DMA_CRC_reserved1[4];
  DMA_CRC_CTL1_tag CTL1;               /* CRC Control Register */
  DMA_CRC_ICRC1_tag ICRC1;             /* Initial CRC Value Register */
  DMA_CRC_FCRC1_tag FCRC1;             /* Final CRC Value Register */
  uint8_t DMA_CRC_reserved2[4];
  DMA_CRC_CTL2_tag CTL2;               /* CRC Control Register */
  DMA_CRC_ICRC2_tag ICRC2;             /* Initial CRC Value Register */
  DMA_CRC_FCRC2_tag FCRC2;             /* Final CRC Value Register */
  uint8_t DMA_CRC_reserved3[4];
  DMA_CRC_CTL3_tag CTL3;               /* CRC Control Register */
  DMA_CRC_ICRC3_tag ICRC3;             /* Initial CRC Value Register */
  DMA_CRC_FCRC3_tag FCRC3;             /* Final CRC Value Register */
  uint8_t DMA_CRC_reserved4[4];
  DMA_CRC_CTL4_tag CTL4;               /* CRC Control Register */
  DMA_CRC_ICRC4_tag ICRC4;             /* Initial CRC Value Register */
  DMA_CRC_FCRC4_tag FCRC4;             /* Final CRC Value Register */
  uint8_t DMA_CRC_reserved5[4];
  DMA_CRC_CTL5_tag CTL5;               /* CRC Control Register */
  DMA_CRC_ICRC5_tag ICRC5;             /* Initial CRC Value Register */
  DMA_CRC_FCRC5_tag FCRC5;             /* Final CRC Value Register */
  uint8_t DMA_CRC_reserved6[4];
  DMA_CRC_CTL6_tag CTL6;               /* CRC Control Register */
  DMA_CRC_ICRC6_tag ICRC6;             /* Initial CRC Value Register */
  DMA_CRC_FCRC6_tag FCRC6;             /* Final CRC Value Register */
  uint8_t DMA_CRC_reserved7[4];
  DMA_CRC_CTL7_tag CTL7;               /* CRC Control Register */
  DMA_CRC_ICRC7_tag ICRC7;             /* Initial CRC Value Register */
  DMA_CRC_FCRC7_tag FCRC7;             /* Final CRC Value Register */
};


/* ============================================================================
   =============================== Module: EDMA_AE ============================
   ============================================================================ */

typedef union EDMA_AE_CR_union_tag {   /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;             /* Reserved */
    vuint32_t EDBG:1;                  /* Enable Debug */
    vuint32_t ERCA:1;                  /* Enable Round Robin Channel Arbitration */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t HOE:1;                   /* Halt On Error */
    vuint32_t HALT:1;                  /* Halt DMA Operations */
    vuint32_t CLM:1;                   /* Continuous Link Mode */
    vuint32_t EMLM:1;                  /* Enable Minor Loop Mapping */
    vuint32_t _unused_8:8;             /* Reserved */
    vuint32_t ECX:1;                   /* Error Cancel Transfer */
    vuint32_t CX:1;                    /* Cancel Transfer */
    vuint32_t _unused_18:6;            /* Reserved */
    vuint32_t _unused_24:7;            /* eDMA version number */
    vuint32_t ACTIVE:1;                /* DMA Active Status */
  } B;
} EDMA_AE_CR_tag;

typedef union EDMA_AE_ES_union_tag {   /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t DBE:1;                   /* Destination Bus Error */
    vuint32_t SBE:1;                   /* Source Bus Error */
    vuint32_t SGE:1;                   /* Scatter/Gather Configuration Error */
    vuint32_t NCE:1;                   /* NBYTES/CITER Configuration Error */
    vuint32_t DOE:1;                   /* Destination Offset Error */
    vuint32_t DAE:1;                   /* Destination Address Error */
    vuint32_t SOE:1;                   /* Source Offset Error */
    vuint32_t SAE:1;                   /* Source Address Error */
    vuint32_t ERRCHN:4;                /* Error Channel Number or Canceled Channel Number */
    vuint32_t _unused_12:2;            /* Reserved */
    vuint32_t CPE:1;                   /* Channel Priority Error */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t ECX:1;                   /* Transfer Canceled */
    vuint32_t _unused_17:14;           /* Reserved */
    vuint32_t VLD:1;                   /* VLD */
  } B;
} EDMA_AE_ES_tag;

typedef union EDMA_AE_ERQ_union_tag {  /* Enable Request Register */
  vuint32_t R;
  struct {
    vuint32_t ERQ0:1;                  /* Enable DMA Request 0 */
    vuint32_t ERQ1:1;                  /* Enable DMA Request 1 */
    vuint32_t ERQ2:1;                  /* Enable DMA Request 2 */
    vuint32_t ERQ3:1;                  /* Enable DMA Request 3 */
    vuint32_t ERQ4:1;                  /* Enable DMA Request 4 */
    vuint32_t ERQ5:1;                  /* Enable DMA Request 5 */
    vuint32_t ERQ6:1;                  /* Enable DMA Request 6 */
    vuint32_t ERQ7:1;                  /* Enable DMA Request 7 */
    vuint32_t ERQ8:1;                  /* Enable DMA Request 8 */
    vuint32_t ERQ9:1;                  /* Enable DMA Request 9 */
    vuint32_t ERQ10:1;                 /* Enable DMA Request 10 */
    vuint32_t ERQ11:1;                 /* Enable DMA Request 11 */
    vuint32_t ERQ12:1;                 /* Enable DMA Request 12 */
    vuint32_t ERQ13:1;                 /* Enable DMA Request 13 */
    vuint32_t ERQ14:1;                 /* Enable DMA Request 14 */
    vuint32_t ERQ15:1;                 /* Enable DMA Request 15 */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} EDMA_AE_ERQ_tag;

typedef union EDMA_AE_EEI_union_tag {  /* Enable Error Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t EEI0:1;                  /* Enable Error Interrupt 0 */
    vuint32_t EEI1:1;                  /* Enable Error Interrupt 1 */
    vuint32_t EEI2:1;                  /* Enable Error Interrupt 2 */
    vuint32_t EEI3:1;                  /* Enable Error Interrupt 3 */
    vuint32_t EEI4:1;                  /* Enable Error Interrupt 4 */
    vuint32_t EEI5:1;                  /* Enable Error Interrupt 5 */
    vuint32_t EEI6:1;                  /* Enable Error Interrupt 6 */
    vuint32_t EEI7:1;                  /* Enable Error Interrupt 7 */
    vuint32_t EEI8:1;                  /* Enable Error Interrupt 8 */
    vuint32_t EEI9:1;                  /* Enable Error Interrupt 9 */
    vuint32_t EEI10:1;                 /* Enable Error Interrupt 10 */
    vuint32_t EEI11:1;                 /* Enable Error Interrupt 11 */
    vuint32_t EEI12:1;                 /* Enable Error Interrupt 12 */
    vuint32_t EEI13:1;                 /* Enable Error Interrupt 13 */
    vuint32_t EEI14:1;                 /* Enable Error Interrupt 14 */
    vuint32_t EEI15:1;                 /* Enable Error Interrupt 15 */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} EDMA_AE_EEI_tag;

typedef union EDMA_AE_CEEI_union_tag { /* Clear Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t CEEI:4;                   /* Clear Enable Error Interrupt */
    vuint8_t _unused_4:2;              /* Reserved */
    vuint8_t CAEE:1;                   /* Clear All Enable Error Interrupts */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} EDMA_AE_CEEI_tag;

typedef union EDMA_AE_SEEI_union_tag { /* Set Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t SEEI:4;                   /* Set Enable Error Interrupt */
    vuint8_t _unused_4:2;              /* Reserved */
    vuint8_t SAEE:1;                   /* Sets All Enable Error Interrupts */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} EDMA_AE_SEEI_tag;

typedef union EDMA_AE_CERQ_union_tag { /* Clear Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t CERQ:4;                   /* Clear Enable Request */
    vuint8_t _unused_4:2;              /* Reserved */
    vuint8_t CAER:1;                   /* Clear All Enable Requests */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} EDMA_AE_CERQ_tag;

typedef union EDMA_AE_SERQ_union_tag { /* Set Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t SERQ:4;                   /* Set Enable Request */
    vuint8_t _unused_4:2;              /* Reserved */
    vuint8_t SAER:1;                   /* Set All Enable Requests */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} EDMA_AE_SERQ_tag;

typedef union EDMA_AE_CDNE_union_tag { /* Clear DONE Status Bit Register */
  vuint8_t R;
  struct {
    vuint8_t CDNE:4;                   /* Clear DONE Bit */
    vuint8_t _unused_4:2;              /* Reserved */
    vuint8_t CADN:1;                   /* Clears All DONE Bits */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} EDMA_AE_CDNE_tag;

typedef union EDMA_AE_SSRT_union_tag { /* Set START Bit Register */
  vuint8_t R;
  struct {
    vuint8_t SSRT:4;                   /* Set START Bit */
    vuint8_t _unused_4:2;              /* Reserved */
    vuint8_t SAST:1;                   /* Set All START Bits (activates all channels) */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} EDMA_AE_SSRT_tag;

typedef union EDMA_AE_CERR_union_tag { /* Clear Error Register */
  vuint8_t R;
  struct {
    vuint8_t CERR:4;                   /* Clear Error Indicator */
    vuint8_t _unused_4:2;              /* Reserved */
    vuint8_t CAEI:1;                   /* Clear All Error Indicators */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} EDMA_AE_CERR_tag;

typedef union EDMA_AE_CINT_union_tag { /* Clear Interrupt Request Register */
  vuint8_t R;
  struct {
    vuint8_t CINT:4;                   /* Clear Interrupt Request */
    vuint8_t _unused_4:2;              /* Reserved */
    vuint8_t CAIR:1;                   /* Clear All Interrupt Requests */
    vuint8_t NOP:1;                    /* No Op enable */
  } B;
} EDMA_AE_CINT_tag;

typedef union EDMA_AE_INT_union_tag {  /* Interrupt Request Register */
  vuint32_t R;
  struct {
    vuint32_t INT0:1;                  /* Interrupt Request 0 */
    vuint32_t INT1:1;                  /* Interrupt Request 1 */
    vuint32_t INT2:1;                  /* Interrupt Request 2 */
    vuint32_t INT3:1;                  /* Interrupt Request 3 */
    vuint32_t INT4:1;                  /* Interrupt Request 4 */
    vuint32_t INT5:1;                  /* Interrupt Request 5 */
    vuint32_t INT6:1;                  /* Interrupt Request 6 */
    vuint32_t INT7:1;                  /* Interrupt Request 7 */
    vuint32_t INT8:1;                  /* Interrupt Request 8 */
    vuint32_t INT9:1;                  /* Interrupt Request 9 */
    vuint32_t INT10:1;                 /* Interrupt Request 10 */
    vuint32_t INT11:1;                 /* Interrupt Request 11 */
    vuint32_t INT12:1;                 /* Interrupt Request 12 */
    vuint32_t INT13:1;                 /* Interrupt Request 13 */
    vuint32_t INT14:1;                 /* Interrupt Request 14 */
    vuint32_t INT15:1;                 /* Interrupt Request 15 */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} EDMA_AE_INT_tag;

typedef union EDMA_AE_ERR_union_tag {  /* Error Register */
  vuint32_t R;
  struct {
    vuint32_t ERR0:1;                  /* Error In Channel 0 */
    vuint32_t ERR1:1;                  /* Error In Channel 1 */
    vuint32_t ERR2:1;                  /* Error In Channel 2 */
    vuint32_t ERR3:1;                  /* Error In Channel 3 */
    vuint32_t ERR4:1;                  /* Error In Channel 4 */
    vuint32_t ERR5:1;                  /* Error In Channel 5 */
    vuint32_t ERR6:1;                  /* Error In Channel 6 */
    vuint32_t ERR7:1;                  /* Error In Channel 7 */
    vuint32_t ERR8:1;                  /* Error In Channel 8 */
    vuint32_t ERR9:1;                  /* Error In Channel 9 */
    vuint32_t ERR10:1;                 /* Error In Channel 10 */
    vuint32_t ERR11:1;                 /* Error In Channel 11 */
    vuint32_t ERR12:1;                 /* Error In Channel 12 */
    vuint32_t ERR13:1;                 /* Error In Channel 13 */
    vuint32_t ERR14:1;                 /* Error In Channel 14 */
    vuint32_t ERR15:1;                 /* Error In Channel 15 */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} EDMA_AE_ERR_tag;

typedef union EDMA_AE_HRS_union_tag {  /* Hardware Request Status Register */
  vuint32_t R;
  struct {
    vuint32_t HRS0:1;                  /* Hardware Request Status Channel 0 */
    vuint32_t HRS1:1;                  /* Hardware Request Status Channel 1 */
    vuint32_t HRS2:1;                  /* Hardware Request Status Channel 2 */
    vuint32_t HRS3:1;                  /* Hardware Request Status Channel 3 */
    vuint32_t HRS4:1;                  /* Hardware Request Status Channel 4 */
    vuint32_t HRS5:1;                  /* Hardware Request Status Channel 5 */
    vuint32_t HRS6:1;                  /* Hardware Request Status Channel 6 */
    vuint32_t HRS7:1;                  /* Hardware Request Status Channel 7 */
    vuint32_t HRS8:1;                  /* Hardware Request Status Channel 8 */
    vuint32_t HRS9:1;                  /* Hardware Request Status Channel 9 */
    vuint32_t HRS10:1;                 /* Hardware Request Status Channel 10 */
    vuint32_t HRS11:1;                 /* Hardware Request Status Channel 11 */
    vuint32_t HRS12:1;                 /* Hardware Request Status Channel 12 */
    vuint32_t HRS13:1;                 /* Hardware Request Status Channel 13 */
    vuint32_t HRS14:1;                 /* Hardware Request Status Channel 14 */
    vuint32_t HRS15:1;                 /* Hardware Request Status Channel 15 */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} EDMA_AE_HRS_tag;

typedef union EDMA_AE_EARS_union_tag { /* Enable Asynchronous Request in Stop Register */
  vuint32_t R;
  struct {
    vuint32_t EDREQ_0:1;               /* Enable asynchronous DMA request in stop mode for channel 0. */
    vuint32_t EDREQ_1:1;               /* Enable asynchronous DMA request in stop mode for channel 1. */
    vuint32_t EDREQ_2:1;               /* Enable asynchronous DMA request in stop mode for channel 2. */
    vuint32_t EDREQ_3:1;               /* Enable asynchronous DMA request in stop mode for channel 3. */
    vuint32_t EDREQ_4:1;               /* Enable asynchronous DMA request in stop mode for channel 4 */
    vuint32_t EDREQ_5:1;               /* Enable asynchronous DMA request in stop mode for channel 5 */
    vuint32_t EDREQ_6:1;               /* Enable asynchronous DMA request in stop mode for channel 6 */
    vuint32_t EDREQ_7:1;               /* Enable asynchronous DMA request in stop mode for channel 7 */
    vuint32_t EDREQ_8:1;               /* Enable asynchronous DMA request in stop mode for channel 8 */
    vuint32_t EDREQ_9:1;               /* Enable asynchronous DMA request in stop mode for channel 9 */
    vuint32_t EDREQ_10:1;              /* Enable asynchronous DMA request in stop mode for channel 10 */
    vuint32_t EDREQ_11:1;              /* Enable asynchronous DMA request in stop mode for channel 11 */
    vuint32_t EDREQ_12:1;              /* Enable asynchronous DMA request in stop mode for channel 12 */
    vuint32_t EDREQ_13:1;              /* Enable asynchronous DMA request in stop mode for channel 13 */
    vuint32_t EDREQ_14:1;              /* Enable asynchronous DMA request in stop mode for channel 14 */
    vuint32_t EDREQ_15:1;              /* Enable asynchronous DMA request in stop mode for channel 15 */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} EDMA_AE_EARS_tag;

typedef union EDMA_AE_DCHPRI_union_tag { /* Channel Priority Register */
  vuint8_t R;
  struct {
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
    vuint8_t _unused_4:2;              /* Reserved */
    vuint8_t DPA:1;                    /* Disable Preempt Ability. This field resets to 0. */
    vuint8_t ECP:1;                    /* Enable Channel Preemption. This field resets to 0. */
  } B;
} EDMA_AE_DCHPRI_tag;

typedef union EDMA_AE_TCD_SADDR_union_tag { /* TCD Source Address */
  vuint32_t R;
  struct {
    vuint32_t SADDR:32;                /* Source Address */
  } B;
} EDMA_AE_TCD_SADDR_tag;

typedef union EDMA_AE_TCD_SOFF_union_tag { /* TCD Signed Source Address Offset */
  vuint16_t R;
  struct {
    vuint16_t SOFF:16;                 /* Source address signed offset */
  } B;
} EDMA_AE_TCD_SOFF_tag;

typedef union EDMA_AE_TCD_ATTR_union_tag { /* TCD Transfer Attributes */
  vuint16_t R;
  struct {
    vuint16_t DSIZE:3;                 /* Destination data transfer size */
    vuint16_t DMOD:5;                  /* Destination Address Modulo */
    vuint16_t SSIZE:3;                 /* Source data transfer size */
    vuint16_t SMOD:5;                  /* Source Address Modulo */
  } B;
} EDMA_AE_TCD_ATTR_tag;

typedef union EDMA_AE_TCD_TCD_NBYTES_NBYTES_MLNO_union_tag { /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:32;               /* Minor Byte Transfer Count */
  } B;
} EDMA_AE_TCD_TCD_NBYTES_NBYTES_MLNO_tag;

typedef union EDMA_AE_TCD_TCD_NBYTES_NBYTES_MLOFFNO_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:30;               /* Minor Byte Transfer Count */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
  } B;
} EDMA_AE_TCD_TCD_NBYTES_NBYTES_MLOFFNO_tag;

typedef union EDMA_AE_TCD_TCD_NBYTES_NBYTES_MLOFFYES_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:10;               /* Minor Byte Transfer Count */
    vuint32_t MLOFF:20;                /* If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes. */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
  } B;
} EDMA_AE_TCD_TCD_NBYTES_NBYTES_MLOFFYES_tag;

typedef union EDMA_AE_TCD_TCD_NBYTES_union_tag {
  EDMA_AE_TCD_TCD_NBYTES_NBYTES_MLNO_tag NBYTES_MLNO; /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  EDMA_AE_TCD_TCD_NBYTES_NBYTES_MLOFFNO_tag NBYTES_MLOFFNO; /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  EDMA_AE_TCD_TCD_NBYTES_NBYTES_MLOFFYES_tag NBYTES_MLOFFYES; /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
} EDMA_AE_TCD_TCD_NBYTES_tag;

typedef union EDMA_AE_TCD_SLAST_union_tag { /* TCD Last Source Address Adjustment */
  vuint32_t R;
  struct {
    vuint32_t SLAST:32;                /* Last Source Address Adjustment */
  } B;
} EDMA_AE_TCD_SLAST_tag;

typedef union EDMA_AE_TCD_DADDR_union_tag { /* TCD Destination Address */
  vuint32_t R;
  struct {
    vuint32_t DADDR:32;                /* Destination Address */
  } B;
} EDMA_AE_TCD_DADDR_tag;

typedef union EDMA_AE_TCD_DOFF_union_tag { /* TCD Signed Destination Address Offset */
  vuint16_t R;
  struct {
    vuint16_t DOFF:16;                 /* Destination Address Signed Offset */
  } B;
} EDMA_AE_TCD_DOFF_tag;

typedef union EDMA_AE_TCD_TCD_CITER_ELINK_CITER_ELINKNO_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t CITER:15;                /* Current Major Iteration Count */
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
  } B;
} EDMA_AE_TCD_TCD_CITER_ELINK_CITER_ELINKNO_tag;

typedef union EDMA_AE_TCD_TCD_CITER_ELINK_CITER_ELINKYES_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t CITER:9;                 /* Current Major Iteration Count */
    vuint16_t LINKCH:4;                /* Minor Loop Link Channel Number */
    vuint16_t _unused_13:2;            /* Reserved */
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
  } B;
} EDMA_AE_TCD_TCD_CITER_ELINK_CITER_ELINKYES_tag;

typedef union EDMA_AE_TCD_TCD_CITER_ELINK_union_tag {
  EDMA_AE_TCD_TCD_CITER_ELINK_CITER_ELINKNO_tag CITER_ELINKNO; /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  EDMA_AE_TCD_TCD_CITER_ELINK_CITER_ELINKYES_tag CITER_ELINKYES; /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} EDMA_AE_TCD_TCD_CITER_ELINK_tag;

typedef union EDMA_AE_TCD_DLASTSGA_union_tag { /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  vuint32_t R;
  struct {
    vuint32_t DLASTSGA:32;             /* DLASTSGA */
  } B;
} EDMA_AE_TCD_DLASTSGA_tag;

typedef union EDMA_AE_TCD_CSR_union_tag { /* TCD Control and Status */
  vuint16_t R;
  struct {
    vuint16_t START:1;                 /* Channel Start */
    vuint16_t INTMAJOR:1;              /* Enable an interrupt when major iteration count completes. */
    vuint16_t INTHALF:1;               /* Enable an interrupt when major counter is half complete. */
    vuint16_t DREQ:1;                  /* Disable Request */
    vuint16_t ESG:1;                   /* Enable Scatter/Gather Processing */
    vuint16_t MAJORELINK:1;            /* Enable channel-to-channel linking on major loop complete */
    vuint16_t ACTIVE:1;                /* Channel Active */
    vuint16_t DONE:1;                  /* Channel Done */
    vuint16_t MAJORLINKCH:4;           /* Major Loop Link Channel Number */
    vuint16_t _unused_12:2;            /* Reserved */
    vuint16_t BWC:2;                   /* Bandwidth Control */
  } B;
} EDMA_AE_TCD_CSR_tag;

typedef union EDMA_AE_TCD_TCD_BITER_ELINK_BITER_ELINKNO_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t BITER:15;                /* Starting Major Iteration Count */
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
  } B;
} EDMA_AE_TCD_TCD_BITER_ELINK_BITER_ELINKNO_tag;

typedef union EDMA_AE_TCD_TCD_BITER_ELINK_BITER_ELINKYES_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t BITER:9;                 /* Starting major iteration count */
    vuint16_t LINKCH:4;                /* Link Channel Number */
    vuint16_t _unused_13:2;            /* Reserved */
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
  } B;
} EDMA_AE_TCD_TCD_BITER_ELINK_BITER_ELINKYES_tag;

typedef union EDMA_AE_TCD_TCD_BITER_ELINK_union_tag {
  EDMA_AE_TCD_TCD_BITER_ELINK_BITER_ELINKNO_tag BITER_ELINKNO; /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  EDMA_AE_TCD_TCD_BITER_ELINK_BITER_ELINKYES_tag BITER_ELINKYES; /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} EDMA_AE_TCD_TCD_BITER_ELINK_tag;

typedef struct EDMA_AE_TCD_struct_tag {
  EDMA_AE_TCD_SADDR_tag SADDR;         /* TCD Source Address */
  EDMA_AE_TCD_SOFF_tag SOFF;           /* TCD Signed Source Address Offset */
  EDMA_AE_TCD_ATTR_tag ATTR;           /* TCD Transfer Attributes */
  EDMA_AE_TCD_TCD_NBYTES_tag TCD_NBYTES;
  EDMA_AE_TCD_SLAST_tag SLAST;         /* TCD Last Source Address Adjustment */
  EDMA_AE_TCD_DADDR_tag DADDR;         /* TCD Destination Address */
  EDMA_AE_TCD_DOFF_tag DOFF;           /* TCD Signed Destination Address Offset */
  EDMA_AE_TCD_TCD_CITER_ELINK_tag TCD_CITER_ELINK;
  EDMA_AE_TCD_DLASTSGA_tag DLASTSGA;   /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  EDMA_AE_TCD_CSR_tag CSR;             /* TCD Control and Status */
  EDMA_AE_TCD_TCD_BITER_ELINK_tag TCD_BITER_ELINK;
} EDMA_AE_TCD_tag;

struct EDMA_AE_tag {
  EDMA_AE_CR_tag CR;                   /* Control Register */
  EDMA_AE_ES_tag ES;                   /* Error Status Register */
  uint8_t EDMA_AE_reserved0[4];
  EDMA_AE_ERQ_tag ERQ;                 /* Enable Request Register */
  uint8_t EDMA_AE_reserved1[4];
  EDMA_AE_EEI_tag EEI;                 /* Enable Error Interrupt Register */
  EDMA_AE_CEEI_tag CEEI;               /* Clear Enable Error Interrupt Register */
  EDMA_AE_SEEI_tag SEEI;               /* Set Enable Error Interrupt Register */
  EDMA_AE_CERQ_tag CERQ;               /* Clear Enable Request Register */
  EDMA_AE_SERQ_tag SERQ;               /* Set Enable Request Register */
  EDMA_AE_CDNE_tag CDNE;               /* Clear DONE Status Bit Register */
  EDMA_AE_SSRT_tag SSRT;               /* Set START Bit Register */
  EDMA_AE_CERR_tag CERR;               /* Clear Error Register */
  EDMA_AE_CINT_tag CINT;               /* Clear Interrupt Request Register */
  uint8_t EDMA_AE_reserved2[4];
  EDMA_AE_INT_tag INT;                 /* Interrupt Request Register */
  uint8_t EDMA_AE_reserved3[4];
  EDMA_AE_ERR_tag ERR;                 /* Error Register */
  uint8_t EDMA_AE_reserved4[4];
  EDMA_AE_HRS_tag HRS;                 /* Hardware Request Status Register */
  uint8_t EDMA_AE_reserved5[12];
  EDMA_AE_EARS_tag EARS;               /* Enable Asynchronous Request in Stop Register */
  uint8_t EDMA_AE_reserved6[184];
  EDMA_AE_DCHPRI_tag DCHPRI[16];       /* Channel Priority Register */
  uint8_t EDMA_AE_reserved7[3824];
  EDMA_AE_TCD_tag TCD[16];
};


/* ============================================================================
   =============================== Module: EIM ================================
   ============================================================================ */

typedef union EIM_EIMCR_union_tag {    /* Error Injection Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t GEIEN:1;                 /* Global Error Injection Enable */
    vuint32_t _unused_1:31;            /* Reserved */
  } B;
} EIM_EIMCR_tag;

typedef union EIM_EICHEN_union_tag {   /* Error Injection Channel Enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;             /* Reserved */
    vuint32_t _unused_1:1;             /* Reserved */
    vuint32_t _unused_2:1;             /* Reserved */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t _unused_4:1;             /* Reserved */
    vuint32_t _unused_5:1;             /* Reserved */
    vuint32_t _unused_6:1;             /* Reserved */
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t _unused_8:1;             /* Reserved */
    vuint32_t _unused_9:1;             /* Reserved */
    vuint32_t _unused_10:1;            /* Reserved */
    vuint32_t _unused_11:1;            /* Reserved */
    vuint32_t _unused_12:1;            /* Reserved */
    vuint32_t _unused_13:1;            /* Reserved */
    vuint32_t _unused_14:1;            /* Reserved */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t _unused_16:1;            /* Reserved */
    vuint32_t _unused_17:1;            /* Reserved */
    vuint32_t _unused_18:1;            /* Reserved */
    vuint32_t _unused_19:1;            /* Reserved */
    vuint32_t _unused_20:1;            /* Reserved */
    vuint32_t _unused_21:1;            /* Reserved */
    vuint32_t _unused_22:1;            /* Reserved */
    vuint32_t _unused_23:1;            /* Reserved */
    vuint32_t _unused_24:1;            /* Reserved */
    vuint32_t _unused_25:1;            /* Reserved */
    vuint32_t _unused_26:1;            /* Reserved */
    vuint32_t _unused_27:1;            /* Reserved */
    vuint32_t _unused_28:1;            /* Reserved */
    vuint32_t _unused_29:1;            /* Reserved */
    vuint32_t EICH1EN:1;               /* Error Injection Channel 1 Enable */
    vuint32_t EICH0EN:1;               /* Error Injection Channel 0 Enable */
  } B;
} EIM_EICHEN_tag;

typedef union EIM_EICHD0_WORD0_union_tag { /* Error Injection Channel Descriptor n, Word0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:18;
    vuint32_t CHKBIT_MASK:14;          /* Checkbit Mask */
  } B;
} EIM_EICHD0_WORD0_tag;

typedef union EIM_EICHD0_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_EICHD0_WORD1_tag;

typedef union EIM_EICHD0_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_EICHD0_WORD2_tag;

typedef union EIM_EICHD1_WORD0_union_tag { /* Error Injection Channel Descriptor n, Word0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:18;
    vuint32_t CHKBIT_MASK:14;          /* Checkbit Mask */
  } B;
} EIM_EICHD1_WORD0_tag;

typedef union EIM_EICHD1_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_EICHD1_WORD1_tag;

typedef union EIM_EICHD1_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_EICHD1_WORD2_tag;

struct EIM_tag {
  EIM_EIMCR_tag EIMCR;                 /* Error Injection Module Configuration Register */
  EIM_EICHEN_tag EICHEN;               /* Error Injection Channel Enable register */
  uint8_t EIM_reserved0[248];
  EIM_EICHD0_WORD0_tag EICHD0_WORD0;   /* Error Injection Channel Descriptor n, Word0 */
  EIM_EICHD0_WORD1_tag EICHD0_WORD1;   /* Error Injection Channel Descriptor n, Word1 */
  EIM_EICHD0_WORD2_tag EICHD0_WORD2;   /* Error Injection Channel Descriptor n, Word2 */
  uint8_t EIM_reserved1[52];
  EIM_EICHD1_WORD0_tag EICHD1_WORD0;   /* Error Injection Channel Descriptor n, Word0 */
  EIM_EICHD1_WORD1_tag EICHD1_WORD1;   /* Error Injection Channel Descriptor n, Word1 */
  EIM_EICHD1_WORD2_tag EICHD1_WORD2;   /* Error Injection Channel Descriptor n, Word2 */
};


/* ============================================================================
   =============================== Module: EIM_0 ==============================
   ============================================================================ */

typedef union EIM_0_EIMCR_union_tag {  /* Error Injection Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t GEIEN:1;                 /* Global Error Injection Enable */
    vuint32_t _unused_1:31;            /* Reserved */
  } B;
} EIM_0_EIMCR_tag;

typedef union EIM_0_EICHEN_union_tag { /* Error Injection Channel Enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;             /* Reserved */
    vuint32_t _unused_1:1;             /* Reserved */
    vuint32_t _unused_2:1;             /* Reserved */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t _unused_4:1;             /* Reserved */
    vuint32_t _unused_5:1;             /* Reserved */
    vuint32_t _unused_6:1;             /* Reserved */
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t _unused_8:1;             /* Reserved */
    vuint32_t _unused_9:1;             /* Reserved */
    vuint32_t _unused_10:1;            /* Reserved */
    vuint32_t _unused_11:1;            /* Reserved */
    vuint32_t _unused_12:1;            /* Reserved */
    vuint32_t _unused_13:1;            /* Reserved */
    vuint32_t _unused_14:1;            /* Reserved */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t _unused_16:1;            /* Reserved */
    vuint32_t _unused_17:1;            /* Reserved */
    vuint32_t _unused_18:1;            /* Reserved */
    vuint32_t _unused_19:1;            /* Reserved */
    vuint32_t _unused_20:1;            /* Reserved */
    vuint32_t _unused_21:1;            /* Reserved */
    vuint32_t _unused_22:1;            /* Reserved */
    vuint32_t _unused_23:1;            /* Reserved */
    vuint32_t _unused_24:1;            /* Reserved */
    vuint32_t _unused_25:1;            /* Reserved */
    vuint32_t _unused_26:1;            /* Reserved */
    vuint32_t _unused_27:1;            /* Reserved */
    vuint32_t _unused_28:1;            /* Reserved */
    vuint32_t _unused_29:1;            /* Reserved */
    vuint32_t _unused_30:1;            /* Reserved */
    vuint32_t EICH0EN:1;               /* Error Injection Channel 0 Enable */
  } B;
} EIM_0_EICHEN_tag;

typedef union EIM_0_EICHD0_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_0_EICHD0_WORD1_tag;

typedef union EIM_0_EICHD0_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_0_EICHD0_WORD2_tag;

typedef union EIM_0_EICHD0_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_0_EICHD0_WORD3_tag;

typedef union EIM_0_EICHD0_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_0_EICHD0_WORD4_tag;

typedef union EIM_0_EICHD0_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_0_EICHD0_WORD5_tag;

typedef union EIM_0_EICHD0_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_0_EICHD0_WORD6_tag;

typedef union EIM_0_EICHD0_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_0_EICHD0_WORD7_tag;

typedef union EIM_0_EICHD0_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_0_EICHD0_WORD8_tag;

struct EIM_0_tag {
  EIM_0_EIMCR_tag EIMCR;               /* Error Injection Module Configuration Register */
  EIM_0_EICHEN_tag EICHEN;             /* Error Injection Channel Enable register */
  uint8_t EIM_0_reserved0[252];
  EIM_0_EICHD0_WORD1_tag EICHD0_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_0_EICHD0_WORD2_tag EICHD0_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_0_EICHD0_WORD3_tag EICHD0_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_0_EICHD0_WORD4_tag EICHD0_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_0_EICHD0_WORD5_tag EICHD0_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_0_EICHD0_WORD6_tag EICHD0_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_0_EICHD0_WORD7_tag EICHD0_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_0_EICHD0_WORD8_tag EICHD0_WORD8; /* Error Injection Channel Descriptor n, Word8 */
};


/* ============================================================================
   =============================== Module: EIM_1 ==============================
   ============================================================================ */

typedef union EIM_1_EIMCR_union_tag {  /* Error Injection Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t GEIEN:1;                 /* Global Error Injection Enable */
    vuint32_t _unused_1:31;            /* Reserved */
  } B;
} EIM_1_EIMCR_tag;

typedef union EIM_1_EICHEN_union_tag { /* Error Injection Channel Enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;             /* Reserved */
    vuint32_t _unused_1:1;             /* Reserved */
    vuint32_t _unused_2:1;             /* Reserved */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t _unused_4:1;             /* Reserved */
    vuint32_t _unused_5:1;             /* Reserved */
    vuint32_t _unused_6:1;             /* Reserved */
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t _unused_8:1;             /* Reserved */
    vuint32_t _unused_9:1;             /* Reserved */
    vuint32_t _unused_10:1;            /* Reserved */
    vuint32_t _unused_11:1;            /* Reserved */
    vuint32_t _unused_12:1;            /* Reserved */
    vuint32_t _unused_13:1;            /* Reserved */
    vuint32_t _unused_14:1;            /* Reserved */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t _unused_16:1;            /* Reserved */
    vuint32_t EICH14EN:1;              /* Error Injection Channel 14 Enable */
    vuint32_t EICH13EN:1;              /* Error Injection Channel 13 Enable */
    vuint32_t EICH12EN:1;              /* Error Injection Channel 12 Enable */
    vuint32_t EICH11EN:1;              /* Error Injection Channel 11 Enable */
    vuint32_t EICH10EN:1;              /* Error Injection Channel 10 Enable */
    vuint32_t EICH9EN:1;               /* Error Injection Channel 9 Enable */
    vuint32_t EICH8EN:1;               /* Error Injection Channel 8 Enable */
    vuint32_t EICH7EN:1;               /* Error Injection Channel 7 Enable */
    vuint32_t EICH6EN:1;               /* Error Injection Channel 6 Enable */
    vuint32_t EICH5EN:1;               /* Error Injection Channel 5 Enable */
    vuint32_t EICH4EN:1;               /* Error Injection Channel 4 Enable */
    vuint32_t EICH3EN:1;               /* Error Injection Channel 3 Enable */
    vuint32_t EICH2EN:1;               /* Error Injection Channel 2 Enable */
    vuint32_t EICH1EN:1;               /* Error Injection Channel 1 Enable */
    vuint32_t EICH0EN:1;               /* Error Injection Channel 0 Enable */
  } B;
} EIM_1_EICHEN_tag;

typedef union EIM_1_EICHD0_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD0_WORD1_tag;

typedef union EIM_1_EICHD0_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD0_WORD2_tag;

typedef union EIM_1_EICHD0_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD0_WORD3_tag;

typedef union EIM_1_EICHD0_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD0_WORD4_tag;

typedef union EIM_1_EICHD0_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD0_WORD5_tag;

typedef union EIM_1_EICHD0_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD0_WORD6_tag;

typedef union EIM_1_EICHD0_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD0_WORD7_tag;

typedef union EIM_1_EICHD0_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD0_WORD8_tag;

typedef union EIM_1_EICHD1_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD1_WORD1_tag;

typedef union EIM_1_EICHD1_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD1_WORD2_tag;

typedef union EIM_1_EICHD1_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD1_WORD3_tag;

typedef union EIM_1_EICHD1_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD1_WORD4_tag;

typedef union EIM_1_EICHD1_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD1_WORD5_tag;

typedef union EIM_1_EICHD1_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD1_WORD6_tag;

typedef union EIM_1_EICHD1_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD1_WORD7_tag;

typedef union EIM_1_EICHD1_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD1_WORD8_tag;

typedef union EIM_1_EICHD2_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD2_WORD1_tag;

typedef union EIM_1_EICHD2_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD2_WORD2_tag;

typedef union EIM_1_EICHD2_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD2_WORD3_tag;

typedef union EIM_1_EICHD2_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD2_WORD4_tag;

typedef union EIM_1_EICHD2_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD2_WORD5_tag;

typedef union EIM_1_EICHD2_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD2_WORD6_tag;

typedef union EIM_1_EICHD2_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD2_WORD7_tag;

typedef union EIM_1_EICHD2_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD2_WORD8_tag;

typedef union EIM_1_EICHD3_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD3_WORD1_tag;

typedef union EIM_1_EICHD3_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD3_WORD2_tag;

typedef union EIM_1_EICHD3_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD3_WORD3_tag;

typedef union EIM_1_EICHD3_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD3_WORD4_tag;

typedef union EIM_1_EICHD3_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD3_WORD5_tag;

typedef union EIM_1_EICHD3_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD3_WORD6_tag;

typedef union EIM_1_EICHD3_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD3_WORD7_tag;

typedef union EIM_1_EICHD3_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD3_WORD8_tag;

typedef union EIM_1_EICHD4_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD4_WORD1_tag;

typedef union EIM_1_EICHD4_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD4_WORD2_tag;

typedef union EIM_1_EICHD4_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD4_WORD3_tag;

typedef union EIM_1_EICHD4_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD4_WORD4_tag;

typedef union EIM_1_EICHD4_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD4_WORD5_tag;

typedef union EIM_1_EICHD4_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD4_WORD6_tag;

typedef union EIM_1_EICHD4_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD4_WORD7_tag;

typedef union EIM_1_EICHD4_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD4_WORD8_tag;

typedef union EIM_1_EICHD5_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD5_WORD1_tag;

typedef union EIM_1_EICHD5_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD5_WORD2_tag;

typedef union EIM_1_EICHD5_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD5_WORD3_tag;

typedef union EIM_1_EICHD5_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD5_WORD4_tag;

typedef union EIM_1_EICHD5_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD5_WORD5_tag;

typedef union EIM_1_EICHD5_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD5_WORD6_tag;

typedef union EIM_1_EICHD5_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD5_WORD7_tag;

typedef union EIM_1_EICHD5_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD5_WORD8_tag;

typedef union EIM_1_EICHD6_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD6_WORD1_tag;

typedef union EIM_1_EICHD6_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD6_WORD2_tag;

typedef union EIM_1_EICHD6_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD6_WORD3_tag;

typedef union EIM_1_EICHD6_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD6_WORD4_tag;

typedef union EIM_1_EICHD6_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD6_WORD5_tag;

typedef union EIM_1_EICHD6_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD6_WORD6_tag;

typedef union EIM_1_EICHD6_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD6_WORD7_tag;

typedef union EIM_1_EICHD6_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD6_WORD8_tag;

typedef union EIM_1_EICHD7_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD7_WORD1_tag;

typedef union EIM_1_EICHD7_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD7_WORD2_tag;

typedef union EIM_1_EICHD7_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD7_WORD3_tag;

typedef union EIM_1_EICHD7_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD7_WORD4_tag;

typedef union EIM_1_EICHD7_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD7_WORD5_tag;

typedef union EIM_1_EICHD7_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD7_WORD6_tag;

typedef union EIM_1_EICHD7_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD7_WORD7_tag;

typedef union EIM_1_EICHD7_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD7_WORD8_tag;

typedef union EIM_1_EICHD8_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD8_WORD1_tag;

typedef union EIM_1_EICHD8_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD8_WORD2_tag;

typedef union EIM_1_EICHD8_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD8_WORD3_tag;

typedef union EIM_1_EICHD8_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD8_WORD4_tag;

typedef union EIM_1_EICHD8_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD8_WORD5_tag;

typedef union EIM_1_EICHD8_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD8_WORD6_tag;

typedef union EIM_1_EICHD8_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD8_WORD7_tag;

typedef union EIM_1_EICHD8_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD8_WORD8_tag;

typedef union EIM_1_EICHD9_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD9_WORD1_tag;

typedef union EIM_1_EICHD9_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD9_WORD2_tag;

typedef union EIM_1_EICHD9_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD9_WORD3_tag;

typedef union EIM_1_EICHD9_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD9_WORD4_tag;

typedef union EIM_1_EICHD9_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD9_WORD5_tag;

typedef union EIM_1_EICHD9_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD9_WORD6_tag;

typedef union EIM_1_EICHD9_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD9_WORD7_tag;

typedef union EIM_1_EICHD9_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD9_WORD8_tag;

typedef union EIM_1_EICHD10_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD10_WORD1_tag;

typedef union EIM_1_EICHD10_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD10_WORD2_tag;

typedef union EIM_1_EICHD10_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD10_WORD3_tag;

typedef union EIM_1_EICHD10_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD10_WORD4_tag;

typedef union EIM_1_EICHD10_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD10_WORD5_tag;

typedef union EIM_1_EICHD10_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD10_WORD6_tag;

typedef union EIM_1_EICHD10_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD10_WORD7_tag;

typedef union EIM_1_EICHD10_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD10_WORD8_tag;

typedef union EIM_1_EICHD11_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD11_WORD1_tag;

typedef union EIM_1_EICHD11_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD11_WORD2_tag;

typedef union EIM_1_EICHD11_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD11_WORD3_tag;

typedef union EIM_1_EICHD11_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD11_WORD4_tag;

typedef union EIM_1_EICHD11_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD11_WORD5_tag;

typedef union EIM_1_EICHD11_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD11_WORD6_tag;

typedef union EIM_1_EICHD11_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD11_WORD7_tag;

typedef union EIM_1_EICHD11_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD11_WORD8_tag;

typedef union EIM_1_EICHD12_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD12_WORD1_tag;

typedef union EIM_1_EICHD12_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD12_WORD2_tag;

typedef union EIM_1_EICHD12_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD12_WORD3_tag;

typedef union EIM_1_EICHD12_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD12_WORD4_tag;

typedef union EIM_1_EICHD12_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD12_WORD5_tag;

typedef union EIM_1_EICHD12_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD12_WORD6_tag;

typedef union EIM_1_EICHD12_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD12_WORD7_tag;

typedef union EIM_1_EICHD12_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD12_WORD8_tag;

typedef union EIM_1_EICHD13_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD13_WORD1_tag;

typedef union EIM_1_EICHD13_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD13_WORD2_tag;

typedef union EIM_1_EICHD13_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD13_WORD3_tag;

typedef union EIM_1_EICHD13_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD13_WORD4_tag;

typedef union EIM_1_EICHD13_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD13_WORD5_tag;

typedef union EIM_1_EICHD13_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD13_WORD6_tag;

typedef union EIM_1_EICHD13_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD13_WORD7_tag;

typedef union EIM_1_EICHD13_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD13_WORD8_tag;

typedef union EIM_1_EICHD14_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_1_EICHD14_WORD1_tag;

typedef union EIM_1_EICHD14_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_1_EICHD14_WORD2_tag;

typedef union EIM_1_EICHD14_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_1_EICHD14_WORD3_tag;

typedef union EIM_1_EICHD14_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_1_EICHD14_WORD4_tag;

typedef union EIM_1_EICHD14_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_1_EICHD14_WORD5_tag;

typedef union EIM_1_EICHD14_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_1_EICHD14_WORD6_tag;

typedef union EIM_1_EICHD14_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_1_EICHD14_WORD7_tag;

typedef union EIM_1_EICHD14_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_1_EICHD14_WORD8_tag;

struct EIM_1_tag {
  EIM_1_EIMCR_tag EIMCR;               /* Error Injection Module Configuration Register */
  EIM_1_EICHEN_tag EICHEN;             /* Error Injection Channel Enable register */
  uint8_t EIM_1_reserved0[252];
  EIM_1_EICHD0_WORD1_tag EICHD0_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD0_WORD2_tag EICHD0_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD0_WORD3_tag EICHD0_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD0_WORD4_tag EICHD0_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD0_WORD5_tag EICHD0_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD0_WORD6_tag EICHD0_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD0_WORD7_tag EICHD0_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD0_WORD8_tag EICHD0_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved1[32];
  EIM_1_EICHD1_WORD1_tag EICHD1_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD1_WORD2_tag EICHD1_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD1_WORD3_tag EICHD1_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD1_WORD4_tag EICHD1_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD1_WORD5_tag EICHD1_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD1_WORD6_tag EICHD1_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD1_WORD7_tag EICHD1_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD1_WORD8_tag EICHD1_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved2[32];
  EIM_1_EICHD2_WORD1_tag EICHD2_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD2_WORD2_tag EICHD2_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD2_WORD3_tag EICHD2_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD2_WORD4_tag EICHD2_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD2_WORD5_tag EICHD2_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD2_WORD6_tag EICHD2_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD2_WORD7_tag EICHD2_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD2_WORD8_tag EICHD2_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved3[32];
  EIM_1_EICHD3_WORD1_tag EICHD3_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD3_WORD2_tag EICHD3_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD3_WORD3_tag EICHD3_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD3_WORD4_tag EICHD3_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD3_WORD5_tag EICHD3_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD3_WORD6_tag EICHD3_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD3_WORD7_tag EICHD3_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD3_WORD8_tag EICHD3_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved4[32];
  EIM_1_EICHD4_WORD1_tag EICHD4_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD4_WORD2_tag EICHD4_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD4_WORD3_tag EICHD4_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD4_WORD4_tag EICHD4_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD4_WORD5_tag EICHD4_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD4_WORD6_tag EICHD4_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD4_WORD7_tag EICHD4_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD4_WORD8_tag EICHD4_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved5[32];
  EIM_1_EICHD5_WORD1_tag EICHD5_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD5_WORD2_tag EICHD5_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD5_WORD3_tag EICHD5_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD5_WORD4_tag EICHD5_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD5_WORD5_tag EICHD5_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD5_WORD6_tag EICHD5_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD5_WORD7_tag EICHD5_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD5_WORD8_tag EICHD5_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved6[32];
  EIM_1_EICHD6_WORD1_tag EICHD6_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD6_WORD2_tag EICHD6_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD6_WORD3_tag EICHD6_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD6_WORD4_tag EICHD6_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD6_WORD5_tag EICHD6_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD6_WORD6_tag EICHD6_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD6_WORD7_tag EICHD6_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD6_WORD8_tag EICHD6_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved7[32];
  EIM_1_EICHD7_WORD1_tag EICHD7_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD7_WORD2_tag EICHD7_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD7_WORD3_tag EICHD7_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD7_WORD4_tag EICHD7_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD7_WORD5_tag EICHD7_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD7_WORD6_tag EICHD7_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD7_WORD7_tag EICHD7_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD7_WORD8_tag EICHD7_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved8[32];
  EIM_1_EICHD8_WORD1_tag EICHD8_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD8_WORD2_tag EICHD8_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD8_WORD3_tag EICHD8_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD8_WORD4_tag EICHD8_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD8_WORD5_tag EICHD8_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD8_WORD6_tag EICHD8_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD8_WORD7_tag EICHD8_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD8_WORD8_tag EICHD8_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved9[32];
  EIM_1_EICHD9_WORD1_tag EICHD9_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD9_WORD2_tag EICHD9_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD9_WORD3_tag EICHD9_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD9_WORD4_tag EICHD9_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD9_WORD5_tag EICHD9_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD9_WORD6_tag EICHD9_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD9_WORD7_tag EICHD9_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD9_WORD8_tag EICHD9_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved10[32];
  EIM_1_EICHD10_WORD1_tag EICHD10_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD10_WORD2_tag EICHD10_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD10_WORD3_tag EICHD10_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD10_WORD4_tag EICHD10_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD10_WORD5_tag EICHD10_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD10_WORD6_tag EICHD10_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD10_WORD7_tag EICHD10_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD10_WORD8_tag EICHD10_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved11[32];
  EIM_1_EICHD11_WORD1_tag EICHD11_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD11_WORD2_tag EICHD11_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD11_WORD3_tag EICHD11_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD11_WORD4_tag EICHD11_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD11_WORD5_tag EICHD11_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD11_WORD6_tag EICHD11_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD11_WORD7_tag EICHD11_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD11_WORD8_tag EICHD11_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved12[32];
  EIM_1_EICHD12_WORD1_tag EICHD12_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD12_WORD2_tag EICHD12_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD12_WORD3_tag EICHD12_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD12_WORD4_tag EICHD12_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD12_WORD5_tag EICHD12_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD12_WORD6_tag EICHD12_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD12_WORD7_tag EICHD12_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD12_WORD8_tag EICHD12_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved13[32];
  EIM_1_EICHD13_WORD1_tag EICHD13_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD13_WORD2_tag EICHD13_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD13_WORD3_tag EICHD13_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD13_WORD4_tag EICHD13_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD13_WORD5_tag EICHD13_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD13_WORD6_tag EICHD13_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD13_WORD7_tag EICHD13_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD13_WORD8_tag EICHD13_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_1_reserved14[32];
  EIM_1_EICHD14_WORD1_tag EICHD14_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_1_EICHD14_WORD2_tag EICHD14_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_1_EICHD14_WORD3_tag EICHD14_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_1_EICHD14_WORD4_tag EICHD14_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_1_EICHD14_WORD5_tag EICHD14_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_1_EICHD14_WORD6_tag EICHD14_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_1_EICHD14_WORD7_tag EICHD14_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_1_EICHD14_WORD8_tag EICHD14_WORD8; /* Error Injection Channel Descriptor n, Word8 */
};


/* ============================================================================
   =============================== Module: EIM_platform =======================
   ============================================================================ */

typedef union EIM_platform_EIMCR_union_tag { /* Error Injection Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t GEIEN:1;                 /* Global Error Injection Enable */
    vuint32_t _unused_1:31;            /* Reserved */
  } B;
} EIM_platform_EIMCR_tag;

typedef union EIM_platform_EICHEN_union_tag { /* Error Injection Channel Enable register */
  vuint32_t R;
  struct {
    vuint32_t EICH31EN:1;              /* Error Injection Channel 31 Enable */
    vuint32_t EICH30EN:1;              /* Error Injection Channel 30 Enable */
    vuint32_t EICH29EN:1;              /* Error Injection Channel 29 Enable */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t _unused_4:1;             /* Reserved */
    vuint32_t _unused_5:1;             /* Reserved */
    vuint32_t _unused_6:1;             /* Reserved */
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t _unused_8:1;             /* Reserved */
    vuint32_t _unused_9:1;             /* Reserved */
    vuint32_t _unused_10:1;            /* Reserved */
    vuint32_t _unused_11:1;            /* Reserved */
    vuint32_t _unused_12:1;            /* Reserved */
    vuint32_t _unused_13:1;            /* Reserved */
    vuint32_t _unused_14:1;            /* Reserved */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t _unused_16:1;            /* Reserved */
    vuint32_t _unused_17:1;            /* Reserved */
    vuint32_t _unused_18:1;            /* Reserved */
    vuint32_t _unused_19:1;            /* Reserved */
    vuint32_t _unused_20:1;            /* Reserved */
    vuint32_t _unused_21:1;            /* Reserved */
    vuint32_t EICH9EN:1;               /* Error Injection Channel 9 Enable */
    vuint32_t EICH8EN:1;               /* Error Injection Channel 8 Enable */
    vuint32_t EICH7EN:1;               /* Error Injection Channel 7 Enable */
    vuint32_t EICH6EN:1;               /* Error Injection Channel 6 Enable */
    vuint32_t EICH5EN:1;               /* Error Injection Channel 5 Enable */
    vuint32_t EICH4EN:1;               /* Error Injection Channel 4 Enable */
    vuint32_t EICH3EN:1;               /* Error Injection Channel 3 Enable */
    vuint32_t EICH2EN:1;               /* Error Injection Channel 2 Enable */
    vuint32_t EICH1EN:1;               /* Error Injection Channel 1 Enable */
    vuint32_t EICH0EN:1;               /* Error Injection Channel 0 Enable */
  } B;
} EIM_platform_EICHEN_tag;

typedef union EIM_platform_EICHD0_WORD0_union_tag { /* Error Injection Channel Descriptor n, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:32;          /* Checkbit Mask */
  } B;
} EIM_platform_EICHD0_WORD0_tag;

typedef union EIM_platform_EICHD0_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_platform_EICHD0_WORD1_tag;

typedef union EIM_platform_EICHD0_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_platform_EICHD0_WORD2_tag;

typedef union EIM_platform_EICHD0_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_platform_EICHD0_WORD3_tag;

typedef union EIM_platform_EICHD0_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_platform_EICHD0_WORD4_tag;

typedef union EIM_platform_EICHD0_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_platform_EICHD0_WORD5_tag;

typedef union EIM_platform_EICHD0_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_platform_EICHD0_WORD6_tag;

typedef union EIM_platform_EICHD0_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_platform_EICHD0_WORD7_tag;

typedef union EIM_platform_EICHD0_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_platform_EICHD0_WORD8_tag;

typedef union EIM_platform_EICHD1_WORD0_union_tag { /* Error Injection Channel Descriptor n, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:32;          /* Checkbit Mask */
  } B;
} EIM_platform_EICHD1_WORD0_tag;

typedef union EIM_platform_EICHD1_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_platform_EICHD1_WORD1_tag;

typedef union EIM_platform_EICHD1_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_platform_EICHD1_WORD2_tag;

typedef union EIM_platform_EICHD1_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_platform_EICHD1_WORD3_tag;

typedef union EIM_platform_EICHD1_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_platform_EICHD1_WORD4_tag;

typedef union EIM_platform_EICHD1_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_platform_EICHD1_WORD5_tag;

typedef union EIM_platform_EICHD1_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_platform_EICHD1_WORD6_tag;

typedef union EIM_platform_EICHD1_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_platform_EICHD1_WORD7_tag;

typedef union EIM_platform_EICHD1_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_platform_EICHD1_WORD8_tag;

typedef union EIM_platform_EICHD2_WORD0_union_tag { /* Error Injection Channel Descriptor n, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:32;          /* Checkbit Mask */
  } B;
} EIM_platform_EICHD2_WORD0_tag;

typedef union EIM_platform_EICHD2_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_platform_EICHD2_WORD1_tag;

typedef union EIM_platform_EICHD2_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_platform_EICHD2_WORD2_tag;

typedef union EIM_platform_EICHD2_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_platform_EICHD2_WORD3_tag;

typedef union EIM_platform_EICHD2_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_platform_EICHD2_WORD4_tag;

typedef union EIM_platform_EICHD2_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_platform_EICHD2_WORD5_tag;

typedef union EIM_platform_EICHD2_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_platform_EICHD2_WORD6_tag;

typedef union EIM_platform_EICHD2_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_platform_EICHD2_WORD7_tag;

typedef union EIM_platform_EICHD2_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_platform_EICHD2_WORD8_tag;

typedef union EIM_platform_EICHD3_WORD0_union_tag { /* Error Injection Channel Descriptor n, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:32;          /* Checkbit Mask */
  } B;
} EIM_platform_EICHD3_WORD0_tag;

typedef union EIM_platform_EICHD3_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_platform_EICHD3_WORD1_tag;

typedef union EIM_platform_EICHD3_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_platform_EICHD3_WORD2_tag;

typedef union EIM_platform_EICHD3_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_platform_EICHD3_WORD3_tag;

typedef union EIM_platform_EICHD3_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_platform_EICHD3_WORD4_tag;

typedef union EIM_platform_EICHD3_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_platform_EICHD3_WORD5_tag;

typedef union EIM_platform_EICHD3_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_platform_EICHD3_WORD6_tag;

typedef union EIM_platform_EICHD3_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_platform_EICHD3_WORD7_tag;

typedef union EIM_platform_EICHD3_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_platform_EICHD3_WORD8_tag;

typedef union EIM_platform_EICHD4_WORD0_union_tag { /* Error Injection Channel Descriptor n, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:32;          /* Checkbit Mask */
  } B;
} EIM_platform_EICHD4_WORD0_tag;

typedef union EIM_platform_EICHD4_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_platform_EICHD4_WORD1_tag;

typedef union EIM_platform_EICHD4_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_platform_EICHD4_WORD2_tag;

typedef union EIM_platform_EICHD4_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_platform_EICHD4_WORD3_tag;

typedef union EIM_platform_EICHD4_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_platform_EICHD4_WORD4_tag;

typedef union EIM_platform_EICHD4_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_platform_EICHD4_WORD5_tag;

typedef union EIM_platform_EICHD4_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_platform_EICHD4_WORD6_tag;

typedef union EIM_platform_EICHD4_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_platform_EICHD4_WORD7_tag;

typedef union EIM_platform_EICHD4_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_platform_EICHD4_WORD8_tag;

typedef union EIM_platform_EICHD5_WORD0_union_tag { /* Error Injection Channel Descriptor n, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:32;          /* Checkbit Mask */
  } B;
} EIM_platform_EICHD5_WORD0_tag;

typedef union EIM_platform_EICHD5_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_platform_EICHD5_WORD1_tag;

typedef union EIM_platform_EICHD5_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_platform_EICHD5_WORD2_tag;

typedef union EIM_platform_EICHD5_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_platform_EICHD5_WORD3_tag;

typedef union EIM_platform_EICHD5_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_platform_EICHD5_WORD4_tag;

typedef union EIM_platform_EICHD5_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_platform_EICHD5_WORD5_tag;

typedef union EIM_platform_EICHD5_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_platform_EICHD5_WORD6_tag;

typedef union EIM_platform_EICHD5_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_platform_EICHD5_WORD7_tag;

typedef union EIM_platform_EICHD5_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_platform_EICHD5_WORD8_tag;

typedef union EIM_platform_EICHD6_WORD0_union_tag { /* Error Injection Channel Descriptor n, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:32;          /* Checkbit Mask */
  } B;
} EIM_platform_EICHD6_WORD0_tag;

typedef union EIM_platform_EICHD6_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_platform_EICHD6_WORD1_tag;

typedef union EIM_platform_EICHD6_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_platform_EICHD6_WORD2_tag;

typedef union EIM_platform_EICHD6_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_platform_EICHD6_WORD3_tag;

typedef union EIM_platform_EICHD6_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_platform_EICHD6_WORD4_tag;

typedef union EIM_platform_EICHD6_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_platform_EICHD6_WORD5_tag;

typedef union EIM_platform_EICHD6_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_platform_EICHD6_WORD6_tag;

typedef union EIM_platform_EICHD6_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_platform_EICHD6_WORD7_tag;

typedef union EIM_platform_EICHD6_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_platform_EICHD6_WORD8_tag;

typedef union EIM_platform_EICHD7_WORD0_union_tag { /* Error Injection Channel Descriptor n, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:32;          /* Checkbit Mask */
  } B;
} EIM_platform_EICHD7_WORD0_tag;

typedef union EIM_platform_EICHD7_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_platform_EICHD7_WORD1_tag;

typedef union EIM_platform_EICHD7_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_platform_EICHD7_WORD2_tag;

typedef union EIM_platform_EICHD7_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_platform_EICHD7_WORD3_tag;

typedef union EIM_platform_EICHD7_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_platform_EICHD7_WORD4_tag;

typedef union EIM_platform_EICHD7_WORD5_union_tag { /* Error Injection Channel Descriptor n, Word5 */
  vuint32_t R;
  struct {
    vuint32_t B16_19DATA_MASK:32;      /* Data Mask Bytes 16-19 */
  } B;
} EIM_platform_EICHD7_WORD5_tag;

typedef union EIM_platform_EICHD7_WORD6_union_tag { /* Error Injection Channel Descriptor n, Word6 */
  vuint32_t R;
  struct {
    vuint32_t B20_23DATA_MASK:32;      /* Data Mask Bytes 20-23 */
  } B;
} EIM_platform_EICHD7_WORD6_tag;

typedef union EIM_platform_EICHD7_WORD7_union_tag { /* Error Injection Channel Descriptor n, Word7 */
  vuint32_t R;
  struct {
    vuint32_t B24_27DATA_MASK:32;      /* Data Mask Bytes 24-27 */
  } B;
} EIM_platform_EICHD7_WORD7_tag;

typedef union EIM_platform_EICHD7_WORD8_union_tag { /* Error Injection Channel Descriptor n, Word8 */
  vuint32_t R;
  struct {
    vuint32_t B28_31DATA_MASK:32;      /* Data Mask Bytes 28-31 */
  } B;
} EIM_platform_EICHD7_WORD8_tag;

typedef union EIM_platform_EICHD8_WORD0_union_tag { /* Error Injection Channel Descriptor n, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:32;          /* Checkbit Mask */
  } B;
} EIM_platform_EICHD8_WORD0_tag;

typedef union EIM_platform_EICHD8_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_platform_EICHD8_WORD1_tag;

typedef union EIM_platform_EICHD8_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_platform_EICHD8_WORD2_tag;

typedef union EIM_platform_EICHD9_WORD0_union_tag { /* Error Injection Channel Descriptor n, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:32;          /* Checkbit Mask */
  } B;
} EIM_platform_EICHD9_WORD0_tag;

typedef union EIM_platform_EICHD9_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_platform_EICHD9_WORD1_tag;

typedef union EIM_platform_EICHD9_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_platform_EICHD9_WORD2_tag;

typedef union EIM_platform_EICHD29_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_platform_EICHD29_WORD1_tag;

typedef union EIM_platform_EICHD30_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_platform_EICHD30_WORD1_tag;

typedef union EIM_platform_EICHD30_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_platform_EICHD30_WORD2_tag;

typedef union EIM_platform_EICHD30_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_platform_EICHD30_WORD3_tag;

typedef union EIM_platform_EICHD30_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_platform_EICHD30_WORD4_tag;

typedef union EIM_platform_EICHD31_WORD1_union_tag { /* Error Injection Channel Descriptor n, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_platform_EICHD31_WORD1_tag;

typedef union EIM_platform_EICHD31_WORD2_union_tag { /* Error Injection Channel Descriptor n, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_platform_EICHD31_WORD2_tag;

typedef union EIM_platform_EICHD31_WORD3_union_tag { /* Error Injection Channel Descriptor n, Word3 */
  vuint32_t R;
  struct {
    vuint32_t B8_11DATA_MASK:32;       /* Data Mask Bytes 8-11 */
  } B;
} EIM_platform_EICHD31_WORD3_tag;

typedef union EIM_platform_EICHD31_WORD4_union_tag { /* Error Injection Channel Descriptor n, Word4 */
  vuint32_t R;
  struct {
    vuint32_t B12_15DATA_MASK:32;      /* Data Mask Bytes 12-15 */
  } B;
} EIM_platform_EICHD31_WORD4_tag;

struct EIM_platform_tag {
  EIM_platform_EIMCR_tag EIMCR;        /* Error Injection Module Configuration Register */
  EIM_platform_EICHEN_tag EICHEN;      /* Error Injection Channel Enable register */
  uint8_t EIM_platform_reserved0[248];
  EIM_platform_EICHD0_WORD0_tag EICHD0_WORD0; /* Error Injection Channel Descriptor n, Word0 */
  EIM_platform_EICHD0_WORD1_tag EICHD0_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_platform_EICHD0_WORD2_tag EICHD0_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_platform_EICHD0_WORD3_tag EICHD0_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_platform_EICHD0_WORD4_tag EICHD0_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_platform_EICHD0_WORD5_tag EICHD0_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_platform_EICHD0_WORD6_tag EICHD0_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_platform_EICHD0_WORD7_tag EICHD0_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_platform_EICHD0_WORD8_tag EICHD0_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_platform_reserved1[28];
  EIM_platform_EICHD1_WORD0_tag EICHD1_WORD0; /* Error Injection Channel Descriptor n, Word0 */
  EIM_platform_EICHD1_WORD1_tag EICHD1_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_platform_EICHD1_WORD2_tag EICHD1_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_platform_EICHD1_WORD3_tag EICHD1_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_platform_EICHD1_WORD4_tag EICHD1_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_platform_EICHD1_WORD5_tag EICHD1_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_platform_EICHD1_WORD6_tag EICHD1_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_platform_EICHD1_WORD7_tag EICHD1_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_platform_EICHD1_WORD8_tag EICHD1_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_platform_reserved2[28];
  EIM_platform_EICHD2_WORD0_tag EICHD2_WORD0; /* Error Injection Channel Descriptor n, Word0 */
  EIM_platform_EICHD2_WORD1_tag EICHD2_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_platform_EICHD2_WORD2_tag EICHD2_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_platform_EICHD2_WORD3_tag EICHD2_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_platform_EICHD2_WORD4_tag EICHD2_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_platform_EICHD2_WORD5_tag EICHD2_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_platform_EICHD2_WORD6_tag EICHD2_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_platform_EICHD2_WORD7_tag EICHD2_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_platform_EICHD2_WORD8_tag EICHD2_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_platform_reserved3[28];
  EIM_platform_EICHD3_WORD0_tag EICHD3_WORD0; /* Error Injection Channel Descriptor n, Word0 */
  EIM_platform_EICHD3_WORD1_tag EICHD3_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_platform_EICHD3_WORD2_tag EICHD3_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_platform_EICHD3_WORD3_tag EICHD3_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_platform_EICHD3_WORD4_tag EICHD3_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_platform_EICHD3_WORD5_tag EICHD3_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_platform_EICHD3_WORD6_tag EICHD3_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_platform_EICHD3_WORD7_tag EICHD3_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_platform_EICHD3_WORD8_tag EICHD3_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_platform_reserved4[28];
  EIM_platform_EICHD4_WORD0_tag EICHD4_WORD0; /* Error Injection Channel Descriptor n, Word0 */
  EIM_platform_EICHD4_WORD1_tag EICHD4_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_platform_EICHD4_WORD2_tag EICHD4_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_platform_EICHD4_WORD3_tag EICHD4_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_platform_EICHD4_WORD4_tag EICHD4_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_platform_EICHD4_WORD5_tag EICHD4_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_platform_EICHD4_WORD6_tag EICHD4_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_platform_EICHD4_WORD7_tag EICHD4_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_platform_EICHD4_WORD8_tag EICHD4_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_platform_reserved5[28];
  EIM_platform_EICHD5_WORD0_tag EICHD5_WORD0; /* Error Injection Channel Descriptor n, Word0 */
  EIM_platform_EICHD5_WORD1_tag EICHD5_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_platform_EICHD5_WORD2_tag EICHD5_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_platform_EICHD5_WORD3_tag EICHD5_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_platform_EICHD5_WORD4_tag EICHD5_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_platform_EICHD5_WORD5_tag EICHD5_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_platform_EICHD5_WORD6_tag EICHD5_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_platform_EICHD5_WORD7_tag EICHD5_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_platform_EICHD5_WORD8_tag EICHD5_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_platform_reserved6[28];
  EIM_platform_EICHD6_WORD0_tag EICHD6_WORD0; /* Error Injection Channel Descriptor n, Word0 */
  EIM_platform_EICHD6_WORD1_tag EICHD6_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_platform_EICHD6_WORD2_tag EICHD6_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_platform_EICHD6_WORD3_tag EICHD6_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_platform_EICHD6_WORD4_tag EICHD6_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_platform_EICHD6_WORD5_tag EICHD6_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_platform_EICHD6_WORD6_tag EICHD6_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_platform_EICHD6_WORD7_tag EICHD6_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_platform_EICHD6_WORD8_tag EICHD6_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_platform_reserved7[28];
  EIM_platform_EICHD7_WORD0_tag EICHD7_WORD0; /* Error Injection Channel Descriptor n, Word0 */
  EIM_platform_EICHD7_WORD1_tag EICHD7_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_platform_EICHD7_WORD2_tag EICHD7_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_platform_EICHD7_WORD3_tag EICHD7_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_platform_EICHD7_WORD4_tag EICHD7_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  EIM_platform_EICHD7_WORD5_tag EICHD7_WORD5; /* Error Injection Channel Descriptor n, Word5 */
  EIM_platform_EICHD7_WORD6_tag EICHD7_WORD6; /* Error Injection Channel Descriptor n, Word6 */
  EIM_platform_EICHD7_WORD7_tag EICHD7_WORD7; /* Error Injection Channel Descriptor n, Word7 */
  EIM_platform_EICHD7_WORD8_tag EICHD7_WORD8; /* Error Injection Channel Descriptor n, Word8 */
  uint8_t EIM_platform_reserved8[28];
  EIM_platform_EICHD8_WORD0_tag EICHD8_WORD0; /* Error Injection Channel Descriptor n, Word0 */
  EIM_platform_EICHD8_WORD1_tag EICHD8_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_platform_EICHD8_WORD2_tag EICHD8_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  uint8_t EIM_platform_reserved9[52];
  EIM_platform_EICHD9_WORD0_tag EICHD9_WORD0; /* Error Injection Channel Descriptor n, Word0 */
  EIM_platform_EICHD9_WORD1_tag EICHD9_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_platform_EICHD9_WORD2_tag EICHD9_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  uint8_t EIM_platform_reserved10[1272];
  EIM_platform_EICHD29_WORD1_tag EICHD29_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  uint8_t EIM_platform_reserved11[60];
  EIM_platform_EICHD30_WORD1_tag EICHD30_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_platform_EICHD30_WORD2_tag EICHD30_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_platform_EICHD30_WORD3_tag EICHD30_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_platform_EICHD30_WORD4_tag EICHD30_WORD4; /* Error Injection Channel Descriptor n, Word4 */
  uint8_t EIM_platform_reserved12[48];
  EIM_platform_EICHD31_WORD1_tag EICHD31_WORD1; /* Error Injection Channel Descriptor n, Word1 */
  EIM_platform_EICHD31_WORD2_tag EICHD31_WORD2; /* Error Injection Channel Descriptor n, Word2 */
  EIM_platform_EICHD31_WORD3_tag EICHD31_WORD3; /* Error Injection Channel Descriptor n, Word3 */
  EIM_platform_EICHD31_WORD4_tag EICHD31_WORD4; /* Error Injection Channel Descriptor n, Word4 */
};


/* ============================================================================
   =============================== Module: EMIOS ==============================
   ============================================================================ */

typedef union EMIOS_MCR_union_tag {    /* eMIOS Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;             /* Reserved. */
    vuint32_t GPRE:8;                  /* Global Prescaler bits. */
    vuint32_t _unused_16:4;            /* Reserved. */
    vuint32_t _unused_20:6;            /* Reserved. */
    vuint32_t GPREN:1;                 /* Global Prescaler Enable bit. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t GTBE:1;                  /* Global Time Base Enable bit. */
    vuint32_t FRZ:1;                   /* Freeze bit. */
    vuint32_t MDIS:1;                  /* Module Disable bit. */
    vuint32_t _unused_31:1;            /* Reserved. */
  } B;
} EMIOS_MCR_tag;

typedef union EMIOS_GFLAG_union_tag {  /* eMIOS Global FLAG Register */
  vuint32_t R;
  struct {
    vuint32_t F0:1;                    /* Channel [0] mirrored FLAG bit. */
    vuint32_t F1:1;                    /* Channel [1] mirrored FLAG bit. */
    vuint32_t F2:1;                    /* Channel [2] mirrored FLAG bit. */
    vuint32_t F3:1;                    /* Channel [3] mirrored FLAG bit. */
    vuint32_t F4:1;                    /* Channel [4] mirrored FLAG bit. */
    vuint32_t F5:1;                    /* Channel [5] mirrored FLAG bit. */
    vuint32_t F6:1;                    /* Channel [6] mirrored FLAG bit. */
    vuint32_t F7:1;                    /* Channel [7] mirrored FLAG bit. */
    vuint32_t _unused_8:1;             /* Reserved. */
    vuint32_t _unused_9:1;             /* Reserved. */
    vuint32_t _unused_10:1;            /* Reserved. */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t _unused_12:1;            /* Reserved. */
    vuint32_t _unused_13:1;            /* Reserved. */
    vuint32_t _unused_14:1;            /* Reserved. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t F16:1;                   /* Channel [16] mirrored FLAG bit. */
    vuint32_t F17:1;                   /* Channel [17] mirrored FLAG bit. */
    vuint32_t F18:1;                   /* Channel [18] mirrored FLAG bit. */
    vuint32_t F19:1;                   /* Channel [19] mirrored FLAG bit. */
    vuint32_t F20:1;                   /* Channel [20] mirrored FLAG bit. */
    vuint32_t F21:1;                   /* Channel [21] mirrored FLAG bit. */
    vuint32_t F22:1;                   /* Channel [22] mirrored FLAG bit. */
    vuint32_t F23:1;                   /* Channel [23] mirrored FLAG bit. */
    vuint32_t F24:1;                   /* Channel [24] mirrored FLAG bit. */
    vuint32_t F25:1;                   /* Channel [25] mirrored FLAG bit. */
    vuint32_t F26:1;                   /* Channel [26] mirrored FLAG bit. */
    vuint32_t F27:1;                   /* Channel [27] mirrored FLAG bit. */
    vuint32_t F28:1;                   /* Channel [28] mirrored FLAG bit. */
    vuint32_t F29:1;                   /* Channel [29] mirrored FLAG bit. */
    vuint32_t F30:1;                   /* Channel [30] mirrored FLAG bit. */
    vuint32_t F31:1;                   /* Channel [31] mirrored FLAG bit. */
  } B;
} EMIOS_GFLAG_tag;

typedef union EMIOS_OUDIS_union_tag {  /* eMIOS Output Update Disable register */
  vuint32_t R;
  struct {
    vuint32_t OU0:1;                   /* Channel [n] Output Update Disable bit. */
    vuint32_t OU1:1;                   /* Channel [n] Output Update Disable bit. */
    vuint32_t OU2:1;                   /* Channel [n] Output Update Disable bit. */
    vuint32_t OU3:1;                   /* Channel [n] Output Update Disable bit. */
    vuint32_t OU4:1;                   /* Channel [n] Output Update Disable bit. */
    vuint32_t OU5:1;                   /* Channel [n] Output Update Disable bit. */
    vuint32_t OU6:1;                   /* Channel [n] Output Update Disable bit. */
    vuint32_t OU7:1;                   /* Channel [n] Output Update Disable bit. */
    vuint32_t _unused_8:1;             /* Reserved. */
    vuint32_t _unused_9:1;             /* Reserved. */
    vuint32_t _unused_10:1;            /* Reserved. */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t _unused_12:1;            /* Reserved. */
    vuint32_t _unused_13:1;            /* Reserved. */
    vuint32_t _unused_14:1;            /* Reserved. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t OU16:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU17:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU18:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU19:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU20:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU21:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU22:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU23:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU24:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU25:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU26:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU27:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU28:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU29:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU30:1;                  /* Channel [n] Output Update Disable bit. */
    vuint32_t OU31:1;                  /* Channel [n] Output Update Disable bit. */
  } B;
} EMIOS_OUDIS_tag;

typedef union EMIOS_UCDIS_union_tag {  /* eMIOS Disable Channel register */
  vuint32_t R;
  struct {
    vuint32_t UCDIS0:1;                /* Enable Channel n bit. */
    vuint32_t UCDIS1:1;                /* Enable Channel n bit. */
    vuint32_t UCDIS2:1;                /* Enable Channel n bit. */
    vuint32_t UCDIS3:1;                /* Enable Channel n bit. */
    vuint32_t UCDIS4:1;                /* Enable Channel n bit. */
    vuint32_t UCDIS5:1;                /* Enable Channel n bit. */
    vuint32_t UCDIS6:1;                /* Enable Channel n bit. */
    vuint32_t UCDIS7:1;                /* Enable Channel n bit. */
    vuint32_t UCDIS8:1;                /* Enable Channel n bit. */
    vuint32_t _unused_9:1;             /* Reserved. */
    vuint32_t UCDIS10:1;               /* Enable Channel n bit. */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t UCDIS12:1;               /* Enable Channel n bit. */
    vuint32_t _unused_13:1;            /* Reserved. */
    vuint32_t UCDIS14:1;               /* Enable Channel n bit. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t UCDIS16:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS17:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS18:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS19:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS20:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS21:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS22:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS23:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS24:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS25:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS26:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS27:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS28:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS29:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS30:1;               /* Enable Channel n bit. */
    vuint32_t UCDIS31:1;               /* Enable Channel n bit. */
  } B;
} EMIOS_UCDIS_tag;

typedef union EMIOS_CH_UC_A_union_tag { /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t A:24;                    /* A */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} EMIOS_CH_UC_A_tag;

typedef union EMIOS_CH_UC_B_union_tag { /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t B:24;                    /* See text above register figure. */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} EMIOS_CH_UC_B_tag;

typedef union EMIOS_CH_UC_CNT_union_tag { /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t C:24;                    /* The C field contains the value of the internal counter.{mts_ipi_slv_counter_bus} */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} EMIOS_CH_UC_CNT_tag;

typedef union EMIOS_CH_UC_C_union_tag { /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t MODE:7;                  /* Mode selection bits. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. {Statement} */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t BSL:2;                   /* Bus Select bits. {Statement} */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t FORCMA:1;                /* Force Match A bit. {Statement} */
    vuint32_t _unused_14:3;            /* Reserved. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t IF:4;                    /* Input Filter bits. {Statement} */
    vuint32_t _unused_23:1;            /* Reserved. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. {Statement} */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
  } B;
} EMIOS_CH_UC_C_tag;

typedef union EMIOS_CH_UC_S_union_tag { /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t FLAG:1;                  /* FLAG bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t _unused_3:12;            /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t _unused_16:15;           /* Reserved. */
    vuint32_t OVR:1;                   /* Overrun bit. */
  } B;
} EMIOS_CH_UC_S_tag;

typedef union EMIOS_CH_UC_ALTA_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t ALTA:24;                 /* See text above register figure. */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} EMIOS_CH_UC_ALTA_tag;

typedef union EMIOS_CH_UC_C2_union_tag { /* eMIOS UC Control 2 register n */
  vuint32_t R;
  struct {
    vuint32_t UCRELDEL_INT:5;          /* Unified Channel Reload Signal Output Delay Interval. */
    vuint32_t _unused_5:9;             /* Reserved. */
    vuint32_t UCPRECLK:1;              /* Prescaler Clock select bit. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t UCEXTPRE:14;             /* Extended Prescaler bits [29:16]. */
    vuint32_t _unused_30:2;            /* Reserved. */
  } B;
} EMIOS_CH_UC_C2_tag;

typedef struct EMIOS_CH_UC_struct_tag {
  EMIOS_CH_UC_A_tag A;                 /* eMIOS UC A register n */
  EMIOS_CH_UC_B_tag B;                 /* eMIOS UC B register n */
  EMIOS_CH_UC_CNT_tag CNT;             /* eMIOS CNT register n */
  EMIOS_CH_UC_C_tag C;                 /* eMIOS UC Control register n */
  EMIOS_CH_UC_S_tag S;                 /* eMIOS UC Status register n */
  EMIOS_CH_UC_ALTA_tag ALTA;           /* eMIOS Alternate Address register n */
  EMIOS_CH_UC_C2_tag C2;               /* eMIOS UC Control 2 register n */
  uint8_t UC_reserved0[4];
} EMIOS_CH_UC_tag;

typedef union EMIOS_CH_WSC_WSCAEC_union_tag { /* eMIOS WSC Capture A and EVCNT register n */
  vuint32_t R;
  struct {
    vuint32_t T24CAPA:24;              /* T24CAPA[23:0]. */
    vuint32_t EVCNT:8;                 /* EVCNT[0:7]. */
  } B;
} EMIOS_CH_WSC_WSCAEC_tag;

typedef union EMIOS_CH_WSC_WSCAPB_union_tag { /* eMIOS WSC Capture B register n */
  vuint32_t R;
  struct {
    vuint32_t T24CAPB:24;              /* T24CAPB[23:0]. See text above register figure. */
    vuint32_t _unused_24:8;            /* Reserved */
  } B;
} EMIOS_CH_WSC_WSCAPB_tag;

typedef union EMIOS_CH_WSC_WSC1_union_tag { /* eMIOS WSC Control 1 register n */
  vuint32_t R;
  struct {
    vuint32_t MODE:7;                  /* Mode selection bits {mts_ipi_slv_wsc} . */
    vuint32_t EDPOLCAP:1;              /* Capture Register Edge Polarity bit{mts_ipi_slv_wsc}. */
    vuint32_t EDSELCAP:1;              /* Capture Register Edge Selection bit.{mts_ipi_slv_wsc} */
    vuint32_t BSL:2;                   /* Bus Select bits {mts_ipi_slv_wsc} . */
    vuint32_t _unused_11:6;            /* Reserved */
    vuint32_t FEN:1;                   /* FLAG/OVERRUN Enable bit {mts_ipi_slv_wsc} . */
    vuint32_t FCK:1;                   /* Filter Clock select bit {mts_ipi_slv_filter} . */
    vuint32_t IF4_7:4;                 /* Input Filter bits.{mts_ipi_slv_filter} */
    vuint32_t _unused_23:1;            /* Reserved */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t CPREN:1;                 /* T16PWCNT Counter Prescaler Enable bit {mts_ipi_slv_prescaler} . */
    vuint32_t IF0_3:4;                 /* Input Filter bits {mts_ipi_slv_filter} . */
    vuint32_t _unused_30:1;            /* Reserved */
    vuint32_t FREN:1;                  /* Freeze Enable bit {mts_ipi_slv_wsc} . */
  } B;
} EMIOS_CH_WSC_WSC1_tag;

typedef union EMIOS_CH_WSC_WSC2_union_tag { /* eMIOS WSC Control 2 register n */
  vuint32_t R;
  struct {
    vuint32_t FLAGSEL:6;               /* Flag Selection bits.{mts_ipi_slv_wsc} */
    vuint32_t _unused_6:1;             /* Reserved */
    vuint32_t EDPOLPW:1;               /* Pulse Width Detection Edge Polarity bit {mts_ipi_slv_wsc} . */
    vuint32_t EDSELPW:1;               /* Pulse Width Detection Edge Selection bit.{mts_ipi_slv_wsc} */
    vuint32_t _unused_9:3;             /* Reserved */
    vuint32_t PWREN:1;                 /* T16PWCNT Pulse Width Counter reset enable bit {mts_ipi_slv_wsc} . */
    vuint32_t PWSWR:1;                 /* T16PWCNT Pulse Width Counter software reset {mts_ipi_slv_wsc} . */
    vuint32_t WSPREMODE:1;             /* Wheel Speed Channel internal prescalar operating mode. {mts_ipi_slv_wsc} */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t WSPRE:12;                /* Prescaler bits 11:00:11{mts_ipi_slv_prescaler} . */
    vuint32_t _unused_28:4;            /* Reserved */
  } B;
} EMIOS_CH_WSC_WSC2_tag;

typedef union EMIOS_CH_WSC_WSS_union_tag { /* eMIOS WSC Status register n */
  vuint32_t R;
  struct {
    vuint32_t FLAGCE:1;                /* FLAG Compare Event bit {mts_ipi_slv_wsc} . */
    vuint32_t FLAGECO:1;               /* FLAG Event Counter Overflow bit {mts_ipi_slv_wsc} . */
    vuint32_t FLAGPW:1;                /* FLAG Pulse Width Capture Event bit {mts_ipi_slv_wsc} . */
    vuint32_t FLAGCAP:1;               /* FLAG Capture Event bit {mts_ipi_slv_wsc} . */
    vuint32_t FLAGPWO:1;               /* FLAG T16PWCNT Pulse Width Counter Overflow bit {mts_ipi_slv_wsc} . */
    vuint32_t FLAGFF:1;                /* FIFO Full bit {mts_ipi_slv_wsc} . */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t OVRCE:1;                 /* FLAGCE Overrun bit {mts_ipi_slv_wsc} . */
    vuint32_t OVRECO:1;                /* FLAGECO Overrun bit {mts_ipi_slv_wsc} . */
    vuint32_t OVRPW:1;                 /* FLAGPW Overrun bit {mts_ipi_slv_wsc} . */
    vuint32_t OVRCAP:1;                /* FLAGCAP Overrun bit. */
    vuint32_t OVRPWO:1;                /* FLAGPWO Overrun bit {mts_ipi_slv_wsc} . */
    vuint32_t _unused_13:2;            /* Reserved */
    vuint32_t WSCIN:1;                 /* Wheel Speed Channel Input pin bit {mts_ipi_slv_filter} . */
    vuint32_t FLAGCEC:1;               /* FLAGCE Clear bit {mts_ipi_slv_wsc} . */
    vuint32_t FLAGECOC:1;              /* FLAGECO Clear bit {mts_ipi_slv_wsc} . */
    vuint32_t FLAGPWC:1;               /* FLAGPW Clear bit {mts_ipi_slv_wsc} . */
    vuint32_t FLAGCAPC:1;              /* FLAGCAP Clear bit {mts_ipi_slv_wsc} . */
    vuint32_t FLAGPWOC:1;              /* FLAGPWO Clear bit {mts_ipi_slv_wsc} . */
    vuint32_t FLAGFFC:1;               /* FLAGFF Clear bit {mts_ipi_slv_wsc} . */
    vuint32_t _unused_22:2;            /* Reserved */
    vuint32_t OVRCEC:1;                /* OVRCE Clear bit {mts_ipi_slv_wsc} . */
    vuint32_t OVRECOC:1;               /* OVRECO Clear bit {mts_ipi_slv_wsc} */
    vuint32_t OVRPWC:1;                /* OVRPW Clear bit {mts_ipi_slv_wsc} . */
    vuint32_t OVRCAPC:1;               /* OVRCAP Clear bit {mts_ipi_slv_wsc} . */
    vuint32_t OVRPWOC:1;               /* OVRPWO Clear bit {mts_ipi_slv_wsc} . */
    vuint32_t _unused_29:3;            /* Reserved */
  } B;
} EMIOS_CH_WSC_WSS_tag;

typedef union EMIOS_CH_WSC_WSEV_union_tag { /* eMIOS WSC Event register n */
  vuint32_t R;
  struct {
    vuint32_t EVENT:8;                 /* EVENT[0:7] bits. */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} EMIOS_CH_WSC_WSEV_tag;

typedef union EMIOS_CH_WSC_WSCEV_union_tag { /* eMIOS WSC Capture Event register n */
  vuint32_t R;
  struct {
    vuint32_t T24CAPEV:24;             /* T24CAPEV[0:7] bits. */
    vuint32_t _unused_24:8;            /* Reserved */
  } B;
} EMIOS_CH_WSC_WSCEV_tag;

typedef union EMIOS_CH_WSC_WSPW_union_tag { /* eMIOS WSC Pulse Width register n */
  vuint32_t R;
  struct {
    vuint32_t T16PWCAP:16;             /* T16PWCAP[15:0] bits. */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} EMIOS_CH_WSC_WSPW_tag;

typedef union EMIOS_CH_WSC_WSPWCNT_union_tag { /* eMIOS WSC Pulse Width Counter register n */
  vuint32_t R;
  struct {
    vuint32_t T16PWCNT:16;             /* T16PWCNT[15:0] bits. */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} EMIOS_CH_WSC_WSPWCNT_tag;

typedef union EMIOS_CH_WSC_SWSFC_union_tag { /* eMIOS WSC FIFO Control register n */
  vuint32_t R;
  struct {
    vuint32_t CLRF:1;                  /* Clear FIFO {mts_ipi_slv_wsc} . */
    vuint32_t FOOE:1;                  /* FIFO Overflow Overwrite Enable. {mts_ipi_slv_wsc} */
    vuint32_t _unused_2:30;            /* Reserved */
  } B;
} EMIOS_CH_WSC_SWSFC_tag;

typedef union EMIOS_CH_WSC_WSFR_union_tag { /* eMIOS WSC FIFO Read register n */
  vuint32_t R;
  struct {
    vuint32_t T24CAPA_T16PWD_VAL:16;   /* In wheel speed mode, Least significant 16-bits of the 24-bit input capture value (T24CAPA_VAL). In SENT_Mode, 16-bit pulse width measurement value (T16PWD_VAL). {mts_ipi_slv_wsc} */
    vuint32_t E:1;                     /* Captured Edge Type {mts_ipi_slv_wsc} . */
    vuint32_t _unused_17:15;           /* Reserved */
  } B;
} EMIOS_CH_WSC_WSFR_tag;

typedef union EMIOS_CH_WSC_WSFCNT_union_tag { /* eMIOS WSC FIFO Counter register n */
  vuint32_t R;
  struct {
    vuint32_t FCNTR:8;                 /* FIFO {mts_ipi_slv_wsc} Counter */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} EMIOS_CH_WSC_WSFCNT_tag;

typedef union EMIOS_CH_WSC_WSFPNT_union_tag { /* eMIOS WSC FIFO Pointer register n */
  vuint32_t R;
  struct {
    vuint32_t FIFORDPT:8;              /* FIFO Read Pointer {mts_ipi_slv_wsc} . */
    vuint32_t _unused_8:8;             /* Reserved */
    vuint32_t FIFOWRPT:8;              /* FIFO Write Pointer {mts_ipi_slv_wsc} . */
    vuint32_t _unused_24:8;            /* Reserved */
  } B;
} EMIOS_CH_WSC_WSFPNT_tag;

typedef struct EMIOS_CH_WSC_struct_tag {
  EMIOS_CH_WSC_WSCAEC_tag WSCAEC;      /* eMIOS WSC Capture A and EVCNT register n */
  EMIOS_CH_WSC_WSCAPB_tag WSCAPB;      /* eMIOS WSC Capture B register n */
  EMIOS_CH_WSC_WSC1_tag WSC1;          /* eMIOS WSC Control 1 register n */
  EMIOS_CH_WSC_WSC2_tag WSC2;          /* eMIOS WSC Control 2 register n */
  EMIOS_CH_WSC_WSS_tag WSS;            /* eMIOS WSC Status register n */
  EMIOS_CH_WSC_WSEV_tag WSEV;          /* eMIOS WSC Event register n */
  EMIOS_CH_WSC_WSCEV_tag WSCEV;        /* eMIOS WSC Capture Event register n */
  EMIOS_CH_WSC_WSPW_tag WSPW;          /* eMIOS WSC Pulse Width register n */
  EMIOS_CH_WSC_WSPWCNT_tag WSPWCNT;    /* eMIOS WSC Pulse Width Counter register n */
  EMIOS_CH_WSC_SWSFC_tag SWSFC;        /* eMIOS WSC FIFO Control register n */
  EMIOS_CH_WSC_WSFR_tag WSFR;          /* eMIOS WSC FIFO Read register n */
  EMIOS_CH_WSC_WSFCNT_tag WSFCNT;      /* eMIOS WSC FIFO Counter register n */
  EMIOS_CH_WSC_WSFPNT_tag WSFPNT;      /* eMIOS WSC FIFO Pointer register n */
  uint8_t WSC_reserved0[12];
} EMIOS_CH_WSC_tag;

typedef union EMIOS_CH_union_tag {
  EMIOS_CH_UC_tag UC[32];              /* Valid array indices: 0-7, 16-31 */
  EMIOS_CH_WSC_tag WSC[8];             /* Valid array indices: 4-7 */
} EMIOS_CH_tag;

struct EMIOS_tag {
  EMIOS_MCR_tag MCR;                   /* eMIOS Module Configuration Register */
  EMIOS_GFLAG_tag GFLAG;               /* eMIOS Global FLAG Register */
  EMIOS_OUDIS_tag OUDIS;               /* eMIOS Output Update Disable register */
  EMIOS_UCDIS_tag UCDIS;               /* eMIOS Disable Channel register */
  uint8_t EMIOS_reserved0[16];
  EMIOS_CH_tag CH;
};


/* ============================================================================
   =============================== Module: ERM ================================
   ============================================================================ */

typedef union ERM_CR0_union_tag {      /* ERM Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;             /* Reserved */
    vuint32_t _unused_2:2;             /* Reserved */
    vuint32_t _unused_4:2;             /* Reserved */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t _unused_8:2;             /* Reserved */
    vuint32_t _unused_10:2;            /* Reserved */
    vuint32_t _unused_12:2;            /* Reserved */
    vuint32_t _unused_14:2;            /* Reserved */
    vuint32_t _unused_16:2;            /* Reserved */
    vuint32_t ENCIE3:1;                /* ENCIE3 */
    vuint32_t ESCIE3:1;                /* ESCIE3 */
    vuint32_t _unused_20:2;            /* Reserved */
    vuint32_t ENCIE2:1;                /* ENCIE2 */
    vuint32_t ESCIE2:1;                /* ESCIE2 */
    vuint32_t _unused_24:2;            /* Reserved */
    vuint32_t ENCIE1:1;                /* ENCIE1 */
    vuint32_t ESCIE1:1;                /* ESCIE1 */
    vuint32_t _unused_28:2;            /* Reserved */
    vuint32_t ENCIE0:1;                /* ENCIE0 */
    vuint32_t ESCIE0:1;                /* ESCIE0 */
  } B;
} ERM_CR0_tag;

typedef union ERM_SR0_union_tag {      /* ERM Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* Reserved */
    vuint32_t _unused_4:4;             /* Reserved */
    vuint32_t _unused_8:4;             /* Reserved */
    vuint32_t _unused_12:4;            /* Reserved */
    vuint32_t _unused_16:2;            /* Reserved */
    vuint32_t NCE3:1;                  /* NCE3 */
    vuint32_t SBC3:1;                  /* SBC3 */
    vuint32_t _unused_20:2;            /* Reserved */
    vuint32_t NCE2:1;                  /* NCE2 */
    vuint32_t SBC2:1;                  /* SBC2 */
    vuint32_t _unused_24:2;            /* Reserved */
    vuint32_t NCE1:1;                  /* NCE1 */
    vuint32_t SBC1:1;                  /* SBC1 */
    vuint32_t _unused_28:2;            /* Reserved */
    vuint32_t NCE0:1;                  /* NCE0 */
    vuint32_t SBC0:1;                  /* SBC0 */
  } B;
} ERM_SR0_tag;

typedef union ERM_EAR0_union_tag {     /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;                  /* EAR */
  } B;
} ERM_EAR0_tag;

typedef union ERM_SYN0_union_tag {     /* ERM Memory n Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;            /* Reserved */
    vuint32_t SYNDROME:8;              /* SYNDROME */
  } B;
} ERM_SYN0_tag;

typedef union ERM_CORR_ERR_CNT0_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_CORR_ERR_CNT0_tag;

typedef union ERM_EAR1_union_tag {     /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;                  /* EAR */
  } B;
} ERM_EAR1_tag;

typedef union ERM_SYN1_union_tag {     /* ERM Memory n Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;            /* Reserved */
    vuint32_t SYNDROME:8;              /* SYNDROME */
  } B;
} ERM_SYN1_tag;

typedef union ERM_CORR_ERR_CNT1_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_CORR_ERR_CNT1_tag;

typedef union ERM_EAR2_union_tag {     /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;                  /* EAR */
  } B;
} ERM_EAR2_tag;

typedef union ERM_SYN2_union_tag {     /* ERM Memory n Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;            /* Reserved */
    vuint32_t SYNDROME:8;              /* SYNDROME */
  } B;
} ERM_SYN2_tag;

typedef union ERM_CORR_ERR_CNT2_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_CORR_ERR_CNT2_tag;

typedef union ERM_EAR3_union_tag {     /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;                  /* EAR */
  } B;
} ERM_EAR3_tag;

typedef union ERM_CORR_ERR_CNT3_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_CORR_ERR_CNT3_tag;

struct ERM_tag {
  ERM_CR0_tag CR0;                     /* ERM Configuration Register 0 */
  uint8_t ERM_reserved0[12];
  ERM_SR0_tag SR0;                     /* ERM Status Register 0 */
  uint8_t ERM_reserved1[236];
  ERM_EAR0_tag EAR0;                   /* ERM Memory n Error Address Register */
  ERM_SYN0_tag SYN0;                   /* ERM Memory n Syndrome Register */
  ERM_CORR_ERR_CNT0_tag CORR_ERR_CNT0; /* ERM Memory n Correctable Error Count Register */
  uint8_t ERM_reserved2[4];
  ERM_EAR1_tag EAR1;                   /* ERM Memory n Error Address Register */
  ERM_SYN1_tag SYN1;                   /* ERM Memory n Syndrome Register */
  ERM_CORR_ERR_CNT1_tag CORR_ERR_CNT1; /* ERM Memory n Correctable Error Count Register */
  uint8_t ERM_reserved3[4];
  ERM_EAR2_tag EAR2;                   /* ERM Memory n Error Address Register */
  ERM_SYN2_tag SYN2;                   /* ERM Memory n Syndrome Register */
  ERM_CORR_ERR_CNT2_tag CORR_ERR_CNT2; /* ERM Memory n Correctable Error Count Register */
  uint8_t ERM_reserved4[4];
  ERM_EAR3_tag EAR3;                   /* ERM Memory n Error Address Register */
  uint8_t ERM_reserved5[4];
  ERM_CORR_ERR_CNT3_tag CORR_ERR_CNT3; /* ERM Memory n Correctable Error Count Register */
};


/* ============================================================================
   =============================== Module: ERM_PER ============================
   ============================================================================ */

typedef union ERM_PER_CR0_union_tag {  /* ERM Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;             /* Reserved */
    vuint32_t ENCIE7:1;                /* ENCIE7 */
    vuint32_t ESCIE7:1;                /* ESCIE7 */
    vuint32_t _unused_4:2;             /* Reserved */
    vuint32_t ENCIE6:1;                /* ENCIE6 */
    vuint32_t ESCIE6:1;                /* ESCIE6 */
    vuint32_t _unused_8:2;             /* Reserved */
    vuint32_t ENCIE5:1;                /* ENCIE5 */
    vuint32_t ESCIE5:1;                /* ESCIE5 */
    vuint32_t _unused_12:2;            /* Reserved */
    vuint32_t ENCIE4:1;                /* ENCIE4 */
    vuint32_t ESCIE4:1;                /* ESCIE4 */
    vuint32_t _unused_16:2;            /* Reserved */
    vuint32_t ENCIE3:1;                /* ENCIE3 */
    vuint32_t ESCIE3:1;                /* ESCIE3 */
    vuint32_t _unused_20:2;            /* Reserved */
    vuint32_t ENCIE2:1;                /* ENCIE2 */
    vuint32_t ESCIE2:1;                /* ESCIE2 */
    vuint32_t _unused_24:2;            /* Reserved */
    vuint32_t ENCIE1:1;                /* ENCIE1 */
    vuint32_t ESCIE1:1;                /* ESCIE1 */
    vuint32_t _unused_28:2;            /* Reserved */
    vuint32_t ENCIE0:1;                /* ENCIE0 */
    vuint32_t ESCIE0:1;                /* ESCIE0 */
  } B;
} ERM_PER_CR0_tag;

typedef union ERM_PER_CR1_union_tag {  /* ERM Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;             /* Reserved */
    vuint32_t _unused_2:2;             /* Reserved */
    vuint32_t _unused_4:2;             /* Reserved */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t _unused_8:2;             /* Reserved */
    vuint32_t _unused_10:2;            /* Reserved */
    vuint32_t _unused_12:2;            /* Reserved */
    vuint32_t _unused_14:2;            /* Reserved */
    vuint32_t _unused_16:2;            /* Reserved */
    vuint32_t _unused_18:2;            /* Reserved */
    vuint32_t _unused_20:2;            /* Reserved */
    vuint32_t _unused_22:2;            /* Reserved */
    vuint32_t _unused_24:2;            /* Reserved */
    vuint32_t _unused_26:2;            /* Reserved */
    vuint32_t _unused_28:2;            /* Reserved */
    vuint32_t ENCIE8:1;                /* ENCIE8 */
    vuint32_t ESCIE8:1;                /* ESCIE8 */
  } B;
} ERM_PER_CR1_tag;

typedef union ERM_PER_SR0_union_tag {  /* ERM Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;             /* Reserved */
    vuint32_t NCE7:1;                  /* NCE7 */
    vuint32_t SBC7:1;                  /* SBC7 */
    vuint32_t _unused_4:2;             /* Reserved */
    vuint32_t NCE6:1;                  /* NCE6 */
    vuint32_t SBC6:1;                  /* SBC6 */
    vuint32_t _unused_8:2;             /* Reserved */
    vuint32_t NCE5:1;                  /* NCE5 */
    vuint32_t SBC5:1;                  /* SBC5 */
    vuint32_t _unused_12:2;            /* Reserved */
    vuint32_t NCE4:1;                  /* NCE4 */
    vuint32_t SBC4:1;                  /* SBC4 */
    vuint32_t _unused_16:2;            /* Reserved */
    vuint32_t NCE3:1;                  /* NCE3 */
    vuint32_t SBC3:1;                  /* SBC3 */
    vuint32_t _unused_20:2;            /* Reserved */
    vuint32_t NCE2:1;                  /* NCE2 */
    vuint32_t SBC2:1;                  /* SBC2 */
    vuint32_t _unused_24:2;            /* Reserved */
    vuint32_t NCE1:1;                  /* NCE1 */
    vuint32_t SBC1:1;                  /* SBC1 */
    vuint32_t _unused_28:2;            /* Reserved */
    vuint32_t NCE0:1;                  /* NCE0 */
    vuint32_t SBC0:1;                  /* SBC0 */
  } B;
} ERM_PER_SR0_tag;

typedef union ERM_PER_SR1_union_tag {  /* ERM Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* Reserved */
    vuint32_t _unused_4:4;             /* Reserved */
    vuint32_t _unused_8:4;             /* Reserved */
    vuint32_t _unused_12:4;            /* Reserved */
    vuint32_t _unused_16:4;            /* Reserved */
    vuint32_t _unused_20:4;            /* Reserved */
    vuint32_t _unused_24:4;            /* Reserved */
    vuint32_t _unused_28:2;            /* Reserved */
    vuint32_t NCE8:1;                  /* NCE8 */
    vuint32_t SBC8:1;                  /* SBC8 */
  } B;
} ERM_PER_SR1_tag;

typedef union ERM_PER_EAR0_union_tag { /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;                  /* EAR */
  } B;
} ERM_PER_EAR0_tag;

typedef union ERM_PER_CORR_ERR_CNT0_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_PER_CORR_ERR_CNT0_tag;

typedef union ERM_PER_EAR1_union_tag { /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;                  /* EAR */
  } B;
} ERM_PER_EAR1_tag;

typedef union ERM_PER_CORR_ERR_CNT1_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_PER_CORR_ERR_CNT1_tag;

typedef union ERM_PER_EAR2_union_tag { /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;                  /* EAR */
  } B;
} ERM_PER_EAR2_tag;

typedef union ERM_PER_CORR_ERR_CNT2_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_PER_CORR_ERR_CNT2_tag;

typedef union ERM_PER_EAR3_union_tag { /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;                  /* EAR */
  } B;
} ERM_PER_EAR3_tag;

typedef union ERM_PER_CORR_ERR_CNT3_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_PER_CORR_ERR_CNT3_tag;

typedef union ERM_PER_EAR4_union_tag { /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;                  /* EAR */
  } B;
} ERM_PER_EAR4_tag;

typedef union ERM_PER_CORR_ERR_CNT4_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_PER_CORR_ERR_CNT4_tag;

typedef union ERM_PER_EAR5_union_tag { /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;                  /* EAR */
  } B;
} ERM_PER_EAR5_tag;

typedef union ERM_PER_CORR_ERR_CNT5_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_PER_CORR_ERR_CNT5_tag;

typedef union ERM_PER_CORR_ERR_CNT6_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_PER_CORR_ERR_CNT6_tag;

typedef union ERM_PER_CORR_ERR_CNT7_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_PER_CORR_ERR_CNT7_tag;

typedef union ERM_PER_EAR8_union_tag { /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;                  /* EAR */
  } B;
} ERM_PER_EAR8_tag;

typedef union ERM_PER_SYN8_union_tag { /* ERM Memory n Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;            /* Reserved */
    vuint32_t SYNDROME:8;              /* SYNDROME */
  } B;
} ERM_PER_SYN8_tag;

typedef union ERM_PER_CORR_ERR_CNT8_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_PER_CORR_ERR_CNT8_tag;

struct ERM_PER_tag {
  ERM_PER_CR0_tag CR0;                 /* ERM Configuration Register 0 */
  ERM_PER_CR1_tag CR1;                 /* ERM Configuration Register 1 */
  uint8_t ERM_PER_reserved0[8];
  ERM_PER_SR0_tag SR0;                 /* ERM Status Register 0 */
  ERM_PER_SR1_tag SR1;                 /* ERM Status Register 1 */
  uint8_t ERM_PER_reserved1[232];
  ERM_PER_EAR0_tag EAR0;               /* ERM Memory n Error Address Register */
  uint8_t ERM_PER_reserved2[4];
  ERM_PER_CORR_ERR_CNT0_tag CORR_ERR_CNT0; /* ERM Memory n Correctable Error Count Register */
  uint8_t ERM_PER_reserved3[4];
  ERM_PER_EAR1_tag EAR1;               /* ERM Memory n Error Address Register */
  uint8_t ERM_PER_reserved4[4];
  ERM_PER_CORR_ERR_CNT1_tag CORR_ERR_CNT1; /* ERM Memory n Correctable Error Count Register */
  uint8_t ERM_PER_reserved5[4];
  ERM_PER_EAR2_tag EAR2;               /* ERM Memory n Error Address Register */
  uint8_t ERM_PER_reserved6[4];
  ERM_PER_CORR_ERR_CNT2_tag CORR_ERR_CNT2; /* ERM Memory n Correctable Error Count Register */
  uint8_t ERM_PER_reserved7[4];
  ERM_PER_EAR3_tag EAR3;               /* ERM Memory n Error Address Register */
  uint8_t ERM_PER_reserved8[4];
  ERM_PER_CORR_ERR_CNT3_tag CORR_ERR_CNT3; /* ERM Memory n Correctable Error Count Register */
  uint8_t ERM_PER_reserved9[4];
  ERM_PER_EAR4_tag EAR4;               /* ERM Memory n Error Address Register */
  uint8_t ERM_PER_reserved10[4];
  ERM_PER_CORR_ERR_CNT4_tag CORR_ERR_CNT4; /* ERM Memory n Correctable Error Count Register */
  uint8_t ERM_PER_reserved11[4];
  ERM_PER_EAR5_tag EAR5;               /* ERM Memory n Error Address Register */
  uint8_t ERM_PER_reserved12[4];
  ERM_PER_CORR_ERR_CNT5_tag CORR_ERR_CNT5; /* ERM Memory n Correctable Error Count Register */
  uint8_t ERM_PER_reserved13[12];
  ERM_PER_CORR_ERR_CNT6_tag CORR_ERR_CNT6; /* ERM Memory n Correctable Error Count Register */
  uint8_t ERM_PER_reserved14[12];
  ERM_PER_CORR_ERR_CNT7_tag CORR_ERR_CNT7; /* ERM Memory n Correctable Error Count Register */
  uint8_t ERM_PER_reserved15[4];
  ERM_PER_EAR8_tag EAR8;               /* ERM Memory n Error Address Register */
  ERM_PER_SYN8_tag SYN8;               /* ERM Memory n Syndrome Register */
  ERM_PER_CORR_ERR_CNT8_tag CORR_ERR_CNT8; /* ERM Memory n Correctable Error Count Register */
};


/* ============================================================================
   =============================== Module: ERM_eDMA_0 =========================
   ============================================================================ */

typedef union ERM_eDMA_0_CR0_union_tag { /* ERM Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;             /* Reserved */
    vuint32_t _unused_2:2;             /* Reserved */
    vuint32_t _unused_4:2;             /* Reserved */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t _unused_8:2;             /* Reserved */
    vuint32_t _unused_10:2;            /* Reserved */
    vuint32_t _unused_12:2;            /* Reserved */
    vuint32_t _unused_14:2;            /* Reserved */
    vuint32_t _unused_16:2;            /* Reserved */
    vuint32_t _unused_18:2;            /* Reserved */
    vuint32_t _unused_20:2;            /* Reserved */
    vuint32_t _unused_22:2;            /* Reserved */
    vuint32_t _unused_24:2;            /* Reserved */
    vuint32_t _unused_26:2;            /* Reserved */
    vuint32_t _unused_28:2;            /* Reserved */
    vuint32_t ENCIE0:1;                /* ENCIE0 */
    vuint32_t ESCIE0:1;                /* ESCIE0 */
  } B;
} ERM_eDMA_0_CR0_tag;

typedef union ERM_eDMA_0_SR0_union_tag { /* ERM Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* Reserved */
    vuint32_t _unused_4:4;             /* Reserved */
    vuint32_t _unused_8:4;             /* Reserved */
    vuint32_t _unused_12:4;            /* Reserved */
    vuint32_t _unused_16:4;            /* Reserved */
    vuint32_t _unused_20:4;            /* Reserved */
    vuint32_t _unused_24:4;            /* Reserved */
    vuint32_t _unused_28:2;            /* Reserved */
    vuint32_t NCE0:1;                  /* NCE0 */
    vuint32_t SBC0:1;                  /* SBC0 */
  } B;
} ERM_eDMA_0_SR0_tag;

typedef union ERM_eDMA_0_EAR0_union_tag { /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;                  /* EAR */
  } B;
} ERM_eDMA_0_EAR0_tag;

typedef union ERM_eDMA_0_SYN0_union_tag { /* ERM Memory n Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;            /* Reserved */
    vuint32_t SYNDROME:8;              /* SYNDROME */
  } B;
} ERM_eDMA_0_SYN0_tag;

typedef union ERM_eDMA_0_CORR_ERR_CNT0_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_eDMA_0_CORR_ERR_CNT0_tag;

struct ERM_eDMA_0_tag {
  ERM_eDMA_0_CR0_tag CR0;              /* ERM Configuration Register 0 */
  uint8_t ERM_eDMA_0_reserved0[12];
  ERM_eDMA_0_SR0_tag SR0;              /* ERM Status Register 0 */
  uint8_t ERM_eDMA_0_reserved1[236];
  ERM_eDMA_0_EAR0_tag EAR0;            /* ERM Memory n Error Address Register */
  ERM_eDMA_0_SYN0_tag SYN0;            /* ERM Memory n Syndrome Register */
  ERM_eDMA_0_CORR_ERR_CNT0_tag CORR_ERR_CNT0; /* ERM Memory n Correctable Error Count Register */
};


/* ============================================================================
   =============================== Module: ERM_eDMA_1 =========================
   ============================================================================ */

typedef union ERM_eDMA_1_CR0_union_tag { /* ERM Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;             /* Reserved */
    vuint32_t _unused_2:2;             /* Reserved */
    vuint32_t _unused_4:2;             /* Reserved */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t _unused_8:2;             /* Reserved */
    vuint32_t _unused_10:2;            /* Reserved */
    vuint32_t _unused_12:2;            /* Reserved */
    vuint32_t _unused_14:2;            /* Reserved */
    vuint32_t _unused_16:2;            /* Reserved */
    vuint32_t _unused_18:2;            /* Reserved */
    vuint32_t _unused_20:2;            /* Reserved */
    vuint32_t _unused_22:2;            /* Reserved */
    vuint32_t _unused_24:2;            /* Reserved */
    vuint32_t _unused_26:2;            /* Reserved */
    vuint32_t _unused_28:2;            /* Reserved */
    vuint32_t ENCIE0:1;                /* ENCIE0 */
    vuint32_t ESCIE0:1;                /* ESCIE0 */
  } B;
} ERM_eDMA_1_CR0_tag;

typedef union ERM_eDMA_1_SR0_union_tag { /* ERM Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:4;             /* Reserved */
    vuint32_t _unused_4:4;             /* Reserved */
    vuint32_t _unused_8:4;             /* Reserved */
    vuint32_t _unused_12:4;            /* Reserved */
    vuint32_t _unused_16:4;            /* Reserved */
    vuint32_t _unused_20:4;            /* Reserved */
    vuint32_t _unused_24:4;            /* Reserved */
    vuint32_t _unused_28:2;            /* Reserved */
    vuint32_t NCE0:1;                  /* NCE0 */
    vuint32_t SBC0:1;                  /* SBC0 */
  } B;
} ERM_eDMA_1_SR0_tag;

typedef union ERM_eDMA_1_EAR0_union_tag { /* ERM Memory n Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t EAR:32;                  /* EAR */
  } B;
} ERM_eDMA_1_EAR0_tag;

typedef union ERM_eDMA_1_SYN0_union_tag { /* ERM Memory n Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:24;            /* Reserved */
    vuint32_t SYNDROME:8;              /* SYNDROME */
  } B;
} ERM_eDMA_1_SYN0_tag;

typedef union ERM_eDMA_1_CORR_ERR_CNT0_union_tag { /* ERM Memory n Correctable Error Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:8;                 /* Memory n Correctable Error Count */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} ERM_eDMA_1_CORR_ERR_CNT0_tag;

struct ERM_eDMA_1_tag {
  ERM_eDMA_1_CR0_tag CR0;              /* ERM Configuration Register 0 */
  uint8_t ERM_eDMA_1_reserved0[12];
  ERM_eDMA_1_SR0_tag SR0;              /* ERM Status Register 0 */
  uint8_t ERM_eDMA_1_reserved1[236];
  ERM_eDMA_1_EAR0_tag EAR0;            /* ERM Memory n Error Address Register */
  ERM_eDMA_1_SYN0_tag SYN0;            /* ERM Memory n Syndrome Register */
  ERM_eDMA_1_CORR_ERR_CNT0_tag CORR_ERR_CNT0; /* ERM Memory n Correctable Error Count Register */
};


/* ============================================================================
   =============================== Module: ETIMER =============================
   ============================================================================ */

typedef union ETIMER_CH_COMP1_union_tag { /* Channel n Compare Register 1 */
  vuint16_t R;
  struct {
    vuint16_t COMP1:16;                /* COMP1 */
  } B;
} ETIMER_CH_COMP1_tag;

typedef union ETIMER_CH_COMP2_union_tag { /* Channel n Compare Register 2 */
  vuint16_t R;
  struct {
    vuint16_t COMP2:16;                /* COMP2 */
  } B;
} ETIMER_CH_COMP2_tag;

typedef union ETIMER_CH_CAPT1_union_tag { /* Channel n Capture Register 1 */
  vuint16_t R;
  struct {
    vuint16_t CAPT1:16;                /* CAPT1 */
  } B;
} ETIMER_CH_CAPT1_tag;

typedef union ETIMER_CH_CAPT2_union_tag { /* Channel n Capture Register 2 */
  vuint16_t R;
  struct {
    vuint16_t CAPT2:16;                /* CAPT2 */
  } B;
} ETIMER_CH_CAPT2_tag;

typedef union ETIMER_CH_LOAD_union_tag { /* Channel n Load Register */
  vuint16_t R;
  struct {
    vuint16_t LOAD:16;                 /* LOAD */
  } B;
} ETIMER_CH_LOAD_tag;

typedef union ETIMER_CH_HOLD_union_tag { /* Channel n Hold Register */
  vuint16_t R;
  struct {
    vuint16_t HOLD:16;                 /* HOLD */
  } B;
} ETIMER_CH_HOLD_tag;

typedef union ETIMER_CH_CNTR_union_tag { /* Channel n Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CNTR:16;                 /* CNTR */
  } B;
} ETIMER_CH_CNTR_tag;

typedef union ETIMER_CH_CTRL1_union_tag { /* Channel n Control Register 1 */
  vuint16_t R;
  struct {
    vuint16_t SECSRC:5;                /* Secondary Count Source */
    vuint16_t DIR:1;                   /* Count Direction */
    vuint16_t LENGTH:1;                /* Count Length */
    vuint16_t ONCE:1;                  /* Count once */
    vuint16_t PRISRC:5;                /* Primary Count Source */
    vuint16_t CNTMODE:3;               /* Count mode */
  } B;
} ETIMER_CH_CTRL1_tag;

typedef union ETIMER_CH_CTRL2_union_tag { /* Channel n Control Register 2 */
  vuint16_t R;
  struct {
    vuint16_t OUTMODE:4;               /* Output Mode */
    vuint16_t MSTR:1;                  /* Master Mode */
    vuint16_t OPS:1;                   /* Output Polarity Select. */
    vuint16_t PIPS:1;                  /* Primary Source Input Polarity Select */
    vuint16_t SIPS:1;                  /* Secondary Source Input Polarity Select */
    vuint16_t COINIT:2;                /* Co-channel Initialization */
    vuint16_t COFRC:1;                 /* Co-channel OFLAG Force */
    vuint16_t FORCE:1;                 /* Force the OFLAG output */
    vuint16_t VAL:1;                   /* Forced OFLAG Value */
    vuint16_t INPUT:1;                 /* External input signal */
    vuint16_t RDNT:1;                  /* Redundant Channel Enable */
    vuint16_t OEN:1;                   /* Output Enable */
  } B;
} ETIMER_CH_CTRL2_tag;

typedef union ETIMER_CH_CTRL3_union_tag { /* Channel n Control Register 3 */
  vuint16_t R;
  struct {
    vuint16_t DBGEN:2;                 /* Debug Actions Enable */
    vuint16_t C1FCNT:3;                /* Capture 1 FIFO count */
    vuint16_t C2FCNT:3;                /* Capture 2 FIFO count */
    vuint16_t _unused_8:5;             /* Reserved */
    vuint16_t ROC:2;                   /* Reload on Capture */
    vuint16_t _unused_15:1;            /* Reserved */
  } B;
} ETIMER_CH_CTRL3_tag;

typedef union ETIMER_CH_STS_union_tag { /* Channel n Status Register */
  vuint16_t R;
  struct {
    vuint16_t TCF:1;                   /* TCF */
    vuint16_t TCF1:1;                  /* Timer Compare 1 Flag */
    vuint16_t TCF2:1;                  /* Timer Compare 2 Flag */
    vuint16_t TOF:1;                   /* Timer Overflow Flag */
    vuint16_t IELF:1;                  /* Input Edge Low Flag */
    vuint16_t IEHF:1;                  /* Input Edge High Flag */
    vuint16_t ICF1:1;                  /* Input Capture 1 Flag */
    vuint16_t ICF2:1;                  /* Input Capture 2 Flag */
    vuint16_t RCF:1;                   /* Redundant Channel Flag */
    vuint16_t WDF:1;                   /* Watchdog Time-out Flag */
    vuint16_t _unused_10:6;            /* Reserved */
  } B;
} ETIMER_CH_STS_tag;

typedef union ETIMER_CH_INTDMA_union_tag { /* Channel n Interrupt and DMA Enable Register */
  vuint16_t R;
  struct {
    vuint16_t TCFIE:1;                 /* Timer Compare Flag Interrupt Enable */
    vuint16_t TCF1IE:1;                /* Timer Compare 1 Flag Interrupt Enable */
    vuint16_t TCF2IE:1;                /* Timer Compare 2 Flag Interrupt Enable */
    vuint16_t TOFIE:1;                 /* Timer Overflow Flag Interrupt Enable */
    vuint16_t IELFIE:1;                /* Input Edge Low Flag Interrupt Enable */
    vuint16_t IEHFIE:1;                /* Input Edge High Flag Interrupt Enable */
    vuint16_t ICF1IE:1;                /* Input Capture 1 Flag Interrupt Enable */
    vuint16_t ICF2IE:1;                /* Input Capture 2 Flag Interrupt Enable */
    vuint16_t RCFIE:1;                 /* Redundant Channel Flag Interrupt Enable */
    vuint16_t WDFIE:1;                 /* Watchdog Flag Interrupt Enable */
    vuint16_t _unused_10:2;            /* Reserved */
    vuint16_t CMPLD1DE:1;              /* Comparator Load Register 1 Flag DMA Enable */
    vuint16_t CMPLD2DE:1;              /* Comparator Load Register 2 Flag DMA Enable */
    vuint16_t ICF1DE:1;                /* Input Capture 1 Flag DMA Enable */
    vuint16_t ICF2DE:1;                /* Input Capture 2 Flag DMA Enable */
  } B;
} ETIMER_CH_INTDMA_tag;

typedef union ETIMER_CH_CMPLD1_union_tag { /* Channel n Comparator Load Register 1 */
  vuint16_t R;
  struct {
    vuint16_t CMPLD1:16;               /* CMPLD1 */
  } B;
} ETIMER_CH_CMPLD1_tag;

typedef union ETIMER_CH_CMPLD2_union_tag { /* Channel n Comparator Load Register 2 */
  vuint16_t R;
  struct {
    vuint16_t CMPLD2:16;               /* CMPLD2 */
  } B;
} ETIMER_CH_CMPLD2_tag;

typedef union ETIMER_CH_CCCTRL_union_tag { /* Channel n Compare and Capture Control Register */
  vuint16_t R;
  struct {
    vuint16_t ARM:1;                   /* Arm Capture */
    vuint16_t ONESHOT:1;               /* One Shot Capture Mode */
    vuint16_t CFWM:2;                  /* Capture FIFO Water Mark */
    vuint16_t CPT1MODE:2;              /* Capture 1 Mode Control */
    vuint16_t CPT2MODE:2;              /* Capture 2 Mode Control */
    vuint16_t CMPMODE:2;               /* Compare Mode */
    vuint16_t CLC1:3;                  /* Compare Load Control 1 */
    vuint16_t CLC2:3;                  /* Compare Load Control 2 */
  } B;
} ETIMER_CH_CCCTRL_tag;

typedef union ETIMER_CH_FILT_union_tag { /* Channel n Input Filter Register */
  vuint16_t R;
  struct {
    vuint16_t FILT_PER:8;              /* Input Filter Sample Period */
    vuint16_t FILT_CNT:3;              /* Input Filter Sample Count */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} ETIMER_CH_FILT_tag;

typedef struct ETIMER_CH_struct_tag {
  ETIMER_CH_COMP1_tag COMP1;           /* Channel n Compare Register 1 */
  ETIMER_CH_COMP2_tag COMP2;           /* Channel n Compare Register 2 */
  ETIMER_CH_CAPT1_tag CAPT1;           /* Channel n Capture Register 1 */
  ETIMER_CH_CAPT2_tag CAPT2;           /* Channel n Capture Register 2 */
  ETIMER_CH_LOAD_tag LOAD;             /* Channel n Load Register */
  ETIMER_CH_HOLD_tag HOLD;             /* Channel n Hold Register */
  ETIMER_CH_CNTR_tag CNTR;             /* Channel n Counter Register */
  ETIMER_CH_CTRL1_tag CTRL1;           /* Channel n Control Register 1 */
  ETIMER_CH_CTRL2_tag CTRL2;           /* Channel n Control Register 2 */
  ETIMER_CH_CTRL3_tag CTRL3;           /* Channel n Control Register 3 */
  ETIMER_CH_STS_tag STS;               /* Channel n Status Register */
  ETIMER_CH_INTDMA_tag INTDMA;         /* Channel n Interrupt and DMA Enable Register */
  ETIMER_CH_CMPLD1_tag CMPLD1;         /* Channel n Comparator Load Register 1 */
  ETIMER_CH_CMPLD2_tag CMPLD2;         /* Channel n Comparator Load Register 2 */
  ETIMER_CH_CCCTRL_tag CCCTRL;         /* Channel n Compare and Capture Control Register */
  ETIMER_CH_FILT_tag FILT;             /* Channel n Input Filter Register */
} ETIMER_CH_tag;

typedef union ETIMER_WDTOL_union_tag { /* Watchdog Time-out Low Word Register */
  vuint16_t R;
  struct {
    vuint16_t WDTOL:16;                /* WDTOL */
  } B;
} ETIMER_WDTOL_tag;

typedef union ETIMER_WDTOH_union_tag { /* Watchdog Time-out High Word Register */
  vuint16_t R;
  struct {
    vuint16_t WDTOH:16;                /* WDTOH */
  } B;
} ETIMER_WDTOH_tag;

typedef union ETIMER_ENBL_union_tag {  /* Channel Enable Register */
  vuint16_t R;
  struct {
    vuint16_t ENBL:6;                  /* Timer Channel Enable */
    vuint16_t _unused_6:10;            /* Reserved */
  } B;
} ETIMER_ENBL_tag;

typedef union ETIMER_DREQ0_union_tag { /* DMA Request 0 Select Register */
  vuint16_t R;
  struct {
    vuint16_t DREQ0:5;                 /* DMA Request Select */
    vuint16_t _unused_5:10;            /* Reserved */
    vuint16_t DREQ0_EN:1;              /* DREQ0_EN */
  } B;
} ETIMER_DREQ0_tag;

typedef union ETIMER_DREQ1_union_tag { /* DMA Request 1 Select Register */
  vuint16_t R;
  struct {
    vuint16_t DREQ1:5;                 /* DMA Request Select */
    vuint16_t _unused_5:10;            /* Reserved */
    vuint16_t DREQ1_EN:1;              /* DREQ1_EN */
  } B;
} ETIMER_DREQ1_tag;

typedef union ETIMER_DREQ2_union_tag { /* DMA Request 2 Select Register */
  vuint16_t R;
  struct {
    vuint16_t DREQ2:5;                 /* DMA Request Select */
    vuint16_t _unused_5:10;            /* Reserved */
    vuint16_t DREQ2_EN:1;              /* DREQ2_EN */
  } B;
} ETIMER_DREQ2_tag;

typedef union ETIMER_DREQ3_union_tag { /* DMA Request 3 Select Register */
  vuint16_t R;
  struct {
    vuint16_t DREQ3:5;                 /* DMA Request Select */
    vuint16_t _unused_5:10;            /* Reserved */
    vuint16_t DREQ3_EN:1;              /* DREQ3_EN */
  } B;
} ETIMER_DREQ3_tag;

struct ETIMER_tag {
  ETIMER_CH_tag CH[6];
  uint8_t ETIMER_reserved0[64];
  ETIMER_WDTOL_tag WDTOL;              /* Watchdog Time-out Low Word Register */
  ETIMER_WDTOH_tag WDTOH;              /* Watchdog Time-out High Word Register */
  uint8_t ETIMER_reserved1[8];
  ETIMER_ENBL_tag ENBL;                /* Channel Enable Register */
  uint8_t ETIMER_reserved2[2];
  ETIMER_DREQ0_tag DREQ0;              /* DMA Request 0 Select Register */
  ETIMER_DREQ1_tag DREQ1;              /* DMA Request 1 Select Register */
  ETIMER_DREQ2_tag DREQ2;              /* DMA Request 2 Select Register */
  ETIMER_DREQ3_tag DREQ3;              /* DMA Request 3 Select Register */
};


/* ============================================================================
   =============================== Module: FBXC ===============================
   ============================================================================ */

typedef union FBXC_STR_union_tag {     /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t REP_ERR:1;               /* Repair error */
    vuint32_t DRW:1;                   /* Disable repair write */
    vuint32_t _unused_2:30;            /* Reserved */
  } B;
} FBXC_STR_tag;

typedef union FBXC_FDADDR_union_tag {  /* Fusebox Debug Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;                 /* Address of error */
  } B;
} FBXC_FDADDR_tag;

typedef union FBXC_FDDATA_union_tag {  /* Fusebox Debug Data Register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;                 /* Data to be programmed */
  } B;
} FBXC_FDDATA_tag;

typedef union FBXC_CTL_union_tag {     /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t MR:1;                    /* Margin read enable */
    vuint32_t RSB:1;                   /* Repair enable (active-low) */
    vuint32_t _unused_2:30;            /* Reserved */
  } B;
} FBXC_CTL_tag;

typedef union FBXC_PRPW_union_tag {    /* Program and Read Pulse Width Register */
  vuint32_t R;
  struct {
    vuint32_t PPW:16;                  /* Program pulse width */
    vuint32_t RPW:8;                   /* Read pulse width */
    vuint32_t _unused_24:8;            /* Reserved */
  } B;
} FBXC_PRPW_tag;

typedef union FBXC_SHPW_union_tag {    /* Setup and Hold Pulse Width Register */
  vuint32_t R;
  struct {
    vuint32_t SPW:8;                   /* Short pulse width */
    vuint32_t LPW:8;                   /* Long pulse width */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} FBXC_SHPW_tag;

struct FBXC_tag {
  FBXC_STR_tag STR;                    /* Status Register */
  FBXC_FDADDR_tag FDADDR;              /* Fusebox Debug Address Register */
  FBXC_FDDATA_tag FDDATA;              /* Fusebox Debug Data Register */
  FBXC_CTL_tag CTL;                    /* Control Register */
  FBXC_PRPW_tag PRPW;                  /* Program and Read Pulse Width Register */
  FBXC_SHPW_tag SHPW;                  /* Setup and Hold Pulse Width Register */
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

typedef union FCCU_CTRL_union_tag {    /* Control */
  vuint32_t R;
  struct {
    vuint32_t OPR:5;                   /* Operation Run */
    vuint32_t _unused_5:1;             /* Reserved */
    vuint32_t OPS:2;                   /* Operation Status */
    vuint32_t _unused_8:1;             /* Reserved */
    vuint32_t DEBUG:1;                 /* Debug Mode Enable */
    vuint32_t _unused_10:19;           /* Reserved */
    vuint32_t _unused_29:2;            /* Reserved */
    vuint32_t _unused_31:1;            /* Reserved */
  } B;
} FCCU_CTRL_tag;

typedef union FCCU_CTRLK_union_tag {   /* Control Key */
  vuint32_t R;
  struct {
    vuint32_t CTRLK:32;                /* Locked-Operation Control Key */
  } B;
} FCCU_CTRLK_tag;

typedef union FCCU_CFG_union_tag {     /* Configuration */
  vuint32_t R;
  struct {
    vuint32_t FOP:6;                   /* Fault-Output (EOUT) Prescaler */
    vuint32_t FOM:3;                   /* Fault-Output (EOUT) Mode */
    vuint32_t PS:1;                    /* Fault-Output (EOUT) Polarity Selection */
    vuint32_t SM:1;                    /* Fault-Output (EOUT) Switching Mode */
    vuint32_t _unused_11:1;            /* Reserved */
    vuint32_t _unused_12:1;            /* Reserved */
    vuint32_t _unused_13:2;            /* Reserved */
    vuint32_t FOPE:1;                  /* Fault-Output (EOUT) Prescaler Extension */
    vuint32_t _unused_16:4;            /* Reserved */
    vuint32_t _unused_20:2;            /* Reserved */
    vuint32_t FCCU_SET_CLEAR:2;        /* Fault-Output (EOUT) Control */
    vuint32_t FCCU_SET_AFTER_RESET:1;  /* Fault-Output (EOUT) Activate */
    vuint32_t _unused_25:7;            /* Reserved */
  } B;
} FCCU_CFG_tag;

typedef union FCCU_NCF_CFG_union_tag { /* Non-critical Fault Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFC0:1;                 /* Non-critical Fault Configuration n */
    vuint32_t NCFC1:1;                 /* Non-critical Fault Configuration n */
    vuint32_t NCFC2:1;                 /* Non-critical Fault Configuration n */
    vuint32_t NCFC3:1;                 /* Non-critical Fault Configuration n */
    vuint32_t NCFC4:1;                 /* Non-critical Fault Configuration n */
    vuint32_t NCFC5:1;                 /* Non-critical Fault Configuration n */
    vuint32_t NCFC6:1;                 /* Non-critical Fault Configuration n */
    vuint32_t NCFC7:1;                 /* Non-critical Fault Configuration n */
    vuint32_t NCFC8:1;                 /* Non-critical Fault Configuration n */
    vuint32_t NCFC9:1;                 /* Non-critical Fault Configuration n */
    vuint32_t NCFC10:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC11:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC12:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC13:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC14:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC15:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC16:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC17:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC18:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC19:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC20:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC21:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC22:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC23:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC24:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC25:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC26:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC27:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC28:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC29:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC30:1;                /* Non-critical Fault Configuration n */
    vuint32_t NCFC31:1;                /* Non-critical Fault Configuration n */
  } B;
} FCCU_NCF_CFG_tag;

typedef union FCCU_NCFS_CFG_union_tag { /* Non-critical Fault-State Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFSC0:2;                /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC1:2;                /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC2:2;                /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC3:2;                /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC4:2;                /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC5:2;                /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC6:2;                /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC7:2;                /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC8:2;                /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC9:2;                /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC10:2;               /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC11:2;               /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC12:2;               /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC13:2;               /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC14:2;               /* Non-critical Fault-State Configuration n */
    vuint32_t NCFSC15:2;               /* Non-critical Fault-State Configuration n */
  } B;
} FCCU_NCFS_CFG_tag;

typedef union FCCU_NCF_S_union_tag {   /* Non-critical Fault Status */
  vuint32_t R;
  struct {
    vuint32_t NCFS0:1;                 /* Non-critical Fault Status n */
    vuint32_t NCFS1:1;                 /* Non-critical Fault Status n */
    vuint32_t NCFS2:1;                 /* Non-critical Fault Status n */
    vuint32_t NCFS3:1;                 /* Non-critical Fault Status n */
    vuint32_t NCFS4:1;                 /* Non-critical Fault Status n */
    vuint32_t NCFS5:1;                 /* Non-critical Fault Status n */
    vuint32_t NCFS6:1;                 /* Non-critical Fault Status n */
    vuint32_t NCFS7:1;                 /* Non-critical Fault Status n */
    vuint32_t NCFS8:1;                 /* Non-critical Fault Status n */
    vuint32_t NCFS9:1;                 /* Non-critical Fault Status n */
    vuint32_t NCFS10:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS11:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS12:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS13:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS14:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS15:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS16:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS17:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS18:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS19:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS20:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS21:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS22:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS23:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS24:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS25:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS26:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS27:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS28:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS29:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS30:1;                /* Non-critical Fault Status n */
    vuint32_t NCFS31:1;                /* Non-critical Fault Status n */
  } B;
} FCCU_NCF_S_tag;

typedef union FCCU_NCFK_union_tag {    /* Non-critical Fault Key */
  vuint32_t R;
  struct {
    vuint32_t NCFK:32;                 /* Non-critical Fault Key */
  } B;
} FCCU_NCFK_tag;

typedef union FCCU_NCF_E_union_tag {   /* Non-critical Fault Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFE0:1;                 /* Non-critical Fault Enable n */
    vuint32_t NCFE1:1;                 /* Non-critical Fault Enable n */
    vuint32_t NCFE2:1;                 /* Non-critical Fault Enable n */
    vuint32_t NCFE3:1;                 /* Non-critical Fault Enable n */
    vuint32_t NCFE4:1;                 /* Non-critical Fault Enable n */
    vuint32_t NCFE5:1;                 /* Non-critical Fault Enable n */
    vuint32_t NCFE6:1;                 /* Non-critical Fault Enable n */
    vuint32_t NCFE7:1;                 /* Non-critical Fault Enable n */
    vuint32_t NCFE8:1;                 /* Non-critical Fault Enable n */
    vuint32_t NCFE9:1;                 /* Non-critical Fault Enable n */
    vuint32_t NCFE10:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE11:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE12:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE13:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE14:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE15:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE16:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE17:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE18:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE19:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE20:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE21:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE22:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE23:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE24:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE25:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE26:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE27:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE28:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE29:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE30:1;                /* Non-critical Fault Enable n */
    vuint32_t NCFE31:1;                /* Non-critical Fault Enable n */
  } B;
} FCCU_NCF_E_tag;

typedef union FCCU_NCF_TOE_union_tag { /* Non-critical-Fault Alarm-State Timeout Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFTOE0:1;               /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE1:1;               /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE2:1;               /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE3:1;               /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE4:1;               /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE5:1;               /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE6:1;               /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE7:1;               /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE8:1;               /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE9:1;               /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE10:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE11:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE12:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE13:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE14:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE15:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE16:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE17:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE18:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE19:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE20:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE21:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE22:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE23:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE24:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE25:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE26:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE27:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE28:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE29:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE30:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
    vuint32_t NCFTOE31:1;              /* Non-critical-Fault Alarm-State Timeout Enable n */
  } B;
} FCCU_NCF_TOE_tag;

typedef union FCCU_NCF_TO_union_tag {  /* Non-critical-Fault Alarm-State Timeout Interval */
  vuint32_t R;
  struct {
    vuint32_t TO:32;                   /* Non-critical-Fault Alarm-State Timeout Interval */
  } B;
} FCCU_NCF_TO_tag;

typedef union FCCU_CFG_TO_union_tag {  /* Configuration-State Timeout Interval */
  vuint32_t R;
  struct {
    vuint32_t TO:3;                    /* Configuration-State Timeout Interval */
    vuint32_t _unused_3:29;            /* Reserved */
  } B;
} FCCU_CFG_TO_tag;

typedef union FCCU_EINOUT_union_tag {  /* IO Control */
  vuint32_t R;
  struct {
    vuint32_t EOUT0:1;                 /* EOUT0 */
    vuint32_t EOUT1:1;                 /* EOUT1 */
    vuint32_t _unused_2:2;             /* Reserved */
    vuint32_t EIN0:1;                  /* Error Input 0 */
    vuint32_t EIN1:1;                  /* Error Input 1 */
    vuint32_t _unused_6:26;            /* Reserved */
  } B;
} FCCU_EINOUT_tag;

typedef union FCCU_STAT_union_tag {    /* Status */
  vuint32_t R;
  struct {
    vuint32_t STATUS:3;                /* FCCU State */
    vuint32_t ESTAT:1;                 /* FCCU Faulty Condition */
    vuint32_t PHYSICERRORPIN:2;        /* EOUT Signal States */
    vuint32_t _unused_6:26;            /* Reserved */
  } B;
} FCCU_STAT_tag;

typedef union FCCU_N2AF_STATUS_union_tag { /* Normal-to-Alarm Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t NAFS:8;                  /* Normal-to-Alarm Freeze Status */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} FCCU_N2AF_STATUS_tag;

typedef union FCCU_A2FF_STATUS_union_tag { /* Alarm-to-Fault Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t AFFS:8;                  /* Alarm-to-Fault Freeze Status */
    vuint32_t AF_SRC:2;                /* Alarm-to-Fault Source */
    vuint32_t _unused_10:22;           /* Reserved */
  } B;
} FCCU_A2FF_STATUS_tag;

typedef union FCCU_N2FF_STATUS_union_tag { /* Normal-to-Fault Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t NFFS:8;                  /* Normal-to-Fault Freeze Status */
    vuint32_t NF_SRC:2;                /* Normal-to-Fault Source */
    vuint32_t _unused_10:22;           /* Reserved */
  } B;
} FCCU_N2FF_STATUS_tag;

typedef union FCCU_F2AF_STATUS_union_tag { /* Fault-to-Alarm Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t FAFS:9;                  /* Fault-to-Alarm Freeze Status */
    vuint32_t _unused_9:23;            /* Reserved */
  } B;
} FCCU_F2AF_STATUS_tag;

typedef union FCCU_NCFF_union_tag {    /* Non-critical Fault Fake */
  vuint32_t R;
  struct {
    vuint32_t FNCFC:7;                 /* FNCFC */
    vuint32_t _unused_7:25;            /* Reserved */
  } B;
} FCCU_NCFF_tag;

typedef union FCCU_IRQ_STAT_union_tag { /* IRQ Status */
  vuint32_t R;
  struct {
    vuint32_t CFG_TO_STAT:1;           /* Configuration-State Timeout Status */
    vuint32_t ALRM_STAT:1;             /* Alarm Interrupt Status */
    vuint32_t NMI_STAT:1;              /* NMI Interrupt Status */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t _unused_4:1;             /* Reserved */
    vuint32_t _unused_5:27;            /* Reserved */
  } B;
} FCCU_IRQ_STAT_tag;

typedef union FCCU_IRQ_EN_union_tag {  /* IRQ Enable */
  vuint32_t R;
  struct {
    vuint32_t CFG_TO_IEN:1;            /* Configuration-State Timeout Interrupt Enable */
    vuint32_t _unused_1:2;             /* Reserved */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t _unused_4:28;            /* Reserved */
  } B;
} FCCU_IRQ_EN_tag;

typedef union FCCU_TRANS_LOCK_union_tag { /* Transient Configuration Lock */
  vuint32_t R;
  struct {
    vuint32_t TRANSKEY:9;              /* Transient Configuration Lock */
    vuint32_t _unused_9:23;            /* Reserved */
  } B;
} FCCU_TRANS_LOCK_tag;

typedef union FCCU_PERMNT_LOCK_union_tag { /* Permanent Configuration Lock */
  vuint32_t R;
  struct {
    vuint32_t PERMNTKEY:9;             /* Permanent Configuration Lock */
    vuint32_t _unused_9:23;            /* Reserved */
  } B;
} FCCU_PERMNT_LOCK_tag;

typedef union FCCU_DELTA_T_union_tag { /* Delta T */
  vuint32_t R;
  struct {
    vuint32_t DELTA_T:14;              /* Minimum Fault-Output (EOUT) Timer Interval */
    vuint32_t _unused_14:2;            /* Reserved */
    vuint32_t _unused_16:14;           /* Reserved */
    vuint32_t _unused_30:2;            /* Reserved */
  } B;
} FCCU_DELTA_T_tag;

typedef union FCCU_IRQ_ALARM_EN_union_tag { /* Non-critical Alarm-State Interrupt-Request Enable */
  vuint32_t R;
  struct {
    vuint32_t IRQEN0:1;                /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN1:1;                /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN2:1;                /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN3:1;                /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN4:1;                /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN5:1;                /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN6:1;                /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN7:1;                /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN8:1;                /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN9:1;                /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN10:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN11:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN12:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN13:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN14:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN15:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN16:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN17:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN18:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN19:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN20:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN21:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN22:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN23:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN24:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN25:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN26:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN27:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN28:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN29:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN30:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
    vuint32_t IRQEN31:1;               /* Non-critical Alarm-State Interrupt-Request Enable n */
  } B;
} FCCU_IRQ_ALARM_EN_tag;

typedef union FCCU_NMI_EN_union_tag {  /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable */
  vuint32_t R;
  struct {
    vuint32_t NMIEN0:1;                /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN1:1;                /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN2:1;                /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN3:1;                /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN4:1;                /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN5:1;                /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN6:1;                /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN7:1;                /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN8:1;                /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN9:1;                /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN10:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN11:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN12:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN13:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN14:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN15:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN16:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN17:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN18:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN19:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN20:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN21:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN22:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN23:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN24:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN25:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN26:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN27:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN28:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN29:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN30:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
    vuint32_t NMIEN31:1;               /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable n */
  } B;
} FCCU_NMI_EN_tag;

typedef union FCCU_EOUT_SIG_EN_union_tag { /* Non-critical Fault-State EOUT Signaling Enable */
  vuint32_t R;
  struct {
    vuint32_t EOUTEN0:1;               /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN1:1;               /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN2:1;               /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN3:1;               /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN4:1;               /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN5:1;               /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN6:1;               /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN7:1;               /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN8:1;               /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN9:1;               /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN10:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN11:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN12:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN13:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN14:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN15:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN16:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN17:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN18:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN19:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN20:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN21:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN22:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN23:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN24:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN25:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN26:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN27:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN28:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN29:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN30:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
    vuint32_t EOUTEN31:1;              /* Non-critical Fault-State EOUT Signaling Enable n */
  } B;
} FCCU_EOUT_SIG_EN_tag;

typedef union FCCU_TMR_ALARM_union_tag { /* Alarm-State Timer */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Alarm-State Timer Count */
  } B;
} FCCU_TMR_ALARM_tag;

typedef union FCCU_TMR_CFG_union_tag { /* Configuration-State Timer */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Configuration-State Timer Count */
  } B;
} FCCU_TMR_CFG_tag;

typedef union FCCU_TMR_ETMR_union_tag { /* Fault-Output Timer */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Fault-Output Timer Count */
  } B;
} FCCU_TMR_ETMR_tag;

struct FCCU_tag {
  FCCU_CTRL_tag CTRL;                  /* Control */
  FCCU_CTRLK_tag CTRLK;                /* Control Key */
  FCCU_CFG_tag CFG;                    /* Configuration */
  uint8_t FCCU_reserved0[16];
  FCCU_NCF_CFG_tag NCF_CFG[4];         /* Non-critical Fault Configuration */
  uint8_t FCCU_reserved1[32];
  FCCU_NCFS_CFG_tag NCFS_CFG[8];       /* Non-critical Fault-State Configuration */
  uint8_t FCCU_reserved2[20];
  FCCU_NCF_S_tag NCF_S[4];             /* Non-critical Fault Status */
  FCCU_NCFK_tag NCFK;                  /* Non-critical Fault Key */
  FCCU_NCF_E_tag NCF_E[4];             /* Non-critical Fault Enable */
  FCCU_NCF_TOE_tag NCF_TOE[4];         /* Non-critical-Fault Alarm-State Timeout Enable */
  FCCU_NCF_TO_tag NCF_TO;              /* Non-critical-Fault Alarm-State Timeout Interval */
  FCCU_CFG_TO_tag CFG_TO;              /* Configuration-State Timeout Interval */
  FCCU_EINOUT_tag EINOUT;              /* IO Control */
  FCCU_STAT_tag STAT;                  /* Status */
  FCCU_N2AF_STATUS_tag N2AF_STATUS;    /* Normal-to-Alarm Freeze Status */
  FCCU_A2FF_STATUS_tag A2FF_STATUS;    /* Alarm-to-Fault Freeze Status */
  FCCU_N2FF_STATUS_tag N2FF_STATUS;    /* Normal-to-Fault Freeze Status */
  FCCU_F2AF_STATUS_tag F2AF_STATUS;    /* Fault-to-Alarm Freeze Status */
  uint8_t FCCU_reserved3[8];
  FCCU_NCFF_tag NCFF;                  /* Non-critical Fault Fake */
  FCCU_IRQ_STAT_tag IRQ_STAT;          /* IRQ Status */
  FCCU_IRQ_EN_tag IRQ_EN;              /* IRQ Enable */
  uint8_t FCCU_reserved4[8];
  FCCU_TRANS_LOCK_tag TRANS_LOCK;      /* Transient Configuration Lock */
  FCCU_PERMNT_LOCK_tag PERMNT_LOCK;    /* Permanent Configuration Lock */
  FCCU_DELTA_T_tag DELTA_T;            /* Delta T */
  FCCU_IRQ_ALARM_EN_tag IRQ_ALARM_EN[4]; /* Non-critical Alarm-State Interrupt-Request Enable */
  FCCU_NMI_EN_tag NMI_EN[4];           /* Non-critical Fault-State Non-maskable-Interrupt-Request Enable */
  FCCU_EOUT_SIG_EN_tag EOUT_SIG_EN[4]; /* Non-critical Fault-State EOUT Signaling Enable */
  FCCU_TMR_ALARM_tag TMR_ALARM;        /* Alarm-State Timer */
  uint8_t FCCU_reserved5[4];
  FCCU_TMR_CFG_tag TMR_CFG;            /* Configuration-State Timer */
  FCCU_TMR_ETMR_tag TMR_ETMR;          /* Fault-Output Timer */
};


/* ============================================================================
   =============================== Module: FLEXCAN_0_3 ========================
   ============================================================================ */

typedef union FLEXCAN_0_3_MCR_union_tag { /* Module Configuration register */
  vuint32_t R;
  struct {
    vuint32_t MAXMB:7;                 /* Number Of The Last Message Buffer */
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t IDAM:2;                  /* ID Acceptance Mode */
    vuint32_t _unused_10:1;            /* Reserved */
    vuint32_t FDEN:1;                  /* CAN FD operation enable */
    vuint32_t AEN:1;                   /* Abort Enable */
    vuint32_t LPRIOEN:1;               /* Local Priority Enable */
    vuint32_t _unused_14:1;            /* Reserved */
    vuint32_t DMA:1;                   /* DMA Enable */
    vuint32_t IRMQ:1;                  /* Individual Rx Masking And Queue Enable */
    vuint32_t SRXDIS:1;                /* Self Reception Disable */
    vuint32_t _unused_18:1;            /* Reserved */
    vuint32_t _unused_19:1;            /* Reserved */
    vuint32_t LPMACK:1;                /* Low-Power Mode Acknowledge */
    vuint32_t WRNEN:1;                 /* Warning Interrupt Enable */
    vuint32_t _unused_22:1;            /* Reserved */
    vuint32_t _unused_23:1;            /* Reserved */
    vuint32_t FRZACK:1;                /* Freeze Mode Acknowledge */
    vuint32_t SOFTRST:1;               /* Soft Reset */
    vuint32_t _unused_26:1;            /* Reserved */
    vuint32_t NOTRDY:1;                /* FlexCAN Not Ready */
    vuint32_t HALT:1;                  /* Halt FlexCAN */
    vuint32_t RFEN:1;                  /* Legacy Rx FIFO Enable */
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t MDIS:1;                  /* Module Disable */
  } B;
} FLEXCAN_0_3_MCR_tag;

typedef union FLEXCAN_0_3_CTRL1_union_tag { /* Control 1 register */
  vuint32_t R;
  struct {
    vuint32_t PROPSEG:3;               /* Propagation Segment */
    vuint32_t LOM:1;                   /* Listen-Only Mode */
    vuint32_t LBUF:1;                  /* Lowest Buffer Transmitted First */
    vuint32_t TSYN:1;                  /* Timer Sync */
    vuint32_t BOFFREC:1;               /* Bus Off Recovery */
    vuint32_t SMP:1;                   /* CAN Bit Sampling */
    vuint32_t _unused_8:1;             /* Reserved */
    vuint32_t _unused_9:1;             /* Reserved */
    vuint32_t RWRNMSK:1;               /* Rx Warning Interrupt Mask */
    vuint32_t TWRNMSK:1;               /* Tx Warning Interrupt Mask */
    vuint32_t LPB:1;                   /* Loop Back Mode */
    vuint32_t _unused_13:1;            /* Reserved */
    vuint32_t ERRMSK:1;                /* Error Interrupt Mask */
    vuint32_t BOFFMSK:1;               /* Bus Off Interrupt Mask */
    vuint32_t PSEG2:3;                 /* Phase Segment 2 */
    vuint32_t PSEG1:3;                 /* Phase Segment 1 */
    vuint32_t RJW:2;                   /* Resync Jump Width */
    vuint32_t PRESDIV:8;               /* Prescaler Division Factor */
  } B;
} FLEXCAN_0_3_CTRL1_tag;

typedef union FLEXCAN_0_3_TIMER_union_tag { /* Free Running Timer */
  vuint32_t R;
  struct {
    vuint32_t TIMER:16;                /* Timer Value */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} FLEXCAN_0_3_TIMER_tag;

typedef union FLEXCAN_0_3_RXMGMASK_union_tag { /* Rx Mailboxes Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t MG:32;                   /* Rx Mailboxes Global Mask Bits */
  } B;
} FLEXCAN_0_3_RXMGMASK_tag;

typedef union FLEXCAN_0_3_RX14MASK_union_tag { /* Rx 14 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX14M:32;                /* Rx Buffer 14 Mask Bits */
  } B;
} FLEXCAN_0_3_RX14MASK_tag;

typedef union FLEXCAN_0_3_RX15MASK_union_tag { /* Rx 15 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX15M:32;                /* Rx Buffer 15 Mask Bits */
  } B;
} FLEXCAN_0_3_RX15MASK_tag;

typedef union FLEXCAN_0_3_ECR_union_tag { /* Error Counter */
  vuint32_t R;
  struct {
    vuint32_t TXERRCNT:8;              /* Transmit Error Counter */
    vuint32_t RXERRCNT:8;              /* Receive Error Counter */
    vuint32_t TXERRCNT_FAST:8;         /* Transmit Error Counter for fast bits */
    vuint32_t RXERRCNT_FAST:8;         /* Receive Error Counter for fast bits */
  } B;
} FLEXCAN_0_3_ECR_tag;

typedef union FLEXCAN_0_3_ESR1_union_tag { /* Error and Status 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;             /* Reserved */
    vuint32_t ERRINT:1;                /* Error Interrupt */
    vuint32_t BOFFINT:1;               /* Bus Off Interrupt */
    vuint32_t RX:1;                    /* FlexCAN In Reception */
    vuint32_t FLTCONF:2;               /* Fault Confinement State */
    vuint32_t TX:1;                    /* FlexCAN In Transmission */
    vuint32_t IDLE:1;                  /* IDLE */
    vuint32_t RXWRN:1;                 /* Rx Error Warning */
    vuint32_t TXWRN:1;                 /* TX Error Warning */
    vuint32_t STFERR:1;                /* Stuffing Error */
    vuint32_t FRMERR:1;                /* Form Error */
    vuint32_t CRCERR:1;                /* Cyclic Redundancy Check Error */
    vuint32_t ACKERR:1;                /* Acknowledge Error */
    vuint32_t BIT0ERR:1;               /* Bit0 Error */
    vuint32_t BIT1ERR:1;               /* Bit1 Error */
    vuint32_t RWRNINT:1;               /* Rx Warning Interrupt Flag */
    vuint32_t TWRNINT:1;               /* Tx Warning Interrupt Flag */
    vuint32_t SYNCH:1;                 /* CAN Synchronization Status */
    vuint32_t BOFFDONEINT:1;           /* Bus Off Done Interrupt */
    vuint32_t ERRINT_FAST:1;           /* Error interrupt for errors detected in Data Phase of CAN FD frames with BRS bit set */
    vuint32_t ERROVR:1;                /* Error Overrun */
    vuint32_t _unused_22:4;            /* Reserved */
    vuint32_t STFERR_FAST:1;           /* Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t FRMERR_FAST:1;           /* Form Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t CRCERR_FAST:1;           /* Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set */
    vuint32_t _unused_29:1;            /* Reserved */
    vuint32_t BIT0ERR_FAST:1;          /* Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BIT1ERR_FAST:1;          /* Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set */
  } B;
} FLEXCAN_0_3_ESR1_tag;

typedef union FLEXCAN_0_3_IMASK2_union_tag { /* Interrupt Masks 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32M:32;           /* Buffer MB i Mask */
  } B;
} FLEXCAN_0_3_IMASK2_tag;

typedef union FLEXCAN_0_3_IMASK1_union_tag { /* Interrupt Masks 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO0M:32;            /* Buffer MB i Mask */
  } B;
} FLEXCAN_0_3_IMASK1_tag;

typedef union FLEXCAN_0_3_IFLAG2_union_tag { /* Interrupt Flags 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32I:32;           /* Buffer MB i Interrupt */
  } B;
} FLEXCAN_0_3_IFLAG2_tag;

typedef union FLEXCAN_0_3_IFLAG1_union_tag { /* Interrupt Flags 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF0I:1;                 /* Buffer MB0 Interrupt Or Clear Legacy FIFO bit */
    vuint32_t BUF4TO1I:4;              /* Buffer MB i Interrupt Or Reserved */
    vuint32_t BUF5I:1;                 /* Buffer MB5 Interrupt Or Frames available in Legacy Rx FIFO */
    vuint32_t BUF6I:1;                 /* Buffer MB6 Interrupt Or Legacy Rx FIFO Warning */
    vuint32_t BUF7I:1;                 /* Buffer MB7 Interrupt Or Legacy Rx FIFO Overflow */
    vuint32_t BUF31TO8I:24;            /* Buffer MBi Interrupt */
  } B;
} FLEXCAN_0_3_IFLAG1_tag;

typedef union FLEXCAN_0_3_CTRL2_union_tag { /* Control 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:6;             /* Reserved */
    vuint32_t TSTAMPCAP:2;             /* Time Stamp Capture Point */
    vuint32_t MBTSBASE:2;              /* Message Buffer Time Stamp Base */
    vuint32_t _unused_10:1;            /* Reserved */
    vuint32_t EDFLTDIS:1;              /* Edge Filter Disable */
    vuint32_t ISOCANFDEN:1;            /* ISO CAN FD Enable */
    vuint32_t _unused_13:1;            /* Reserved */
    vuint32_t PREXCEN:1;               /* Protocol Exception Enable */
    vuint32_t TIMER_SRC:1;             /* Timer Source */
    vuint32_t EACEN:1;                 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
    vuint32_t RRS:1;                   /* Remote Request Storing */
    vuint32_t MRP:1;                   /* Mailboxes Reception Priority */
    vuint32_t TASD:5;                  /* Tx Arbitration Start Delay */
    vuint32_t RFFN:4;                  /* Number Of Legacy Rx FIFO Filters */
    vuint32_t WRMFRZ:1;                /* Write-Access To Memory In Freeze Mode */
    vuint32_t ECRWRE:1;                /* Error-correction Configuration Register Write Enable */
    vuint32_t BOFFDONEMSK:1;           /* Bus Off Done Interrupt Mask */
    vuint32_t ERRMSK_FAST:1;           /* Error Interrupt Mask for errors detected in the data phase of fast CAN FD frames */
  } B;
} FLEXCAN_0_3_CTRL2_tag;

typedef union FLEXCAN_0_3_ESR2_union_tag { /* Error and Status 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:13;            /* Reserved */
    vuint32_t IMB:1;                   /* Inactive Mailbox */
    vuint32_t VPS:1;                   /* Valid Priority Status */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t LPTM:7;                  /* Lowest Priority Tx Mailbox */
    vuint32_t _unused_23:9;            /* Reserved */
  } B;
} FLEXCAN_0_3_ESR2_tag;

typedef union FLEXCAN_0_3_CRCR_union_tag { /* CRC register */
  vuint32_t R;
  struct {
    vuint32_t TXCRC:15;                /* Transmitted CRC value */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t MBCRC:7;                 /* CRC Mailbox */
    vuint32_t _unused_23:9;            /* Reserved */
  } B;
} FLEXCAN_0_3_CRCR_tag;

typedef union FLEXCAN_0_3_RXFGMASK_union_tag { /* Legacy Rx FIFO Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t FGM:32;                  /* Legacy Rx FIFO Global Mask Bits */
  } B;
} FLEXCAN_0_3_RXFGMASK_tag;

typedef union FLEXCAN_0_3_RXFIR_union_tag { /* Legacy Rx FIFO Information register */
  vuint32_t R;
  struct {
    vuint32_t IDHIT:9;                 /* Identifier Acceptance Filter Hit Indicator */
    vuint32_t _unused_9:23;            /* Reserved */
  } B;
} FLEXCAN_0_3_RXFIR_tag;

typedef union FLEXCAN_0_3_CBT_union_tag { /* CAN Bit Timing register */
  vuint32_t R;
  struct {
    vuint32_t EPSEG2:5;                /* Extended Phase Segment 2 */
    vuint32_t EPSEG1:5;                /* Extended Phase Segment 1 */
    vuint32_t EPROPSEG:6;              /* Extended Propagation Segment */
    vuint32_t ERJW:5;                  /* Extended Resync Jump Width */
    vuint32_t EPRESDIV:10;             /* Extended Prescaler Division Factor */
    vuint32_t BTF:1;                   /* Bit Timing Format Enable */
  } B;
} FLEXCAN_0_3_CBT_tag;

typedef union FLEXCAN_0_3_IMASK4_union_tag { /* Interrupt Masks 4 register */
  vuint32_t R;
  struct {
    vuint32_t BUF127TO96M:32;          /* Buffer MB i Mask */
  } B;
} FLEXCAN_0_3_IMASK4_tag;

typedef union FLEXCAN_0_3_IMASK3_union_tag { /* Interrupt Masks 3 register */
  vuint32_t R;
  struct {
    vuint32_t BUF95TO64M:32;           /* Buffer MB i Mask */
  } B;
} FLEXCAN_0_3_IMASK3_tag;

typedef union FLEXCAN_0_3_IFLAG4_union_tag { /* Interrupt Flags 4 register */
  vuint32_t R;
  struct {
    vuint32_t BUF127TO96:32;           /* Buffer MB i Interrupt */
  } B;
} FLEXCAN_0_3_IFLAG4_tag;

typedef union FLEXCAN_0_3_IFLAG3_union_tag { /* Interrupt Flags 3 register */
  vuint32_t R;
  struct {
    vuint32_t BUF95TO64:32;            /* Buffer MB i Interrupt */
  } B;
} FLEXCAN_0_3_IFLAG3_tag;

typedef union FLEXCAN_0_3_RXIMR_union_tag { /* Rx Individual Mask registers */
  vuint32_t R;
  struct {
    vuint32_t MI:32;                   /* Individual Mask Bits */
  } B;
} FLEXCAN_0_3_RXIMR_tag;

typedef union FLEXCAN_0_3_MECR_union_tag { /* Memory Error Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:7;             /* Reserved */
    vuint32_t NCEFAFRZ:1;              /* Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode */
    vuint32_t ECCDIS:1;                /* Error Correction Disable */
    vuint32_t RERRDIS:1;               /* Error Report Disable */
    vuint32_t _unused_10:3;            /* Reserved */
    vuint32_t EXTERRIE:1;              /* Extended Error Injection Enable */
    vuint32_t FAERRIE:1;               /* FlexCAN Access Error Injection Enable */
    vuint32_t HAERRIE:1;               /* Host Access Error Injection Enable */
    vuint32_t CEI_MSK:1;               /* Correctable Errors Interrupt Mask */
    vuint32_t _unused_17:1;            /* Reserved */
    vuint32_t FANCEI_MSK:1;            /* FlexCAN Access With Non-Correctable Errors Interrupt Mask */
    vuint32_t HANCEI_MSK:1;            /* Host Access With Non-Correctable Errors Interrupt Mask */
    vuint32_t _unused_20:11;           /* Reserved */
    vuint32_t ECRWRDIS:1;              /* Error Configuration Register Write Disable */
  } B;
} FLEXCAN_0_3_MECR_tag;

typedef union FLEXCAN_0_3_ERRIAR_union_tag { /* Error Injection Address register */
  vuint32_t R;
  struct {
    vuint32_t INJADDR_L:2;             /* Error Injection Address Low */
    vuint32_t INJADDR_H:12;            /* Error Injection Address High */
    vuint32_t _unused_14:18;           /* Reserved */
  } B;
} FLEXCAN_0_3_ERRIAR_tag;

typedef union FLEXCAN_0_3_ERRIDPR_union_tag { /* Error Injection Data Pattern register */
  vuint32_t R;
  struct {
    vuint32_t DFLIP:32;                /* Data flip pattern */
  } B;
} FLEXCAN_0_3_ERRIDPR_tag;

typedef union FLEXCAN_0_3_ERRIPPR_union_tag { /* Error Injection Parity Pattern register */
  vuint32_t R;
  struct {
    vuint32_t PFLIP0:5;                /* Parity Flip Pattern For Byte 0 (Least Significant) */
    vuint32_t _unused_5:3;             /* Reserved */
    vuint32_t PFLIP1:5;                /* Parity Flip Pattern For Byte 1 */
    vuint32_t _unused_13:3;            /* Reserved */
    vuint32_t PFLIP2:5;                /* Parity Flip Pattern For Byte 2 */
    vuint32_t _unused_21:3;            /* Reserved */
    vuint32_t PFLIP3:5;                /* Parity Flip Pattern For Byte 3 (most significant) */
    vuint32_t _unused_29:3;            /* Reserved */
  } B;
} FLEXCAN_0_3_ERRIPPR_tag;

typedef union FLEXCAN_0_3_RERRAR_union_tag { /* Error Report Address register */
  vuint32_t R;
  struct {
    vuint32_t ERRADDR:14;              /* Address Where Error Detected */
    vuint32_t _unused_14:2;            /* Reserved */
    vuint32_t SAID:3;                  /* SAID */
    vuint32_t _unused_19:5;            /* Reserved */
    vuint32_t NCE:1;                   /* Non-Correctable Error */
    vuint32_t _unused_25:7;            /* Reserved */
  } B;
} FLEXCAN_0_3_RERRAR_tag;

typedef union FLEXCAN_0_3_RERRDR_union_tag { /* Error Report Data register */
  vuint32_t R;
  struct {
    vuint32_t RDATA:32;                /* Raw data word read from memory with error */
  } B;
} FLEXCAN_0_3_RERRDR_tag;

typedef union FLEXCAN_0_3_RERRSYNR_union_tag { /* Error Report Syndrome register */
  vuint32_t R;
  struct {
    vuint32_t SYND0:5;                 /* Error Syndrome For Byte 0 (least significant) */
    vuint32_t _unused_5:2;             /* Reserved */
    vuint32_t BE0:1;                   /* Byte Enabled For Byte 0 (least significant) */
    vuint32_t SYND1:5;                 /* Error Syndrome for Byte 1 */
    vuint32_t _unused_13:2;            /* Reserved */
    vuint32_t BE1:1;                   /* Byte Enabled For Byte 1 */
    vuint32_t SYND2:5;                 /* Error Syndrome For Byte 2 */
    vuint32_t _unused_21:2;            /* Reserved */
    vuint32_t BE2:1;                   /* Byte Enabled For Byte 2 */
    vuint32_t SYND3:5;                 /* Error Syndrome For Byte 3 (most significant) */
    vuint32_t _unused_29:2;            /* Reserved */
    vuint32_t BE3:1;                   /* Byte Enabled For Byte 3 (most significant) */
  } B;
} FLEXCAN_0_3_RERRSYNR_tag;

typedef union FLEXCAN_0_3_ERRSR_union_tag { /* Error Status register */
  vuint32_t R;
  struct {
    vuint32_t CEIOF:1;                 /* Correctable Error Interrupt Overrun Flag */
    vuint32_t _unused_1:1;             /* Reserved */
    vuint32_t FANCEIOF:1;              /* FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t HANCEIOF:1;              /* Host Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t _unused_4:12;            /* Reserved */
    vuint32_t CEIF:1;                  /* Correctable Error Interrupt Flag */
    vuint32_t _unused_17:1;            /* Reserved */
    vuint32_t FANCEIF:1;               /* FlexCAN Access With Non-Correctable Error Interrupt Flag */
    vuint32_t HANCEIF:1;               /* Host Access With Non-Correctable Error Interrupt Flag */
    vuint32_t _unused_20:12;           /* Reserved */
  } B;
} FLEXCAN_0_3_ERRSR_tag;

typedef union FLEXCAN_0_3_FDCTRL_union_tag { /* CAN FD Control register */
  vuint32_t R;
  struct {
    vuint32_t TDCVAL:6;                /* Transceiver Delay Compensation Value */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t TDCOFF:5;                /* Transceiver Delay Compensation Offset */
    vuint32_t _unused_13:1;            /* Reserved */
    vuint32_t TDCFAIL:1;               /* Transceiver Delay Compensation Fail */
    vuint32_t TDCEN:1;                 /* Transceiver Delay Compensation Enable */
    vuint32_t MBDSR0:2;                /* Message Buffer Data Size for Region 0 */
    vuint32_t _unused_18:1;            /* Reserved */
    vuint32_t MBDSR1:2;                /* Message Buffer Data Size for Region 1 */
    vuint32_t _unused_21:1;            /* Reserved */
    vuint32_t MBDSR2:2;                /* Message Buffer Data Size for Region 2 */
    vuint32_t _unused_24:1;            /* Reserved */
    vuint32_t MBDSR3:2;                /* Message Buffer Data Size for Region 3 */
    vuint32_t _unused_27:4;            /* Reserved */
    vuint32_t FDRATE:1;                /* Bit Rate Switch Enable */
  } B;
} FLEXCAN_0_3_FDCTRL_tag;

typedef union FLEXCAN_0_3_FDCBT_union_tag { /* CAN FD Bit Timing register */
  vuint32_t R;
  struct {
    vuint32_t FPSEG2:3;                /* Fast Phase Segment 2 */
    vuint32_t _unused_3:2;             /* Reserved */
    vuint32_t FPSEG1:3;                /* Fast Phase Segment 1 */
    vuint32_t _unused_8:2;             /* Reserved */
    vuint32_t FPROPSEG:5;              /* Fast Propagation Segment */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t FRJW:3;                  /* Fast Resync Jump Width */
    vuint32_t _unused_19:1;            /* Reserved */
    vuint32_t FPRESDIV:10;             /* Fast Prescaler Division Factor */
    vuint32_t _unused_30:2;            /* Reserved */
  } B;
} FLEXCAN_0_3_FDCBT_tag;

typedef union FLEXCAN_0_3_FDCRC_union_tag { /* CAN FD CRC register */
  vuint32_t R;
  struct {
    vuint32_t FD_TXCRC:21;             /* Extended Transmitted CRC value */
    vuint32_t _unused_21:3;            /* Reserved */
    vuint32_t FD_MBCRC:7;              /* CRC Mailbox Number for FD_TXCRC */
    vuint32_t _unused_31:1;            /* Reserved */
  } B;
} FLEXCAN_0_3_FDCRC_tag;

typedef union FLEXCAN_0_3_ERFCR_union_tag { /* Enhanced Rx FIFO Control register */
  vuint32_t R;
  struct {
    vuint32_t ERFWM:5;                 /* Enhanced Rx FIFO Watermark */
    vuint32_t _unused_5:3;             /* Reserved. */
    vuint32_t NFE:6;                   /* Number of Enhanced Rx FIFO Filter Elements */
    vuint32_t _unused_14:2;            /* Reserved. */
    vuint32_t NEXIF:7;                 /* Number of Extended ID Filter Elements */
    vuint32_t _unused_23:3;            /* Reserved. */
    vuint32_t DMALW:5;                 /* DMA Last Word */
    vuint32_t ERFEN:1;                 /* Enhanced Rx FIFO enable */
  } B;
} FLEXCAN_0_3_ERFCR_tag;

typedef union FLEXCAN_0_3_ERFIER_union_tag { /* Enhanced Rx FIFO Interrupt Enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:28;            /* Reserved */
    vuint32_t ERFDAIE:1;               /* Enhanced Rx FIFO Data Available Interrupt Enable */
    vuint32_t ERFWMIIE:1;              /* Enhanced Rx FIFO Watermark Indication Interrupt Enable */
    vuint32_t ERFOVFIE:1;              /* Enhanced Rx FIFO Overflow Interrupt Enable */
    vuint32_t ERFUFWIE:1;              /* Enhanced Rx FIFO Underflow Interrupt Enable */
  } B;
} FLEXCAN_0_3_ERFIER_tag;

typedef union FLEXCAN_0_3_ERFSR_union_tag { /* Enhanced Rx FIFO Status register */
  vuint32_t R;
  struct {
    vuint32_t ERFEL:6;                 /* Enhanced Rx FIFO Elements */
    vuint32_t _unused_6:10;            /* Reserved */
    vuint32_t ERFF:1;                  /* Enhanced Rx FIFO full */
    vuint32_t ERFE:1;                  /* Enhanced Rx FIFO empty */
    vuint32_t _unused_18:9;            /* Reserved */
    vuint32_t ERFCLR:1;                /* Enhanced Rx FIFO Clear */
    vuint32_t ERFDA:1;                 /* Enhanced Rx FIFO Data Available */
    vuint32_t ERFWMI:1;                /* Enhanced Rx FIFO Watermark Indication */
    vuint32_t ERFOVF:1;                /* Enhanced Rx FIFO Overflow */
    vuint32_t ERFUFW:1;                /* Enhanced Rx FIFO Underflow */
  } B;
} FLEXCAN_0_3_ERFSR_tag;

typedef union FLEXCAN_0_3_HR_TIME_STAMP_union_tag { /* High Resolution Time Stamp */
  vuint32_t R;
  struct {
    vuint32_t TS:32;                   /* High Resolution Time Stamp */
  } B;
} FLEXCAN_0_3_HR_TIME_STAMP_tag;

typedef union FLEXCAN_0_3_ERFFEL_union_tag { /* Enhanced Rx FIFO Filter Element */
  vuint32_t R;
  struct {
    vuint32_t FEL:32;                  /* Filter Element Bits */
  } B;
} FLEXCAN_0_3_ERFFEL_tag;

struct FLEXCAN_0_3_tag {
  FLEXCAN_0_3_MCR_tag MCR;             /* Module Configuration register */
  FLEXCAN_0_3_CTRL1_tag CTRL1;         /* Control 1 register */
  FLEXCAN_0_3_TIMER_tag TIMER;         /* Free Running Timer */
  uint8_t FLEXCAN_0_3_reserved0[4];
  FLEXCAN_0_3_RXMGMASK_tag RXMGMASK;   /* Rx Mailboxes Global Mask register */
  FLEXCAN_0_3_RX14MASK_tag RX14MASK;   /* Rx 14 Mask register */
  FLEXCAN_0_3_RX15MASK_tag RX15MASK;   /* Rx 15 Mask register */
  FLEXCAN_0_3_ECR_tag ECR;             /* Error Counter */
  FLEXCAN_0_3_ESR1_tag ESR1;           /* Error and Status 1 register */
  FLEXCAN_0_3_IMASK2_tag IMASK2;       /* Interrupt Masks 2 register */
  FLEXCAN_0_3_IMASK1_tag IMASK1;       /* Interrupt Masks 1 register */
  FLEXCAN_0_3_IFLAG2_tag IFLAG2;       /* Interrupt Flags 2 register */
  FLEXCAN_0_3_IFLAG1_tag IFLAG1;       /* Interrupt Flags 1 register */
  FLEXCAN_0_3_CTRL2_tag CTRL2;         /* Control 2 register */
  FLEXCAN_0_3_ESR2_tag ESR2;           /* Error and Status 2 register */
  uint8_t FLEXCAN_0_3_reserved1[8];
  FLEXCAN_0_3_CRCR_tag CRCR;           /* CRC register */
  FLEXCAN_0_3_RXFGMASK_tag RXFGMASK;   /* Legacy Rx FIFO Global Mask register */
  FLEXCAN_0_3_RXFIR_tag RXFIR;         /* Legacy Rx FIFO Information register */
  FLEXCAN_0_3_CBT_tag CBT;             /* CAN Bit Timing register */
  uint8_t FLEXCAN_0_3_reserved2[20];
  FLEXCAN_0_3_IMASK4_tag IMASK4;       /* Interrupt Masks 4 register */
  FLEXCAN_0_3_IMASK3_tag IMASK3;       /* Interrupt Masks 3 register */
  FLEXCAN_0_3_IFLAG4_tag IFLAG4;       /* Interrupt Flags 4 register */
  FLEXCAN_0_3_IFLAG3_tag IFLAG3;       /* Interrupt Flags 3 register */
  uint8_t FLEXCAN_0_3_reserved3[2056];
  FLEXCAN_0_3_RXIMR_tag RXIMR[128];    /* Rx Individual Mask registers */
  uint8_t FLEXCAN_0_3_reserved4[96];
  FLEXCAN_0_3_MECR_tag MECR;           /* Memory Error Control register */
  FLEXCAN_0_3_ERRIAR_tag ERRIAR;       /* Error Injection Address register */
  FLEXCAN_0_3_ERRIDPR_tag ERRIDPR;     /* Error Injection Data Pattern register */
  FLEXCAN_0_3_ERRIPPR_tag ERRIPPR;     /* Error Injection Parity Pattern register */
  FLEXCAN_0_3_RERRAR_tag RERRAR;       /* Error Report Address register */
  FLEXCAN_0_3_RERRDR_tag RERRDR;       /* Error Report Data register */
  FLEXCAN_0_3_RERRSYNR_tag RERRSYNR;   /* Error Report Syndrome register */
  FLEXCAN_0_3_ERRSR_tag ERRSR;         /* Error Status register */
  uint8_t FLEXCAN_0_3_reserved5[256];
  FLEXCAN_0_3_FDCTRL_tag FDCTRL;       /* CAN FD Control register */
  FLEXCAN_0_3_FDCBT_tag FDCBT;         /* CAN FD Bit Timing register */
  FLEXCAN_0_3_FDCRC_tag FDCRC;         /* CAN FD CRC register */
  FLEXCAN_0_3_ERFCR_tag ERFCR;         /* Enhanced Rx FIFO Control register */
  FLEXCAN_0_3_ERFIER_tag ERFIER;       /* Enhanced Rx FIFO Interrupt Enable register */
  FLEXCAN_0_3_ERFSR_tag ERFSR;         /* Enhanced Rx FIFO Status register */
  uint8_t FLEXCAN_0_3_reserved6[24];
  FLEXCAN_0_3_HR_TIME_STAMP_tag HR_TIME_STAMP[128]; /* High Resolution Time Stamp */
  uint8_t FLEXCAN_0_3_reserved7[8656];
  FLEXCAN_0_3_ERFFEL_tag ERFFEL[128];  /* Enhanced Rx FIFO Filter Element */
};


/* ============================================================================
   =============================== Module: FLEXCAN_4_7 ========================
   ============================================================================ */

typedef union FLEXCAN_4_7_MCR_union_tag { /* Module Configuration register */
  vuint32_t R;
  struct {
    vuint32_t MAXMB:7;                 /* Number Of The Last Message Buffer */
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t IDAM:2;                  /* ID Acceptance Mode */
    vuint32_t _unused_10:1;            /* Reserved */
    vuint32_t FDEN:1;                  /* CAN FD operation enable */
    vuint32_t AEN:1;                   /* Abort Enable */
    vuint32_t LPRIOEN:1;               /* Local Priority Enable */
    vuint32_t _unused_14:1;            /* Reserved */
    vuint32_t DMA:1;                   /* DMA Enable */
    vuint32_t IRMQ:1;                  /* Individual Rx Masking And Queue Enable */
    vuint32_t SRXDIS:1;                /* Self Reception Disable */
    vuint32_t _unused_18:1;            /* Reserved */
    vuint32_t _unused_19:1;            /* Reserved */
    vuint32_t LPMACK:1;                /* Low-Power Mode Acknowledge */
    vuint32_t WRNEN:1;                 /* Warning Interrupt Enable */
    vuint32_t _unused_22:1;            /* Reserved */
    vuint32_t _unused_23:1;            /* Reserved */
    vuint32_t FRZACK:1;                /* Freeze Mode Acknowledge */
    vuint32_t SOFTRST:1;               /* Soft Reset */
    vuint32_t _unused_26:1;            /* Reserved */
    vuint32_t NOTRDY:1;                /* FlexCAN Not Ready */
    vuint32_t HALT:1;                  /* Halt FlexCAN */
    vuint32_t RFEN:1;                  /* Rx FIFO Enable */
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t MDIS:1;                  /* Module Disable */
  } B;
} FLEXCAN_4_7_MCR_tag;

typedef union FLEXCAN_4_7_CTRL1_union_tag { /* Control 1 register */
  vuint32_t R;
  struct {
    vuint32_t PROPSEG:3;               /* Propagation Segment */
    vuint32_t LOM:1;                   /* Listen-Only Mode */
    vuint32_t LBUF:1;                  /* Lowest Buffer Transmitted First */
    vuint32_t TSYN:1;                  /* Timer Sync */
    vuint32_t BOFFREC:1;               /* Bus Off Recovery */
    vuint32_t SMP:1;                   /* CAN Bit Sampling */
    vuint32_t _unused_8:1;             /* Reserved */
    vuint32_t _unused_9:1;             /* Reserved */
    vuint32_t RWRNMSK:1;               /* Rx Warning Interrupt Mask */
    vuint32_t TWRNMSK:1;               /* Tx Warning Interrupt Mask */
    vuint32_t LPB:1;                   /* Loop Back Mode */
    vuint32_t _unused_13:1;            /* Reserved */
    vuint32_t ERRMSK:1;                /* Error Interrupt Mask */
    vuint32_t BOFFMSK:1;               /* Bus Off Interrupt Mask */
    vuint32_t PSEG2:3;                 /* Phase Segment 2 */
    vuint32_t PSEG1:3;                 /* Phase Segment 1 */
    vuint32_t RJW:2;                   /* Resync Jump Width */
    vuint32_t PRESDIV:8;               /* Prescaler Division Factor */
  } B;
} FLEXCAN_4_7_CTRL1_tag;

typedef union FLEXCAN_4_7_TIMER_union_tag { /* Free Running Timer */
  vuint32_t R;
  struct {
    vuint32_t TIMER:16;                /* Timer Value */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} FLEXCAN_4_7_TIMER_tag;

typedef union FLEXCAN_4_7_RXMGMASK_union_tag { /* Rx Mailboxes Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t MG:32;                   /* Rx Mailboxes Global Mask Bits */
  } B;
} FLEXCAN_4_7_RXMGMASK_tag;

typedef union FLEXCAN_4_7_RX14MASK_union_tag { /* Rx 14 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX14M:32;                /* Rx Buffer 14 Mask Bits */
  } B;
} FLEXCAN_4_7_RX14MASK_tag;

typedef union FLEXCAN_4_7_RX15MASK_union_tag { /* Rx 15 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX15M:32;                /* Rx Buffer 15 Mask Bits */
  } B;
} FLEXCAN_4_7_RX15MASK_tag;

typedef union FLEXCAN_4_7_ECR_union_tag { /* Error Counter */
  vuint32_t R;
  struct {
    vuint32_t TXERRCNT:8;              /* Transmit Error Counter */
    vuint32_t RXERRCNT:8;              /* Receive Error Counter */
    vuint32_t TXERRCNT_FAST:8;         /* Transmit Error Counter for fast bits */
    vuint32_t RXERRCNT_FAST:8;         /* Receive Error Counter for fast bits */
  } B;
} FLEXCAN_4_7_ECR_tag;

typedef union FLEXCAN_4_7_ESR1_union_tag { /* Error and Status 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;             /* Reserved */
    vuint32_t ERRINT:1;                /* Error Interrupt */
    vuint32_t BOFFINT:1;               /* Bus Off Interrupt */
    vuint32_t RX:1;                    /* FlexCAN In Reception */
    vuint32_t FLTCONF:2;               /* Fault Confinement State */
    vuint32_t TX:1;                    /* FlexCAN In Transmission */
    vuint32_t IDLE:1;                  /* IDLE */
    vuint32_t RXWRN:1;                 /* Rx Error Warning */
    vuint32_t TXWRN:1;                 /* TX Error Warning */
    vuint32_t STFERR:1;                /* Stuffing Error */
    vuint32_t FRMERR:1;                /* Form Error */
    vuint32_t CRCERR:1;                /* Cyclic Redundancy Check Error */
    vuint32_t ACKERR:1;                /* Acknowledge Error */
    vuint32_t BIT0ERR:1;               /* Bit0 Error */
    vuint32_t BIT1ERR:1;               /* Bit1 Error */
    vuint32_t RWRNINT:1;               /* Rx Warning Interrupt Flag */
    vuint32_t TWRNINT:1;               /* Tx Warning Interrupt Flag */
    vuint32_t SYNCH:1;                 /* CAN Synchronization Status */
    vuint32_t BOFFDONEINT:1;           /* Bus Off Done Interrupt */
    vuint32_t ERRINT_FAST:1;           /* Error interrupt for errors detected in Data Phase of CAN FD frames with BRS bit set */
    vuint32_t ERROVR:1;                /* Error Overrun */
    vuint32_t _unused_22:4;            /* Reserved */
    vuint32_t STFERR_FAST:1;           /* Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t FRMERR_FAST:1;           /* Form Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t CRCERR_FAST:1;           /* Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set */
    vuint32_t _unused_29:1;            /* Reserved */
    vuint32_t BIT0ERR_FAST:1;          /* Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BIT1ERR_FAST:1;          /* Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set */
  } B;
} FLEXCAN_4_7_ESR1_tag;

typedef union FLEXCAN_4_7_IMASK2_union_tag { /* Interrupt Masks 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32M:32;           /* Buffer MB i Mask */
  } B;
} FLEXCAN_4_7_IMASK2_tag;

typedef union FLEXCAN_4_7_IMASK1_union_tag { /* Interrupt Masks 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO0M:32;            /* Buffer MB i Mask */
  } B;
} FLEXCAN_4_7_IMASK1_tag;

typedef union FLEXCAN_4_7_IFLAG2_union_tag { /* Interrupt Flags 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32I:32;           /* Buffer MB i Interrupt */
  } B;
} FLEXCAN_4_7_IFLAG2_tag;

typedef union FLEXCAN_4_7_IFLAG1_union_tag { /* Interrupt Flags 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF0I:1;                 /* Buffer MB0 Interrupt Or Clear FIFO bit */
    vuint32_t BUF4TO1I:4;              /* Buffer MB i Interrupt Or Reserved */
    vuint32_t BUF5I:1;                 /* Buffer MB5 Interrupt Or Frames available in Rx FIFO */
    vuint32_t BUF6I:1;                 /* Buffer MB6 Interrupt Or Rx FIFO Warning */
    vuint32_t BUF7I:1;                 /* Buffer MB7 Interrupt Or Rx FIFO Overflow */
    vuint32_t BUF31TO8I:24;            /* Buffer MBi Interrupt */
  } B;
} FLEXCAN_4_7_IFLAG1_tag;

typedef union FLEXCAN_4_7_CTRL2_union_tag { /* Control 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:6;             /* Reserved */
    vuint32_t _unused_6:4;             /* Reserved */
    vuint32_t _unused_10:1;            /* Reserved */
    vuint32_t EDFLTDIS:1;              /* Edge Filter Disable */
    vuint32_t ISOCANFDEN:1;            /* ISO CAN FD Enable */
    vuint32_t _unused_13:1;            /* Reserved */
    vuint32_t PREXCEN:1;               /* Protocol Exception Enable */
    vuint32_t TIMER_SRC:1;             /* Timer Source */
    vuint32_t EACEN:1;                 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
    vuint32_t RRS:1;                   /* Remote Request Storing */
    vuint32_t MRP:1;                   /* Mailboxes Reception Priority */
    vuint32_t TASD:5;                  /* Tx Arbitration Start Delay */
    vuint32_t RFFN:4;                  /* Number Of Rx FIFO Filters */
    vuint32_t WRMFRZ:1;                /* Write-Access To Memory In Freeze Mode */
    vuint32_t ECRWRE:1;                /* Error-correction Configuration Register Write Enable */
    vuint32_t BOFFDONEMSK:1;           /* Bus Off Done Interrupt Mask */
    vuint32_t ERRMSK_FAST:1;           /* Error Interrupt Mask for errors detected in the data phase of fast CAN FD frames */
  } B;
} FLEXCAN_4_7_CTRL2_tag;

typedef union FLEXCAN_4_7_ESR2_union_tag { /* Error and Status 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:13;            /* Reserved */
    vuint32_t IMB:1;                   /* Inactive Mailbox */
    vuint32_t VPS:1;                   /* Valid Priority Status */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t LPTM:7;                  /* Lowest Priority Tx Mailbox */
    vuint32_t _unused_23:9;            /* Reserved */
  } B;
} FLEXCAN_4_7_ESR2_tag;

typedef union FLEXCAN_4_7_CRCR_union_tag { /* CRC register */
  vuint32_t R;
  struct {
    vuint32_t TXCRC:15;                /* Transmitted CRC value */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t MBCRC:7;                 /* CRC Mailbox */
    vuint32_t _unused_23:9;            /* Reserved */
  } B;
} FLEXCAN_4_7_CRCR_tag;

typedef union FLEXCAN_4_7_RXFGMASK_union_tag { /* Rx FIFO Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t FGM:32;                  /* Rx FIFO Global Mask Bits */
  } B;
} FLEXCAN_4_7_RXFGMASK_tag;

typedef union FLEXCAN_4_7_RXFIR_union_tag { /* Rx FIFO Information register */
  vuint32_t R;
  struct {
    vuint32_t IDHIT:9;                 /* Identifier Acceptance Filter Hit Indicator */
    vuint32_t _unused_9:23;            /* Reserved */
  } B;
} FLEXCAN_4_7_RXFIR_tag;

typedef union FLEXCAN_4_7_CBT_union_tag { /* CAN Bit Timing register */
  vuint32_t R;
  struct {
    vuint32_t EPSEG2:5;                /* Extended Phase Segment 2 */
    vuint32_t EPSEG1:5;                /* Extended Phase Segment 1 */
    vuint32_t EPROPSEG:6;              /* Extended Propagation Segment */
    vuint32_t ERJW:5;                  /* Extended Resync Jump Width */
    vuint32_t EPRESDIV:10;             /* Extended Prescaler Division Factor */
    vuint32_t BTF:1;                   /* Bit Timing Format Enable */
  } B;
} FLEXCAN_4_7_CBT_tag;

typedef union FLEXCAN_4_7_IMASK4_union_tag { /* Interrupt Masks 4 register */
  vuint32_t R;
  struct {
    vuint32_t BUF127TO96M:32;          /* Buffer MB i Mask */
  } B;
} FLEXCAN_4_7_IMASK4_tag;

typedef union FLEXCAN_4_7_IMASK3_union_tag { /* Interrupt Masks 3 register */
  vuint32_t R;
  struct {
    vuint32_t BUF95TO64M:32;           /* Buffer MB i Mask */
  } B;
} FLEXCAN_4_7_IMASK3_tag;

typedef union FLEXCAN_4_7_IFLAG4_union_tag { /* Interrupt Flags 4 register */
  vuint32_t R;
  struct {
    vuint32_t BUF127TO96:32;           /* Buffer MB i Interrupt */
  } B;
} FLEXCAN_4_7_IFLAG4_tag;

typedef union FLEXCAN_4_7_IFLAG3_union_tag { /* Interrupt Flags 3 register */
  vuint32_t R;
  struct {
    vuint32_t BUF95TO64:32;            /* Buffer MB i Interrupt */
  } B;
} FLEXCAN_4_7_IFLAG3_tag;

typedef union FLEXCAN_4_7_RXIMR_union_tag { /* Rx Individual Mask registers */
  vuint32_t R;
  struct {
    vuint32_t MI:32;                   /* Individual Mask Bits */
  } B;
} FLEXCAN_4_7_RXIMR_tag;

typedef union FLEXCAN_4_7_MECR_union_tag { /* Memory Error Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:7;             /* Reserved */
    vuint32_t NCEFAFRZ:1;              /* Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode */
    vuint32_t ECCDIS:1;                /* Error Correction Disable */
    vuint32_t RERRDIS:1;               /* Error Report Disable */
    vuint32_t _unused_10:3;            /* Reserved */
    vuint32_t EXTERRIE:1;              /* Extended Error Injection Enable */
    vuint32_t FAERRIE:1;               /* FlexCAN Access Error Injection Enable */
    vuint32_t HAERRIE:1;               /* Host Access Error Injection Enable */
    vuint32_t CEI_MSK:1;               /* Correctable Errors Interrupt Mask */
    vuint32_t _unused_17:1;            /* Reserved */
    vuint32_t FANCEI_MSK:1;            /* FlexCAN Access With Non-Correctable Errors Interrupt Mask */
    vuint32_t HANCEI_MSK:1;            /* Host Access With Non-Correctable Errors Interrupt Mask */
    vuint32_t _unused_20:11;           /* Reserved */
    vuint32_t ECRWRDIS:1;              /* Error Configuration Register Write Disable */
  } B;
} FLEXCAN_4_7_MECR_tag;

typedef union FLEXCAN_4_7_ERRIAR_union_tag { /* Error Injection Address register */
  vuint32_t R;
  struct {
    vuint32_t INJADDR_L:2;             /* Error Injection Address Low */
    vuint32_t INJADDR_H:12;            /* Error Injection Address High */
    vuint32_t _unused_14:18;           /* Reserved */
  } B;
} FLEXCAN_4_7_ERRIAR_tag;

typedef union FLEXCAN_4_7_ERRIDPR_union_tag { /* Error Injection Data Pattern register */
  vuint32_t R;
  struct {
    vuint32_t DFLIP:32;                /* Data flip pattern */
  } B;
} FLEXCAN_4_7_ERRIDPR_tag;

typedef union FLEXCAN_4_7_ERRIPPR_union_tag { /* Error Injection Parity Pattern register */
  vuint32_t R;
  struct {
    vuint32_t PFLIP0:5;                /* Parity Flip Pattern For Byte 0 (Least Significant) */
    vuint32_t _unused_5:3;             /* Reserved */
    vuint32_t PFLIP1:5;                /* Parity Flip Pattern For Byte 1 */
    vuint32_t _unused_13:3;            /* Reserved */
    vuint32_t PFLIP2:5;                /* Parity Flip Pattern For Byte 2 */
    vuint32_t _unused_21:3;            /* Reserved */
    vuint32_t PFLIP3:5;                /* Parity Flip Pattern For Byte 3 (most significant) */
    vuint32_t _unused_29:3;            /* Reserved */
  } B;
} FLEXCAN_4_7_ERRIPPR_tag;

typedef union FLEXCAN_4_7_RERRAR_union_tag { /* Error Report Address register */
  vuint32_t R;
  struct {
    vuint32_t ERRADDR:14;              /* Address Where Error Detected */
    vuint32_t _unused_14:2;            /* Reserved */
    vuint32_t SAID:3;                  /* SAID */
    vuint32_t _unused_19:5;            /* Reserved */
    vuint32_t NCE:1;                   /* Non-Correctable Error */
    vuint32_t _unused_25:7;            /* Reserved */
  } B;
} FLEXCAN_4_7_RERRAR_tag;

typedef union FLEXCAN_4_7_RERRDR_union_tag { /* Error Report Data register */
  vuint32_t R;
  struct {
    vuint32_t RDATA:32;                /* Raw data word read from memory with error */
  } B;
} FLEXCAN_4_7_RERRDR_tag;

typedef union FLEXCAN_4_7_RERRSYNR_union_tag { /* Error Report Syndrome register */
  vuint32_t R;
  struct {
    vuint32_t SYND0:5;                 /* Error Syndrome For Byte 0 (least significant) */
    vuint32_t _unused_5:2;             /* Reserved */
    vuint32_t BE0:1;                   /* Byte Enabled For Byte 0 (least significant) */
    vuint32_t SYND1:5;                 /* Error Syndrome for Byte 1 */
    vuint32_t _unused_13:2;            /* Reserved */
    vuint32_t BE1:1;                   /* Byte Enabled For Byte 1 */
    vuint32_t SYND2:5;                 /* Error Syndrome For Byte 2 */
    vuint32_t _unused_21:2;            /* Reserved */
    vuint32_t BE2:1;                   /* Byte Enabled For Byte 2 */
    vuint32_t SYND3:5;                 /* Error Syndrome For Byte 3 (most significant) */
    vuint32_t _unused_29:2;            /* Reserved */
    vuint32_t BE3:1;                   /* Byte Enabled For Byte 3 (most significant) */
  } B;
} FLEXCAN_4_7_RERRSYNR_tag;

typedef union FLEXCAN_4_7_ERRSR_union_tag { /* Error Status register */
  vuint32_t R;
  struct {
    vuint32_t CEIOF:1;                 /* Correctable Error Interrupt Overrun Flag */
    vuint32_t _unused_1:1;             /* Reserved */
    vuint32_t FANCEIOF:1;              /* FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t HANCEIOF:1;              /* Host Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t _unused_4:12;            /* Reserved */
    vuint32_t CEIF:1;                  /* Correctable Error Interrupt Flag */
    vuint32_t _unused_17:1;            /* Reserved */
    vuint32_t FANCEIF:1;               /* FlexCAN Access With Non-Correctable Error Interrupt Flag */
    vuint32_t HANCEIF:1;               /* Host Access With Non-Correctable Error Interrupt Flag */
    vuint32_t _unused_20:12;           /* Reserved */
  } B;
} FLEXCAN_4_7_ERRSR_tag;

typedef union FLEXCAN_4_7_FDCTRL_union_tag { /* CAN FD Control register */
  vuint32_t R;
  struct {
    vuint32_t TDCVAL:6;                /* Transceiver Delay Compensation Value */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t TDCOFF:5;                /* Transceiver Delay Compensation Offset */
    vuint32_t _unused_13:1;            /* Reserved */
    vuint32_t TDCFAIL:1;               /* Transceiver Delay Compensation Fail */
    vuint32_t TDCEN:1;                 /* Transceiver Delay Compensation Enable */
    vuint32_t MBDSR0:2;                /* Message Buffer Data Size for Region 0 */
    vuint32_t _unused_18:1;            /* Reserved */
    vuint32_t MBDSR1:2;                /* Message Buffer Data Size for Region 1 */
    vuint32_t _unused_21:1;            /* Reserved */
    vuint32_t MBDSR2:2;                /* Message Buffer Data Size for Region 2 */
    vuint32_t _unused_24:1;            /* Reserved */
    vuint32_t MBDSR3:2;                /* Message Buffer Data Size for Region 3 */
    vuint32_t _unused_27:4;            /* Reserved */
    vuint32_t FDRATE:1;                /* Bit Rate Switch Enable */
  } B;
} FLEXCAN_4_7_FDCTRL_tag;

typedef union FLEXCAN_4_7_FDCBT_union_tag { /* CAN FD Bit Timing register */
  vuint32_t R;
  struct {
    vuint32_t FPSEG2:3;                /* Fast Phase Segment 2 */
    vuint32_t _unused_3:2;             /* Reserved */
    vuint32_t FPSEG1:3;                /* Fast Phase Segment 1 */
    vuint32_t _unused_8:2;             /* Reserved */
    vuint32_t FPROPSEG:5;              /* Fast Propagation Segment */
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t FRJW:3;                  /* Fast Resync Jump Width */
    vuint32_t _unused_19:1;            /* Reserved */
    vuint32_t FPRESDIV:10;             /* Fast Prescaler Division Factor */
    vuint32_t _unused_30:2;            /* Reserved */
  } B;
} FLEXCAN_4_7_FDCBT_tag;

typedef union FLEXCAN_4_7_FDCRC_union_tag { /* CAN FD CRC register */
  vuint32_t R;
  struct {
    vuint32_t FD_TXCRC:21;             /* Extended Transmitted CRC value */
    vuint32_t _unused_21:3;            /* Reserved */
    vuint32_t FD_MBCRC:7;              /* CRC Mailbox Number for FD_TXCRC */
    vuint32_t _unused_31:1;            /* Reserved */
  } B;
} FLEXCAN_4_7_FDCRC_tag;

struct FLEXCAN_4_7_tag {
  FLEXCAN_4_7_MCR_tag MCR;             /* Module Configuration register */
  FLEXCAN_4_7_CTRL1_tag CTRL1;         /* Control 1 register */
  FLEXCAN_4_7_TIMER_tag TIMER;         /* Free Running Timer */
  uint8_t FLEXCAN_4_7_reserved0[4];
  FLEXCAN_4_7_RXMGMASK_tag RXMGMASK;   /* Rx Mailboxes Global Mask register */
  FLEXCAN_4_7_RX14MASK_tag RX14MASK;   /* Rx 14 Mask register */
  FLEXCAN_4_7_RX15MASK_tag RX15MASK;   /* Rx 15 Mask register */
  FLEXCAN_4_7_ECR_tag ECR;             /* Error Counter */
  FLEXCAN_4_7_ESR1_tag ESR1;           /* Error and Status 1 register */
  FLEXCAN_4_7_IMASK2_tag IMASK2;       /* Interrupt Masks 2 register */
  FLEXCAN_4_7_IMASK1_tag IMASK1;       /* Interrupt Masks 1 register */
  FLEXCAN_4_7_IFLAG2_tag IFLAG2;       /* Interrupt Flags 2 register */
  FLEXCAN_4_7_IFLAG1_tag IFLAG1;       /* Interrupt Flags 1 register */
  FLEXCAN_4_7_CTRL2_tag CTRL2;         /* Control 2 register */
  FLEXCAN_4_7_ESR2_tag ESR2;           /* Error and Status 2 register */
  uint8_t FLEXCAN_4_7_reserved1[8];
  FLEXCAN_4_7_CRCR_tag CRCR;           /* CRC register */
  FLEXCAN_4_7_RXFGMASK_tag RXFGMASK;   /* Rx FIFO Global Mask register */
  FLEXCAN_4_7_RXFIR_tag RXFIR;         /* Rx FIFO Information register */
  FLEXCAN_4_7_CBT_tag CBT;             /* CAN Bit Timing register */
  uint8_t FLEXCAN_4_7_reserved2[20];
  FLEXCAN_4_7_IMASK4_tag IMASK4;       /* Interrupt Masks 4 register */
  FLEXCAN_4_7_IMASK3_tag IMASK3;       /* Interrupt Masks 3 register */
  FLEXCAN_4_7_IFLAG4_tag IFLAG4;       /* Interrupt Flags 4 register */
  FLEXCAN_4_7_IFLAG3_tag IFLAG3;       /* Interrupt Flags 3 register */
  uint8_t FLEXCAN_4_7_reserved3[2056];
  FLEXCAN_4_7_RXIMR_tag RXIMR[128];    /* Rx Individual Mask registers */
  uint8_t FLEXCAN_4_7_reserved4[96];
  FLEXCAN_4_7_MECR_tag MECR;           /* Memory Error Control register */
  FLEXCAN_4_7_ERRIAR_tag ERRIAR;       /* Error Injection Address register */
  FLEXCAN_4_7_ERRIDPR_tag ERRIDPR;     /* Error Injection Data Pattern register */
  FLEXCAN_4_7_ERRIPPR_tag ERRIPPR;     /* Error Injection Parity Pattern register */
  FLEXCAN_4_7_RERRAR_tag RERRAR;       /* Error Report Address register */
  FLEXCAN_4_7_RERRDR_tag RERRDR;       /* Error Report Data register */
  FLEXCAN_4_7_RERRSYNR_tag RERRSYNR;   /* Error Report Syndrome register */
  FLEXCAN_4_7_ERRSR_tag ERRSR;         /* Error Status register */
  uint8_t FLEXCAN_4_7_reserved5[256];
  FLEXCAN_4_7_FDCTRL_tag FDCTRL;       /* CAN FD Control register */
  FLEXCAN_4_7_FDCBT_tag FDCBT;         /* CAN FD Bit Timing register */
  FLEXCAN_4_7_FDCRC_tag FDCRC;         /* CAN FD CRC register */
};


/* ============================================================================
   =============================== Module: FLEXPWM ============================
   ============================================================================ */

typedef union FLEXPWM_SUB0_CNT_union_tag { /* Submodule n Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CNT:16;                  /* Count */
  } B;
} FLEXPWM_SUB0_CNT_tag;

typedef union FLEXPWM_SUB0_INIT_union_tag { /* Submodule n Initial Count Register */
  vuint16_t R;
  struct {
    vuint16_t INIT:16;                 /* Initial count */
  } B;
} FLEXPWM_SUB0_INIT_tag;

typedef union FLEXPWM_SUB0_CTRL2_union_tag { /* Submodule n Control 2 Register */
  vuint16_t R;
  struct {
    vuint16_t CLK_SEL:2;               /* Clock Source Select */
    vuint16_t RELOAD_SEL:1;            /* Reload Source Select */
    vuint16_t FORCE_SEL:3;             /* Force Source Select */
    vuint16_t FORCE:1;                 /* Force Initialization */
    vuint16_t FRCEN:1;                 /* Force Initialization Enable */
    vuint16_t INIT_SEL:2;              /* Initialization Control Select */
    vuint16_t PWMX_INIT:1;             /* PWMX Initial Value */
    vuint16_t PWM45_INIT:1;            /* PWM45 Initial Value */
    vuint16_t PWM23_INIT:1;            /* PWM23 Initial Value */
    vuint16_t INDEP:1;                 /* Independent or Complementary Pair Operation */
    vuint16_t _unused_14:1;            /* Reserved */
    vuint16_t DBGEN:1;                 /* Debug Enable */
  } B;
} FLEXPWM_SUB0_CTRL2_tag;

typedef union FLEXPWM_SUB0_CTRL1_union_tag { /* Submodule n Control 1 Register */
  vuint16_t R;
  struct {
    vuint16_t DBLEN:1;                 /* Double Switching Enable */
    vuint16_t _unused_1:1;             /* Reserved */
    vuint16_t LDMOD:1;                 /* Load Mode Select */
    vuint16_t PHSSHFT:1;               /* Phase Shift Mode Enable */
    vuint16_t PRSC:3;                  /* Prescaler */
    vuint16_t COMPMODE:1;              /* Compare Mode */
    vuint16_t DT:2;                    /* Deadtime */
    vuint16_t FULL:1;                  /* Full Cycle Reload */
    vuint16_t HALF:1;                  /* Half Cycle Reload */
    vuint16_t LDFQ:4;                  /* Load Frequency */
  } B;
} FLEXPWM_SUB0_CTRL1_tag;

typedef union FLEXPWM_SUB0_VAL0_union_tag { /* Submodule n Value Register 0 */
  vuint16_t R;
  struct {
    vuint16_t VAL0:16;                 /* Value 0 */
  } B;
} FLEXPWM_SUB0_VAL0_tag;

typedef union FLEXPWM_SUB0_VAL1_union_tag { /* Submodule n Value Register 1 */
  vuint16_t R;
  struct {
    vuint16_t VAL1:16;                 /* Value 1 */
  } B;
} FLEXPWM_SUB0_VAL1_tag;

typedef union FLEXPWM_SUB0_VAL2_union_tag { /* Submodule n Value Register 2 */
  vuint16_t R;
  struct {
    vuint16_t VAL2:16;                 /* Value 2 */
  } B;
} FLEXPWM_SUB0_VAL2_tag;

typedef union FLEXPWM_SUB0_VAL3_union_tag { /* Submodule n Value Register 3 */
  vuint16_t R;
  struct {
    vuint16_t VAL3:16;                 /* Value 3 */
  } B;
} FLEXPWM_SUB0_VAL3_tag;

typedef union FLEXPWM_SUB0_VAL4_union_tag { /* Submodule n Value Register 4 */
  vuint16_t R;
  struct {
    vuint16_t VAL4:16;                 /* VAL4 */
  } B;
} FLEXPWM_SUB0_VAL4_tag;

typedef union FLEXPWM_SUB0_VAL5_union_tag { /* Submodule n Value Register 5 */
  vuint16_t R;
  struct {
    vuint16_t VAL5:16;                 /* VAL5 */
  } B;
} FLEXPWM_SUB0_VAL5_tag;

typedef union FLEXPWM_SUB0_OCTRL_union_tag { /* Submodule n Output Control Register */
  vuint16_t R;
  struct {
    vuint16_t PWMXFS:2;                /* PWMX Fault State */
    vuint16_t PWMBFS:2;                /* PWMB Fault State */
    vuint16_t PWMAFS:2;                /* PWMA Fault State */
    vuint16_t _unused_6:2;             /* Reserved */
    vuint16_t POLX:1;                  /* POLX */
    vuint16_t POLB:1;                  /* POLB */
    vuint16_t POLA:1;                  /* POLA */
    vuint16_t _unused_11:2;            /* Reserved */
    vuint16_t PWMX_IN:1;               /* PWMX_IN */
    vuint16_t _unused_14:1;            /* Reserved */
    vuint16_t _unused_15:1;            /* Reserved */
  } B;
} FLEXPWM_SUB0_OCTRL_tag;

typedef union FLEXPWM_SUB0_STS_union_tag { /* Submodule n Status Register */
  vuint16_t R;
  struct {
    vuint16_t CMPF:6;                  /* CMPF */
    vuint16_t CFX0:1;                  /* CFX0 */
    vuint16_t CFX1:1;                  /* CFX1 */
    vuint16_t _unused_8:4;             /* Reserved */
    vuint16_t RF:1;                    /* RF */
    vuint16_t REF:1;                   /* REF */
    vuint16_t RUF:1;                   /* RUF */
    vuint16_t _unused_15:1;            /* Reserved */
  } B;
} FLEXPWM_SUB0_STS_tag;

typedef union FLEXPWM_SUB0_INTEN_union_tag { /* Submodule n Interrupt Enable Register */
  vuint16_t R;
  struct {
    vuint16_t CMPIE:6;                 /* CMPIE */
    vuint16_t CX0IE:1;                 /* CX0IE */
    vuint16_t CX1IE:1;                 /* CX1IE */
    vuint16_t _unused_8:4;             /* Reserved */
    vuint16_t RIE:1;                   /* RIE */
    vuint16_t REIE:1;                  /* REIE */
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} FLEXPWM_SUB0_INTEN_tag;

typedef union FLEXPWM_SUB0_DMAEN_union_tag { /* Submodule n DMA Enable Register */
  vuint16_t R;
  struct {
    vuint16_t CX0DE:1;                 /* CX0DE */
    vuint16_t CX1DE:1;                 /* CX1DE */
    vuint16_t _unused_2:4;             /* Reserved */
    vuint16_t CAPTDE:2;                /* CAPTDE */
    vuint16_t FAND:1;                  /* FAND */
    vuint16_t VALDE:1;                 /* VALDE */
    vuint16_t _unused_10:6;            /* Reserved */
  } B;
} FLEXPWM_SUB0_DMAEN_tag;

typedef union FLEXPWM_SUB0_TCTRL_union_tag { /* Submodule n Output Trigger Control Register */
  vuint16_t R;
  struct {
    vuint16_t OUT_TRIG_EN:6;           /* OUT_TRIG_EN */
    vuint16_t _unused_6:10;            /* Reserved */
  } B;
} FLEXPWM_SUB0_TCTRL_tag;

typedef union FLEXPWM_SUB0_DISMAP_union_tag { /* Submodule n Fault Disable Mapping Register */
  vuint16_t R;
  struct {
    vuint16_t DISA:4;                  /* DISA */
    vuint16_t DISB:4;                  /* DISB */
    vuint16_t DISX:4;                  /* DISX */
    vuint16_t _unused_12:4;            /* Reserved */
  } B;
} FLEXPWM_SUB0_DISMAP_tag;

typedef union FLEXPWM_SUB0_DTCNT0_union_tag { /* Submodule n Deadtime Count Register 0 */
  vuint16_t R;
  struct {
    vuint16_t DTCNT0:11;               /* DTCNT0 */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXPWM_SUB0_DTCNT0_tag;

typedef union FLEXPWM_SUB0_DTCNT1_union_tag { /* Submodule n Deadtime Count Register 1 */
  vuint16_t R;
  struct {
    vuint16_t DTCNT1:11;               /* DTCNT1 */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXPWM_SUB0_DTCNT1_tag;

typedef union FLEXPWM_SUB0_CAPTCTRLX_union_tag { /* Submodule n Capture Control X Register */
  vuint16_t R;
  struct {
    vuint16_t ARMX:1;                  /* ARMX */
    vuint16_t ONESHOTX:1;              /* ONESHOTX */
    vuint16_t EDGX0:2;                 /* EDGX0 */
    vuint16_t EDGX1:2;                 /* EDGX1 */
    vuint16_t INPSELX:1;               /* INPSELX */
    vuint16_t EDGCNTX_EN:1;            /* EDGCNTX_EN */
    vuint16_t CFXWM:2;                 /* Capture X FIFOs Watermark */
    vuint16_t CX0CNT:3;                /* CX0CNT */
    vuint16_t CX1CNT:3;                /* CX1CNT */
  } B;
} FLEXPWM_SUB0_CAPTCTRLX_tag;

typedef union FLEXPWM_SUB0_CAPTCMPX_union_tag { /* Submodule n Capture Compare X Register */
  vuint16_t R;
  struct {
    vuint16_t EDGCMPX:8;               /* EDGCMPX */
    vuint16_t EDGCNTX:8;               /* EDGCNTX */
  } B;
} FLEXPWM_SUB0_CAPTCMPX_tag;

typedef union FLEXPWM_SUB0_CVAL0_union_tag { /* Submodule n Capture Value 0 Register */
  vuint16_t R;
  struct {
    vuint16_t CAPTVAL0:16;             /* CAPTVAL0 */
  } B;
} FLEXPWM_SUB0_CVAL0_tag;

typedef union FLEXPWM_SUB0_CVAL0CYC_union_tag { /* Submodule n Capture Value 0 Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t CVAL0CYC:3;              /* CVAL0 Cycle */
    vuint16_t _unused_3:13;            /* Reserved */
  } B;
} FLEXPWM_SUB0_CVAL0CYC_tag;

typedef union FLEXPWM_SUB0_CVAL1_union_tag { /* Submodule n Capture Value 1 Register */
  vuint16_t R;
  struct {
    vuint16_t CAPTVAL1:16;             /* CAPTVAL1 */
  } B;
} FLEXPWM_SUB0_CVAL1_tag;

typedef union FLEXPWM_SUB0_CVAL1CYC_union_tag { /* Submodule n Capture Value 1 Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t CVAL1CYC:3;              /* CVAL1 Cycle */
    vuint16_t _unused_3:13;            /* Reserved */
  } B;
} FLEXPWM_SUB0_CVAL1CYC_tag;

typedef union FLEXPWM_SUB1_CNT_union_tag { /* Submodule n Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CNT:16;                  /* Count */
  } B;
} FLEXPWM_SUB1_CNT_tag;

typedef union FLEXPWM_SUB1_INIT_union_tag { /* Submodule n Initial Count Register */
  vuint16_t R;
  struct {
    vuint16_t INIT:16;                 /* Initial count */
  } B;
} FLEXPWM_SUB1_INIT_tag;

typedef union FLEXPWM_SUB1_CTRL2_union_tag { /* Submodule n Control 2 Register */
  vuint16_t R;
  struct {
    vuint16_t CLK_SEL:2;               /* Clock Source Select */
    vuint16_t RELOAD_SEL:1;            /* Reload Source Select */
    vuint16_t FORCE_SEL:3;             /* Force Source Select */
    vuint16_t FORCE:1;                 /* Force Initialization */
    vuint16_t FRCEN:1;                 /* Force Initialization Enable */
    vuint16_t INIT_SEL:2;              /* Initialization Control Select */
    vuint16_t PWMX_INIT:1;             /* PWMX Initial Value */
    vuint16_t PWM45_INIT:1;            /* PWM45 Initial Value */
    vuint16_t PWM23_INIT:1;            /* PWM23 Initial Value */
    vuint16_t INDEP:1;                 /* Independent or Complementary Pair Operation */
    vuint16_t _unused_14:1;            /* Reserved */
    vuint16_t DBGEN:1;                 /* Debug Enable */
  } B;
} FLEXPWM_SUB1_CTRL2_tag;

typedef union FLEXPWM_SUB1_CTRL1_union_tag { /* Submodule n Control 1 Register */
  vuint16_t R;
  struct {
    vuint16_t DBLEN:1;                 /* Double Switching Enable */
    vuint16_t _unused_1:1;             /* Reserved */
    vuint16_t LDMOD:1;                 /* Load Mode Select */
    vuint16_t PHSSHFT:1;               /* Phase Shift Mode Enable */
    vuint16_t PRSC:3;                  /* Prescaler */
    vuint16_t COMPMODE:1;              /* Compare Mode */
    vuint16_t DT:2;                    /* Deadtime */
    vuint16_t FULL:1;                  /* Full Cycle Reload */
    vuint16_t HALF:1;                  /* Half Cycle Reload */
    vuint16_t LDFQ:4;                  /* Load Frequency */
  } B;
} FLEXPWM_SUB1_CTRL1_tag;

typedef union FLEXPWM_SUB1_VAL0_union_tag { /* Submodule n Value Register 0 */
  vuint16_t R;
  struct {
    vuint16_t VAL0:16;                 /* Value 0 */
  } B;
} FLEXPWM_SUB1_VAL0_tag;

typedef union FLEXPWM_SUB1_VAL1_union_tag { /* Submodule n Value Register 1 */
  vuint16_t R;
  struct {
    vuint16_t VAL1:16;                 /* Value 1 */
  } B;
} FLEXPWM_SUB1_VAL1_tag;

typedef union FLEXPWM_SUB1_VAL2_union_tag { /* Submodule n Value Register 2 */
  vuint16_t R;
  struct {
    vuint16_t VAL2:16;                 /* Value 2 */
  } B;
} FLEXPWM_SUB1_VAL2_tag;

typedef union FLEXPWM_SUB1_VAL3_union_tag { /* Submodule n Value Register 3 */
  vuint16_t R;
  struct {
    vuint16_t VAL3:16;                 /* Value 3 */
  } B;
} FLEXPWM_SUB1_VAL3_tag;

typedef union FLEXPWM_SUB1_VAL4_union_tag { /* Submodule n Value Register 4 */
  vuint16_t R;
  struct {
    vuint16_t VAL4:16;                 /* VAL4 */
  } B;
} FLEXPWM_SUB1_VAL4_tag;

typedef union FLEXPWM_SUB1_VAL5_union_tag { /* Submodule n Value Register 5 */
  vuint16_t R;
  struct {
    vuint16_t VAL5:16;                 /* VAL5 */
  } B;
} FLEXPWM_SUB1_VAL5_tag;

typedef union FLEXPWM_SUB1_OCTRL_union_tag { /* Submodule n Output Control Register */
  vuint16_t R;
  struct {
    vuint16_t PWMXFS:2;                /* PWMX Fault State */
    vuint16_t PWMBFS:2;                /* PWMB Fault State */
    vuint16_t PWMAFS:2;                /* PWMA Fault State */
    vuint16_t _unused_6:2;             /* Reserved */
    vuint16_t POLX:1;                  /* POLX */
    vuint16_t POLB:1;                  /* POLB */
    vuint16_t POLA:1;                  /* POLA */
    vuint16_t _unused_11:2;            /* Reserved */
    vuint16_t PWMX_IN:1;               /* PWMX_IN */
    vuint16_t _unused_14:1;            /* Reserved */
    vuint16_t _unused_15:1;            /* Reserved */
  } B;
} FLEXPWM_SUB1_OCTRL_tag;

typedef union FLEXPWM_SUB1_STS_union_tag { /* Submodule n Status Register */
  vuint16_t R;
  struct {
    vuint16_t CMPF:6;                  /* CMPF */
    vuint16_t CFX0:1;                  /* CFX0 */
    vuint16_t CFX1:1;                  /* CFX1 */
    vuint16_t _unused_8:4;             /* Reserved */
    vuint16_t RF:1;                    /* RF */
    vuint16_t REF:1;                   /* REF */
    vuint16_t RUF:1;                   /* RUF */
    vuint16_t _unused_15:1;            /* Reserved */
  } B;
} FLEXPWM_SUB1_STS_tag;

typedef union FLEXPWM_SUB1_INTEN_union_tag { /* Submodule n Interrupt Enable Register */
  vuint16_t R;
  struct {
    vuint16_t CMPIE:6;                 /* CMPIE */
    vuint16_t CX0IE:1;                 /* CX0IE */
    vuint16_t CX1IE:1;                 /* CX1IE */
    vuint16_t _unused_8:4;             /* Reserved */
    vuint16_t RIE:1;                   /* RIE */
    vuint16_t REIE:1;                  /* REIE */
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} FLEXPWM_SUB1_INTEN_tag;

typedef union FLEXPWM_SUB1_DMAEN_union_tag { /* Submodule n DMA Enable Register */
  vuint16_t R;
  struct {
    vuint16_t CX0DE:1;                 /* CX0DE */
    vuint16_t CX1DE:1;                 /* CX1DE */
    vuint16_t _unused_2:4;             /* Reserved */
    vuint16_t CAPTDE:2;                /* CAPTDE */
    vuint16_t FAND:1;                  /* FAND */
    vuint16_t VALDE:1;                 /* VALDE */
    vuint16_t _unused_10:6;            /* Reserved */
  } B;
} FLEXPWM_SUB1_DMAEN_tag;

typedef union FLEXPWM_SUB1_TCTRL_union_tag { /* Submodule n Output Trigger Control Register */
  vuint16_t R;
  struct {
    vuint16_t OUT_TRIG_EN:6;           /* OUT_TRIG_EN */
    vuint16_t _unused_6:10;            /* Reserved */
  } B;
} FLEXPWM_SUB1_TCTRL_tag;

typedef union FLEXPWM_SUB1_DISMAP_union_tag { /* Submodule n Fault Disable Mapping Register */
  vuint16_t R;
  struct {
    vuint16_t DISA:4;                  /* DISA */
    vuint16_t DISB:4;                  /* DISB */
    vuint16_t DISX:4;                  /* DISX */
    vuint16_t _unused_12:4;            /* Reserved */
  } B;
} FLEXPWM_SUB1_DISMAP_tag;

typedef union FLEXPWM_SUB1_DTCNT0_union_tag { /* Submodule n Deadtime Count Register 0 */
  vuint16_t R;
  struct {
    vuint16_t DTCNT0:11;               /* DTCNT0 */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXPWM_SUB1_DTCNT0_tag;

typedef union FLEXPWM_SUB1_DTCNT1_union_tag { /* Submodule n Deadtime Count Register 1 */
  vuint16_t R;
  struct {
    vuint16_t DTCNT1:11;               /* DTCNT1 */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXPWM_SUB1_DTCNT1_tag;

typedef union FLEXPWM_SUB1_CAPTCTRLX_union_tag { /* Submodule n Capture Control X Register */
  vuint16_t R;
  struct {
    vuint16_t ARMX:1;                  /* ARMX */
    vuint16_t ONESHOTX:1;              /* ONESHOTX */
    vuint16_t EDGX0:2;                 /* EDGX0 */
    vuint16_t EDGX1:2;                 /* EDGX1 */
    vuint16_t INPSELX:1;               /* INPSELX */
    vuint16_t EDGCNTX_EN:1;            /* EDGCNTX_EN */
    vuint16_t CFXWM:2;                 /* Capture X FIFOs Watermark */
    vuint16_t CX0CNT:3;                /* CX0CNT */
    vuint16_t CX1CNT:3;                /* CX1CNT */
  } B;
} FLEXPWM_SUB1_CAPTCTRLX_tag;

typedef union FLEXPWM_SUB1_CAPTCMPX_union_tag { /* Submodule n Capture Compare X Register */
  vuint16_t R;
  struct {
    vuint16_t EDGCMPX:8;               /* EDGCMPX */
    vuint16_t EDGCNTX:8;               /* EDGCNTX */
  } B;
} FLEXPWM_SUB1_CAPTCMPX_tag;

typedef union FLEXPWM_SUB1_CVAL0_union_tag { /* Submodule n Capture Value 0 Register */
  vuint16_t R;
  struct {
    vuint16_t CAPTVAL0:16;             /* CAPTVAL0 */
  } B;
} FLEXPWM_SUB1_CVAL0_tag;

typedef union FLEXPWM_SUB1_CVAL0CYC_union_tag { /* Submodule n Capture Value 0 Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t CVAL0CYC:3;              /* CVAL0 Cycle */
    vuint16_t _unused_3:13;            /* Reserved */
  } B;
} FLEXPWM_SUB1_CVAL0CYC_tag;

typedef union FLEXPWM_SUB1_CVAL1_union_tag { /* Submodule n Capture Value 1 Register */
  vuint16_t R;
  struct {
    vuint16_t CAPTVAL1:16;             /* CAPTVAL1 */
  } B;
} FLEXPWM_SUB1_CVAL1_tag;

typedef union FLEXPWM_SUB1_CVAL1CYC_union_tag { /* Submodule n Capture Value 1 Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t CVAL1CYC:3;              /* CVAL1 Cycle */
    vuint16_t _unused_3:13;            /* Reserved */
  } B;
} FLEXPWM_SUB1_CVAL1CYC_tag;

typedef union FLEXPWM_SUB2_CNT_union_tag { /* Submodule n Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CNT:16;                  /* Count */
  } B;
} FLEXPWM_SUB2_CNT_tag;

typedef union FLEXPWM_SUB2_INIT_union_tag { /* Submodule n Initial Count Register */
  vuint16_t R;
  struct {
    vuint16_t INIT:16;                 /* Initial count */
  } B;
} FLEXPWM_SUB2_INIT_tag;

typedef union FLEXPWM_SUB2_CTRL2_union_tag { /* Submodule n Control 2 Register */
  vuint16_t R;
  struct {
    vuint16_t CLK_SEL:2;               /* Clock Source Select */
    vuint16_t RELOAD_SEL:1;            /* Reload Source Select */
    vuint16_t FORCE_SEL:3;             /* Force Source Select */
    vuint16_t FORCE:1;                 /* Force Initialization */
    vuint16_t FRCEN:1;                 /* Force Initialization Enable */
    vuint16_t INIT_SEL:2;              /* Initialization Control Select */
    vuint16_t PWMX_INIT:1;             /* PWMX Initial Value */
    vuint16_t PWM45_INIT:1;            /* PWM45 Initial Value */
    vuint16_t PWM23_INIT:1;            /* PWM23 Initial Value */
    vuint16_t INDEP:1;                 /* Independent or Complementary Pair Operation */
    vuint16_t _unused_14:1;            /* Reserved */
    vuint16_t DBGEN:1;                 /* Debug Enable */
  } B;
} FLEXPWM_SUB2_CTRL2_tag;

typedef union FLEXPWM_SUB2_CTRL1_union_tag { /* Submodule n Control 1 Register */
  vuint16_t R;
  struct {
    vuint16_t DBLEN:1;                 /* Double Switching Enable */
    vuint16_t _unused_1:1;             /* Reserved */
    vuint16_t LDMOD:1;                 /* Load Mode Select */
    vuint16_t PHSSHFT:1;               /* Phase Shift Mode Enable */
    vuint16_t PRSC:3;                  /* Prescaler */
    vuint16_t COMPMODE:1;              /* Compare Mode */
    vuint16_t DT:2;                    /* Deadtime */
    vuint16_t FULL:1;                  /* Full Cycle Reload */
    vuint16_t HALF:1;                  /* Half Cycle Reload */
    vuint16_t LDFQ:4;                  /* Load Frequency */
  } B;
} FLEXPWM_SUB2_CTRL1_tag;

typedef union FLEXPWM_SUB2_VAL0_union_tag { /* Submodule n Value Register 0 */
  vuint16_t R;
  struct {
    vuint16_t VAL0:16;                 /* Value 0 */
  } B;
} FLEXPWM_SUB2_VAL0_tag;

typedef union FLEXPWM_SUB2_VAL1_union_tag { /* Submodule n Value Register 1 */
  vuint16_t R;
  struct {
    vuint16_t VAL1:16;                 /* Value 1 */
  } B;
} FLEXPWM_SUB2_VAL1_tag;

typedef union FLEXPWM_SUB2_VAL2_union_tag { /* Submodule n Value Register 2 */
  vuint16_t R;
  struct {
    vuint16_t VAL2:16;                 /* Value 2 */
  } B;
} FLEXPWM_SUB2_VAL2_tag;

typedef union FLEXPWM_SUB2_VAL3_union_tag { /* Submodule n Value Register 3 */
  vuint16_t R;
  struct {
    vuint16_t VAL3:16;                 /* Value 3 */
  } B;
} FLEXPWM_SUB2_VAL3_tag;

typedef union FLEXPWM_SUB2_VAL4_union_tag { /* Submodule n Value Register 4 */
  vuint16_t R;
  struct {
    vuint16_t VAL4:16;                 /* VAL4 */
  } B;
} FLEXPWM_SUB2_VAL4_tag;

typedef union FLEXPWM_SUB2_VAL5_union_tag { /* Submodule n Value Register 5 */
  vuint16_t R;
  struct {
    vuint16_t VAL5:16;                 /* VAL5 */
  } B;
} FLEXPWM_SUB2_VAL5_tag;

typedef union FLEXPWM_SUB2_OCTRL_union_tag { /* Submodule n Output Control Register */
  vuint16_t R;
  struct {
    vuint16_t PWMXFS:2;                /* PWMX Fault State */
    vuint16_t PWMBFS:2;                /* PWMB Fault State */
    vuint16_t PWMAFS:2;                /* PWMA Fault State */
    vuint16_t _unused_6:2;             /* Reserved */
    vuint16_t POLX:1;                  /* POLX */
    vuint16_t POLB:1;                  /* POLB */
    vuint16_t POLA:1;                  /* POLA */
    vuint16_t _unused_11:2;            /* Reserved */
    vuint16_t PWMX_IN:1;               /* PWMX_IN */
    vuint16_t _unused_14:1;            /* Reserved */
    vuint16_t _unused_15:1;            /* Reserved */
  } B;
} FLEXPWM_SUB2_OCTRL_tag;

typedef union FLEXPWM_SUB2_STS_union_tag { /* Submodule n Status Register */
  vuint16_t R;
  struct {
    vuint16_t CMPF:6;                  /* CMPF */
    vuint16_t CFX0:1;                  /* CFX0 */
    vuint16_t CFX1:1;                  /* CFX1 */
    vuint16_t _unused_8:4;             /* Reserved */
    vuint16_t RF:1;                    /* RF */
    vuint16_t REF:1;                   /* REF */
    vuint16_t RUF:1;                   /* RUF */
    vuint16_t _unused_15:1;            /* Reserved */
  } B;
} FLEXPWM_SUB2_STS_tag;

typedef union FLEXPWM_SUB2_INTEN_union_tag { /* Submodule n Interrupt Enable Register */
  vuint16_t R;
  struct {
    vuint16_t CMPIE:6;                 /* CMPIE */
    vuint16_t CX0IE:1;                 /* CX0IE */
    vuint16_t CX1IE:1;                 /* CX1IE */
    vuint16_t _unused_8:4;             /* Reserved */
    vuint16_t RIE:1;                   /* RIE */
    vuint16_t REIE:1;                  /* REIE */
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} FLEXPWM_SUB2_INTEN_tag;

typedef union FLEXPWM_SUB2_DMAEN_union_tag { /* Submodule n DMA Enable Register */
  vuint16_t R;
  struct {
    vuint16_t CX0DE:1;                 /* CX0DE */
    vuint16_t CX1DE:1;                 /* CX1DE */
    vuint16_t _unused_2:4;             /* Reserved */
    vuint16_t CAPTDE:2;                /* CAPTDE */
    vuint16_t FAND:1;                  /* FAND */
    vuint16_t VALDE:1;                 /* VALDE */
    vuint16_t _unused_10:6;            /* Reserved */
  } B;
} FLEXPWM_SUB2_DMAEN_tag;

typedef union FLEXPWM_SUB2_TCTRL_union_tag { /* Submodule n Output Trigger Control Register */
  vuint16_t R;
  struct {
    vuint16_t OUT_TRIG_EN:6;           /* OUT_TRIG_EN */
    vuint16_t _unused_6:10;            /* Reserved */
  } B;
} FLEXPWM_SUB2_TCTRL_tag;

typedef union FLEXPWM_SUB2_DISMAP_union_tag { /* Submodule n Fault Disable Mapping Register */
  vuint16_t R;
  struct {
    vuint16_t DISA:4;                  /* DISA */
    vuint16_t DISB:4;                  /* DISB */
    vuint16_t DISX:4;                  /* DISX */
    vuint16_t _unused_12:4;            /* Reserved */
  } B;
} FLEXPWM_SUB2_DISMAP_tag;

typedef union FLEXPWM_SUB2_DTCNT0_union_tag { /* Submodule n Deadtime Count Register 0 */
  vuint16_t R;
  struct {
    vuint16_t DTCNT0:11;               /* DTCNT0 */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXPWM_SUB2_DTCNT0_tag;

typedef union FLEXPWM_SUB2_DTCNT1_union_tag { /* Submodule n Deadtime Count Register 1 */
  vuint16_t R;
  struct {
    vuint16_t DTCNT1:11;               /* DTCNT1 */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXPWM_SUB2_DTCNT1_tag;

typedef union FLEXPWM_SUB2_CAPTCTRLX_union_tag { /* Submodule n Capture Control X Register */
  vuint16_t R;
  struct {
    vuint16_t ARMX:1;                  /* ARMX */
    vuint16_t ONESHOTX:1;              /* ONESHOTX */
    vuint16_t EDGX0:2;                 /* EDGX0 */
    vuint16_t EDGX1:2;                 /* EDGX1 */
    vuint16_t INPSELX:1;               /* INPSELX */
    vuint16_t EDGCNTX_EN:1;            /* EDGCNTX_EN */
    vuint16_t CFXWM:2;                 /* Capture X FIFOs Watermark */
    vuint16_t CX0CNT:3;                /* CX0CNT */
    vuint16_t CX1CNT:3;                /* CX1CNT */
  } B;
} FLEXPWM_SUB2_CAPTCTRLX_tag;

typedef union FLEXPWM_SUB2_CAPTCMPX_union_tag { /* Submodule n Capture Compare X Register */
  vuint16_t R;
  struct {
    vuint16_t EDGCMPX:8;               /* EDGCMPX */
    vuint16_t EDGCNTX:8;               /* EDGCNTX */
  } B;
} FLEXPWM_SUB2_CAPTCMPX_tag;

typedef union FLEXPWM_SUB2_CVAL0_union_tag { /* Submodule n Capture Value 0 Register */
  vuint16_t R;
  struct {
    vuint16_t CAPTVAL0:16;             /* CAPTVAL0 */
  } B;
} FLEXPWM_SUB2_CVAL0_tag;

typedef union FLEXPWM_SUB2_CVAL0CYC_union_tag { /* Submodule n Capture Value 0 Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t CVAL0CYC:3;              /* CVAL0 Cycle */
    vuint16_t _unused_3:13;            /* Reserved */
  } B;
} FLEXPWM_SUB2_CVAL0CYC_tag;

typedef union FLEXPWM_SUB2_CVAL1_union_tag { /* Submodule n Capture Value 1 Register */
  vuint16_t R;
  struct {
    vuint16_t CAPTVAL1:16;             /* CAPTVAL1 */
  } B;
} FLEXPWM_SUB2_CVAL1_tag;

typedef union FLEXPWM_SUB2_CVAL1CYC_union_tag { /* Submodule n Capture Value 1 Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t CVAL1CYC:3;              /* CVAL1 Cycle */
    vuint16_t _unused_3:13;            /* Reserved */
  } B;
} FLEXPWM_SUB2_CVAL1CYC_tag;

typedef union FLEXPWM_SUB3_CNT_union_tag { /* Submodule n Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CNT:16;                  /* Count */
  } B;
} FLEXPWM_SUB3_CNT_tag;

typedef union FLEXPWM_SUB3_INIT_union_tag { /* Submodule n Initial Count Register */
  vuint16_t R;
  struct {
    vuint16_t INIT:16;                 /* Initial count */
  } B;
} FLEXPWM_SUB3_INIT_tag;

typedef union FLEXPWM_SUB3_CTRL2_union_tag { /* Submodule n Control 2 Register */
  vuint16_t R;
  struct {
    vuint16_t CLK_SEL:2;               /* Clock Source Select */
    vuint16_t RELOAD_SEL:1;            /* Reload Source Select */
    vuint16_t FORCE_SEL:3;             /* Force Source Select */
    vuint16_t FORCE:1;                 /* Force Initialization */
    vuint16_t FRCEN:1;                 /* Force Initialization Enable */
    vuint16_t INIT_SEL:2;              /* Initialization Control Select */
    vuint16_t PWMX_INIT:1;             /* PWMX Initial Value */
    vuint16_t PWM45_INIT:1;            /* PWM45 Initial Value */
    vuint16_t PWM23_INIT:1;            /* PWM23 Initial Value */
    vuint16_t INDEP:1;                 /* Independent or Complementary Pair Operation */
    vuint16_t _unused_14:1;            /* Reserved */
    vuint16_t DBGEN:1;                 /* Debug Enable */
  } B;
} FLEXPWM_SUB3_CTRL2_tag;

typedef union FLEXPWM_SUB3_CTRL1_union_tag { /* Submodule n Control 1 Register */
  vuint16_t R;
  struct {
    vuint16_t DBLEN:1;                 /* Double Switching Enable */
    vuint16_t _unused_1:1;             /* Reserved */
    vuint16_t LDMOD:1;                 /* Load Mode Select */
    vuint16_t PHSSHFT:1;               /* Phase Shift Mode Enable */
    vuint16_t PRSC:3;                  /* Prescaler */
    vuint16_t COMPMODE:1;              /* Compare Mode */
    vuint16_t DT:2;                    /* Deadtime */
    vuint16_t FULL:1;                  /* Full Cycle Reload */
    vuint16_t HALF:1;                  /* Half Cycle Reload */
    vuint16_t LDFQ:4;                  /* Load Frequency */
  } B;
} FLEXPWM_SUB3_CTRL1_tag;

typedef union FLEXPWM_SUB3_VAL0_union_tag { /* Submodule n Value Register 0 */
  vuint16_t R;
  struct {
    vuint16_t VAL0:16;                 /* Value 0 */
  } B;
} FLEXPWM_SUB3_VAL0_tag;

typedef union FLEXPWM_SUB3_VAL1_union_tag { /* Submodule n Value Register 1 */
  vuint16_t R;
  struct {
    vuint16_t VAL1:16;                 /* Value 1 */
  } B;
} FLEXPWM_SUB3_VAL1_tag;

typedef union FLEXPWM_SUB3_VAL2_union_tag { /* Submodule n Value Register 2 */
  vuint16_t R;
  struct {
    vuint16_t VAL2:16;                 /* Value 2 */
  } B;
} FLEXPWM_SUB3_VAL2_tag;

typedef union FLEXPWM_SUB3_VAL3_union_tag { /* Submodule n Value Register 3 */
  vuint16_t R;
  struct {
    vuint16_t VAL3:16;                 /* Value 3 */
  } B;
} FLEXPWM_SUB3_VAL3_tag;

typedef union FLEXPWM_SUB3_VAL4_union_tag { /* Submodule n Value Register 4 */
  vuint16_t R;
  struct {
    vuint16_t VAL4:16;                 /* VAL4 */
  } B;
} FLEXPWM_SUB3_VAL4_tag;

typedef union FLEXPWM_SUB3_VAL5_union_tag { /* Submodule n Value Register 5 */
  vuint16_t R;
  struct {
    vuint16_t VAL5:16;                 /* VAL5 */
  } B;
} FLEXPWM_SUB3_VAL5_tag;

typedef union FLEXPWM_SUB3_OCTRL_union_tag { /* Submodule n Output Control Register */
  vuint16_t R;
  struct {
    vuint16_t PWMXFS:2;                /* PWMX Fault State */
    vuint16_t PWMBFS:2;                /* PWMB Fault State */
    vuint16_t PWMAFS:2;                /* PWMA Fault State */
    vuint16_t _unused_6:2;             /* Reserved */
    vuint16_t POLX:1;                  /* POLX */
    vuint16_t POLB:1;                  /* POLB */
    vuint16_t POLA:1;                  /* POLA */
    vuint16_t _unused_11:2;            /* Reserved */
    vuint16_t PWMX_IN:1;               /* PWMX_IN */
    vuint16_t _unused_14:1;            /* Reserved */
    vuint16_t _unused_15:1;            /* Reserved */
  } B;
} FLEXPWM_SUB3_OCTRL_tag;

typedef union FLEXPWM_SUB3_STS_union_tag { /* Submodule n Status Register */
  vuint16_t R;
  struct {
    vuint16_t CMPF:6;                  /* CMPF */
    vuint16_t CFX0:1;                  /* CFX0 */
    vuint16_t CFX1:1;                  /* CFX1 */
    vuint16_t _unused_8:4;             /* Reserved */
    vuint16_t RF:1;                    /* RF */
    vuint16_t REF:1;                   /* REF */
    vuint16_t RUF:1;                   /* RUF */
    vuint16_t _unused_15:1;            /* Reserved */
  } B;
} FLEXPWM_SUB3_STS_tag;

typedef union FLEXPWM_SUB3_INTEN_union_tag { /* Submodule n Interrupt Enable Register */
  vuint16_t R;
  struct {
    vuint16_t CMPIE:6;                 /* CMPIE */
    vuint16_t CX0IE:1;                 /* CX0IE */
    vuint16_t CX1IE:1;                 /* CX1IE */
    vuint16_t _unused_8:4;             /* Reserved */
    vuint16_t RIE:1;                   /* RIE */
    vuint16_t REIE:1;                  /* REIE */
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} FLEXPWM_SUB3_INTEN_tag;

typedef union FLEXPWM_SUB3_DMAEN_union_tag { /* Submodule n DMA Enable Register */
  vuint16_t R;
  struct {
    vuint16_t CX0DE:1;                 /* CX0DE */
    vuint16_t CX1DE:1;                 /* CX1DE */
    vuint16_t _unused_2:4;             /* Reserved */
    vuint16_t CAPTDE:2;                /* CAPTDE */
    vuint16_t FAND:1;                  /* FAND */
    vuint16_t VALDE:1;                 /* VALDE */
    vuint16_t _unused_10:6;            /* Reserved */
  } B;
} FLEXPWM_SUB3_DMAEN_tag;

typedef union FLEXPWM_SUB3_TCTRL_union_tag { /* Submodule n Output Trigger Control Register */
  vuint16_t R;
  struct {
    vuint16_t OUT_TRIG_EN:6;           /* OUT_TRIG_EN */
    vuint16_t _unused_6:10;            /* Reserved */
  } B;
} FLEXPWM_SUB3_TCTRL_tag;

typedef union FLEXPWM_SUB3_DISMAP_union_tag { /* Submodule n Fault Disable Mapping Register */
  vuint16_t R;
  struct {
    vuint16_t DISA:4;                  /* DISA */
    vuint16_t DISB:4;                  /* DISB */
    vuint16_t DISX:4;                  /* DISX */
    vuint16_t _unused_12:4;            /* Reserved */
  } B;
} FLEXPWM_SUB3_DISMAP_tag;

typedef union FLEXPWM_SUB3_DTCNT0_union_tag { /* Submodule n Deadtime Count Register 0 */
  vuint16_t R;
  struct {
    vuint16_t DTCNT0:11;               /* DTCNT0 */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXPWM_SUB3_DTCNT0_tag;

typedef union FLEXPWM_SUB3_DTCNT1_union_tag { /* Submodule n Deadtime Count Register 1 */
  vuint16_t R;
  struct {
    vuint16_t DTCNT1:11;               /* DTCNT1 */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXPWM_SUB3_DTCNT1_tag;

typedef union FLEXPWM_SUB3_CAPTCTRLX_union_tag { /* Submodule n Capture Control X Register */
  vuint16_t R;
  struct {
    vuint16_t ARMX:1;                  /* ARMX */
    vuint16_t ONESHOTX:1;              /* ONESHOTX */
    vuint16_t EDGX0:2;                 /* EDGX0 */
    vuint16_t EDGX1:2;                 /* EDGX1 */
    vuint16_t INPSELX:1;               /* INPSELX */
    vuint16_t EDGCNTX_EN:1;            /* EDGCNTX_EN */
    vuint16_t CFXWM:2;                 /* Capture X FIFOs Watermark */
    vuint16_t CX0CNT:3;                /* CX0CNT */
    vuint16_t CX1CNT:3;                /* CX1CNT */
  } B;
} FLEXPWM_SUB3_CAPTCTRLX_tag;

typedef union FLEXPWM_SUB3_CAPTCMPX_union_tag { /* Submodule n Capture Compare X Register */
  vuint16_t R;
  struct {
    vuint16_t EDGCMPX:8;               /* EDGCMPX */
    vuint16_t EDGCNTX:8;               /* EDGCNTX */
  } B;
} FLEXPWM_SUB3_CAPTCMPX_tag;

typedef union FLEXPWM_SUB3_CVAL0_union_tag { /* Submodule n Capture Value 0 Register */
  vuint16_t R;
  struct {
    vuint16_t CAPTVAL0:16;             /* CAPTVAL0 */
  } B;
} FLEXPWM_SUB3_CVAL0_tag;

typedef union FLEXPWM_SUB3_CVAL0CYC_union_tag { /* Submodule n Capture Value 0 Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t CVAL0CYC:3;              /* CVAL0 Cycle */
    vuint16_t _unused_3:13;            /* Reserved */
  } B;
} FLEXPWM_SUB3_CVAL0CYC_tag;

typedef union FLEXPWM_SUB3_CVAL1_union_tag { /* Submodule n Capture Value 1 Register */
  vuint16_t R;
  struct {
    vuint16_t CAPTVAL1:16;             /* CAPTVAL1 */
  } B;
} FLEXPWM_SUB3_CVAL1_tag;

typedef union FLEXPWM_SUB3_CVAL1CYC_union_tag { /* Submodule n Capture Value 1 Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t CVAL1CYC:3;              /* CVAL1 Cycle */
    vuint16_t _unused_3:13;            /* Reserved */
  } B;
} FLEXPWM_SUB3_CVAL1CYC_tag;

typedef union FLEXPWM_OUTEN_union_tag { /* Output Enable Register */
  vuint16_t R;
  struct {
    vuint16_t PWMX_EN:4;               /* PWMX_EN */
    vuint16_t PWMB_EN:4;               /* PWMB_EN */
    vuint16_t PWMA_EN:4;               /* PWMA_EN */
    vuint16_t _unused_12:4;            /* Reserved */
  } B;
} FLEXPWM_OUTEN_tag;

typedef union FLEXPWM_MASK_union_tag { /* Mask Register */
  vuint16_t R;
  struct {
    vuint16_t MASKX:4;                 /* MASKX */
    vuint16_t MASKB:4;                 /* MASKB */
    vuint16_t MASKA:4;                 /* MASKA */
    vuint16_t UPDATE_MASK:4;           /* Update Mask */
  } B;
} FLEXPWM_MASK_tag;

typedef union FLEXPWM_SWCOUT_union_tag { /* Software Controlled Output Register */
  vuint16_t R;
  struct {
    vuint16_t OUT45_0:1;               /* OUT45_0 */
    vuint16_t OUT23_0:1;               /* OUT23_0 */
    vuint16_t OUT45_1:1;               /* OUT45_1 */
    vuint16_t OUT23_1:1;               /* OUT23_1 */
    vuint16_t OUT45_2:1;               /* OUT45_2 */
    vuint16_t OUT23_2:1;               /* OUT23_2 */
    vuint16_t OUT45_3:1;               /* OUT45_3 */
    vuint16_t OUT23_3:1;               /* OUT23_3 */
    vuint16_t _unused_8:8;             /* Reserved */
  } B;
} FLEXPWM_SWCOUT_tag;

typedef union FLEXPWM_DTSRCSEL_union_tag { /* Deadtime Source Select Register */
  vuint16_t R;
  struct {
    vuint16_t SEL45_0:2;               /* SEL45_0 */
    vuint16_t SEL23_0:2;               /* SEL23_0 */
    vuint16_t SEL45_1:2;               /* SEL45_1 */
    vuint16_t SEL23_1:2;               /* SEL23_1 */
    vuint16_t SEL45_2:2;               /* SEL45_2 */
    vuint16_t SEL23_2:2;               /* SEL23_2 */
    vuint16_t SEL45_3:2;               /* SEL45_3 */
    vuint16_t SEL23_3:2;               /* SEL23_3 */
  } B;
} FLEXPWM_DTSRCSEL_tag;

typedef union FLEXPWM_MCTRL_union_tag { /* Master Control Register */
  vuint16_t R;
  struct {
    vuint16_t LDOK:4;                  /* Load Okay */
    vuint16_t CLDOK:4;                 /* Clear Load Okay */
    vuint16_t RUN:4;                   /* Run */
    vuint16_t IPOL:4;                  /* Current Polarity */
  } B;
} FLEXPWM_MCTRL_tag;

typedef union FLEXPWM_FCTRL_union_tag { /* Fault Control Register */
  vuint16_t R;
  struct {
    vuint16_t FIE:4;                   /* FIE */
    vuint16_t FSAFE:4;                 /* FSAFE */
    vuint16_t FAUTO:4;                 /* FAUTO */
    vuint16_t FLVL:4;                  /* FLVL */
  } B;
} FLEXPWM_FCTRL_tag;

typedef union FLEXPWM_FSTS_union_tag { /* Fault Status Register */
  vuint16_t R;
  struct {
    vuint16_t FFLAG:4;                 /* FFLAG */
    vuint16_t FFULL:4;                 /* FFULL */
    vuint16_t FFPIN:4;                 /* FFPIN */
    vuint16_t FTEST:1;                 /* FTEST */
    vuint16_t _unused_13:3;            /* Reserved */
  } B;
} FLEXPWM_FSTS_tag;

typedef union FLEXPWM_FFILT_union_tag { /* Fault Filter Register */
  vuint16_t R;
  struct {
    vuint16_t FILT_PER:8;              /* FILT_PER */
    vuint16_t FILT_CNT:3;              /* FILT_CNT */
    vuint16_t _unused_11:4;            /* Reserved */
    vuint16_t GSTR:1;                  /* GSTR */
  } B;
} FLEXPWM_FFILT_tag;

typedef union FLEXPWM_FCTRL2_union_tag { /* Fault Control 2 Register */
  vuint16_t R;
  struct {
    vuint16_t NOCOMB:4;                /* No combinational path from fault inputs to PWM outputs */
    vuint16_t _unused_4:12;            /* Reserved */
  } B;
} FLEXPWM_FCTRL2_tag;

struct FLEXPWM_tag {
  FLEXPWM_SUB0_CNT_tag SUB0_CNT;       /* Submodule n Counter Register */
  FLEXPWM_SUB0_INIT_tag SUB0_INIT;     /* Submodule n Initial Count Register */
  FLEXPWM_SUB0_CTRL2_tag SUB0_CTRL2;   /* Submodule n Control 2 Register */
  FLEXPWM_SUB0_CTRL1_tag SUB0_CTRL1;   /* Submodule n Control 1 Register */
  FLEXPWM_SUB0_VAL0_tag SUB0_VAL0;     /* Submodule n Value Register 0 */
  FLEXPWM_SUB0_VAL1_tag SUB0_VAL1;     /* Submodule n Value Register 1 */
  FLEXPWM_SUB0_VAL2_tag SUB0_VAL2;     /* Submodule n Value Register 2 */
  FLEXPWM_SUB0_VAL3_tag SUB0_VAL3;     /* Submodule n Value Register 3 */
  FLEXPWM_SUB0_VAL4_tag SUB0_VAL4;     /* Submodule n Value Register 4 */
  FLEXPWM_SUB0_VAL5_tag SUB0_VAL5;     /* Submodule n Value Register 5 */
  uint8_t FLEXPWM_reserved0[4];
  FLEXPWM_SUB0_OCTRL_tag SUB0_OCTRL;   /* Submodule n Output Control Register */
  FLEXPWM_SUB0_STS_tag SUB0_STS;       /* Submodule n Status Register */
  FLEXPWM_SUB0_INTEN_tag SUB0_INTEN;   /* Submodule n Interrupt Enable Register */
  FLEXPWM_SUB0_DMAEN_tag SUB0_DMAEN;   /* Submodule n DMA Enable Register */
  FLEXPWM_SUB0_TCTRL_tag SUB0_TCTRL;   /* Submodule n Output Trigger Control Register */
  FLEXPWM_SUB0_DISMAP_tag SUB0_DISMAP; /* Submodule n Fault Disable Mapping Register */
  FLEXPWM_SUB0_DTCNT0_tag SUB0_DTCNT0; /* Submodule n Deadtime Count Register 0 */
  FLEXPWM_SUB0_DTCNT1_tag SUB0_DTCNT1; /* Submodule n Deadtime Count Register 1 */
  uint8_t FLEXPWM_reserved1[8];
  FLEXPWM_SUB0_CAPTCTRLX_tag SUB0_CAPTCTRLX; /* Submodule n Capture Control X Register */
  FLEXPWM_SUB0_CAPTCMPX_tag SUB0_CAPTCMPX; /* Submodule n Capture Compare X Register */
  FLEXPWM_SUB0_CVAL0_tag SUB0_CVAL0;   /* Submodule n Capture Value 0 Register */
  FLEXPWM_SUB0_CVAL0CYC_tag SUB0_CVAL0CYC; /* Submodule n Capture Value 0 Cycle Register */
  FLEXPWM_SUB0_CVAL1_tag SUB0_CVAL1;   /* Submodule n Capture Value 1 Register */
  FLEXPWM_SUB0_CVAL1CYC_tag SUB0_CVAL1CYC; /* Submodule n Capture Value 1 Cycle Register */
  uint8_t FLEXPWM_reserved2[20];
  FLEXPWM_SUB1_CNT_tag SUB1_CNT;       /* Submodule n Counter Register */
  FLEXPWM_SUB1_INIT_tag SUB1_INIT;     /* Submodule n Initial Count Register */
  FLEXPWM_SUB1_CTRL2_tag SUB1_CTRL2;   /* Submodule n Control 2 Register */
  FLEXPWM_SUB1_CTRL1_tag SUB1_CTRL1;   /* Submodule n Control 1 Register */
  FLEXPWM_SUB1_VAL0_tag SUB1_VAL0;     /* Submodule n Value Register 0 */
  FLEXPWM_SUB1_VAL1_tag SUB1_VAL1;     /* Submodule n Value Register 1 */
  FLEXPWM_SUB1_VAL2_tag SUB1_VAL2;     /* Submodule n Value Register 2 */
  FLEXPWM_SUB1_VAL3_tag SUB1_VAL3;     /* Submodule n Value Register 3 */
  FLEXPWM_SUB1_VAL4_tag SUB1_VAL4;     /* Submodule n Value Register 4 */
  FLEXPWM_SUB1_VAL5_tag SUB1_VAL5;     /* Submodule n Value Register 5 */
  uint8_t FLEXPWM_reserved3[4];
  FLEXPWM_SUB1_OCTRL_tag SUB1_OCTRL;   /* Submodule n Output Control Register */
  FLEXPWM_SUB1_STS_tag SUB1_STS;       /* Submodule n Status Register */
  FLEXPWM_SUB1_INTEN_tag SUB1_INTEN;   /* Submodule n Interrupt Enable Register */
  FLEXPWM_SUB1_DMAEN_tag SUB1_DMAEN;   /* Submodule n DMA Enable Register */
  FLEXPWM_SUB1_TCTRL_tag SUB1_TCTRL;   /* Submodule n Output Trigger Control Register */
  FLEXPWM_SUB1_DISMAP_tag SUB1_DISMAP; /* Submodule n Fault Disable Mapping Register */
  FLEXPWM_SUB1_DTCNT0_tag SUB1_DTCNT0; /* Submodule n Deadtime Count Register 0 */
  FLEXPWM_SUB1_DTCNT1_tag SUB1_DTCNT1; /* Submodule n Deadtime Count Register 1 */
  uint8_t FLEXPWM_reserved4[8];
  FLEXPWM_SUB1_CAPTCTRLX_tag SUB1_CAPTCTRLX; /* Submodule n Capture Control X Register */
  FLEXPWM_SUB1_CAPTCMPX_tag SUB1_CAPTCMPX; /* Submodule n Capture Compare X Register */
  FLEXPWM_SUB1_CVAL0_tag SUB1_CVAL0;   /* Submodule n Capture Value 0 Register */
  FLEXPWM_SUB1_CVAL0CYC_tag SUB1_CVAL0CYC; /* Submodule n Capture Value 0 Cycle Register */
  FLEXPWM_SUB1_CVAL1_tag SUB1_CVAL1;   /* Submodule n Capture Value 1 Register */
  FLEXPWM_SUB1_CVAL1CYC_tag SUB1_CVAL1CYC; /* Submodule n Capture Value 1 Cycle Register */
  uint8_t FLEXPWM_reserved5[20];
  FLEXPWM_SUB2_CNT_tag SUB2_CNT;       /* Submodule n Counter Register */
  FLEXPWM_SUB2_INIT_tag SUB2_INIT;     /* Submodule n Initial Count Register */
  FLEXPWM_SUB2_CTRL2_tag SUB2_CTRL2;   /* Submodule n Control 2 Register */
  FLEXPWM_SUB2_CTRL1_tag SUB2_CTRL1;   /* Submodule n Control 1 Register */
  FLEXPWM_SUB2_VAL0_tag SUB2_VAL0;     /* Submodule n Value Register 0 */
  FLEXPWM_SUB2_VAL1_tag SUB2_VAL1;     /* Submodule n Value Register 1 */
  FLEXPWM_SUB2_VAL2_tag SUB2_VAL2;     /* Submodule n Value Register 2 */
  FLEXPWM_SUB2_VAL3_tag SUB2_VAL3;     /* Submodule n Value Register 3 */
  FLEXPWM_SUB2_VAL4_tag SUB2_VAL4;     /* Submodule n Value Register 4 */
  FLEXPWM_SUB2_VAL5_tag SUB2_VAL5;     /* Submodule n Value Register 5 */
  uint8_t FLEXPWM_reserved6[4];
  FLEXPWM_SUB2_OCTRL_tag SUB2_OCTRL;   /* Submodule n Output Control Register */
  FLEXPWM_SUB2_STS_tag SUB2_STS;       /* Submodule n Status Register */
  FLEXPWM_SUB2_INTEN_tag SUB2_INTEN;   /* Submodule n Interrupt Enable Register */
  FLEXPWM_SUB2_DMAEN_tag SUB2_DMAEN;   /* Submodule n DMA Enable Register */
  FLEXPWM_SUB2_TCTRL_tag SUB2_TCTRL;   /* Submodule n Output Trigger Control Register */
  FLEXPWM_SUB2_DISMAP_tag SUB2_DISMAP; /* Submodule n Fault Disable Mapping Register */
  FLEXPWM_SUB2_DTCNT0_tag SUB2_DTCNT0; /* Submodule n Deadtime Count Register 0 */
  FLEXPWM_SUB2_DTCNT1_tag SUB2_DTCNT1; /* Submodule n Deadtime Count Register 1 */
  uint8_t FLEXPWM_reserved7[8];
  FLEXPWM_SUB2_CAPTCTRLX_tag SUB2_CAPTCTRLX; /* Submodule n Capture Control X Register */
  FLEXPWM_SUB2_CAPTCMPX_tag SUB2_CAPTCMPX; /* Submodule n Capture Compare X Register */
  FLEXPWM_SUB2_CVAL0_tag SUB2_CVAL0;   /* Submodule n Capture Value 0 Register */
  FLEXPWM_SUB2_CVAL0CYC_tag SUB2_CVAL0CYC; /* Submodule n Capture Value 0 Cycle Register */
  FLEXPWM_SUB2_CVAL1_tag SUB2_CVAL1;   /* Submodule n Capture Value 1 Register */
  FLEXPWM_SUB2_CVAL1CYC_tag SUB2_CVAL1CYC; /* Submodule n Capture Value 1 Cycle Register */
  uint8_t FLEXPWM_reserved8[20];
  FLEXPWM_SUB3_CNT_tag SUB3_CNT;       /* Submodule n Counter Register */
  FLEXPWM_SUB3_INIT_tag SUB3_INIT;     /* Submodule n Initial Count Register */
  FLEXPWM_SUB3_CTRL2_tag SUB3_CTRL2;   /* Submodule n Control 2 Register */
  FLEXPWM_SUB3_CTRL1_tag SUB3_CTRL1;   /* Submodule n Control 1 Register */
  FLEXPWM_SUB3_VAL0_tag SUB3_VAL0;     /* Submodule n Value Register 0 */
  FLEXPWM_SUB3_VAL1_tag SUB3_VAL1;     /* Submodule n Value Register 1 */
  FLEXPWM_SUB3_VAL2_tag SUB3_VAL2;     /* Submodule n Value Register 2 */
  FLEXPWM_SUB3_VAL3_tag SUB3_VAL3;     /* Submodule n Value Register 3 */
  FLEXPWM_SUB3_VAL4_tag SUB3_VAL4;     /* Submodule n Value Register 4 */
  FLEXPWM_SUB3_VAL5_tag SUB3_VAL5;     /* Submodule n Value Register 5 */
  uint8_t FLEXPWM_reserved9[4];
  FLEXPWM_SUB3_OCTRL_tag SUB3_OCTRL;   /* Submodule n Output Control Register */
  FLEXPWM_SUB3_STS_tag SUB3_STS;       /* Submodule n Status Register */
  FLEXPWM_SUB3_INTEN_tag SUB3_INTEN;   /* Submodule n Interrupt Enable Register */
  FLEXPWM_SUB3_DMAEN_tag SUB3_DMAEN;   /* Submodule n DMA Enable Register */
  FLEXPWM_SUB3_TCTRL_tag SUB3_TCTRL;   /* Submodule n Output Trigger Control Register */
  FLEXPWM_SUB3_DISMAP_tag SUB3_DISMAP; /* Submodule n Fault Disable Mapping Register */
  FLEXPWM_SUB3_DTCNT0_tag SUB3_DTCNT0; /* Submodule n Deadtime Count Register 0 */
  FLEXPWM_SUB3_DTCNT1_tag SUB3_DTCNT1; /* Submodule n Deadtime Count Register 1 */
  uint8_t FLEXPWM_reserved10[8];
  FLEXPWM_SUB3_CAPTCTRLX_tag SUB3_CAPTCTRLX; /* Submodule n Capture Control X Register */
  FLEXPWM_SUB3_CAPTCMPX_tag SUB3_CAPTCMPX; /* Submodule n Capture Compare X Register */
  FLEXPWM_SUB3_CVAL0_tag SUB3_CVAL0;   /* Submodule n Capture Value 0 Register */
  FLEXPWM_SUB3_CVAL0CYC_tag SUB3_CVAL0CYC; /* Submodule n Capture Value 0 Cycle Register */
  FLEXPWM_SUB3_CVAL1_tag SUB3_CVAL1;   /* Submodule n Capture Value 1 Register */
  FLEXPWM_SUB3_CVAL1CYC_tag SUB3_CVAL1CYC; /* Submodule n Capture Value 1 Cycle Register */
  uint8_t FLEXPWM_reserved11[20];
  FLEXPWM_OUTEN_tag OUTEN;             /* Output Enable Register */
  FLEXPWM_MASK_tag MASK;               /* Mask Register */
  FLEXPWM_SWCOUT_tag SWCOUT;           /* Software Controlled Output Register */
  FLEXPWM_DTSRCSEL_tag DTSRCSEL;       /* Deadtime Source Select Register */
  FLEXPWM_MCTRL_tag MCTRL;             /* Master Control Register */
  uint8_t FLEXPWM_reserved12[2];
  FLEXPWM_FCTRL_tag FCTRL;             /* Fault Control Register */
  FLEXPWM_FSTS_tag FSTS;               /* Fault Status Register */
  FLEXPWM_FFILT_tag FFILT;             /* Fault Filter Register */
  FLEXPWM_FCTRL2_tag FCTRL2;           /* Fault Control 2 Register */
};


/* ============================================================================
   =============================== Module: FLEXRAY ============================
   ============================================================================ */

typedef union FLEXRAY_MVR_union_tag {  /* Module Version Register */
  vuint16_t R;
  struct {
    vuint16_t PEVER:8;                 /* PE Version Number */
    vuint16_t CHIVER:8;                /* CHI Version Number */
  } B;
} FLEXRAY_MVR_tag;

typedef union FLEXRAY_MCR_union_tag {  /* Module Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:1;             /* Reserved */
    vuint16_t BITRATE:3;
    vuint16_t CLKSEL:1;                /* Protocol Engine Clock Source Select */
    vuint16_t _unused_5:1;             /* Reserved */
    vuint16_t FAM:1;                   /* FIFO Address Mode */
    vuint16_t FUM:1;                   /* FIFO Update Mode */
    vuint16_t _unused_8:1;             /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
    vuint16_t ECCE:1;                  /* ECC Functionality Enable */
    vuint16_t SFFE:1;                  /* Synchronization Frame Filter Enable */
    vuint16_t CHA:1;                   /* Channel A Enable */
    vuint16_t CHB:1;                   /* Channel B Enable */
    vuint16_t SCM:1;                   /* Single Channel Device Mode */
    vuint16_t SBFF:1;                  /* System Bus Failure Freeze */
    vuint16_t MEN:1;                   /* Module Enable */
  } B;
} FLEXRAY_MCR_tag;

typedef union FLEXRAY_SYMBADHR_union_tag { /* System Memory Base Address High Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:16;                 /* System Memory Base Address high */
  } B;
} FLEXRAY_SYMBADHR_tag;

typedef union FLEXRAY_SYMBADLR_union_tag { /* System Memory Base Address Low Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:4;             /* Reserved */
    vuint16_t SMBA:12;                 /* System Memory Base Address low */
  } B;
} FLEXRAY_SYMBADLR_tag;

typedef union FLEXRAY_STBSCR_union_tag { /* Strobe Signal Control Register */
  vuint16_t R;
  struct {
    vuint16_t STBPSEL:2;               /* Strobe Port Select */
    vuint16_t _unused_2:2;             /* Reserved */
    vuint16_t ENB:1;                   /* Strobe Signal Enable */
    vuint16_t _unused_5:3;             /* Reserved */
    vuint16_t SEL:4;                   /* Strobe Signal Select */
    vuint16_t _unused_12:3;            /* Reserved */
    vuint16_t WMD:1;                   /* Write Mode */
  } B;
} FLEXRAY_STBSCR_tag;

typedef union FLEXRAY_MBDSR_union_tag { /* Message Buffer Data Size Register */
  vuint16_t R;
  struct {
    vuint16_t MBSEG1DS:7;              /* Message Buffer Segment 1 Data Size */
    vuint16_t _unused_7:1;             /* Reserved */
    vuint16_t MBSEG2DS:7;              /* Message Buffer Segment 2 Data Size */
    vuint16_t _unused_15:1;            /* Reserved */
  } B;
} FLEXRAY_MBDSR_tag;

typedef union FLEXRAY_MBSSUTR_union_tag { /* Message Buffer Segment Size and Utilization Register */
  vuint16_t R;
  struct {
    vuint16_t LAST_MB_UTIL:8;          /* Last Message Buffer Utilized */
    vuint16_t LAST_MB_SEG1:8;          /* Last Message Buffer In Segment 1 */
  } B;
} FLEXRAY_MBSSUTR_tag;

typedef union FLEXRAY_PEDRAR_union_tag { /* PE DRAM Access Register */
  vuint16_t R;
  struct {
    vuint16_t DAD:1;
    vuint16_t ADDR:11;
    vuint16_t INST:4;
  } B;
} FLEXRAY_PEDRAR_tag;

typedef union FLEXRAY_PEDRDR_union_tag { /* PE DRAM Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FLEXRAY_PEDRDR_tag;

typedef union FLEXRAY_POCR_union_tag { /* Protocol Operation Control Register */
  vuint16_t R;
  struct {
    vuint16_t POCCMD:4;                /* Protocol Control Command */
    vuint16_t _unused_4:3;             /* Reserved */
    vuint16_t BSY_WMC:1;
    vuint16_t ERC_AP:2;                /* External Rate Correction Application */
    vuint16_t EOC_AP:2;                /* External Offset Correction Application */
    vuint16_t _unused_12:3;            /* Reserved */
    vuint16_t WME:1;                   /* Write Mode External Correction */
  } B;
} FLEXRAY_POCR_tag;

typedef union FLEXRAY_GIFER_union_tag { /* Global Interrupt Flag and Enable Register */
  vuint16_t R;
  struct {
    vuint16_t TBIE:1;                  /* Transmit Message Buffer Interrupt Enable */
    vuint16_t RBIE:1;                  /* Receive Message Buffer Interrupt Enable */
    vuint16_t FAFAIE:1;                /* Receive FIFO Channel A Almost Full Interrupt Enable */
    vuint16_t FAFBIE:1;                /* Receive FIFO Channel B Almost Full Interrupt Enable */
    vuint16_t WUPIE:1;                 /* Wakeup Interrupt Enable */
    vuint16_t CHIE:1;                  /* CHI Interrupt Enable */
    vuint16_t PRIE:1;                  /* Protocol Interrupt Enable */
    vuint16_t MIE:1;                   /* Module Interrupt Enable */
    vuint16_t TBIF:1;                  /* Transmit Message Buffer Interrupt Flag */
    vuint16_t RBIF:1;                  /* Receive Message Buffer Interrupt Flag */
    vuint16_t FAFAIF:1;                /* Receive FIFO Channel A Almost Full Interrupt Flag */
    vuint16_t FAFBIF:1;                /* Receive FIFO Channel B Almost Full Interrupt Flag */
    vuint16_t WUPIF:1;                 /* Wakeup Interrupt Flag */
    vuint16_t CHIF:1;                  /* CHI Interrupt Flag */
    vuint16_t PRIF:1;                  /* Protocol Interrupt Flag */
    vuint16_t MIF:1;                   /* Module Interrupt Flag */
  } B;
} FLEXRAY_GIFER_tag;

typedef union FLEXRAY_PIFR0_union_tag { /* Protocol Interrupt Flag Register 0 */
  vuint16_t R;
  struct {
    vuint16_t CYS_IF:1;                /* Cycle Start Interrupt Flag */
    vuint16_t TI1_IF:1;                /* Timer 1 Expired Interrupt Flag */
    vuint16_t TI2_IF:1;                /* Timer 2 Expired Interrupt Flag */
    vuint16_t TBVA_IF:1;               /* Transmission across boundary on channel A Interrupt Flag */
    vuint16_t TBVB_IF:1;               /* Transmission across boundary on channel B Interrupt Flag */
    vuint16_t LTXA_IF:1;               /* pLatestTx Violation on Channel A Interrupt Flag */
    vuint16_t LTXB_IF:1;               /* pLatestTx Violation on Channel B Interrupt Flag */
    vuint16_t MTX_IF:1;                /* Media Access Test Symbol Received Interrupt Flag */
    vuint16_t MXS_IF:1;                /* Max Sync Frames Detected Interrupt Flag */
    vuint16_t CCL_IF:1;                /* Clock Correction Limit Reached Interrupt Flag */
    vuint16_t MOC_IF:1;                /* Missing Offset Correction Interrupt Flag */
    vuint16_t MRC_IF:1;                /* Missing Rate Correction Interrupt Flag */
    vuint16_t CSA_IF:1;                /* Cold Start Abort Interrupt Flag */
    vuint16_t ILCF_IF:1;               /* Illegal Protocol Configuration Interrupt Flag */
    vuint16_t INTL_IF:1;               /* Internal Protocol Error Interrupt Flag */
    vuint16_t FATL_IF:1;               /* Fatal Protocol Error Interrupt Flag */
  } B;
} FLEXRAY_PIFR0_tag;

typedef union FLEXRAY_PIFR1_union_tag { /* Protocol Interrupt Flag Register 1 */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:4;             /* Reserved */
    vuint16_t ODT_IF:1;                /* Odd Cycle Table Written Interrupt Flag */
    vuint16_t EVT_IF:1;                /* Even Cycle Table Written Interrupt Flag */
    vuint16_t _unused_6:2;             /* Reserved */
    vuint16_t SSI0_IF:1;               /* Slot Status Counter Incremented Interrupt Flag */
    vuint16_t SSI1_IF:1;               /* Slot Status Counter Incremented Interrupt Flag */
    vuint16_t SSI2_IF:1;               /* Slot Status Counter Incremented Interrupt Flag */
    vuint16_t SSI3_IF:1;               /* Slot Status Counter Incremented Interrupt Flag */
    vuint16_t PSC_IF:1;                /* Protocol State Changed Interrupt Flag */
    vuint16_t PECF_IF:1;               /* Protocol Engine Communication Failure Interrupt Flag */
    vuint16_t IPC_IF:1;                /* Illegal Protocol Control Command Interrupt Flag */
    vuint16_t EMC_IF:1;                /* Error Mode Changed Interrupt Flag */
  } B;
} FLEXRAY_PIFR1_tag;

typedef union FLEXRAY_PIER0_union_tag { /* Protocol Interrupt Enable Register 0 */
  vuint16_t R;
  struct {
    vuint16_t CYS_IE:1;                /* Cycle Start Interrupt Enable */
    vuint16_t TI1_IE:1;                /* Timer 1 Expired Interrupt Enable */
    vuint16_t TI2_IE:1;                /* Timer 2 Expired Interrupt Enable */
    vuint16_t TBVA_IE:1;               /* Transmission across boundary on channel A Interrupt Enable */
    vuint16_t TBVB_IE:1;               /* Transmission across boundary on channel B Interrupt Enable */
    vuint16_t LTXA_IE:1;               /* pLatestTx Violation on Channel A Interrupt Enable */
    vuint16_t LTXB_IE:1;               /* pLatestTx Violation on Channel B Interrupt Enable */
    vuint16_t MTX_IE:1;                /* Media Access Test Symbol Received Interrupt Enable */
    vuint16_t MXS_IE:1;                /* Max Sync Frames Detected Interrupt Enable */
    vuint16_t CCL_IE:1;                /* Clock Correction Limit Reached Interrupt Enable */
    vuint16_t MOC_IE:1;                /* Missing Offset Correction Interrupt Enable */
    vuint16_t MRC_IE:1;                /* Missing Rate Correction Interrupt Enable */
    vuint16_t CSA_IE:1;                /* Cold Start Abort Interrupt Enable */
    vuint16_t ILCF_IE:1;               /* Illegal Protocol Configuration Interrupt Enable */
    vuint16_t INTL_IE:1;               /* Internal Protocol Error Interrupt Enable */
    vuint16_t FATL_IE:1;               /* Fatal Protocol Error Interrupt Enable */
  } B;
} FLEXRAY_PIER0_tag;

typedef union FLEXRAY_PIER1_union_tag { /* Protocol Interrupt Enable Register 1 */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:4;             /* Reserved */
    vuint16_t ODT_IE:1;                /* Odd Cycle Table Written Interrupt Enable */
    vuint16_t EVT_IE:1;                /* Even Cycle Table Written Interrupt Enable */
    vuint16_t _unused_6:2;             /* Reserved */
    vuint16_t SSI0_IE:1;               /* Slot Status Counter Incremented Interrupt Enable */
    vuint16_t SSI1_IE:1;               /* Slot Status Counter Incremented Interrupt Enable */
    vuint16_t SSI2_IE:1;               /* Slot Status Counter Incremented Interrupt Enable */
    vuint16_t SSI3_IE:1;               /* Slot Status Counter Incremented Interrupt Enable */
    vuint16_t PSC_IE:1;                /* Protocol State Changed Interrupt Enable */
    vuint16_t PECF_IE:1;               /* Protocol Engine Communication Failure Interrupt Enable */
    vuint16_t IPC_IE:1;                /* Illegal Protocol Control Command Interrupt Enable */
    vuint16_t EMC_IE:1;                /* Error Mode Changed Interrupt Enable */
  } B;
} FLEXRAY_PIER1_tag;

typedef union FLEXRAY_CHIERFR_union_tag { /* CHI Error Flag Register */
  vuint16_t R;
  struct {
    vuint16_t ILSA_EF:1;               /* Illegal System Bus Address Error Flag */
    vuint16_t NMF_EF:1;                /* Network Management Frame Error Flag */
    vuint16_t NML_EF:1;                /* Network Management Length Error Flag */
    vuint16_t SPL_EF:1;                /* Static Payload Length Error Flag */
    vuint16_t DPL_EF:1;                /* Dynamic Payload Length Error Flag */
    vuint16_t FID_EF:1;                /* Frame ID Error Flag */
    vuint16_t SBCF_EF:1;               /* System Bus Communication Failure Error Flag */
    vuint16_t _unused_7:1;             /* Reserved */
    vuint16_t LCK_EF:1;                /* Lock Error Flag */
    vuint16_t MBU_EF:1;                /* Message Buffer Utilization Error Flag */
    vuint16_t MBS_EF:1;                /* Message Buffer Search Error Flag */
    vuint16_t FOVA_EF:1;               /* Receive FIFO Overrun Channel A Error Flag */
    vuint16_t FOVB_EF:1;               /* Receive FIFO Overrun Channel B Error Flag */
    vuint16_t PCMI_EF:1;               /* Protocol Command Ignored Error Flag */
    vuint16_t FRLA_EF:1;               /* Frame Lost Channel A Error Flag */
    vuint16_t FRLB_EF:1;               /* Frame Lost Channel B Error Flag */
  } B;
} FLEXRAY_CHIERFR_tag;

typedef union FLEXRAY_MBIVEC_union_tag { /* Message Buffer Interrupt Vector Register */
  vuint16_t R;
  struct {
    vuint16_t RBIVEC:8;                /* Receive Buffer Interrupt Vector */
    vuint16_t TBIVEC:8;                /* Transmit Buffer Interrupt Vector */
  } B;
} FLEXRAY_MBIVEC_tag;

typedef union FLEXRAY_CASERCR_union_tag { /* Channel A Status Error Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CHAERSCNT:16;            /* Channel A Status Error Counter */
  } B;
} FLEXRAY_CASERCR_tag;

typedef union FLEXRAY_CBSERCR_union_tag { /* Channel B Status Error Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CHBERSCNT:16;            /* Channel B Status Error Counter */
  } B;
} FLEXRAY_CBSERCR_tag;

typedef union FLEXRAY_PSR0_union_tag { /* Protocol Status Register 0 */
  vuint16_t R;
  struct {
    vuint16_t WAKEUPSTATUS:3;          /* Wakeup Status */
    vuint16_t _unused_3:1;             /* Reserved */
    vuint16_t STARTUPSTATE:4;          /* Startup State */
    vuint16_t PROTSTATE:3;             /* Protocol State */
    vuint16_t _unused_11:1;            /* Reserved */
    vuint16_t SLOTMODE:2;              /* Slot Mode */
    vuint16_t ERRMODE:2;               /* Error Mode */
  } B;
} FLEXRAY_PSR0_tag;

typedef union FLEXRAY_PSR1_union_tag { /* Protocol Status Register 1 */
  vuint16_t R;
  struct {
    vuint16_t APTAC:5;                 /* Allow Passive to Active Counter */
    vuint16_t FRZ:1;                   /* Freeze Occurred */
    vuint16_t HHR:1;                   /* Host Halt Request Pending */
    vuint16_t CPN:1;                   /* Leading Cold Start Path Noise */
    vuint16_t REMCSAT:5;               /* Remaining Coldstart Attempts */
    vuint16_t _unused_13:1;            /* Reserved */
    vuint16_t CSP:1;                   /* Leading Cold Start Path */
    vuint16_t CSAA:1;                  /* Cold Start Attempt Aborted Flag */
  } B;
} FLEXRAY_PSR1_tag;

typedef union FLEXRAY_PSR2_union_tag { /* Protocol Status Register 2 */
  vuint16_t R;
  struct {
    vuint16_t CKCORFCNT:4;             /* Clock Correction Failed Counter */
    vuint16_t MTA:1;                   /* Media Access Test Symbol MTS Received on Channel A */
    vuint16_t SSEA:1;                  /* Symbol Window Syntax Error on Channel A */
    vuint16_t SBVA:1;                  /* Symbol Window Boundary Violation on Channel A */
    vuint16_t STCA:1;                  /* Symbol Window Transmit Conflict on Channel A */
    vuint16_t NSEA:1;                  /* NIT Syntax Error on Channel A */
    vuint16_t NBVA:1;                  /* NIT Boundary Violation on Channel A */
    vuint16_t MTB:1;                   /* Media Access Test Symbol MTS Received on Channel B */
    vuint16_t SSEB:1;                  /* Symbol Window Syntax Error on Channel B */
    vuint16_t SBVB:1;                  /* Symbol Window Boundary Violation on Channel B */
    vuint16_t STCB:1;                  /* Symbol Window Transmit Conflict on Channel B */
    vuint16_t NSEB:1;                  /* NIT Syntax Error on Channel B */
    vuint16_t NBVB:1;                  /* NIT Boundary Violation on Channel B */
  } B;
} FLEXRAY_PSR2_tag;

typedef union FLEXRAY_PSR3_union_tag { /* Protocol Status Register 3 */
  vuint16_t R;
  struct {
    vuint16_t AVFA:1;                  /* Aggregated Valid Frame on Channel A */
    vuint16_t ASEA:1;                  /* Aggregated Syntax Error on Channel A */
    vuint16_t ACEA:1;                  /* Aggregated Content Error on Channel A */
    vuint16_t AACA:1;                  /* Aggregated Additional Communication on Channel A */
    vuint16_t ABVA:1;                  /* Aggregated Boundary Violation on Channel A */
    vuint16_t WUA:1;                   /* Wakeup Symbol Received on Channel A */
    vuint16_t _unused_6:2;             /* Reserved */
    vuint16_t AVFB:1;                  /* Aggregated Valid Frame on Channel B */
    vuint16_t ASEB:1;                  /* Aggregated Syntax Error on Channel B */
    vuint16_t ACEB:1;                  /* Aggregated Content Error on Channel B */
    vuint16_t AACB:1;                  /* Aggregated Additional Communication on Channel B */
    vuint16_t ABVB:1;                  /* Aggregated Boundary Violation on Channel B */
    vuint16_t WUB:1;                   /* Wakeup Symbol Received on Channel B */
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} FLEXRAY_PSR3_tag;

typedef union FLEXRAY_MTCTR_union_tag { /* Macrotick Counter Register */
  vuint16_t R;
  struct {
    vuint16_t MTCT:14;                 /* Macrotick Counter */
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} FLEXRAY_MTCTR_tag;

typedef union FLEXRAY_CYCTR_union_tag { /* Cycle Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CYCCNT:6;                /* Cycle Counter */
    vuint16_t _unused_6:10;            /* Reserved */
  } B;
} FLEXRAY_CYCTR_tag;

typedef union FLEXRAY_SLTCTAR_union_tag { /* Slot Counter Channel A Register */
  vuint16_t R;
  struct {
    vuint16_t SLOTCNTA:11;             /* Slot Counter Value for Channel A */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXRAY_SLTCTAR_tag;

typedef union FLEXRAY_SLTCTBR_union_tag { /* Slot Counter Channel B Register */
  vuint16_t R;
  struct {
    vuint16_t SLOTCNTB:11;             /* Slot Counter Value for Channel B */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXRAY_SLTCTBR_tag;

typedef union FLEXRAY_RTCORVR_union_tag { /* Rate Correction Value Register */
  vuint16_t R;
  struct {
    vuint16_t RATECORR:16;             /* Rate Correction Value */
  } B;
} FLEXRAY_RTCORVR_tag;

typedef union FLEXRAY_OFCORVR_union_tag { /* Offset Correction Value Register */
  vuint16_t R;
  struct {
    vuint16_t OFFSETCORR:16;           /* Offset Correction Value */
  } B;
} FLEXRAY_OFCORVR_tag;

typedef union FLEXRAY_CIFR_union_tag { /* Combined Interrupt Flag Register */
  vuint16_t R;
  struct {
    vuint16_t TBIF:1;                  /* Transmit Message Buffer Interrupt Flag */
    vuint16_t RBIF:1;                  /* Receive Message Buffer Interrupt Flag */
    vuint16_t FAFAIF:1;                /* Receive FIFO Channel A Almost Full Interrupt Flag */
    vuint16_t FAFBIF:1;                /* Receive FIFO Channel B Almost Full Interrupt Flag */
    vuint16_t WUPIF:1;                 /* Wakeup Interrupt Flag */
    vuint16_t CHIF:1;                  /* CHI Interrupt Flag */
    vuint16_t PRIF:1;                  /* Protocol Interrupt Flag */
    vuint16_t MIF:1;                   /* Module Interrupt Flag */
    vuint16_t _unused_8:8;             /* Reserved */
  } B;
} FLEXRAY_CIFR_tag;

typedef union FLEXRAY_SYMATOR_union_tag { /* System Memory Access Time-Out Register */
  vuint16_t R;
  struct {
    vuint16_t TIMEOUT:8;               /* System Memory Access Time-Out */
    vuint16_t _unused_8:8;             /* Reserved */
  } B;
} FLEXRAY_SYMATOR_tag;

typedef union FLEXRAY_SFCNTR_union_tag { /* Sync Frame Counter Register */
  vuint16_t R;
  struct {
    vuint16_t SFODA:4;                 /* Sync Frames Channel A, odd cycle */
    vuint16_t SFODB:4;                 /* Sync Frames Channel B, odd cycle */
    vuint16_t SFEVA:4;                 /* Sync Frames Channel A, even cycle */
    vuint16_t SFEVB:4;                 /* Sync Frames Channel B, even cycle */
  } B;
} FLEXRAY_SFCNTR_tag;

typedef union FLEXRAY_SFTOR_union_tag { /* Sync Frame Table Offset Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:1;             /* Reserved */
    vuint16_t SFT_OFFSET:15;           /* Sync Frame Table Offset */
  } B;
} FLEXRAY_SFTOR_tag;

typedef union FLEXRAY_SFTCCSR_union_tag { /* Sync Frame Table Configuration Control Status Register */
  vuint16_t R;
  struct {
    vuint16_t SIDEN:1;                 /* SIDEN */
    vuint16_t SDVEN:1;                 /* Sync Frame Deviation Table Enable */
    vuint16_t OPT:1;                   /* One Pair Trigger */
    vuint16_t _unused_3:1;             /* Reserved */
    vuint16_t OVAL:1;                  /* Odd Cycle Tables Valid */
    vuint16_t EVAL:1;                  /* Even Cycle Tables Valid */
    vuint16_t OLKS:1;                  /* Odd Cycle Tables Lock Status */
    vuint16_t ELKS:1;                  /* Even Cycle Tables Lock Status */
    vuint16_t CYCNUM:6;                /* Cycle Number */
    vuint16_t OLKT:1;                  /* Odd Cycle Tables Lock/Unlock Trigger */
    vuint16_t ELKT:1;                  /* Even Cycle Tables Lock/Unlock Trigger */
  } B;
} FLEXRAY_SFTCCSR_tag;

typedef union FLEXRAY_SFIDRFR_union_tag { /* Sync Frame ID Rejection Filter Register */
  vuint16_t R;
  struct {
    vuint16_t SYNFRID:10;              /* Sync Frame Rejection ID */
    vuint16_t _unused_10:6;            /* Reserved */
  } B;
} FLEXRAY_SFIDRFR_tag;

typedef union FLEXRAY_SFIDAFVR_union_tag { /* Sync Frame ID Acceptance Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t FVAL:10;                 /* Filter Value */
    vuint16_t _unused_10:6;            /* Reserved */
  } B;
} FLEXRAY_SFIDAFVR_tag;

typedef union FLEXRAY_SFIDAFMR_union_tag { /* Sync Frame ID Acceptance Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t FMSK:10;                 /* Filter Mask */
    vuint16_t _unused_10:6;            /* Reserved */
  } B;
} FLEXRAY_SFIDAFMR_tag;

typedef union FLEXRAY_NMVR_union_tag { /* Network Management Vector Register */
  vuint16_t R;
  struct {
    vuint16_t NMVP:16;                 /* Network Management Vector Part */
  } B;
} FLEXRAY_NMVR_tag;

typedef union FLEXRAY_NMVLR_union_tag { /* Network Management Vector Length Register */
  vuint16_t R;
  struct {
    vuint16_t NMVL:4;                  /* Network Management Vector Length */
    vuint16_t _unused_4:12;            /* Reserved */
  } B;
} FLEXRAY_NMVLR_tag;

typedef union FLEXRAY_TICCR_union_tag { /* Timer Configuration and Control Register */
  vuint16_t R;
  struct {
    vuint16_t T1ST:1;                  /* Timer T1 State */
    vuint16_t T1TR:1;                  /* Timer T1 Trigger */
    vuint16_t T1SP:1;                  /* Timer T1 Stop */
    vuint16_t _unused_3:1;             /* Reserved */
    vuint16_t T1_REP:1;                /* Timer T1 Repetitive Mode */
    vuint16_t _unused_5:3;             /* Reserved */
    vuint16_t T2ST:1;                  /* Timer T2 State */
    vuint16_t T2TR:1;                  /* Timer T2 Trigger */
    vuint16_t T2SP:1;                  /* Timer T2 Stop */
    vuint16_t _unused_11:1;            /* Reserved */
    vuint16_t T2_REP:1;                /* Timer T2 Repetitive Mode */
    vuint16_t T2_CFG:1;                /* Timer T2 Configuration */
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} FLEXRAY_TICCR_tag;

typedef union FLEXRAY_TI1CYSR_union_tag { /* Timer 1 Cycle Set Register */
  vuint16_t R;
  struct {
    vuint16_t T1_CYC_MSK:6;            /* Timer T1 Cycle Filter Mask */
    vuint16_t _unused_6:2;             /* Reserved */
    vuint16_t T1_CYC_VAL:6;            /* Timer T1 Cycle Filter Value */
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} FLEXRAY_TI1CYSR_tag;

typedef union FLEXRAY_TI1MTOR_union_tag { /* Timer 1 Macrotick Offset Register */
  vuint16_t R;
  struct {
    vuint16_t T1_MTOFFSET:14;          /* Timer 1 Macrotick Offset */
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} FLEXRAY_TI1MTOR_tag;

typedef union FLEXRAY_TI2CR0_REL_TI2CR0_ABS_TI2CR0_ABS_union_tag { /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2CYCMSK:6;              /* Timer T2 Cycle Filter Mask */
    vuint16_t _unused_6:2;             /* Reserved */
    vuint16_t T2CYCVAL:6;              /* Timer T2 Cycle Filter Mask */
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} FLEXRAY_TI2CR0_REL_TI2CR0_ABS_TI2CR0_ABS_tag;

typedef union FLEXRAY_TI2CR0_REL_TI2CR0_ABS_TI2CR0_REL_union_tag { /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MTCNT:16;              /* Timer T2 Macrotick High Word */
  } B;
} FLEXRAY_TI2CR0_REL_TI2CR0_ABS_TI2CR0_REL_tag;

typedef union FLEXRAY_TI2CR0_REL_TI2CR0_ABS_union_tag {
  FLEXRAY_TI2CR0_REL_TI2CR0_ABS_TI2CR0_ABS_tag TI2CR0_ABS; /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
  FLEXRAY_TI2CR0_REL_TI2CR0_ABS_TI2CR0_REL_tag TI2CR0_REL; /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
} FLEXRAY_TI2CR0_REL_TI2CR0_ABS_tag;

typedef union FLEXRAY_TI2CR1_REL_TI2CR1_ABS_TI2CR1_ABS_union_tag { /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MOFF:14;               /* Timer T2 Macrotick Offset */
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} FLEXRAY_TI2CR1_REL_TI2CR1_ABS_TI2CR1_ABS_tag;

typedef union FLEXRAY_TI2CR1_REL_TI2CR1_ABS_TI2CR1_REL_union_tag { /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MTCNT:16;
  } B;
} FLEXRAY_TI2CR1_REL_TI2CR1_ABS_TI2CR1_REL_tag;

typedef union FLEXRAY_TI2CR1_REL_TI2CR1_ABS_union_tag {
  FLEXRAY_TI2CR1_REL_TI2CR1_ABS_TI2CR1_ABS_tag TI2CR1_ABS; /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
  FLEXRAY_TI2CR1_REL_TI2CR1_ABS_TI2CR1_REL_tag TI2CR1_REL; /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
} FLEXRAY_TI2CR1_REL_TI2CR1_ABS_tag;

typedef union FLEXRAY_SSSR_union_tag { /* Slot Status Selection Register */
  vuint16_t R;
  struct {
    vuint16_t SLOTNUMBER:11;           /* Slot Number */
    vuint16_t _unused_11:1;            /* Reserved */
    vuint16_t SEL:2;                   /* Selector */
    vuint16_t _unused_14:1;            /* Reserved */
    vuint16_t WMD:1;                   /* Write Mode */
  } B;
} FLEXRAY_SSSR_tag;

typedef union FLEXRAY_SSCCR_union_tag { /* Slot Status Counter Condition Register */
  vuint16_t R;
  struct {
    vuint16_t STATUSMASK:4;            /* Slot Status Mask */
    vuint16_t SUF:1;                   /* Startup Frame Restriction */
    vuint16_t NUF:1;                   /* Null Frame Restriction */
    vuint16_t SYF:1;                   /* Sync Frame Restriction */
    vuint16_t VFR:1;                   /* Valid Frame Restriction */
    vuint16_t MCY:1;                   /* Multi Cycle Selection */
    vuint16_t CNTCFG:2;                /* Counter Configuration */
    vuint16_t _unused_11:1;            /* Reserved */
    vuint16_t SEL:2;                   /* Selector */
    vuint16_t _unused_14:1;            /* Reserved */
    vuint16_t WMD:1;                   /* Write Mode */
  } B;
} FLEXRAY_SSCCR_tag;

typedef union FLEXRAY_SSR_union_tag {  /* Slot Status Register */
  vuint16_t R;
  struct {
    vuint16_t TCA:1;                   /* Transmission Conflict on Channel A */
    vuint16_t BVA:1;                   /* Boundary Violation on Channel A */
    vuint16_t CEA:1;                   /* Content Error on Channel A */
    vuint16_t SEA:1;                   /* SEA */
    vuint16_t SUA:1;                   /* Startup Frame Indicator Channel A */
    vuint16_t NFA:1;                   /* Null Frame Indicator Channel A */
    vuint16_t SYA:1;                   /* Sync Frame Indicator Channel A */
    vuint16_t VFA:1;                   /* Valid Frame on Channel A */
    vuint16_t TCB:1;                   /* Transmission Conflict on Channel B */
    vuint16_t BVB:1;                   /* Boundary Violation on Channel B */
    vuint16_t CEB:1;                   /* Content Error on Channel B */
    vuint16_t SEB:1;                   /* Syntax Error on Channel B */
    vuint16_t SUB:1;                   /* Startup Frame Indicator Channel B */
    vuint16_t NFB:1;                   /* Null Frame Indicator Channel B */
    vuint16_t SYB:1;                   /* Sync Frame Indicator Channel B */
    vuint16_t VFB:1;                   /* Valid Frame on Channel B */
  } B;
} FLEXRAY_SSR_tag;

typedef union FLEXRAY_SSCR_union_tag { /* Slot Status Counter Register */
  vuint16_t R;
  struct {
    vuint16_t SLOTSTATUSCNT:16;        /* Slot Status Counter */
  } B;
} FLEXRAY_SSCR_tag;

typedef union FLEXRAY_MTSACFR_union_tag { /* MTS A Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t CYCCNTVAL:6;             /* Cycle Counter Value */
    vuint16_t _unused_6:2;             /* Reserved */
    vuint16_t CYCCNTMSK:6;             /* Cycle Counter Mask */
    vuint16_t _unused_14:1;            /* Reserved */
    vuint16_t MTE:1;                   /* Media Access Test Symbol Transmission Enable */
  } B;
} FLEXRAY_MTSACFR_tag;

typedef union FLEXRAY_MTSBCFR_union_tag { /* MTS B Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t CYCCNTVAL:6;             /* Cycle Counter Value */
    vuint16_t _unused_6:2;             /* Reserved */
    vuint16_t CYCCNTMSK:6;             /* Cycle Counter Mask */
    vuint16_t _unused_14:1;            /* Reserved */
    vuint16_t MTE:1;                   /* Media Access Test Symbol Transmission Enable */
  } B;
} FLEXRAY_MTSBCFR_tag;

typedef union FLEXRAY_RSBIR_union_tag { /* Receive Shadow Buffer Index Register */
  vuint16_t R;
  struct {
    vuint16_t RSBIDX:9;                /* RSBIDXA1/RSBIDXA2/RSBIDXB1/RSBIDXB2- Receive Shadow Buffer Index */
    vuint16_t _unused_9:3;             /* Reserved */
    vuint16_t SEL:2;                   /* Selector */
    vuint16_t _unused_14:1;            /* Reserved */
    vuint16_t WMD:1;                   /* Write Mode */
  } B;
} FLEXRAY_RSBIR_tag;

typedef union FLEXRAY_RFWMSR_union_tag { /* Receive FIFO Watermark and Selection Register */
  vuint16_t R;
  struct {
    vuint16_t SEL:1;                   /* Select */
    vuint16_t _unused_1:7;             /* Reserved */
    vuint16_t WM:8;                    /* WMA/WMB - Watermark */
  } B;
} FLEXRAY_RFWMSR_tag;

typedef union FLEXRAY_RFSIR_union_tag { /* Receive FIFO Start Index Register */
  vuint16_t R;
  struct {
    vuint16_t SIDX:10;                 /* SIDXA/SIDXB - Start Index */
    vuint16_t _unused_10:6;            /* Reserved */
  } B;
} FLEXRAY_RFSIR_tag;

typedef union FLEXRAY_RFDSR_union_tag { /* Receive FIFO Depth and Size Register */
  vuint16_t R;
  struct {
    vuint16_t ENTRY_SIZE:7;            /* ENTRY_SIZEA/ENTRY_SIZEB - Entry Size */
    vuint16_t _unused_7:1;             /* Reserved */
    vuint16_t FIFO_DEPTH:8;            /* FIFO_DEPTHA/FIFO_DEPTHB - FIFO Depth */
  } B;
} FLEXRAY_RFDSR_tag;

typedef union FLEXRAY_RFARIR_union_tag { /* Receive FIFO A Read Index Register */
  vuint16_t R;
  struct {
    vuint16_t RDIDX:10;                /* Read Index */
    vuint16_t _unused_10:6;            /* Reserved */
  } B;
} FLEXRAY_RFARIR_tag;

typedef union FLEXRAY_RFBRIR_union_tag { /* Receive FIFO B Read Index Register */
  vuint16_t R;
  struct {
    vuint16_t RDIDX:10;                /* Read Index */
    vuint16_t _unused_10:6;            /* Reserved */
  } B;
} FLEXRAY_RFBRIR_tag;

typedef union FLEXRAY_RFMIDAFVR_union_tag { /* Receive FIFO Message ID Acceptance Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t MIDAFVAL:16;             /* MIDAFVALA/MIDAFVALB - Message ID Acceptance Filter Value */
  } B;
} FLEXRAY_RFMIDAFVR_tag;

typedef union FLEXRAY_RFMIDAFMR_union_tag { /* Receive FIFO Message ID Acceptance Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t MIDAFMSK:16;             /* MIDAFMSKA/MIDAFMSKB - Message ID Acceptance Filter Mask */
  } B;
} FLEXRAY_RFMIDAFMR_tag;

typedef union FLEXRAY_RFFIDRFVR_union_tag { /* Receive FIFO Frame ID Rejection Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t FIDRFVAL:11;             /* FIDRFVALA/FIDRFVALB - Frame ID Rejection Filter Value */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXRAY_RFFIDRFVR_tag;

typedef union FLEXRAY_RFFIDRFMR_union_tag { /* Receive FIFO Frame ID Rejection Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t FIDRFMSK:11;             /* Frame ID Rejection Filter Mask */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXRAY_RFFIDRFMR_tag;

typedef union FLEXRAY_RFRFCFR_union_tag { /* Receive FIFO Range Filter Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t SID:11;                  /* Slot ID */
    vuint16_t _unused_11:1;            /* Reserved */
    vuint16_t SEL:2;                   /* Filter Selector */
    vuint16_t IBD:1;                   /* Interval Boundary */
    vuint16_t WMD:1;                   /* Write Mode */
  } B;
} FLEXRAY_RFRFCFR_tag;

typedef union FLEXRAY_RFRFCTR_union_tag { /* Receive FIFO Range Filter Control Register */
  vuint16_t R;
  struct {
    vuint16_t F0EN:1;                  /* Range Filter 0 Enable */
    vuint16_t F1EN:1;                  /* Range Filter 1 Enable */
    vuint16_t F2EN:1;                  /* Range Filter 2 Enable */
    vuint16_t F3EN:1;                  /* Range Filter 3 Enable */
    vuint16_t _unused_4:4;             /* Reserved */
    vuint16_t F0MD:1;                  /* Range Filter 0 Mode */
    vuint16_t F1MD:1;                  /* Range Filter 1 Mode */
    vuint16_t F2MD:1;                  /* Range Filter 2 Mode */
    vuint16_t F3MD:1;                  /* Range Filter 3 Mode */
    vuint16_t _unused_12:4;            /* Reserved */
  } B;
} FLEXRAY_RFRFCTR_tag;

typedef union FLEXRAY_LDTXSLAR_union_tag { /* Last Dynamic Transmit Slot Channel A Register */
  vuint16_t R;
  struct {
    vuint16_t LDYNTXSLOTA:11;          /* Last Dynamic Transmission Slot Channel A */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXRAY_LDTXSLAR_tag;

typedef union FLEXRAY_LDTXSLBR_union_tag { /* Last Dynamic Transmit Slot Channel B Register */
  vuint16_t R;
  struct {
    vuint16_t LDYNTXSLOTB:11;          /* Last Dynamic Transmission Slot Channel B */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXRAY_LDTXSLBR_tag;

typedef union FLEXRAY_PCR0_union_tag { /* Protocol Configuration Register 0 */
  vuint16_t R;
  struct {
    vuint16_t STATIC_SLOT_LENGTH:10;   /* static_slot_length */
    vuint16_t ACTION_POINT_OFFSET:6;   /* action_point_offset */
  } B;
} FLEXRAY_PCR0_tag;

typedef union FLEXRAY_PCR1_union_tag { /* Protocol Configuration Register 1 */
  vuint16_t R;
  struct {
    vuint16_t MACRO_AFTER_FIRST_STATIC_SLOT:14; /* macro_after_first_static_slot */
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} FLEXRAY_PCR1_tag;

typedef union FLEXRAY_PCR2_union_tag { /* Protocol Configuration Register 2 */
  vuint16_t R;
  struct {
    vuint16_t NUMBER_OF_STATIC_SLOTS:10; /* gNumberOfStaticSlots */
    vuint16_t MINISLOT_AFTER_ACTION_POINT:6; /* minislot_after_action_point */
  } B;
} FLEXRAY_PCR2_tag;

typedef union FLEXRAY_PCR3_union_tag { /* Protocol Configuration Register 3 */
  vuint16_t R;
  struct {
    vuint16_t COLDSTART_ATTEMPTS:5;    /* coldstart_attempts */
    vuint16_t MINISLOT_ACTION_POINT_OFFSET:5; /* minislot_action_point_offset */
    vuint16_t WAKEUP_SYMBOL_RX_LOW:6;  /* wakeup_symbol_rx_low */
  } B;
} FLEXRAY_PCR3_tag;

typedef union FLEXRAY_PCR4_union_tag { /* Protocol Configuration Register 4 */
  vuint16_t R;
  struct {
    vuint16_t WAKEUP_SYMBOL_RX_WINDOW:9; /* wakeup_symbol_rx_window */
    vuint16_t CAS_RX_LOW_MAX:7;        /* cas_rx_low_max */
  } B;
} FLEXRAY_PCR4_tag;

typedef union FLEXRAY_PCR5_union_tag { /* Protocol Configuration Register 5 */
  vuint16_t R;
  struct {
    vuint16_t WAKEUP_SYMBOL_RX_IDLE:6; /* wakeup_symbol_rx_idle */
    vuint16_t WAKEUP_SYMBOL_TX_LOW:6;  /* wakeup_symbol_tx_low */
    vuint16_t TSS_TRANSMITTER:4;       /* tss_transmitter */
  } B;
} FLEXRAY_PCR5_tag;

typedef union FLEXRAY_PCR6_union_tag { /* Protocol Configuration Register 6 */
  vuint16_t R;
  struct {
    vuint16_t MACRO_INITIAL_OFFSET_A:7; /* macro_initial_offset_a */
    vuint16_t SYMBOL_WINDOW_AFTER_ACTION_POINT:8; /* symbol_window_after_action_point */
    vuint16_t _unused_15:1;            /* Reserved */
  } B;
} FLEXRAY_PCR6_tag;

typedef union FLEXRAY_PCR7_union_tag { /* Protocol Configuration Register 7 */
  vuint16_t R;
  struct {
    vuint16_t MICRO_PER_MACRO_NOM_HALF:7; /* micro_per_macro_nom_half */
    vuint16_t DECODING_CORRECTION_B:9; /* decoding_correction_b */
  } B;
} FLEXRAY_PCR7_tag;

typedef union FLEXRAY_PCR8_union_tag { /* Protocol Configuration Register 8 */
  vuint16_t R;
  struct {
    vuint16_t WAKEUP_SYMBOL_TX_IDLE:8; /* wakeup_symbol_tx_idle */
    vuint16_t MAX_WITHOUT_CLOCK_CORRECTION_PASSIVE:4; /* max_without_clock_correction_passive */
    vuint16_t MAX_WITHOUT_CLOCK_CORRECTION_FATAL:4; /* max_without_clock_correction_fatal */
  } B;
} FLEXRAY_PCR8_tag;

typedef union FLEXRAY_PCR9_union_tag { /* Protocol Configuration Register 9 */
  vuint16_t R;
  struct {
    vuint16_t OFFSET_CORRECTION_OUT:14; /* offset_correction_out */
    vuint16_t SYMBOL_WINDOW_EXISTS:1;  /* symbol_window_exists */
    vuint16_t MINISLOT_EXISTS:1;       /* minislot_exists */
  } B;
} FLEXRAY_PCR9_tag;

typedef union FLEXRAY_PCR10_union_tag { /* Protocol Configuration Register 10 */
  vuint16_t R;
  struct {
    vuint16_t MACRO_PER_CYCLE:14;      /* macro_per_cycle */
    vuint16_t WAKEUP_CHANNEL:1;        /* wakeup_channel */
    vuint16_t SINGLE_SLOT_ENABLED:1;   /* single_slot_enabled */
  } B;
} FLEXRAY_PCR10_tag;

typedef union FLEXRAY_PCR11_union_tag { /* Protocol Configuration Register 11 */
  vuint16_t R;
  struct {
    vuint16_t OFFSET_CORRECTION_START:14; /* offset_correction_start */
    vuint16_t KEY_SLOT_USED_FOR_SYNC:1; /* key_slot_used_for_sync */
    vuint16_t KEY_SLOT_USED_FOR_STARTUP:1; /* key_slot_used_for_startup */
  } B;
} FLEXRAY_PCR11_tag;

typedef union FLEXRAY_PCR12_union_tag { /* Protocol Configuration Register 12 */
  vuint16_t R;
  struct {
    vuint16_t KEY_SLOT_HEADER_CRC:11;  /* key_slot_header_crc */
    vuint16_t ALLOW_PASSIVE_TO_ACTIVE:5; /* allow_passive_to_active */
  } B;
} FLEXRAY_PCR12_tag;

typedef union FLEXRAY_PCR13_union_tag { /* Protocol Configuration Register 13 */
  vuint16_t R;
  struct {
    vuint16_t STATIC_SLOT_AFTER_ACTION_POINT:10; /* static_slot_after_action_point */
    vuint16_t FIRST_MINISLOT_ACTION_POINT_OFFSET:6; /* first_minislot_action_point_offset */
  } B;
} FLEXRAY_PCR13_tag;

typedef union FLEXRAY_PCR14_union_tag { /* Protocol Configuration Register 14 */
  vuint16_t R;
  struct {
    vuint16_t LISTEN_TIMEOUT:5;        /* listen_timeout */
    vuint16_t RATE_CORRECTION_OUT:11;  /* rate_correction_out */
  } B;
} FLEXRAY_PCR14_tag;

typedef union FLEXRAY_PCR15_union_tag { /* Protocol Configuration Register 15 */
  vuint16_t R;
  struct {
    vuint16_t LISTEN_TIMEOUT:16;       /* listen_timeout */
  } B;
} FLEXRAY_PCR15_tag;

typedef union FLEXRAY_PCR16_union_tag { /* Protocol Configuration Register 16 */
  vuint16_t R;
  struct {
    vuint16_t NOISE_LISTEN_TIMEOUT:9;  /* noise_listen_timeout */
    vuint16_t MACRO_INITIAL_OFFSET_B:7; /* macro_initial_offset_b */
  } B;
} FLEXRAY_PCR16_tag;

typedef union FLEXRAY_PCR17_union_tag { /* Protocol Configuration Register 17 */
  vuint16_t R;
  struct {
    vuint16_t NOISE_LISTEN_TIMEOUT:16; /* noise_listen_timeout */
  } B;
} FLEXRAY_PCR17_tag;

typedef union FLEXRAY_PCR18_union_tag { /* Protocol Configuration Register 18 */
  vuint16_t R;
  struct {
    vuint16_t KEY_SLOT_ID:10;          /* key_slot_id */
    vuint16_t WAKEUP_PATTERN:6;        /* wakeup_pattern */
  } B;
} FLEXRAY_PCR18_tag;

typedef union FLEXRAY_PCR19_union_tag { /* Protocol Configuration Register 19 */
  vuint16_t R;
  struct {
    vuint16_t PAYLOAD_LENGTH_STATIC:7; /* payload_length_static */
    vuint16_t DECODING_CORRECTION_A:9; /* decoding_correction_a */
  } B;
} FLEXRAY_PCR19_tag;

typedef union FLEXRAY_PCR20_union_tag { /* Protocol Configuration Register 20 */
  vuint16_t R;
  struct {
    vuint16_t MICRO_INITIAL_OFFSET_A:8; /* micro_initial_offset_a */
    vuint16_t MICRO_INITIAL_OFFSET_B:8; /* micro_initial_offset_b */
  } B;
} FLEXRAY_PCR20_tag;

typedef union FLEXRAY_PCR21_union_tag { /* Protocol Configuration Register 21 */
  vuint16_t R;
  struct {
    vuint16_t LATEST_TX:13;            /* latest_tx */
    vuint16_t EXTERN_RATE_CORRECTION:3; /* extern_rate_correction */
  } B;
} FLEXRAY_PCR21_tag;

typedef union FLEXRAY_PCR22_union_tag { /* Protocol Configuration Register 22 */
  vuint16_t R;
  struct {
    vuint16_t MICRO_PER_CYCLE:4;       /* micro_per_cycle */
    vuint16_t COMP_ACCEPTED_STARTUP_RANGE_A:11; /* comp_accepted_startup_range_a */
    vuint16_t _unused_15:1;            /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
  } B;
} FLEXRAY_PCR22_tag;

typedef union FLEXRAY_PCR23_union_tag { /* Protocol Configuration Register 23 */
  vuint16_t R;
  struct {
    vuint16_t MICRO_PER_CYCLE:16;      /* micro_per_cycle */
  } B;
} FLEXRAY_PCR23_tag;

typedef union FLEXRAY_PCR24_union_tag { /* Protocol Configuration Register 24 */
  vuint16_t R;
  struct {
    vuint16_t MICRO_PER_CYCLE_MIN:4;   /* micro_per_cycle_min */
    vuint16_t MAX_PAYLOAD_LENGTH_DYNAMIC:7; /* max_payload_length_dynamic */
    vuint16_t CLUSTER_DRIFT_DAMPING:5; /* cluster_drift_damping */
  } B;
} FLEXRAY_PCR24_tag;

typedef union FLEXRAY_PCR25_union_tag { /* Protocol Configuration Register 25 */
  vuint16_t R;
  struct {
    vuint16_t MICRO_PER_CYCLE_MIN:16;  /* micro_per_cycle_min */
  } B;
} FLEXRAY_PCR25_tag;

typedef union FLEXRAY_PCR26_union_tag { /* Protocol Configuration Register 26 */
  vuint16_t R;
  struct {
    vuint16_t MICRO_PER_CYCLE_MAX:4;   /* micro_per_cycle_max */
    vuint16_t COMP_ACCEPTED_STARTUP_RANGE_B:11; /* comp_accepted_startup_range_b */
    vuint16_t ALLOW_HALT_DUE_TO_CLOCK:1; /* allow_halt_due_to_clock */
  } B;
} FLEXRAY_PCR26_tag;

typedef union FLEXRAY_PCR27_union_tag { /* Protocol Configuration Register 27 */
  vuint16_t R;
  struct {
    vuint16_t MICRO_PER_CYCLE_MAX:16;  /* micro_per_cycle_max */
  } B;
} FLEXRAY_PCR27_tag;

typedef union FLEXRAY_PCR28_union_tag { /* Protocol Configuration Register 28 */
  vuint16_t R;
  struct {
    vuint16_t MACRO_AFTER_OFFSET_CORRECTION:14; /* macro_after_offset_correction */
    vuint16_t DYNAMIC_SLOT_IDLE_PHASE:2; /* dynamic_slot_idle_phase */
  } B;
} FLEXRAY_PCR28_tag;

typedef union FLEXRAY_PCR29_union_tag { /* Protocol Configuration Register 29 */
  vuint16_t R;
  struct {
    vuint16_t MINISLOTS_MAX:13;        /* minislots_max */
    vuint16_t EXTERN_OFFSET_CORRECTION:3; /* extern_offset_correction */
  } B;
} FLEXRAY_PCR29_tag;

typedef union FLEXRAY_PCR30_union_tag { /* Protocol Configuration Register 30 */
  vuint16_t R;
  struct {
    vuint16_t SYNC_NODE_MAX:4;         /* sync_node_max */
    vuint16_t _unused_4:12;            /* Reserved */
  } B;
} FLEXRAY_PCR30_tag;

typedef union FLEXRAY_STPWHR_union_tag { /* StopWatch Count High Register */
  vuint16_t R;
  struct {
    vuint16_t STPW_S_H:16;             /* StopWatch Count High */
  } B;
} FLEXRAY_STPWHR_tag;

typedef union FLEXRAY_STPWLR_union_tag { /* Stop Watch Count Low Register */
  vuint16_t R;
  struct {
    vuint16_t STPW_S_L:16;             /* StopWatch Count Low */
  } B;
} FLEXRAY_STPWLR_tag;

typedef union FLEXRAY_PEOER_union_tag { /* Protocol Event Output Enable and StopWatch Control Register */
  vuint16_t R;
  struct {
    vuint16_t CYC_EE:1;                /* Cycle Start Event Output Enable */
    vuint16_t TIM1_EE:1;               /* Timer 1 expired Event Output Enable */
    vuint16_t TIM2_EE:1;               /* imer 2 expired Event Output Enable */
    vuint16_t _unused_3:5;             /* Reserved */
    vuint16_t STPW_EN:1;               /* Stopwatch count Enable */
    vuint16_t _unused_9:7;             /* Reserved */
  } B;
} FLEXRAY_PEOER_tag;

typedef union FLEXRAY_RFSDOR_union_tag { /* Receive FIFO Start Data Offset Register */
  vuint16_t R;
  struct {
    vuint16_t SDO:16;                  /* SDOA/SDOB - Start Data Field Offset */
  } B;
} FLEXRAY_RFSDOR_tag;

typedef union FLEXRAY_RFSYMBADHR_union_tag { /* Receive FIFO System Memory Base Address High Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:16;                 /* System Memory Base Address */
  } B;
} FLEXRAY_RFSYMBADHR_tag;

typedef union FLEXRAY_RFSYMBADLR_union_tag { /* Receive FIFO System Memory Base Address Low Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_0:4;             /* Reserved */
    vuint16_t SMBA:12;                 /* System Memory Base Address */
  } B;
} FLEXRAY_RFSYMBADLR_tag;

typedef union FLEXRAY_RFPTR_union_tag { /* Receive FIFO Periodic Timer Register */
  vuint16_t R;
  struct {
    vuint16_t PTD:14;                  /* Periodic Timer Duration */
    vuint16_t _unused_14:2;            /* Reserved */
  } B;
} FLEXRAY_RFPTR_tag;

typedef union FLEXRAY_RFFLPCR_union_tag { /* Receive FIFO Fill Level and POP Count Register */
  vuint16_t R;
  struct {
    vuint16_t FLA_OR_PCA:8;            /* FLA_or_PCA */
    vuint16_t FLB_OR_PCB:8;            /* FLB_or_PCB */
  } B;
} FLEXRAY_RFFLPCR_tag;

typedef union FLEXRAY_EEIFER_union_tag { /* ECC Error Interrupt Flag and Enable Register */
  vuint16_t R;
  struct {
    vuint16_t DRCE_IE:1;               /* DRAM Corrected Error Interrupt Enable */
    vuint16_t DRNE_IE:1;               /* DRAM Non-Corrected Error Interrupt Enable */
    vuint16_t LRCE_IE:1;               /* LRAM Corrected Error Interrupt Enable */
    vuint16_t LRNE_IE:1;               /* LRAM Non-Corrected Error Interrupt Enable */
    vuint16_t _unused_4:4;             /* Reserved */
    vuint16_t DRCE_IF:1;               /* DRAM Corrected Error Interrupt Flag */
    vuint16_t DRNE_IF:1;               /* DRAM Non-Corrected Error Interrupt Flag */
    vuint16_t LRCE_IF:1;               /* LRAM Corrected Error Interrupt Flag */
    vuint16_t LRNE_IF:1;               /* LRAM Non-Corrected Error Interrupt Flag */
    vuint16_t DRCE_OF:1;               /* DRAM Corrected Error Overflow Flag */
    vuint16_t DRNE_OF:1;               /* DRAM Non-Corrected Error Overflow Flag */
    vuint16_t LRCE_OF:1;               /* LRAM Corrected Error Overflow Flag */
    vuint16_t LRNE_OF:1;               /* LRAM Non-Corrected Error Overflow Flag */
  } B;
} FLEXRAY_EEIFER_tag;

typedef union FLEXRAY_EERICR_union_tag { /* ECC Error Report and Injection Control Register */
  vuint16_t R;
  struct {
    vuint16_t EIE:1;                   /* Error Injection Enable */
    vuint16_t EIM:1;                   /* Error Injection Mode */
    vuint16_t _unused_2:2;             /* Reserved */
    vuint16_t ERM:1;                   /* Error Report Mode */
    vuint16_t _unused_5:3;             /* Reserved */
    vuint16_t ERS:2;                   /* Error Report Select */
    vuint16_t _unused_10:5;            /* Reserved */
    vuint16_t BSY:1;                   /* Register Update Busy */
  } B;
} FLEXRAY_EERICR_tag;

typedef union FLEXRAY_EERAR_union_tag { /* ECC Error Report Address Register */
  vuint16_t R;
  struct {
    vuint16_t ADDR:12;                 /* Memory Address */
    vuint16_t BANK:3;                  /* Memory Bank */
    vuint16_t MID:1;                   /* Memory Identifier */
  } B;
} FLEXRAY_EERAR_tag;

typedef union FLEXRAY_EERDR_union_tag { /* ECC Error Report Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;                 /* Data */
  } B;
} FLEXRAY_EERDR_tag;

typedef union FLEXRAY_EERCR_union_tag { /* ECC Error Report Code Register */
  vuint16_t R;
  struct {
    vuint16_t CODE:5;                  /* Code */
    vuint16_t _unused_5:11;            /* Reserved */
  } B;
} FLEXRAY_EERCR_tag;

typedef union FLEXRAY_EEIAR_union_tag { /* ECC Error Injection Address Register */
  vuint16_t R;
  struct {
    vuint16_t ADDR:12;                 /* Memory Address */
    vuint16_t BANK:3;                  /* Memory Bank */
    vuint16_t MID:1;                   /* Memory Identifier */
  } B;
} FLEXRAY_EEIAR_tag;

typedef union FLEXRAY_EEIDR_union_tag { /* ECC Error Injection Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;                 /* Data */
  } B;
} FLEXRAY_EEIDR_tag;

typedef union FLEXRAY_EEICR_union_tag { /* ECC Error Injection Code Register */
  vuint16_t R;
  struct {
    vuint16_t CODE:5;                  /* Code */
    vuint16_t _unused_5:11;            /* Reserved */
  } B;
} FLEXRAY_EEICR_tag;

typedef union FLEXRAY_MB_MBCCSR_union_tag { /* Message Buffer Configuration Control Status Register */
  vuint16_t R;
  struct {
    vuint16_t MBIF:1;                  /* Message Buffer Interrupt Flag */
    vuint16_t LCKS:1;                  /* Lock Status */
    vuint16_t EDS:1;                   /* Enable/Disable Status */
    vuint16_t DVAL:1;                  /* Data Valid */
    vuint16_t DUP:1;                   /* Data Updated */
    vuint16_t _unused_5:3;             /* Reserved */
    vuint16_t MBIE:1;                  /* Message Buffer Interrupt Enable */
    vuint16_t LCKT:1;                  /* Lock/Unlock Trigger */
    vuint16_t EDT:1;                   /* Enable/Disable Trigger */
    vuint16_t CMT:1;                   /* Commit for Transmission */
    vuint16_t MTD:1;                   /* Message Buffer Transfer Direction */
    vuint16_t _unused_13:3;            /* Reserved */
  } B;
} FLEXRAY_MB_MBCCSR_tag;

typedef union FLEXRAY_MB_MBCCFR_union_tag { /* Message Buffer Cycle Counter Filter Register */
  vuint16_t R;
  struct {
    vuint16_t CCFVAL:6;                /* Cycle Counter Filtering Value */
    vuint16_t CCFMSK:6;                /* Cycle Counter Filtering Mask */
    vuint16_t CCFE:1;                  /* Cycle Counter Filtering Enable */
    vuint16_t CHB:1;                   /* Channel Assignment */
    vuint16_t CHA:1;                   /* Channel Assignment */
    vuint16_t MTM:1;                   /* Message Buffer Transmission Mode */
  } B;
} FLEXRAY_MB_MBCCFR_tag;

typedef union FLEXRAY_MB_MBFIDR_union_tag { /* Message Buffer Frame ID Register */
  vuint16_t R;
  struct {
    vuint16_t FID:11;                  /* Frame ID */
    vuint16_t _unused_11:5;            /* Reserved */
  } B;
} FLEXRAY_MB_MBFIDR_tag;

typedef union FLEXRAY_MB_MBIDXR_union_tag { /* Message Buffer Index Register */
  vuint16_t R;
  struct {
    vuint16_t MBIDX:9;                 /* Message Buffer Index */
    vuint16_t _unused_9:7;             /* Reserved */
  } B;
} FLEXRAY_MB_MBIDXR_tag;

typedef struct FLEXRAY_MB_struct_tag {
  FLEXRAY_MB_MBCCSR_tag MBCCSR;        /* Message Buffer Configuration Control Status Register */
  FLEXRAY_MB_MBCCFR_tag MBCCFR;        /* Message Buffer Cycle Counter Filter Register */
  FLEXRAY_MB_MBFIDR_tag MBFIDR;        /* Message Buffer Frame ID Register */
  FLEXRAY_MB_MBIDXR_tag MBIDXR;        /* Message Buffer Index Register */
} FLEXRAY_MB_tag;

typedef union FLEXRAY_MBDOR_union_tag { /* Message Buffer Data Field Offset Register */
  vuint16_t R;
  struct {
    vuint16_t MBDO:16;                 /* Message Buffer Data Field Offset */
  } B;
} FLEXRAY_MBDOR_tag;

typedef union FLEXRAY_LEETR_union_tag { /* LRAM ECC Error Test Register */
  vuint16_t R;
  struct {
    vuint16_t LEETD:16;                /* LRAM ECC Error Test Data */
  } B;
} FLEXRAY_LEETR_tag;

struct FLEXRAY_tag {
  FLEXRAY_MVR_tag MVR;                 /* Module Version Register */
  FLEXRAY_MCR_tag MCR;                 /* Module Configuration Register */
  FLEXRAY_SYMBADHR_tag SYMBADHR;       /* System Memory Base Address High Register */
  FLEXRAY_SYMBADLR_tag SYMBADLR;       /* System Memory Base Address Low Register */
  FLEXRAY_STBSCR_tag STBSCR;           /* Strobe Signal Control Register */
  uint8_t FLEXRAY_reserved0[2];
  FLEXRAY_MBDSR_tag MBDSR;             /* Message Buffer Data Size Register */
  FLEXRAY_MBSSUTR_tag MBSSUTR;         /* Message Buffer Segment Size and Utilization Register */
  FLEXRAY_PEDRAR_tag PEDRAR;           /* PE DRAM Access Register */
  FLEXRAY_PEDRDR_tag PEDRDR;           /* PE DRAM Data Register */
  FLEXRAY_POCR_tag POCR;               /* Protocol Operation Control Register */
  FLEXRAY_GIFER_tag GIFER;             /* Global Interrupt Flag and Enable Register */
  FLEXRAY_PIFR0_tag PIFR0;             /* Protocol Interrupt Flag Register 0 */
  FLEXRAY_PIFR1_tag PIFR1;             /* Protocol Interrupt Flag Register 1 */
  FLEXRAY_PIER0_tag PIER0;             /* Protocol Interrupt Enable Register 0 */
  FLEXRAY_PIER1_tag PIER1;             /* Protocol Interrupt Enable Register 1 */
  FLEXRAY_CHIERFR_tag CHIERFR;         /* CHI Error Flag Register */
  FLEXRAY_MBIVEC_tag MBIVEC;           /* Message Buffer Interrupt Vector Register */
  FLEXRAY_CASERCR_tag CASERCR;         /* Channel A Status Error Counter Register */
  FLEXRAY_CBSERCR_tag CBSERCR;         /* Channel B Status Error Counter Register */
  FLEXRAY_PSR0_tag PSR0;               /* Protocol Status Register 0 */
  FLEXRAY_PSR1_tag PSR1;               /* Protocol Status Register 1 */
  FLEXRAY_PSR2_tag PSR2;               /* Protocol Status Register 2 */
  FLEXRAY_PSR3_tag PSR3;               /* Protocol Status Register 3 */
  FLEXRAY_MTCTR_tag MTCTR;             /* Macrotick Counter Register */
  FLEXRAY_CYCTR_tag CYCTR;             /* Cycle Counter Register */
  FLEXRAY_SLTCTAR_tag SLTCTAR;         /* Slot Counter Channel A Register */
  FLEXRAY_SLTCTBR_tag SLTCTBR;         /* Slot Counter Channel B Register */
  FLEXRAY_RTCORVR_tag RTCORVR;         /* Rate Correction Value Register */
  FLEXRAY_OFCORVR_tag OFCORVR;         /* Offset Correction Value Register */
  FLEXRAY_CIFR_tag CIFR;               /* Combined Interrupt Flag Register */
  FLEXRAY_SYMATOR_tag SYMATOR;         /* System Memory Access Time-Out Register */
  FLEXRAY_SFCNTR_tag SFCNTR;           /* Sync Frame Counter Register */
  FLEXRAY_SFTOR_tag SFTOR;             /* Sync Frame Table Offset Register */
  FLEXRAY_SFTCCSR_tag SFTCCSR;         /* Sync Frame Table Configuration Control Status Register */
  FLEXRAY_SFIDRFR_tag SFIDRFR;         /* Sync Frame ID Rejection Filter Register */
  FLEXRAY_SFIDAFVR_tag SFIDAFVR;       /* Sync Frame ID Acceptance Filter Value Register */
  FLEXRAY_SFIDAFMR_tag SFIDAFMR;       /* Sync Frame ID Acceptance Filter Mask Register */
  FLEXRAY_NMVR_tag NMVR[6];            /* Network Management Vector Register */
  FLEXRAY_NMVLR_tag NMVLR;             /* Network Management Vector Length Register */
  FLEXRAY_TICCR_tag TICCR;             /* Timer Configuration and Control Register */
  FLEXRAY_TI1CYSR_tag TI1CYSR;         /* Timer 1 Cycle Set Register */
  FLEXRAY_TI1MTOR_tag TI1MTOR;         /* Timer 1 Macrotick Offset Register */
  FLEXRAY_TI2CR0_REL_TI2CR0_ABS_tag TI2CR0_REL_TI2CR0_ABS;
  FLEXRAY_TI2CR1_REL_TI2CR1_ABS_tag TI2CR1_REL_TI2CR1_ABS;
  FLEXRAY_SSSR_tag SSSR;               /* Slot Status Selection Register */
  FLEXRAY_SSCCR_tag SSCCR;             /* Slot Status Counter Condition Register */
  FLEXRAY_SSR_tag SSR[8];              /* Slot Status Register */
  FLEXRAY_SSCR_tag SSCR[4];            /* Slot Status Counter Register */
  FLEXRAY_MTSACFR_tag MTSACFR;         /* MTS A Configuration Register */
  FLEXRAY_MTSBCFR_tag MTSBCFR;         /* MTS B Configuration Register */
  FLEXRAY_RSBIR_tag RSBIR;             /* Receive Shadow Buffer Index Register */
  FLEXRAY_RFWMSR_tag RFWMSR;           /* Receive FIFO Watermark and Selection Register */
  FLEXRAY_RFSIR_tag RFSIR;             /* Receive FIFO Start Index Register */
  FLEXRAY_RFDSR_tag RFDSR;             /* Receive FIFO Depth and Size Register */
  FLEXRAY_RFARIR_tag RFARIR;           /* Receive FIFO A Read Index Register */
  FLEXRAY_RFBRIR_tag RFBRIR;           /* Receive FIFO B Read Index Register */
  FLEXRAY_RFMIDAFVR_tag RFMIDAFVR;     /* Receive FIFO Message ID Acceptance Filter Value Register */
  FLEXRAY_RFMIDAFMR_tag RFMIDAFMR;     /* Receive FIFO Message ID Acceptance Filter Mask Register */
  FLEXRAY_RFFIDRFVR_tag RFFIDRFVR;     /* Receive FIFO Frame ID Rejection Filter Value Register */
  FLEXRAY_RFFIDRFMR_tag RFFIDRFMR;     /* Receive FIFO Frame ID Rejection Filter Mask Register */
  FLEXRAY_RFRFCFR_tag RFRFCFR;         /* Receive FIFO Range Filter Configuration Register */
  FLEXRAY_RFRFCTR_tag RFRFCTR;         /* Receive FIFO Range Filter Control Register */
  FLEXRAY_LDTXSLAR_tag LDTXSLAR;       /* Last Dynamic Transmit Slot Channel A Register */
  FLEXRAY_LDTXSLBR_tag LDTXSLBR;       /* Last Dynamic Transmit Slot Channel B Register */
  FLEXRAY_PCR0_tag PCR0;               /* Protocol Configuration Register 0 */
  FLEXRAY_PCR1_tag PCR1;               /* Protocol Configuration Register 1 */
  FLEXRAY_PCR2_tag PCR2;               /* Protocol Configuration Register 2 */
  FLEXRAY_PCR3_tag PCR3;               /* Protocol Configuration Register 3 */
  FLEXRAY_PCR4_tag PCR4;               /* Protocol Configuration Register 4 */
  FLEXRAY_PCR5_tag PCR5;               /* Protocol Configuration Register 5 */
  FLEXRAY_PCR6_tag PCR6;               /* Protocol Configuration Register 6 */
  FLEXRAY_PCR7_tag PCR7;               /* Protocol Configuration Register 7 */
  FLEXRAY_PCR8_tag PCR8;               /* Protocol Configuration Register 8 */
  FLEXRAY_PCR9_tag PCR9;               /* Protocol Configuration Register 9 */
  FLEXRAY_PCR10_tag PCR10;             /* Protocol Configuration Register 10 */
  FLEXRAY_PCR11_tag PCR11;             /* Protocol Configuration Register 11 */
  FLEXRAY_PCR12_tag PCR12;             /* Protocol Configuration Register 12 */
  FLEXRAY_PCR13_tag PCR13;             /* Protocol Configuration Register 13 */
  FLEXRAY_PCR14_tag PCR14;             /* Protocol Configuration Register 14 */
  FLEXRAY_PCR15_tag PCR15;             /* Protocol Configuration Register 15 */
  FLEXRAY_PCR16_tag PCR16;             /* Protocol Configuration Register 16 */
  FLEXRAY_PCR17_tag PCR17;             /* Protocol Configuration Register 17 */
  FLEXRAY_PCR18_tag PCR18;             /* Protocol Configuration Register 18 */
  FLEXRAY_PCR19_tag PCR19;             /* Protocol Configuration Register 19 */
  FLEXRAY_PCR20_tag PCR20;             /* Protocol Configuration Register 20 */
  FLEXRAY_PCR21_tag PCR21;             /* Protocol Configuration Register 21 */
  FLEXRAY_PCR22_tag PCR22;             /* Protocol Configuration Register 22 */
  FLEXRAY_PCR23_tag PCR23;             /* Protocol Configuration Register 23 */
  FLEXRAY_PCR24_tag PCR24;             /* Protocol Configuration Register 24 */
  FLEXRAY_PCR25_tag PCR25;             /* Protocol Configuration Register 25 */
  FLEXRAY_PCR26_tag PCR26;             /* Protocol Configuration Register 26 */
  FLEXRAY_PCR27_tag PCR27;             /* Protocol Configuration Register 27 */
  FLEXRAY_PCR28_tag PCR28;             /* Protocol Configuration Register 28 */
  FLEXRAY_PCR29_tag PCR29;             /* Protocol Configuration Register 29 */
  FLEXRAY_PCR30_tag PCR30;             /* Protocol Configuration Register 30 */
  FLEXRAY_STPWHR_tag STPWHR;           /* StopWatch Count High Register */
  FLEXRAY_STPWLR_tag STPWLR;           /* Stop Watch Count Low Register */
  FLEXRAY_PEOER_tag PEOER;             /* Protocol Event Output Enable and StopWatch Control Register */
  uint8_t FLEXRAY_reserved1[2];
  FLEXRAY_RFSDOR_tag RFSDOR;           /* Receive FIFO Start Data Offset Register */
  FLEXRAY_RFSYMBADHR_tag RFSYMBADHR;   /* Receive FIFO System Memory Base Address High Register */
  FLEXRAY_RFSYMBADLR_tag RFSYMBADLR;   /* Receive FIFO System Memory Base Address Low Register */
  FLEXRAY_RFPTR_tag RFPTR;             /* Receive FIFO Periodic Timer Register */
  FLEXRAY_RFFLPCR_tag RFFLPCR;         /* Receive FIFO Fill Level and POP Count Register */
  FLEXRAY_EEIFER_tag EEIFER;           /* ECC Error Interrupt Flag and Enable Register */
  FLEXRAY_EERICR_tag EERICR;           /* ECC Error Report and Injection Control Register */
  FLEXRAY_EERAR_tag EERAR;             /* ECC Error Report Address Register */
  FLEXRAY_EERDR_tag EERDR;             /* ECC Error Report Data Register */
  FLEXRAY_EERCR_tag EERCR;             /* ECC Error Report Code Register */
  FLEXRAY_EEIAR_tag EEIAR;             /* ECC Error Injection Address Register */
  FLEXRAY_EEIDR_tag EEIDR;             /* ECC Error Injection Data Register */
  FLEXRAY_EEICR_tag EEICR;             /* ECC Error Injection Code Register */
  uint8_t FLEXRAY_reserved2[1792];
  FLEXRAY_MB_tag MB[256];
  FLEXRAY_MBDOR_tag MBDOR[260];        /* Message Buffer Data Field Offset Register */
  uint8_t FLEXRAY_reserved3[8];
  FLEXRAY_LEETR_tag LEETR[6];          /* LRAM ECC Error Test Register */
};


/* ============================================================================
   =============================== Module: FLEXTIMER ==========================
   ============================================================================ */

typedef union FLEXTIMER_SC_union_tag { /* Status And Control */
  vuint32_t R;
  struct {
    vuint32_t PS:3;                    /* Prescale Factor Selection */
    vuint32_t CLKS:2;                  /* Clock Source Selection */
    vuint32_t CPWMS:1;                 /* Center-Aligned PWM Select */
    vuint32_t RIE:1;                   /* Reload Point Interrupt Enable */
    vuint32_t RF:1;                    /* Reload Flag */
    vuint32_t TOIE:1;                  /* Timer Overflow Interrupt Enable */
    vuint32_t TOF:1;                   /* Timer Overflow Flag */
    vuint32_t _unused_10:6;            /* Reserved */
    vuint32_t PWMEN0:1;                /* Channel 0 PWM enable bit */
    vuint32_t PWMEN1:1;                /* Channel 1 PWM enable bit */
    vuint32_t PWMEN2:1;                /* Channel 2 PWM enable bit */
    vuint32_t PWMEN3:1;                /* Channel 3 PWM enable bit */
    vuint32_t PWMEN4:1;                /* Channel 4 PWM enable bit */
    vuint32_t PWMEN5:1;                /* Channel 5 PWM enable bit */
    vuint32_t _unused_22:2;            /* Reserved */
    vuint32_t FLTPS:4;                 /* Filter Prescaler */
    vuint32_t _unused_28:4;            /* Reserved */
  } B;
} FLEXTIMER_SC_tag;

typedef union FLEXTIMER_CNT_union_tag { /* Counter */
  vuint32_t R;
  struct {
    vuint32_t COUNT:16;                /* Counter Value */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} FLEXTIMER_CNT_tag;

typedef union FLEXTIMER_MOD_union_tag { /* Modulo */
  vuint32_t R;
  struct {
    vuint32_t MOD:16;                  /* MOD */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} FLEXTIMER_MOD_tag;

typedef union FLEXTIMER_CONTROLS_CSC_union_tag { /* Channel (n) Status And Control */
  vuint32_t R;
  struct {
    vuint32_t DMA:1;                   /* DMA Enable */
    vuint32_t ICRST:1;                 /* FTM counter reset by the selected input capture event. */
    vuint32_t ELSA:1;                  /* Channel (n) Edge or Level Select */
    vuint32_t ELSB:1;                  /* Channel (n) Edge or Level Select */
    vuint32_t MSA:1;                   /* Channel (n) Mode Select */
    vuint32_t MSB:1;                   /* Channel (n) Mode Select */
    vuint32_t CHIE:1;                  /* Channel (n) Interrupt Enable */
    vuint32_t CHF:1;                   /* Channel (n) Flag */
    vuint32_t TRIGMODE:1;              /* Trigger mode control */
    vuint32_t CHIS:1;                  /* Channel (n) Input State */
    vuint32_t CHOV:1;                  /* Channel (n) Output Value */
    vuint32_t _unused_11:21;           /* Reserved */
  } B;
} FLEXTIMER_CONTROLS_CSC_tag;

typedef union FLEXTIMER_CONTROLS_CV_union_tag { /* Channel (n) Value */
  vuint32_t R;
  struct {
    vuint32_t VAL:16;                  /* Channel Value */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} FLEXTIMER_CONTROLS_CV_tag;

typedef struct FLEXTIMER_CONTROLS_struct_tag {
  FLEXTIMER_CONTROLS_CSC_tag CSC;      /* Channel (n) Status And Control */
  FLEXTIMER_CONTROLS_CV_tag CV;        /* Channel (n) Value */
} FLEXTIMER_CONTROLS_tag;

typedef union FLEXTIMER_CNTIN_union_tag { /* Counter Initial Value */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;                 /* INIT */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} FLEXTIMER_CNTIN_tag;

typedef union FLEXTIMER_STATUS_union_tag { /* Capture And Compare Status */
  vuint32_t R;
  struct {
    vuint32_t CH0F:1;                  /* Channel 0 Flag */
    vuint32_t CH1F:1;                  /* Channel 1 Flag */
    vuint32_t CH2F:1;                  /* Channel 2 Flag */
    vuint32_t CH3F:1;                  /* Channel 3 Flag */
    vuint32_t CH4F:1;                  /* Channel 4 Flag */
    vuint32_t CH5F:1;                  /* Channel 5 Flag */
    vuint32_t _unused_6:26;            /* Reserved */
  } B;
} FLEXTIMER_STATUS_tag;

typedef union FLEXTIMER_MODE_union_tag { /* Features Mode Selection */
  vuint32_t R;
  struct {
    vuint32_t FTMEN:1;                 /* FTM Enable */
    vuint32_t INIT:1;                  /* Initialize The Channels Output */
    vuint32_t WPDIS:1;                 /* Write Protection Disable */
    vuint32_t PWMSYNC:1;               /* PWM Synchronization Mode */
    vuint32_t CAPTEST:1;               /* Capture Test Mode Enable */
    vuint32_t _unused_5:3;             /* Reserved */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} FLEXTIMER_MODE_tag;

typedef union FLEXTIMER_SYNC_union_tag { /* Synchronization */
  vuint32_t R;
  struct {
    vuint32_t CNTMIN:1;                /* Minimum Loading Point Enable */
    vuint32_t CNTMAX:1;                /* Maximum Loading Point Enable */
    vuint32_t REINIT:1;                /* FTM Counter Reinitialization by Synchronization */
    vuint32_t SYNCHOM:1;               /* Output Mask Synchronization */
    vuint32_t TRIG0:1;                 /* PWM Synchronization Hardware Trigger 0 */
    vuint32_t TRIG1:1;                 /* PWM Synchronization Hardware Trigger 1 */
    vuint32_t TRIG2:1;                 /* PWM Synchronization Hardware Trigger 2 */
    vuint32_t SWSYNC:1;                /* PWM Synchronization Software Trigger */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} FLEXTIMER_SYNC_tag;

typedef union FLEXTIMER_OUTINIT_union_tag { /* Initial State For Channels Output */
  vuint32_t R;
  struct {
    vuint32_t CH0OI:1;                 /* Channel 0 Output Initialization Value */
    vuint32_t CH1OI:1;                 /* Channel 1 Output Initialization Value */
    vuint32_t CH2OI:1;                 /* Channel 2 Output Initialization Value */
    vuint32_t CH3OI:1;                 /* Channel 3 Output Initialization Value */
    vuint32_t CH4OI:1;                 /* Channel 4 Output Initialization Value */
    vuint32_t CH5OI:1;                 /* Channel 5 Output Initialization Value */
    vuint32_t _unused_6:26;            /* Reserved */
  } B;
} FLEXTIMER_OUTINIT_tag;

typedef union FLEXTIMER_OUTMASK_union_tag { /* Output Mask */
  vuint32_t R;
  struct {
    vuint32_t CH0OM:1;                 /* Channel 0 Output Mask */
    vuint32_t CH1OM:1;                 /* Channel 1 Output Mask */
    vuint32_t CH2OM:1;                 /* Channel 2 Output Mask */
    vuint32_t CH3OM:1;                 /* Channel 3 Output Mask */
    vuint32_t CH4OM:1;                 /* Channel 4 Output Mask */
    vuint32_t CH5OM:1;                 /* Channel 5 Output Mask */
    vuint32_t _unused_6:26;            /* Reserved */
  } B;
} FLEXTIMER_OUTMASK_tag;

typedef union FLEXTIMER_COMBINE_union_tag { /* Function For Linked Channels */
  vuint32_t R;
  struct {
    vuint32_t COMBINE0:1;              /* Combine Channels For n = 0 */
    vuint32_t COMP0:1;                 /* Complement Of Channel (n) For n = 0 */
    vuint32_t DECAPEN0:1;              /* Dual Edge Capture Mode Enable For n = 0 */
    vuint32_t DECAP0:1;                /* Dual Edge Capture Mode Captures For n = 0 */
    vuint32_t DTEN0:1;                 /* Deadtime Enable For n = 0 */
    vuint32_t SYNCEN0:1;               /* Synchronization Enable For n = 0 */
    vuint32_t _unused_6:1;             /* Reserved */
    vuint32_t MCOMBINE0:1;             /* Modified Combine Mode For n = 0 */
    vuint32_t COMBINE1:1;              /* Combine Channels For n = 2 */
    vuint32_t COMP1:1;                 /* Complement Of Channel (n) For n = 2 */
    vuint32_t DECAPEN1:1;              /* Dual Edge Capture Mode Enable For n = 2 */
    vuint32_t DECAP1:1;                /* Dual Edge Capture Mode Captures For n = 2 */
    vuint32_t DTEN1:1;                 /* Deadtime Enable For n = 2 */
    vuint32_t SYNCEN1:1;               /* Synchronization Enable For n = 2 */
    vuint32_t _unused_14:1;            /* Reserved */
    vuint32_t MCOMBINE1:1;             /* Modified Combine Mode For n = 2 */
    vuint32_t COMBINE2:1;              /* Combine Channels For n = 4 */
    vuint32_t COMP2:1;                 /* Complement Of Channel (n) For n = 4 */
    vuint32_t DECAPEN2:1;              /* Dual Edge Capture Mode Enable For n = 4 */
    vuint32_t DECAP2:1;                /* Dual Edge Capture Mode Captures For n = 4 */
    vuint32_t DTEN2:1;                 /* Deadtime Enable For n = 4 */
    vuint32_t SYNCEN2:1;               /* Synchronization Enable For n = 4 */
    vuint32_t _unused_22:1;            /* Reserved */
    vuint32_t MCOMBINE2:1;             /* Modified Combine Mode For n = 4 */
    vuint32_t _unused_24:8;            /* Reserved */
  } B;
} FLEXTIMER_COMBINE_tag;

typedef union FLEXTIMER_DEADTIME_union_tag { /* Deadtime Configuration */
  vuint32_t R;
  struct {
    vuint32_t DTVAL:6;                 /* Deadtime Value */
    vuint32_t DTPS:2;                  /* Deadtime Prescaler Value */
    vuint32_t _unused_8:8;             /* Reserved */
    vuint32_t DTVALEX:4;               /* Extended Deadtime Value */
    vuint32_t _unused_20:12;           /* Reserved */
  } B;
} FLEXTIMER_DEADTIME_tag;

typedef union FLEXTIMER_EXTTRIG_union_tag { /* FTM External Trigger */
  vuint32_t R;
  struct {
    vuint32_t CH2TRIG:1;               /* Channel 2 External Trigger Enable */
    vuint32_t CH3TRIG:1;               /* Channel 3 External Trigger Enable */
    vuint32_t CH4TRIG:1;               /* Channel 4 External Trigger Enable */
    vuint32_t CH5TRIG:1;               /* Channel 5 External Trigger Enable */
    vuint32_t CH0TRIG:1;               /* Channel 0 External Trigger Enable */
    vuint32_t CH1TRIG:1;               /* Channel 1 External Trigger Enable */
    vuint32_t INITTRIGEN:1;            /* Initialization Trigger Enable */
    vuint32_t TRIGF:1;                 /* Channel Trigger Flag */
    vuint32_t _unused_8:1;             /* Reserved */
    vuint32_t _unused_9:1;             /* Reserved */
    vuint32_t _unused_10:22;           /* Reserved */
  } B;
} FLEXTIMER_EXTTRIG_tag;

typedef union FLEXTIMER_POL_union_tag { /* Channels Polarity */
  vuint32_t R;
  struct {
    vuint32_t POL0:1;                  /* Channel 0 Polarity */
    vuint32_t POL1:1;                  /* Channel 1 Polarity */
    vuint32_t POL2:1;                  /* Channel 2 Polarity */
    vuint32_t POL3:1;                  /* Channel 3 Polarity */
    vuint32_t POL4:1;                  /* Channel 4 Polarity */
    vuint32_t POL5:1;                  /* Channel 5 Polarity */
    vuint32_t _unused_6:26;            /* Reserved */
  } B;
} FLEXTIMER_POL_tag;

typedef union FLEXTIMER_FMS_union_tag { /* Fault Mode Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;             /* Reserved */
    vuint32_t _unused_1:1;             /* Reserved */
    vuint32_t _unused_2:1;             /* Reserved */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t _unused_4:1;             /* Reserved */
    vuint32_t _unused_5:1;             /* Reserved */
    vuint32_t WPEN:1;                  /* Write Protection Enable */
    vuint32_t _unused_7:25;            /* Reserved */
  } B;
} FLEXTIMER_FMS_tag;

typedef union FLEXTIMER_FILTER_union_tag { /* Input Capture Filter Control */
  vuint32_t R;
  struct {
    vuint32_t CH0FVAL:4;               /* Channel 0 Input Filter */
    vuint32_t CH1FVAL:4;               /* Channel 1 Input Filter */
    vuint32_t CH2FVAL:4;               /* Channel 2 Input Filter */
    vuint32_t CH3FVAL:4;               /* Channel 3 Input Filter */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} FLEXTIMER_FILTER_tag;

typedef union FLEXTIMER_QDCTRL_union_tag { /* Quadrature Decoder Control And Status */
  vuint32_t R;
  struct {
    vuint32_t QUADEN:1;                /* Quadrature Decoder Mode Enable */
    vuint32_t TOFDIR:1;                /* Timer Overflow Direction In Quadrature Decoder Mode */
    vuint32_t QUADIR:1;                /* FTM Counter Direction In Quadrature Decoder Mode */
    vuint32_t QUADMODE:1;              /* Quadrature Decoder Mode */
    vuint32_t PHBPOL:1;                /* Phase B Input Polarity */
    vuint32_t PHAPOL:1;                /* Phase A Input Polarity */
    vuint32_t PHBFLTREN:1;             /* Phase B Input Filter Enable */
    vuint32_t PHAFLTREN:1;             /* Phase A Input Filter Enable */
    vuint32_t _unused_8:24;            /* Reserved */
  } B;
} FLEXTIMER_QDCTRL_tag;

typedef union FLEXTIMER_CONF_union_tag { /* Configuration */
  vuint32_t R;
  struct {
    vuint32_t LDFQ:5;                  /* Frequency of the Reload Opportunities */
    vuint32_t _unused_5:1;             /* Reserved */
    vuint32_t BDMMODE:2;               /* Debug Mode */
    vuint32_t _unused_8:1;             /* Reserved */
    vuint32_t GTBEEN:1;                /* Global Time Base Enable */
    vuint32_t GTBEOUT:1;               /* Global Time Base Output */
    vuint32_t ITRIGR:1;                /* Initialization trigger on Reload Point */
    vuint32_t _unused_12:20;           /* Reserved */
  } B;
} FLEXTIMER_CONF_tag;

typedef union FLEXTIMER_SYNCONF_union_tag { /* Synchronization Configuration */
  vuint32_t R;
  struct {
    vuint32_t HWTRIGMODE:1;            /* Hardware Trigger Mode */
    vuint32_t _unused_1:1;             /* Reserved */
    vuint32_t CNTINC:1;                /* CNTIN Register Synchronization */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t INVC:1;                  /* INVCTRL Register Synchronization */
    vuint32_t SWOC:1;                  /* SWOCTRL Register Synchronization */
    vuint32_t _unused_6:1;             /* Reserved */
    vuint32_t SYNCMODE:1;              /* Synchronization Mode */
    vuint32_t SWRSTCNT:1;              /* FTM counter synchronization is activated by the software trigger */
    vuint32_t SWWRBUF:1;               /* MOD, HCR, CNTIN, and CV registers synchronization is activated by the software trigger */
    vuint32_t SWOM:1;                  /* Output mask synchronization is activated by the software trigger */
    vuint32_t SWINVC:1;                /* Inverting control synchronization is activated by the software trigger */
    vuint32_t SWSOC:1;                 /* Software output control synchronization is activated by the software trigger */
    vuint32_t _unused_13:3;            /* Reserved */
    vuint32_t HWRSTCNT:1;              /* FTM counter synchronization is activated by a hardware trigger */
    vuint32_t HWWRBUF:1;               /* MOD, HCR, CNTIN, and CV registers synchronization is activated by a hardware trigger */
    vuint32_t HWOM:1;                  /* Output mask synchronization is activated by a hardware trigger */
    vuint32_t HWINVC:1;                /* Inverting control synchronization is activated by a hardware trigger */
    vuint32_t HWSOC:1;                 /* Software output control synchronization is activated by a hardware trigger */
    vuint32_t _unused_21:11;           /* Reserved */
  } B;
} FLEXTIMER_SYNCONF_tag;

typedef union FLEXTIMER_INVCTRL_union_tag { /* FTM Inverting Control */
  vuint32_t R;
  struct {
    vuint32_t INV0EN:1;                /* Pair Channels 0 Inverting Enable */
    vuint32_t INV1EN:1;                /* Pair Channels 1 Inverting Enable */
    vuint32_t INV2EN:1;                /* Pair Channels 2 Inverting Enable */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t _unused_4:28;            /* Reserved */
  } B;
} FLEXTIMER_INVCTRL_tag;

typedef union FLEXTIMER_SWOCTRL_union_tag { /* FTM Software Output Control */
  vuint32_t R;
  struct {
    vuint32_t CH0OC:1;                 /* Channel 0 Software Output Control Enable */
    vuint32_t CH1OC:1;                 /* Channel 1 Software Output Control Enable */
    vuint32_t CH2OC:1;                 /* Channel 2 Software Output Control Enable */
    vuint32_t CH3OC:1;                 /* Channel 3 Software Output Control Enable */
    vuint32_t CH4OC:1;                 /* Channel 4 Software Output Control Enable */
    vuint32_t CH5OC:1;                 /* Channel 5 Software Output Control Enable */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t CH0OCV:1;                /* Channel 0 Software Output Control Value */
    vuint32_t CH1OCV:1;                /* Channel 1 Software Output Control Value */
    vuint32_t CH2OCV:1;                /* Channel 2 Software Output Control Value */
    vuint32_t CH3OCV:1;                /* Channel 3 Software Output Control Value */
    vuint32_t CH4OCV:1;                /* Channel 4 Software Output Control Value */
    vuint32_t CH5OCV:1;                /* Channel 5 Software Output Control Value */
    vuint32_t _unused_14:2;            /* Reserved */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} FLEXTIMER_SWOCTRL_tag;

typedef union FLEXTIMER_PWMLOAD_union_tag { /* FTM PWM Load */
  vuint32_t R;
  struct {
    vuint32_t CH0SEL:1;                /* Channel 0 Select */
    vuint32_t CH1SEL:1;                /* Channel 1 Select */
    vuint32_t CH2SEL:1;                /* Channel 2 Select */
    vuint32_t CH3SEL:1;                /* Channel 3 Select */
    vuint32_t CH4SEL:1;                /* Channel 4 Select */
    vuint32_t CH5SEL:1;                /* Channel 5 Select */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t HCSEL:1;                 /* Half Cycle Select */
    vuint32_t LDOK:1;                  /* Load Enable */
    vuint32_t GLEN:1;                  /* Global Load Enable */
    vuint32_t GLDOK:1;                 /* Global Load OK */
    vuint32_t _unused_12:20;           /* Reserved */
  } B;
} FLEXTIMER_PWMLOAD_tag;

typedef union FLEXTIMER_HCR_union_tag { /* Half Cycle Register */
  vuint32_t R;
  struct {
    vuint32_t HCVAL:16;                /* Half Cycle Value */
    vuint32_t _unused_16:16;           /* Reserved */
  } B;
} FLEXTIMER_HCR_tag;

typedef union FLEXTIMER_MOD_MIRROR_union_tag { /* Mirror of Modulo Value */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:11;            /* Reserved */
    vuint32_t FRACMOD:5;               /* Modulo Fractional Value */
    vuint32_t MOD:16;                  /* Mirror of the Modulo Integer Value */
  } B;
} FLEXTIMER_MOD_MIRROR_tag;

typedef union FLEXTIMER_CV_MIRROR_union_tag { /* Mirror of Channel (n) Match Value */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:11;            /* Reserved */
    vuint32_t FRACVAL:5;               /* Channel (n) Match Fractional Value */
    vuint32_t VAL:16;                  /* Mirror of the Channel (n) Match Integer Value */
  } B;
} FLEXTIMER_CV_MIRROR_tag;

struct FLEXTIMER_tag {
  FLEXTIMER_SC_tag SC;                 /* Status And Control */
  FLEXTIMER_CNT_tag CNT;               /* Counter */
  FLEXTIMER_MOD_tag MOD;               /* Modulo */
  FLEXTIMER_CONTROLS_tag CONTROLS[6];
  uint8_t FLEXTIMER_reserved0[16];
  FLEXTIMER_CNTIN_tag CNTIN;           /* Counter Initial Value */
  FLEXTIMER_STATUS_tag STATUS;         /* Capture And Compare Status */
  FLEXTIMER_MODE_tag MODE;             /* Features Mode Selection */
  FLEXTIMER_SYNC_tag SYNC;             /* Synchronization */
  FLEXTIMER_OUTINIT_tag OUTINIT;       /* Initial State For Channels Output */
  FLEXTIMER_OUTMASK_tag OUTMASK;       /* Output Mask */
  FLEXTIMER_COMBINE_tag COMBINE;       /* Function For Linked Channels */
  FLEXTIMER_DEADTIME_tag DEADTIME;     /* Deadtime Configuration */
  FLEXTIMER_EXTTRIG_tag EXTTRIG;       /* FTM External Trigger */
  FLEXTIMER_POL_tag POL;               /* Channels Polarity */
  FLEXTIMER_FMS_tag FMS;               /* Fault Mode Status */
  FLEXTIMER_FILTER_tag FILTER;         /* Input Capture Filter Control */
  uint8_t FLEXTIMER_reserved1[4];
  FLEXTIMER_QDCTRL_tag QDCTRL;         /* Quadrature Decoder Control And Status */
  FLEXTIMER_CONF_tag CONF;             /* Configuration */
  uint8_t FLEXTIMER_reserved2[4];
  FLEXTIMER_SYNCONF_tag SYNCONF;       /* Synchronization Configuration */
  FLEXTIMER_INVCTRL_tag INVCTRL;       /* FTM Inverting Control */
  FLEXTIMER_SWOCTRL_tag SWOCTRL;       /* FTM Software Output Control */
  FLEXTIMER_PWMLOAD_tag PWMLOAD;       /* FTM PWM Load */
  FLEXTIMER_HCR_tag HCR;               /* Half Cycle Register */
  uint8_t FLEXTIMER_reserved3[352];
  FLEXTIMER_MOD_MIRROR_tag MOD_MIRROR; /* Mirror of Modulo Value */
  FLEXTIMER_CV_MIRROR_tag CV_MIRROR[6]; /* Mirror of Channel (n) Match Value */
};


/* ============================================================================
   =============================== Module: FXOSC ==============================
   ============================================================================ */

typedef union FXOSC_FXOSC_CTRL_union_tag { /* FXOSC Control Register */
  vuint32_t R;
  struct {
    vuint32_t OSCON:1;                 /* Crystal oscillator power-down control */
    vuint32_t _unused_1:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_3:1;
    vuint32_t GM_SEL:4;                /* Crystal overdrive protection */
    vuint32_t _unused_8:8;
    vuint32_t EOCV:8;                  /* End of count value */
    vuint32_t COMP_EN:1;               /* Comparator enable */
    vuint32_t _unused_25:1;
    vuint32_t _unused_26:4;
    vuint32_t _unused_30:1;
    vuint32_t OSC_BYP:1;               /* Oscillator bypass */
  } B;
} FXOSC_FXOSC_CTRL_tag;

typedef union FXOSC_FXOSC_STAT_union_tag { /* Oscillator Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:31;
    vuint32_t OSC_STAT:1;              /* Crystal oscillator status */
  } B;
} FXOSC_FXOSC_STAT_tag;

struct FXOSC_tag {
  FXOSC_FXOSC_CTRL_tag FXOSC_CTRL;     /* FXOSC Control Register */
  FXOSC_FXOSC_STAT_tag FXOSC_STAT;     /* Oscillator Status Register */
};


/* ============================================================================
   =============================== Module: GMAC ===============================
   ============================================================================ */

typedef union GMAC_MAC_CONFIGURATION_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RE:1;                    /* Receiver Enable When this bit is set, the Rx state machine of the MAC is enabled for receiving packets from the GMII or MII interface. When this bit is reset, the MAC Rx state machine is disabled after it completes the reception of the current packet. The Rx state machine does not receive any more packets from the GMII or MII interface. */
    vuint32_t TE:1;                    /* Transmitter Enable When this bit is set, the Tx state machine of the MAC is enabled for transmission on the GMII or MII interface. When this bit is reset, the MAC Tx state machine is disabled after it completes the transmission of the current packet. The Tx state machine does not transmit any more packets. */
    vuint32_t PRELEN:2;                /* Preamble Length for Transmit packets These bits control the number of preamble bytes that are added to the beginning of every Tx packet. The preamble reduction occurs only when the MAC is operating in the full-duplex mode. */
    vuint32_t DC:1;                    /* Deferral Check When this bit is set, the deferral check function is enabled in the MAC. The MAC issues a Packet Abort status, along with the excessive deferral error bit set in the Tx packet status, when the Tx state machine is deferred for more than 24,288 bit times in 10 or 100 Mbps mode. If the MAC is configured for 1000/2500 Mbps operation, the threshold for deferral is 155,680 bits times. Deferral begins when the transmitter is ready to transmit, but it is prevented because of an active carrier sense signal (CRS) on GMII or MII. The defer time is not cumulative. For example, if the transmitter defers for 10,000 bit times because the CRS signal is active and the CRS signal becomes inactive, the transmitter transmits and collision happens. Because of collision, the transmitter needs to back off and then defer again after back off completion. In such a scenario, the deferral timer is reset to 0, and it is restarted. When this bit is reset, the deferral check function is disabled and the MAC defers until the CRS signal goes inactive. This bit is applicable only in the half-duplex mode. */
    vuint32_t BL:2;                    /* Back-Off Limit The back-off limit determines the random integer number (r) of slot time delays (4,096 bit times for 1000/2500 Mbps; 512 bit times for 10/100 Mbps) for which the MAC waits before rescheduling a transmission attempt during retries after a collision. n = retransmission attempt. The random integer r takes the value in the range 0 <= r < 2^k This bit is applicable only in the half-duplex mode. */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t DR:1;                    /* Disable Retry When this bit is set, the MAC attempts only one transmission. When a collision occurs on the GMII or MII interface, the MAC ignores the current packet transmission and reports a Packet Abort with excessive collision error in the Tx packet status. When this bit is reset, the MAC retries based on the settings of the BL field. This bit is applicable only in the half-duplex mode. */
    vuint32_t DCRS:1;                  /* Disable Carrier Sense During Transmission When this bit is set, the MAC transmitter ignores the (G)MII CRS signal during packet transmission in the half-duplex mode. As a result, no errors are generated because of Loss of Carrier or No Carrier during transmission. When this bit is reset, the MAC transmitter generates errors because of Carrier Sense. The MAC can even abort the transmission. */
    vuint32_t DO:1;                    /* Disable Receive Own When this bit is set, the MAC disables the reception of packets when the gmii_txen_o is asserted in the half-duplex mode. When this bit is reset, the MAC receives all packets given by the PHY. This bit is not applicable in the full-duplex mode. */
    vuint32_t ECRSFD:1;                /* Enable Carrier Sense Before Transmission in Full-Duplex Mode When this bit is set, the MAC transmitter checks the CRS signal before packet transmission in the full-duplex mode. The MAC starts the transmission only when the CRS signal is low. When this bit is reset, the MAC transmitter ignores the status of the CRS signal. */
    vuint32_t LM:1;                    /* Loopback Mode When this bit is set, the MAC operates in the loopback mode at GMII or MII. The (G)MII Rx clock input (clk_rx_i) is required for the loopback to work properly. This is because the Tx clock is not internally looped back. */
    vuint32_t DM:1;                    /* Duplex Mode When this bit is set, the MAC operates in the full-duplex mode in which it can transmit and receive simultaneously. This bit is RO with default value of 1'b1 in the full-duplex-only configurations. */
    vuint32_t FES:1;                   /* Speed This bit selects the speed mode. The mac_speed_o[0] signal reflects the value of this bit. */
    vuint32_t PS:1;                    /* Port Select This bit selects the Ethernet line speed. This bit, along with Bit 14, selects the exact line speed. In the 10/100 Mbps-only (always 1) or 1000 Mbps-only (always 0) configurations, this bit is read-only (RO) with appropriate value. In default 10/100/1000 Mbps configurations, this bit is read-write (R/W). The mac_speed_o[1] signal reflects the value of this bit. */
    vuint32_t JE:1;                    /* Jumbo Packet Enable When this bit is set, the MAC allows jumbo packets of 9,018 bytes (9,022 bytes for VLAN tagged packets) without reporting a giant packet error in the Rx packet status. */
    vuint32_t JD:1;                    /* Jabber Disable When this bit is set, the MAC disables the jabber timer on the transmitter. The MAC can transfer packets of up to 16,383 bytes. When this bit is reset, if the application sends more than 2,048 bytes of data (10,240 if JE is set high) during transmission, the MAC does not send rest of the bytes in that packet. */
    vuint32_t BE:1;                    /* Packet Burst Enable When this bit is set, the MAC allows packet bursting during transmission in the GMII half-duplex mode. */
    vuint32_t WD:1;                    /* Watchdog Disable When this bit is set, the MAC disables the watchdog timer on the receiver. The MAC can receive packets of up to 16,383 bytes. When this bit is reset, the MAC does not allow more than 2,048 bytes (10,240 if JE is set high) of the packet being received. The MAC cuts off any bytes received after 2,048 bytes. */
    vuint32_t ACS:1;                   /* Automatic Pad or CRC Stripping When this bit is set, the MAC strips the Pad or FCS field on the incoming packets only if the value of the length field is less than 1,536 bytes. All received packets with length field greater than or equal to 1,536 bytes are passed to the application without stripping the Pad or FCS field. When this bit is reset, the MAC passes all incoming packets to the application, without any modification. Note: For information about how the settings of CST bit and this bit impact the packet length, see the Table, Packet Length based on the CST and ACS Bit . */
    vuint32_t CST:1;                   /* CRC stripping for Type packets When this bit is set, the last four bytes (FCS) of all packets of Ether type (type field greater than 1,536) are stripped and dropped before forwarding the packet to the application. Note: For information about how the settings of the ACS bit and this bit impact the packet length, see the Table, Packet Length based on the CST and ACS Bits. */
    vuint32_t S2KP:1;                  /* IEEE 802.3as Support for 2K Packets When this bit is set, the MAC considers all packets with up to 2,000 bytes length as normal packets. When the JE bit is not set, the MAC considers all received packets of size more than 2K bytes as Giant packets. When this bit is reset and the JE bit is not set, the MAC considers all received packets of size more than 1,518 bytes (1,522 bytes for tagged) as giant packets. For more information about how the setting of this bit and the JE bit impact the Giant packet status, see the Table, Gaint Packet Status based on S2KP and JE Bits. Note: When the JE bit is set, setting this bit has no effect on the giant packet status. */
    vuint32_t GPSLCE:1;                /* Giant Packet Size Limit Control Enable When this bit is set, the MAC considers the value in GPSL field in MAC_Ext_Configuration register to declare a received packet as Giant packet. This field must be programmed to more than 1,518 bytes. Otherwise, the MAC considers 1,518 bytes as giant packet limit. When this bit is reset, the MAC considers a received packet as Giant packet when its size is greater than 1,518 bytes (1522 bytes for tagged packet). The watchdog timeout limit, Jumbo Packet Enable and 2K Packet Enable have higher precedence over this bit, that is the MAC considers a received packet as Giant packet when its size is greater than 9,018 bytes (9,022 bytes for tagged packet) with Jumbo Packet Enabled and greater than 2,000 bytes with 2K Packet Enabled. The watchdog timeout, if enabled, terminates the received packet when watchdog limit is reached. Therefore, the programmed giant packet limit should be less than the watchdog limit to get the giant packet status. */
    vuint32_t IPG:3;                   /* Inter-Packet Gap These bits control the minimum IPG between packets during transmission. This range of minimum IPG is valid in full-duplex mode. In the half-duplex mode, the minimum IPG can be configured only for 64-bit times (IPG = 100). Lower values are not considered. When a JAM pattern is being transmitted because of backpressure activation, the MAC does not consider the minimum IPG. The above function (IPG less than 96 bit times) is valid only when EIPGEN bit in MAC_Ext_Configuration register is reset. When EIPGEN is set, then the minimum IPG (greater than 96 bit times) is controlled as per the description given in EIPG field in MAC_Ext_Configuration register. */
    vuint32_t IPC:1;                   /* Checksum Offload When set, this bit enables the IPv4 header checksum checking and IPv4 or IPv6 TCP, UDP, or ICMP payload checksum checking. When this bit is reset, the COE function in the receiver is disabled. The Layer 3 and Layer 4 Packet Filter and Enable Split Header features automatically selects the IPC Full Checksum Offload Engine on the Receive side. When any of these features are enabled, you must set the IPC bit. */
    vuint32_t SARC:3;                  /* Source Address Insertion or Replacement Control This field controls the source address insertion or replacement for all transmitted packets. Bit 30 specifies which MAC Address register (0 or 1) is used for source address insertion or replacement based on the values of Bits[29:28]: 2'b0x: - The mti_sa_ctrl_i and ati_sa_ctrl_i input signals control the SA field generation. 2'b10: - If Bit 30 is set to 0, the MAC inserts the content of the MAC Address 0 registers in the SA field of all transmitted packets. - If Bit 30 is set to 1 and the Enable MAC Address Register 1 option is selected while configuring the core, the MAC inserts the content of the MAC Address 1 registers in the SA field of all transmitted packets. 2'b11: - If Bit 30 is set to 0, the MAC replaces the content of the MAC Address 0 registers in the SA field of all transmitted packets. - If Bit 30 is set to 1 and the MAC Address Register 1 is enabled, the MAC replaces the content of the MAC Address 1 registers in the SA field of all transmitted packets. Note: - Changes to this field take effect only on the start of a packet. If you write to this register field when a packet is being transmitted, only the subsequent packet can use the updated value, that is, the current packet does not use the updated value. */
    vuint32_t ARPEN:1;                 /* ARP Offload Enable When this bit is set, the MAC can recognize an incoming ARP request packet and schedules the ARP packet for transmission. It forwards the ARP packet to the application and also indicate the events in the RxStatus. When this bit is reset, the MAC receiver does not recognize any ARP packet and indicates them as Type frame in the RxStatus. This bit is available only when the Enable IPv4 ARP Offload is selected. */
  } B;
} GMAC_MAC_CONFIGURATION_tag;

typedef union GMAC_MAC_EXT_CONFIGURATION_union_tag {
  vuint32_t R;
  struct {
    vuint32_t GPSL:14;                 /* Giant Packet Size Limit If the received packet size is greater than the value programmed in this field in units of bytes, the MAC declares the received packet as Giant packet. The value programmed in this field must be greater than or equal to 1,518 bytes. Any other programmed value is considered as 1,518 bytes. For VLAN tagged packets, the MAC adds 4 bytes to the programmed value. When the Enable Double VLAN Processing option is selected, the MAC adds 8 bytes to the programmed value for double VLAN tagged packets. The value in this field is applicable when the GPSLCE bit is set in MAC_Configuration register. */
    vuint32_t _unused_14:2;            /* Reserved. */
    vuint32_t DCRCC:1;                 /* Disable CRC Checking for Received Packets When this bit is set, the MAC receiver does not check the CRC field in the received packets. When this bit is reset, the MAC receiver always checks the CRC field in the received packets. */
    vuint32_t SPEN:1;                  /* Slow Protocol Detection Enable When this bit is set, MAC processes the Slow Protocol packets (Ether Type 0x8809) and provides the Rx status. The MAC discards the Slow Protocol packets with invalid sub-types. When this bit is reset, the MAC forwards all error-free Slow Protocol packets to the application. The MAC considers such packets as normal Type packets. */
    vuint32_t USP:1;                   /* Unicast Slow Protocol Packet Detect When this bit is set, the MAC detects the Slow Protocol packets with unicast address of the station specified in the MAC_Address0_High and MAC_Address0_Low registers. The MAC also detects the Slow Protocol packets with the Slow Protocols multicast address (01-80-C2-00-00-02). When this bit is reset, the MAC detects only Slow Protocol packets with the Slow Protocol multicast address specified in the IEEE 802.3-2015, Section 5. */
    vuint32_t PDC:1;                   /* Packet Duplication Control When this bit is set, the received packet with Multicast/Broadcast Destination address is routed to multiple Receive DMA Channels. The Receive DMA Channels is identified by the DCS field of MAC_Address(#i)_High register corresponding to the MAC Address register that matches the Multicast/Broadcast Destination address in the received packet. The DCS field is interpreted to be a one-hot value, each bit corresponding to the Receive DMA Channel. When this bit is reset, the received packet is routed to single Receive DMA Channel. The Receive DMA Channel is identified by the DCS field of MAC_Address(#i)_High register corresponding to the MAC Address register that matches the Destination address in the received packet. The DCS field is interpreted as a binary value. */
    vuint32_t HDSMS:3;                 /* Maximum Size for Splitting the Header Data These bits indicate the maximum header size allowed for splitting the header data in the received packet. */
    vuint32_t _unused_23:1;            /* Reserved. */
    vuint32_t EIPGEN:1;                /* Extended Inter-Packet Gap Enable When this bit is set, the MAC interprets EIPG field and IPG field in MAC_Configuration register together as minimum IPG greater than 96 bit times in steps of 8 bit times. When this bit is reset, the MAC ignores EIPG field and interprets IPG field in MAC_Configuration register as minimum IPG less than or equal to 96 bit times in steps of 8 bit times. Note: The extended Inter-Packet Gap feature must be enabled when operating in Full-Duplex mode only. There may be undesirable effects on back-pressure function and frame transmission if it is enabled in Half-Duplex mode. */
    vuint32_t EIPG:5;                  /* Extended Inter-Packet Gap The value in this field is applicable when the EIPGEN bit is set. This field (as Most Significant bits), along with IPG field in MAC_Configuration register, gives the minimum IPG greater than 96 bit times in steps of 8 bit times: {EIPG, IPG} 8'h00 - 104 bit times 8'h01 - 112 bit times 8'h02 - 120 bit times ----------------------- 8'hFF - 2144 bit times */
    vuint32_t _unused_30:1;            /* Reserved. */
    vuint32_t _unused_31:1;            /* Reserved. */
  } B;
} GMAC_MAC_EXT_CONFIGURATION_tag;

typedef union GMAC_MAC_PACKET_FILTER_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PR:1;                    /* Promiscuous Mode When this bit is set, the Address Filtering module passes all incoming packets irrespective of the destination or source address. The SA or DA Filter Fails status bits of the Rx Status Word are always cleared when PR is set. */
    vuint32_t HUC:1;                   /* Hash Unicast When this bit is set, the MAC performs the destination address filtering of unicast packets according to the hash table. When this bit is reset, the MAC performs a perfect destination address filtering for unicast packets, that is, it compares the DA field with the values programmed in DA registers. */
    vuint32_t HMC:1;                   /* Hash Multicast When this bit is set, the MAC performs the destination address filtering of received multicast packets according to the hash table. When this bit is reset, the MAC performs the perfect destination address filtering for multicast packets, that is, it compares the DA field with the values programmed in DA registers. */
    vuint32_t DAIF:1;                  /* DA Inverse Filtering When this bit is set, the Address Check block operates in inverse filtering mode for the DA address comparison for both unicast and multicast packets. When this bit is reset, normal filtering of packets is performed. */
    vuint32_t PM:1;                    /* Pass All Multicast When this bit is set, it indicates that all received packets with a multicast destination address (first bit in the destination address field is '1') are passed. When this bit is reset, filtering of multicast packet depends on HMC bit. */
    vuint32_t DBF:1;                   /* Disable Broadcast Packets When this bit is set, the AFM module blocks all incoming broadcast packets. In addition, it overrides all other filter settings. When this bit is reset, the AFM module passes all received broadcast packets. */
    vuint32_t PCF:2;                   /* Pass Control Packets These bits control the forwarding of all control packets (including unicast and multicast Pause packets). */
    vuint32_t SAIF:1;                  /* SA Inverse Filtering When this bit is set, the Address Check block operates in the inverse filtering mode for SA address comparison. If the SA of a packet matches the values programmed in the SA registers, it is marked as failing the SA Address filter. When this bit is reset, if the SA of a packet does not match the values programmed in the SA registers, it is marked as failing the SA Address filter. */
    vuint32_t SAF:1;                   /* Source Address Filter Enable When this bit is set, the MAC compares the SA field of the received packets with the values programmed in the enabled SA registers. If the comparison fails, the MAC drops the packet. When this bit is reset, the MAC forwards the received packet to the application with updated SAF bit of the Rx Status depending on the SA address comparison. Note: According to the IEEE specification, Bit 47 of the SA is reserved. However, in GMAC, the MAC compares all 48 bits. The software driver should take this into consideration while programming the MAC address registers for SA. */
    vuint32_t HPF:1;                   /* Hash or Perfect Filter When this bit is set, the address filter passes a packet if it matches either the perfect filtering or hash filtering as set by the HMC or HUC bit. When this bit is reset and the HUC or HMC bit is set, the packet is passed only if it matches the Hash filter. */
    vuint32_t _unused_11:5;            /* Reserved. */
    vuint32_t VTFE:1;                  /* VLAN Tag Filter Enable When this bit is set, the MAC drops the VLAN tagged packets that do not match the VLAN Tag. When this bit is reset, the MAC forwards all packets irrespective of the match status of the VLAN Tag. */
    vuint32_t _unused_17:3;            /* Reserved. */
    vuint32_t IPFE:1;                  /* Layer 3 and Layer 4 Filter Enable When this bit is set, the MAC drops packets that do not match the enabled Layer 3 and Layer 4 filters. If Layer 3 or Layer 4 filters are not enabled for matching, this bit does not have any effect. When this bit is reset, the MAC forwards all packets irrespective of the match status of the Layer 3 and Layer 4 fields. */
    vuint32_t DNTU:1;                  /* Drop Non-TCP/UDP over IP Packets When this bit is set, the MAC drops the non-TCP or UDP over IP packets. The MAC forward only those packets that are processed by the Layer 4 filter. When this bit is reset, the MAC forwards all non-TCP or UDP over IP packets. */
    vuint32_t _unused_22:9;            /* Reserved. */
    vuint32_t RA:1;                    /* Receive All When this bit is set, the MAC Receiver module passes all received packets to the application, irrespective of whether they pass the address filter or not. The result of the SA or DA filtering is updated (pass or fail) in the corresponding bit in the Rx Status Word. When this bit is reset, the Receiver module passes only those packets to the application that pass the SA or DA address filter. */
  } B;
} GMAC_MAC_PACKET_FILTER_tag;

typedef union GMAC_MAC_WATCHDOG_TIMEOUT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t WTO:4;                   /* Watchdog Timeout When the PWE bit is set and the WD bit of the MAC_Configuration register is reset, this field is used as watchdog timeout for a received packet. If the length of a received packet exceeds the value of this field, such packet is terminated and declared as an error packet. Note: When the PWE bit is set, the value in this field should be more than 1,522 (0x05F2). Otherwise, the IEEE 802.3-specified valid tagged packets are declared as error packets and then dropped. */
    vuint32_t _unused_4:4;             /* Reserved. */
    vuint32_t PWE:1;                   /* Programmable Watchdog Enable When this bit is set and the WD bit of the MAC_Configuration register is reset, the WTO field is used as watchdog timeout for a received packet. When this bit is cleared, the watchdog timeout for a received packet is controlled by setting of WD and JE bits in MAC_Configuration register. */
    vuint32_t _unused_9:23;            /* Reserved. */
  } B;
} GMAC_MAC_WATCHDOG_TIMEOUT_tag;

typedef union GMAC_MAC_HASH_TABLE_REG0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HT31T0:32;               /* MAC Hash Table First 32 Bits This field contains the first 32 Bits [31:0] of the Hash table. */
  } B;
} GMAC_MAC_HASH_TABLE_REG0_tag;

typedef union GMAC_MAC_HASH_TABLE_REG1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HT63T32:32;              /* MAC Hash Table Second 32 Bits This field contains the second 32 Bits [63:32] of the Hash table. */
  } B;
} GMAC_MAC_HASH_TABLE_REG1_tag;

typedef union GMAC_MAC_HASH_TABLE_REG2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HT95T64:32;              /* MAC Hash Table Third 32 Bits This field contains the third 32 Bits [95:64] of the Hash table. */
  } B;
} GMAC_MAC_HASH_TABLE_REG2_tag;

typedef union GMAC_MAC_HASH_TABLE_REG3_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HT127T96:32;             /* MAC Hash Table Fourth 32 Bits This field contains the fourth 32 Bits [127:96] of the Hash table. */
  } B;
} GMAC_MAC_HASH_TABLE_REG3_tag;

typedef union GMAC_MAC_HASH_TABLE_REG4_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HT159T128:32;            /* MAC Hash Table Fifth 32 Bits This field contains the fifth 32 Bits [159:128] of the Hash table. */
  } B;
} GMAC_MAC_HASH_TABLE_REG4_tag;

typedef union GMAC_MAC_HASH_TABLE_REG5_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HT191T160:32;            /* MAC Hash Table Sixth 32 Bits This field contains the sixth 32 Bits [191:160] of the Hash table. */
  } B;
} GMAC_MAC_HASH_TABLE_REG5_tag;

typedef union GMAC_MAC_HASH_TABLE_REG6_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HT223T192:32;            /* MAC Hash Table Seventh 32 Bits This field contains the seventh 32 Bits [223:192] of the Hash table. */
  } B;
} GMAC_MAC_HASH_TABLE_REG6_tag;

typedef union GMAC_MAC_HASH_TABLE_REG7_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HT255T224:32;            /* MAC Hash Table Eighth 32 Bits This field contains the eighth 32 Bits [255:224] of the Hash table. */
  } B;
} GMAC_MAC_HASH_TABLE_REG7_tag;

typedef union GMAC_MAC_VLAN_TAG_CTRL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t OB:1;                    /* Operation Busy This bit is set along with a read or write command for initiating the indirect access to per VLAN Tag Filter register. This bit is reset when the read or write command to per VLAN Tag Filter indirect access register is complete. The next indirect register access can be initiated only after this bit is reset. During a write operation, the bit is reset only after the data has been written into the Per VLAN Tag register. During a read operation, the data should be read from the MAC_VLAN_Tag_Data register only after this bit is reset. */
    vuint32_t CT:1;                    /* Command Type This bit indicates if the current register access is a read or a write. When set, it indicate a read operation. When reset, it indicates a write operation. */
    vuint32_t OFS:5;                   /* Offset This field holds the address offset of the MAC VLAN Tag Filter Register which the application is trying to access. The width of the field depends on the number of MAC VLAN Tag Registers enabled. */
    vuint32_t _unused_7:10;            /* Reserved. */
    vuint32_t VTIM:1;                  /* VLAN Tag Inverse Match Enable When this bit is set, this bit enables the VLAN Tag inverse matching. The packets without matching VLAN Tag are marked as matched. When reset, this bit enables the VLAN Tag perfect matching. The packets with matched VLAN Tag are marked as matched. */
    vuint32_t ESVL:1;                  /* Enable S-VLAN When this bit is set, the MAC transmitter and receiver consider the S-VLAN packets (Type = 0x88A8) as valid VLAN tagged packets. */
    vuint32_t _unused_19:2;            /* Reserved. */
    vuint32_t EVLS:2;                  /* Enable VLAN Tag Stripping on Receive This field indicates the stripping operation on the outer VLAN Tag in received packet. */
    vuint32_t _unused_23:1;            /* Reserved. */
    vuint32_t EVLRXS:1;                /* Enable VLAN Tag in Rx status When this bit is set, MAC provides the outer VLAN Tag in the Rx status. When this bit is reset, the MAC does not provide the outer VLAN Tag in Rx status. */
    vuint32_t VTHM:1;                  /* VLAN Tag Hash Table Match Enable When this bit is set, the most significant four bits of CRC of VLAN Tag (ones-complement of most significant four bits of CRC of VLAN Tag when ETV bit is reset) are used to index the content of the MAC_VLAN_Hash_Table register. A value of 1 in the VLAN Hash Table register, corresponding to the index, indicates that the packet matched the VLAN hash table. When the ETV bit is set, the CRC of the 12-bit VLAN Identifier (VID) is used for comparison. When the ETV bit is reset, the ones-complement of the CRC of the 16-bit VLAN tag is used for comparison. When this bit is reset, the VLAN Hash Match operation is not performed. */
    vuint32_t EDVLP:1;                 /* Enable Double VLAN Processing When this bit is set, the MAC enables processing of up to two VLAN Tags on Tx and Rx (if present). When this bit is reset, the MAC enables processing of up to one VLAN Tag on Tx and Rx (if present). */
    vuint32_t ERIVLT:1;                /* ERIVLT */
    vuint32_t EIVLS:2;                 /* Enable Inner VLAN Tag Stripping on Receive This field indicates the stripping operation on inner VLAN Tag in received packet. */
    vuint32_t _unused_30:1;            /* Reserved. */
    vuint32_t EIVLRXS:1;               /* Enable Inner VLAN Tag in Rx Status When this bit is set, the MAC provides the inner VLAN Tag in the Rx status. When this bit is reset, the MAC does not provide the inner VLAN Tag in Rx status. */
  } B;
} GMAC_MAC_VLAN_TAG_CTRL_tag;

typedef union GMAC_MAC_VLAN_TAG_DATA_union_tag {
  vuint32_t R;
  struct {
    vuint32_t VID:16;                  /* VLAN Tag ID This field holds the VLAN Tag value which is used by the MAC for perfect comparison. It is valid when VLAN Tag Enable is set. */
    vuint32_t VEN:1;                   /* VLAN Tag Enable This bit is used to enable or disable the VLAN Tag. When this bit is set, the MAC compares the VLAN Tag of received packet with the VLAN Tag ID. When this bit is reset, no comparison is performed irrespective of the programming of the other fields. */
    vuint32_t ETV:1;                   /* 12bits or 16bits VLAN comparison This bit is valid only when VEN of the Filter is set. When this bit is set, a 12-bit VLAN identifier is used for comparing and filtering instead of the complete 16-bit VLAN tag. Bits [11:0] of VLAN tag are compared with the corresponding field in the received VLAN-tagged packet. */
    vuint32_t DOVLTC:1;                /* Disable VLAN Type Comparison This bit is valid only when VLAN Tag Enable of the Filter is set. When this bit is set, the MAC does not check whether the VLAN Tag specified by the Enable Inner VLAN Tag Comparison bit is of type S-VLAN or C-VLAN. When this bit is reset, the MAC filters or matches the VLAN Tag specified by the Enable Inner VLAN Tag Comparison bit only when VLAN Tag type is similar to the one specified by the Enable S-VLAN Match for received Frames bit. */
    vuint32_t ERSVLM:1;                /* Enable S-VLAN Match for received Frames This bit is valid only when VLAN Tag Enable of the Filter is set. When this bit is set, the MAC receiver enables filtering or matching for S-VLAN (Type = 0x88A8) packets. When this bit is reset, the MAC receiver enables filtering or matching for C-VLAN (Type = 0x8100) packets. */
    vuint32_t ERIVLT:1;                /* Enable Inner VLAN Tag Comparison This bit is valid only when VLAN Tag Enable of the Filter is set. When this bit and the EDVLP field are set, the MAC receiver enables operation on the inner VLAN Tag (if present). When this bit is reset, the MAC receiver enables operation on the outer VLAN Tag (if present). */
    vuint32_t _unused_21:3;            /* Reserved. */
    vuint32_t DMACHEN:1;               /* DMA Channel Number Enable This bit is the Enable for the DMA Channel Number value programmed in the field DMACH. When this bit is reset, the Routing does not occur based on VLAN Filter result. The frame is routed based on DA Based DMA Channel Routing. */
    vuint32_t DMACHN:3;                /* DMA Channel Number The DMA Channel number to which the VLAN Tagged Frame is to be routed if it passes this VLAN Tag Filter is programmed in this field. If the Routing based on VLAN Tag Filter is not necessary, this field need not be programmed. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_MAC_VLAN_TAG_DATA_tag;

typedef union GMAC_MAC_VLAN_HASH_TABLE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t VLHT:16;                 /* VLAN Hash Table This field contains the 16-bit VLAN Hash Table. */
    vuint32_t _unused_16:16;           /* Reserved. */
  } B;
} GMAC_MAC_VLAN_HASH_TABLE_tag;

typedef union GMAC_MAC_VLAN_INCL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t VLT:16;                  /* VLAN Tag for Transmit Packets This field contains the value of the VLAN tag to be inserted or replaced. The value must only be changed when the transmit lines are inactive or during the initialization phase. Bits[15:13] are the User Priority field, Bit 12 is the CFI/DEI field, and Bits[11:0] are the VID field in the VLAN tag. The following list describes the bits of this field: - Bits[15:13]: User Priority - Bit 12: Canonical Format Indicator (CFI) or Drop Eligible Indicator (DEI) - Bits[11:0]: VLAN Identifier (VID) field of VLAN tag */
    vuint32_t VLC:2;                   /* VLAN Tag Control in Transmit Packets - 2'b00: No VLAN tag deletion, insertion, or replacement - 2'b01: VLAN tag deletion The MAC removes the VLAN type (bytes 13 and 14) and VLAN tag (bytes 15 and 16) of all transmitted packets with VLAN tags. - 2'b10: VLAN tag insertion The MAC inserts VLT in bytes 15 and 16 of the packet after inserting the Type value (0x8100 or 0x88a8) in bytes 13 and 14. This operation is performed on all transmitted packets, irrespective of whether they already have a VLAN tag. - 2'b11: VLAN tag replacement The MAC replaces VLT in bytes 15 and 16 of all VLAN-type transmitted packets (Bytes 13 and 14 are 0x8100 or 0x88a8). Note: Changes to this field take effect only on the start of a packet. If you write this register field when a packet is being transmitted, only the subsequent packet can use the updated value, that is, the current packet does not use the updated value. */
    vuint32_t VLP:1;                   /* VLAN Priority Control When this bit is set, the control bits[17:16] are used for VLAN deletion, insertion, or replacement. When this bit is reset, the mti_vlan_ctrl_i control input is used and bits[17:16] are ignored. */
    vuint32_t CSVL:1;                  /* C-VLAN or S-VLAN When this bit is set, S-VLAN type (0x88A8) is inserted or replaced in the 13th and 14th bytes of transmitted packets. When this bit is reset, C-VLAN type (0x8100) is inserted or replaced in the 13th and 14th bytes of transmitted packets. */
    vuint32_t VLTI:1;                  /* VLAN Tag Input When this bit is set, it indicates that the VLAN tag to be inserted or replaced in Tx packet should be taken from: - The Tx descriptor */
    vuint32_t CBTI:1;                  /* Channel based tag insertion When this bit is set, outer VLAN tag is inserted for every packets transmitted by the MAC. The tag value is taken from the queue/channel specific VLAN tag register. The VLTI, VLP, VLC, and VLT fields of this register are ignored when this bit is set. When this bit is set, a write operation to byte 3 of this register initiates the read/write access to the indirect register. When reset, outer VLAN operation is based on the setting of VLTI, VLP, VLC and VLT fields of this register. */
    vuint32_t _unused_22:2;            /* Reserved. */
    vuint32_t ADDR:3;                  /* Address This field selects one of the queue/channel specific VLAN Inclusion register for read/write access. This does not have any effect when CBTI is reset. */
    vuint32_t _unused_27:3;            /* Reserved. */
    vuint32_t RDWR:1;                  /* Read write control This bit controls the read or write operation for indirectly accessing the queue/channel specific VLAN Inclusion register. When set indicates write operation and when reset indicates read operation. This does not have any effect when CBTI is reset. */
    vuint32_t BUSY:1;                  /* Busy This bit indicates the status of the read/write operation of indirect access to the queue/channel specific VLAN inclusion register. For write operation write to a register is complete when this bit is reset. For read operation the read data is valid when the bit is reset. The application must make sure that this bit is reset before attempting subsequent access to this register. */
  } B;
} GMAC_MAC_VLAN_INCL_tag;

typedef union GMAC_MAC_INNER_VLAN_INCL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t VLT:16;                  /* VLAN Tag for Transmit Packets This field contains the value of the VLAN tag to be inserted or replaced. The value must only be changed when the transmit lines are inactive or during the initialization phase. Bits[15:13] are the User Priority field, Bit 12 is the CFI/DEI field, and Bits[11:0] are the VID field in the VLAN tag. The following list describes the bits of this field: - Bits[15:13]: User Priority - Bit 12: Canonical Format Indicator (CFI) or Drop Eligible Indicator (DEI) - Bits[11:0]: VLAN Identifier (VID) field of VLAN tag */
    vuint32_t VLC:2;                   /* VLAN Tag Control in Transmit Packets - 2'b00: No VLAN tag deletion, insertion, or replacement - 2'b01: VLAN tag deletion The MAC removes the VLAN type (bytes 17 and 18) and VLAN tag (bytes 19 and 20) of all transmitted packets with VLAN tags. - 2'b10: VLAN tag insertion The MAC inserts VLT in bytes 19 and 20 of the packet after inserting the Type value (0x8100 or 0x88a8) in bytes 17 and 18. This operation is performed on all transmitted packets, irrespective of whether they already have a VLAN tag. - 2'b11: VLAN tag replacement The MAC replaces VLT in bytes 19 and 20 of all VLAN-type transmitted packets (Bytes 17 and 18 are 0x8100 or 0x88a8). Note: Changes to this field take effect only on the start of a packet. If you write this register field when a packet is being transmitted, only the subsequent packet can use the updated value, that is, the current packet does not use the updated value. */
    vuint32_t VLP:1;                   /* VLAN Priority Control When this bit is set, the VLC field is used for VLAN deletion, insertion, or replacement. When this bit is reset, the mti_vlan_ctrl_i control input is used and the VLC field is ignored. */
    vuint32_t CSVL:1;                  /* C-VLAN or S-VLAN When this bit is set, S-VLAN type (0x88A8) is inserted or replaced in the 13th and 14th bytes of transmitted packets. When this bit is reset, C-VLAN type (0x8100) is inserted or replaced in the 13th and 14th bytes of transmitted packets. */
    vuint32_t VLTI:1;                  /* VLAN Tag Input When this bit is set, it indicates that the VLAN tag to be inserted or replaced in Tx packet should be taken from: - The Tx descriptor */
    vuint32_t _unused_21:11;           /* Reserved. */
  } B;
} GMAC_MAC_INNER_VLAN_INCL_tag;

typedef union GMAC_MAC_Q0_TX_FLOW_CTRL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FCB_BPA:1;               /* Flow Control Busy or Backpressure Activate This bit initiates a Pause packet in the full-duplex mode and activates the backpressure function in the half-duplex mode if the TFE bit is set. Full-Duplex Mode: In the full-duplex mode, this bit should be read as 1'b0 before writing to this register. To initiate a Pause packet, the application must set this bit to 1'b1. During Control packet transfer, this bit continues to be set to indicate that a packet transmission is in progress. When Pause packet transmission is complete, the MAC resets this bit to 1'b0. You should not write to this register until this bit is cleared. Half-Duplex Mode: When this bit is set (and TFE bit is set) in the half-duplex mode, the MAC asserts the backpressure. During backpressure, when the MAC receives a new packet, the transmitter starts sending a JAM pattern resulting in a collision. This control register bit is logically ORed with the mti_flowctrl_i input signal for the backpressure function. When the MAC is configured for the full-duplex mode, the BPA is automatically disabled. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TFE:1;                   /* Transmit Flow Control Enable Full-Duplex Mode: In the full-duplex mode, when this bit is set, the MAC enables the flow control operation to Tx Pause packets. When this bit is reset, the flow control operation in the MAC is disabled, and the MAC does not transmit any Pause packets. Half-Duplex Mode: In the half-duplex mode, when this bit is set, the MAC enables the backpressure operation. When this bit is reset, the backpressure feature is disabled. */
    vuint32_t _unused_2:2;             /* Reserved. */
    vuint32_t PLT:3;                   /* Pause Low Threshold This field configures the threshold of the Pause timer at which the input flow control signal mti_flowctrl_i (or sbd_flowctrl_i) is checked for automatic retransmission of the Pause packet. The threshold values should be always less than the Pause Time configured in Bits[31:16]. For example, if PT = 100H (256 slot times), and PLT = 001, a second Pause packet is automatically transmitted if the mti_flowctrl_i signal is asserted at 228 (256-28) slot times after the first Pause packet is transmitted. The following list provides the threshold values for different values. The slot time is defined as the time taken to transmit 512 bits (64 bytes) on the GMII or MII interface. This (approximate) computation is based on the packet size (64, 1518, 2000, 9018, 16384, or 32768) + 2 Pause Packet Size + IPG in Slot Times. */
    vuint32_t DZPQ:1;                  /* Disable Zero-Quanta Pause When this bit is set, it disables the automatic generation of the zero-quanta Pause packets on de-assertion of the flow-control signal from the FIFO layer (MTL or external sideband flow control signal sbd_flowctrl_i or mti_flowctrl_i). When this bit is reset, normal operation with automatic zero-quanta Pause packet generation is enabled. */
    vuint32_t _unused_8:8;             /* Reserved. */
    vuint32_t PT:16;                   /* Pause Time This field holds the value to be used in the Pause Time field in the Tx control packet. If the Pause Time bits are configured to be double-synchronized to the (G)MII clock domain, consecutive writes to this register should be performed only after at least four clock cycles in the destination clock domain. */
  } B;
} GMAC_MAC_Q0_TX_FLOW_CTRL_tag;

typedef union GMAC_MAC_Q1_TX_FLOW_CTRL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FCB_BPA:1;               /* Flow Control Busy This bit initiates a PFC packet if the TFE bit is set. To initiate a PFC packet, the application must set this bit to 1'b1. During Control packet transfer, this bit continues to be set to indicate that a packet transmission is in progress. When PFC packet transmission is complete, the MAC resets this bit to 1'b0. You should not write to this register until this bit is cleared. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TFE:1;                   /* Transmit Flow Control Enable When this bit is set in full-duplex mode, the MAC enables the flow control operation to Tx Pause packets. When this bit is reset, the flow control operation in the MAC is disabled, and the MAC does not transmit any Pause packets. */
    vuint32_t _unused_2:2;             /* Reserved. */
    vuint32_t PLT:3;                   /* Pause Low Threshold This field configures the threshold of the Pause timer at which the input flow control signal mti_flowctrl_i (or sbd_flowctrl_i) is checked for automatic retransmission of the Pause packet. The threshold values should be always less than the Pause Time configured in Bits[31:16]. For example, if PT = 100H (256 slot times), and PLT = 001, a second Pause packet is automatically transmitted if the mti_flowctrl_i signal is asserted at 228 (256-28) slot times after the first Pause packet is transmitted. The following list provides the threshold values for different values. The slot time is defined as the time taken to transmit 512 bits (64 bytes) on the GMII or MII interface. This (approximate) computation is based on the packet size (64, 1518, 2000, 9018, 16384, or 32768) + 2 Pause Packet Size + IPG in Slot Times. */
    vuint32_t DZPQ:1;                  /* Disable Zero-Quanta Pause When this bit is set, it disables the automatic generation of the zero-quanta Pause packets on de-assertion of the flow-control signal from the FIFO layer (MTL or external sideband flow control signal sbd_flowctrl_i or mti_flowctrl_i). When this bit is reset, normal operation with automatic zero-quanta Pause packet generation is enabled. */
    vuint32_t _unused_8:8;             /* Reserved. */
    vuint32_t PT:16;                   /* Pause Time This field holds the value to be used in the Pause Time field in the Tx control packet. If the Pause Time bits are configured to be double-synchronized to the (G)MII clock domain, consecutive writes to this register should be performed only after at least four clock cycles in the destination clock domain. */
  } B;
} GMAC_MAC_Q1_TX_FLOW_CTRL_tag;

typedef union GMAC_MAC_Q2_TX_FLOW_CTRL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FCB_BPA:1;               /* Flow Control Busy This bit initiates a PFC packet if the TFE bit is set. To initiate a PFC packet, the application must set this bit to 1'b1. During Control packet transfer, this bit continues to be set to indicate that a packet transmission is in progress. When PFC packet transmission is complete, the MAC resets this bit to 1'b0. You should not write to this register until this bit is cleared. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TFE:1;                   /* Transmit Flow Control Enable When this bit is set in full-duplex mode, the MAC enables the flow control operation to Tx Pause packets. When this bit is reset, the flow control operation in the MAC is disabled, and the MAC does not transmit any Pause packets. */
    vuint32_t _unused_2:2;             /* Reserved. */
    vuint32_t PLT:3;                   /* Pause Low Threshold This field configures the threshold of the Pause timer at which the input flow control signal mti_flowctrl_i (or sbd_flowctrl_i) is checked for automatic retransmission of the Pause packet. The threshold values should be always less than the Pause Time configured in Bits[31:16]. For example, if PT = 100H (256 slot times), and PLT = 001, a second Pause packet is automatically transmitted if the mti_flowctrl_i signal is asserted at 228 (256-28) slot times after the first Pause packet is transmitted. The following list provides the threshold values for different values. The slot time is defined as the time taken to transmit 512 bits (64 bytes) on the GMII or MII interface. This (approximate) computation is based on the packet size (64, 1518, 2000, 9018, 16384, or 32768) + 2 Pause Packet Size + IPG in Slot Times. */
    vuint32_t DZPQ:1;                  /* Disable Zero-Quanta Pause When this bit is set, it disables the automatic generation of the zero-quanta Pause packets on de-assertion of the flow-control signal from the FIFO layer (MTL or external sideband flow control signal sbd_flowctrl_i or mti_flowctrl_i). When this bit is reset, normal operation with automatic zero-quanta Pause packet generation is enabled. */
    vuint32_t _unused_8:8;             /* Reserved. */
    vuint32_t PT:16;                   /* Pause Time This field holds the value to be used in the Pause Time field in the Tx control packet. If the Pause Time bits are configured to be double-synchronized to the (G)MII clock domain, consecutive writes to this register should be performed only after at least four clock cycles in the destination clock domain. */
  } B;
} GMAC_MAC_Q2_TX_FLOW_CTRL_tag;

typedef union GMAC_MAC_Q3_TX_FLOW_CTRL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FCB_BPA:1;               /* Flow Control Busy This bit initiates a PFC packet if the TFE bit is set. To initiate a PFC packet, the application must set this bit to 1'b1. During Control packet transfer, this bit continues to be set to indicate that a packet transmission is in progress. When PFC packet transmission is complete, the MAC resets this bit to 1'b0. You should not write to this register until this bit is cleared. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TFE:1;                   /* Transmit Flow Control Enable When this bit is set in full-duplex mode, the MAC enables the flow control operation to Tx Pause packets. When this bit is reset, the flow control operation in the MAC is disabled, and the MAC does not transmit any Pause packets. */
    vuint32_t _unused_2:2;             /* Reserved. */
    vuint32_t PLT:3;                   /* Pause Low Threshold This field configures the threshold of the Pause timer at which the input flow control signal mti_flowctrl_i (or sbd_flowctrl_i) is checked for automatic retransmission of the Pause packet. The threshold values should be always less than the Pause Time configured in Bits[31:16]. For example, if PT = 100H (256 slot times), and PLT = 001, a second Pause packet is automatically transmitted if the mti_flowctrl_i signal is asserted at 228 (256-28) slot times after the first Pause packet is transmitted. The following list provides the threshold values for different values. The slot time is defined as the time taken to transmit 512 bits (64 bytes) on the GMII or MII interface. This (approximate) computation is based on the packet size (64, 1518, 2000, 9018, 16384, or 32768) + 2 Pause Packet Size + IPG in Slot Times. */
    vuint32_t DZPQ:1;                  /* Disable Zero-Quanta Pause When this bit is set, it disables the automatic generation of the zero-quanta Pause packets on de-assertion of the flow-control signal from the FIFO layer (MTL or external sideband flow control signal sbd_flowctrl_i or mti_flowctrl_i). When this bit is reset, normal operation with automatic zero-quanta Pause packet generation is enabled. */
    vuint32_t _unused_8:8;             /* Reserved. */
    vuint32_t PT:16;                   /* Pause Time This field holds the value to be used in the Pause Time field in the Tx control packet. If the Pause Time bits are configured to be double-synchronized to the (G)MII clock domain, consecutive writes to this register should be performed only after at least four clock cycles in the destination clock domain. */
  } B;
} GMAC_MAC_Q3_TX_FLOW_CTRL_tag;

typedef union GMAC_MAC_Q4_TX_FLOW_CTRL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FCB_BPA:1;               /* Flow Control Busy This bit initiates a PFC packet if the TFE bit is set. To initiate a PFC packet, the application must set this bit to 1'b1. During Control packet transfer, this bit continues to be set to indicate that a packet transmission is in progress. When PFC packet transmission is complete, the MAC resets this bit to 1'b0. You should not write to this register until this bit is cleared. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TFE:1;                   /* Transmit Flow Control Enable When this bit is set in full-duplex mode, the MAC enables the flow control operation to Tx Pause packets. When this bit is reset, the flow control operation in the MAC is disabled, and the MAC does not transmit any Pause packets. */
    vuint32_t _unused_2:2;             /* Reserved. */
    vuint32_t PLT:3;                   /* Pause Low Threshold This field configures the threshold of the Pause timer at which the input flow control signal mti_flowctrl_i (or sbd_flowctrl_i) is checked for automatic retransmission of the Pause packet. The threshold values should be always less than the Pause Time configured in Bits[31:16]. For example, if PT = 100H (256 slot times), and PLT = 001, a second Pause packet is automatically transmitted if the mti_flowctrl_i signal is asserted at 228 (256-28) slot times after the first Pause packet is transmitted. The following list provides the threshold values for different values. The slot time is defined as the time taken to transmit 512 bits (64 bytes) on the GMII or MII interface. This (approximate) computation is based on the packet size (64, 1518, 2000, 9018, 16384, or 32768) + 2 Pause Packet Size + IPG in Slot Times. */
    vuint32_t DZPQ:1;                  /* Disable Zero-Quanta Pause When this bit is set, it disables the automatic generation of the zero-quanta Pause packets on de-assertion of the flow-control signal from the FIFO layer (MTL or external sideband flow control signal sbd_flowctrl_i or mti_flowctrl_i). When this bit is reset, normal operation with automatic zero-quanta Pause packet generation is enabled. */
    vuint32_t _unused_8:8;             /* Reserved. */
    vuint32_t PT:16;                   /* Pause Time This field holds the value to be used in the Pause Time field in the Tx control packet. If the Pause Time bits are configured to be double-synchronized to the (G)MII clock domain, consecutive writes to this register should be performed only after at least four clock cycles in the destination clock domain. */
  } B;
} GMAC_MAC_Q4_TX_FLOW_CTRL_tag;

typedef union GMAC_MAC_RX_FLOW_CTRL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RFE:1;                   /* Receive Flow Control Enable When this bit is set and the MAC is operating in full-duplex mode, the MAC decodes the received Pause packet and disables its transmitter for a specified (Pause) time. When this bit is reset or the MAC is operating in half-duplex mode, the decode function of the Pause packet is disabled. When PFC is enabled, flow control is enabled for PFC packets. The MAC decodes the received PFC packet and disables the Transmit queue, with matching priorities, for a duration of received Pause time. */
    vuint32_t UP:1;                    /* Unicast Pause Packet Detect A pause packet is processed when it has the unique multicast address specified in the IEEE 802.3. When this bit is set, the MAC can also detect Pause packets with unicast address of the station. This unicast address should be as specified in MAC_Address0_High and MAC_Address0_Low. When this bit is reset, the MAC only detects Pause packets with unique multicast address. Note: The MAC does not process a Pause packet if the multicast address is different from the unique multicast address. This is also applicable to the received PFC packet when the Priority Flow Control (PFC) is enabled. The unique multicast address (0x01_80_C2_00_00_01) is as specified in IEEE 802.1 Qbb-2011. */
    vuint32_t _unused_2:6;             /* Reserved. */
    vuint32_t PFCE:1;                  /* Priority Based Flow Control Enable When this bit is set, it enables generation and reception of priority-based flow control (PFC) packets. When this bit is reset, it enables generation and reception of 802.3x Pause control packets. */
    vuint32_t _unused_9:23;            /* Reserved. */
  } B;
} GMAC_MAC_RX_FLOW_CTRL_tag;

typedef union GMAC_MAC_RXQ_CTRL4_union_tag {
  vuint32_t R;
  struct {
    vuint32_t UFFQE:1;                 /* Unicast Address Filter Fail Packets Queuing Enable. When this bit is set, the Unicast packets which fail the Destination or Source address filter is routed to the Rx Queue Number programmed in the UFFQ. When this bit is reset, the Unicast packets which fail the Destination or Source address filter is routed based on other routing options. This bit is valid only when the RA bit of the MAC_Packet_Filter register is set. */
    vuint32_t UFFQ:3;                  /* Unicast Address Filter Fail Packets Queue. This field holds the Rx queue number to which the Unicast packets failing the Destination or Source Address filter are routed to. This field is valid only when the UFFQE bit is set. */
    vuint32_t _unused_4:4;             /* Reserved. */
    vuint32_t MFFQE:1;                 /* Multicast Address Filter Fail Packets Queuing Enable. When this bit is set, the Multicast packets which fail the Destination or Source address filter is routed to the Rx Queue Number programmed in the MFFQ. When this bit is reset, the Multicast packets which fail the Destination or Source address filter is routed based on other routing options. This bit is valid only when the RA bit of the MAC_Packet_Filter register is set. */
    vuint32_t MFFQ:3;                  /* Multicast Address Filter Fail Packets Queue. This field holds the Rx queue number to which the Multicast packets failing the Destination or Source Address filter are routed to. This field is valid only when the MFFQE bit is set. */
    vuint32_t _unused_12:4;            /* Reserved. */
    vuint32_t VFFQE:1;                 /* VLAN Tag Filter Fail Packets Queuing Enable When this bit is set, the tagged packets which fail the Destination or Source address filter or fail the VLAN tag filter, are routed to the Rx Queue Number programmed in the VFFQ. When this bit is reset, the tagged packets which fail the Destination or Source address filter or fail the VLAN tag filter are routed based on other routing options. This bit is valid only when the RA bit of the MAC_Packet_Filter register is set. */
    vuint32_t VFFQ:3;                  /* VLAN Tag Filter Fail Packets Queue This field holds the Rx queue number to which the tagged packets failing the Destination or Source Address filter (and UFFQE/MFFQE not enabled) or failing the VLAN tag filter must be routed to. This field is valid only when the VFFQE bit is set. */
    vuint32_t _unused_20:12;           /* Reserved. */
  } B;
} GMAC_MAC_RXQ_CTRL4_tag;

typedef union GMAC_MAC_TXQ_PRTY_MAP0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PSTQ0:8;                 /* Priorities Selected in Transmit Queue 0 This field holds the priorities assigned to Tx Queue 0 by the software. This field determines if Tx Queue 0 should be blocked from transmitting specified pause time when a PFC packet is received with priorities matching the priorities programmed in this field. If the content of this field is not mutually exclusive to corresponding fields of other Transmit queues, that is, same priority is mapped to multiple Tx queues, the MAC blocks all queues with matching priority for specified time. */
    vuint32_t PSTQ1:8;                 /* Priorities Selected in Transmit Queue 1 This bit is similar to the PSTQ0 bit. */
    vuint32_t PSTQ2:8;                 /* Priorities Selected in Transmit Queue 2 This bit is similar to the PSTQ0 bit. */
    vuint32_t PSTQ3:8;                 /* Priorities Selected in Transmit Queue 3 This bit is similar to the PSTQ0 bit. */
  } B;
} GMAC_MAC_TXQ_PRTY_MAP0_tag;

typedef union GMAC_MAC_TXQ_PRTY_MAP1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PSTQ4:8;                 /* Priorities Selected in Transmit Queue 4 This field holds the priorities assigned to Tx Queue 4 by the software. This field determines if Tx Queue 4 should be blocked from transmitting specified pause time when a PFC packet is received with priorities matching the priorities programmed in this field. If the content of this field is not mutually exclusive to corresponding fields of other Transmit queues, that is, same priority is mapped to multiple Tx queues, the MAC blocks all queues with matching priority for specified time. */
    vuint32_t _unused_8:8;             /* Reserved. */
    vuint32_t _unused_16:8;            /* Reserved. */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} GMAC_MAC_TXQ_PRTY_MAP1_tag;

typedef union GMAC_MAC_RXQ_CTRL0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXQ0EN:2;                /* Receive Queue 0 Enable This field indicates whether Rx Queue 0 is enabled for AV or DCB. */
    vuint32_t RXQ1EN:2;                /* Receive Queue 1 Enable This field is similar to the RXQ0EN field. */
    vuint32_t RXQ2EN:2;                /* Receive Queue 2 Enable This field is similar to the RXQ0EN field. */
    vuint32_t RXQ3EN:2;                /* Receive Queue 3 Enable This field is similar to the RXQ0EN field. */
    vuint32_t RXQ4EN:2;                /* Receive Queue 4 Enable This field is similar to the RXQ0EN field. */
    vuint32_t _unused_10:2;            /* Reserved. */
    vuint32_t _unused_12:2;            /* Reserved. */
    vuint32_t _unused_14:2;            /* Reserved. */
    vuint32_t _unused_16:16;           /* Reserved. */
  } B;
} GMAC_MAC_RXQ_CTRL0_tag;

typedef union GMAC_MAC_RXQ_CTRL1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t AVCPQ:3;                 /* AV Untagged Control Packets Queue This field specifies the Receive queue on which the received AV tagged and untagged control packets are routed. The AV tagged (when TACPQE bit is set) and untagged control packets are routed to Receive queue specified by this field. */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t PTPQ:3;                  /* PTP Packets Queue This field specifies the Rx queue on which the PTP packets sent over the Ethernet payload (not over IPv4 or IPv6) are routed. When the AV8021ASMEN bit of MAC_Timestamp_Control register is set, only untagged PTP over Ethernet packets are routed on an Rx Queue. If the bit is not set, then based on programming of TPQC field, both tagged and untagged PTPoE packets can be routed to this Rx Queue. */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t DCBCPQ:3;                /* DCB Control Packets Queue This field specifies the Rx queue on which the received DCB control packets are routed. The DCB data packets are routed based on the PSRQ field of the Transmit Flow Control Register of corresponding queue. */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t UPQ:3;                   /* Untagged Packet Queue This field indicates the Rx Queue to which Untagged Packets are to be routed. Any Rx Queue enabled for Generic/DCB/AV traffic can be used to route the Untagged Packets. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t MCBCQ:3;                 /* Multicast and Broadcast Queue This field specifies the Rx Queue onto which Multicast or Broadcast Packets are routed. Any Rx Queue enabled for Generic/DCB/AV traffic can be used to route the Multicast or Broadcast Packets. */
    vuint32_t _unused_19:1;            /* Reserved. */
    vuint32_t MCBCQEN:1;               /* Multicast and Broadcast Queue Enable This bit specifies that Multicast or Broadcast packets routing to the Rx Queue is enabled and the Multicast or Broadcast packets must be routed to Rx Queue specified in MCBCQ field. */
    vuint32_t TACPQE:1;                /* Tagged AV Control Packets Queuing Enable. When set, the MAC routes the received Tagged AV Control packets to the Rx queue specified by AVCPQ field. When reset, the MAC routes the received Tagged AV Control packets based on the tag priority matching the PSRQ fields in MAC_RxQ_Ctrl2 and MAC_RxQ_Ctrl3 registers. */
    vuint32_t TPQC:2;                  /* Tagged PTP over Ethernet Packets Queuing Control. This field controls the routing of the VLAN Tagged PTPoE packets. If DWC_EQOS_AV_ENABLE is selected in the configuration, the following programmable options are allowed. - 2'b00: VLAN Tagged PTPoE packets are routed as generic VLAN Tagged packet (based on PSRQ for only non-AV enabled Rx Queues). - 2'b01: VLAN Tagged PTPoE packets are routed to Rx Queue specified by PTPQ field (That Rx Queue can be enabled for AV or non-AV traffic). - 2'b10: VLAN Tagged PTPoE packets are routed to only AV enabled Rx Queues based on PSRQ. - 2'b11: Reserved If DWC_EQOS_AV_ENABLE is not selected in the configuration, the following programmable options are allowed. - 1'b0: VLAN Tagged PTPoE packets are routed as generic VLAN Tagged packet (based on PSRQ for DCB/Generic enabled Rx Queues). - 1'b1: VLAN Tagged PTPoE packets are routed to Rx Queues specified by PTPQ field. */
    vuint32_t FPRQ:3;                  /* Frame Preemption Residue Queue This field holds the Rx queue number to which the residual preemption frames must be forwarded. Preemption frames that are tagged and pass the SA/DA/VLAN filtering are routed based on PSRQ and all other frames are treated as residual frames and is routed to the queue number mentioned in this field. The Queue-0 is used as a default queue for express frames, so this field cannot be programmed to a value 0. */
    vuint32_t _unused_27:5;            /* Reserved. */
  } B;
} GMAC_MAC_RXQ_CTRL1_tag;

typedef union GMAC_MAC_RXQ_CTRL2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PSRQ0:8;                 /* Priorities Selected in the Receive Queue 0 This field decides the priorities assigned to Rx Queue 0. All packets with priorities that match the values set in this field are routed to Rx Queue 0. For example, if PSRQ0[5] is set, packets with USP field equal to 5 are routed to Rx Queue 0. The software must ensure that the content of this field is mutually exclusive to the PSRQ fields for other queues, that is, the same priority is not mapped to multiple Rx queues. this field also determines the priorities to be included in the PFC packet sent to remote station when Rx Queue 0 crosses the flow control threshold settings. */
    vuint32_t PSRQ1:8;                 /* Priorities Selected in the Receive Queue 1 This field decides the priorities assigned to Rx Queue 1. All packets with priorities that match the values set in this field are routed to Rx Queue 1. For example, if PSRQ1[4] is set, packets with USP field equal to 4 are routed to Rx Queue 1. The software must ensure that the content of this field is mutually exclusive to the PSRQ fields for other queues, that is, the same priority is not mapped to multiple Rx queues. this field also determines the priorities to be included in the PFC packet sent to remote station when Rx Queue 1 crosses the flow control threshold settings. */
    vuint32_t PSRQ2:8;                 /* Priorities Selected in the Receive Queue 2 This field decides the priorities assigned to Rx Queue 2. All packets with priorities that match the values set in this field are routed to Rx Queue 2. For example, if PSRQ2[1, 0] are set, packets with USP field equal to 1 or 0 are routed to Rx Queue 2. The software must ensure that the content of this field is mutually exclusive to the PSRQ fields for other queues, that is, the same priority is not mapped to multiple Rx queues. this field also determines the priorities to be included in the PFC packet sent to remote station when Rx Queue 2 crosses the flow control threshold settings. */
    vuint32_t PSRQ3:8;                 /* Priorities Selected in the Receive Queue 3 This field decides the priorities assigned to Rx Queue 3. All packets with priorities that match the values set in this field are routed to Rx Queue 3. For example, if PSRQ3[6, 3] are set, packets with USP field equal to 3 or 6 are routed to Rx Queue 3. The software must ensure that the content of this field is mutually exclusive to the PSRQ fields for other queues, that is, the same priority is not mapped to multiple Rx queues. this field also determines the priorities to be included in the PFC packet sent to remote station when Rx Queue 3 crosses the flow control threshold settings. */
  } B;
} GMAC_MAC_RXQ_CTRL2_tag;

typedef union GMAC_MAC_RXQ_CTRL3_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PSRQ4:8;                 /* Priorities Selected in the Receive Queue 4 This field decides the priorities assigned to Rx Queue 4. All packets with priorities that match the values set in this field are routed to Rx Queue 4. For example, if PSRQ4[7:4] is set, packets with USP field equal to 7, 6, 5, or 4 are routed to Rx Queue 4. The software must ensure that the content of this field is mutually exclusive to the PSRQ fields for other queues, that is, the same priority is not mapped to multiple Rx queues. this field also determines the priorities to be included in the PFC packet sent to remote station when Rx Queue 4 crosses the flow control threshold settings. */
    vuint32_t _unused_8:8;             /* Reserved. */
    vuint32_t _unused_16:8;            /* Reserved. */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} GMAC_MAC_RXQ_CTRL3_tag;

typedef union GMAC_MAC_INTERRUPT_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RGSMIIIS:1;              /* RGMII or SMII Interrupt Status This bit is set because of any change in value of the Link Status of RGMII or SMII interface (LNKSTS bit in MAC_PHYIF_Control_Status register). This bit is cleared when the MAC_PHYIF_Control_Status register is read (or LNKSTS bit of MAC_PHYIF_Control_Status register is written to 1 when RCWE bit of MAC_CSR_SW_Ctrl register is set). This bit is valid only when you select the optional RGMII or SMII PHY interface. */
    vuint32_t _unused_1:1;             /* Reserved. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t PHYIS:1;                 /* PHY Interrupt This bit is set when rising edge is detected on the phy_intr_i input. This bit is cleared when this register is read (or this bit is written to 1 when RCWE bit of MAC_CSR_SW_Ctrl register is set). */
    vuint32_t PMTIS:1;                 /* PMT Interrupt Status This bit is set when a Magic packet or Wake-on-LAN packet is received in the power-down mode (RWKPRCVD and MGKPRCVD bits in MAC_PMT_Control_Status register). This bit is cleared when corresponding interrupt source bit are cleared because of a Read operation to the MAC_PMT_Control_Status register (or corresponding interrupt source bit of MAC_PMT_Control_Status register is written to 1 when RCWE bit of MAC_CSR_SW_Ctrl register is set). This bit is valid only when you select the Enable Power Management option. */
    vuint32_t _unused_5:1;             /* Reserved. */
    vuint32_t _unused_6:2;             /* Reserved. */
    vuint32_t MMCIS:1;                 /* MMC Interrupt Status This bit is set high when Bit 11, Bit 10, or Bit 9 is set high. This bit is cleared only when all these bits are low. This bit is valid only when you select the Enable MAC Management Counters (MMC) option. */
    vuint32_t MMCRXIS:1;               /* MMC Receive Interrupt Status This bit is set high when an interrupt is generated in the MMC Receive Interrupt Register. This bit is cleared when all bits in this interrupt register are cleared. This bit is valid only when you select the Enable MAC Management Counters (MMC) option. */
    vuint32_t MMCTXIS:1;               /* MMC Transmit Interrupt Status This bit is set high when an interrupt is generated in the MMC Transmit Interrupt Register. This bit is cleared when all bits in this interrupt register are cleared. This bit is valid only when you select the Enable MAC Management Counters (MMC) option. */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t TSIS:1;                  /* Timestamp Interrupt Status If the Timestamp feature is enabled, this bit is set when any of the following conditions is true: - The system time value is equal to or exceeds the value specified in the Target Time High and Low registers. - There is an overflow in the Seconds register. - The Target Time Error occurred, that is, programmed target time already elapsed. If the Auxiliary Snapshot feature is enabled, this bit is set when the auxiliary snapshot trigger is asserted. In configurations other than EQOS_CORE, when drop transmit status is enabled in MTL, this bit is set when the captured transmit timestamp is updated in the MAC_Tx_Timestamp_Status_Nanoseconds and Mac_TxTimestamp_Status_Seconds registers. When PTP offload feature is enabled, this bit is set when the captured transmit timestamp is updated in the MAC_Tx_Timestamp_Status_Nanoseconds and MAC_Tx_Timestamp_Status_Seconds registers, for PTO generated Delay Request and Pdelay request packets. This bit is cleared when the corresponding interrupt source bit is read (or corresponding interrupt source bit is written to 1 when RCWE bit of MAC_CSR_SW_Ctrl register is set) in the MAC_Timestamp_Status register. */
    vuint32_t TXSTSIS:1;               /* Transmit Status Interrupt This bit indicates the status of transmitted packets. This bit is set when any of the following bits is set in the MAC_Rx_Tx_Status register: - Excessive Collision (EXCOL) - Late Collision (LCOL) - Excessive Deferral (EXDEF) - Loss of Carrier (LCARR) - No Carrier (NCARR) - Jabber Timeout (TJT) This bit is cleared when the corresponding interrupt source bit is read (or corresponding interrupt source bit is written to 1 when RCWE bit of MAC_CSR_SW_Ctrl register is set) in the MAC_Rx_Tx_Status register. */
    vuint32_t RXSTSIS:1;               /* Receive Status Interrupt This bit indicates the status of received packets. This bit is set when the RWT bit is set in the MAC_Rx_Tx_Status register. This bit is cleared when the corresponding interrupt source bit is read (or corresponding interrupt source bit is written to 1 when RCWE bit of MAC_CSR_SW_Ctrl register is set) in the MAC_Rx_Tx_Status register. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t _unused_16:1;            /* Reserved. */
    vuint32_t FPEIS:1;                 /* Frame Preemption Interrupt Status This bit indicates an interrupt event during the operation of Frame Preemption (Bits[19:16] of MAC_FPE_CTRL_STS register is set). To reset this bit, the application must clear the event in MAC_FPE_CTRL_STS that has caused the Interrupt. */
    vuint32_t MDIOIS:1;                /* MDIO Interrupt Status This bit indicates an interrupt event after the completion of MDIO operation. To reset this bit, the application has to read this bit/Write 1 to this bit when RCWE bit of MAC_CSR_SW_Ctrl register is set. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t MFTIS:1;                 /* MMC FPE Transmit Interrupt Status This bit is set high when an interrupt is generated in the MMC FPE Transmit Interrupt Register. This bit is cleared when all bits in this interrupt register are cleared. This bit is valid only when you select the Enable MAC Management Counters (MMC) option along with FPE support. */
    vuint32_t MFRIS:1;                 /* MMC FPE Receive Interrupt Status This bit is set high when an interrupt is generated in the MMC FPE Receive Interrupt Register. This bit is cleared when all bits in this interrupt register are cleared. This bit is valid only when you select the Enable MAC Management Counters (MMC) option along with FPE support. */
    vuint32_t _unused_21:11;           /* Reserved. */
  } B;
} GMAC_MAC_INTERRUPT_STATUS_tag;

typedef union GMAC_MAC_INTERRUPT_ENABLE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RGSMIIIE:1;              /* RGMII or SMII Interrupt Enable When this bit is set, it enables the assertion of the interrupt signal because of the setting of RGSMIIIS bit in MAC_Interrupt_Status register. */
    vuint32_t _unused_1:1;             /* Reserved. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t PHYIE:1;                 /* PHY Interrupt Enable When this bit is set, it enables the assertion of the interrupt signal because of the setting of PHYIS bit in MAC_Interrupt_Status register. */
    vuint32_t PMTIE:1;                 /* PMT Interrupt Enable When this bit is set, it enables the assertion of the interrupt signal because of the setting of PMTIS bit in MAC_Interrupt_Status register. */
    vuint32_t _unused_5:1;             /* Reserved. */
    vuint32_t _unused_6:6;             /* Reserved. */
    vuint32_t TSIE:1;                  /* Timestamp Interrupt Enable When this bit is set, it enables the assertion of the interrupt signal because of the setting of TSIS bit in MAC_Interrupt_Status register. */
    vuint32_t TXSTSIE:1;               /* Transmit Status Interrupt Enable When this bit is set, it enables the assertion of the interrupt signal because of the setting of TXSTSIS bit in the MAC_Interrupt_Status register. */
    vuint32_t RXSTSIE:1;               /* Receive Status Interrupt Enable When this bit is set, it enables the assertion of the interrupt signal because of the setting of RXSTSIS bit in the MAC_Interrupt_Status register. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t _unused_16:1;            /* Reserved. */
    vuint32_t FPEIE:1;                 /* Frame Preemption Interrupt Enable When this bit is set, it enables the assertion of the interrupt when FPEIS field is set in the MAC_Interrupt_Status register. */
    vuint32_t MDIOIE:1;                /* MDIO Interrupt Enable When this bit is set, it enables the assertion of the interrupt when MDIOIS field is set in the MAC_Interrupt_Status register. */
    vuint32_t _unused_19:13;           /* Reserved. */
  } B;
} GMAC_MAC_INTERRUPT_ENABLE_tag;

typedef union GMAC_MAC_RX_TX_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TJT:1;                   /* Transmit Jabber Timeout This bit indicates that the Transmit Jabber Timer expired which happens when the packet size exceeds 2,048 bytes and JD bit is reset in the MAC_Configuration register. This bit is set when the packet size exceeds 16,383 bytes and the JD bit is set in the MAC_Configuration register. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t NCARR:1;                 /* No Carrier When the DTXSTS bit is set in the MTL_Operation_Mode register, this bit indicates that the carrier signal from the PHY is not present at the end of preamble transmission. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t LCARR:1;                 /* Loss of Carrier When the DTXSTS bit is set in the MTL_Operation_Mode register, this bit indicates that the loss of carrier occurred during packet transmission, that is, the phy_crs_i signal was inactive for one or more transmission clock periods during packet transmission. This bit is valid only for packets transmitted without collision. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t EXDEF:1;                 /* Excessive Deferral When the DTXSTS bit is set in the MTL_Operation_Mode register and the DC bit is set in the MAC_Configuration register, this bit indicates that the transmission ended because of excessive deferral of over 24,288 bit times. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t LCOL:1;                  /* Late Collision When the DTXSTS bit is set in the MTL_Operation_Mode register, this bit indicates that the packet transmission aborted because a collision occurred after the collision window (64 bytes including Preamble in MII mode; 512 bytes including Preamble and Carrier Extension in GMII mode). This bit is not valid if the Underflow error occurs. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t EXCOL:1;                 /* Excessive Collisions When the DTXSTS bit is set in the MTL_Operation_Mode register, this bit indicates that the transmission aborted after 16 successive collisions while attempting to transmit the current packet. If the DR bit is set in the MAC_Configuration register, this bit is set after the first collision and the packet transmission is aborted. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t _unused_6:2;             /* Reserved. */
    vuint32_t RWT:1;                   /* Receive Watchdog Timeout This bit is set when a packet with length greater than 2,048 bytes is received and the WD bit is reset in the MAC_Configuration register. This bit is set when a packet with length greater than 16,383 bytes is received and the WD bit is set in the MAC_Configuration register. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t _unused_9:23;            /* Reserved. */
  } B;
} GMAC_MAC_RX_TX_STATUS_tag;

typedef union GMAC_MAC_PMT_CONTROL_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PWRDWN:1;                /* Power Down When this bit is set, the MAC receiver drops all received packets until it receives the expected magic packet or remote wake-up packet. This bit is then self-cleared and the power-down mode is disabled. The software can clear this bit before the expected magic packet or remote wake-up packet is received. The packets received by the MAC after this bit is cleared are forwarded to the application. This bit must only be set when the Magic Packet Enable, Global Unicast, or Remote Wake-Up Packet Enable bit is set high. Note: You can gate-off the CSR clock during the power-down mode. However, when the CSR clock is gated-off, you cannot perform any read or write operations on this register. Therefore, the Software cannot clear this bit. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t MGKPKTEN:1;              /* Magic Packet Enable When this bit is set, a power management event is generated when the MAC receives a magic packet. */
    vuint32_t RWKPKTEN:1;              /* Remote Wake-Up Packet Enable When this bit is set, a power management event is generated when the MAC receives a remote wake-up packet. */
    vuint32_t _unused_3:2;             /* Reserved. */
    vuint32_t MGKPRCVD:1;              /* Magic Packet Received When this bit is set, it indicates that the power management event is generated because of the reception of a magic packet. This bit is cleared when this register is read. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t RWKPRCVD:1;              /* Remote Wake-Up Packet Received When this bit is set, it indicates that the power management event is generated because of the reception of a remote wake-up packet. This bit is cleared when this register is read. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t _unused_7:2;             /* Reserved. */
    vuint32_t GLBLUCAST:1;             /* Global Unicast When this bit set, any unicast packet filtered by the MAC (DAF) address recognition is detected as a remote wake-up packet. */
    vuint32_t RWKPFE:1;                /* Remote Wake-up Packet Forwarding Enable When this bit is set along with RWKPKTEN, the MAC receiver drops all received frames until it receives the expected Wake-up frame. All frames after that event including the received wake-up frame are forwarded to application. This bit is then self-cleared on receiving the wake-up packet. The application can also clear this bit before the expected wake-up frame is received. In such cases, the MAC reverts to the default behavior where packets received are forwarded to the application. This bit must only be set when RWKPKTEN is set high and PWRDWN is set low. The setting of this bit has no effect when PWRDWN is set high. Note: If Magic Packet Enable and Wake-Up Frame Enable are both set along with setting of this bit and Magic Packet is received prior to wake-up frame, this bit is self-cleared on receiving Magic Packet, the received Magic packet is dropped, and all frames after received Magic Packet are forwarded to application. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t _unused_11:13;           /* Reserved. */
    vuint32_t RWKPTR:5;                /* Remote Wake-up FIFO Pointer This field gives the current value (0 to 7, 15, or 31 when 4, 8, or 16 Remote Wake-up Packet Filters are selected) of the Remote Wake-up Packet Filter register pointer. When the value of this pointer is equal to maximum for the selected number of Remote Wake-up Packet Filters, the contents of the Remote Wake-up Packet Filter Register are transferred to the clk_rx_i domain when a Write occurs to that register. */
    vuint32_t _unused_29:2;            /* Reserved. */
    vuint32_t RWKFILTRST:1;            /* Remote Wake-Up Packet Filter Register Pointer Reset When this bit is set, the remote wake-up packet filter register pointer is reset to 3'b000. It is automatically cleared after 1 clock cycle. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
  } B;
} GMAC_MAC_PMT_CONTROL_STATUS_tag;

typedef union GMAC_MAC_RWK_PACKET_FILTER_union_tag {
  vuint32_t R;
  struct {
    vuint32_t WKUPFRMFTR:32;           /* RWK Packet Filter This field contains the various controls of RWK Packet filter. */
  } B;
} GMAC_MAC_RWK_PACKET_FILTER_tag;

typedef union GMAC_MAC_PHYIF_CONTROL_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TC:1;                    /* Transmit Configuration in RGMII, SGMII, or SMII When set, this bit enables the transmission of duplex mode, link speed, and link up or down information to the PHY in the RGMII, SMII, or SGMII port. When this bit is reset, no such information is driven to the PHY. The details of this feature are provided in the following sections: - "Reduced Gigabit Media Independent Interface" - "Serial Media Independent Interface" - "Serial Gigabit Media Independent Interface" */
    vuint32_t LUD:1;                   /* Link Up or Down This bit indicates whether the link is up or down during transmission of configuration in the RGMII, SGMII, or SMII interface. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t _unused_4:1;             /* Reserved. */
    vuint32_t _unused_5:11;            /* Reserved. */
    vuint32_t LNKMOD:1;                /* Link Mode This bit indicates the current mode of operation of the link. */
    vuint32_t LNKSPEED:2;              /* Link Speed This bit indicates the current speed of the link. */
    vuint32_t LNKSTS:1;                /* Link Status This bit indicates whether the link is up (1'b1) or down (1'b0). */
    vuint32_t _unused_20:1;            /* Reserved. */
    vuint32_t _unused_21:1;            /* Reserved. */
    vuint32_t _unused_22:10;           /* Reserved. */
  } B;
} GMAC_MAC_PHYIF_CONTROL_STATUS_tag;

typedef union GMAC_MAC_VERSION_union_tag {
  vuint32_t R;
  struct {
    vuint32_t IPVER:8;                 /* IP version */
    vuint32_t CFGVER:8;                /* IP configuration version */
    vuint32_t _unused_16:16;           /* Reserved. */
  } B;
} GMAC_MAC_VERSION_tag;

typedef union GMAC_MAC_DEBUG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RPESTS:1;                /* MAC GMII or MII Receive Protocol Engine Status When this bit is set, it indicates that the MAC GMII or MII receive protocol engine is actively receiving data, and it is not in the Idle state. */
    vuint32_t RFCFCSTS:2;              /* MAC Receive Packet Controller FIFO Status When this bit is set, this field indicates the active state of the small FIFO Read and Write controllers of the MAC Receive Packet Controller module. */
    vuint32_t _unused_3:13;            /* Reserved. */
    vuint32_t TPESTS:1;                /* MAC GMII or MII Transmit Protocol Engine Status When this bit is set, it indicates that the MAC GMII or MII transmit protocol engine is actively transmitting data, and it is not in the Idle state. */
    vuint32_t TFCSTS:2;                /* MAC Transmit Packet Controller Status This field indicates the state of the MAC Transmit Packet Controller module. */
    vuint32_t _unused_19:13;           /* Reserved. */
  } B;
} GMAC_MAC_DEBUG_tag;

typedef union GMAC_MAC_HW_FEATURE0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t MIISEL:1;                /* 10 or 100 Mbps Support This bit is set to 1 when 10/100 Mbps is selected as the Mode of Operation */
    vuint32_t GMIISEL:1;               /* 1000 Mbps Support This bit is set to 1 when 1000 Mbps is selected as the Mode of Operation */
    vuint32_t HDSEL:1;                 /* Half-duplex Support This bit is set to 1 when the half-duplex mode is selected */
    vuint32_t PCSSEL:1;                /* PCS Registers (TBI, SGMII, or RTBI PHY interface) This bit is set to 1 when the TBI, SGMII, or RTBI PHY interface option is selected */
    vuint32_t VLHASH:1;                /* VLAN Hash Filter Selected This bit is set to 1 when the Enable VLAN Hash Table Based Filtering option is selected */
    vuint32_t SMASEL:1;                /* SMA (MDIO) Interface This bit is set to 1 when the Enable Station Management (MDIO Interface) option is selected */
    vuint32_t RWKSEL:1;                /* PMT Remote Wake-up Packet Enable This bit is set to 1 when the Enable Remote Wake-Up Packet Detection option is selected */
    vuint32_t MGKSEL:1;                /* PMT Magic Packet Enable This bit is set to 1 when the Enable Magic Packet Detection option is selected */
    vuint32_t MMCSEL:1;                /* RMON Module Enable This bit is set to 1 when the Enable MAC Management Counters (MMC) option is selected */
    vuint32_t ARPOFFSEL:1;             /* ARP Offload Enabled This bit is set to 1 when the Enable IPv4 ARP Offload option is selected */
    vuint32_t _unused_10:2;            /* Reserved. */
    vuint32_t TSSEL:1;                 /* IEEE 1588-2008 Timestamp Enabled This bit is set to 1 when the Enable IEEE 1588 Timestamp Support option is selected */
    vuint32_t _unused_13:1;            /* Reserved. */
    vuint32_t TXCOESEL:1;              /* Transmit Checksum Offload Enabled This bit is set to 1 when the Enable Transmit TCP/IP Checksum Insertion option is selected */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t RXCOESEL:1;              /* Receive Checksum Offload Enabled This bit is set to 1 when the Enable Receive TCP/IP Checksum Check option is selected */
    vuint32_t _unused_17:1;            /* Reserved. */
    vuint32_t ADDMACADRSEL:5;          /* MAC Addresses 1-31 Selected This bit is set to 1 when the non-zero value is selected for Enable Additional 1-31 MAC Address Registers option */
    vuint32_t MACADR32SEL:1;           /* MAC Addresses 32-63 Selected This bit is set to 1 when the Enable Additional 32 MAC Address Registers (32-63) option is selected */
    vuint32_t MACADR64SEL:1;           /* MAC Addresses 64-127 Selected This bit is set to 1 when the Enable Additional 64 MAC Address Registers (64-127) option is selected */
    vuint32_t TSSTSSEL:2;              /* Timestamp System Time Source This bit indicates the source of the Timestamp system time: This bit is set to 1 when the Enable IEEE 1588 Timestamp Support option is selected */
    vuint32_t SAVLANINS:1;             /* Source Address or VLAN Insertion Enable This bit is set to 1 when the Enable SA and VLAN Insertion on Tx option is selected */
    vuint32_t ACTPHYSEL:3;             /* Active PHY Selected When you have multiple PHY interfaces in your configuration, this field indicates the sampled value of phy_intf_sel_i during reset de-assertion. */
    vuint32_t _unused_31:1;            /* Reserved. */
  } B;
} GMAC_MAC_HW_FEATURE0_tag;

typedef union GMAC_MAC_HW_FEATURE1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXFIFOSIZE:5;            /* MTL Receive FIFO Size This field contains the configured value of MTL Rx FIFO in bytes expressed as Log to base 2 minus 7, that is, Log2(RXFIFO_SIZE) -7: */
    vuint32_t SPRAM:1;                 /* Single Port RAM Enable This bit is set to 1 when the Use single port RAM Feature is selected. */
    vuint32_t TXFIFOSIZE:5;            /* MTL Transmit FIFO Size This field contains the configured value of MTL Tx FIFO in bytes expressed as Log to base 2 minus 7, that is, Log2(TXFIFO_SIZE) -7: */
    vuint32_t OSTEN:1;                 /* One-Step Timestamping Enable This bit is set to 1 when the Enable One-Step Timestamp Feature is selected. */
    vuint32_t PTOEN:1;                 /* PTP Offload Enable This bit is set to 1 when the Enable PTP Timestamp Offload Feature is selected. */
    vuint32_t ADVTHWORD:1;             /* IEEE 1588 High Word Register Enable This bit is set to 1 when the Add IEEE 1588 Higher Word Register option is selected */
    vuint32_t ADDR64:2;                /* Address Width. This field indicates the configured address width: */
    vuint32_t DCBEN:1;                 /* DCB Feature Enable This bit is set to 1 when the Enable Data Center Bridging option is selected */
    vuint32_t SPHEN:1;                 /* Split Header Feature Enable This bit is set to 1 when the Enable Split Header Structure option is selected */
    vuint32_t _unused_18:1;            /* Reserved. */
    vuint32_t DBGMEMA:1;               /* DMA Debug Registers Enable This bit is set to 1 when the Debug Mode Enable option is selected */
    vuint32_t AVSEL:1;                 /* AV Feature Enable This bit is set to 1 when the Enable Audio Video Bridging option is selected. */
    vuint32_t RAVSEL:1;                /* Rx Side Only AV Feature Enable This bit is set to 1 when the Enable Audio Video Bridging option on Rx Side Only is selected. */
    vuint32_t _unused_22:1;            /* Reserved. */
    vuint32_t POUOST:1;                /* One Step for PTP over UDP/IP Feature Enable This bit is set to 1 when the Enable One step timestamp for PTP over UDP/IP feature is selected. */
    vuint32_t HASHTBLSZ:2;             /* Hash Table Size This field indicates the size of the hash table: */
    vuint32_t _unused_26:1;            /* Reserved. */
    vuint32_t L3L4FNUM:4;              /* Total number of L3 or L4 Filters This field indicates the total number of L3 or L4 filters: */
    vuint32_t _unused_31:1;            /* Reserved. */
  } B;
} GMAC_MAC_HW_FEATURE1_tag;

typedef union GMAC_MAC_HW_FEATURE2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXQCNT:4;                /* Number of MTL Receive Queues This field indicates the number of MTL Receive queues: */
    vuint32_t _unused_4:2;             /* Reserved. */
    vuint32_t TXQCNT:4;                /* Number of MTL Transmit Queues This field indicates the number of MTL Transmit queues: */
    vuint32_t _unused_10:2;            /* Reserved. */
    vuint32_t RXCHCNT:4;               /* Number of DMA Receive Channels This field indicates the number of DMA Receive channels: */
    vuint32_t _unused_16:2;            /* Reserved. */
    vuint32_t TXCHCNT:4;               /* Number of DMA Transmit Channels This field indicates the number of DMA Transmit channels: */
    vuint32_t _unused_22:2;            /* Reserved. */
    vuint32_t PPSOUTNUM:3;             /* Number of PPS Outputs This field indicates the number of PPS outputs: */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t AUXSNAPNUM:3;            /* Number of Auxiliary Snapshot Inputs This field indicates the number of auxiliary snapshot inputs: */
    vuint32_t _unused_31:1;            /* Reserved. */
  } B;
} GMAC_MAC_HW_FEATURE2_tag;

typedef union GMAC_MAC_HW_FEATURE3_union_tag {
  vuint32_t R;
  struct {
    vuint32_t NRVF:3;                  /* Number of Extended VLAN Tag Filters Enabled This field indicates the Number of Extended VLAN Tag Filters selected: */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t CBTISEL:1;               /* Queue/Channel based VLAN tag insertion on Tx Enable This bit is set to 1 when the Enable Queue/Channel based VLAN tag insertion on Tx Feature is selected. */
    vuint32_t DVLAN:1;                 /* Double VLAN Tag Processing Selected This bit is set to 1 when the Enable Double VLAN Processing Feature is selected. */
    vuint32_t _unused_6:3;             /* Reserved. */
    vuint32_t PDUPSEL:1;               /* Broadcast/Multicast Packet Duplication This bit is set to 1 when the Broadcast/Multicast Packet Duplication feature is selected. */
    vuint32_t FRPSEL:1;                /* Flexible Receive Parser Selected This bit is set to 1 when the Enable Flexible Programmable Receive Parser option is selected. */
    vuint32_t FRPBS:2;                 /* Flexible Receive Parser Buffer size This field indicates the supported Max Number of bytes of the packet data to be Parsed by Flexible Receive Parser. */
    vuint32_t FRPES:2;                 /* Flexible Receive Parser Table Entries size This field indicates the Max Number of Parser Entries supported by Flexible Receive Parser. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t ESTSEL:1;                /* Enhancements to Scheduling Traffic Enable This bit is set to 1 when the Enable Enhancements to Scheduling Traffic feature is selected. */
    vuint32_t ESTDEP:3;                /* Depth of the Gate Control List */
    vuint32_t ESTWID:2;                /* Width of the Time Interval field in the Gate Control List This field indicates the width of the Configured Time Interval Field */
    vuint32_t _unused_22:4;            /* Reserved. */
    vuint32_t FPESEL:1;                /* Frame Preemption Enable This bit is set to 1 when the Enable Frame preemption feature is selected. */
    vuint32_t TBSSEL:1;                /* Time Based Scheduling Enable This bit is set to 1 when the Time Based Scheduling feature is selected. */
    vuint32_t ASP:2;                   /* Automotive Safety Package Following are the encoding for the different Safety features */
    vuint32_t _unused_30:2;            /* Reserved. */
  } B;
} GMAC_MAC_HW_FEATURE3_tag;

typedef union GMAC_MAC_DPP_FSM_INTERRUPT_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;             /* Reserved. */
    vuint32_t _unused_1:1;             /* Reserved. */
    vuint32_t RDPES:1;                 /* Read Descriptor Parity checker Error Status This bit when set indicates that a parity error is detected at the DMA Read descriptor parity checker (or at PC3 as shown in Fig.Transmit data path parity protection). */
    vuint32_t MPES:1;                  /* MTL data path Parity checker Error Status This bit when set indicates that a parity error is detected at the MTL transmit write controller parity checker (or at PC4 as shown in Fig.Transmit data path parity protection). */
    vuint32_t MTSPES:1;                /* MTL TX Status data path Parity checker Error Status This filed when set indicates that, parity error is detected on the MTL TX Status data on ati interface (or at PC5 as shown in Fig.Transmit data path parity protection). */
    vuint32_t ARPES:1;                 /* Application Receive interface data path Parity Error Status This bit when set indicates that a parity error is detected at following checkers based on the system configuration as described below - In MTL configuration (DWC_EQOS_SYS=1), parity checker (PC6 as shown in Fig.Receive Data path Parity protection) at ARI interface. - In DMA configuration (DWC_EQOS_SYS=2), parity checker (PC6 as shown in Fig.Receive Data path Parity protection) at DMA application interface. - In AHB configuration (DWC_EQOS_SYS=3), parity checker (PC6 as shown in Fig.Receive Data path Parity protection) at AHB master interface. - In AXI configuration (DWC_EQOS_SYS=4), parity checker (PC6 as shown in Fig.Receive Data path Parity protection) at AXI master interface. */
    vuint32_t _unused_6:1;             /* Reserved. */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t TTES:1;                  /* Tx FSM Timeout Error Status This field when set indicates that one of the Tx FSM Timeout has occurred. */
    vuint32_t RTES:1;                  /* Rx FSM Timeout Error Status This field when set indicates that one of the Rx FSM Timeout has occurred. */
    vuint32_t _unused_10:1;            /* Reserved. */
    vuint32_t ATES:1;                  /* APP FSM Timeout Error Status This field when set indicates that one of the APP FSM Timeout has occurred. */
    vuint32_t PTES:1;                  /* PTP FSM Timeout Error Status This field when set indicates that one of the PTP FSM Timeout has occurred. */
    vuint32_t _unused_13:1;            /* Reserved. */
    vuint32_t _unused_14:1;            /* Reserved. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t MSTTES:1;                /* Master Read/Write Timeout Error Status This field when set indicates that an Application/CSR Timeout has occurred on the master (AXI/AHB/ARI/ATI) interface. */
    vuint32_t _unused_17:1;            /* Reserved. */
    vuint32_t _unused_18:6;            /* Reserved. */
    vuint32_t FSMPES:1;                /* FSM State Parity Error Status This field when set indicates one of the FSMs State registers has a parity error detected. */
    vuint32_t _unused_25:7;            /* Reserved. */
  } B;
} GMAC_MAC_DPP_FSM_INTERRUPT_STATUS_tag;

typedef union GMAC_MAC_FSM_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TMOUTEN:1;               /* This bit when set indicates that the FSM timeout feature is enabled. */
    vuint32_t PRTYEN:1;                /* This bit when set indicates that the FSM parity feature is enabled. */
    vuint32_t _unused_2:6;
    vuint32_t TTEIN:1;                 /* Tx FSM Timeout Error Injection This field when set indicates that Error Injection for TX FSM timeout is enabled. */
    vuint32_t RTEIN:1;                 /* Rx FSM Timeout Error Injection This field when set indicates that Error Injection for RX FSM timeout is enabled. */
    vuint32_t _unused_10:1;            /* Reserved. */
    vuint32_t ATEIN:1;                 /* APP FSM Timeout Error Injection This field when set indicates that Error Injection for APP FSM timeout is enabled. */
    vuint32_t PTEIN:1;                 /* PTP FSM Timeout Error Injection This field when set indicates that Error Injection for PTP FSM timeout is enabled. */
    vuint32_t _unused_13:1;            /* Reserved. */
    vuint32_t _unused_14:1;            /* Reserved. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t TPEIN:1;                 /* Tx FSM Parity Error Injection This field when set indicates that Error Injection for TX FSM Parity is enabled. */
    vuint32_t RPEIN:1;                 /* Rx FSM Parity Error Injection This field when set indicates that Error Injection for RX FSM Parity is enabled. */
    vuint32_t _unused_18:1;            /* Reserved. */
    vuint32_t APEIN:1;                 /* APP FSM Parity Error Injection This field when set indicates that Error Injection for APP FSM Parity is enabled. */
    vuint32_t PPEIN:1;                 /* PTP FSM Parity Error Injection This field when set indicates that Error Injection for PTP FSM Parity is enabled. */
    vuint32_t _unused_21:1;            /* Reserved. */
    vuint32_t _unused_22:1;            /* Reserved. */
    vuint32_t _unused_23:1;            /* Reserved. */
    vuint32_t TLGRNML:1;               /* Tx Large/Normal Mode Select This field when set indicates that large mode tic generation is used for Tx domain, else normal mode tic generation is used. */
    vuint32_t RLGRNML:1;               /* Rx Large/Normal Mode Select This field when set indicates that large mode tic generation is used for Rx domain, else normal mode tic generation is used. */
    vuint32_t _unused_26:1;            /* Reserved. */
    vuint32_t ALGRNML:1;               /* APP Large/Normal Mode Select This field when set indicates that large mode tic generation is used for APP domain, else normal mode tic generation is used. */
    vuint32_t PLGRNML:1;               /* PTP Large/Normal Mode Select This field when set indicates that large mode tic generation is used for PTP domain, else normal mode tic generation is used. */
    vuint32_t _unused_29:1;            /* Reserved. */
    vuint32_t _unused_30:1;            /* Reserved. */
    vuint32_t _unused_31:1;            /* Reserved. */
  } B;
} GMAC_MAC_FSM_CONTROL_tag;

typedef union GMAC_MAC_FSM_ACT_TIMER_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TMR:10;                  /* This field indicates the number of CSR clocks required to generate 1us tic. */
    vuint32_t _unused_10:6;            /* Reserved. */
    vuint32_t NTMRMD:4;                /* This field provides the value to be used for normal mode FSM and other interface time outs. The timeout duration based on the mode value is given below */
    vuint32_t LTMRMD:4;                /* This field provides the mode value to be used for large mode FSM and other interface time outs. The timeout duration based on the mode value is given below */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} GMAC_MAC_FSM_ACT_TIMER_tag;

typedef union GMAC_SCS_REG1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t MAC_SCS1:32;             /* NXP Reserved, All the bits must be set to "0". This field is reserved for NXP Internal use, and must always be set to "0" unless instructed by NXP. Setting any bit to "1" might cause unexpected behavior in the IP. */
  } B;
} GMAC_SCS_REG1_tag;

typedef union GMAC_MAC_MDIO_ADDRESS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t GB:1;                    /* GMII Busy The application sets this bit to instruct the SMA to initiate a Read or Write access to the MDIO slave. The MAC clears this bit after the MDIO frame transfer is completed. Hence the software must not write or change any of the fields in MAC_MDIO_Address and MAC_MDIO_Data registers as long as this bit is set. For write transfers, the application must first write 16-bit data in the GDl field (and also RA field when C45E is set) in MAC_MDIO_Data register before setting this bit. When C45E is set, it should also write into the RA field of MAC_MDIO_Data register before initiating a read transfer. When a read transfer is completed (GB=0), the data read from the PHY register is valid in the GD field of the MAC_MDIO_Data register. Note: Even if the addressed PHY is not present, there is no change in the functionality of this bit. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t C45E:1;                  /* Clause 45 PHY Enable When this bit is set, Clause 45 capable PHY is connected to MDIO. When this bit is reset, Clause 22 capable PHY is connected to MDIO. */
    vuint32_t GOC_0:1;                 /* GMII Operation Command 0 This is the lower bit of the operation command to the PHY or RevMII. When in SMA mode (MDIO master) this bit along with GOC_1 determines the operation to be performed to the PHY. When only RevMII is selected in configuration this bit is read-only and tied to 1. */
    vuint32_t GOC_1:1;                 /* GMII Operation Command 1 This bit is higher bit of the operation command to the PHY or RevMII, GOC_1 and GOC_O is encoded as follows: - 00: Reserved - 01: Write - 10: Post Read Increment Address for Clause 45 PHY - 11: Read When Clause 22 PHY or RevMII is enabled, only Write and Read commands are valid. */
    vuint32_t SKAP:1;                  /* Skip Address Packet When this bit is set, the SMA does not send the address packets before read, write, or post-read increment address packets. This bit is valid only when C45E is set. */
    vuint32_t _unused_5:3;             /* Reserved. */
    vuint32_t CR:4;                    /* CSR Clock Range The CSR Clock Range selection determines the frequency of the MDC clock according to the CSR clock frequency used in your design: - 0000: CSR clock = 60-100 MHz; MDC clock = CSR clock/42 - 0001: CSR clock = 100-150 MHz; MDC clock = CSR clock/62 - 0010: CSR clock = 20-35 MHz; MDC clock = CSR clock/16 - 0011: CSR clock = 35-60 MHz; MDC clock = CSR clock/26 - 0100: CSR clock = 150-250 MHz; MDC clock = CSR clock/102 - 0101: CSR clock = 250-300 MHz; MDC clock = CSR clock/124 - 0110: CSR clock = 300-500 MHz; MDC clock = CSR clock/204 - 0111: CSR clock = 500-800 MHz; MDC clock = CSR clock/324 The suggested range of CSR clock frequency applicable for each value (when Bit 11 = 0) ensures that the MDC clock is approximately between 1.0 MHz to 2.5 MHz freqency range. When Bit 11 is set, you can achieve a higher frequency of the MDC clock than the frequency limit of 2.5 MHz (specified in the IEEE 802.3) and program a clock divider of lower value. For example, when CSR clock is of 100 MHz frequency and you program these bits as 1010, the resultant MDC clock is of 12.5 MHz which is above the range specified in IEEE 802.3. Program the following values only if the interfacing chips support faster MDC clocks: - 1000: CSR clock/4 - 1001: CSR clock/6 - 1010: CSR clock/8 - 1011: CSR clock/10 - 1100: CSR clock/12 - 1101: CSR clock/14 - 1110: CSR clock/16 - 1111: CSR clock/18 These bits are not used for accessing RevMII. These bits are read-only if the RevMII interface is selected as single PHY interface. */
    vuint32_t NTC:3;                   /* Number of Trailing Clocks This field controls the number of trailing clock cycles generated on gmii_mdc_o (MDC) after the end of transmission of MDIO frame. The valid values can be from 0 to 7. Programming the value to 3'h3 indicates that there are additional three clock cycles on the MDC line after the end of MDIO frame transfer. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t RDA:5;                   /* Register/Device Address These bits select the PHY register in selected Clause 22 PHY device. These bits select the Device (MMD) in selected Clause 45 capable PHY. */
    vuint32_t PA:5;                    /* Physical Layer Address This field indicates which Clause 22 PHY devices (out of 32 devices) the MAC is accessing. This field indicates which Clause 45 capable PHYs (out of 32 PHYs) the MAC is accessing. */
    vuint32_t BTB:1;                   /* Back to Back transactions When this bit is set and the NTC has value greater than 0, then the MAC informs the completion of a read or write command at the end of frame transfer (before the trailing clocks are transmitted). The software can thus initiate the next command which is executed immediately irrespective of the number trailing clocks generated for the previous frame. When this bit is reset, then the read/write command completion (GB is cleared) only after the trailing clocks are generated. In this mode, it is ensured that the NTC is always generated after each frame. This bit must not be set when NTC=0. */
    vuint32_t PSE:1;                   /* Preamble Suppression Enable When this bit is set, the SMA suppresses the 32-bit preamble and transmits MDIO frames with only 1 preamble bit. When this bit is 0, the MDIO frame always has 32 bits of preamble as defined in the IEEE specifications. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_MAC_MDIO_ADDRESS_tag;

typedef union GMAC_MAC_MDIO_DATA_union_tag {
  vuint32_t R;
  struct {
    vuint32_t GD:16;                   /* GMII Data This field contains the 16-bit data value read from the PHY or RevMII after a Management Read operation or the 16-bit data value to be written to the PHY or RevMII before a Management Write operation. */
    vuint32_t RA:16;                   /* Register Address This field is valid only when C45E is set. It contains the Register Address in the PHY to which the MDIO frame is intended for. */
  } B;
} GMAC_MAC_MDIO_DATA_tag;

typedef union GMAC_MAC_ARP_ADDRESS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ARPPA:32;                /* ARP Protocol Address This field contains the IPv4 Destination Address of the MAC. This address is used for perfect match with the Protocol Address of Target field in the received ARP packet. This field is available only when the Enable IPv4 ARP Offload option is selected. */
  } B;
} GMAC_MAC_ARP_ADDRESS_tag;

typedef union GMAC_MAC_CSR_SW_CTRL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RCWE:1;                  /* Register Clear on Write 1 Enable When this bit is set, the access mode of some register fields changes to Clear on Write 1, the application needs to set that respective bit to 1 to clear it. When this bit is reset, the access mode of these register fields remain as Clear on Read. */
    vuint32_t _unused_1:7;             /* Reserved. */
    vuint32_t SEEN:1;                  /* Slave Error Response Enable When this bit is set, the MAC responds with Slave Error for accesses to reserved registers in CSR space. When this bit is reset, the MAC responds with Okay response to any register accessed from CSR space. */
    vuint32_t _unused_9:23;            /* Reserved. */
  } B;
} GMAC_MAC_CSR_SW_CTRL_tag;

typedef union GMAC_MAC_FPE_CTRL_STS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t EFPE:1;                  /* Enable Tx Frame Preemption When set Frame Preemption Tx functionality is enabled. */
    vuint32_t SVER:1;                  /* Send Verify mPacket When set indicates hardware to send a verify mPacket. Reset by hardware after sending the Verify mPacket. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t SRSP:1;                  /* Send Respond mPacket When set indicates hardware to send a Respond mPacket. Reset by hardware after sending the Respond mPacket. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t S1_SET_0:1;              /* NXP Reserved, Must be set to "0". This field is reserved for NXP Internal use, and must always be set to "0" unless instructed by NXP. Setting to "1" might cause unexpected behavior in the IP. */
    vuint32_t _unused_4:12;            /* Reserved. */
    vuint32_t RVER:1;                  /* Received Verify Frame Set when a Verify mPacket is received. An interrupt can be generated for this event if FPEIE bit of MAC_Interrupt_Enable is set. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t RRSP:1;                  /* Received Respond Frame Set when a Respond mPacket is received. An interrupt can be generated for this event if FPEIE bit of MAC_Interrupt_Enable is set. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t TVER:1;                  /* Transmitted Verify Frame Set when a Verify mPacket is transmitted (triggered by setting SVER field). An interrupt can be generated for this event if FPEIE bit of MAC_Interrupt_Enable is set. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t TRSP:1;                  /* Transmitted Respond Frame Set when a Respond mPacket is transmitted (triggered by setting SRSP field). An interrupt can be generated for this event if FPEIE bit of MAC_Interrupt_Enable is set. Access restriction applies. Clears on read (or write of 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t _unused_20:12;           /* Reserved. */
  } B;
} GMAC_MAC_FPE_CTRL_STS_tag;

typedef union GMAC_MAC_EXT_CFG1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t SPLOFST:7;               /* Split Offset These bits indicate the value of offset from the beginning of Length/Type field at which header split should take place when the appropriate SPLM is selected. The reset value of this field is 2 bytes indicating a split at L2 header. Value is in terms of bytes. */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t SPLM:2;                  /* Split Mode These bits indicate the mode of splitting the incoming Rx packets. They are */
    vuint32_t _unused_10:22;           /* Reserved. */
  } B;
} GMAC_MAC_EXT_CFG1_tag;

typedef union GMAC_MAC_PRESN_TIME_NS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t MPTN:32;                 /* MAC 1722 Presentation Time in ns These bits indicate the value of the 32-bit binary rollover equivalent time of the PTP System Time in ns */
  } B;
} GMAC_MAC_PRESN_TIME_NS_tag;

typedef union GMAC_MAC_PRESN_TIME_UPDT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t MPTU:32;                 /* MAC 1722 Presentation Time Update This field holds the init value or the update value for the presentation time. When used for update, this field holds the 32-bit value in ns, that should be added to the Current Presentation Time Counter value. Init happens when TSINIT is set, and update happens when the TSUPDT bit is set (TSINIT and TSINIT defined in MAC_Timestamp_ Control register). When ADDSUB field of MAC_System_Time_Nanoseconds_Update is set, this value is directly used for subtraction */
  } B;
} GMAC_MAC_PRESN_TIME_UPDT_tag;

typedef union GMAC_MAC_ADDRESS0_HIGH_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ADDRHI:16;               /* MAC Address0[47:32] This field contains the upper 16 bits [47:32] of the first 6-byte MAC address. The MAC uses this field for filtering the received packets and inserting the MAC address in the Transmit Flow Control (Pause) Packets. */
    vuint32_t DCS:5;                   /* DMA Channel Select If the PDC bit of MAC_Ext_Configuration register is not set: This field contains the binary representation of the DMA Channel number to which an Rx packet whose DA matches the MAC Address0 content is routed. If the PDC bit of MAC_Ext_Configuration register is set: This field contains the one-hot representation of one or more DMA Channel numbers to which an Rx packet whose DA matches the MAC Address0 content is routed. */
    vuint32_t _unused_21:10;           /* Reserved. */
    vuint32_t AE:1;                    /* Address Enable This bit is always set to 1. */
  } B;
} GMAC_MAC_ADDRESS0_HIGH_tag;

typedef union GMAC_MAC_ADDRESS0_LOW_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ADDRLO:32;               /* MAC Address0[31:0] This field contains the lower 32 bits of the first 6-byte MAC address. The MAC uses this field for filtering the received packets and inserting the MAC address in the Transmit Flow Control (Pause) Packets. */
  } B;
} GMAC_MAC_ADDRESS0_LOW_tag;

typedef union GMAC_MAC_ADDRESS1_HIGH_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ADDRHI:16;               /* MAC Address1 [47:32] This field contains the upper 16 bits[47:32] of the second 6-byte MAC address. */
    vuint32_t DCS:5;                   /* DMA Channel Select If the PDC bit of MAC_Ext_Configuration register is not set: This field contains the binary representation of the DMA Channel number to which an Rx packet whose DA matches the MAC Address(#i) content is routed. If the PDC bit of MAC_Ext_Configuration register is set: This field contains the one-hot representation of one or more DMA Channel numbers to which an Rx packet whose DA matches the MAC Address(#i) content is routed. */
    vuint32_t _unused_21:3;            /* Reserved. */
    vuint32_t MBC:6;                   /* Mask Byte Control These bits are mask control bits for comparing each of the MAC Address bytes. When set high, the MAC does not compare the corresponding byte of received DA or SA with the contents of MAC Address1 registers. Each bit controls the masking of the bytes as follows: - Bit 29: MAC_Address${i}_High[15:8] - Bit 28: MAC_Address${i}_High[7:0] - Bit 27: MAC_Address${i}_Low[31:24] - .. - Bit 24: MAC_Address${i}_Low[7:0] You can filter a group of addresses (known as group address filtering) by masking one or more bytes of the address. */
    vuint32_t SA:1;                    /* Source Address When this bit is set, the MAC Address1[47:0] is used to compare with the SA fields of the received packet. When this bit is reset, the MAC Address1[47:0] is used to compare with the DA fields of the received packet. */
    vuint32_t AE:1;                    /* Address Enable When this bit is set, the address filter module uses the second MAC address for perfect filtering. When this bit is reset, the address filter module ignores the address for filtering. */
  } B;
} GMAC_MAC_ADDRESS1_HIGH_tag;

typedef union GMAC_MAC_ADDRESS1_LOW_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ADDRLO:32;               /* MAC Address1 [31:0] This field contains the lower 32 bits of second 6-byte MAC address. The content of this field is undefined until loaded by the application after the initialization process. */
  } B;
} GMAC_MAC_ADDRESS1_LOW_tag;

typedef union GMAC_MMC_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t CNTRST:1;                /* Counters Reset When this bit is set, all counters are reset. This bit is cleared automatically after 1 clock cycle. Access restriction applies. Self-cleared. Setting 0 clears. Setting 1 sets. */
    vuint32_t CNTSTOPRO:1;             /* Counter Stop Rollover When this bit is set, the counter does not roll over to zero after reaching the maximum value. */
    vuint32_t RSTONRD:1;               /* Reset on Read When this bit is set, the MMC counters are reset to zero after Read (self-clearing after reset). The counters are cleared when the least significant byte lane (Bits[7:0]) is read. */
    vuint32_t CNTFREEZ:1;              /* MMC Counter Freeze When this bit is set, it freezes all MMC counters to their current value. Until this bit is reset to 0, no MMC counter is updated because of any transmitted or received packet. If any MMC counter is read with the Reset on Read bit set, then that counter is also cleared in this mode. */
    vuint32_t CNTPRST:1;               /* Counters Preset When this bit is set, all counters are initialized or preset to almost full or almost half according to the CNTPRSTLVL bit. This bit is cleared automatically after 1 clock cycle. This bit, along with the CNTPRSTLVL bit, is useful for debugging and testing the assertion of interrupts because of MMC counter becoming half-full or full. Access restriction applies. Self-cleared. Setting 0 clears. Setting 1 sets. */
    vuint32_t CNTPRSTLVL:1;            /* Full-Half Preset When this bit is low and the CNTPRST bit is set, all MMC counters get preset to almost-half value. All octet counters get preset to 0x7FFF_F800 (Half 2KBytes) and all packet-counters gets preset to 0x7FFF_FFF0 (Half 16). When this bit is high and the CNTPRST bit is set, all MMC counters get preset to almost-full value. All octet counters get preset to 0xFFFF_F800 (Full 2KBytes) and all packet-counters gets preset to 0xFFFF_FFF0 (Full 16). For 16-bit counters, the almost-half preset values are 0x7800 and 0x7FF0 for the respective octet and packet counters. Similarly, the almost-full preset values for the 16-bit counters are 0xF800 and 0xFFF0. */
    vuint32_t _unused_6:2;             /* Reserved. */
    vuint32_t UCDBC:1;                 /* Update MMC Counters for Dropped Broadcast Packets Note: The CNTRST bit has a higher priority than the CNTPRST bit. Therefore, when the software tries to set both bits in the same write cycle, all counters are cleared and the CNTPRST bit is not set. When set, the MAC updates all related MMC Counters for Broadcast packets that are dropped because of the setting of the DBF bit of MAC_Packet_Filter register. When reset, the MMC Counters are not updated for dropped Broadcast packets. */
    vuint32_t _unused_9:23;            /* Reserved. */
  } B;
} GMAC_MMC_CONTROL_tag;

typedef union GMAC_MMC_RX_INTERRUPT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXGBPKTIS:1;             /* MMC Receive Good Bad Packet Counter Interrupt Status This bit is set when the rxpacketcount_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXGBOCTIS:1;             /* MMC Receive Good Bad Octet Counter Interrupt Status This bit is set when the rxoctetcount_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXGOCTIS:1;              /* MMC Receive Good Octet Counter Interrupt Status This bit is set when the rxoctetcount_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXBCGPIS:1;              /* MMC Receive Broadcast Good Packet Counter Interrupt Status This bit is set when the rxbroadcastpackets_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXMCGPIS:1;              /* MMC Receive Multicast Good Packet Counter Interrupt Status This bit is set when the rxmulticastpackets_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXCRCERPIS:1;            /* MMC Receive CRC Error Packet Counter Interrupt Status This bit is set when the rxcrcerror counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXALGNERPIS:1;           /* MMC Receive Alignment Error Packet Counter Interrupt Status This bit is set when the rxalignmenterror counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXRUNTPIS:1;             /* MMC Receive Runt Packet Counter Interrupt Status This bit is set when the rxrunterror counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXJABERPIS:1;            /* MMC Receive Jabber Error Packet Counter Interrupt Status This bit is set when the rxjabbererror counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXUSIZEGPIS:1;           /* MMC Receive Undersize Good Packet Counter Interrupt Status This bit is set when the rxundersize_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXOSIZEGPIS:1;           /* MMC Receive Oversize Good Packet Counter Interrupt Status This bit is set when the rxoversize_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RX64OCTGBPIS:1;          /* MMC Receive 64 Octet Good Bad Packet Counter Interrupt Status This bit is set when the rx64octets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RX65T127OCTGBPIS:1;      /* MMC Receive 65 to 127 Octet Good Bad Packet Counter Interrupt Status This bit is set when the rx65to127octets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RX128T255OCTGBPIS:1;     /* MMC Receive 128 to 255 Octet Good Bad Packet Counter Interrupt Status This bit is set when the rx128to255octets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RX256T511OCTGBPIS:1;     /* MMC Receive 256 to 511 Octet Good Bad Packet Counter Interrupt Status This bit is set when the rx256to511octets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RX512T1023OCTGBPIS:1;    /* MMC Receive 512 to 1023 Octet Good Bad Packet Counter Interrupt Status This bit is set when the rx512to1023octets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RX1024TMAXOCTGBPIS:1;    /* MMC Receive 1024 to Maximum Octet Good Bad Packet Counter Interrupt Status This bit is set when the rx1024tomaxoctets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXUCGPIS:1;              /* MMC Receive Unicast Good Packet Counter Interrupt Status This bit is set when the rxunicastpackets_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXLENERPIS:1;            /* MMC Receive Length Error Packet Counter Interrupt Status This bit is set when the rxlengtherror counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXORANGEPIS:1;           /* MMC Receive Out Of Range Error Packet Counter Interrupt Status. This bit is set when the rxoutofrangetype counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXPAUSPIS:1;             /* MMC Receive Pause Packet Counter Interrupt Status This bit is set when the rxpausepackets counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXFOVPIS:1;              /* MMC Receive FIFO Overflow Packet Counter Interrupt Status This bit is set when the rxfifooverflow counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXVLANGBPIS:1;           /* MMC Receive VLAN Good Bad Packet Counter Interrupt Status This bit is set when the rxvlanpackets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXWDOGPIS:1;             /* MMC Receive Watchdog Error Packet Counter Interrupt Status This bit is set when the rxwatchdog error counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXRCVERRPIS:1;           /* MMC Receive Error Packet Counter Interrupt Status This bit is set when the rxrcverror counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t RXCTRLPIS:1;             /* MMC Receive Control Packet Counter Interrupt Status This bit is set when the rxctrlpackets_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_26:1;            /* Reserved. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_MMC_RX_INTERRUPT_tag;

typedef union GMAC_MMC_TX_INTERRUPT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXGBOCTIS:1;             /* MMC Transmit Good Bad Octet Counter Interrupt Status This bit is set when the txoctetcount_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXGBPKTIS:1;             /* MMC Transmit Good Bad Packet Counter Interrupt Status This bit is set when the txpacketcount_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXBCGPIS:1;              /* MMC Transmit Broadcast Good Packet Counter Interrupt Status This bit is set when the txbroadcastpackets_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXMCGPIS:1;              /* MMC Transmit Multicast Good Packet Counter Interrupt Status This bit is set when the txmulticastpackets_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TX64OCTGBPIS:1;          /* MMC Transmit 64 Octet Good Bad Packet Counter Interrupt Status This bit is set when the tx64octets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TX65T127OCTGBPIS:1;      /* MMC Transmit 65 to 127 Octet Good Bad Packet Counter Interrupt Status This bit is set when the tx65to127octets_gb counter reaches half the maximum value, and also when it reaches the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TX128T255OCTGBPIS:1;     /* MMC Transmit 128 to 255 Octet Good Bad Packet Counter Interrupt Status This bit is set when the tx128to255octets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TX256T511OCTGBPIS:1;     /* MMC Transmit 256 to 511 Octet Good Bad Packet Counter Interrupt Status This bit is set when the tx256to511octets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TX512T1023OCTGBPIS:1;    /* MMC Transmit 512 to 1023 Octet Good Bad Packet Counter Interrupt Status This bit is set when the tx512to1023octets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TX1024TMAXOCTGBPIS:1;    /* MMC Transmit 1024 to Maximum Octet Good Bad Packet Counter Interrupt Status This bit is set when the tx1024tomaxoctets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXUCGBPIS:1;             /* MMC Transmit Unicast Good Bad Packet Counter Interrupt Status This bit is set when the txunicastpackets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXMCGBPIS:1;             /* MMC Transmit Multicast Good Bad Packet Counter Interrupt Status The bit is set when the txmulticastpackets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXBCGBPIS:1;             /* MMC Transmit Broadcast Good Bad Packet Counter Interrupt Status This bit is set when the txbroadcastpackets_gb counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXUFLOWERPIS:1;          /* MMC Transmit Underflow Error Packet Counter Interrupt Status This bit is set when the txunderflowerror counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXSCOLGPIS:1;            /* MMC Transmit Single Collision Good Packet Counter Interrupt Status This bit is set when the txsinglecol_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXMCOLGPIS:1;            /* MMC Transmit Multiple Collision Good Packet Counter Interrupt Status This bit is set when the txmulticol_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXDEFPIS:1;              /* MMC Transmit Deferred Packet Counter Interrupt Status This bit is set when the txdeferred counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXLATCOLPIS:1;           /* MMC Transmit Late Collision Packet Counter Interrupt Status This bit is set when the txlatecol counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXEXCOLPIS:1;            /* MMC Transmit Excessive Collision Packet Counter Interrupt Status This bit is set when the txexesscol counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXCARERPIS:1;            /* MMC Transmit Carrier Error Packet Counter Interrupt Status This bit is set when the txcarriererror counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXGOCTIS:1;              /* MMC Transmit Good Octet Counter Interrupt Status This bit is set when the txoctetcount_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXGPKTIS:1;              /* MMC Transmit Good Packet Counter Interrupt Status This bit is set when the txpacketcount_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXEXDEFPIS:1;            /* MMC Transmit Excessive Deferral Packet Counter Interrupt Status This bit is set when the txexcessdef counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXPAUSPIS:1;             /* MMC Transmit Pause Packet Counter Interrupt Status This bit is set when the txpausepacketserror counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXVLANGPIS:1;            /* MMC Transmit VLAN Good Packet Counter Interrupt Status This bit is set when the txvlanpackets_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t TXOSIZEGPIS:1;           /* MMC Transmit Oversize Good Packet Counter Interrupt Status This bit is set when the txoversize_g counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_26:1;            /* Reserved. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_MMC_TX_INTERRUPT_tag;

typedef union GMAC_MMC_RX_INTERRUPT_MASK_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXGBPKTIM:1;             /* MMC Receive Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxpacketcount_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXGBOCTIM:1;             /* MMC Receive Good Bad Octet Counter Interrupt Mask Setting this bit masks the interrupt when the rxoctetcount_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXGOCTIM:1;              /* MMC Receive Good Octet Counter Interrupt Mask Setting this bit masks the interrupt when the rxoctetcount_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXBCGPIM:1;              /* MMC Receive Broadcast Good Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxbroadcastpackets_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXMCGPIM:1;              /* MMC Receive Multicast Good Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxmulticastpackets_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXCRCERPIM:1;            /* MMC Receive CRC Error Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxcrcerror counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXALGNERPIM:1;           /* MMC Receive Alignment Error Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxalignmenterror counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXRUNTPIM:1;             /* MMC Receive Runt Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxrunterror counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXJABERPIM:1;            /* MMC Receive Jabber Error Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxjabbererror counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXUSIZEGPIM:1;           /* MMC Receive Undersize Good Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxundersize_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXOSIZEGPIM:1;           /* MMC Receive Oversize Good Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxoversize_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t RX64OCTGBPIM:1;          /* MMC Receive 64 Octet Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rx64octets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t RX65T127OCTGBPIM:1;      /* MMC Receive 65 to 127 Octet Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rx65to127octets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t RX128T255OCTGBPIM:1;     /* MMC Receive 128 to 255 Octet Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rx128to255octets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t RX256T511OCTGBPIM:1;     /* MMC Receive 256 to 511 Octet Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rx256to511octets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t RX512T1023OCTGBPIM:1;    /* MMC Receive 512 to 1023 Octet Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rx512to1023octets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t RX1024TMAXOCTGBPIM:1;    /* MMC Receive 1024 to Maximum Octet Good Bad Packet Counter Interrupt Mask. Setting this bit masks the interrupt when the rx1024tomaxoctets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXUCGPIM:1;              /* MMC Receive Unicast Good Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxunicastpackets_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXLENERPIM:1;            /* MMC Receive Length Error Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxlengtherror counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXORANGEPIM:1;           /* MMC Receive Out Of Range Error Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxoutofrangetype counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXPAUSPIM:1;             /* MMC Receive Pause Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxpausepackets counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXFOVPIM:1;              /* MMC Receive FIFO Overflow Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxfifooverflow counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXVLANGBPIM:1;           /* MMC Receive VLAN Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxvlanpackets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXWDOGPIM:1;             /* MMC Receive Watchdog Error Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxwatchdog counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXRCVERRPIM:1;           /* MMC Receive Error Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxrcverror counter reaches half of the maximum value or the maximum value. */
    vuint32_t RXCTRLPIM:1;             /* MMC Receive Control Packet Counter Interrupt Mask Setting this bit masks the interrupt when the rxctrlpackets_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t _unused_26:1;            /* Reserved. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_MMC_RX_INTERRUPT_MASK_tag;

typedef union GMAC_MMC_TX_INTERRUPT_MASK_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXGBOCTIM:1;             /* MMC Transmit Good Bad Octet Counter Interrupt Mask Setting this bit masks the interrupt when the txoctetcount_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXGBPKTIM:1;             /* MMC Transmit Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txpacketcount_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXBCGPIM:1;              /* MMC Transmit Broadcast Good Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txbroadcastpackets_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXMCGPIM:1;              /* MMC Transmit Multicast Good Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txmulticastpackets_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t TX64OCTGBPIM:1;          /* MMC Transmit 64 Octet Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the tx64octets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t TX65T127OCTGBPIM:1;      /* MMC Transmit 65 to 127 Octet Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the tx65to127octets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t TX128T255OCTGBPIM:1;     /* MMC Transmit 128 to 255 Octet Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the tx128to255octets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t TX256T511OCTGBPIM:1;     /* MMC Transmit 256 to 511 Octet Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the tx256to511octets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t TX512T1023OCTGBPIM:1;    /* MMC Transmit 512 to 1023 Octet Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the tx512to1023octets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t TX1024TMAXOCTGBPIM:1;    /* MMC Transmit 1024 to Maximum Octet Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the tx1024tomaxoctets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXUCGBPIM:1;             /* MMC Transmit Unicast Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txunicastpackets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXMCGBPIM:1;             /* MMC Transmit Multicast Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txmulticastpackets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXBCGBPIM:1;             /* MMC Transmit Broadcast Good Bad Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txbroadcastpackets_gb counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXUFLOWERPIM:1;          /* MMC Transmit Underflow Error Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txunderflowerror counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXSCOLGPIM:1;            /* MMC Transmit Single Collision Good Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txsinglecol_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXMCOLGPIM:1;            /* MMC Transmit Multiple Collision Good Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txmulticol_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXDEFPIM:1;              /* MMC Transmit Deferred Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txdeferred counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXLATCOLPIM:1;           /* MMC Transmit Late Collision Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txlatecol counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXEXCOLPIM:1;            /* MMC Transmit Excessive Collision Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txexcesscol counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXCARERPIM:1;            /* MMC Transmit Carrier Error Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txcarriererror counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXGOCTIM:1;              /* MMC Transmit Good Octet Counter Interrupt Mask Setting this bit masks the interrupt when the txoctetcount_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXGPKTIM:1;              /* MMC Transmit Good Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txpacketcount_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXEXDEFPIM:1;            /* MMC Transmit Excessive Deferral Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txexcessdef counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXPAUSPIM:1;             /* MMC Transmit Pause Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txpausepackets counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXVLANGPIM:1;            /* MMC Transmit VLAN Good Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txvlanpackets_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t TXOSIZEGPIM:1;           /* MMC Transmit Oversize Good Packet Counter Interrupt Mask Setting this bit masks the interrupt when the txoversize_g counter reaches half of the maximum value or the maximum value. */
    vuint32_t _unused_26:1;            /* Reserved. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_MMC_TX_INTERRUPT_MASK_tag;

typedef union GMAC_TX_OCTET_COUNT_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXOCTGB:32;              /* Tx Octet Count Good Bad This field indicates the number of bytes transmitted, exclusive of preamble and retried bytes, in good and bad packets. */
  } B;
} GMAC_TX_OCTET_COUNT_GOOD_BAD_tag;

typedef union GMAC_TX_PACKET_COUNT_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXPKTGB:32;              /* Tx Packet Count Good Bad This field indicates the number of good and bad packets transmitted, exclusive of retried packets. */
  } B;
} GMAC_TX_PACKET_COUNT_GOOD_BAD_tag;

typedef union GMAC_TX_BROADCAST_PACKETS_GOOD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXBCASTG:32;             /* Tx Broadcast Packets Good This field indicates the number of good broadcast packets transmitted. */
  } B;
} GMAC_TX_BROADCAST_PACKETS_GOOD_tag;

typedef union GMAC_TX_MULTICAST_PACKETS_GOOD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXMCASTG:32;             /* Tx Multicast Packets Good This field indicates the number of good multicast packets transmitted. */
  } B;
} GMAC_TX_MULTICAST_PACKETS_GOOD_tag;

typedef union GMAC_TX_64OCTETS_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TX64OCTGB:32;            /* Tx 64Octets Packets Good_Bad This field indicates the number of good and bad packets transmitted with length 64 bytes, exclusive of preamble and retried packets. */
  } B;
} GMAC_TX_64OCTETS_PACKETS_GOOD_BAD_tag;

typedef union GMAC_TX_65TO127OCTETS_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TX65_127OCTGB:32;        /* Tx 65To127Octets Packets Good Bad This field indicates the number of good and bad packets transmitted with length between 65 and 127 (inclusive) bytes, exclusive of preamble and retried packets. */
  } B;
} GMAC_TX_65TO127OCTETS_PACKETS_GOOD_BAD_tag;

typedef union GMAC_TX_128TO255OCTETS_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TX128_255OCTGB:32;       /* Tx 128To255Octets Packets Good Bad This field indicates the number of good and bad packets transmitted with length between 128 and 255 (inclusive) bytes, exclusive of preamble and retried packets. */
  } B;
} GMAC_TX_128TO255OCTETS_PACKETS_GOOD_BAD_tag;

typedef union GMAC_TX_256TO511OCTETS_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TX256_511OCTGB:32;       /* Tx 256To511Octets Packets Good Bad This field indicates the number of good and bad packets transmitted with length between 256 and 511 (inclusive) bytes, exclusive of preamble and retried packets. */
  } B;
} GMAC_TX_256TO511OCTETS_PACKETS_GOOD_BAD_tag;

typedef union GMAC_TX_512TO1023OCTETS_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TX512_1023OCTGB:32;      /* Tx 512To1023Octets Packets Good Bad This field indicates the number of good and bad packets transmitted with length between 512 and 1023 (inclusive) bytes, exclusive of preamble and retried packets. */
  } B;
} GMAC_TX_512TO1023OCTETS_PACKETS_GOOD_BAD_tag;

typedef union GMAC_TX_1024TOMAXOCTETS_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TX1024_MAXOCTGB:32;      /* Tx 1024ToMaxOctets Packets Good Bad This field indicates the number of good and bad packets transmitted with length between 1024 and maxsize (inclusive) bytes, exclusive of preamble and retried packets. */
  } B;
} GMAC_TX_1024TOMAXOCTETS_PACKETS_GOOD_BAD_tag;

typedef union GMAC_TX_UNICAST_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXUCASTGB:32;            /* Tx Unicast Packets Good Bad This field indicates the number of good and bad unicast packets transmitted. */
  } B;
} GMAC_TX_UNICAST_PACKETS_GOOD_BAD_tag;

typedef union GMAC_TX_MULTICAST_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXMCASTGB:32;            /* Tx Multicast Packets Good Bad This field indicates the number of good and bad multicast packets transmitted. */
  } B;
} GMAC_TX_MULTICAST_PACKETS_GOOD_BAD_tag;

typedef union GMAC_TX_BROADCAST_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXBCASTGB:32;            /* Tx Broadcast Packets Good Bad This field indicates the number of good and bad broadcast packets transmitted. */
  } B;
} GMAC_TX_BROADCAST_PACKETS_GOOD_BAD_tag;

typedef union GMAC_TX_UNDERFLOW_ERROR_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXUNDRFLW:32;            /* Tx Underflow Error Packets This field indicates the number of packets aborted because of packets underflow error. */
  } B;
} GMAC_TX_UNDERFLOW_ERROR_PACKETS_tag;

typedef union GMAC_TX_SINGLE_COLLISION_GOOD_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXSNGLCOLG:32;           /* Tx Single Collision Good Packets This field indicates the number of successfully transmitted packets after a single collision in the half-duplex mode. */
  } B;
} GMAC_TX_SINGLE_COLLISION_GOOD_PACKETS_tag;

typedef union GMAC_TX_MULTIPLE_COLLISION_GOOD_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXMULTCOLG:32;           /* Tx Multiple Collision Good Packets This field indicates the number of successfully transmitted packets after multiple collisions in the half-duplex mode. */
  } B;
} GMAC_TX_MULTIPLE_COLLISION_GOOD_PACKETS_tag;

typedef union GMAC_TX_DEFERRED_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXDEFRD:32;              /* Tx Deferred Packets This field indicates the number of successfully transmitted after a deferral in the half-duplex mode. */
  } B;
} GMAC_TX_DEFERRED_PACKETS_tag;

typedef union GMAC_TX_LATE_COLLISION_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXLATECOL:32;            /* Tx Late Collision Packets This field indicates the number of packets aborted because of late collision error. */
  } B;
} GMAC_TX_LATE_COLLISION_PACKETS_tag;

typedef union GMAC_TX_EXCESSIVE_COLLISION_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXEXSCOL:32;             /* Tx Excessive Collision Packets This field indicates the number of packets aborted because of excessive (16) collision errors. */
  } B;
} GMAC_TX_EXCESSIVE_COLLISION_PACKETS_tag;

typedef union GMAC_TX_CARRIER_ERROR_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXCARR:32;               /* Tx Carrier Error Packets This field indicates the number of packets aborted because of carrier sense error (no carrier or loss of carrier). */
  } B;
} GMAC_TX_CARRIER_ERROR_PACKETS_tag;

typedef union GMAC_TX_OCTET_COUNT_GOOD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXOCTG:32;               /* Tx Octet Count Good This field indicates the number of bytes transmitted, exclusive of preamble, only in good packets. */
  } B;
} GMAC_TX_OCTET_COUNT_GOOD_tag;

typedef union GMAC_TX_PACKET_COUNT_GOOD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXPKTG:32;               /* Tx Packet Count Good This field indicates the number of good packets transmitted. */
  } B;
} GMAC_TX_PACKET_COUNT_GOOD_tag;

typedef union GMAC_TX_EXCESSIVE_DEFERRAL_ERROR_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXEXSDEF:32;             /* Tx Excessive Deferral Error This field indicates the number of packets aborted because of excessive deferral error (deferred for more than two max-sized packet times). */
  } B;
} GMAC_TX_EXCESSIVE_DEFERRAL_ERROR_tag;

typedef union GMAC_TX_PAUSE_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXPAUSE:32;              /* Tx Pause Packets This field indicates the number of good Pause packets transmitted. */
  } B;
} GMAC_TX_PAUSE_PACKETS_tag;

typedef union GMAC_TX_VLAN_PACKETS_GOOD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXVLANG:32;              /* Tx VLAN Packets Good This field provides the number of good VLAN packets transmitted. */
  } B;
} GMAC_TX_VLAN_PACKETS_GOOD_tag;

typedef union GMAC_TX_OSIZE_PACKETS_GOOD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXOSIZG:32;              /* Tx OSize Packets Good This field indicates the number of packets transmitted without errors and with length greater than the maxsize (1,518 or 1,522 bytes for VLAN tagged packets; 2000 bytes if enabled in S2KP bit of the MAC_Configuration register). */
  } B;
} GMAC_TX_OSIZE_PACKETS_GOOD_tag;

typedef union GMAC_RX_PACKETS_COUNT_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXPKTGB:32;              /* Rx Packets Count Good Bad This field indicates the number of good and bad packets received. */
  } B;
} GMAC_RX_PACKETS_COUNT_GOOD_BAD_tag;

typedef union GMAC_RX_OCTET_COUNT_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXOCTGB:32;              /* Rx Octet Count Good Bad This field indicates the number of bytes received, exclusive of preamble, in good and bad packets. */
  } B;
} GMAC_RX_OCTET_COUNT_GOOD_BAD_tag;

typedef union GMAC_RX_OCTET_COUNT_GOOD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXOCTG:32;               /* Rx Octet Count Good This field indicates the number of bytes received, exclusive of preamble, only in good packets. */
  } B;
} GMAC_RX_OCTET_COUNT_GOOD_tag;

typedef union GMAC_RX_BROADCAST_PACKETS_GOOD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXBCASTG:32;             /* Rx Broadcast Packets Good This field indicates the number of good broadcast packets received. */
  } B;
} GMAC_RX_BROADCAST_PACKETS_GOOD_tag;

typedef union GMAC_RX_MULTICAST_PACKETS_GOOD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXMCASTG:32;             /* Rx Multicast Packets Good This field indicates the number of good multicast packets received. */
  } B;
} GMAC_RX_MULTICAST_PACKETS_GOOD_tag;

typedef union GMAC_RX_CRC_ERROR_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXCRCERR:32;             /* Rx CRC Error Packets This field indicates the number of packets received with CRC error. */
  } B;
} GMAC_RX_CRC_ERROR_PACKETS_tag;

typedef union GMAC_RX_ALIGNMENT_ERROR_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXALGNERR:32;            /* Rx Alignment Error Packets This field indicates the number of packets received with alignment (dribble) error. It is valid only in 10/100 mode. */
  } B;
} GMAC_RX_ALIGNMENT_ERROR_PACKETS_tag;

typedef union GMAC_RX_RUNT_ERROR_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXRUNTERR:32;            /* Rx Runt Error Packets This field indicates the number of packets received with runt (length less than 64 bytes and CRC error) error. */
  } B;
} GMAC_RX_RUNT_ERROR_PACKETS_tag;

typedef union GMAC_RX_JABBER_ERROR_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXJABERR:32;             /* Rx Jabber Error Packets This field indicates the number of giant packets received with length (including CRC) greater than 1,518 bytes (1,522 bytes for VLAN tagged) and with CRC error. If Jumbo Packet mode is enabled, packets of length greater than 9,018 bytes (9,022 bytes for VLAN tagged) are considered as giant packets. */
  } B;
} GMAC_RX_JABBER_ERROR_PACKETS_tag;

typedef union GMAC_RX_UNDERSIZE_PACKETS_GOOD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXUNDERSZG:32;           /* Rx Undersize Packets Good This field indicates the number of packets received with length less than 64 bytes, without any errors. */
  } B;
} GMAC_RX_UNDERSIZE_PACKETS_GOOD_tag;

typedef union GMAC_RX_OVERSIZE_PACKETS_GOOD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXOVERSZG:32;            /* Rx Oversize Packets Good This field indicates the number of packets received without errors, with length greater than the maxsize (1,518 bytes or 1,522 bytes for VLAN tagged packets; 2000 bytes if enabled in the S2KP bit of the MAC_Configuration register). */
  } B;
} GMAC_RX_OVERSIZE_PACKETS_GOOD_tag;

typedef union GMAC_RX_64OCTETS_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RX64OCTGB:32;            /* Rx 64 Octets Packets Good Bad This field indicates the number of good and bad packets received with length 64 bytes, exclusive of the preamble. */
  } B;
} GMAC_RX_64OCTETS_PACKETS_GOOD_BAD_tag;

typedef union GMAC_RX_65TO127OCTETS_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RX65_127OCTGB:32;        /* Rx 65-127 Octets Packets Good Bad This field indicates the number of good and bad packets received with length between 65 and 127 (inclusive) bytes, exclusive of the preamble. */
  } B;
} GMAC_RX_65TO127OCTETS_PACKETS_GOOD_BAD_tag;

typedef union GMAC_RX_128TO255OCTETS_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RX128_255OCTGB:32;       /* Rx 128-255 Octets Packets Good Bad This field indicates the number of good and bad packets received with length between 128 and 255 (inclusive) bytes, exclusive of the preamble. */
  } B;
} GMAC_RX_128TO255OCTETS_PACKETS_GOOD_BAD_tag;

typedef union GMAC_RX_256TO511OCTETS_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RX256_511OCTGB:32;       /* Rx 256-511 Octets Packets Good Bad This field indicates the number of good and bad packets received with length between 256 and 511 (inclusive) bytes, exclusive of the preamble. */
  } B;
} GMAC_RX_256TO511OCTETS_PACKETS_GOOD_BAD_tag;

typedef union GMAC_RX_512TO1023OCTETS_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RX512_1023OCTGB:32;      /* RX 512-1023 Octets Packets Good Bad This field indicates the number of good and bad packets received with length between 512 and 1023 (inclusive) bytes, exclusive of the preamble. */
  } B;
} GMAC_RX_512TO1023OCTETS_PACKETS_GOOD_BAD_tag;

typedef union GMAC_RX_1024TOMAXOCTETS_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RX1024_MAXOCTGB:32;      /* Rx 1024-Max Octets Good Bad This field indicates the number of good and bad packets received with length between 1024 and maxsize (inclusive) bytes, exclusive of the preamble. */
  } B;
} GMAC_RX_1024TOMAXOCTETS_PACKETS_GOOD_BAD_tag;

typedef union GMAC_RX_UNICAST_PACKETS_GOOD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXUCASTG:32;             /* Rx Unicast Packets Good This field indicates the number of good unicast packets received. */
  } B;
} GMAC_RX_UNICAST_PACKETS_GOOD_tag;

typedef union GMAC_RX_LENGTH_ERROR_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXLENERR:32;             /* Rx Length Error Packets This field indicates the number of packets received with length error (Length Type field not equal to packet size), for all packets with valid length field. */
  } B;
} GMAC_RX_LENGTH_ERROR_PACKETS_tag;

typedef union GMAC_RX_OUT_OF_RANGE_TYPE_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXOUTOFRNG:32;           /* Rx Out of Range Type Packet This field indicates the number of packets received with length field not equal to the valid packet size (greater than 1,500 but less than 1,536). */
  } B;
} GMAC_RX_OUT_OF_RANGE_TYPE_PACKETS_tag;

typedef union GMAC_RX_PAUSE_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXPAUSEPKT:32;           /* Rx Pause Packets This field indicates the number of good and valid Pause packets received. */
  } B;
} GMAC_RX_PAUSE_PACKETS_tag;

typedef union GMAC_RX_FIFO_OVERFLOW_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXFIFOOVFL:32;           /* Rx FIFO Overflow Packets This field indicates the number of missed received packets because of FIFO overflow. */
  } B;
} GMAC_RX_FIFO_OVERFLOW_PACKETS_tag;

typedef union GMAC_RX_VLAN_PACKETS_GOOD_BAD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXVLANPKTGB:32;          /* Rx VLAN Packets Good Bad This field indicates the number of good and bad VLAN packets received. */
  } B;
} GMAC_RX_VLAN_PACKETS_GOOD_BAD_tag;

typedef union GMAC_RX_WATCHDOG_ERROR_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXWDGERR:32;             /* Rx Watchdog Error Packets This field indicates the number of packets received with error because of watchdog timeout error (packets with a data load larger than 2,048 bytes (when JE and WD bits are reset in MAC_Configuration register), 10,240 bytes (when JE bit is set and WD bit is reset in MAC_Configuration register), 16,384 bytes (when WD bit is set in MAC_Configuration register) or the value programmed in the MAC_Watchdog_Timeout register). */
  } B;
} GMAC_RX_WATCHDOG_ERROR_PACKETS_tag;

typedef union GMAC_RX_RECEIVE_ERROR_PACKETS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXRCVERR:32;             /* Rx Receive Error Packets This field indicates the number of packets received with Receive error or Packet Extension error on the GMII or MII interface. */
  } B;
} GMAC_RX_RECEIVE_ERROR_PACKETS_tag;

typedef union GMAC_RX_CONTROL_PACKETS_GOOD_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXCTRLG:32;              /* Rx Control Packets Good This field indicates the number of good control packets received. */
  } B;
} GMAC_RX_CONTROL_PACKETS_GOOD_tag;

typedef union GMAC_MMC_FPE_TX_INTERRUPT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FCIS:1;                  /* MMC Tx FPE Fragment Counter Interrupt status This bit is set when the Tx_FPE_Fragment_Cntr counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. Exists when any one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
    vuint32_t HRCIS:1;                 /* MMC Tx Hold Request Counter Interrupt Status This bit is set when the Tx_Hold_Req_Cntr counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. Exists when any one of the RX/TX MMC counters are enabled during FPE with AV_EST Enabled configuration. */
    vuint32_t _unused_2:30;            /* Reserved. */
  } B;
} GMAC_MMC_FPE_TX_INTERRUPT_tag;

typedef union GMAC_MMC_FPE_TX_INTERRUPT_MASK_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FCIM:1;                  /* MMC Transmit Fragment Counter Interrupt Mask Setting this bit masks the interrupt when the Tx_FPE_Fragment_Cntr counter reaches half of the maximum value or the maximum value. Exists when any one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
    vuint32_t HRCIM:1;                 /* MMC Transmit Hold Request Counter Interrupt Mask Setting this bit masks the interrupt when the Tx_Hold_Req_Cntr counter reaches half of the maximum value or the maximum value. Exists when any one of the RX/TX MMC counters are enabled during FPE with AV_EST Enabled configuration. */
    vuint32_t _unused_2:30;            /* Reserved. */
  } B;
} GMAC_MMC_FPE_TX_INTERRUPT_MASK_tag;

typedef union GMAC_MMC_TX_FPE_FRAGMENT_CNTR_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXFFC:32;                /* Tx FPE Fragment counter This field indicates the number of additional mPackets that has been transmitted due to preemption Exists when any one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
  } B;
} GMAC_MMC_TX_FPE_FRAGMENT_CNTR_tag;

typedef union GMAC_MMC_TX_HOLD_REQ_CNTR_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXHRC:32;                /* Tx Hold Request Counter This field indicates count of number of a hold request is given to MAC. Exists when any one of the RX/TX MMC counters are enabled during FPE with AV_EST Enabled configuration. */
  } B;
} GMAC_MMC_TX_HOLD_REQ_CNTR_tag;

typedef union GMAC_MMC_FPE_RX_INTERRUPT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PAECIS:1;                /* MMC Rx Packet Assembly Error Counter Interrupt Status This bit is set when the Rx_Packet_Assemble_Err_Cntr counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. Exists when any one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
    vuint32_t PSECIS:1;                /* MMC Rx Packet SMD Error Counter Interrupt Status This bit is set when the Rx_Packet_SMD_Err_Cntr counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. Exists when any one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
    vuint32_t PAOCIS:1;                /* MMC Rx Packet Assembly OK Counter Interrupt Status This bit is set when the Rx_Packet_Assemble_Ok_Cntr counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. Exists when any one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
    vuint32_t FCIS:1;                  /* MMC Rx FPE Fragment Counter Interrupt Status This bit is set when the Rx_FPE_Fragment_Cntr counter reaches half of the maximum value or the maximum value. Access restriction applies. Clears on read. Self-set to 1 on internal event. Exists when any one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
    vuint32_t _unused_4:28;            /* Reserved. */
  } B;
} GMAC_MMC_FPE_RX_INTERRUPT_tag;

typedef union GMAC_MMC_FPE_RX_INTERRUPT_MASK_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PAECIM:1;                /* MMC Rx Packet Assembly Error Counter Interrupt Mask Setting this bit masks the interrupt when the R Rx_Packet_Assemble_Err_Cntr counter reaches half of the maximum value or the maximum value. Exists when any one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
    vuint32_t PSECIM:1;                /* MMC Rx Packet SMD Error Counter Interrupt Mask Setting this bit masks the interrupt when the R Rx_Packet_SMD_Err_Cntr counter reaches half of the maximum value or the maximum value. Exists when any one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
    vuint32_t PAOCIM:1;                /* MMC Rx Packet Assembly OK Counter Interrupt Mask Setting this bit masks the interrupt when the Rx_Packet_Assemble_Ok_Cntr counter reaches half of the maximum value or the maximum value. Exists when any one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
    vuint32_t FCIM:1;                  /* MMC Rx FPE Fragment Counter Interrupt Mask Setting this bit masks the interrupt when the Tx_FPE_Fragment_Cntr counter reaches half of the maximum value or the maximum value. Exists when any one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
    vuint32_t _unused_4:28;            /* Reserved. */
  } B;
} GMAC_MMC_FPE_RX_INTERRUPT_MASK_tag;

typedef union GMAC_MMC_RX_PACKET_ASSEMBLY_ERR_CNTR_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PAEC:32;                 /* Rx Packet Assembly Error Counter This field indicates the number of MAC frames with reassembly errors on the Receiver, due to mismatch in the Fragment Count value. Exists when any one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
  } B;
} GMAC_MMC_RX_PACKET_ASSEMBLY_ERR_CNTR_tag;

typedef union GMAC_MMC_RX_PACKET_SMD_ERR_CNTR_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PSEC:32;                 /* Rx Packet SMD Error Counter This field indicates the number of MAC frames rejected due to unknown SMD value and MAC frame fragments rejected due to arriving with an SMD-C when there was no preceding preempted frame. Exists when at least one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
  } B;
} GMAC_MMC_RX_PACKET_SMD_ERR_CNTR_tag;

typedef union GMAC_MMC_RX_PACKET_ASSEMBLY_OK_CNTR_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PAOC:32;                 /* Rx Packet Assembly OK Counter This field indicates the number of MAC frames that were successfully reassembled and delivered to MAC. Exists when at least one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
  } B;
} GMAC_MMC_RX_PACKET_ASSEMBLY_OK_CNTR_tag;

typedef union GMAC_MMC_RX_FPE_FRAGMENT_CNTR_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FFC:32;                  /* Rx FPE Fragment Counter This field indicates the number of additional mPackets received due to preemption Exists when at least one of the RX/TX MMC counters are enabled during FPE Enabled configuration. */
  } B;
} GMAC_MMC_RX_FPE_FRAGMENT_CNTR_tag;

typedef union GMAC_MAC_L3_L4_CONTROL0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3PEN0:1;                /* Layer 3 Protocol Enable When this bit is set, the Layer 3 IP Source or Destination Address matching is enabled for IPv6 packets. When this bit is reset, the Layer 3 IP Source or Destination Address matching is enabled for IPv4 packets. The Layer 3 matching is done only when the L3SAM0 or L3DAM0 bit is set. */
    vuint32_t _unused_1:1;             /* Reserved. */
    vuint32_t L3SAM0:1;                /* Layer 3 IP SA Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Source Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3DAM0 bit because either IPv6 SA or DA can be checked for filtering. */
    vuint32_t L3SAIM0:1;               /* Layer 3 IP SA Inverse Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for inverse matching. When this bit reset, the Layer 3 IP Source Address field is enabled for perfect matching. This bit is valid and applicable only when the L3SAM0 bit is set. */
    vuint32_t L3DAM0:1;                /* Layer 3 IP DA Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Destination Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3SAM0 bit because either IPv6 DA or SA can be checked for filtering. */
    vuint32_t L3DAIM0:1;               /* Layer 3 IP DA Inverse Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for inverse matching. When this bit is reset, the Layer 3 IP Destination Address field is enabled for perfect matching. This bit is valid and applicable only when the L3DAM0 bit is set high. */
    vuint32_t L3HSBM0:5;               /* Layer 3 IP SA Higher Bits Match IPv4 Packets: This field contains the number of lower bits of IP Source Address that are masked for matching in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: This field contains Bits[4:0] of L3HSBM0. These bits indicate the number of higher bits of IP Source or Destination Address matched in the IPv6 packets. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set high. */
    vuint32_t L3HDBM0:5;               /* Layer 3 IP DA Higher Bits Match IPv4 Packets: This field contains the number of higher bits of IP Destination Address that are matched in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: Bits[12:11] of this field correspond to Bits[6:5] of L3HSBM0 which indicate the number of lower bits of IP Source or Destination Address that are masked in the IPv6 packets. The following list describes the concatenated values of the L3HDBM0[1:0] and L3HSBM0 bits: - 0: No bits are masked. - 1: LSb[0] is masked. - 2: Two LSbs [1:0] are masked - .. - 127: All bits except MSb are masked. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set. */
    vuint32_t L4PEN0:1;                /* Layer 4 Protocol Enable When this bit is set, the Source and Destination Port number fields of UDP packets are used for matching. When this bit is reset, the Source and Destination Port number fields of TCP packets are used for matching. The Layer 4 matching is done only when the L4SPM0 or L4DPM0 bit is set. */
    vuint32_t _unused_17:1;            /* Reserved. */
    vuint32_t L4SPM0:1;                /* Layer 4 Source Port Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Source Port number field for matching. */
    vuint32_t L4SPIM0:1;               /* Layer 4 Source Port Inverse Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Source Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4SPM0 bit is set high. */
    vuint32_t L4DPM0:1;                /* Layer 4 Destination Port Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Destination Port number field for matching. */
    vuint32_t L4DPIM0:1;               /* Layer 4 Destination Port Inverse Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Destination Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4DPM0 bit is set high. */
    vuint32_t _unused_22:2;            /* Reserved. */
    vuint32_t DMCHN0:3;                /* DMA Channel Number When DMCHEN is set high, this field selects the DMA Channel number to which the packet passed by this filter is routed. The width of this field depends on the number of the DMA channels present in your configuration. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t DMCHEN0:1;               /* DMA Channel Select Enable When set, this bit enables the selection of the DMA channel number for the packet that is passed by this L3_L4 filter. The DMA channel is indicated by the DMCHN bits. When this bit is reset, the DMA channel is not decided by this filter. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MAC_L3_L4_CONTROL0_tag;

typedef union GMAC_MAC_LAYER4_ADDRESS0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L4SP0:16;                /* Layer 4 Source Port Number Field When the L4PEN0 bit is reset and the L4SPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Source Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4SPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Source Port Number field in the IPv4 or IPv6 packets. */
    vuint32_t L4DP0:16;                /* Layer 4 Destination Port Number Field When the L4PEN0 bit is reset and the L4DPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Destination Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4DPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Destination Port Number field in the IPv4 or IPv6 packets. */
  } B;
} GMAC_MAC_LAYER4_ADDRESS0_tag;

typedef union GMAC_MAC_LAYER3_ADDR0_REG0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A00:32;                /* Layer 3 Address 0 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Source Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR0_REG0_tag;

typedef union GMAC_MAC_LAYER3_ADDR1_REG0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A10:32;                /* Layer 3 Address 1 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Destination Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR1_REG0_tag;

typedef union GMAC_MAC_LAYER3_ADDR2_REG0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A20:32;                /* Layer 3 Address 2 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR2_REG0_tag;

typedef union GMAC_MAC_LAYER3_ADDR3_REG0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A30:32;                /* Layer 3 Address 3 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR3_REG0_tag;

typedef union GMAC_MAC_L3_L4_CONTROL1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3PEN1:1;                /* Layer 3 Protocol Enable When this bit is set, the Layer 3 IP Source or Destination Address matching is enabled for IPv6 packets. When this bit is reset, the Layer 3 IP Source or Destination Address matching is enabled for IPv4 packets. The Layer 3 matching is done only when the L3SAM0 or L3DAM0 bit is set. */
    vuint32_t _unused_1:1;             /* Reserved. */
    vuint32_t L3SAM1:1;                /* Layer 3 IP SA Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Source Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3DAM0 bit because either IPv6 SA or DA can be checked for filtering. */
    vuint32_t L3SAIM1:1;               /* Layer 3 IP SA Inverse Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for inverse matching. When this bit reset, the Layer 3 IP Source Address field is enabled for perfect matching. This bit is valid and applicable only when the L3SAM0 bit is set. */
    vuint32_t L3DAM1:1;                /* Layer 3 IP DA Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Destination Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3SAM0 bit because either IPv6 DA or SA can be checked for filtering. */
    vuint32_t L3DAIM1:1;               /* Layer 3 IP DA Inverse Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for inverse matching. When this bit is reset, the Layer 3 IP Destination Address field is enabled for perfect matching. This bit is valid and applicable only when the L3DAM0 bit is set high. */
    vuint32_t L3HSBM1:5;               /* Layer 3 IP SA Higher Bits Match IPv4 Packets: This field contains the number of lower bits of IP Source Address that are masked for matching in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: This field contains Bits[4:0] of L3HSBM0. These bits indicate the number of higher bits of IP Source or Destination Address matched in the IPv6 packets. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set high. */
    vuint32_t L3HDBM1:5;               /* Layer 3 IP DA Higher Bits Match IPv4 Packets: This field contains the number of higher bits of IP Destination Address that are matched in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: Bits[12:11] of this field correspond to Bits[6:5] of L3HSBM0 which indicate the number of lower bits of IP Source or Destination Address that are masked in the IPv6 packets. The following list describes the concatenated values of the L3HDBM0[1:0] and L3HSBM0 bits: - 0: No bits are masked. - 1: LSb[0] is masked. - 2: Two LSbs [1:0] are masked - .. - 127: All bits except MSb are masked. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set. */
    vuint32_t L4PEN1:1;                /* Layer 4 Protocol Enable When this bit is set, the Source and Destination Port number fields of UDP packets are used for matching. When this bit is reset, the Source and Destination Port number fields of TCP packets are used for matching. The Layer 4 matching is done only when the L4SPM0 or L4DPM0 bit is set. */
    vuint32_t _unused_17:1;            /* Reserved. */
    vuint32_t L4SPM1:1;                /* Layer 4 Source Port Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Source Port number field for matching. */
    vuint32_t L4SPIM1:1;               /* Layer 4 Source Port Inverse Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Source Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4SPM0 bit is set high. */
    vuint32_t L4DPM1:1;                /* Layer 4 Destination Port Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Destination Port number field for matching. */
    vuint32_t L4DPIM1:1;               /* Layer 4 Destination Port Inverse Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Destination Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4DPM0 bit is set high. */
    vuint32_t _unused_22:2;            /* Reserved. */
    vuint32_t DMCHN1:3;                /* DMA Channel Number When DMCHEN is set high, this field selects the DMA Channel number to which the packet passed by this filter is routed. The width of this field depends on the number of the DMA channels present in your configuration. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t DMCHEN1:1;               /* DMA Channel Select Enable When set, this bit enables the selection of the DMA channel number for the packet that is passed by this L3_L4 filter. The DMA channel is indicated by the DMCHN bits. When this bit is reset, the DMA channel is not decided by this filter. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MAC_L3_L4_CONTROL1_tag;

typedef union GMAC_MAC_LAYER4_ADDRESS1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L4SP1:16;                /* Layer 4 Source Port Number Field When the L4PEN0 bit is reset and the L4SPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Source Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4SPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Source Port Number field in the IPv4 or IPv6 packets. */
    vuint32_t L4DP1:16;                /* Layer 4 Destination Port Number Field When the L4PEN0 bit is reset and the L4DPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Destination Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4DPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Destination Port Number field in the IPv4 or IPv6 packets. */
  } B;
} GMAC_MAC_LAYER4_ADDRESS1_tag;

typedef union GMAC_MAC_LAYER3_ADDR0_REG1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A01:32;                /* Layer 3 Address 0 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Source Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR0_REG1_tag;

typedef union GMAC_MAC_LAYER3_ADDR1_REG1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A11:32;                /* Layer 3 Address 1 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Destination Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR1_REG1_tag;

typedef union GMAC_MAC_LAYER3_ADDR2_REG1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A21:32;                /* Layer 3 Address 2 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR2_REG1_tag;

typedef union GMAC_MAC_LAYER3_ADDR3_REG1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A31:32;                /* Layer 3 Address 3 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR3_REG1_tag;

typedef union GMAC_MAC_L3_L4_CONTROL2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3PEN2:1;                /* Layer 3 Protocol Enable When this bit is set, the Layer 3 IP Source or Destination Address matching is enabled for IPv6 packets. When this bit is reset, the Layer 3 IP Source or Destination Address matching is enabled for IPv4 packets. The Layer 3 matching is done only when the L3SAM0 or L3DAM0 bit is set. */
    vuint32_t _unused_1:1;             /* Reserved. */
    vuint32_t L3SAM2:1;                /* Layer 3 IP SA Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Source Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3DAM0 bit because either IPv6 SA or DA can be checked for filtering. */
    vuint32_t L3SAIM2:1;               /* Layer 3 IP SA Inverse Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for inverse matching. When this bit reset, the Layer 3 IP Source Address field is enabled for perfect matching. This bit is valid and applicable only when the L3SAM0 bit is set. */
    vuint32_t L3DAM2:1;                /* Layer 3 IP DA Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Destination Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3SAM0 bit because either IPv6 DA or SA can be checked for filtering. */
    vuint32_t L3DAIM2:1;               /* Layer 3 IP DA Inverse Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for inverse matching. When this bit is reset, the Layer 3 IP Destination Address field is enabled for perfect matching. This bit is valid and applicable only when the L3DAM0 bit is set high. */
    vuint32_t L3HSBM2:5;               /* Layer 3 IP SA Higher Bits Match IPv4 Packets: This field contains the number of lower bits of IP Source Address that are masked for matching in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: This field contains Bits[4:0] of L3HSBM0. These bits indicate the number of higher bits of IP Source or Destination Address matched in the IPv6 packets. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set high. */
    vuint32_t L3HDBM2:5;               /* Layer 3 IP DA Higher Bits Match IPv4 Packets: This field contains the number of higher bits of IP Destination Address that are matched in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: Bits[12:11] of this field correspond to Bits[6:5] of L3HSBM0 which indicate the number of lower bits of IP Source or Destination Address that are masked in the IPv6 packets. The following list describes the concatenated values of the L3HDBM0[1:0] and L3HSBM0 bits: - 0: No bits are masked. - 1: LSb[0] is masked. - 2: Two LSbs [1:0] are masked - .. - 127: All bits except MSb are masked. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set. */
    vuint32_t L4PEN2:1;                /* Layer 4 Protocol Enable When this bit is set, the Source and Destination Port number fields of UDP packets are used for matching. When this bit is reset, the Source and Destination Port number fields of TCP packets are used for matching. The Layer 4 matching is done only when the L4SPM0 or L4DPM0 bit is set. */
    vuint32_t _unused_17:1;            /* Reserved. */
    vuint32_t L4SPM2:1;                /* Layer 4 Source Port Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Source Port number field for matching. */
    vuint32_t L4SPIM2:1;               /* Layer 4 Source Port Inverse Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Source Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4SPM0 bit is set high. */
    vuint32_t L4DPM2:1;                /* Layer 4 Destination Port Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Destination Port number field for matching. */
    vuint32_t L4DPIM2:1;               /* Layer 4 Destination Port Inverse Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Destination Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4DPM0 bit is set high. */
    vuint32_t _unused_22:2;            /* Reserved. */
    vuint32_t DMCHN2:3;                /* DMA Channel Number When DMCHEN is set high, this field selects the DMA Channel number to which the packet passed by this filter is routed. The width of this field depends on the number of the DMA channels present in your configuration. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t DMCHEN2:1;               /* DMA Channel Select Enable When set, this bit enables the selection of the DMA channel number for the packet that is passed by this L3_L4 filter. The DMA channel is indicated by the DMCHN bits. When this bit is reset, the DMA channel is not decided by this filter. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MAC_L3_L4_CONTROL2_tag;

typedef union GMAC_MAC_LAYER4_ADDRESS2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L4SP2:16;                /* Layer 4 Source Port Number Field When the L4PEN0 bit is reset and the L4SPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Source Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4SPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Source Port Number field in the IPv4 or IPv6 packets. */
    vuint32_t L4DP2:16;                /* Layer 4 Destination Port Number Field When the L4PEN0 bit is reset and the L4DPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Destination Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4DPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Destination Port Number field in the IPv4 or IPv6 packets. */
  } B;
} GMAC_MAC_LAYER4_ADDRESS2_tag;

typedef union GMAC_MAC_LAYER3_ADDR0_REG2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A02:32;                /* Layer 3 Address 0 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Source Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR0_REG2_tag;

typedef union GMAC_MAC_LAYER3_ADDR1_REG2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A12:32;                /* Layer 3 Address 1 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Destination Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR1_REG2_tag;

typedef union GMAC_MAC_LAYER3_ADDR2_REG2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A22:32;                /* Layer 3 Address 2 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR2_REG2_tag;

typedef union GMAC_MAC_LAYER3_ADDR3_REG2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A32:32;                /* Layer 3 Address 3 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR3_REG2_tag;

typedef union GMAC_MAC_L3_L4_CONTROL3_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3PEN3:1;                /* Layer 3 Protocol Enable When this bit is set, the Layer 3 IP Source or Destination Address matching is enabled for IPv6 packets. When this bit is reset, the Layer 3 IP Source or Destination Address matching is enabled for IPv4 packets. The Layer 3 matching is done only when the L3SAM0 or L3DAM0 bit is set. */
    vuint32_t _unused_1:1;             /* Reserved. */
    vuint32_t L3SAM3:1;                /* Layer 3 IP SA Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Source Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3DAM0 bit because either IPv6 SA or DA can be checked for filtering. */
    vuint32_t L3SAIM3:1;               /* Layer 3 IP SA Inverse Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for inverse matching. When this bit reset, the Layer 3 IP Source Address field is enabled for perfect matching. This bit is valid and applicable only when the L3SAM0 bit is set. */
    vuint32_t L3DAM3:1;                /* Layer 3 IP DA Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Destination Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3SAM0 bit because either IPv6 DA or SA can be checked for filtering. */
    vuint32_t L3DAIM3:1;               /* Layer 3 IP DA Inverse Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for inverse matching. When this bit is reset, the Layer 3 IP Destination Address field is enabled for perfect matching. This bit is valid and applicable only when the L3DAM0 bit is set high. */
    vuint32_t L3HSBM3:5;               /* Layer 3 IP SA Higher Bits Match IPv4 Packets: This field contains the number of lower bits of IP Source Address that are masked for matching in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: This field contains Bits[4:0] of L3HSBM0. These bits indicate the number of higher bits of IP Source or Destination Address matched in the IPv6 packets. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set high. */
    vuint32_t L3HDBM3:5;               /* Layer 3 IP DA Higher Bits Match IPv4 Packets: This field contains the number of higher bits of IP Destination Address that are matched in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: Bits[12:11] of this field correspond to Bits[6:5] of L3HSBM0 which indicate the number of lower bits of IP Source or Destination Address that are masked in the IPv6 packets. The following list describes the concatenated values of the L3HDBM0[1:0] and L3HSBM0 bits: - 0: No bits are masked. - 1: LSb[0] is masked. - 2: Two LSbs [1:0] are masked - .. - 127: All bits except MSb are masked. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set. */
    vuint32_t L4PEN3:1;                /* Layer 4 Protocol Enable When this bit is set, the Source and Destination Port number fields of UDP packets are used for matching. When this bit is reset, the Source and Destination Port number fields of TCP packets are used for matching. The Layer 4 matching is done only when the L4SPM0 or L4DPM0 bit is set. */
    vuint32_t _unused_17:1;            /* Reserved. */
    vuint32_t L4SPM3:1;                /* Layer 4 Source Port Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Source Port number field for matching. */
    vuint32_t L4SPIM3:1;               /* Layer 4 Source Port Inverse Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Source Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4SPM0 bit is set high. */
    vuint32_t L4DPM3:1;                /* Layer 4 Destination Port Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Destination Port number field for matching. */
    vuint32_t L4DPIM3:1;               /* Layer 4 Destination Port Inverse Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Destination Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4DPM0 bit is set high. */
    vuint32_t _unused_22:2;            /* Reserved. */
    vuint32_t DMCHN3:3;                /* DMA Channel Number When DMCHEN is set high, this field selects the DMA Channel number to which the packet passed by this filter is routed. The width of this field depends on the number of the DMA channels present in your configuration. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t DMCHEN3:1;               /* DMA Channel Select Enable When set, this bit enables the selection of the DMA channel number for the packet that is passed by this L3_L4 filter. The DMA channel is indicated by the DMCHN bits. When this bit is reset, the DMA channel is not decided by this filter. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MAC_L3_L4_CONTROL3_tag;

typedef union GMAC_MAC_LAYER4_ADDRESS3_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L4SP3:16;                /* Layer 4 Source Port Number Field When the L4PEN0 bit is reset and the L4SPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Source Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4SPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Source Port Number field in the IPv4 or IPv6 packets. */
    vuint32_t L4DP3:16;                /* Layer 4 Destination Port Number Field When the L4PEN0 bit is reset and the L4DPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Destination Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4DPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Destination Port Number field in the IPv4 or IPv6 packets. */
  } B;
} GMAC_MAC_LAYER4_ADDRESS3_tag;

typedef union GMAC_MAC_LAYER3_ADDR0_REG3_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A03:32;                /* Layer 3 Address 0 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Source Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR0_REG3_tag;

typedef union GMAC_MAC_LAYER3_ADDR1_REG3_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A13:32;                /* Layer 3 Address 1 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Destination Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR1_REG3_tag;

typedef union GMAC_MAC_LAYER3_ADDR2_REG3_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A23:32;                /* Layer 3 Address 2 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR2_REG3_tag;

typedef union GMAC_MAC_LAYER3_ADDR3_REG3_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A33:32;                /* Layer 3 Address 3 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR3_REG3_tag;

typedef union GMAC_MAC_L3_L4_CONTROL4_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3PEN4:1;                /* Layer 3 Protocol Enable When this bit is set, the Layer 3 IP Source or Destination Address matching is enabled for IPv6 packets. When this bit is reset, the Layer 3 IP Source or Destination Address matching is enabled for IPv4 packets. The Layer 3 matching is done only when the L3SAM0 or L3DAM0 bit is set. */
    vuint32_t _unused_1:1;             /* Reserved. */
    vuint32_t L3SAM4:1;                /* Layer 3 IP SA Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Source Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3DAM0 bit because either IPv6 SA or DA can be checked for filtering. */
    vuint32_t L3SAIM4:1;               /* Layer 3 IP SA Inverse Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for inverse matching. When this bit reset, the Layer 3 IP Source Address field is enabled for perfect matching. This bit is valid and applicable only when the L3SAM0 bit is set. */
    vuint32_t L3DAM4:1;                /* Layer 3 IP DA Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Destination Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3SAM0 bit because either IPv6 DA or SA can be checked for filtering. */
    vuint32_t L3DAIM4:1;               /* Layer 3 IP DA Inverse Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for inverse matching. When this bit is reset, the Layer 3 IP Destination Address field is enabled for perfect matching. This bit is valid and applicable only when the L3DAM0 bit is set high. */
    vuint32_t L3HSBM4:5;               /* Layer 3 IP SA Higher Bits Match IPv4 Packets: This field contains the number of lower bits of IP Source Address that are masked for matching in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: This field contains Bits[4:0] of L3HSBM0. These bits indicate the number of higher bits of IP Source or Destination Address matched in the IPv6 packets. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set high. */
    vuint32_t L3HDBM4:5;               /* Layer 3 IP DA Higher Bits Match IPv4 Packets: This field contains the number of higher bits of IP Destination Address that are matched in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: Bits[12:11] of this field correspond to Bits[6:5] of L3HSBM0 which indicate the number of lower bits of IP Source or Destination Address that are masked in the IPv6 packets. The following list describes the concatenated values of the L3HDBM0[1:0] and L3HSBM0 bits: - 0: No bits are masked. - 1: LSb[0] is masked. - 2: Two LSbs [1:0] are masked - .. - 127: All bits except MSb are masked. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set. */
    vuint32_t L4PEN4:1;                /* Layer 4 Protocol Enable When this bit is set, the Source and Destination Port number fields of UDP packets are used for matching. When this bit is reset, the Source and Destination Port number fields of TCP packets are used for matching. The Layer 4 matching is done only when the L4SPM0 or L4DPM0 bit is set. */
    vuint32_t _unused_17:1;            /* Reserved. */
    vuint32_t L4SPM4:1;                /* Layer 4 Source Port Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Source Port number field for matching. */
    vuint32_t L4SPIM4:1;               /* Layer 4 Source Port Inverse Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Source Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4SPM0 bit is set high. */
    vuint32_t L4DPM4:1;                /* Layer 4 Destination Port Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Destination Port number field for matching. */
    vuint32_t L4DPIM4:1;               /* Layer 4 Destination Port Inverse Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Destination Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4DPM0 bit is set high. */
    vuint32_t _unused_22:2;            /* Reserved. */
    vuint32_t DMCHN4:3;                /* DMA Channel Number When DMCHEN is set high, this field selects the DMA Channel number to which the packet passed by this filter is routed. The width of this field depends on the number of the DMA channels present in your configuration. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t DMCHEN4:1;               /* DMA Channel Select Enable When set, this bit enables the selection of the DMA channel number for the packet that is passed by this L3_L4 filter. The DMA channel is indicated by the DMCHN bits. When this bit is reset, the DMA channel is not decided by this filter. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MAC_L3_L4_CONTROL4_tag;

typedef union GMAC_MAC_LAYER4_ADDRESS4_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L4SP4:16;                /* Layer 4 Source Port Number Field When the L4PEN0 bit is reset and the L4SPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Source Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4SPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Source Port Number field in the IPv4 or IPv6 packets. */
    vuint32_t L4DP4:16;                /* Layer 4 Destination Port Number Field When the L4PEN0 bit is reset and the L4DPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Destination Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4DPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Destination Port Number field in the IPv4 or IPv6 packets. */
  } B;
} GMAC_MAC_LAYER4_ADDRESS4_tag;

typedef union GMAC_MAC_LAYER3_ADDR0_REG4_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A04:32;                /* Layer 3 Address 0 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Source Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR0_REG4_tag;

typedef union GMAC_MAC_LAYER3_ADDR1_REG4_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A14:32;                /* Layer 3 Address 1 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Destination Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR1_REG4_tag;

typedef union GMAC_MAC_LAYER3_ADDR2_REG4_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A24:32;                /* Layer 3 Address 2 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR2_REG4_tag;

typedef union GMAC_MAC_LAYER3_ADDR3_REG4_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A34:32;                /* Layer 3 Address 3 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR3_REG4_tag;

typedef union GMAC_MAC_L3_L4_CONTROL5_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3PEN5:1;                /* Layer 3 Protocol Enable When this bit is set, the Layer 3 IP Source or Destination Address matching is enabled for IPv6 packets. When this bit is reset, the Layer 3 IP Source or Destination Address matching is enabled for IPv4 packets. The Layer 3 matching is done only when the L3SAM0 or L3DAM0 bit is set. */
    vuint32_t _unused_1:1;             /* Reserved. */
    vuint32_t L3SAM5:1;                /* Layer 3 IP SA Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Source Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3DAM0 bit because either IPv6 SA or DA can be checked for filtering. */
    vuint32_t L3SAIM5:1;               /* Layer 3 IP SA Inverse Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for inverse matching. When this bit reset, the Layer 3 IP Source Address field is enabled for perfect matching. This bit is valid and applicable only when the L3SAM0 bit is set. */
    vuint32_t L3DAM5:1;                /* Layer 3 IP DA Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Destination Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3SAM0 bit because either IPv6 DA or SA can be checked for filtering. */
    vuint32_t L3DAIM5:1;               /* Layer 3 IP DA Inverse Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for inverse matching. When this bit is reset, the Layer 3 IP Destination Address field is enabled for perfect matching. This bit is valid and applicable only when the L3DAM0 bit is set high. */
    vuint32_t L3HSBM5:5;               /* Layer 3 IP SA Higher Bits Match IPv4 Packets: This field contains the number of lower bits of IP Source Address that are masked for matching in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: This field contains Bits[4:0] of L3HSBM0. These bits indicate the number of higher bits of IP Source or Destination Address matched in the IPv6 packets. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set high. */
    vuint32_t L3HDBM5:5;               /* Layer 3 IP DA Higher Bits Match IPv4 Packets: This field contains the number of higher bits of IP Destination Address that are matched in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: Bits[12:11] of this field correspond to Bits[6:5] of L3HSBM0 which indicate the number of lower bits of IP Source or Destination Address that are masked in the IPv6 packets. The following list describes the concatenated values of the L3HDBM0[1:0] and L3HSBM0 bits: - 0: No bits are masked. - 1: LSb[0] is masked. - 2: Two LSbs [1:0] are masked - .. - 127: All bits except MSb are masked. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set. */
    vuint32_t L4PEN5:1;                /* Layer 4 Protocol Enable When this bit is set, the Source and Destination Port number fields of UDP packets are used for matching. When this bit is reset, the Source and Destination Port number fields of TCP packets are used for matching. The Layer 4 matching is done only when the L4SPM0 or L4DPM0 bit is set. */
    vuint32_t _unused_17:1;            /* Reserved. */
    vuint32_t L4SPM5:1;                /* Layer 4 Source Port Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Source Port number field for matching. */
    vuint32_t L4SPIM5:1;               /* Layer 4 Source Port Inverse Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Source Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4SPM0 bit is set high. */
    vuint32_t L4DPM5:1;                /* Layer 4 Destination Port Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Destination Port number field for matching. */
    vuint32_t L4DPIM5:1;               /* Layer 4 Destination Port Inverse Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Destination Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4DPM0 bit is set high. */
    vuint32_t _unused_22:2;            /* Reserved. */
    vuint32_t DMCHN5:3;                /* DMA Channel Number When DMCHEN is set high, this field selects the DMA Channel number to which the packet passed by this filter is routed. The width of this field depends on the number of the DMA channels present in your configuration. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t DMCHEN5:1;               /* DMA Channel Select Enable When set, this bit enables the selection of the DMA channel number for the packet that is passed by this L3_L4 filter. The DMA channel is indicated by the DMCHN bits. When this bit is reset, the DMA channel is not decided by this filter. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MAC_L3_L4_CONTROL5_tag;

typedef union GMAC_MAC_LAYER4_ADDRESS5_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L4SP5:16;                /* Layer 4 Source Port Number Field When the L4PEN0 bit is reset and the L4SPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Source Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4SPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Source Port Number field in the IPv4 or IPv6 packets. */
    vuint32_t L4DP5:16;                /* Layer 4 Destination Port Number Field When the L4PEN0 bit is reset and the L4DPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Destination Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4DPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Destination Port Number field in the IPv4 or IPv6 packets. */
  } B;
} GMAC_MAC_LAYER4_ADDRESS5_tag;

typedef union GMAC_MAC_LAYER3_ADDR0_REG5_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A05:32;                /* Layer 3 Address 0 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Source Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR0_REG5_tag;

typedef union GMAC_MAC_LAYER3_ADDR1_REG5_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A15:32;                /* Layer 3 Address 1 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Destination Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR1_REG5_tag;

typedef union GMAC_MAC_LAYER3_ADDR2_REG5_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A25:32;                /* Layer 3 Address 2 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR2_REG5_tag;

typedef union GMAC_MAC_LAYER3_ADDR3_REG5_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A35:32;                /* Layer 3 Address 3 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR3_REG5_tag;

typedef union GMAC_MAC_L3_L4_CONTROL6_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3PEN6:1;                /* Layer 3 Protocol Enable When this bit is set, the Layer 3 IP Source or Destination Address matching is enabled for IPv6 packets. When this bit is reset, the Layer 3 IP Source or Destination Address matching is enabled for IPv4 packets. The Layer 3 matching is done only when the L3SAM0 or L3DAM0 bit is set. */
    vuint32_t _unused_1:1;             /* Reserved. */
    vuint32_t L3SAM6:1;                /* Layer 3 IP SA Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Source Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3DAM0 bit because either IPv6 SA or DA can be checked for filtering. */
    vuint32_t L3SAIM6:1;               /* Layer 3 IP SA Inverse Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for inverse matching. When this bit reset, the Layer 3 IP Source Address field is enabled for perfect matching. This bit is valid and applicable only when the L3SAM0 bit is set. */
    vuint32_t L3DAM6:1;                /* Layer 3 IP DA Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Destination Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3SAM0 bit because either IPv6 DA or SA can be checked for filtering. */
    vuint32_t L3DAIM6:1;               /* Layer 3 IP DA Inverse Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for inverse matching. When this bit is reset, the Layer 3 IP Destination Address field is enabled for perfect matching. This bit is valid and applicable only when the L3DAM0 bit is set high. */
    vuint32_t L3HSBM6:5;               /* Layer 3 IP SA Higher Bits Match IPv4 Packets: This field contains the number of lower bits of IP Source Address that are masked for matching in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: This field contains Bits[4:0] of L3HSBM0. These bits indicate the number of higher bits of IP Source or Destination Address matched in the IPv6 packets. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set high. */
    vuint32_t L3HDBM6:5;               /* Layer 3 IP DA Higher Bits Match IPv4 Packets: This field contains the number of higher bits of IP Destination Address that are matched in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: Bits[12:11] of this field correspond to Bits[6:5] of L3HSBM0 which indicate the number of lower bits of IP Source or Destination Address that are masked in the IPv6 packets. The following list describes the concatenated values of the L3HDBM0[1:0] and L3HSBM0 bits: - 0: No bits are masked. - 1: LSb[0] is masked. - 2: Two LSbs [1:0] are masked - .. - 127: All bits except MSb are masked. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set. */
    vuint32_t L4PEN6:1;                /* Layer 4 Protocol Enable When this bit is set, the Source and Destination Port number fields of UDP packets are used for matching. When this bit is reset, the Source and Destination Port number fields of TCP packets are used for matching. The Layer 4 matching is done only when the L4SPM0 or L4DPM0 bit is set. */
    vuint32_t _unused_17:1;            /* Reserved. */
    vuint32_t L4SPM6:1;                /* Layer 4 Source Port Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Source Port number field for matching. */
    vuint32_t L4SPIM6:1;               /* Layer 4 Source Port Inverse Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Source Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4SPM0 bit is set high. */
    vuint32_t L4DPM6:1;                /* Layer 4 Destination Port Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Destination Port number field for matching. */
    vuint32_t L4DPIM6:1;               /* Layer 4 Destination Port Inverse Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Destination Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4DPM0 bit is set high. */
    vuint32_t _unused_22:2;            /* Reserved. */
    vuint32_t DMCHN6:3;                /* DMA Channel Number When DMCHEN is set high, this field selects the DMA Channel number to which the packet passed by this filter is routed. The width of this field depends on the number of the DMA channels present in your configuration. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t DMCHEN6:1;               /* DMA Channel Select Enable When set, this bit enables the selection of the DMA channel number for the packet that is passed by this L3_L4 filter. The DMA channel is indicated by the DMCHN bits. When this bit is reset, the DMA channel is not decided by this filter. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MAC_L3_L4_CONTROL6_tag;

typedef union GMAC_MAC_LAYER4_ADDRESS6_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L4SP6:16;                /* Layer 4 Source Port Number Field When the L4PEN0 bit is reset and the L4SPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Source Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4SPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Source Port Number field in the IPv4 or IPv6 packets. */
    vuint32_t L4DP6:16;                /* Layer 4 Destination Port Number Field When the L4PEN0 bit is reset and the L4DPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Destination Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4DPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Destination Port Number field in the IPv4 or IPv6 packets. */
  } B;
} GMAC_MAC_LAYER4_ADDRESS6_tag;

typedef union GMAC_MAC_LAYER3_ADDR0_REG6_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A06:32;                /* Layer 3 Address 0 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Source Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR0_REG6_tag;

typedef union GMAC_MAC_LAYER3_ADDR1_REG6_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A16:32;                /* Layer 3 Address 1 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Destination Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR1_REG6_tag;

typedef union GMAC_MAC_LAYER3_ADDR2_REG6_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A26:32;                /* Layer 3 Address 2 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR2_REG6_tag;

typedef union GMAC_MAC_LAYER3_ADDR3_REG6_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A36:32;                /* Layer 3 Address 3 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR3_REG6_tag;

typedef union GMAC_MAC_L3_L4_CONTROL7_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3PEN7:1;                /* Layer 3 Protocol Enable When this bit is set, the Layer 3 IP Source or Destination Address matching is enabled for IPv6 packets. When this bit is reset, the Layer 3 IP Source or Destination Address matching is enabled for IPv4 packets. The Layer 3 matching is done only when the L3SAM0 or L3DAM0 bit is set. */
    vuint32_t _unused_1:1;             /* Reserved. */
    vuint32_t L3SAM7:1;                /* Layer 3 IP SA Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Source Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3DAM0 bit because either IPv6 SA or DA can be checked for filtering. */
    vuint32_t L3SAIM7:1;               /* Layer 3 IP SA Inverse Match Enable When this bit is set, the Layer 3 IP Source Address field is enabled for inverse matching. When this bit reset, the Layer 3 IP Source Address field is enabled for perfect matching. This bit is valid and applicable only when the L3SAM0 bit is set. */
    vuint32_t L3DAM7:1;                /* Layer 3 IP DA Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for matching. When this bit is reset, the MAC ignores the Layer 3 IP Destination Address field for matching. Note: When the L3PEN0 bit is set, you should set either this bit or the L3SAM0 bit because either IPv6 DA or SA can be checked for filtering. */
    vuint32_t L3DAIM7:1;               /* Layer 3 IP DA Inverse Match Enable When this bit is set, the Layer 3 IP Destination Address field is enabled for inverse matching. When this bit is reset, the Layer 3 IP Destination Address field is enabled for perfect matching. This bit is valid and applicable only when the L3DAM0 bit is set high. */
    vuint32_t L3HSBM7:5;               /* Layer 3 IP SA Higher Bits Match IPv4 Packets: This field contains the number of lower bits of IP Source Address that are masked for matching in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: This field contains Bits[4:0] of L3HSBM0. These bits indicate the number of higher bits of IP Source or Destination Address matched in the IPv6 packets. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set high. */
    vuint32_t L3HDBM7:5;               /* Layer 3 IP DA Higher Bits Match IPv4 Packets: This field contains the number of higher bits of IP Destination Address that are matched in the IPv4 packets. The following list describes the values of this field: - 0: No bits are masked. - 1: LSb[0] is masked - 2: Two LSbs [1:0] are masked - .. - 31: All bits except MSb are masked. IPv6 Packets: Bits[12:11] of this field correspond to Bits[6:5] of L3HSBM0 which indicate the number of lower bits of IP Source or Destination Address that are masked in the IPv6 packets. The following list describes the concatenated values of the L3HDBM0[1:0] and L3HSBM0 bits: - 0: No bits are masked. - 1: LSb[0] is masked. - 2: Two LSbs [1:0] are masked - .. - 127: All bits except MSb are masked. This field is valid and applicable only when the L3DAM0 or L3SAM0 bit is set. */
    vuint32_t L4PEN7:1;                /* Layer 4 Protocol Enable When this bit is set, the Source and Destination Port number fields of UDP packets are used for matching. When this bit is reset, the Source and Destination Port number fields of TCP packets are used for matching. The Layer 4 matching is done only when the L4SPM0 or L4DPM0 bit is set. */
    vuint32_t _unused_17:1;            /* Reserved. */
    vuint32_t L4SPM7:1;                /* Layer 4 Source Port Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Source Port number field for matching. */
    vuint32_t L4SPIM7:1;               /* Layer 4 Source Port Inverse Match Enable When this bit is set, the Layer 4 Source Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Source Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4SPM0 bit is set high. */
    vuint32_t L4DPM7:1;                /* Layer 4 Destination Port Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for matching. When this bit is reset, the MAC ignores the Layer 4 Destination Port number field for matching. */
    vuint32_t L4DPIM7:1;               /* Layer 4 Destination Port Inverse Match Enable When this bit is set, the Layer 4 Destination Port number field is enabled for inverse matching. When this bit is reset, the Layer 4 Destination Port number field is enabled for perfect matching. This bit is valid and applicable only when the L4DPM0 bit is set high. */
    vuint32_t _unused_22:2;            /* Reserved. */
    vuint32_t DMCHN7:3;                /* DMA Channel Number When DMCHEN is set high, this field selects the DMA Channel number to which the packet passed by this filter is routed. The width of this field depends on the number of the DMA channels present in your configuration. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t DMCHEN7:1;               /* DMA Channel Select Enable When set, this bit enables the selection of the DMA channel number for the packet that is passed by this L3_L4 filter. The DMA channel is indicated by the DMCHN bits. When this bit is reset, the DMA channel is not decided by this filter. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MAC_L3_L4_CONTROL7_tag;

typedef union GMAC_MAC_LAYER4_ADDRESS7_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L4SP7:16;                /* Layer 4 Source Port Number Field When the L4PEN0 bit is reset and the L4SPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Source Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4SPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Source Port Number field in the IPv4 or IPv6 packets. */
    vuint32_t L4DP7:16;                /* Layer 4 Destination Port Number Field When the L4PEN0 bit is reset and the L4DPM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the TCP Destination Port Number field in the IPv4 or IPv6 packets. When the L4PEN0 and L4DPM0 bits are set in MAC_L3_L4_Control0 register, this field contains the value to be matched with the UDP Destination Port Number field in the IPv4 or IPv6 packets. */
  } B;
} GMAC_MAC_LAYER4_ADDRESS7_tag;

typedef union GMAC_MAC_LAYER3_ADDR0_REG7_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A07:32;                /* Layer 3 Address 0 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[31:0] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Source Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR0_REG7_tag;

typedef union GMAC_MAC_LAYER3_ADDR1_REG7_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A17:32;                /* Layer 3 Address 1 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[63:32] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset and the L3SAM0 bit is set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with the IP Destination Address field in the IPv4 packets. */
  } B;
} GMAC_MAC_LAYER3_ADDR1_REG7_tag;

typedef union GMAC_MAC_LAYER3_ADDR2_REG7_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A27:32;                /* Layer 3 Address 2 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[95:64] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR2_REG7_tag;

typedef union GMAC_MAC_LAYER3_ADDR3_REG7_union_tag {
  vuint32_t R;
  struct {
    vuint32_t L3A37:32;                /* Layer 3 Address 3 Field When the L3PEN0 and L3SAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Source Address field in the IPv6 packets. When the L3PEN0 and L3DAM0 bits are set in the MAC_L3_L4_Control0 register, this field contains the value to be matched with Bits[127:96] of the IP Destination Address field in the IPv6 packets. When the L3PEN0 bit is reset in the MAC_L3_L4_Control0 register, this field is not used. */
  } B;
} GMAC_MAC_LAYER3_ADDR3_REG7_tag;

typedef union GMAC_MAC_TIMESTAMP_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSENA:1;                 /* Enable Timestamp When this bit is set, the timestamp is added for Transmit and Receive packets. When disabled, timestamp is not added for transmit and receive packets and the Timestamp Generator is also suspended. You need to initialize the Timestamp (system time) after enabling this mode. On the Receive side, the MAC processes the IEEE 1588 packets only if this bit is set. */
    vuint32_t TSCFUPDT:1;              /* Fine or Coarse Timestamp Update When this bit is set, the Fine method is used to update system timestamp. When this bit is reset, Coarse method is used to update the system timestamp. */
    vuint32_t TSINIT:1;                /* Initialize Timestamp When this bit is set, the system time is initialized (overwritten) with the value specified in the MAC_System_Time_Seconds_Update and MAC_System_Time_Nanoseconds_Update registers. This bit should be zero before it is updated. This bit is reset when the initialization is complete. The Timestamp Higher Word register (if enabled during core configuration) can only be initialized. When Media Clock Generation and Recovery is configured (DWC_EQOS_FLEXI_PPS_OUT_EN) and enabled MAC_Presn_Time_Updt should also be updated before setting this field. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TSUPDT:1;                /* Update Timestamp When this bit is set, the system time is updated (added or subtracted) with the value specified in MAC_System_Time_Seconds_Update and MAC_System_Time_Nanoseconds_Update registers. This bit should be zero before updating it. This bit is reset when the update is complete in hardware. The Timestamp Higher Word register (if enabled during core configuration) is not updated. When Media Clock Generation and Recovery is configured (DWC_EQOS_FLEXI_PPS_OUT_EN) and enabled MAC_Presn_Time_Updt should also be updated before setting this field. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t _unused_4:1;             /* Reserved. */
    vuint32_t TSADDREG:1;              /* Update Addend Register When this bit is set, the content of the Timestamp Addend register is updated in the PTP block for fine correction. This bit is cleared when the update is complete. This bit should be zero before it is set. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t PTGE:1;                  /* Presentation Time Generation Enable When this bit is set the Presentation Time generation will be enabled. */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t TSENALL:1;               /* Enable Timestamp for All Packets When this bit is set, the timestamp snapshot is enabled for all packets received by the MAC. */
    vuint32_t TSCTRLSSR:1;             /* Timestamp Digital or Binary Rollover Control When this bit is set, the Timestamp Low register rolls over after 0x3B9A_C9FF value (that is, 1 nanosecond accuracy) and increments the timestamp (High) seconds. When this bit is reset, the rollover value of sub-second register is 0x7FFF_FFFF. The sub-second increment must be programmed correctly depending on the PTP reference clock frequency and the value of this bit. */
    vuint32_t TSVER2ENA:1;             /* Enable PTP Packet Processing for Version 2 Format When this bit is set, the IEEE 1588 version 2 format is used to process the PTP packets. When this bit is reset, the IEEE 1588 version 1 format is used to process the PTP packets. The IEEE 1588 formats are described in 'PTP Processing and Control'. */
    vuint32_t TSIPENA:1;               /* Enable Processing of PTP over Ethernet Packets When this bit is set, the MAC receiver processes the PTP packets encapsulated directly in the Ethernet packets. When this bit is reset, the MAC ignores the PTP over Ethernet packets. */
    vuint32_t TSIPV6ENA:1;             /* Enable Processing of PTP Packets Sent over IPv6-UDP When this bit is set, the MAC receiver processes the PTP packets encapsulated in IPv6-UDP packets. When this bit is clear, the MAC ignores the PTP transported over IPv6-UDP packets. */
    vuint32_t TSIPV4ENA:1;             /* Enable Processing of PTP Packets Sent over IPv4-UDP When this bit is set, the MAC receiver processes the PTP packets encapsulated in IPv4-UDP packets. When this bit is reset, the MAC ignores the PTP transported over IPv4-UDP packets. This bit is set by default. */
    vuint32_t TSEVNTENA:1;             /* Enable Timestamp Snapshot for Event Messages When this bit is set, the timestamp snapshot is taken only for event messages (SYNC, Delay_Req, Pdelay_Req, or Pdelay_Resp). When this bit is reset, the snapshot is taken for all messages except Announce, Management, and Signaling. For more information about the timestamp snapshots, see Timestamp Snapshot Dependency on Register Bits Table. */
    vuint32_t TSMSTRENA:1;             /* Enable Snapshot for Messages Relevant to Master When this bit is set, the snapshot is taken only for the messages that are relevant to the master node. Otherwise, the snapshot is taken for the messages relevant to the slave node. */
    vuint32_t SNAPTYPSEL:2;            /* Select PTP packets for Taking Snapshots These bits, along with Bits 15 and 14, decide the set of PTP packet types for which snapshot needs to be taken. The encoding is given in Timestamp Snapshot Dependency on Register Bits Table. */
    vuint32_t TSENMACADDR:1;           /* Enable MAC Address for PTP Packet Filtering When this bit is set, the DA MAC address (that matches any MAC Address register) is used to filter the PTP packets when PTP is directly sent over Ethernet. When this bit is set, received PTP packets with DA containing a special multicast or unicast address that matches the one programmed in MAC address registers are considered for processing as indicated below, when PTP is directly sent over Ethernet. For normal time stamping operation, MAC address registers 0 to 31 is considered for unicast destination address matching. For PTP offload, only MAC address register 0 is considered for unicast destination address matching. */
    vuint32_t CSC:1;                   /* Enable checksum correction during OST for PTP over UDP/IPv4 packets When this bit is set, the last two bytes of PTP message sent over UDP/IPv4 is updated to keep the UDP checksum correct, for changes made to origin timestamp and/or correction field as part of one step timestamp operation. The application shall form the packet with these two dummy bytes. When reset, no updates are done to keep the UDP checksum correct. The application shall form the packet with UDP checksum set to 0. */
    vuint32_t ESTI:1;                  /* External System Time Input When this bit is set, the MAC uses the external 64-bit reference System Time input for the following: - To take the timestamp provided as status - To insert the timestamp in transmit PTP packets when One-step Timestamp or Timestamp Offload feature is enabled. When this bit is reset, the MAC uses the internal reference System Time. */
    vuint32_t _unused_21:3;            /* Reserved. */
    vuint32_t TXTSSTSM:1;              /* Transmit Timestamp Status Mode When this bit is set, the MAC overwrites the earlier transmit timestamp status even if it is not read by the software. The MAC indicates this by setting the TXTSSMIS bit of the MAC_Tx_Timestamp_Status_Nanoseconds register. When this bit is reset, the MAC ignores the timestamp status of current packet if the timestamp status of previous packet is not read by the software. The MAC indicates this by setting the TXTSSMIS bit of the MAC_Tx_Timestamp_Status_Nanoseconds register. */
    vuint32_t _unused_25:3;            /* Reserved. */
    vuint32_t AV8021ASMEN:1;           /* AV 802.1AS Mode Enable When this bit is set, the MAC processes only untagged PTP over Ethernet packets for providing PTP status and capturing timestamp snapshots, that is, IEEE 802.1AS mode of operation. When PTP offload feature is enabled, for the purpose of PTP offload, the transport specific field in the PTP header is generated and checked based on the value of this bit. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MAC_TIMESTAMP_CONTROL_tag;

typedef union GMAC_MAC_SUB_SECOND_INCREMENT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;             /* Reserved. */
    vuint32_t SNSINC:8;                /* Sub-nanosecond Increment Value This field contains the sub-nanosecond increment value, represented in nanoseconds multiplied by 2^8. This value is accumulated with the sub-nanoseconds field of the subsecond register. For example, when TSCTRLSSR field in the MAC_Timestamp_Control register is set. and if the required increment is 5.3ns, then SSINC should be 0x05 and SNSINC should be 0x4C. */
    vuint32_t SSINC:8;                 /* Sub-second Increment Value The value programmed in this field is accumulated every clock cycle (of clk_ptp_i) with the contents of the sub-second register. For example, when the PTP clock is 50 MHz (period is 20 ns), you should program 20 (0x14) when the System Time Nanoseconds register has an accuracy of 1 ns [Bit 9 (TSCTRLSSR) is set in MAC_Timestamp_Control]. When TSCTRLSSR is clear, the Nanoseconds register has a resolution of ~0.465 ns. In this case, you should program a value of 43 (0x2B) which is derived by 20 ns/0.465. */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} GMAC_MAC_SUB_SECOND_INCREMENT_tag;

typedef union GMAC_MAC_SYSTEM_TIME_SECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSS:32;                  /* Timestamp Second The value in this field indicates the current value in seconds of the System Time maintained by the MAC. */
  } B;
} GMAC_MAC_SYSTEM_TIME_SECONDS_tag;

typedef union GMAC_MAC_SYSTEM_TIME_NANOSECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSSS:31;                 /* Timestamp Sub Seconds The value in this field has the sub-second representation of time, with an accuracy of 0.46 ns. When Bit 9 is set in MAC_Timestamp_Control, each bit represents 1 ns. The maximum value is 0x3B9A_C9FF after which it rolls-over to zero. */
    vuint32_t _unused_31:1;            /* Reserved. */
  } B;
} GMAC_MAC_SYSTEM_TIME_NANOSECONDS_tag;

typedef union GMAC_MAC_SYSTEM_TIME_SECONDS_UPDATE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSS:32;                  /* Timestamp Seconds The value in this field is the seconds part of the update. When ADDSUB is reset, this field must be programmed with the seconds part of the update value. When ADDSUB is set, this field must be programmed with the complement of the seconds part of the update value. For example, if 2.000000001 seconds need to be subtracted from the system time, the TSS field in the MAC_Timestamp_Seconds_Update register must be 0xFFFF_FFFE (that is, 2^32 - 2). */
  } B;
} GMAC_MAC_SYSTEM_TIME_SECONDS_UPDATE_tag;

typedef union GMAC_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSSS:31;                 /* Timestamp Sub Seconds The value in this field is the sub-seconds part of the update. When ADDSUB is reset, this field must be programmed with the sub-seconds part of the update value, with an accuracy based on the TSCTRLSSR bit of the MAC_Timestamp_Control register. When ADDSUB is set, this field must be programmed with the complement of the sub-seconds part of the update value as described below. When TSCTRLSSR bit in MAC_Timestamp_Control is set, the programmed value must be 10^9 - <sub-second value>. When TSCTRLSSR bit in MAC_Timestamp_Control is reset, the programmed value must be 2^31 - <sub-second_value>. When the TSCTRLSSR bit is reset in the MAC_Timestamp_Control register, each bit represents an accuracy of 0.46 ns. When the TSCTRLSSR bit is set in the MAC_Timestamp_Control register, each bit represents 1 ns and the programmed value should not exceed 0x3B9A_C9FF. For example, if 2.000000001 seconds need to be subtracted from the system time, then the TSSS field in the MAC_Timestamp_Nanoseconds_Update register must be 0x7FFF_FFFF (that is, 2^31 - 1), when TSCTRLSSR bit in MAC_Timestamp_Control is reset and 0x3B9A_C9FF (that is, 10^9 - 1), when TSCTRLSSR bit in MAC_Timestamp_Control is set. */
    vuint32_t ADDSUB:1;                /* Add or Subtract Time When this bit is set, the time value is subtracted with the contents of the update register. When this bit is reset, the time value is added with the contents of the update register. */
  } B;
} GMAC_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE_tag;

typedef union GMAC_MAC_TIMESTAMP_ADDEND_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSAR:32;                 /* Timestamp Addend Register This field indicates the 32-bit time value to be added to the Accumulator register to achieve time synchronization. */
  } B;
} GMAC_MAC_TIMESTAMP_ADDEND_tag;

typedef union GMAC_MAC_SYSTEM_TIME_HIGHER_WORD_SECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSHWR:16;                /* Timestamp Higher Word Register This field contains the most-significant 16-bits of timestamp seconds value. This register is optional. You can add this register by selecting the Add IEEE 1588 Higher Word Register option. This register is directly written to initialize the value and it is incremented when there is an overflow from 32-bits of the System Time Seconds register. Access restriction applies. Updated based on the event. Setting 1 sets. Setting 0 clears. */
    vuint32_t _unused_16:16;           /* Reserved. */
  } B;
} GMAC_MAC_SYSTEM_TIME_HIGHER_WORD_SECONDS_tag;

typedef union GMAC_MAC_TIMESTAMP_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSSOVF:1;                /* Timestamp Seconds Overflow When this bit is set, it indicates that the seconds value of the timestamp (when supporting version 2 format) has overflowed beyond 32'hFFFF_FFFF. Access restriction applies. Clears on read (or this bit is written to 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t TSTARGT0:1;              /* Timestamp Target Time Reached When set, this bit indicates that the value of system time is greater than or equal to the value specified in the MAC_PPS0_Target_Time_Seconds and MAC_PPS0_Target_Time_Nanoseconds registers. Access restriction applies. Clears on read (or this bit is written to 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t AUXTSTRIG:1;             /* Auxiliary Timestamp Trigger Snapshot This bit is set high when the auxiliary snapshot is written to the FIFO. This bit is valid only if the Add IEEE 1588 Auxiliary Snapshot option is selected. Access restriction applies. Clears on read (or this bit is written to 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t TSTRGTERR0:1;            /* Timestamp Target Time Error This bit is set when the latest target time programmed in the MAC_PPS0_Target_Time_Seconds and MAC_PPS0_Target_Time_Nanoseconds registers elapses. This bit is cleared when the application reads this bit. Access restriction applies. Clears on read (or this bit is written to 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t TSTARGT1:1;              /* Timestamp Target Time Reached for Target Time PPS1 When set, this bit indicates that the value of system time is greater than or equal to the value specified in the MAC_PPS1_Target_Time_Seconds and MAC_PPS1_Target_Time_Nanoseconds registers. Access restriction applies. Clears on read (or this bit is written to 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t TSTRGTERR1:1;            /* Timestamp Target Time Error This bit is set when the latest target time programmed in the MAC_PPS1_Target_Time_Seconds and MAC_PPS1_Target_Time_Nanoseconds registers elapses. This bit is cleared when the application reads this bit. Access restriction applies. Clears on read (or this bit is written to 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t TSTARGT2:1;              /* Timestamp Target Time Reached for Target Time PPS2 When set, this bit indicates that the value of system time is greater than or equal to the value specified in the MAC_PPS2_Target_Time_Seconds and MAC_PPS2_Target_Time_Nanoseconds registers. Access restriction applies. Clears on read (or this bit is written to 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t TSTRGTERR2:1;            /* Timestamp Target Time Error This bit is set when the latest target time programmed in the MAC_PPS2_Target_Time_Seconds and MAC_PPS2_Target_Time_Nanoseconds registers elapses. This bit is cleared when the application reads this bit. Access restriction applies. Clears on read (or this bit is written to 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t TSTARGT3:1;              /* Timestamp Target Time Reached for Target Time PPS3 When this bit is set, it indicates that the value of system time is greater than or equal to the value specified in the MAC_PPS3_Target_Time_Seconds and MAC_PPS3_Target_Time_Nanoseconds registers. Access restriction applies. Clears on read (or this bit is written to 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t TSTRGTERR3:1;            /* Timestamp Target Time Error This bit is set when the latest target time programmed in the MAC_PPS3_Target_Time_Seconds and MAC_PPS3_Target_Time_Nanoseconds registers elapses. This bit is cleared when the application reads this bit. Access restriction applies. Clears on read (or this bit is written to 1 when RCWE bit in MAC_CSR_SW_Ctrl register is set). Self-set to 1 on internal event. */
    vuint32_t _unused_10:5;            /* Reserved. */
    vuint32_t TXTSSIS:1;               /* Tx Timestamp Status Interrupt Status In non-EQOS_CORE configurations when drop transmit status is enabled in MTL, this bit is set when the captured transmit timestamp is updated in the MAC_Tx_Timestamp_Status_Nanoseconds and MAC_Tx_Timestamp_Status_Seconds registers. When PTP offload feature is enabled, this bit is set when the captured transmit timestamp is updated in the MAC_Tx_Timestamp_Status_Nanoseconds and MAC_Tx_Timestamp_Status_Seconds registers, for PTO generated Delay Request and Pdelay request packets. This bit is cleared when the MAC_Tx_Timestamp_Status_Seconds register is read (or write to MAC_Tx_Timestamp_Status_Seconds register when RCWE bit of MAC_CSR_SW_Ctrl register is set). */
    vuint32_t ATSSTN:4;                /* Auxiliary Timestamp Snapshot Trigger Identifier These bits identify the Auxiliary trigger inputs for which the timestamp available in the Auxiliary Snapshot Register is applicable. When more than one bit is set at the same time, it means that corresponding auxiliary triggers were sampled at the same clock. These bits are applicable only if the number of Auxiliary snapshots is more than one. One bit is assigned for each trigger as shown in the following list: - Bit 16: Auxiliary trigger 0 - Bit 17: Auxiliary trigger 1 - Bit 18: Auxiliary trigger 2 - Bit 19: Auxiliary trigger 3 The software can read this register to find the triggers that are set when the timestamp is taken. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_20:4;            /* Reserved. */
    vuint32_t ATSSTM:1;                /* Auxiliary Timestamp Snapshot Trigger Missed This bit is set when the Auxiliary timestamp snapshot FIFO is full and external trigger was set. This indicates that the latest snapshot is not stored in the FIFO. This bit is valid only if the Add IEEE 1588 Auxiliary Snapshot option is selected. */
    vuint32_t ATSNS:5;                 /* Number of Auxiliary Timestamp Snapshots This field indicates the number of Snapshots available in the FIFO. A value equal to the selected depth of FIFO (4, 8, or 16) indicates that the Auxiliary Snapshot FIFO is full. These bits are cleared (to 00000) when the Auxiliary snapshot FIFO clear bit is set. This bit is valid only if the Add IEEE 1588 Auxiliary Snapshot option is selected. */
    vuint32_t _unused_30:2;            /* Reserved. */
  } B;
} GMAC_MAC_TIMESTAMP_STATUS_tag;

typedef union GMAC_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXTSSLO:31;              /* Transmit Timestamp Status Low This field contains the 31 bits of the Nanoseconds field of the Transmit packet's captured timestamp. */
    vuint32_t TXTSSMIS:1;              /* Transmit Timestamp Status Missed When this bit is set, it indicates one of the following: - The timestamp of the current packet is ignored if TXTSSTSM bit of the MAC_Timestamp_Control register is reset - The timestamp of the previous packet is overwritten with timestamp of the current packet if TXTSSTSM bit of the MAC_Timestamp_Control register is set. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
  } B;
} GMAC_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_tag;

typedef union GMAC_MAC_TX_TIMESTAMP_STATUS_SECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXTSSHI:32;              /* Transmit Timestamp Status High This field contains the lower 32 bits of the Seconds field of Transmit packet's captured timestamp. */
  } B;
} GMAC_MAC_TX_TIMESTAMP_STATUS_SECONDS_tag;

typedef union GMAC_MAC_AUXILIARY_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ATSFC:1;                 /* Auxiliary Snapshot FIFO Clear When set, this bit resets the pointers of the Auxiliary Snapshot FIFO. This bit is cleared when the pointers are reset and the FIFO is empty. When this bit is high, the auxiliary snapshots are stored in the FIFO. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t _unused_1:3;             /* Reserved. */
    vuint32_t ATSEN0:1;                /* Auxiliary Snapshot 0 Enable This bit controls the capturing of Auxiliary Snapshot Trigger 0. When this bit is set, the auxiliary snapshot of the event on ptp_aux_trig_i[0] input is enabled. When this bit is reset, the events on this input are ignored. */
    vuint32_t ATSEN1:1;                /* Auxiliary Snapshot 1 Enable This bit controls the capturing of Auxiliary Snapshot Trigger 1. When this bit is set, the auxiliary snapshot of the event on ptp_aux_trig_i[1] input is enabled. When this bit is reset, the events on this input are ignored. */
    vuint32_t ATSEN2:1;                /* Auxiliary Snapshot 2 Enable This bit controls the capturing of Auxiliary Snapshot Trigger 2. When this bit is set, the auxiliary snapshot of the event on ptp_aux_trig_i[2] input is enabled. When this bit is reset, the events on this input are ignored. */
    vuint32_t ATSEN3:1;                /* Auxiliary Snapshot 3 Enable This bit controls the capturing of Auxiliary Snapshot Trigger 3. When this bit is set, the auxiliary snapshot of the event on ptp_aux_trig_i[3] input is enabled. When this bit is reset, the events on this input are ignored. */
    vuint32_t _unused_8:24;            /* Reserved. */
  } B;
} GMAC_MAC_AUXILIARY_CONTROL_tag;

typedef union GMAC_MAC_AUXILIARY_TIMESTAMP_NANOSECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t AUXTSLO:31;              /* Auxiliary Timestamp Contains the lower 31 bits (nanoseconds field) of the auxiliary timestamp. */
    vuint32_t _unused_31:1;            /* Reserved. */
  } B;
} GMAC_MAC_AUXILIARY_TIMESTAMP_NANOSECONDS_tag;

typedef union GMAC_MAC_AUXILIARY_TIMESTAMP_SECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t AUXTSHI:32;              /* Auxiliary Timestamp Contains the lower 32 bits of the Seconds field of the auxiliary timestamp. */
  } B;
} GMAC_MAC_AUXILIARY_TIMESTAMP_SECONDS_tag;

typedef union GMAC_MAC_TIMESTAMP_INGRESS_ASYM_CORR_union_tag {
  vuint32_t R;
  struct {
    vuint32_t OSTIAC:32;               /* One-Step Timestamp Ingress Asymmetry Correction This field contains the ingress path asymmetry value to be added to correctionField of Pdelay_Resp PTP packet. The programmed value should be in units of nanoseconds and multiplied by 2^16. For example, 2.5 ns is represented as 0x00028000. The value can also be negative, which is represented in 2's complement form with bit 31 representing the sign bit. */
  } B;
} GMAC_MAC_TIMESTAMP_INGRESS_ASYM_CORR_tag;

typedef union GMAC_MAC_TIMESTAMP_EGRESS_ASYM_CORR_union_tag {
  vuint32_t R;
  struct {
    vuint32_t OSTEAC:32;               /* One-Step Timestamp Egress Asymmetry Correction This field contains the egress path asymmetry value to be subtracted from correctionField of Pdelay_Resp PTP packet. The programmed value must be the negated value in units of nanoseconds multiplied by 2^16. For example, if the required correction is +2.5 ns, the programmed value must be 0xFFFD_8000, which is the 2's complement of 0x0002_8000(2.5 * 216). Similarly, if the required correction is -3.3 ns, the programmed value is 0x0003_4CCC (3.3 * 216). */
  } B;
} GMAC_MAC_TIMESTAMP_EGRESS_ASYM_CORR_tag;

typedef union GMAC_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSIC:32;                 /* Timestamp Ingress Correction This field contains the ingress path correction value as defined by the Ingress Correction expression. */
  } B;
} GMAC_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND_tag;

typedef union GMAC_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSEC:32;                 /* Timestamp Egress Correction This field contains the nanoseconds part of the egress path correction value as defined by the Egress Correction expression. */
  } B;
} GMAC_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND_tag;

typedef union GMAC_MAC_TIMESTAMP_INGRESS_CORR_SUBNANOSEC_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;             /* Reserved. */
    vuint32_t TSICSNS:8;               /* Timestamp Ingress Correction, sub-nanoseconds This field contains the sub-nanoseconds part of the ingress path correction value as defined by the "Ingress Correction" expression. */
    vuint32_t _unused_16:16;           /* Reserved. */
  } B;
} GMAC_MAC_TIMESTAMP_INGRESS_CORR_SUBNANOSEC_tag;

typedef union GMAC_MAC_TIMESTAMP_EGRESS_CORR_SUBNANOSEC_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;             /* Reserved. */
    vuint32_t TSECSNS:8;               /* Timestamp Egress Correction, sub-nanoseconds This field contains the sub-nanoseconds part of the egress path correction value as defined by the "Egress Correction" expression. */
    vuint32_t _unused_16:16;           /* Reserved. */
  } B;
} GMAC_MAC_TIMESTAMP_EGRESS_CORR_SUBNANOSEC_tag;

typedef union GMAC_MAC_TIMESTAMP_INGRESS_LATENCY_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;             /* Reserved. */
    vuint32_t ITLSNS:8;                /* Ingress Timestamp Latency, in nanoseconds This register holds the average latency in nanoseconds between the input ports (phy_rxd_i) of MAC and the actual point (GMII/MII) where the ingress timestamp is taken. Ingress correction value is computed as described in the section 7.1.2.4.1 of QoS Databook. */
    vuint32_t ITLNS:12;                /* Ingress Timestamp Latency, in sub-nanoseconds This register holds the average latency in sub-nanoseconds between the input ports (phy_rxd_i) of MAC and the actual point (GMII/MII) where the ingress timestamp is taken. Ingress correction value is computed as described in the section 7.1.2.4.1 of QoS Databook. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_MAC_TIMESTAMP_INGRESS_LATENCY_tag;

typedef union GMAC_MAC_TIMESTAMP_EGRESS_LATENCY_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:8;             /* Reserved. */
    vuint32_t ETLSNS:8;                /* Egress Timestamp Latency, in sub-nanoseconds This register holds the average latency in sub-nanoseconds between the actual point (GMII/MII) where the egress timestamp is taken and the output ports (phy_txd_o) of the MAC. Ingress correction value is computed as described in the section 7.1.2.4.2 of QoS Databook. */
    vuint32_t ETLNS:12;                /* Egress Timestamp Latency, in nanoseconds This register holds the average latency in nanoseconds between the actual point (GMII/MII) where the egress timestamp is taken and the output ports (phy_txd_o) of the MAC. Ingress correction value is computed as described in the section 7.1.2.4.2 of QoS Databook. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_MAC_TIMESTAMP_EGRESS_LATENCY_tag;

typedef union GMAC_MAC_PPS_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PPSCTRL_PPSCMD:4;        /* PPS Output Frequency Control This field controls the frequency of the PPS0 output (ptp_pps_o[0]) signal. The default value of PPSCTRL is 0000, and the PPS output is 1 pulse (of width clk_ptp_i) every second. For other values of PPSCTRL, the PPS output becomes a generated clock of following frequencies: - 0001: The binary rollover is 2 Hz, and the digital rollover is 1 Hz. - 0010: The binary rollover is 4 Hz, and the digital rollover is 2 Hz. - 0011: The binary rollover is 8 Hz, and the digital rollover is 4 Hz. - 0100: The binary rollover is 16 Hz, and the digital rollover is 8 Hz. - .. - 1111: The binary rollover is 32.768 kHz and the digital rollover is 16.384 kHz. In the binary rollover mode, the PPS output (ptp_pps_o) has a duty cycle of 50 percent with these frequencies. In the digital rollover mode, the PPS output frequency is an average number. The actual clock is of different frequency that gets synchronized every second. For example: - When PPSCTRL = 0001, the PPS (1 Hz) has a low period of 537 ms and a high period of 463 ms - When PPSCTRL = 0010, the PPS (2 Hz) is a sequence of One clock of 50 percent duty cycle and 537 ms period Second clock of 463 ms period (268 ms low and 195 ms high) - When PPSCTRL = 0011, the PPS (4 Hz) is a sequence of Three clocks of 50 percent duty cycle and 268 ms period Fourth clock of 195 ms period (134 ms low and 61 ms high) This behavior is because of the non-linear toggling of bits in the digital rollover mode in the MAC_System_Time_Nanoseconds register. or Flexible PPS Output (ptp_pps_o[0]) Control Programming these bits with a non-zero value instructs the MAC to initiate an event. When the command is transferred or synchronized to the PTP clock domain, these bits get cleared automatically. The software should ensure that these bits are programmed only when they are 'all-zero'. The following list describes the values of PPSCMD0: - 0000: No Command - 0001: START Single Pulse This command generates single pulse rising at the start point defined in MAC_PPS0_Target_Time_Seconds and MAC_PPS0_Target_Time_Nanoseconds register and of a duration defined in the PPS0 Width Register. - 0010: START Pulse Train This command generates the train of pulses rising at the start point defined in the Target Time Registers and of a duration defined in the PPS0 Width Register and repeated at interval defined in the PPS Interval Register. By default, the PPS pulse train is free-running unless stopped by the 'Stop Pulse train at time' or 'Stop Pulse Train immediately' commands. - 0011: Cancel START This command cancels the START Single Pulse and START Pulse Train commands if the system time has not crossed the programmed start time. - 0100: STOP Pulse train at time This command stops the train of pulses initiated by the START Pulse Train command (PPSCMD = 0010) after the time programmed in the Target Time registers elapses. - 0101: STOP Pulse Train immediately This command immediately stops the train of pulses initiated by the START Pulse Train command (PPSCMD = 0010). - 110: Cancel STOP Pulse train This command cancels the STOP pulse train at time command if the programmed stop time has not elapsed. The PPS pulse train becomes free-running on the successful execution of this command. - 0111-1111: Reserved or Presentation Time Control If MCGREN0 is set then these bits are treated as Presentation time control bits. The following list describes the values of PPSCMD0: - 0000: No Operation related to MCGR will be carried out. If set to this value in the mid of clock recovery or generation all the processing inputs will be flushed. - 0001: Capture the Presentation time at rising edge of mcg_pst_trig_i[0] into the MAC_PPS0_Target_Time_Seconds register - 0010: Capture the Presentation time at falling edge of mcg_pst_trig_i[0] into the MAC_PPS0_Target_Time_Seconds register - 0011: Capture the Presentation time at both edges of mcg_pst_trig_i[0] into the MAC_PPS0_Target_Time_Seconds register - 0100-1000: Reserved - 1001: Toggle output on compare - 1010: Pulse output low on compare for one PTP-clock cycle - 1011: Pulse output high on compare for one PTP-clock cycle - 1100-1111: Reserved */
    vuint32_t PPSEN0:1;                /* Flexible PPS Output Mode Enable When this bit is set, Bits[3:0] function as PPSCMD. When this bit is reset, Bits[3:0] function as PPSCTRL (Fixed PPS mode). */
    vuint32_t TRGTMODSEL0:2;           /* Target Time Register Mode for PPS0 Output This field indicates the Target Time registers (MAC_PPS0_Target_Time_Seconds and MAC_PPS0_Target_Time_Nanoseconds) mode for PPS0 output signal: */
    vuint32_t MCGREN0:1;               /* MCGR Mode Enable for PPS0 Output This field enables the 0th PPS instance to operate in PPS or MCGR mode. When set it operates in MCGR mode and on reset it operates in PPS mode. */
    vuint32_t PPSCMD1:4;               /* Flexible PPS1 Output Control This field controls the flexible PPS1 output (ptp_pps_o[1]) signal. This field is similar to the PPSCMD0 field. If MCGREN1 is set, then PPSCMD1 indicated by these 4 bits [11:8] are taken as Presentation Time Control bits for media clock generation and recovery for comparator instance 1. This field is similar to the PPSCMD0 Presentation Time Control bits. If MCGREN1 is not set then only 3 bits from [10:8] is used as PPSCMD1 and the 4th bit is to be set as 0. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t _unused_12:1;            /* Reserved. */
    vuint32_t TRGTMODSEL1:2;           /* Target Time Register Mode for PPS1 Output This field indicates the Target Time registers (MAC_PPS1_Target_Time_Seconds and MAC_PPS1_Target_Time_Nanoseconds) mode for PPS1 output signal. */
    vuint32_t MCGREN1:1;               /* MCGR Mode Enable for PPS1 Output This field enables the 1st PPS instance to operate in PPS or MCGR mode. When set it operates in MCGR mode and on reset it operates in PPS mode. */
    vuint32_t PPSCMD2:4;               /* Flexible PPS2 Output Control This field controls the flexible PPS2 output (ptp_pps_o[2]) signal. This field is similar to the PPSCMD0 field. If MCGREN2 is set, then PPSCMD2 indicated by these 4 bits [19:16] are taken as Presentation Time Control bits for media clock generation and recovery for comparator instance 2. This field is similar to the PPSCMD0 Presentation Time Control bits. If MCGREN2 is not set then only 3 bits from [18:16] is used as PPSCMD2 and the 4th bit is to be set as 0. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t _unused_20:1;            /* Reserved. */
    vuint32_t TRGTMODSEL2:2;           /* Target Time Register Mode for PPS2 Output This field indicates the Target Time registers (MAC_PPS2_Target_Time_Seconds and MAC_PPS2_Target_Time_Nanoseconds) mode for PPS2 output signal. */
    vuint32_t MCGREN2:1;               /* MCGR Mode Enable for PPS2 Output This field enables the 2nd PPS instance to operate in PPS or MCGR mode. When set it operates in MCGR mode and on reset it operates in PPS mode. */
    vuint32_t PPSCMD3:4;               /* Flexible PPS3 Output Control This field controls the flexible PPS3 output (ptp_pps_o[3]) signal. This field is similar to the PPSCMD0[2:0] field. If MCGREN3 is set, then PPSCMD3 indicated by these 4 bits [27:24] are taken as Presentation Time Control bits for media clock generation and recovery for comparator instance 3. This field is similar to the PPSCMD0 Presentation Time Control bits. If MCGREN3 is not set then only 3 bits from [26:24] is used as PPSCMD3 and the 4th bit is to be set as 0. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t _unused_28:1;            /* Reserved. */
    vuint32_t TRGTMODSEL3:2;           /* Target Time Register Mode for PPS3 Output This field indicates the Target Time registers (MAC_PPS3_Target_Time_Seconds and MAC_PPS3_Target_Time_Nanoseconds) mode for PPS3 output signal. */
    vuint32_t MCGREN3:1;               /* MCGR Mode Enable for PPS3 Output This field enables the 3rd PPS instance to operate in PPS or MCGR mode. When set it operates in MCGR mode and on reset it operates in PPS mode. */
  } B;
} GMAC_MAC_PPS_CONTROL_tag;

typedef union GMAC_MAC_PPS0_TARGET_TIME_SECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSTRH0:32;               /* PPS Target Time Seconds Register This field stores the time in seconds. When the timestamp value matches or exceeds both Target Timestamp registers, the MAC starts or stops the PPS signal output and generates an interrupt (if enabled) based on Target Time mode selected for the corresponding PPS output in the MAC_PPS_Control register. If DWC_EQOS_FLEXI_PPS_OUT_EN is enabled in the configuration and PTGE field of MAC_Timestamp_Control Register is set with Presentation time control set in recovery mode, then these bits indicate the TPT being programmed by the application and in generation mode it indicates the CPT generated at the sampled trigger. */
  } B;
} GMAC_MAC_PPS0_TARGET_TIME_SECONDS_tag;

typedef union GMAC_MAC_PPS0_TARGET_TIME_NANOSECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TTSL0:31;                /* Target Time Low for PPS Register This register stores the time in (signed) nanoseconds. When the value of the timestamp matches the value in both Target Timestamp registers, the MAC starts or stops the PPS signal output and generates an interrupt (if enabled) based on the TRGTMODSEL0 field (Bits [6:5]) in MAC_PPS_Control. When the TSCTRLSSR bit is reset in the MAC_Timestamp_Control register, this value should be (time in ns / 0.465). The actual start or stop time of the PPS signal output may have an error margin up to one unit of sub-second increment value. When the TSCTRLSSR bit is set in the MAC_Timestamp_Control register, this value should not exceed 0x3B9A_C9FF. The actual start or stop time of the PPS signal output may have an error margin up to one unit of sub-second increment value. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TRGTBUSY0:1;             /* PPS Target Time Register Busy The MAC sets this bit when the PPSCMD0 field in the MAC_PPS_Control register is programmed to 010 or 011. Programming the PPSCMD0 field to 010 or 011 instructs the MAC to synchronize the Target Time Registers to the PTP clock domain. The MAC clears this bit after synchronizing the Target Time Registers to the PTP clock domain The application must not update the Target Time Registers when this bit is read as 1. Otherwise, the synchronization of the previous programmed time gets corrupted. */
  } B;
} GMAC_MAC_PPS0_TARGET_TIME_NANOSECONDS_tag;

typedef union GMAC_MAC_PPS0_INTERVAL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PPSINT0:32;              /* PPS Output Signal Interval These bits store the interval between the rising edges of PPS0 signal output. The interval is stored in terms of number of units of sub-second increment value. You need to program one value less than the required interval. For example, if the PTP reference clock is 50 MHz (period of 20 ns), and desired interval between the rising edges of PPS0 signal output is 100 ns (that is, 5 units of sub-second increment value), you should program value 4 (5-1) in this register. */
  } B;
} GMAC_MAC_PPS0_INTERVAL_tag;

typedef union GMAC_MAC_PPS0_WIDTH_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PPSWIDTH0:32;            /* PPS Output Signal Width These bits store the width between the rising edge and corresponding falling edge of PPS0 signal output. The width is stored in terms of number of units of sub-second increment value. You need to program one value less than the required interval. For example, if PTP reference clock is 50 MHz (period of 20 ns), and width between the rising and corresponding falling edges of PPS0 signal output is 80 ns (that is, four units of sub-second increment value), you should program value 3 (4-1) in this register. Note: The value programmed in this register must be lesser than the value programmed in MAC_PPS0_Interval. */
  } B;
} GMAC_MAC_PPS0_WIDTH_tag;

typedef union GMAC_MAC_PPS1_TARGET_TIME_SECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSTRH1:32;               /* PPS Target Time Seconds Register This field stores the time in seconds. When the timestamp value matches or exceeds both Target Timestamp registers, the MAC starts or stops the PPS signal output and generates an interrupt (if enabled) based on Target Time mode selected for the corresponding PPS output in the MAC_PPS_Control register. If DWC_EQOS_FLEXI_PPS_OUT_EN is enabled in the configuration and PTGE field of MAC_Timestamp_Control Register is set with Presentation time control set in recovery mode, then these bits indicate the TPT being programmed by the application and in generation mode it indicates the CPT generated at the sampled trigger. */
  } B;
} GMAC_MAC_PPS1_TARGET_TIME_SECONDS_tag;

typedef union GMAC_MAC_PPS1_TARGET_TIME_NANOSECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TTSL1:31;                /* Target Time Low for PPS Register This register stores the time in (signed) nanoseconds. When the value of the timestamp matches the value in both Target Timestamp registers, the MAC starts or stops the PPS signal output and generates an interrupt (if enabled) based on the TRGTMODSEL0 field (Bits [6:5]) in MAC_PPS_Control. When the TSCTRLSSR bit is reset in the MAC_Timestamp_Control register, this value should be (time in ns / 0.465). The actual start or stop time of the PPS signal output may have an error margin up to one unit of sub-second increment value. When the TSCTRLSSR bit is set in the MAC_Timestamp_Control register, this value should not exceed 0x3B9A_C9FF. The actual start or stop time of the PPS signal output may have an error margin up to one unit of sub-second increment value. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TRGTBUSY1:1;             /* PPS Target Time Register Busy The MAC sets this bit when the PPSCMD0 field in the MAC_PPS_Control register is programmed to 010 or 011. Programming the PPSCMD0 field to 010 or 011 instructs the MAC to synchronize the Target Time Registers to the PTP clock domain. The MAC clears this bit after synchronizing the Target Time Registers to the PTP clock domain The application must not update the Target Time Registers when this bit is read as 1. Otherwise, the synchronization of the previous programmed time gets corrupted. */
  } B;
} GMAC_MAC_PPS1_TARGET_TIME_NANOSECONDS_tag;

typedef union GMAC_MAC_PPS1_INTERVAL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PPSINT1:32;              /* PPS Output Signal Interval These bits store the interval between the rising edges of PPS0 signal output. The interval is stored in terms of number of units of sub-second increment value. You need to program one value less than the required interval. For example, if the PTP reference clock is 50 MHz (period of 20 ns), and desired interval between the rising edges of PPS0 signal output is 100 ns (that is, 5 units of sub-second increment value), you should program value 4 (5-1) in this register. */
  } B;
} GMAC_MAC_PPS1_INTERVAL_tag;

typedef union GMAC_MAC_PPS1_WIDTH_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PPSWIDTH1:32;            /* PPS Output Signal Width These bits store the width between the rising edge and corresponding falling edge of PPS0 signal output. The width is stored in terms of number of units of sub-second increment value. You need to program one value less than the required interval. For example, if PTP reference clock is 50 MHz (period of 20 ns), and width between the rising and corresponding falling edges of PPS0 signal output is 80 ns (that is, four units of sub-second increment value), you should program value 3 (4-1) in this register. Note: The value programmed in this register must be lesser than the value programmed in MAC_PPS0_Interval. */
  } B;
} GMAC_MAC_PPS1_WIDTH_tag;

typedef union GMAC_MAC_PPS2_TARGET_TIME_SECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSTRH2:32;               /* PPS Target Time Seconds Register This field stores the time in seconds. When the timestamp value matches or exceeds both Target Timestamp registers, the MAC starts or stops the PPS signal output and generates an interrupt (if enabled) based on Target Time mode selected for the corresponding PPS output in the MAC_PPS_Control register. If DWC_EQOS_FLEXI_PPS_OUT_EN is enabled in the configuration and PTGE field of MAC_Timestamp_Control Register is set with Presentation time control set in recovery mode, then these bits indicate the TPT being programmed by the application and in generation mode it indicates the CPT generated at the sampled trigger. */
  } B;
} GMAC_MAC_PPS2_TARGET_TIME_SECONDS_tag;

typedef union GMAC_MAC_PPS2_TARGET_TIME_NANOSECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TTSL2:31;                /* Target Time Low for PPS Register This register stores the time in (signed) nanoseconds. When the value of the timestamp matches the value in both Target Timestamp registers, the MAC starts or stops the PPS signal output and generates an interrupt (if enabled) based on the TRGTMODSEL0 field (Bits [6:5]) in MAC_PPS_Control. When the TSCTRLSSR bit is reset in the MAC_Timestamp_Control register, this value should be (time in ns / 0.465). The actual start or stop time of the PPS signal output may have an error margin up to one unit of sub-second increment value. When the TSCTRLSSR bit is set in the MAC_Timestamp_Control register, this value should not exceed 0x3B9A_C9FF. The actual start or stop time of the PPS signal output may have an error margin up to one unit of sub-second increment value. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TRGTBUSY2:1;             /* PPS Target Time Register Busy The MAC sets this bit when the PPSCMD0 field in the MAC_PPS_Control register is programmed to 010 or 011. Programming the PPSCMD0 field to 010 or 011 instructs the MAC to synchronize the Target Time Registers to the PTP clock domain. The MAC clears this bit after synchronizing the Target Time Registers to the PTP clock domain The application must not update the Target Time Registers when this bit is read as 1. Otherwise, the synchronization of the previous programmed time gets corrupted. */
  } B;
} GMAC_MAC_PPS2_TARGET_TIME_NANOSECONDS_tag;

typedef union GMAC_MAC_PPS2_INTERVAL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PPSINT2:32;              /* PPS Output Signal Interval These bits store the interval between the rising edges of PPS0 signal output. The interval is stored in terms of number of units of sub-second increment value. You need to program one value less than the required interval. For example, if the PTP reference clock is 50 MHz (period of 20 ns), and desired interval between the rising edges of PPS0 signal output is 100 ns (that is, 5 units of sub-second increment value), you should program value 4 (5-1) in this register. */
  } B;
} GMAC_MAC_PPS2_INTERVAL_tag;

typedef union GMAC_MAC_PPS2_WIDTH_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PPSWIDTH2:32;            /* PPS Output Signal Width These bits store the width between the rising edge and corresponding falling edge of PPS0 signal output. The width is stored in terms of number of units of sub-second increment value. You need to program one value less than the required interval. For example, if PTP reference clock is 50 MHz (period of 20 ns), and width between the rising and corresponding falling edges of PPS0 signal output is 80 ns (that is, four units of sub-second increment value), you should program value 3 (4-1) in this register. Note: The value programmed in this register must be lesser than the value programmed in MAC_PPS0_Interval. */
  } B;
} GMAC_MAC_PPS2_WIDTH_tag;

typedef union GMAC_MAC_PPS3_TARGET_TIME_SECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TSTRH3:32;               /* PPS Target Time Seconds Register This field stores the time in seconds. When the timestamp value matches or exceeds both Target Timestamp registers, the MAC starts or stops the PPS signal output and generates an interrupt (if enabled) based on Target Time mode selected for the corresponding PPS output in the MAC_PPS_Control register. If DWC_EQOS_FLEXI_PPS_OUT_EN is enabled in the configuration and PTGE field of MAC_Timestamp_Control Register is set with Presentation time control set in recovery mode, then these bits indicate the TPT being programmed by the application and in generation mode it indicates the CPT generated at the sampled trigger. */
  } B;
} GMAC_MAC_PPS3_TARGET_TIME_SECONDS_tag;

typedef union GMAC_MAC_PPS3_TARGET_TIME_NANOSECONDS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TTSL3:31;                /* Target Time Low for PPS Register This register stores the time in (signed) nanoseconds. When the value of the timestamp matches the value in both Target Timestamp registers, the MAC starts or stops the PPS signal output and generates an interrupt (if enabled) based on the TRGTMODSEL0 field (Bits [6:5]) in MAC_PPS_Control. When the TSCTRLSSR bit is reset in the MAC_Timestamp_Control register, this value should be (time in ns / 0.465). The actual start or stop time of the PPS signal output may have an error margin up to one unit of sub-second increment value. When the TSCTRLSSR bit is set in the MAC_Timestamp_Control register, this value should not exceed 0x3B9A_C9FF. The actual start or stop time of the PPS signal output may have an error margin up to one unit of sub-second increment value. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TRGTBUSY3:1;             /* PPS Target Time Register Busy The MAC sets this bit when the PPSCMD0 field in the MAC_PPS_Control register is programmed to 010 or 011. Programming the PPSCMD0 field to 010 or 011 instructs the MAC to synchronize the Target Time Registers to the PTP clock domain. The MAC clears this bit after synchronizing the Target Time Registers to the PTP clock domain The application must not update the Target Time Registers when this bit is read as 1. Otherwise, the synchronization of the previous programmed time gets corrupted. */
  } B;
} GMAC_MAC_PPS3_TARGET_TIME_NANOSECONDS_tag;

typedef union GMAC_MAC_PPS3_INTERVAL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PPSINT3:32;              /* PPS Output Signal Interval These bits store the interval between the rising edges of PPS0 signal output. The interval is stored in terms of number of units of sub-second increment value. You need to program one value less than the required interval. For example, if the PTP reference clock is 50 MHz (period of 20 ns), and desired interval between the rising edges of PPS0 signal output is 100 ns (that is, 5 units of sub-second increment value), you should program value 4 (5-1) in this register. */
  } B;
} GMAC_MAC_PPS3_INTERVAL_tag;

typedef union GMAC_MAC_PPS3_WIDTH_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PPSWIDTH3:32;            /* PPS Output Signal Width These bits store the width between the rising edge and corresponding falling edge of PPS0 signal output. The width is stored in terms of number of units of sub-second increment value. You need to program one value less than the required interval. For example, if PTP reference clock is 50 MHz (period of 20 ns), and width between the rising and corresponding falling edges of PPS0 signal output is 80 ns (that is, four units of sub-second increment value), you should program value 3 (4-1) in this register. Note: The value programmed in this register must be lesser than the value programmed in MAC_PPS0_Interval. */
  } B;
} GMAC_MAC_PPS3_WIDTH_tag;

typedef union GMAC_MAC_PTO_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t PTOEN:1;                 /* PTP Offload Enable When this bit is set, the PTP Offload feature is enabled. */
    vuint32_t ASYNCEN:1;               /* Automatic PTP SYNC message Enable When this bit is set, PTP SYNC message is generated periodically based on interval programmed or trigger from application, when the MAC is programmed to be in Clock Master mode. */
    vuint32_t APDREQEN:1;              /* Automatic PTP Pdelay_Req message Enable When this bit is set, PTP Pdelay_Req message is generated periodically based on interval programmed or trigger from application, when the MAC is programmed to be in Peer-to-Peer Transparent mode. */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t ASYNCTRIG:1;             /* Automatic PTP SYNC message Trigger When this bit is set, one PTP SYNC message is transmitted. This bit is automatically cleared after the PTP SYNC message is transmitted. The application should set the ASYNCEN bit for this operation. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t APDREQTRIG:1;            /* Automatic PTP Pdelay_Req message Trigger When this bit is set, one PTP Pdelay_Req message is transmitted. This bit is automatically cleared after the PTP Pdelay_Req message is transmitted. The application should set the APDREQEN bit for this operation. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t DRRDIS:1;                /* Disable PTO Delay Request/Response response generation When this bit is set, the Delay Request and Delay response is not generated for received SYNC and Delay request packet respectively, as required by the programmed mode. */
    vuint32_t PDRDIS:1;                /* Disable Peer Delay Response response generation When this bit is set, the Peer Delay Response (Pdelay_Resp) response is not be generated for received Peer Delay Request (Pdelay_Req) request packet, as required by the programmed mode. Note: Setting this bit to 1 affects the normal PTP Offload operation and the time synchronization. So, this bit must be set only if there is problem with Pdelay_Resp generation in Hardware and/or Pdelay_Resp generation is handled by Software. */
    vuint32_t DN:8;                    /* Domain Number This field indicates the domain Number in which the PTP node is operating. */
    vuint32_t _unused_16:16;           /* Reserved. */
  } B;
} GMAC_MAC_PTO_CONTROL_tag;

typedef union GMAC_MAC_SOURCE_PORT_IDENTITY0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t SPI0:32;                 /* Source Port Identity 0 This field indicates bits [31:0] of sourcePortIdentity of PTP node. */
  } B;
} GMAC_MAC_SOURCE_PORT_IDENTITY0_tag;

typedef union GMAC_MAC_SOURCE_PORT_IDENTITY1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t SPI1:32;                 /* Source Port Identity 1 This field indicates bits [63:32] of sourcePortIdentity of PTP node. */
  } B;
} GMAC_MAC_SOURCE_PORT_IDENTITY1_tag;

typedef union GMAC_MAC_SOURCE_PORT_IDENTITY2_union_tag {
  vuint32_t R;
  struct {
    vuint32_t SPI2:16;                 /* Source Port Identity 2 This field indicates bits [79:64] of sourcePortIdentity of PTP node. */
    vuint32_t _unused_16:16;           /* Reserved. */
  } B;
} GMAC_MAC_SOURCE_PORT_IDENTITY2_tag;

typedef union GMAC_MAC_LOG_MESSAGE_INTERVAL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t LSI:8;                   /* Log Sync Interval This field indicates the periodicity of the automatically generated SYNC message when the PTP node is Master. Allowed values are -15 to 15. Negative value must be represented in 2's-complement form. For example, if the required value is -1, the value programmed must be 0xFF. */
    vuint32_t DRSYNCR:3;               /* Delay_Req to SYNC Ratio In Slave mode, it is used for controlling frequency of Delay_Req messages transmitted. - 0: DelayReq generated for every received SYNC - 1: DelayReq generated every alternate reception of SYNC - 2: for every 4 SYNC messages - 3: for every 8 SYNC messages - 4: for every 16 SYNC messages - 5: for every 32 SYNC messages - 6-7: Reserved The master sends this information (logMinDelayReqInterval) in the DelayResp PTP messages to the slave. The DWC_ether_qos Receiver processes this value from the received DelayResp messages and updates this field accordingly. In the Slave mode, the host must not write/update this register unless it has to override the received value. In Master mode, the sum of this field and logSyncInterval (LSI) field is provided in the logMinDelayReqInterval field of the generated multicast Delay_Resp PTP message. Access restriction applies. Updated based on the event. Setting 1 sets. Setting 0 clears. */
    vuint32_t _unused_11:13;           /* Reserved. */
    vuint32_t LMPDRI:8;                /* Log Min Pdelay_Req Interval This field indicates logMinPdelayReqInterval of PTP node. This is used to schedule the periodic Pdelay request packet transmission. Allowed values are -15 to 15.Negative value must be represented in 2's-complement form. For example, if the required value is -1, the value programmed must be 0xFF. */
  } B;
} GMAC_MAC_LOG_MESSAGE_INTERVAL_tag;

typedef union GMAC_MTL_OPERATION_MODE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:1;             /* Reserved. */
    vuint32_t DTXSTS:1;                /* Drop Transmit Status When this bit is set, the Tx packet status received from the MAC is dropped in the MTL. When this bit is reset, the Tx packet status received from the MAC is forwarded to the application. */
    vuint32_t RAA:1;                   /* Receive Arbitration Algorithm This field is used to select the arbitration algorithm for the Rx side. - 0: Strict priority (SP) Queue 0 has the lowest priority and the last queue has the highest priority. - 1: Weighted Strict Priority (WSP) */
    vuint32_t _unused_3:2;             /* Reserved. */
    vuint32_t SCHALG:2;                /* Tx Scheduling Algorithm This field indicates the algorithm for Tx scheduling: */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t CNTPRST:1;               /* Counters Preset When this bit is set, - MTL_TxQ[0-7]_Underflow register is initialized/preset to 12'h7F0. - Missed Packet and Overflow Packet counters in MTL_RxQ[0-7]_Missed_Packet_Overflow_Cnt register is initialized/preset to 12'h7F0. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t CNTCLR:1;                /* Counters Reset When this bit is set, all counters are reset. This bit is cleared automatically after 1 clock cycle. If this bit is set along with CNT_PRESET bit, CNT_PRESET has precedence. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t _unused_10:5;            /* Reserved. */
    vuint32_t FRPE:1;                  /* Flexible Rx parser Enable When this bit is set to 1, the Programmable Rx Parser functionality is enabled. When the Rx parser is disabled and if the Rx parser is in the middle of the parsing then it gets disabled only after completing the current packet parsing. When the Rx parser is enabled from disabled state then the Rx parser gets activated for the next immediate packet. */
    vuint32_t _unused_16:16;           /* Reserved. */
  } B;
} GMAC_MTL_OPERATION_MODE_tag;

typedef union GMAC_MTL_DBG_CTL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FDBGEN:1;                /* FIFO Debug Access Enable When this bit is set, it indicates that the debug mode access to the FIFO is enabled. When this bit is reset, it indicates that the FIFO can be accessed only through a master interface. */
    vuint32_t DBGMOD:1;                /* Debug Mode Access to FIFO When this bit is set, it indicates that the current access to the FIFO is read, write, and debug access. In this mode, the following access types are allowed: - Read and Write access to Tx FIFO, TSO FIFO, and Rx FIFO - Read access is allowed to Tx Status FIFO. When this bit is reset, it indicates that the current access to the FIFO is slave access bypassing the DMA. In this mode, the following access are allowed: - Write access to the Tx FIFO - Read access to the Rx FIFO and Tx Status FIFO */
    vuint32_t BYTEEN:2;                /* Byte Enables This field indicates the number of data bytes valid in the data register during Write operation. This is valid only when PKTSTATE is 2'b10 (EOP) and Tx FIFO or Rx FIFO is selected. */
    vuint32_t _unused_4:1;             /* Reserved. */
    vuint32_t PKTSTATE:2;              /* Encoded Packet State This field is used to write the control information to the Tx FIFO or Rx FIFO. Tx FIFO: - 00: Packet Data - 01: Control Word - 10: SOP Data - 11: EOP Data Rx FIFO: - 00: Packet Data - 01: Normal Status - 10: Last Status - 11: EOP */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t RSTALL:1;                /* Reset All Pointers When this bit is set, the pointers of all FIFOs are reset when FIFO Debug Access is enabled. This bit must not be written to 1 when FIFO Debug Access is not enabled, that is FDBGEN bit is 0. Access restriction applies. Self-cleared. Setting 0 clears. Setting 1 sets. */
    vuint32_t RSTSEL:1;                /* Reset Pointers of Selected FIFO When this bit is set, the pointers of the currently-selected FIFO are reset when FIFO Debug Access is enabled. This bit must not be written to 1 when FIFO Debug Access is not enabled, that is FDBGEN bit is 0. Access restriction applies. Self-cleared. Setting 0 clears. Setting 1 sets. */
    vuint32_t FIFORDEN:1;              /* FIFO Read Enable When this bit is set, it enables the Read operation on selected FIFO when FIFO Debug Access is enabled. This bit must not be written to 1 when FIFO Debug Access is not enabled, that is FDBGEN bit is 0. Access restriction applies. Self-cleared. Setting 0 clears. Setting 1 sets. */
    vuint32_t FIFOWREN:1;              /* FIFO Write Enable When this bit is set, it enables the Write operation on selected FIFO when FIFO Debug Access is enabled. This bit must not be written to 1 when FIFO Debug Access is not enabled, that is FDBGEN bit is 0. Access restriction applies. Self-cleared. Setting 0 clears. Setting 1 sets. */
    vuint32_t FIFOSEL:2;               /* FIFO Selected for Access This field indicates the FIFO selected for debug access: */
    vuint32_t PKTIE:1;                 /* Receive Packet Available Interrupt Status Enable When this bit is set, an interrupt is generated when EOP of received packet is written to the Rx FIFO. */
    vuint32_t STSIE:1;                 /* Transmit Status Available Interrupt Status Enable When this bit is set, an interrupt is generated when Transmit status is available in slave mode. */
    vuint32_t EIEE:1;                  /* ECC Inject Error Enable for Tx, Rx and TSO memories When set, enables the ECC error injection feature. When reset, disables the ECC error injection feature. */
    vuint32_t EIEC:2;                  /* ECC Inject Error Control for Tx, Rx and TSO memories When EIEE bit of this register is set, following are the errors inserted based on the value encoded in this field. */
    vuint32_t _unused_19:13;           /* Reserved. */
  } B;
} GMAC_MTL_DBG_CTL_tag;

typedef union GMAC_MTL_DBG_STS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FIFOBUSY:1;              /* FIFO Busy When set, this bit indicates that a FIFO operation is in progress in the MAC and content of the following fields is not valid: - All other fields of this register - All fields of the MTL_FIFO_Debug_Data register */
    vuint32_t PKTSTATE:2;              /* Encoded Packet State This field is used to get the control or status information of the selected FIFO. Tx FIFO: - 00: Packet Data - 01: Control Word - 10: SOP Data - 11: EOP Data Rx FIFO: - 00: Packet Data - 01: Normal Status - 10: Last Status - 11: EOP This field is applicable only for Tx FIFO and Rx FIFO during Read operation. */
    vuint32_t BYTEEN:2;                /* Byte Enables This field indicates the number of data bytes valid in the data register during Read operation. This is valid only when PKTSTATE is 2'b10 (EOP) and Tx FIFO or Rx FIFO is selected. */
    vuint32_t _unused_5:3;             /* Reserved. */
    vuint32_t PKTI:1;                  /* Receive Packet Available Interrupt Status When set, this bit indicates that MAC layer has written the EOP of received packet to the Rx FIFO. This bit is reset when 1 is written to this bit. */
    vuint32_t STSI:1;                  /* Transmit Status Available Interrupt Status When set, this bit indicates that the Slave mode Tx packet is transmitted, and the status is available in Tx Status FIFO. This bit is reset when 1 is written to this bit. */
    vuint32_t _unused_10:5;            /* Reserved. */
    vuint32_t LOCR:17;                 /* Remaining Locations in the FIFO Slave Access Mode: This field indicates the space available in selected FIFO. Debug Access Mode: This field contains the Write or Read pointer value of the selected FIFO during Write or Read operation, respectively. Reset: In single Tx Queue configurations, (DWC_EQOS_TXFIFO_SIZE/(DWC_EQOS_DATAWIDTH/8)), Otherwise 0000H */
  } B;
} GMAC_MTL_DBG_STS_tag;

typedef union GMAC_MTL_FIFO_DEBUG_DATA_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FDBGDATA:32;             /* FIFO Debug Data During debug or slave access write operation, this field contains the data to be written to the Tx FIFO, Rx FIFO, or TSO FIFO. During debug or slave access read operation, this field contains the data read from the Tx FIFO, Rx FIFO, TSO FIFO, or Tx Status FIFO. */
  } B;
} GMAC_MTL_FIFO_DEBUG_DATA_tag;

typedef union GMAC_MTL_INTERRUPT_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t Q0IS:1;                  /* Queue 0 Interrupt status This bit indicates that there is an interrupt from Queue 0. To reset this bit, the application must read Queue 0 Interrupt Control and Status register to get the exact cause of the interrupt and clear its source. */
    vuint32_t Q1IS:1;                  /* Queue 1 Interrupt status This bit indicates that there is an interrupt from Queue 1. To reset this bit, the application must read the MTL_Q1_Interrupt_Control_Status register to get the exact cause of the interrupt and clear its source. */
    vuint32_t Q2IS:1;                  /* Queue 2 Interrupt status This bit indicates that there is an interrupt from Queue 2. To reset this bit, the application must read the MTL_Q2_Interrupt_Control_Status register to get the exact cause of the interrupt and clear its source. */
    vuint32_t Q3IS:1;                  /* Queue 3 Interrupt status This bit indicates that there is an interrupt from Queue 3. To reset this bit, the application must read the MTL_Q3_Interrupt_Control_Status register to get the exact cause of the interrupt and clear its source. */
    vuint32_t Q4IS:1;                  /* Queue 4 Interrupt status This bit indicates that there is an interrupt from Queue 4. To reset this bit, the application must read the MTL_Q4_Interrupt_Control_Status register to get the exact cause of the interrupt and clear its source. */
    vuint32_t _unused_5:1;             /* Reserved. */
    vuint32_t _unused_6:1;             /* Reserved. */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t _unused_8:8;             /* Reserved. */
    vuint32_t _unused_16:1;            /* Reserved. */
    vuint32_t DBGIS:1;                 /* Debug Interrupt status This bit indicates an interrupt event during the slave access. To reset this bit, the application must read the FIFO Debug Access Status register to get the exact cause of the interrupt and clear its source. */
    vuint32_t ESTIS:1;                 /* EST (TAS- 802.1Qbv) Interrupt Status This bit indicates an interrupt event during the operation of 802.1Qbv. To reset this bit, the application must clear the error/event that has caused the Interrupt. */
    vuint32_t _unused_19:4;            /* Reserved. */
    vuint32_t MTLPIS:1;                /* MTL Rx Parser Interrupt Status This bit indicates that there is an interrupt from Rx Parser Block. To reset this bit, the application must read the MTL_ Rxp_Interrupt_Status register to get the exact cause of the interrupt and clear its source. */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} GMAC_MTL_INTERRUPT_STATUS_tag;

typedef union GMAC_MTL_RXQ_DMA_MAP0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t Q0MDMACH:3;              /* Queue 0 Mapped to DMA Channel This field controls the routing of the packet received in Queue 0 to the DMA channel: - 000: DMA Channel 0 - 001: DMA Channel 1 - 010: DMA Channel 2 - 011: DMA Channel 3 - 100: DMA Channel 4 - 101: DMA Channel 5 - 110: DMA Channel 6 - 111: DMA Channel 7 This field is valid when the Q0DDMACH field is reset. The width of this field depends on the number of RX DMA channels and not all the values may be valid in some configurations. For example, if the number of RX DMA channels selected is 2, only 000 and 001 are valid, the other bits are reserved. */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t Q0DDMACH:1;              /* Queue 0 Enabled for DA-based DMA Channel Selection When set, this bit indicates that the packets received in Queue 0 are routed to a particular DMA channel as decided in the MAC Receiver based on the DMA channel number programmed in the L3-L4 filter registers, or the Ethernet DA address. When reset, this bit indicates that the packets received in Queue 0 are routed to the DMA Channel programmed in the Q0MDMACH field. */
    vuint32_t _unused_5:3;             /* Reserved. */
    vuint32_t Q1MDMACH:3;              /* Queue 1 Mapped to DMA Channel This field controls the routing of the received packet in Queue 1 to the DMA channel: - 000: DMA Channel 0 - 001: DMA Channel 1 - 010: DMA Channel 2 - 011: DMA Channel 3 - 100: DMA Channel 4 - 101: DMA Channel 5 - 110: DMA Channel 6 - 111: DMA Channel 7 This field is valid when the Q1DDMACH field is reset. The width of this field depends on the number of RX DMA channels and not all the values may be valid in some configurations. For example, if the number of RX DMA channels selected is 2, only 000 and 001 are valid, the other bits are reserved. */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t Q1DDMACH:1;              /* Queue 1 Enabled for DA-based DMA Channel Selection When set, this bit indicates that the packets received in Queue 1 are routed to a particular DMA channel as decided in the MAC Receiver based on the DMA channel number programmed in the L3-L4 filter registers, or the Ethernet DA address. When reset, this bit indicates that the packets received in Queue 1 are routed to the DMA Channel programmed in the Q1MDMACH field (Bits[10:8]). */
    vuint32_t _unused_13:3;            /* Reserved. */
    vuint32_t Q2MDMACH:3;              /* Queue 2 Mapped to DMA Channel This field controls the routing of the received packet in Queue 2 to the DMA channel: - 000: DMA Channel 0 - 001: DMA Channel 1 - 010: DMA Channel 2 - 011: DMA Channel 3 - 100: DMA Channel 4 - 101: DMA Channel 5 - 110: DMA Channel 6 - 111: DMA Channel 7 This field is valid when the Q2DDMACH field is reset. */
    vuint32_t _unused_19:1;            /* Reserved. */
    vuint32_t Q2DDMACH:1;              /* Queue 2 Enabled for DA-based DMA Channel Selection When set, this bit indicates that the packets received in Queue 2 are routed to a particular DMA channel as decided in the MAC Receiver based on the DMA channel number programmed in the L3-L4 filter registers, or the Ethernet DA address. When reset, this bit indicates that the packets received in Queue 2 are routed to the DMA Channel programmed in the Q2MDMACH field (Bits[18:16]). */
    vuint32_t _unused_21:3;            /* Reserved. */
    vuint32_t Q3MDMACH:3;              /* Queue 3 Mapped to DMA Channel This field controls the routing of the received packet in Queue 3 to the DMA channel: - 000: DMA Channel 0 - 001: DMA Channel 1 - 010: DMA Channel 2 - 011: DMA Channel 3 - 100: DMA Channel 4 - 101: DMA Channel 5 - 110: DMA Channel 6 - 111: DMA Channel 7 This field is valid when the Q3DDMACH field is reset. Note: The width of this field depends on the number of RX DMA channels and not all the values may be valid in some configurations. For example, if the number of RX DMA channels selected is 2, only 000 and 001 are valid, the others are reserved */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t Q3DDMACH:1;              /* Queue 3 Enabled for Dynamic (per packet) DMA Channel Selection When set, this bit indicates that the packets received in Queue 3 are routed to a particular DMA channel as decided in the MAC Receiver based on the DMA channel number programmed in the L3-L4 filter registers, or the Ethernet DA address. When reset, this bit indicates that the packets received in Queue 3 are routed to the DMA Channel programmed in the Q3MDMACH field (Bits[26:24]). */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ_DMA_MAP0_tag;

typedef union GMAC_MTL_RXQ_DMA_MAP1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t Q4MDMACH:3;              /* Queue 4 Mapped to DMA Channel This field controls the routing of the packet received in Queue 4 to the DMA channel: - 000: DMA Channel 0 - 001: DMA Channel 1 - 010: DMA Channel 2 - 011: DMA Channel 3 - 100: DMA Channel 4 - 101: DMA Channel 5 - 110: DMA Channel 6 - 111: DMA Channel 7 This field is valid when the Q4DDMACH field is reset. The width of this field depends on the number of RX DMA channels and not all the values may be valid in some configurations. For example, if the number of RX DMA channels selected is 2, only 000 and 001 are valid, the other bits are reserved. */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t Q4DDMACH:1;              /* Queue 4 Enabled for DA-based DMA Channel Selection When set, this bit indicates that the packets received in Queue 4 are routed to a particular DMA channel as decided in the MAC Receiver based on the DMA channel number programmed in the L3-L4 filter registers, or the Ethernet DA address. When reset, this bit indicates that the packets received in Queue 4 are routed to the DMA Channel programmed in the Q4MDMACH field. */
    vuint32_t _unused_5:3;             /* Reserved. */
    vuint32_t _unused_8:3;             /* Reserved. */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t _unused_12:1;            /* Reserved. */
    vuint32_t _unused_13:3;            /* Reserved. */
    vuint32_t _unused_16:3;            /* Reserved. */
    vuint32_t _unused_19:1;            /* Reserved. */
    vuint32_t _unused_20:1;            /* Reserved. */
    vuint32_t _unused_21:3;            /* Reserved. */
    vuint32_t _unused_24:3;            /* Reserved. */
    vuint32_t _unused_27:1;            /* Reserved. */
    vuint32_t _unused_28:1;            /* Reserved. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ_DMA_MAP1_tag;

typedef union GMAC_MTL_TBS_CTRL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ESTM:1;                  /* EST offset Mode When this bit is set, the Launch Time value used in Time Based Scheduling is interpreted as an EST offset value and is added to the Base Time Register (BTR) of the current list. When reset, the Launch Time value is used as an absolute value that should be compared with the System time [39:8]. */
    vuint32_t LEOV:1;                  /* Launch Expiry Offset Valid When set indicates the LEOS field is valid. When not set, indicates the Launch Expiry Offset is not valid and the MTL must not check for Launch expiry time. */
    vuint32_t _unused_2:2;             /* Reserved. */
    vuint32_t LEGOS:3;                 /* Launch Expiry GSN Offset The number GSN slots that has to be added to the Launch GSN to compute the Launch Expiry time. Value valid only when LEOV is set. */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t LEOS:24;                 /* Launch Expiry Offset The value in units of 256 nanoseconds that has to be added to the Launch time to compute the Launch Expiry time. Value valid only when LEOV is set. Max value: 999,999,999 ns, additionally should be smaller than CTR-1 value when ESTM mode is set since this value is a modulo CTR value. */
  } B;
} GMAC_MTL_TBS_CTRL_tag;

typedef union GMAC_MTL_EST_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t EEST:1;                  /* Enable EST When reset, the gate control list processing is halted and all gates are assumed to be in Open state. Should be set for the hardware to start processing the gate control lists. During the toggle from 0 to 1, the gate control list processing starts only after the SSWL bit it set. When DWC_EQOS_ASP_ECC is selected during the configuration, if any uncorrectable error is detected in the EST memory the hardware will reset this bit and disable the EST function. */
    vuint32_t SSWL:1;                  /* Switch to S/W owned list When set indicates that the software has programmed that list that it currently owns (SWOL) and the hardware should switch to the new list based on the new BTR. Hardware clears this bit when the switch to the SWOL happens to indicate the completion of the switch or when an BTR error (BTRE in Status register) is set. When BTRE is set this bit is cleared but SWOL is not updated as the switch was not successful. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t _unused_2:2;             /* Reserved. */
    vuint32_t DDBF:1;                  /* Do not Drop frames during Frame Size Error When set, frames are not be dropped during Head-of-Line blocking due to Frame Size Error (HLBF field of EST_Status register). */
    vuint32_t DFBS:1;                  /* Drop Frames causing Scheduling Error When set frames reported to cause HOL Blocking due to not getting scheduled (HLBS field of EST_Status register) after 4,8,16,32 (based on LCSE field of this register) GCL iterations are dropped. */
    vuint32_t LCSE:2;                  /* Loop Count to report Scheduling Error Programmable number of GCL list iterations before reporting an HLBS error defined in EST_Status register. */
    vuint32_t TILS:3;                  /* Time Interval Left Shift Amount This field provides the left shift amount for the programmed Time Interval values used in the Gate Control Lists. - 000: No left shift needed (equal to x1ns) - 001: Left shift TI by 1 bit (equal to x2ns) - 010: Left shift TI by 2 bits (equal to x4ns) - . - . - 100: Left shift TI by 7 bits (equal to x128ns) Based on the configuration one or more bits of this field should be treated as Reserved/Read-Only. */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t CTOV:12;                 /* Current Time Offset Value Provides a 12 bit time offset value in nano second that is added to the current time to compensate for all the implementation pipeline delays such as the CDC sync delay, buffering delays, data path delays etc. This offset helps to ensure that the impact of gate controls is visible on the line exactly at the pre-determined schedule (or as close to the schedule as possible). */
    vuint32_t PTOV:8;                  /* PTP Time Offset Value The value of PTP Clock period multiplied by 6 in nanoseconds. This value is needed to avoid transmission overruns at the beginning of the installation of a new GCL. */
  } B;
} GMAC_MTL_EST_CONTROL_tag;

typedef union GMAC_MTL_EST_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t SWLC:1;                  /* Switch to S/W owned list Complete When "1" indicates the hardware has successfully switched to the SWOL, and the SWOL bit has been updated to that effect. Cleared when the SSWL of EST_Control register transitions from 0 to 1, or on a software write. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t BTRE:1;                  /* BTR Error When "1" indicates a programming error in the BTR of SWOL where the programmed value is less than current time. If the BTRL = "1111", SWOL is not updated and Software should reprogram the BTR to a value greater than current time and then set SSWL to reinitiate the switch to SWOL. Else if the value of BTRL < "1111", SWOL is updated and this field indicates the number of iterations (of + CycleTime) taken by hardware to update the BTR to a value greater than Current Time. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t HLBF:1;                  /* Head-Of-Line Blocking due to Frame Size Set when HOL Blocking is noticed on one or more Queues as a result of none of the Time Intervals of gate open in the GCL being greater than or equal to the duration needed for frame size (or frame fragment size when preemption is enabled) transmission. The one hot encoded Queue numbers that are experiencing HLBF are indicated in the MTL_EST_Frm_Size_Error register. Additionally, the first Queue number that experienced HLBF along with the frame size is captured in MTL_EST_Frm_Size_Capture register. Bit cleared when MTL_EST_Frame_Size_ Error register is all zeros. */
    vuint32_t HLBS:1;                  /* Head-Of-Line Blocking due to Scheduling Set when the frame is not able to win arbitration and get scheduled even after 4 iterations of the GCL. Indicates to software a potential programming error. The one hot encoded values of the Queue Numbers that are not able to make progress are indicated in the MTL_EST_Sch_Error register. Bit cleared when MTL_EST_Sch_Error register is all zeros. */
    vuint32_t CGCE:1;                  /* Constant Gate Control Error This error occurs when the list length (LLR) is 1 and the programmed Time Interval (TI) value after the optional Left Shifting is less than or equal to the Cycle Time (CTR). The above programming implies Gates are either always Closed or always Open based on the Gate Control values; the same effect can be achieved by other simpler (non TSN) programming mechanisms. Since the implementation does not support such a programming an error is reported. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_5:2;             /* Reserved. */
    vuint32_t SWOL:1;                  /* S/W owned list When '0' indicates Gate control list number "0" is owned by software and when "1" indicates the Gate Control list "1" is owned by the software. Any reads/writes by the software (using indirect access via GCL_Control) is directed to the list indicated by this value by default. The inverse of this value is treated as HWOL. R/W operations performed by hardware are directed to the list pointed by HWOL by default. */
    vuint32_t BTRL:4;                  /* BTR Error Loop Count Provides the minimum count (N) for which the equation Current Time =< New BTR + (N * New Cycle Time) becomes true. N = "1111" indicates the iterations exceeded the value of 8 and the hardware was not able to update New BTR to be equal to or greater than Current Time. Software intervention is needed to update the New BTR. Value cleared when BTRE field of this register is cleared. */
    vuint32_t _unused_12:4;            /* Reserved. */
    vuint32_t CGSN:4;                  /* Current GCL Slot Number Indicates the slot number of the GCL list. Slot number is a modulo 16 count of the GCL List loops executed so far. Even if a new GCL list is installed, the count is incremental. */
    vuint32_t _unused_20:12;           /* Reserved. */
  } B;
} GMAC_MTL_EST_STATUS_tag;

typedef union GMAC_MTL_EST_SCH_ERROR_union_tag {
  vuint32_t R;
  struct {
    vuint32_t SEQN:5;                  /* Schedule Error Queue Number The One Hot Encoded Queue Numbers that have experienced error/timeout described in HLBS field of status register. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_5:27;            /* Reserved. */
  } B;
} GMAC_MTL_EST_SCH_ERROR_tag;

typedef union GMAC_MTL_EST_FRM_SIZE_ERROR_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FEQN:5;                  /* Frame Size Error Queue Number The One Hot Encoded Queue Numbers that have experienced error described in HLBF field of status register. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_5:27;            /* Reserved. */
  } B;
} GMAC_MTL_EST_FRM_SIZE_ERROR_tag;

typedef union GMAC_MTL_EST_FRM_SIZE_CAPTURE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HBFS:15;                 /* Frame Size of HLBF Captures the Frame Size of the dropped frame related to queue number indicated in HBFQ field of this register. Contents of this register should be considered invalid, if this field is zero. Cleared when MTL_EST_Frm_Size_Error register is all zeros. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t HBFQ:3;                  /* Queue Number of HLBF Captures the binary value of the of the first Queue (number) experiencing HLBF error (see HLBF field of status register). Value once written is not altered by any subsequent queue errors of similar nature. Once cleared the queue number of the next occurring HLBF error is captured. Width is based on the number of Tx Queues configured; remaining bits are Read-Only. Cleared when MTL_EST_Frm_Size_Error register is all zeros. */
    vuint32_t _unused_19:13;           /* Reserved. */
  } B;
} GMAC_MTL_EST_FRM_SIZE_CAPTURE_tag;

typedef union GMAC_MTL_EST_INTR_ENABLE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t IECC:1;                  /* Interrupt Enable for Switch List When set, generates interrupt when the configuration change is successful and the hardware has switched to the new list. When reset this event does not generate an interrupt. */
    vuint32_t IEBE:1;                  /* Interrupt Enable for BTR Error When set, generates interrupt when the BTR Error occurs and is indicated in the status. When reset this event does not generate an interrupt. */
    vuint32_t IEHF:1;                  /* Interrupt Enable for HLBF When set, generates interrupt when the Head-of-Line Blocking due to Frame Size error occurs and is indicated in the status. When reset this event does not generate an interrupt. */
    vuint32_t IEHS:1;                  /* Interrupt Enable for HLBS When set, generates interrupt when the Head-of-Line Blocking due to Scheduling issue and is indicated in the status. When reset this event does not generate an interrupt. */
    vuint32_t CGCE:1;                  /* Interrupt Enable for CGCE When set, generates interrupt when the Constant Gate Control Error occurs and is indicated in the status. When reset this event does not generate an interrupt */
    vuint32_t _unused_5:27;            /* Reserved. */
  } B;
} GMAC_MTL_EST_INTR_ENABLE_tag;

typedef union GMAC_MTL_EST_GCL_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t SRWO:1;                  /* Start Read/Write Op When set indicates a Read/Write Op has started and is in progress. When reset by hardware indicates the R/W Op has completed or an error has occurred (when bit 20 is set) Reads: Data can be read from MTL_EST_GCL_Data register after this bit is reset Writes: MTL_EST_GCL_Data should be programmed with write data before setting SRWO. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t R1W0:1;                  /* Read '1', Write '0': When set to '1': Read Operation When set to '0': Write Operation. */
    vuint32_t GCRR:1;                  /* Gate Control Related Registers When set to "1" indicates the R/W access is for the GCL related registers (BTR, CTR, TER, LLR) whose address is provided by GCRA. When "0" indicates R/W should be directed to GCL from the address provided by GCLA. */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t DBGM:1;                  /* Debug Mode When set to "1" indicates R/W in debug mode where the memory bank (for GCL and Time related registers) is explicitly provided by DBGB value, when set to "0" SWOL bit is used to determine which bank to use. */
    vuint32_t DBGB:1;                  /* Debug Mode Bank Select When set to "0" indicates R/W in debug mode should be directed to Bank 0 (GCL0 and corresponding Time related registers). When set to "1" indicates R/W in debug mode should be directed to Bank 1 (GCL1 and corresponding Time related registers). This value is used when DBGM is set and overrides by value of SWOL which is normally used. */
    vuint32_t _unused_6:2;             /* Reserved. */
    vuint32_t ADDR:8;                  /* Gate Control List Address: (GCLA when GCRR is "0"). Provides the address (row number) of the Gate Control List at which the R/W operation has to be performed. By default the Gate Control List pointed by SWOL of MTL_EST_Status is selected for R/W, however if the DBGM bit of this register is set, a debug mode access is given to R/W from DBGB. The width of this field is dependent on DWC_EQOS_EST_DEP; unused bits should be treated as read only. Gate Control list Related Registers Address: (GCRA when GCRR is "1"). By default the GCL related register set pointed by SWOL of MTL_EST_Status is selected for R/W, however if the DBGM bit of this register is set, a debug mode access is given to R/W from DBGB. Lower 3 bits are only used in this mode, higher order bits are treated as dont cares. - 000: BTR Low (31:0) - 001: BTR High (63:31) - 010: CTR Low (31:0) - 011: CTR High (39:32) - 100: TER (31:0) - 101: LLR (n:0) (where n is (log{DWC_EQOS_EST_DEP} / log2)) - Others: Reserved */
    vuint32_t _unused_16:4;            /* Reserved. */
    vuint32_t ERR0:1;                  /* When set indicates the last write operation was aborted as software writes to GCL and GCL registers is prohibited when SSWL bit of MTL_EST_Control Register is set. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t ESTEIEE:1;               /* EST ECC Inject Error Enable When set along with EEST bit of MTL_EST_Control register, enables the ECC error injection feature. When reset, disables the ECC error injection feature. */
    vuint32_t ESTEIEC:2;               /* ECC Inject Error Control for EST Memory When EIEE bit of this register is set, following are the errors inserted based on the value encoded in this field. This filed will be valid only if DWC_EQOS_ASP_ECC feature is selected during the configuration, else it will be reserved. */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} GMAC_MTL_EST_GCL_CONTROL_tag;

typedef union GMAC_MTL_EST_GCL_DATA_union_tag {
  vuint32_t R;
  struct {
    vuint32_t GCD:32;                  /* Gate Control Data The data corresponding to the address selected in the GCL_Control register. Used for both Read and Write operations. */
  } B;
} GMAC_MTL_EST_GCL_DATA_tag;

typedef union GMAC_MTL_FPE_CTRL_STS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t AFSZ:2;                  /* Additional Fragment Size used to indicate, in units of 64 bytes, the minimum number of bytes over 64 bytes required in non-final fragments of preempted frames. The minimum non-final fragment size is (AFSZ +1) * 64 bytes */
    vuint32_t _unused_2:6;             /* Reserved. */
    vuint32_t PEC:5;                   /* Preemption Classification When set indicates the corresponding Queue must be classified as preemptable, when '0' Queue is classified as express. When both EST (Qbv) and Preemption are enabled, Queue-0 is always assumed to be preemptable. When EST (Qbv) is enabled Queues categorized as preemptable here are always assumed to be in "Open" state in the Gate Control List. */
    vuint32_t _unused_13:3;            /* Reserved. */
    vuint32_t _unused_16:12;           /* Reserved. */
    vuint32_t HRS:1;                   /* Hold/Release Status - 1: Indicates a Set-and-Hold-MAC operation was last executed and the pMAC is in Hold State. - 0: Indicates a Set-and-Release-MAC operation was last executed and the pMAC is in Release State. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MTL_FPE_CTRL_STS_tag;

typedef union GMAC_MTL_FPE_ADVANCE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HADV:16;                 /* Hold Advance The maximum time in nanoseconds that can elapse between issuing a HOLD to the MAC and the MAC ceasing to transmit any preemptable frame that is in the process of transmission or any preemptable frames that are queued for transmission. */
    vuint32_t RADV:16;                 /* Release Advance The maximum time in nanoseconds that can elapse between issuing a RELEASE to the MAC and the MAC being ready to resume transmission of preemptable frames, in the absence of there being any express frames available for transmission. */
  } B;
} GMAC_MTL_FPE_ADVANCE_tag;

typedef union GMAC_MTL_RXP_CONTROL_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t NVE:8;                   /* Number of valid entries in the Instruction table This control indicates the number of valid entries in the Instruction Memory. This is used in Rx parser logic to detect any programming Error. In case while parsing Table address (memory address) found to be more than this entry then NVEOVIS bit in the MTL_RXP_Interrupt_Control_Status register is set. Note: The minimum value of this should be 2. */
    vuint32_t _unused_8:8;             /* Reserved. */
    vuint32_t NPE:8;                   /* Number of parsable entries in the Instruction table This control indicates the number of parsable entries in the Instruction Memory. This is used in Rx parser logic to detect programming Error. In case number of parsed entries for a packet is more than this entry then NPEOVIS bit in the MTL_RXP_Interrupt_Control_Status register is set. */
    vuint32_t _unused_24:7;            /* Reserved. */
    vuint32_t RXPI:1;                  /* RX Parser in Idle state This status bit is set to 1 when the Rx parser is in Idle State and waiting for a new packet for processing. This bit is used as a handshake with software when parser gets disables. After disabling, when bit is set then software can update the Rx parser instruction table. */
  } B;
} GMAC_MTL_RXP_CONTROL_STATUS_tag;

typedef union GMAC_MTL_RXP_INTERRUPT_CONTROL_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t NVEOVIS:1;               /* Number of Valid Entries Overflow Interrupt Status While parsing if the Instruction address found to be more than NVE (Number of Valid Entries in MTL_RXP_Control register), then this bit is set to 1. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t NPEOVIS:1;               /* Number of Parsable Entries Overflow Interrupt Status While parsing a packet if the number of parsed entries found to be more than NPE[] (Number of Parseable Entries in MTL_RXP_Control register),then this bit is set to 1. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t FOOVIS:1;                /* Frame Offset Overflow Interrupt Status While parsing if the Instruction table entry's 'Frame Offset' found to be more than EOF offset, then then this bit is set. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t PDRFIS:1;                /* Packet Dropped due to RF Interrupt Status If the Rx Parser result says to drop the packet by setting RF=1 in the instruction memory, then this bit is set to 1. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_4:12;            /* Reserved. */
    vuint32_t NVEOVIE:1;               /* Number of Valid Entries Overflow Interrupt Enable When this bit is set, the NVEOVIS interrupt is enabled. When this bit is reset, the NVEOVIS interrupt is disabled. */
    vuint32_t NPEOVIE:1;               /* Number of Parsable Entries Overflow Interrupt Enable When this bit is set, the NPEOVIS interrupt is enabled. When this bit is reset, the NPEOVIS interrupt is disabled. */
    vuint32_t FOOVIE:1;                /* Frame Offset Overflow Interrupt Enable When this bit is set, the FOOVIS interrupt is enabled. When this bit is reset, the FOOVIS interrupt is disabled. */
    vuint32_t PDRFIE:1;                /* Packet Drop due to RF Interrupt Enable When this bit is set, the PDRFIS interrupt is enabled. When this bit is reset, the PDRFIS interrupt is disabled. */
    vuint32_t _unused_20:12;           /* Reserved. */
  } B;
} GMAC_MTL_RXP_INTERRUPT_CONTROL_STATUS_tag;

typedef union GMAC_MTL_RXP_DROP_CNT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXPDC:31;                /* Rx Parser Drop count This 31-bit counter is implemented whenever a Rx Parser Drops a packet due to RF =1. The counter is cleared when the register is read. */
    vuint32_t RXPDCOVF:1;              /* Rx Parser Drop Counter Overflow Bit When set, this bit indicates that the MTL_RXP_Drop_cnt (RXPDC) Counter field crossed the maximum limit. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
  } B;
} GMAC_MTL_RXP_DROP_CNT_tag;

typedef union GMAC_MTL_RXP_ERROR_CNT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXPEC:31;                /* Rx Parser Error count This 31-bit counter is implemented whenever a Rx Parser encounters following Error scenarios - Entry address >= NVE[] - Number Parsed Entries >= NPE[] - Entry address > EOF data entry address The counter is cleared when the register is read. */
    vuint32_t RXPECOVF:1;              /* Rx Parser Error Counter Overflow Bit When set, this bit indicates that the MTL_RXP_Error_cnt (RXPEC) Counter field crossed the maximum limit. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
  } B;
} GMAC_MTL_RXP_ERROR_CNT_tag;

typedef union GMAC_MTL_RXP_INDIRECT_ACC_CONTROL_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ADDR:10;                 /* FRP Instruction Table Offset Address This field indicates the ADDR of the 32-bit entry in Rx parser instruction table. Each entry has 128-bit (4x32-bit words). The X depends on the configurable DWC_EQOS_FRP_ENTRIES If DWC_EQOS_FRP_ENTRIES == 256 , then X = 9 If DWC_EQOS_FRP_ENTRIES = 128 , then X = 8 IF DWC_EQOS_FRP_ENTRIES = 64, then X = 7 This is can be written by the software before issuing any Read/Write command. The hardware auto-increments this field after the read-write operation gets completed. */
    vuint32_t _unused_10:6;            /* Reserved. */
    vuint32_t WRRDN:1;                 /* Read Write Control When this bit is set to 1 indicates the write operation to the Rx Parser Memory. When this bit is set to 0 indicates the read operation to the Rx Parser Memory. */
    vuint32_t _unused_17:3;            /* Reserved. */
    vuint32_t RXPEIEE:1;               /* ECC Inject Error Enable for Rx Parser Memory When set, enables the ECC error injection feature. When reset, disables the ECC error injection feature. */
    vuint32_t RXPEIEC:2;               /* ECC Inject Error Control for Rx Parser Memory When EIEE bit of this register is set, following are the errors inserted based on the value encoded in this field. */
    vuint32_t _unused_23:8;            /* Reserved. */
    vuint32_t STARTBUSY:1;             /* FRP Instruction Table Access Busy When this bit is set to 1 by the software then it indicates to start the Read/Write operation from/to the Rx Parser Memory. Software should read this bit as 0 before issuing read or write request to access the Parser Memory Instructions. This bit when set to 1 indicates that hardware is busy until its gets cleared by hardware and software should not issue any read or write operation. */
  } B;
} GMAC_MTL_RXP_INDIRECT_ACC_CONTROL_STATUS_tag;

typedef union GMAC_MTL_RXP_INDIRECT_ACC_DATA_union_tag {
  vuint32_t R;
  struct {
    vuint32_t DATA:32;                 /* FRP Instruction Table Write/Read Data Software should write this register before issuing any write command. The hardware provides the read data from the Rx Parser Memory for read operation when STARTBUSY =0 after read command. */
  } B;
} GMAC_MTL_RXP_INDIRECT_ACC_DATA_tag;

typedef union GMAC_MTL_ECC_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t MTXEE:1;                 /* MTL Tx FIFO ECC Enable When set to 1, enables the ECC feature for MTL Tx FIFO memory. When set to zero, disables the ECC feature for MTL Tx FIFO memory. */
    vuint32_t MRXEE:1;                 /* MTL Rx FIFO ECC Enable When set to 1, enables the ECC feature for MTL Rx FIFO memory. When set to zero, disables the ECC feature for MTL Rx FIFO memory. */
    vuint32_t MESTEE:1;                /* MTL EST ECC Enable When set to 1, enables the ECC feature for EST memory. When set to zero, disables the ECC feature for EST memory. */
    vuint32_t MRXPEE:1;                /* MTL Rx Parser ECC Enable When set to 1, enables the ECC feature for Rx Parser memory. When set to zero, disables the ECC feature for Rx Parser memory. */
    vuint32_t _unused_4:1;             /* Reserved. */
    vuint32_t _unused_5:3;             /* Reserved. */
    vuint32_t MEEAO:1;                 /* MTL ECC Error Address Status Over-ride When set, the following error address fields will hold the last valid address where the error is detected. When reset, the following error address fields will hold the first address where the error is detected. EUEAS/ECEAS of MTL_ECC_Err_Addr_Status register. */
    vuint32_t _unused_9:23;            /* Reserved. */
  } B;
} GMAC_MTL_ECC_CONTROL_tag;

typedef union GMAC_MTL_SAFETY_INTERRUPT_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t MECIS:1;                 /* MTL ECC Correctable error Interrupt Status This bit indicates that a correctable error interrupt event in the MTL ECC safety feature. To get the exact cause of the interrupt the application should read the MTL_ECC_Interrupt_Status register. */
    vuint32_t MEUIS:1;                 /* MTL ECC Uncorrectable error Interrupt Status This bit indicates that an uncorrectable error interrupt event in the MTL ECC safety feature. To get the exact cause of the interrupt the application should read the MTL_ECC_Interrupt_Status register. */
    vuint32_t _unused_2:29;            /* Reserved. */
    vuint32_t MCSIS:1;                 /* MAC Safety Uncorrectable Interrupt Status Indicates an uncorrectable Safety-related Interrupt is set in the MAC module. MAC_DPP_FSM_Interrupt_Status register should be read when this bit is set, to get the cause of the Safety Interrupt in MAC. */
  } B;
} GMAC_MTL_SAFETY_INTERRUPT_STATUS_tag;

typedef union GMAC_MTL_ECC_INTERRUPT_ENABLE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXCEIE:1;                /* Tx memory Correctable Error Interrupt Enable When set, generates an interrupt when a correctable error is detected at the MTL Tx memory interface. It is indicated in the TXCES bit of MTL_ECC_Interrupt_Status register. When reset this event does not generates an interrupt. */
    vuint32_t _unused_1:3;             /* Reserved. */
    vuint32_t RXCEIE:1;                /* Rx memory Correctable Error Interrupt Enable When set, generates an interrupt when a correctable error is detected at the MTL Rx memory interface. It is indicated in the RXCES bit of MTL_ECC_Interrupt_Status register. When reset this event does not generates an interrupt. */
    vuint32_t _unused_5:3;             /* Reserved. */
    vuint32_t ECEIE:1;                 /* EST memory Correctable Error Interrupt Enable When set, generates an interrupt when a correctable error is detected at the MTL EST memory interface. It is indicated in the ECES bit of MTL_ECC_Interrupt_Status register. When reset this event does not generates an interrupt. */
    vuint32_t _unused_9:3;             /* Reserved. */
    vuint32_t RPCEIE:1;                /* Rx Parser memory Correctable Error Interrupt Enable When set, generates an interrupt when an uncorrectable error is detected at the Rx Parser memory interface. It is indicated in RPCES status bit of MTL_ECC_Interrupt_Status register. When reset this event does not generates an interrupt. */
    vuint32_t _unused_13:19;           /* Reserved. */
  } B;
} GMAC_MTL_ECC_INTERRUPT_ENABLE_tag;

typedef union GMAC_MTL_ECC_INTERRUPT_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXCES:1;                 /* MTL Tx memory Correctable Error Status This bit when set indicates that a correctable error is detected at the MTL Tx memory. */
    vuint32_t TXAMS:1;                 /* MTL Tx memory Address Mismatch Status This bit when set indicates that address mismatch is found for address bus of the MTL Tx memory. */
    vuint32_t TXUES:1;                 /* MTL Tx memory Uncorrectable Error Status When set, indicates that an uncorrectable error is detected at the MTL TX memory interface. */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t RXCES:1;                 /* MTL Rx memory Correctable Error Status This bit when set indicates that correctable error is detected at the MTL Rx memory. */
    vuint32_t RXAMS:1;                 /* MTL Rx memory Address Mismatch Status This bit when set indicates that address mismatch is found for address bus of the MTL Rx memory. */
    vuint32_t RXUES:1;                 /* MTL Rx memory Uncorrectable Error Status When set, indicates that an uncorrectable error is detected at the MTL Rx memory interface. */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t ECES:1;                  /* MTL EST memory Correctable Error Status This bit when set indicates that correctable error is detected at the MTL EST memory. */
    vuint32_t EAMS:1;                  /* MTL EST memory Address Mismatch Status This bit when set indicates that address mismatch is found for address bus of MTL EST memory. */
    vuint32_t EUES:1;                  /* MTL EST memory Uncorrectable Error Status When set, indicates that an uncorrectable error is detected at MTL EST memory interface. */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t RPCES:1;                 /* MTL Rx Parser memory Correctable Error Status This bit when set indicates that correctable error is detected at RX Parser memory interface. */
    vuint32_t RPAMS:1;                 /* MTL Rx Parser memory Address Mismatch Status This bit when set indicates that address mismatch is found for address bus of Rx Parser memory. */
    vuint32_t RPUES:1;                 /* Rx Parser memory Uncorrectable Error Status When set, indicates that an uncorrectable error is detected at Rx Parser memory interface. */
    vuint32_t _unused_15:17;           /* Reserved. */
  } B;
} GMAC_MTL_ECC_INTERRUPT_STATUS_tag;

typedef union GMAC_MTL_ECC_ERR_STS_RCTL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t EESRE:1;                 /* MTL ECC Error Status Read Enable When this bit is set, based on the EMS field of this register, the respective memory's error status values will be captured as described below - The correctable and uncorrectable error count values will be captured into MTL_ECC_Err_Cnt_Status register - The address location's of correctable and uncorrectable errors will be captured into MTL_ECC_Err_Addr_Status register. Hardware resets this bit when all the status values are captured into the MTL_ECC_Err_Cnt_Status and MTL_ECC_Err_Addr_Status registers. */
    vuint32_t EMS:3;                   /* MTL ECC Memory Selection When EESRE bit of this register is set, this field indicates which memory's error status value to be read. The memory selection encoding is as described below. */
    vuint32_t CCES:1;                  /* Clear Correctable Error Status When this bit is set along with EESRE bit of this register, based on the EMS field of this register, the respective memory's correctable error address and correctable error count values will be cleared upon reading. Hardware resets this bit when all the error status values are cleared. */
    vuint32_t CUES:1;                  /* Clear Uncorrectable Error Status When this bit is set along with EESRE bit of this register, based on the EMS field of this register, the respective memory's uncorrectable error address and uncorrectable error count values will be cleared upon reading. Hardware resets this bit when all the error status values are cleared. */
    vuint32_t _unused_6:26;            /* Reserved. */
  } B;
} GMAC_MTL_ECC_ERR_STS_RCTL_tag;

typedef union GMAC_MTL_ECC_ERR_ADDR_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ECEAS:16;                /* MTL ECC Correctable Error Address Status Based on the EMS field of MTL_ECC_Err_Sts_Rctl register, this field holds the respective memory's address locations for which a correctable error is detected. When MEEAO bit of MTL_ECC_Control register is set, this field holds the last valid address of memory for which correctable error or address mismatch is detected. When MEEAO bit of MTL_ECC_Control register is reset, this field holds the first address of the memory for which correctable error is detected. */
    vuint32_t EUEAS:16;                /* MTL ECC Uncorrectable Error Address Status Based on the EMS field of MTL_ECC_Err_Sts_Rctl register, this field holds the respective memory's address locations for which an uncorrectable error or address mismatch is detected. When MEEAO bit of MTL_ECC_Control register is set, this field holds the last valid address of memory for which either an uncorrectable error or an address mismatch is detected. When MEEAO bit of MTL_ECC_Control register is reset, this field holds the first address of the memory for which either an uncorrectable error or address mismatch is detected. */
  } B;
} GMAC_MTL_ECC_ERR_ADDR_STATUS_tag;

typedef union GMAC_MTL_ECC_ERR_CNTR_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ECECS:8;                 /* MTL ECC Correctable Error Counter Status Based on the EMS field of MTL_ECC_Err_Cntr_Rctl register, this field holds the respective memory's correctable error count value. */
    vuint32_t _unused_8:8;             /* Reserved. */
    vuint32_t EUECS:4;                 /* MTL ECC Uncorrectable Error Counter Status Based on the EMS field of MTL_ECC_Err_Cntr_Rctl register, this field holds the respective memory's uncorrectable error count value. */
    vuint32_t _unused_20:12;           /* Reserved. */
  } B;
} GMAC_MTL_ECC_ERR_CNTR_STATUS_tag;

typedef union GMAC_MTL_DPP_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t EDPP:1;                  /* Enable Data path Parity Protection When set to 1, enables the parity protection for EQOS datapath by generating and checking the parity on EQOS datapath. When set to 0, disables the parity protection for EQOS datapath. */
    vuint32_t OPE:1;                   /* Odd Parity Enable When set to 1, enables odd parity protection on all the external interfaces and when set to 0, enables even parity protection on all the external interfaces. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t IPEID:1;                 /* Insert Parity Error in Interface Data parity generator When set to 1, parity bit of first valid input data generated by the Interface data parity generator (or at PG1 as shown in Fig.Transmit data path parity protection) is flipped. Following are the input data bus on which parity bits are generated based on configuration selected In AHB Config, hrdata_i In AXI config, rdata_m_i In DMA Config, mdc_rdata_i In MTL Config, ati_data_i Hardware will clear this bit once the respective parity bit is flipped. */
    vuint32_t IPEMC:1;                 /* Insert Parity Error in MTL checksum parity generator When set to 1, parity bit of first valid data generated by the MTL checksum parity generator (or at PG5 as shown in Fig.Transmit data path parity protection) is flipped. Hardware will clear this bit once the respective parity bit is flipped. */
    vuint32_t IPEMTS:1;                /* Insert Parity Error in MTL Tx Status parity generator When set to 1, parity bit of first valid data generated by the MTL Tx Status parity generator (or at PG6 as shown in Fig.Transmit data path parity protection) is flipped. Hardware will clear this bit once respective parity bit is flipped. */
    vuint32_t IPEMRF:1;                /* Insert Parity Error in MTL Rx FIFO read control parity generator When set to 1, parity bit of first valid data generated by the MTL Rx FIFO read control parity generator (or at PG7 as shown in Fig.Receive data path parity protection) is flipped. Hardware will clear this bit once respective parity bit is flipped. */
    vuint32_t IPEDDC:1;                /* Insert Parity Error in DMA DTX Control word parity generator When set to 1, parity bit of first valid data generated by the DMA DTX Control word parity generator (or at PG2 as shown in Fig.Transmit data path parity protection) is flipped. Hardware will clear this bit once respective parity bit is flipped. */
    vuint32_t _unused_9:1;             /* Reserved. */
    vuint32_t IPETD:1;                 /* Insert Parity error in Tx write-back Descriptor parity generator When set to 1, parity bit of first valid data generated by the DMA Tx write-back descriptor parity generator(or at PG4 as shown in Fig.Transmit data path parity protection) is flipped. Hardware will clear this bit once respective parity bit is flipped. */
    vuint32_t IPERD:1;                 /* Insert Parity error in Rx write-back Descriptor parity generator When set to 1, parity bit of first valid data generated by the DMA Rx write-back descriptor parity generator(or at PG8 as shown in Fig.Receive data path parity protection) is flipped. */
    vuint32_t _unused_12:1;            /* Reserved. */
    vuint32_t _unused_13:1;            /* Reserved. */
    vuint32_t _unused_14:18;           /* Reserved. */
  } B;
} GMAC_MTL_DPP_CONTROL_tag;

typedef union GMAC_MTL_TXQ0_OPERATION_MODE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FTQ:1;                   /* Flush Transmit Queue When this bit is set, the Tx queue controller logic is reset to its default values. Therefore, all the data in the Tx queue is lost or flushed. This bit is internally reset when the flushing operation is complete. Until this bit is reset, you should not write to the MTL_TxQ1_Operation_Mode register. The data which is already accepted by the MAC transmitter is not flushed. It is scheduled for transmission and results in underflow and runt packet transmission. Note: The flush operation is complete only when the Tx queue is empty and the application has accepted the pending Tx Status of all transmitted packets. To complete this flush operation, the PHY Tx clock (clk_tx_i) should be active. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TSF:1;                   /* Transmit Store and Forward When this bit is set, the transmission starts when a full packet resides in the MTL Tx queue. When this bit is set, the TTC values specified in Bits[6:4] of this register are ignored. This bit should be changed only when the transmission is stopped. */
    vuint32_t TXQEN:2;                 /* Transmit Queue Enable This field is used to enable/disable the transmit queue 0. - 2'b00: Not enabled - 2'b01: Reserved - 2'b10: Enabled - 2'b11: Reserved This field is Read Only in Single Queue configurations and Read Write in Multiple Queue configurations. Note: In multiple Tx queues configuration, all the queues are disabled by default. Enable the Tx queue by programming this field. */
    vuint32_t TTC:3;                   /* Transmit Threshold Control These bits control the threshold level of the MTL Tx Queue. The transmission starts when the packet size within the MTL Tx Queue is larger than the threshold. In addition, full packets with length less than the threshold are also transmitted. These bits are used only when the TSF bit is reset. */
    vuint32_t _unused_7:9;             /* Reserved. */
    vuint32_t TQS:7;                   /* Transmit Queue Size This field indicates the size of the allocated Transmit queues in blocks of 256 bytes. The TQS field is read-write only if the number of Tx Queues more than one, the reset value is 0x0 and indicates size of 256 bytes. When the number of Tx Queues is one, the field is read-only and the configured TX FIFO size in blocks of 256 bytes is reflected in the reset value. The width of this field depends on the Tx memory size selected in your configuration. For example, if the memory size is 2048, the width of this field is 3 bits: LOG2(2048/256) = LOG2(8) = 3 bits */
    vuint32_t _unused_23:9;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ0_OPERATION_MODE_tag;

typedef union GMAC_MTL_TXQ0_UNDERFLOW_union_tag {
  vuint32_t R;
  struct {
    vuint32_t UFFRMCNT:11;             /* Underflow Packet Counter This field indicates the number of packets aborted by the controller because of Tx Queue Underflow. This counter is incremented each time the MAC aborts outgoing packet because of underflow. The counter is cleared when this register is read with mci_be_i[0] at 1'b1. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t UFCNTOVF:1;              /* Overflow Bit for Underflow Packet Counter This bit is set every time the Tx queue Underflow Packet Counter field overflows, that is, it has crossed the maximum count. In such a scenario, the overflow packet counter is reset to all-zeros and this bit indicates that the rollover happened. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_12:20;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ0_UNDERFLOW_tag;

typedef union GMAC_MTL_TXQ0_DEBUG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXQPAUSED:1;             /* Transmit Queue in Pause When this bit is high and the Rx flow control is enabled, it indicates that the Tx Queue is in the Pause condition (in the full-duplex only mode) because of the following: - Reception of the PFC packet for the priorities assigned to the Tx Queue when PFC is enabled - Reception of 802.3x Pause packet when PFC is disabled */
    vuint32_t TRCSTS:2;                /* MTL Tx Queue Read Controller Status This field indicates the state of the Tx Queue Read Controller: */
    vuint32_t TWCSTS:1;                /* MTL Tx Queue Write Controller Status When high, this bit indicates that the MTL Tx Queue Write Controller is active, and it is transferring the data to the Tx Queue. */
    vuint32_t TXQSTS:1;                /* MTL Tx Queue Not Empty Status When this bit is high, it indicates that the MTL Tx Queue is not empty and some data is left for transmission. */
    vuint32_t TXSTSFSTS:1;             /* MTL Tx Status FIFO Full Status When high, this bit indicates that the MTL Tx Status FIFO is full. Therefore, the MTL cannot accept any more packets for transmission. */
    vuint32_t _unused_6:10;            /* Reserved. */
    vuint32_t PTXQ:3;                  /* Number of Packets in the Transmit Queue This field indicates the current number of packets in the Tx Queue. When the DTXSTS bit of MTL_Operation_Mode register is set to 1, this field does not reflect the number of packets in the Transmit queue. */
    vuint32_t _unused_19:1;            /* Reserved. */
    vuint32_t STXSTSF:3;               /* Number of Status Words in Tx Status FIFO of Queue This field indicates the current number of status in the Tx Status FIFO of this queue. When the DTXSTS bit of MTL_Operation_Mode register is set to 1, this field does not reflect the number of status words in Tx Status FIFO. */
    vuint32_t _unused_23:9;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ0_DEBUG_tag;

typedef union GMAC_MTL_TXQ0_ETS_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ABS:24;                  /* Average Bits per Slot This field contains the average transmitted bits per slot. When the DCB operation is enabled for Queue 0, this field is computed over every 10 million bit times slot (4 ms in 2500 Mbps; 10 ms in 1000 Mbps; 100 ms in 100 Mbps). The maximum value is 0x989680. */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ0_ETS_STATUS_tag;

typedef union GMAC_MTL_TXQ0_QUANTUM_WEIGHT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ISCQW:21;                /* Quantum or Weights When the DCB operation is enabled with DWRR algorithm for Queue 0 traffic, this field contains the quantum value in bytes to be added to credit during every queue scanning cycle. The maximum value is 0x1312D0 bytes. When DCB operation is enabled with WFQ algorithm for Queue 0 traffic, this field contains the weight for this queue. The maximum value is 0x3FFF where weight of 0 indicates 100% bandwidth. Bits[20:14] must be written to zero. The higher the programmed weights lesser the bandwidth allocated for the particular Transmit Queue. This is because the weights are used to compute the packet finish time (weights*packet_size). Lesser the finish time, higher the probability of the packet getting scheduled first and using more bandwidth. When DCB operation or generic queuing operation is enabled with WRR algorithm for Queue 0 traffic, this field contains the weight for this queue. The maximum value is 0x64. Bits [20:7] must be written to zero. */
    vuint32_t _unused_21:11;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ0_QUANTUM_WEIGHT_tag;

typedef union GMAC_MTL_Q0_INTERRUPT_CONTROL_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXUNFIS:1;               /* Transmit Queue Underflow Interrupt Status This bit indicates that the Transmit Queue had an underflow while transmitting the packet. Transmission is suspended and an Underflow Error TDES3[2] is set. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t ABPSIS:1;                /* Average Bits Per Slot Interrupt Status When set, this bit indicates that the MAC has updated the ABS value. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_2:6;             /* Reserved. */
    vuint32_t TXUIE:1;                 /* Transmit Queue Underflow Interrupt Enable When this bit is set, the Transmit Queue Underflow interrupt is enabled. When this bit is reset, the Transmit Queue Underflow interrupt is disabled. */
    vuint32_t ABPSIE:1;                /* Average Bits Per Slot Interrupt Enable When this bit is set, the MAC asserts the sbd_intr_o or mci_intr_o interrupt when the average bits per slot status is updated. When this bit is cleared, the interrupt is not asserted for such an event. */
    vuint32_t _unused_10:6;            /* Reserved. */
    vuint32_t RXOVFIS:1;               /* Receive Queue Overflow Interrupt Status This bit indicates that the Receive Queue had an overflow while receiving the packet. If a partial packet is transferred to the application, the overflow status is set in RDES3[21]. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_17:7;            /* Reserved. */
    vuint32_t RXOIE:1;                 /* Receive Queue Overflow Interrupt Enable When this bit is set, the Receive Queue Overflow interrupt is enabled. When this bit is reset, the Receive Queue Overflow interrupt is disabled. */
    vuint32_t _unused_25:7;            /* Reserved. */
  } B;
} GMAC_MTL_Q0_INTERRUPT_CONTROL_STATUS_tag;

typedef union GMAC_MTL_RXQ0_OPERATION_MODE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RTC:2;                   /* Receive Queue Threshold Control These bits control the threshold level of the MTL Rx queue (in bytes): The received packet is transferred to the application or DMA when the packet size within the MTL Rx queue is larger than the threshold. In addition, full packets with length less than the threshold are automatically transferred. This field is valid only when the RSF bit is zero. This field is ignored when the RSF bit is set to 1. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t FUP:1;                   /* Forward Undersized Good Packets When this bit is set, the Rx queue forwards the undersized good packets (packets with no error and length less than 64 bytes), including pad-bytes and CRC. When this bit is reset, the Rx queue drops all packets of less than 64 bytes, unless a packet is already transferred because of the lower value of Rx Threshold, for example, RTC = 01. */
    vuint32_t FEP:1;                   /* Forward Error Packets When this bit is reset, the Rx queue drops packets with error status (CRC error, GMII_ER, watchdog timeout, or overflow). However, if the start byte (write) pointer of a packet is already transferred to the read controller side (in Threshold mode), the packet is not dropped. When this bit is set, all packets except the runt error packets are forwarded to the application or DMA. If the RSF bit is set and the Rx queue overflows when a partial packet is written, the packet is dropped irrespective of the setting of this bit. However, if the RSF bit is reset and the Rx queue overflows when a partial packet is written, a partial packet may be forwarded to the application or DMA. */
    vuint32_t RSF:1;                   /* Receive Queue Store and Forward When this bit is set, the DWC_ether_qos reads a packet from the Rx queue only after the complete packet has been written to it, ignoring the RTC field of this register. When this bit is reset, the Rx queue operates in the Threshold (cut-through) mode, subject to the threshold specified by the RTC field of this register. */
    vuint32_t DIS_TCP_EF:1;            /* Disable Dropping of TCP/IP Checksum Error Packets When this bit is set, the MAC does not drop the packets which only have the errors detected by the Receive Checksum Offload engine. Such packets have errors only in the encapsulated payload. There are no errors (including FCS error) in the Ethernet packet received by the MAC. When this bit is reset, all error packets are dropped if the FEP bit is reset. */
    vuint32_t EHFC:1;                  /* Enable Hardware Flow Control When this bit is set, the flow control signal operation, based on the fill-level of Rx queue, is enabled. When reset, the flow control operation is disabled. */
    vuint32_t RFA:6;                   /* Threshold for Activating Flow Control (in half-duplex and full-duplex These bits control the threshold (fill-level of Rx queue) at which the flow control is activated: For more information on encoding for this field, see RFD. */
    vuint32_t RFD:6;                   /* Threshold for Deactivating Flow Control (in half-duplex and full-duplex modes) These bits control the threshold (fill-level of Rx queue) at which the flow control is de-asserted after activation: - 0: Full minus 1 KB, that is, FULL 1 KB - 1: Full minus 1.5 KB, that is, FULL 1.5 KB - 2: Full minus 2 KB, that is, FULL 2 KB - 3: Full minus 2.5 KB, that is, FULL 2.5 KB - ... - 62: Full minus 32 KB, that is, FULL 32 KB - 63: Full minus 32.5 KB, that is, FULL 32.5 KB The de-assertion is effective only after flow control is asserted. Note: The value must be programmed in such a way to make sure that the threshold is a positive number. When the EHFC is set high, these values are applicable only when the Rx queue size determined by the RQS field of this register, is equal to or greater than 4 KB. For a given queue size, the values ranges between 0 and the encoding for FULL minus (QSIZE - 0.5 KB) and all other values are illegal. Here the term FULL and QSIZE refers to the queue size determined by the RQS field of this register. The width of this field depends on RX FIFO size selected during the configuration. Remaining bits are reserved and read only. */
    vuint32_t RQS:7;                   /* Receive Queue Size This field indicates the size of the allocated Receive queues in blocks of 256 bytes. The RQS field is read-write only if the number of Rx Queues more than one, the reset value is 0x0 and indicates size of 256 bytes. When the number of Rx Queues is one, the field is read-only and the configured RX FIFO size in blocks of 256 bytes is reflected in the reset value. The width of this field depends on the Rx memory size selected in your configuration. For example, if the memory size is 2048, the width of this field is 3 bits: LOG2(2048/256) = LOG2(8) = 3 bits */
    vuint32_t _unused_27:5;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ0_OPERATION_MODE_tag;

typedef union GMAC_MTL_RXQ0_MISSED_PACKET_OVERFLOW_CNT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t OVFPKTCNT:11;            /* Overflow Packet Counter This field indicates the number of packets discarded by the DWC_ether_qos because of Receive queue overflow. This counter is incremented each time the DWC_ether_qos discards an incoming packet because of overflow. This counter is reset when this register is read with mci_be_i[0] at 1'b1. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t OVFCNTOVF:1;             /* Overflow Counter Overflow Bit When set, this bit indicates that the Rx Queue Overflow Packet Counter field crossed the maximum limit. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_12:4;            /* Reserved. */
    vuint32_t MISPKTCNT:11;            /* Missed Packet Counter This field indicates the number of packets missed by the DWC_ether_qos because the application asserted ari_pkt_flush_i[] for this queue. This counter is reset when this register is read with mci_be_i[0] at 1b1. This counter is incremented by 1 when the DMA discards the packet because of buffer unavailability. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t MISCNTOVF:1;             /* Missed Packet Counter Overflow Bit When set, this bit indicates that the Rx Queue Missed Packet Counter crossed the maximum limit. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ0_MISSED_PACKET_OVERFLOW_CNT_tag;

typedef union GMAC_MTL_RXQ0_DEBUG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RWCSTS:1;                /* MTL Rx Queue Write Controller Active Status When high, this bit indicates that the MTL Rx queue Write controller is active, and it is transferring a received packet to the Rx Queue. */
    vuint32_t RRCSTS:2;                /* MTL Rx Queue Read Controller State This field gives the state of the Rx queue Read controller: */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t RXQSTS:2;                /* MTL Rx Queue Fill-Level Status This field gives the status of the fill-level of the Rx Queue: */
    vuint32_t _unused_6:10;            /* Reserved. */
    vuint32_t PRXQ:14;                 /* Number of Packets in Receive Queue This field indicates the current number of packets in the Rx Queue. The theoretical maximum value for this field is 256KB/16B = 16K Packets, that is, Max_Queue_Size/Min_Packet_Size. */
    vuint32_t _unused_30:2;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ0_DEBUG_tag;

typedef union GMAC_MTL_RXQ0_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXQ_WEGT:3;              /* Receive Queue Weight This field indicates the weight assigned to the Rx Queue 0. The weight is used as the number of continuous PBL or packets requests (depending on the RXQ_FRM_ARBIT) allocated to the queue in one arbitration cycle. */
    vuint32_t RXQ_FRM_ARBIT:1;         /* Receive Queue Packet Arbitration When this bit is set, the DWC_ether_qos drives the packet data to the ARI interface such that the entire packet data of currently-selected queue is transmitted before switching to other queue. When this bit is reset, the DWC_ether_qos drives the packet data to the ARI interface such that the following amount of data of currently-selected queue is transmitted before switching to other queue: - PBL amount of data (indicated by ari_qN_pbl_i[]) or - Complete data of a packet The status and the timestamp are not a part of the PBL data. Therefore, the DWC_ether_qos drives the complete status (including timestamp status) during first PBL request for the packet (in store-and-forward mode) or the last PBL request for the packet (in Threshold mode). */
    vuint32_t _unused_4:28;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ0_CONTROL_tag;

typedef union GMAC_MTL_TXQ1_OPERATION_MODE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FTQ:1;                   /* Flush Transmit Queue When this bit is set, the Tx queue controller logic is reset to its default values. Therefore, all the data in the Tx queue is lost or flushed. This bit is internally reset when the flushing operation is complete. Until this bit is reset, you should not write to the MTL_TxQ1_Operation_Mode register. The data which is already accepted by the MAC transmitter is not flushed. It is scheduled for transmission and results in underflow and runt packet transmission. Note: The flush operation is complete only when the Tx queue is empty and the application has accepted the pending Tx Status of all transmitted packets. To complete this flush operation, the PHY Tx clock (clk_tx_i) should be active. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TSF:1;                   /* Transmit Store and Forward When this bit is set, the transmission starts when a full packet resides in the MTL Tx queue. When this bit is set, the TTC values specified in Bits[6:4] of this register are ignored. This bit should be changed only when the transmission is stopped. */
    vuint32_t TXQEN:2;                 /* Transmit Queue Enable This field is used to enable/disable the transmit queue 0. - 2'b00: Not enabled - 2'b01: Enable in AV mode - 2'b10: Enabled - 2'b11: Reserved Note: In multiple Tx queues configuration, all the queues are disabled by default. Enable the Tx queue by programming this field. */
    vuint32_t TTC:3;                   /* Transmit Threshold Control These bits control the threshold level of the MTL Tx Queue. The transmission starts when the packet size within the MTL Tx Queue is larger than the threshold. In addition, full packets with length less than the threshold are also transmitted. These bits are used only when the TSF bit is reset. */
    vuint32_t _unused_7:9;             /* Reserved. */
    vuint32_t TQS:7;                   /* Transmit Queue Size This field indicates the size of the allocated Transmit queues in blocks of 256 bytes. The TQS field is read-write only if the number of Tx Queues more than one, the reset value is 0x0 and indicates size of 256 bytes. When the number of Tx Queues is one, the field is read-only and the configured TX FIFO size in blocks of 256 bytes is reflected in the reset value. The width of this field depends on the Tx memory size selected in your configuration. For example, if the memory size is 2048, the width of this field is 3 bits: LOG2(2048/256) = LOG2(8) = 3 bits */
    vuint32_t _unused_23:9;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ1_OPERATION_MODE_tag;

typedef union GMAC_MTL_TXQ1_UNDERFLOW_union_tag {
  vuint32_t R;
  struct {
    vuint32_t UFFRMCNT:11;             /* Underflow Packet Counter This field indicates the number of packets aborted by the controller because of Tx Queue Underflow. This counter is incremented each time the MAC aborts outgoing packet because of underflow. The counter is cleared when this register is read with mci_be_i[0] at 1'b1. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t UFCNTOVF:1;              /* Overflow Bit for Underflow Packet Counter This bit is set every time the Tx queue Underflow Packet Counter field overflows, that is, it has crossed the maximum count. In such a scenario, the overflow packet counter is reset to all-zeros and this bit indicates that the rollover happened. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_12:20;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ1_UNDERFLOW_tag;

typedef union GMAC_MTL_TXQ1_DEBUG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXQPAUSED:1;             /* Transmit Queue in Pause When this bit is high and the Rx flow control is enabled, it indicates that the Tx Queue is in the Pause condition (in the full-duplex only mode) because of the following: - Reception of the PFC packet for the priorities assigned to the Tx Queue when PFC is enabled - Reception of 802.3x Pause packet when PFC is disabled */
    vuint32_t TRCSTS:2;                /* MTL Tx Queue Read Controller Status This field indicates the state of the Tx Queue Read Controller: */
    vuint32_t TWCSTS:1;                /* MTL Tx Queue Write Controller Status When high, this bit indicates that the MTL Tx Queue Write Controller is active, and it is transferring the data to the Tx Queue. */
    vuint32_t TXQSTS:1;                /* MTL Tx Queue Not Empty Status When this bit is high, it indicates that the MTL Tx Queue is not empty and some data is left for transmission. */
    vuint32_t TXSTSFSTS:1;             /* MTL Tx Status FIFO Full Status When high, this bit indicates that the MTL Tx Status FIFO is full. Therefore, the MTL cannot accept any more packets for transmission. */
    vuint32_t _unused_6:10;            /* Reserved. */
    vuint32_t PTXQ:3;                  /* Number of Packets in the Transmit Queue This field indicates the current number of packets in the Tx Queue. When the DTXSTS bit of MTL_Operation_Mode register is set to 1, this field does not reflect the number of packets in the Transmit queue. */
    vuint32_t _unused_19:1;            /* Reserved. */
    vuint32_t STXSTSF:3;               /* Number of Status Words in Tx Status FIFO of Queue This field indicates the current number of status in the Tx Status FIFO of this queue. When the DTXSTS bit of MTL_Operation_Mode register is set to 1, this field does not reflect the number of status words in Tx Status FIFO. */
    vuint32_t _unused_23:9;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ1_DEBUG_tag;

typedef union GMAC_MTL_TXQ1_ETS_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;             /* Reserved. */
    vuint32_t AVALG:1;                 /* AV Algorithm When Queue 1 is programmed for AV, this field configures the scheduling algorithm for this queue: This bit when set, indicates credit based shaper algorithm (CBS) is selected for Queue 1 traffic. When reset, strict priority is selected. */
    vuint32_t CC:1;                    /* Credit Control When this bit is set, the accumulated credit parameter in the credit-based shaper algorithm logic is not reset to zero when there is positive credit and no packet to transmit in Channel 1. The credit accumulates even when there is no packet waiting in Channel 1 and another channel is transmitting. When this bit is reset, the accumulated credit parameter in the credit-based shaper algorithm logic is set to zero when there is positive credit and no packet to transmit in Channel 1. When there is no packet waiting in Channel 1 and other channel is transmitting, no credit is accumulated. */
    vuint32_t SLC:3;                   /* Slot Count If the credit-based shaper algorithm is enabled, the software can program the number of slots (of duration programmed in DMA_CH[n]_Slot_Interval register) over which the average transmitted bits per slot, provided in the MTL_TxQ[n]_ETS_Status register, need to be computed for Queue. The encoding is as follows: */
    vuint32_t _unused_7:25;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ1_ETS_CONTROL_tag;

typedef union GMAC_MTL_TXQ1_ETS_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ABS:24;                  /* Average Bits per Slot This field contains the average transmitted bits per slot. If AV operation is enabled, this field is computed over number of slots, programmed in the SLC field of MTL_TxQ[n]_ETS_CONTROL register. The maximum value of this field is 0x6_4000 in 100 Mbps, 0x3E_8000 in 1000 Mbps and 9C_4000 in 2500 Mbps mode respectively. When the DCB operation is enabled for Queue, this field is computed over every 10 million bit times slot (4 ms in 2500 Mbps; 10 ms in 1000 Mbps; 100 ms in 100 Mbps). The maximum value is 0x989680. */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ1_ETS_STATUS_tag;

typedef union GMAC_MTL_TXQ1_QUANTUM_WEIGHT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ISCQW:21;                /* idleSlopeCredit, Quantum or Weights - idleSlopeCredit When AV feature is enabled, this field contains the idleSlopeCredit value required for the credit-based shaper algorithm for Queue 1. This is the rate of change of credit in bits per cycle (40 ns for 100 Mbps; 8 ns for 1000 Mbps; 3.2 ns for 2500 Mbps) when the credit is increasing. The software should program this field with computed credit in bits per cycle scaled by 1,024. The maximum value is portTransmitRate, that is, 0x2000 in 1000/2500 Mbps mode and 0x1000 in 100 Mbps mode. Bits[20:14] must be written to zero. - Quantum When the DCB operation is enabled with DWRR algorithm for Queue 1 traffic, this field contains the quantum value in bytes to be added to credit during every queue scanning cycle. The maximum value is 0x1312D0 bytes. - Weights When DCB operation is enabled with WFQ algorithm for Queue 1 traffic, this field contains the weight for this queue. The maximum value is 0x3FFF where weight of 0 indicates 100% bandwidth. Bits[20:14] must be written to zero. When DCB operation or generic queuing operation is enabled with WRR algorithm for Queue 1 traffic, this field contains the weight for this queue. The maximum value is 0x64. Bits [20:7] must be written to zero. - Note 1: In multiple Queue configuration this field in respective per queue register must be programmed to some non-zero value when multiple queues are enabled or single queue other than Q0 is enabled. This field need not be programmed when only Q0 is enabled. In general, when WRR algorithm is selected a non-zero value must be programmed on both Receive and Transmit. In Receive, the register is MTL_Operation_Mode register. - Note 2: For WFQ algorithm, higher the programmed weights lesser the bandwidth allocated for that Transmit Queue. The finish time is not a function of particular packet alone but it is as per the formula: (previous_finish_time of particular Transmit Queue + (weights*packet_size)) - Note 3: The weights programmed do not correspond to the number of packets but the fraction of bandwidth or time allocated for particular queue w.r.t. total BW or time. */
    vuint32_t _unused_21:11;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ1_QUANTUM_WEIGHT_tag;

typedef union GMAC_MTL_TXQ1_SENDSLOPECREDIT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t SSC:14;                  /* sendSlopeCredit Value When AV operation is enabled, this field contains the sendSlopeCredit value required for credit-based shaper algorithm for Queue 1. This is the rate of change of credit in bits per cycle (40 ns, 8 ns and 3.2 ns for 100 Mbps, 1000 Mbps and 2500 Mbps respectively) when the credit is decreasing. The software should program this field with computed credit in bits per cycle scaled by 1,024. The maximum value is portTransmitRate, that is, 0x2000 in 1000/2500 Mbps mode and 0x1000 in 100 Mbps mode. This field should be programmed with absolute sendSlopeCredit value. The credit-based shaper logic subtracts it from the accumulated credit when Channel 1 is selected for transmission. */
    vuint32_t _unused_14:18;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ1_SENDSLOPECREDIT_tag;

typedef union GMAC_MTL_TXQ1_HICREDIT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HC:29;                   /* hiCredit Value When the AV feature is enabled, this field contains the hiCredit value required for the credit-based shaper algorithm. This is the maximum value that can be accumulated in the credit parameter. This is specified in bits scaled by 1,024. The maximum value is maxInterferenceSize, that is, best-effort maximum packet size (16,384 bytes or 131,072 bits). The value to be specified is 131,072 * 1,024 = 134,217,728 or 0x0800_0000. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ1_HICREDIT_tag;

typedef union GMAC_MTL_TXQ1_LOCREDIT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t LC:29;                   /* loCredit Value When AV operation is enabled, this field contains the loCredit value required for the credit-based shaper algorithm. This is the minimum value that can be accumulated in the credit parameter. This is specified in bits scaled by 1,024. The maximum value to be programmed is corresponds to twice the maxFrameSize transmitted from this queue. If the maxFrameSize is 8192 bytes, then (8192*2) * 8 * 1024 = 134,217,728 or 0x0800_0000. Because it is a negative value, the programmed value is 2's complement of the value, that is, 0x1800_0000. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ1_LOCREDIT_tag;

typedef union GMAC_MTL_Q1_INTERRUPT_CONTROL_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXUNFIS:1;               /* Transmit Queue Underflow Interrupt Status This bit indicates that the Transmit Queue had an underflow while transmitting the packet. Transmission is suspended and an Underflow Error TDES3[2] is set. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t ABPSIS:1;                /* Average Bits Per Slot Interrupt Status When set, this bit indicates that the MAC has updated the ABS value. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_2:6;             /* Reserved. */
    vuint32_t TXUIE:1;                 /* Transmit Queue Underflow Interrupt Enable When this bit is set, the Transmit Queue Underflow interrupt is enabled. When this bit is reset, the Transmit Queue Underflow interrupt is disabled. */
    vuint32_t ABPSIE:1;                /* Average Bits Per Slot Interrupt Enable When this bit is set, the MAC asserts the sbd_intr_o or mci_intr_o interrupt when the average bits per slot status is updated. When this bit is cleared, the interrupt is not asserted for such an event. */
    vuint32_t _unused_10:6;            /* Reserved. */
    vuint32_t RXOVFIS:1;               /* Receive Queue Overflow Interrupt Status This bit indicates that the Receive Queue had an overflow while receiving the packet. If a partial packet is transferred to the application, the overflow status is set in RDES3[21]. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_17:7;            /* Reserved. */
    vuint32_t RXOIE:1;                 /* Receive Queue Overflow Interrupt Enable When this bit is set, the Receive Queue Overflow interrupt is enabled. When this bit is reset, the Receive Queue Overflow interrupt is disabled. */
    vuint32_t _unused_25:7;            /* Reserved. */
  } B;
} GMAC_MTL_Q1_INTERRUPT_CONTROL_STATUS_tag;

typedef union GMAC_MTL_RXQ1_OPERATION_MODE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RTC:2;                   /* Receive Queue Threshold Control These bits control the threshold level of the MTL Rx queue (in bytes): The received packet is transferred to the application or DMA when the packet size within the MTL Rx queue is larger than the threshold. In addition, full packets with length less than the threshold are automatically transferred. This field is valid only when the RSF bit is zero. This field is ignored when the RSF bit is set to 1. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t FUP:1;                   /* Forward Undersized Good Packets When this bit is set, the Rx queue forwards the undersized good packets (packets with no error and length less than 64 bytes), including pad-bytes and CRC. When this bit is reset, the Rx queue drops all packets of less than 64 bytes, unless a packet is already transferred because of the lower value of Rx Threshold, for example, RTC = 01. */
    vuint32_t FEP:1;                   /* Forward Error Packets When this bit is reset, the Rx queue drops packets with error status (CRC error, GMII_ER, watchdog timeout, or overflow). However, if the start byte (write) pointer of a packet is already transferred to the read controller side (in Threshold mode), the packet is not dropped. When this bit is set, all packets except the runt error packets are forwarded to the application or DMA. If the RSF bit is set and the Rx queue overflows when a partial packet is written, the packet is dropped irrespective of the setting of this bit. However, if the RSF bit is reset and the Rx queue overflows when a partial packet is written, a partial packet may be forwarded to the application or DMA. */
    vuint32_t RSF:1;                   /* Receive Queue Store and Forward When this bit is set, the DWC_ether_qos reads a packet from the Rx queue only after the complete packet has been written to it, ignoring the RTC field of this register. When this bit is reset, the Rx queue operates in the Threshold (cut-through) mode, subject to the threshold specified by the RTC field of this register. */
    vuint32_t DIS_TCP_EF:1;            /* Disable Dropping of TCP/IP Checksum Error Packets When this bit is set, the MAC does not drop the packets which only have the errors detected by the Receive Checksum Offload engine. Such packets have errors only in the encapsulated payload. There are no errors (including FCS error) in the Ethernet packet received by the MAC. When this bit is reset, all error packets are dropped if the FEP bit is reset. */
    vuint32_t EHFC:1;                  /* Enable Hardware Flow Control When this bit is set, the flow control signal operation, based on the fill-level of Rx queue, is enabled. When reset, the flow control operation is disabled. */
    vuint32_t RFA:6;                   /* Threshold for Activating Flow Control (in half-duplex and full-duplex These bits control the threshold (fill-level of Rx queue) at which the flow control is activated: For more information on encoding for this field, see RFD. */
    vuint32_t RFD:6;                   /* Threshold for Deactivating Flow Control (in half-duplex and full-duplex modes) These bits control the threshold (fill-level of Rx queue) at which the flow control is de-asserted after activation: - 0: Full minus 1 KB, that is, FULL 1 KB - 1: Full minus 1.5 KB, that is, FULL 1.5 KB - 2: Full minus 2 KB, that is, FULL 2 KB - 3: Full minus 2.5 KB, that is, FULL 2.5 KB - ... - 62: Full minus 32 KB, that is, FULL 32 KB - 63: Full minus 32.5 KB, that is, FULL 32.5 KB The de-assertion is effective only after flow control is asserted. Note: The value must be programmed in such a way to make sure that the threshold is a positive number. When the EHFC is set high, these values are applicable only when the Rx queue size determined by the RQS field of this register, is equal to or greater than 4 KB. For a given queue size, the values ranges between 0 and the encoding for FULL minus (QSIZE - 0.5 KB) and all other values are illegal. Here the term FULL and QSIZE refers to the queue size determined by the RQS field of this register. The width of this field depends on RX FIFO size selected during the configuration. Remaining bits are reserved and read only. */
    vuint32_t RQS:7;                   /* Receive Queue Size This field indicates the size of the allocated Receive queues in blocks of 256 bytes. The RQS field is read-write only if the number of Rx Queues more than one, the reset value is 0x0 and indicates size of 256 bytes. When the number of Rx Queues is one, the field is read-only and the configured RX FIFO size in blocks of 256 bytes is reflected in the reset value. The width of this field depends on the Rx memory size selected in your configuration. For example, if the memory size is 2048, the width of this field is 3 bits: LOG2(2048/256) = LOG2(8) = 3 bits */
    vuint32_t _unused_27:5;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ1_OPERATION_MODE_tag;

typedef union GMAC_MTL_RXQ1_MISSED_PACKET_OVERFLOW_CNT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t OVFPKTCNT:11;            /* Overflow Packet Counter This field indicates the number of packets discarded by the DWC_ether_qos because of Receive queue overflow. This counter is incremented each time the DWC_ether_qos discards an incoming packet because of overflow. This counter is reset when this register is read with mci_be_i[0] at 1'b1. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t OVFCNTOVF:1;             /* Overflow Counter Overflow Bit When set, this bit indicates that the Rx Queue Overflow Packet Counter field crossed the maximum limit. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_12:4;            /* Reserved. */
    vuint32_t MISPKTCNT:11;            /* Missed Packet Counter This field indicates the number of packets missed by the DWC_ether_qos because the application asserted ari_pkt_flush_i[] for this queue. This counter is reset when this register is read with mci_be_i[0] at 1b1. This counter is incremented by 1 when the DMA discards the packet because of buffer unavailability. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t MISCNTOVF:1;             /* Missed Packet Counter Overflow Bit When set, this bit indicates that the Rx Queue Missed Packet Counter crossed the maximum limit. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ1_MISSED_PACKET_OVERFLOW_CNT_tag;

typedef union GMAC_MTL_RXQ1_DEBUG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RWCSTS:1;                /* MTL Rx Queue Write Controller Active Status When high, this bit indicates that the MTL Rx queue Write controller is active, and it is transferring a received packet to the Rx Queue. */
    vuint32_t RRCSTS:2;                /* MTL Rx Queue Read Controller State This field gives the state of the Rx queue Read controller: */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t RXQSTS:2;                /* MTL Rx Queue Fill-Level Status This field gives the status of the fill-level of the Rx Queue: */
    vuint32_t _unused_6:10;            /* Reserved. */
    vuint32_t PRXQ:14;                 /* Number of Packets in Receive Queue This field indicates the current number of packets in the Rx Queue. The theoretical maximum value for this field is 256KB/16B = 16K Packets, that is, Max_Queue_Size/Min_Packet_Size. */
    vuint32_t _unused_30:2;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ1_DEBUG_tag;

typedef union GMAC_MTL_RXQ1_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXQ_WEGT:3;              /* Receive Queue Weight This field indicates the weight assigned to the Rx Queue 0. The weight is used as the number of continuous PBL or packets requests (depending on the RXQ_FRM_ARBIT) allocated to the queue in one arbitration cycle. */
    vuint32_t RXQ_FRM_ARBIT:1;         /* Receive Queue Packet Arbitration When this bit is set, the DWC_ether_qos drives the packet data to the ARI interface such that the entire packet data of currently-selected queue is transmitted before switching to other queue. When this bit is reset, the DWC_ether_qos drives the packet data to the ARI interface such that the following amount of data of currently-selected queue is transmitted before switching to other queue: - PBL amount of data (indicated by ari_qN_pbl_i[]) or - Complete data of a packet The status and the timestamp are not a part of the PBL data. Therefore, the DWC_ether_qos drives the complete status (including timestamp status) during first PBL request for the packet (in store-and-forward mode) or the last PBL request for the packet (in Threshold mode). */
    vuint32_t _unused_4:28;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ1_CONTROL_tag;

typedef union GMAC_MTL_TXQ2_OPERATION_MODE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FTQ:1;                   /* Flush Transmit Queue When this bit is set, the Tx queue controller logic is reset to its default values. Therefore, all the data in the Tx queue is lost or flushed. This bit is internally reset when the flushing operation is complete. Until this bit is reset, you should not write to the MTL_TxQ1_Operation_Mode register. The data which is already accepted by the MAC transmitter is not flushed. It is scheduled for transmission and results in underflow and runt packet transmission. Note: The flush operation is complete only when the Tx queue is empty and the application has accepted the pending Tx Status of all transmitted packets. To complete this flush operation, the PHY Tx clock (clk_tx_i) should be active. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TSF:1;                   /* Transmit Store and Forward When this bit is set, the transmission starts when a full packet resides in the MTL Tx queue. When this bit is set, the TTC values specified in Bits[6:4] of this register are ignored. This bit should be changed only when the transmission is stopped. */
    vuint32_t TXQEN:2;                 /* Transmit Queue Enable This field is used to enable/disable the transmit queue 0. - 2'b00: Not enabled - 2'b01: Enable in AV mode - 2'b10: Enabled - 2'b11: Reserved Note: In multiple Tx queues configuration, all the queues are disabled by default. Enable the Tx queue by programming this field. */
    vuint32_t TTC:3;                   /* Transmit Threshold Control These bits control the threshold level of the MTL Tx Queue. The transmission starts when the packet size within the MTL Tx Queue is larger than the threshold. In addition, full packets with length less than the threshold are also transmitted. These bits are used only when the TSF bit is reset. */
    vuint32_t _unused_7:9;             /* Reserved. */
    vuint32_t TQS:7;                   /* Transmit Queue Size This field indicates the size of the allocated Transmit queues in blocks of 256 bytes. The TQS field is read-write only if the number of Tx Queues more than one, the reset value is 0x0 and indicates size of 256 bytes. When the number of Tx Queues is one, the field is read-only and the configured TX FIFO size in blocks of 256 bytes is reflected in the reset value. The width of this field depends on the Tx memory size selected in your configuration. For example, if the memory size is 2048, the width of this field is 3 bits: LOG2(2048/256) = LOG2(8) = 3 bits */
    vuint32_t _unused_23:9;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ2_OPERATION_MODE_tag;

typedef union GMAC_MTL_TXQ2_UNDERFLOW_union_tag {
  vuint32_t R;
  struct {
    vuint32_t UFFRMCNT:11;             /* Underflow Packet Counter This field indicates the number of packets aborted by the controller because of Tx Queue Underflow. This counter is incremented each time the MAC aborts outgoing packet because of underflow. The counter is cleared when this register is read with mci_be_i[0] at 1'b1. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t UFCNTOVF:1;              /* Overflow Bit for Underflow Packet Counter This bit is set every time the Tx queue Underflow Packet Counter field overflows, that is, it has crossed the maximum count. In such a scenario, the overflow packet counter is reset to all-zeros and this bit indicates that the rollover happened. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_12:20;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ2_UNDERFLOW_tag;

typedef union GMAC_MTL_TXQ2_DEBUG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXQPAUSED:1;             /* Transmit Queue in Pause When this bit is high and the Rx flow control is enabled, it indicates that the Tx Queue is in the Pause condition (in the full-duplex only mode) because of the following: - Reception of the PFC packet for the priorities assigned to the Tx Queue when PFC is enabled - Reception of 802.3x Pause packet when PFC is disabled */
    vuint32_t TRCSTS:2;                /* MTL Tx Queue Read Controller Status This field indicates the state of the Tx Queue Read Controller: */
    vuint32_t TWCSTS:1;                /* MTL Tx Queue Write Controller Status When high, this bit indicates that the MTL Tx Queue Write Controller is active, and it is transferring the data to the Tx Queue. */
    vuint32_t TXQSTS:1;                /* MTL Tx Queue Not Empty Status When this bit is high, it indicates that the MTL Tx Queue is not empty and some data is left for transmission. */
    vuint32_t TXSTSFSTS:1;             /* MTL Tx Status FIFO Full Status When high, this bit indicates that the MTL Tx Status FIFO is full. Therefore, the MTL cannot accept any more packets for transmission. */
    vuint32_t _unused_6:10;            /* Reserved. */
    vuint32_t PTXQ:3;                  /* Number of Packets in the Transmit Queue This field indicates the current number of packets in the Tx Queue. When the DTXSTS bit of MTL_Operation_Mode register is set to 1, this field does not reflect the number of packets in the Transmit queue. */
    vuint32_t _unused_19:1;            /* Reserved. */
    vuint32_t STXSTSF:3;               /* Number of Status Words in Tx Status FIFO of Queue This field indicates the current number of status in the Tx Status FIFO of this queue. When the DTXSTS bit of MTL_Operation_Mode register is set to 1, this field does not reflect the number of status words in Tx Status FIFO. */
    vuint32_t _unused_23:9;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ2_DEBUG_tag;

typedef union GMAC_MTL_TXQ2_ETS_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;             /* Reserved. */
    vuint32_t AVALG:1;                 /* AV Algorithm When Queue 1 is programmed for AV, this field configures the scheduling algorithm for this queue: This bit when set, indicates credit based shaper algorithm (CBS) is selected for Queue 1 traffic. When reset, strict priority is selected. */
    vuint32_t CC:1;                    /* Credit Control When this bit is set, the accumulated credit parameter in the credit-based shaper algorithm logic is not reset to zero when there is positive credit and no packet to transmit in Channel 1. The credit accumulates even when there is no packet waiting in Channel 1 and another channel is transmitting. When this bit is reset, the accumulated credit parameter in the credit-based shaper algorithm logic is set to zero when there is positive credit and no packet to transmit in Channel 1. When there is no packet waiting in Channel 1 and other channel is transmitting, no credit is accumulated. */
    vuint32_t SLC:3;                   /* Slot Count If the credit-based shaper algorithm is enabled, the software can program the number of slots (of duration programmed in DMA_CH[n]_Slot_Interval register) over which the average transmitted bits per slot, provided in the MTL_TxQ[n]_ETS_Status register, need to be computed for Queue. The encoding is as follows: */
    vuint32_t _unused_7:25;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ2_ETS_CONTROL_tag;

typedef union GMAC_MTL_TXQ2_ETS_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ABS:24;                  /* Average Bits per Slot This field contains the average transmitted bits per slot. If AV operation is enabled, this field is computed over number of slots, programmed in the SLC field of MTL_TxQ[n]_ETS_CONTROL register. The maximum value of this field is 0x6_4000 in 100 Mbps, 0x3E_8000 in 1000 Mbps and 9C_4000 in 2500 Mbps mode respectively. When the DCB operation is enabled for Queue, this field is computed over every 10 million bit times slot (4 ms in 2500 Mbps; 10 ms in 1000 Mbps; 100 ms in 100 Mbps). The maximum value is 0x989680. */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ2_ETS_STATUS_tag;

typedef union GMAC_MTL_TXQ2_QUANTUM_WEIGHT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ISCQW:21;                /* idleSlopeCredit, Quantum or Weights - idleSlopeCredit When AV feature is enabled, this field contains the idleSlopeCredit value required for the credit-based shaper algorithm for Queue 1. This is the rate of change of credit in bits per cycle (40 ns for 100 Mbps; 8 ns for 1000 Mbps; 3.2 ns for 2500 Mbps) when the credit is increasing. The software should program this field with computed credit in bits per cycle scaled by 1,024. The maximum value is portTransmitRate, that is, 0x2000 in 1000/2500 Mbps mode and 0x1000 in 100 Mbps mode. Bits[20:14] must be written to zero. - Quantum When the DCB operation is enabled with DWRR algorithm for Queue 1 traffic, this field contains the quantum value in bytes to be added to credit during every queue scanning cycle. The maximum value is 0x1312D0 bytes. - Weights When DCB operation is enabled with WFQ algorithm for Queue 1 traffic, this field contains the weight for this queue. The maximum value is 0x3FFF where weight of 0 indicates 100% bandwidth. Bits[20:14] must be written to zero. When DCB operation or generic queuing operation is enabled with WRR algorithm for Queue 1 traffic, this field contains the weight for this queue. The maximum value is 0x64. Bits [20:7] must be written to zero. - Note 1: In multiple Queue configuration this field in respective per queue register must be programmed to some non-zero value when multiple queues are enabled or single queue other than Q0 is enabled. This field need not be programmed when only Q0 is enabled. In general, when WRR algorithm is selected a non-zero value must be programmed on both Receive and Transmit. In Receive, the register is MTL_Operation_Mode register. - Note 2: For WFQ algorithm, higher the programmed weights lesser the bandwidth allocated for that Transmit Queue. The finish time is not a function of particular packet alone but it is as per the formula: (previous_finish_time of particular Transmit Queue + (weights*packet_size)) - Note 3: The weights programmed do not correspond to the number of packets but the fraction of bandwidth or time allocated for particular queue w.r.t. total BW or time. */
    vuint32_t _unused_21:11;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ2_QUANTUM_WEIGHT_tag;

typedef union GMAC_MTL_TXQ2_SENDSLOPECREDIT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t SSC:14;                  /* sendSlopeCredit Value When AV operation is enabled, this field contains the sendSlopeCredit value required for credit-based shaper algorithm for Queue 1. This is the rate of change of credit in bits per cycle (40 ns, 8 ns and 3.2 ns for 100 Mbps, 1000 Mbps and 2500 Mbps respectively) when the credit is decreasing. The software should program this field with computed credit in bits per cycle scaled by 1,024. The maximum value is portTransmitRate, that is, 0x2000 in 1000/2500 Mbps mode and 0x1000 in 100 Mbps mode. This field should be programmed with absolute sendSlopeCredit value. The credit-based shaper logic subtracts it from the accumulated credit when Channel 1 is selected for transmission. */
    vuint32_t _unused_14:18;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ2_SENDSLOPECREDIT_tag;

typedef union GMAC_MTL_TXQ2_HICREDIT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HC:29;                   /* hiCredit Value When the AV feature is enabled, this field contains the hiCredit value required for the credit-based shaper algorithm. This is the maximum value that can be accumulated in the credit parameter. This is specified in bits scaled by 1,024. The maximum value is maxInterferenceSize, that is, best-effort maximum packet size (16,384 bytes or 131,072 bits). The value to be specified is 131,072 * 1,024 = 134,217,728 or 0x0800_0000. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ2_HICREDIT_tag;

typedef union GMAC_MTL_TXQ2_LOCREDIT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t LC:29;                   /* loCredit Value When AV operation is enabled, this field contains the loCredit value required for the credit-based shaper algorithm. This is the minimum value that can be accumulated in the credit parameter. This is specified in bits scaled by 1,024. The maximum value to be programmed is corresponds to twice the maxFrameSize transmitted from this queue. If the maxFrameSize is 8192 bytes, then (8192*2) * 8 * 1024 = 134,217,728 or 0x0800_0000. Because it is a negative value, the programmed value is 2's complement of the value, that is, 0x1800_0000. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ2_LOCREDIT_tag;

typedef union GMAC_MTL_Q2_INTERRUPT_CONTROL_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXUNFIS:1;               /* Transmit Queue Underflow Interrupt Status This bit indicates that the Transmit Queue had an underflow while transmitting the packet. Transmission is suspended and an Underflow Error TDES3[2] is set. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t ABPSIS:1;                /* Average Bits Per Slot Interrupt Status When set, this bit indicates that the MAC has updated the ABS value. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_2:6;             /* Reserved. */
    vuint32_t TXUIE:1;                 /* Transmit Queue Underflow Interrupt Enable When this bit is set, the Transmit Queue Underflow interrupt is enabled. When this bit is reset, the Transmit Queue Underflow interrupt is disabled. */
    vuint32_t ABPSIE:1;                /* Average Bits Per Slot Interrupt Enable When this bit is set, the MAC asserts the sbd_intr_o or mci_intr_o interrupt when the average bits per slot status is updated. When this bit is cleared, the interrupt is not asserted for such an event. */
    vuint32_t _unused_10:6;            /* Reserved. */
    vuint32_t RXOVFIS:1;               /* Receive Queue Overflow Interrupt Status This bit indicates that the Receive Queue had an overflow while receiving the packet. If a partial packet is transferred to the application, the overflow status is set in RDES3[21]. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_17:7;            /* Reserved. */
    vuint32_t RXOIE:1;                 /* Receive Queue Overflow Interrupt Enable When this bit is set, the Receive Queue Overflow interrupt is enabled. When this bit is reset, the Receive Queue Overflow interrupt is disabled. */
    vuint32_t _unused_25:7;            /* Reserved. */
  } B;
} GMAC_MTL_Q2_INTERRUPT_CONTROL_STATUS_tag;

typedef union GMAC_MTL_RXQ2_OPERATION_MODE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RTC:2;                   /* Receive Queue Threshold Control These bits control the threshold level of the MTL Rx queue (in bytes): The received packet is transferred to the application or DMA when the packet size within the MTL Rx queue is larger than the threshold. In addition, full packets with length less than the threshold are automatically transferred. This field is valid only when the RSF bit is zero. This field is ignored when the RSF bit is set to 1. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t FUP:1;                   /* Forward Undersized Good Packets When this bit is set, the Rx queue forwards the undersized good packets (packets with no error and length less than 64 bytes), including pad-bytes and CRC. When this bit is reset, the Rx queue drops all packets of less than 64 bytes, unless a packet is already transferred because of the lower value of Rx Threshold, for example, RTC = 01. */
    vuint32_t FEP:1;                   /* Forward Error Packets When this bit is reset, the Rx queue drops packets with error status (CRC error, GMII_ER, watchdog timeout, or overflow). However, if the start byte (write) pointer of a packet is already transferred to the read controller side (in Threshold mode), the packet is not dropped. When this bit is set, all packets except the runt error packets are forwarded to the application or DMA. If the RSF bit is set and the Rx queue overflows when a partial packet is written, the packet is dropped irrespective of the setting of this bit. However, if the RSF bit is reset and the Rx queue overflows when a partial packet is written, a partial packet may be forwarded to the application or DMA. */
    vuint32_t RSF:1;                   /* Receive Queue Store and Forward When this bit is set, the DWC_ether_qos reads a packet from the Rx queue only after the complete packet has been written to it, ignoring the RTC field of this register. When this bit is reset, the Rx queue operates in the Threshold (cut-through) mode, subject to the threshold specified by the RTC field of this register. */
    vuint32_t DIS_TCP_EF:1;            /* Disable Dropping of TCP/IP Checksum Error Packets When this bit is set, the MAC does not drop the packets which only have the errors detected by the Receive Checksum Offload engine. Such packets have errors only in the encapsulated payload. There are no errors (including FCS error) in the Ethernet packet received by the MAC. When this bit is reset, all error packets are dropped if the FEP bit is reset. */
    vuint32_t EHFC:1;                  /* Enable Hardware Flow Control When this bit is set, the flow control signal operation, based on the fill-level of Rx queue, is enabled. When reset, the flow control operation is disabled. */
    vuint32_t RFA:6;                   /* Threshold for Activating Flow Control (in half-duplex and full-duplex These bits control the threshold (fill-level of Rx queue) at which the flow control is activated: For more information on encoding for this field, see RFD. */
    vuint32_t RFD:6;                   /* Threshold for Deactivating Flow Control (in half-duplex and full-duplex modes) These bits control the threshold (fill-level of Rx queue) at which the flow control is de-asserted after activation: - 0: Full minus 1 KB, that is, FULL 1 KB - 1: Full minus 1.5 KB, that is, FULL 1.5 KB - 2: Full minus 2 KB, that is, FULL 2 KB - 3: Full minus 2.5 KB, that is, FULL 2.5 KB - ... - 62: Full minus 32 KB, that is, FULL 32 KB - 63: Full minus 32.5 KB, that is, FULL 32.5 KB The de-assertion is effective only after flow control is asserted. Note: The value must be programmed in such a way to make sure that the threshold is a positive number. When the EHFC is set high, these values are applicable only when the Rx queue size determined by the RQS field of this register, is equal to or greater than 4 KB. For a given queue size, the values ranges between 0 and the encoding for FULL minus (QSIZE - 0.5 KB) and all other values are illegal. Here the term FULL and QSIZE refers to the queue size determined by the RQS field of this register. The width of this field depends on RX FIFO size selected during the configuration. Remaining bits are reserved and read only. */
    vuint32_t RQS:7;                   /* Receive Queue Size This field indicates the size of the allocated Receive queues in blocks of 256 bytes. The RQS field is read-write only if the number of Rx Queues more than one, the reset value is 0x0 and indicates size of 256 bytes. When the number of Rx Queues is one, the field is read-only and the configured RX FIFO size in blocks of 256 bytes is reflected in the reset value. The width of this field depends on the Rx memory size selected in your configuration. For example, if the memory size is 2048, the width of this field is 3 bits: LOG2(2048/256) = LOG2(8) = 3 bits */
    vuint32_t _unused_27:5;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ2_OPERATION_MODE_tag;

typedef union GMAC_MTL_RXQ2_MISSED_PACKET_OVERFLOW_CNT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t OVFPKTCNT:11;            /* Overflow Packet Counter This field indicates the number of packets discarded by the DWC_ether_qos because of Receive queue overflow. This counter is incremented each time the DWC_ether_qos discards an incoming packet because of overflow. This counter is reset when this register is read with mci_be_i[0] at 1'b1. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t OVFCNTOVF:1;             /* Overflow Counter Overflow Bit When set, this bit indicates that the Rx Queue Overflow Packet Counter field crossed the maximum limit. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_12:4;            /* Reserved. */
    vuint32_t MISPKTCNT:11;            /* Missed Packet Counter This field indicates the number of packets missed by the DWC_ether_qos because the application asserted ari_pkt_flush_i[] for this queue. This counter is reset when this register is read with mci_be_i[0] at 1b1. This counter is incremented by 1 when the DMA discards the packet because of buffer unavailability. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t MISCNTOVF:1;             /* Missed Packet Counter Overflow Bit When set, this bit indicates that the Rx Queue Missed Packet Counter crossed the maximum limit. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ2_MISSED_PACKET_OVERFLOW_CNT_tag;

typedef union GMAC_MTL_RXQ2_DEBUG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RWCSTS:1;                /* MTL Rx Queue Write Controller Active Status When high, this bit indicates that the MTL Rx queue Write controller is active, and it is transferring a received packet to the Rx Queue. */
    vuint32_t RRCSTS:2;                /* MTL Rx Queue Read Controller State This field gives the state of the Rx queue Read controller: */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t RXQSTS:2;                /* MTL Rx Queue Fill-Level Status This field gives the status of the fill-level of the Rx Queue: */
    vuint32_t _unused_6:10;            /* Reserved. */
    vuint32_t PRXQ:14;                 /* Number of Packets in Receive Queue This field indicates the current number of packets in the Rx Queue. The theoretical maximum value for this field is 256KB/16B = 16K Packets, that is, Max_Queue_Size/Min_Packet_Size. */
    vuint32_t _unused_30:2;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ2_DEBUG_tag;

typedef union GMAC_MTL_RXQ2_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXQ_WEGT:3;              /* Receive Queue Weight This field indicates the weight assigned to the Rx Queue 0. The weight is used as the number of continuous PBL or packets requests (depending on the RXQ_FRM_ARBIT) allocated to the queue in one arbitration cycle. */
    vuint32_t RXQ_FRM_ARBIT:1;         /* Receive Queue Packet Arbitration When this bit is set, the DWC_ether_qos drives the packet data to the ARI interface such that the entire packet data of currently-selected queue is transmitted before switching to other queue. When this bit is reset, the DWC_ether_qos drives the packet data to the ARI interface such that the following amount of data of currently-selected queue is transmitted before switching to other queue: - PBL amount of data (indicated by ari_qN_pbl_i[]) or - Complete data of a packet The status and the timestamp are not a part of the PBL data. Therefore, the DWC_ether_qos drives the complete status (including timestamp status) during first PBL request for the packet (in store-and-forward mode) or the last PBL request for the packet (in Threshold mode). */
    vuint32_t _unused_4:28;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ2_CONTROL_tag;

typedef union GMAC_MTL_TXQ3_OPERATION_MODE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FTQ:1;                   /* Flush Transmit Queue When this bit is set, the Tx queue controller logic is reset to its default values. Therefore, all the data in the Tx queue is lost or flushed. This bit is internally reset when the flushing operation is complete. Until this bit is reset, you should not write to the MTL_TxQ1_Operation_Mode register. The data which is already accepted by the MAC transmitter is not flushed. It is scheduled for transmission and results in underflow and runt packet transmission. Note: The flush operation is complete only when the Tx queue is empty and the application has accepted the pending Tx Status of all transmitted packets. To complete this flush operation, the PHY Tx clock (clk_tx_i) should be active. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TSF:1;                   /* Transmit Store and Forward When this bit is set, the transmission starts when a full packet resides in the MTL Tx queue. When this bit is set, the TTC values specified in Bits[6:4] of this register are ignored. This bit should be changed only when the transmission is stopped. */
    vuint32_t TXQEN:2;                 /* Transmit Queue Enable This field is used to enable/disable the transmit queue 0. - 2'b00: Not enabled - 2'b01: Enable in AV mode - 2'b10: Enabled - 2'b11: Reserved Note: In multiple Tx queues configuration, all the queues are disabled by default. Enable the Tx queue by programming this field. */
    vuint32_t TTC:3;                   /* Transmit Threshold Control These bits control the threshold level of the MTL Tx Queue. The transmission starts when the packet size within the MTL Tx Queue is larger than the threshold. In addition, full packets with length less than the threshold are also transmitted. These bits are used only when the TSF bit is reset. */
    vuint32_t _unused_7:9;             /* Reserved. */
    vuint32_t TQS:7;                   /* Transmit Queue Size This field indicates the size of the allocated Transmit queues in blocks of 256 bytes. The TQS field is read-write only if the number of Tx Queues more than one, the reset value is 0x0 and indicates size of 256 bytes. When the number of Tx Queues is one, the field is read-only and the configured TX FIFO size in blocks of 256 bytes is reflected in the reset value. The width of this field depends on the Tx memory size selected in your configuration. For example, if the memory size is 2048, the width of this field is 3 bits: LOG2(2048/256) = LOG2(8) = 3 bits */
    vuint32_t _unused_23:9;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ3_OPERATION_MODE_tag;

typedef union GMAC_MTL_TXQ3_UNDERFLOW_union_tag {
  vuint32_t R;
  struct {
    vuint32_t UFFRMCNT:11;             /* Underflow Packet Counter This field indicates the number of packets aborted by the controller because of Tx Queue Underflow. This counter is incremented each time the MAC aborts outgoing packet because of underflow. The counter is cleared when this register is read with mci_be_i[0] at 1'b1. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t UFCNTOVF:1;              /* Overflow Bit for Underflow Packet Counter This bit is set every time the Tx queue Underflow Packet Counter field overflows, that is, it has crossed the maximum count. In such a scenario, the overflow packet counter is reset to all-zeros and this bit indicates that the rollover happened. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_12:20;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ3_UNDERFLOW_tag;

typedef union GMAC_MTL_TXQ3_DEBUG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXQPAUSED:1;             /* Transmit Queue in Pause When this bit is high and the Rx flow control is enabled, it indicates that the Tx Queue is in the Pause condition (in the full-duplex only mode) because of the following: - Reception of the PFC packet for the priorities assigned to the Tx Queue when PFC is enabled - Reception of 802.3x Pause packet when PFC is disabled */
    vuint32_t TRCSTS:2;                /* MTL Tx Queue Read Controller Status This field indicates the state of the Tx Queue Read Controller: */
    vuint32_t TWCSTS:1;                /* MTL Tx Queue Write Controller Status When high, this bit indicates that the MTL Tx Queue Write Controller is active, and it is transferring the data to the Tx Queue. */
    vuint32_t TXQSTS:1;                /* MTL Tx Queue Not Empty Status When this bit is high, it indicates that the MTL Tx Queue is not empty and some data is left for transmission. */
    vuint32_t TXSTSFSTS:1;             /* MTL Tx Status FIFO Full Status When high, this bit indicates that the MTL Tx Status FIFO is full. Therefore, the MTL cannot accept any more packets for transmission. */
    vuint32_t _unused_6:10;            /* Reserved. */
    vuint32_t PTXQ:3;                  /* Number of Packets in the Transmit Queue This field indicates the current number of packets in the Tx Queue. When the DTXSTS bit of MTL_Operation_Mode register is set to 1, this field does not reflect the number of packets in the Transmit queue. */
    vuint32_t _unused_19:1;            /* Reserved. */
    vuint32_t STXSTSF:3;               /* Number of Status Words in Tx Status FIFO of Queue This field indicates the current number of status in the Tx Status FIFO of this queue. When the DTXSTS bit of MTL_Operation_Mode register is set to 1, this field does not reflect the number of status words in Tx Status FIFO. */
    vuint32_t _unused_23:9;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ3_DEBUG_tag;

typedef union GMAC_MTL_TXQ3_ETS_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;             /* Reserved. */
    vuint32_t AVALG:1;                 /* AV Algorithm When Queue 1 is programmed for AV, this field configures the scheduling algorithm for this queue: This bit when set, indicates credit based shaper algorithm (CBS) is selected for Queue 1 traffic. When reset, strict priority is selected. */
    vuint32_t CC:1;                    /* Credit Control When this bit is set, the accumulated credit parameter in the credit-based shaper algorithm logic is not reset to zero when there is positive credit and no packet to transmit in Channel 1. The credit accumulates even when there is no packet waiting in Channel 1 and another channel is transmitting. When this bit is reset, the accumulated credit parameter in the credit-based shaper algorithm logic is set to zero when there is positive credit and no packet to transmit in Channel 1. When there is no packet waiting in Channel 1 and other channel is transmitting, no credit is accumulated. */
    vuint32_t SLC:3;                   /* Slot Count If the credit-based shaper algorithm is enabled, the software can program the number of slots (of duration programmed in DMA_CH[n]_Slot_Interval register) over which the average transmitted bits per slot, provided in the MTL_TxQ[n]_ETS_Status register, need to be computed for Queue. The encoding is as follows: */
    vuint32_t _unused_7:25;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ3_ETS_CONTROL_tag;

typedef union GMAC_MTL_TXQ3_ETS_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ABS:24;                  /* Average Bits per Slot This field contains the average transmitted bits per slot. If AV operation is enabled, this field is computed over number of slots, programmed in the SLC field of MTL_TxQ[n]_ETS_CONTROL register. The maximum value of this field is 0x6_4000 in 100 Mbps, 0x3E_8000 in 1000 Mbps and 9C_4000 in 2500 Mbps mode respectively. When the DCB operation is enabled for Queue, this field is computed over every 10 million bit times slot (4 ms in 2500 Mbps; 10 ms in 1000 Mbps; 100 ms in 100 Mbps). The maximum value is 0x989680. */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ3_ETS_STATUS_tag;

typedef union GMAC_MTL_TXQ3_QUANTUM_WEIGHT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ISCQW:21;                /* idleSlopeCredit, Quantum or Weights - idleSlopeCredit When AV feature is enabled, this field contains the idleSlopeCredit value required for the credit-based shaper algorithm for Queue 1. This is the rate of change of credit in bits per cycle (40 ns for 100 Mbps; 8 ns for 1000 Mbps; 3.2 ns for 2500 Mbps) when the credit is increasing. The software should program this field with computed credit in bits per cycle scaled by 1,024. The maximum value is portTransmitRate, that is, 0x2000 in 1000/2500 Mbps mode and 0x1000 in 100 Mbps mode. Bits[20:14] must be written to zero. - Quantum When the DCB operation is enabled with DWRR algorithm for Queue 1 traffic, this field contains the quantum value in bytes to be added to credit during every queue scanning cycle. The maximum value is 0x1312D0 bytes. - Weights When DCB operation is enabled with WFQ algorithm for Queue 1 traffic, this field contains the weight for this queue. The maximum value is 0x3FFF where weight of 0 indicates 100% bandwidth. Bits[20:14] must be written to zero. When DCB operation or generic queuing operation is enabled with WRR algorithm for Queue 1 traffic, this field contains the weight for this queue. The maximum value is 0x64. Bits [20:7] must be written to zero. - Note 1: In multiple Queue configuration this field in respective per queue register must be programmed to some non-zero value when multiple queues are enabled or single queue other than Q0 is enabled. This field need not be programmed when only Q0 is enabled. In general, when WRR algorithm is selected a non-zero value must be programmed on both Receive and Transmit. In Receive, the register is MTL_Operation_Mode register. - Note 2: For WFQ algorithm, higher the programmed weights lesser the bandwidth allocated for that Transmit Queue. The finish time is not a function of particular packet alone but it is as per the formula: (previous_finish_time of particular Transmit Queue + (weights*packet_size)) - Note 3: The weights programmed do not correspond to the number of packets but the fraction of bandwidth or time allocated for particular queue w.r.t. total BW or time. */
    vuint32_t _unused_21:11;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ3_QUANTUM_WEIGHT_tag;

typedef union GMAC_MTL_TXQ3_SENDSLOPECREDIT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t SSC:14;                  /* sendSlopeCredit Value When AV operation is enabled, this field contains the sendSlopeCredit value required for credit-based shaper algorithm for Queue 1. This is the rate of change of credit in bits per cycle (40 ns, 8 ns and 3.2 ns for 100 Mbps, 1000 Mbps and 2500 Mbps respectively) when the credit is decreasing. The software should program this field with computed credit in bits per cycle scaled by 1,024. The maximum value is portTransmitRate, that is, 0x2000 in 1000/2500 Mbps mode and 0x1000 in 100 Mbps mode. This field should be programmed with absolute sendSlopeCredit value. The credit-based shaper logic subtracts it from the accumulated credit when Channel 1 is selected for transmission. */
    vuint32_t _unused_14:18;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ3_SENDSLOPECREDIT_tag;

typedef union GMAC_MTL_TXQ3_HICREDIT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HC:29;                   /* hiCredit Value When the AV feature is enabled, this field contains the hiCredit value required for the credit-based shaper algorithm. This is the maximum value that can be accumulated in the credit parameter. This is specified in bits scaled by 1,024. The maximum value is maxInterferenceSize, that is, best-effort maximum packet size (16,384 bytes or 131,072 bits). The value to be specified is 131,072 * 1,024 = 134,217,728 or 0x0800_0000. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ3_HICREDIT_tag;

typedef union GMAC_MTL_TXQ3_LOCREDIT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t LC:29;                   /* loCredit Value When AV operation is enabled, this field contains the loCredit value required for the credit-based shaper algorithm. This is the minimum value that can be accumulated in the credit parameter. This is specified in bits scaled by 1,024. The maximum value to be programmed is corresponds to twice the maxFrameSize transmitted from this queue. If the maxFrameSize is 8192 bytes, then (8192*2) * 8 * 1024 = 134,217,728 or 0x0800_0000. Because it is a negative value, the programmed value is 2's complement of the value, that is, 0x1800_0000. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ3_LOCREDIT_tag;

typedef union GMAC_MTL_Q3_INTERRUPT_CONTROL_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXUNFIS:1;               /* Transmit Queue Underflow Interrupt Status This bit indicates that the Transmit Queue had an underflow while transmitting the packet. Transmission is suspended and an Underflow Error TDES3[2] is set. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t ABPSIS:1;                /* Average Bits Per Slot Interrupt Status When set, this bit indicates that the MAC has updated the ABS value. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_2:6;             /* Reserved. */
    vuint32_t TXUIE:1;                 /* Transmit Queue Underflow Interrupt Enable When this bit is set, the Transmit Queue Underflow interrupt is enabled. When this bit is reset, the Transmit Queue Underflow interrupt is disabled. */
    vuint32_t ABPSIE:1;                /* Average Bits Per Slot Interrupt Enable When this bit is set, the MAC asserts the sbd_intr_o or mci_intr_o interrupt when the average bits per slot status is updated. When this bit is cleared, the interrupt is not asserted for such an event. */
    vuint32_t _unused_10:6;            /* Reserved. */
    vuint32_t RXOVFIS:1;               /* Receive Queue Overflow Interrupt Status This bit indicates that the Receive Queue had an overflow while receiving the packet. If a partial packet is transferred to the application, the overflow status is set in RDES3[21]. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_17:7;            /* Reserved. */
    vuint32_t RXOIE:1;                 /* Receive Queue Overflow Interrupt Enable When this bit is set, the Receive Queue Overflow interrupt is enabled. When this bit is reset, the Receive Queue Overflow interrupt is disabled. */
    vuint32_t _unused_25:7;            /* Reserved. */
  } B;
} GMAC_MTL_Q3_INTERRUPT_CONTROL_STATUS_tag;

typedef union GMAC_MTL_RXQ3_OPERATION_MODE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RTC:2;                   /* Receive Queue Threshold Control These bits control the threshold level of the MTL Rx queue (in bytes): The received packet is transferred to the application or DMA when the packet size within the MTL Rx queue is larger than the threshold. In addition, full packets with length less than the threshold are automatically transferred. This field is valid only when the RSF bit is zero. This field is ignored when the RSF bit is set to 1. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t FUP:1;                   /* Forward Undersized Good Packets When this bit is set, the Rx queue forwards the undersized good packets (packets with no error and length less than 64 bytes), including pad-bytes and CRC. When this bit is reset, the Rx queue drops all packets of less than 64 bytes, unless a packet is already transferred because of the lower value of Rx Threshold, for example, RTC = 01. */
    vuint32_t FEP:1;                   /* Forward Error Packets When this bit is reset, the Rx queue drops packets with error status (CRC error, GMII_ER, watchdog timeout, or overflow). However, if the start byte (write) pointer of a packet is already transferred to the read controller side (in Threshold mode), the packet is not dropped. When this bit is set, all packets except the runt error packets are forwarded to the application or DMA. If the RSF bit is set and the Rx queue overflows when a partial packet is written, the packet is dropped irrespective of the setting of this bit. However, if the RSF bit is reset and the Rx queue overflows when a partial packet is written, a partial packet may be forwarded to the application or DMA. */
    vuint32_t RSF:1;                   /* Receive Queue Store and Forward When this bit is set, the DWC_ether_qos reads a packet from the Rx queue only after the complete packet has been written to it, ignoring the RTC field of this register. When this bit is reset, the Rx queue operates in the Threshold (cut-through) mode, subject to the threshold specified by the RTC field of this register. */
    vuint32_t DIS_TCP_EF:1;            /* Disable Dropping of TCP/IP Checksum Error Packets When this bit is set, the MAC does not drop the packets which only have the errors detected by the Receive Checksum Offload engine. Such packets have errors only in the encapsulated payload. There are no errors (including FCS error) in the Ethernet packet received by the MAC. When this bit is reset, all error packets are dropped if the FEP bit is reset. */
    vuint32_t EHFC:1;                  /* Enable Hardware Flow Control When this bit is set, the flow control signal operation, based on the fill-level of Rx queue, is enabled. When reset, the flow control operation is disabled. */
    vuint32_t RFA:6;                   /* Threshold for Activating Flow Control (in half-duplex and full-duplex These bits control the threshold (fill-level of Rx queue) at which the flow control is activated: For more information on encoding for this field, see RFD. */
    vuint32_t RFD:6;                   /* Threshold for Deactivating Flow Control (in half-duplex and full-duplex modes) These bits control the threshold (fill-level of Rx queue) at which the flow control is de-asserted after activation: - 0: Full minus 1 KB, that is, FULL 1 KB - 1: Full minus 1.5 KB, that is, FULL 1.5 KB - 2: Full minus 2 KB, that is, FULL 2 KB - 3: Full minus 2.5 KB, that is, FULL 2.5 KB - ... - 62: Full minus 32 KB, that is, FULL 32 KB - 63: Full minus 32.5 KB, that is, FULL 32.5 KB The de-assertion is effective only after flow control is asserted. Note: The value must be programmed in such a way to make sure that the threshold is a positive number. When the EHFC is set high, these values are applicable only when the Rx queue size determined by the RQS field of this register, is equal to or greater than 4 KB. For a given queue size, the values ranges between 0 and the encoding for FULL minus (QSIZE - 0.5 KB) and all other values are illegal. Here the term FULL and QSIZE refers to the queue size determined by the RQS field of this register. The width of this field depends on RX FIFO size selected during the configuration. Remaining bits are reserved and read only. */
    vuint32_t RQS:7;                   /* Receive Queue Size This field indicates the size of the allocated Receive queues in blocks of 256 bytes. The RQS field is read-write only if the number of Rx Queues more than one, the reset value is 0x0 and indicates size of 256 bytes. When the number of Rx Queues is one, the field is read-only and the configured RX FIFO size in blocks of 256 bytes is reflected in the reset value. The width of this field depends on the Rx memory size selected in your configuration. For example, if the memory size is 2048, the width of this field is 3 bits: LOG2(2048/256) = LOG2(8) = 3 bits */
    vuint32_t _unused_27:5;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ3_OPERATION_MODE_tag;

typedef union GMAC_MTL_RXQ3_MISSED_PACKET_OVERFLOW_CNT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t OVFPKTCNT:11;            /* Overflow Packet Counter This field indicates the number of packets discarded by the DWC_ether_qos because of Receive queue overflow. This counter is incremented each time the DWC_ether_qos discards an incoming packet because of overflow. This counter is reset when this register is read with mci_be_i[0] at 1'b1. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t OVFCNTOVF:1;             /* Overflow Counter Overflow Bit When set, this bit indicates that the Rx Queue Overflow Packet Counter field crossed the maximum limit. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_12:4;            /* Reserved. */
    vuint32_t MISPKTCNT:11;            /* Missed Packet Counter This field indicates the number of packets missed by the DWC_ether_qos because the application asserted ari_pkt_flush_i[] for this queue. This counter is reset when this register is read with mci_be_i[0] at 1b1. This counter is incremented by 1 when the DMA discards the packet because of buffer unavailability. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t MISCNTOVF:1;             /* Missed Packet Counter Overflow Bit When set, this bit indicates that the Rx Queue Missed Packet Counter crossed the maximum limit. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ3_MISSED_PACKET_OVERFLOW_CNT_tag;

typedef union GMAC_MTL_RXQ3_DEBUG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RWCSTS:1;                /* MTL Rx Queue Write Controller Active Status When high, this bit indicates that the MTL Rx queue Write controller is active, and it is transferring a received packet to the Rx Queue. */
    vuint32_t RRCSTS:2;                /* MTL Rx Queue Read Controller State This field gives the state of the Rx queue Read controller: */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t RXQSTS:2;                /* MTL Rx Queue Fill-Level Status This field gives the status of the fill-level of the Rx Queue: */
    vuint32_t _unused_6:10;            /* Reserved. */
    vuint32_t PRXQ:14;                 /* Number of Packets in Receive Queue This field indicates the current number of packets in the Rx Queue. The theoretical maximum value for this field is 256KB/16B = 16K Packets, that is, Max_Queue_Size/Min_Packet_Size. */
    vuint32_t _unused_30:2;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ3_DEBUG_tag;

typedef union GMAC_MTL_RXQ3_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXQ_WEGT:3;              /* Receive Queue Weight This field indicates the weight assigned to the Rx Queue 0. The weight is used as the number of continuous PBL or packets requests (depending on the RXQ_FRM_ARBIT) allocated to the queue in one arbitration cycle. */
    vuint32_t RXQ_FRM_ARBIT:1;         /* Receive Queue Packet Arbitration When this bit is set, the DWC_ether_qos drives the packet data to the ARI interface such that the entire packet data of currently-selected queue is transmitted before switching to other queue. When this bit is reset, the DWC_ether_qos drives the packet data to the ARI interface such that the following amount of data of currently-selected queue is transmitted before switching to other queue: - PBL amount of data (indicated by ari_qN_pbl_i[]) or - Complete data of a packet The status and the timestamp are not a part of the PBL data. Therefore, the DWC_ether_qos drives the complete status (including timestamp status) during first PBL request for the packet (in store-and-forward mode) or the last PBL request for the packet (in Threshold mode). */
    vuint32_t _unused_4:28;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ3_CONTROL_tag;

typedef union GMAC_MTL_TXQ4_OPERATION_MODE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FTQ:1;                   /* Flush Transmit Queue When this bit is set, the Tx queue controller logic is reset to its default values. Therefore, all the data in the Tx queue is lost or flushed. This bit is internally reset when the flushing operation is complete. Until this bit is reset, you should not write to the MTL_TxQ1_Operation_Mode register. The data which is already accepted by the MAC transmitter is not flushed. It is scheduled for transmission and results in underflow and runt packet transmission. Note: The flush operation is complete only when the Tx queue is empty and the application has accepted the pending Tx Status of all transmitted packets. To complete this flush operation, the PHY Tx clock (clk_tx_i) should be active. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t TSF:1;                   /* Transmit Store and Forward When this bit is set, the transmission starts when a full packet resides in the MTL Tx queue. When this bit is set, the TTC values specified in Bits[6:4] of this register are ignored. This bit should be changed only when the transmission is stopped. */
    vuint32_t TXQEN:2;                 /* Transmit Queue Enable This field is used to enable/disable the transmit queue 0. - 2'b00: Not enabled - 2'b01: Enable in AV mode - 2'b10: Enabled - 2'b11: Reserved Note: In multiple Tx queues configuration, all the queues are disabled by default. Enable the Tx queue by programming this field. */
    vuint32_t TTC:3;                   /* Transmit Threshold Control These bits control the threshold level of the MTL Tx Queue. The transmission starts when the packet size within the MTL Tx Queue is larger than the threshold. In addition, full packets with length less than the threshold are also transmitted. These bits are used only when the TSF bit is reset. */
    vuint32_t _unused_7:9;             /* Reserved. */
    vuint32_t TQS:7;                   /* Transmit Queue Size This field indicates the size of the allocated Transmit queues in blocks of 256 bytes. The TQS field is read-write only if the number of Tx Queues more than one, the reset value is 0x0 and indicates size of 256 bytes. When the number of Tx Queues is one, the field is read-only and the configured TX FIFO size in blocks of 256 bytes is reflected in the reset value. The width of this field depends on the Tx memory size selected in your configuration. For example, if the memory size is 2048, the width of this field is 3 bits: LOG2(2048/256) = LOG2(8) = 3 bits */
    vuint32_t _unused_23:9;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ4_OPERATION_MODE_tag;

typedef union GMAC_MTL_TXQ4_UNDERFLOW_union_tag {
  vuint32_t R;
  struct {
    vuint32_t UFFRMCNT:11;             /* Underflow Packet Counter This field indicates the number of packets aborted by the controller because of Tx Queue Underflow. This counter is incremented each time the MAC aborts outgoing packet because of underflow. The counter is cleared when this register is read with mci_be_i[0] at 1'b1. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t UFCNTOVF:1;              /* Overflow Bit for Underflow Packet Counter This bit is set every time the Tx queue Underflow Packet Counter field overflows, that is, it has crossed the maximum count. In such a scenario, the overflow packet counter is reset to all-zeros and this bit indicates that the rollover happened. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_12:20;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ4_UNDERFLOW_tag;

typedef union GMAC_MTL_TXQ4_DEBUG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXQPAUSED:1;             /* Transmit Queue in Pause When this bit is high and the Rx flow control is enabled, it indicates that the Tx Queue is in the Pause condition (in the full-duplex only mode) because of the following: - Reception of the PFC packet for the priorities assigned to the Tx Queue when PFC is enabled - Reception of 802.3x Pause packet when PFC is disabled */
    vuint32_t TRCSTS:2;                /* MTL Tx Queue Read Controller Status This field indicates the state of the Tx Queue Read Controller: */
    vuint32_t TWCSTS:1;                /* MTL Tx Queue Write Controller Status When high, this bit indicates that the MTL Tx Queue Write Controller is active, and it is transferring the data to the Tx Queue. */
    vuint32_t TXQSTS:1;                /* MTL Tx Queue Not Empty Status When this bit is high, it indicates that the MTL Tx Queue is not empty and some data is left for transmission. */
    vuint32_t TXSTSFSTS:1;             /* MTL Tx Status FIFO Full Status When high, this bit indicates that the MTL Tx Status FIFO is full. Therefore, the MTL cannot accept any more packets for transmission. */
    vuint32_t _unused_6:10;            /* Reserved. */
    vuint32_t PTXQ:3;                  /* Number of Packets in the Transmit Queue This field indicates the current number of packets in the Tx Queue. When the DTXSTS bit of MTL_Operation_Mode register is set to 1, this field does not reflect the number of packets in the Transmit queue. */
    vuint32_t _unused_19:1;            /* Reserved. */
    vuint32_t STXSTSF:3;               /* Number of Status Words in Tx Status FIFO of Queue This field indicates the current number of status in the Tx Status FIFO of this queue. When the DTXSTS bit of MTL_Operation_Mode register is set to 1, this field does not reflect the number of status words in Tx Status FIFO. */
    vuint32_t _unused_23:9;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ4_DEBUG_tag;

typedef union GMAC_MTL_TXQ4_ETS_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:2;             /* Reserved. */
    vuint32_t AVALG:1;                 /* AV Algorithm When Queue 1 is programmed for AV, this field configures the scheduling algorithm for this queue: This bit when set, indicates credit based shaper algorithm (CBS) is selected for Queue 1 traffic. When reset, strict priority is selected. */
    vuint32_t CC:1;                    /* Credit Control When this bit is set, the accumulated credit parameter in the credit-based shaper algorithm logic is not reset to zero when there is positive credit and no packet to transmit in Channel 1. The credit accumulates even when there is no packet waiting in Channel 1 and another channel is transmitting. When this bit is reset, the accumulated credit parameter in the credit-based shaper algorithm logic is set to zero when there is positive credit and no packet to transmit in Channel 1. When there is no packet waiting in Channel 1 and other channel is transmitting, no credit is accumulated. */
    vuint32_t SLC:3;                   /* Slot Count If the credit-based shaper algorithm is enabled, the software can program the number of slots (of duration programmed in DMA_CH[n]_Slot_Interval register) over which the average transmitted bits per slot, provided in the MTL_TxQ[n]_ETS_Status register, need to be computed for Queue. The encoding is as follows: */
    vuint32_t _unused_7:25;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ4_ETS_CONTROL_tag;

typedef union GMAC_MTL_TXQ4_ETS_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ABS:24;                  /* Average Bits per Slot This field contains the average transmitted bits per slot. If AV operation is enabled, this field is computed over number of slots, programmed in the SLC field of MTL_TxQ[n]_ETS_CONTROL register. The maximum value of this field is 0x6_4000 in 100 Mbps, 0x3E_8000 in 1000 Mbps and 9C_4000 in 2500 Mbps mode respectively. When the DCB operation is enabled for Queue, this field is computed over every 10 million bit times slot (4 ms in 2500 Mbps; 10 ms in 1000 Mbps; 100 ms in 100 Mbps). The maximum value is 0x989680. */
    vuint32_t _unused_24:8;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ4_ETS_STATUS_tag;

typedef union GMAC_MTL_TXQ4_QUANTUM_WEIGHT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ISCQW:21;                /* idleSlopeCredit, Quantum or Weights - idleSlopeCredit When AV feature is enabled, this field contains the idleSlopeCredit value required for the credit-based shaper algorithm for Queue 1. This is the rate of change of credit in bits per cycle (40 ns for 100 Mbps; 8 ns for 1000 Mbps; 3.2 ns for 2500 Mbps) when the credit is increasing. The software should program this field with computed credit in bits per cycle scaled by 1,024. The maximum value is portTransmitRate, that is, 0x2000 in 1000/2500 Mbps mode and 0x1000 in 100 Mbps mode. Bits[20:14] must be written to zero. - Quantum When the DCB operation is enabled with DWRR algorithm for Queue 1 traffic, this field contains the quantum value in bytes to be added to credit during every queue scanning cycle. The maximum value is 0x1312D0 bytes. - Weights When DCB operation is enabled with WFQ algorithm for Queue 1 traffic, this field contains the weight for this queue. The maximum value is 0x3FFF where weight of 0 indicates 100% bandwidth. Bits[20:14] must be written to zero. When DCB operation or generic queuing operation is enabled with WRR algorithm for Queue 1 traffic, this field contains the weight for this queue. The maximum value is 0x64. Bits [20:7] must be written to zero. - Note 1: In multiple Queue configuration this field in respective per queue register must be programmed to some non-zero value when multiple queues are enabled or single queue other than Q0 is enabled. This field need not be programmed when only Q0 is enabled. In general, when WRR algorithm is selected a non-zero value must be programmed on both Receive and Transmit. In Receive, the register is MTL_Operation_Mode register. - Note 2: For WFQ algorithm, higher the programmed weights lesser the bandwidth allocated for that Transmit Queue. The finish time is not a function of particular packet alone but it is as per the formula: (previous_finish_time of particular Transmit Queue + (weights*packet_size)) - Note 3: The weights programmed do not correspond to the number of packets but the fraction of bandwidth or time allocated for particular queue w.r.t. total BW or time. */
    vuint32_t _unused_21:11;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ4_QUANTUM_WEIGHT_tag;

typedef union GMAC_MTL_TXQ4_SENDSLOPECREDIT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t SSC:14;                  /* sendSlopeCredit Value When AV operation is enabled, this field contains the sendSlopeCredit value required for credit-based shaper algorithm for Queue 1. This is the rate of change of credit in bits per cycle (40 ns, 8 ns and 3.2 ns for 100 Mbps, 1000 Mbps and 2500 Mbps respectively) when the credit is decreasing. The software should program this field with computed credit in bits per cycle scaled by 1,024. The maximum value is portTransmitRate, that is, 0x2000 in 1000/2500 Mbps mode and 0x1000 in 100 Mbps mode. This field should be programmed with absolute sendSlopeCredit value. The credit-based shaper logic subtracts it from the accumulated credit when Channel 1 is selected for transmission. */
    vuint32_t _unused_14:18;           /* Reserved. */
  } B;
} GMAC_MTL_TXQ4_SENDSLOPECREDIT_tag;

typedef union GMAC_MTL_TXQ4_HICREDIT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t HC:29;                   /* hiCredit Value When the AV feature is enabled, this field contains the hiCredit value required for the credit-based shaper algorithm. This is the maximum value that can be accumulated in the credit parameter. This is specified in bits scaled by 1,024. The maximum value is maxInterferenceSize, that is, best-effort maximum packet size (16,384 bytes or 131,072 bits). The value to be specified is 131,072 * 1,024 = 134,217,728 or 0x0800_0000. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ4_HICREDIT_tag;

typedef union GMAC_MTL_TXQ4_LOCREDIT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t LC:29;                   /* loCredit Value When AV operation is enabled, this field contains the loCredit value required for the credit-based shaper algorithm. This is the minimum value that can be accumulated in the credit parameter. This is specified in bits scaled by 1,024. The maximum value to be programmed is corresponds to twice the maxFrameSize transmitted from this queue. If the maxFrameSize is 8192 bytes, then (8192*2) * 8 * 1024 = 134,217,728 or 0x0800_0000. Because it is a negative value, the programmed value is 2's complement of the value, that is, 0x1800_0000. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_MTL_TXQ4_LOCREDIT_tag;

typedef union GMAC_MTL_Q4_INTERRUPT_CONTROL_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TXUNFIS:1;               /* Transmit Queue Underflow Interrupt Status This bit indicates that the Transmit Queue had an underflow while transmitting the packet. Transmission is suspended and an Underflow Error TDES3[2] is set. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t ABPSIS:1;                /* Average Bits Per Slot Interrupt Status When set, this bit indicates that the MAC has updated the ABS value. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_2:6;             /* Reserved. */
    vuint32_t TXUIE:1;                 /* Transmit Queue Underflow Interrupt Enable When this bit is set, the Transmit Queue Underflow interrupt is enabled. When this bit is reset, the Transmit Queue Underflow interrupt is disabled. */
    vuint32_t ABPSIE:1;                /* Average Bits Per Slot Interrupt Enable When this bit is set, the MAC asserts the sbd_intr_o or mci_intr_o interrupt when the average bits per slot status is updated. When this bit is cleared, the interrupt is not asserted for such an event. */
    vuint32_t _unused_10:6;            /* Reserved. */
    vuint32_t RXOVFIS:1;               /* Receive Queue Overflow Interrupt Status This bit indicates that the Receive Queue had an overflow while receiving the packet. If a partial packet is transferred to the application, the overflow status is set in RDES3[21]. This bit is cleared when the application writes 1 to this bit. Access restriction applies. Self-set to 1 on internal event. Setting 1 clears. Setting 0 has no effect. */
    vuint32_t _unused_17:7;            /* Reserved. */
    vuint32_t RXOIE:1;                 /* Receive Queue Overflow Interrupt Enable When this bit is set, the Receive Queue Overflow interrupt is enabled. When this bit is reset, the Receive Queue Overflow interrupt is disabled. */
    vuint32_t _unused_25:7;            /* Reserved. */
  } B;
} GMAC_MTL_Q4_INTERRUPT_CONTROL_STATUS_tag;

typedef union GMAC_MTL_RXQ4_OPERATION_MODE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RTC:2;                   /* Receive Queue Threshold Control These bits control the threshold level of the MTL Rx queue (in bytes): The received packet is transferred to the application or DMA when the packet size within the MTL Rx queue is larger than the threshold. In addition, full packets with length less than the threshold are automatically transferred. This field is valid only when the RSF bit is zero. This field is ignored when the RSF bit is set to 1. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t FUP:1;                   /* Forward Undersized Good Packets When this bit is set, the Rx queue forwards the undersized good packets (packets with no error and length less than 64 bytes), including pad-bytes and CRC. When this bit is reset, the Rx queue drops all packets of less than 64 bytes, unless a packet is already transferred because of the lower value of Rx Threshold, for example, RTC = 01. */
    vuint32_t FEP:1;                   /* Forward Error Packets When this bit is reset, the Rx queue drops packets with error status (CRC error, GMII_ER, watchdog timeout, or overflow). However, if the start byte (write) pointer of a packet is already transferred to the read controller side (in Threshold mode), the packet is not dropped. When this bit is set, all packets except the runt error packets are forwarded to the application or DMA. If the RSF bit is set and the Rx queue overflows when a partial packet is written, the packet is dropped irrespective of the setting of this bit. However, if the RSF bit is reset and the Rx queue overflows when a partial packet is written, a partial packet may be forwarded to the application or DMA. */
    vuint32_t RSF:1;                   /* Receive Queue Store and Forward When this bit is set, the DWC_ether_qos reads a packet from the Rx queue only after the complete packet has been written to it, ignoring the RTC field of this register. When this bit is reset, the Rx queue operates in the Threshold (cut-through) mode, subject to the threshold specified by the RTC field of this register. */
    vuint32_t DIS_TCP_EF:1;            /* Disable Dropping of TCP/IP Checksum Error Packets When this bit is set, the MAC does not drop the packets which only have the errors detected by the Receive Checksum Offload engine. Such packets have errors only in the encapsulated payload. There are no errors (including FCS error) in the Ethernet packet received by the MAC. When this bit is reset, all error packets are dropped if the FEP bit is reset. */
    vuint32_t EHFC:1;                  /* Enable Hardware Flow Control When this bit is set, the flow control signal operation, based on the fill-level of Rx queue, is enabled. When reset, the flow control operation is disabled. */
    vuint32_t RFA:6;                   /* Threshold for Activating Flow Control (in half-duplex and full-duplex These bits control the threshold (fill-level of Rx queue) at which the flow control is activated: For more information on encoding for this field, see RFD. */
    vuint32_t RFD:6;                   /* Threshold for Deactivating Flow Control (in half-duplex and full-duplex modes) These bits control the threshold (fill-level of Rx queue) at which the flow control is de-asserted after activation: - 0: Full minus 1 KB, that is, FULL 1 KB - 1: Full minus 1.5 KB, that is, FULL 1.5 KB - 2: Full minus 2 KB, that is, FULL 2 KB - 3: Full minus 2.5 KB, that is, FULL 2.5 KB - ... - 62: Full minus 32 KB, that is, FULL 32 KB - 63: Full minus 32.5 KB, that is, FULL 32.5 KB The de-assertion is effective only after flow control is asserted. Note: The value must be programmed in such a way to make sure that the threshold is a positive number. When the EHFC is set high, these values are applicable only when the Rx queue size determined by the RQS field of this register, is equal to or greater than 4 KB. For a given queue size, the values ranges between 0 and the encoding for FULL minus (QSIZE - 0.5 KB) and all other values are illegal. Here the term FULL and QSIZE refers to the queue size determined by the RQS field of this register. The width of this field depends on RX FIFO size selected during the configuration. Remaining bits are reserved and read only. */
    vuint32_t RQS:7;                   /* Receive Queue Size This field indicates the size of the allocated Receive queues in blocks of 256 bytes. The RQS field is read-write only if the number of Rx Queues more than one, the reset value is 0x0 and indicates size of 256 bytes. When the number of Rx Queues is one, the field is read-only and the configured RX FIFO size in blocks of 256 bytes is reflected in the reset value. The width of this field depends on the Rx memory size selected in your configuration. For example, if the memory size is 2048, the width of this field is 3 bits: LOG2(2048/256) = LOG2(8) = 3 bits */
    vuint32_t _unused_27:5;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ4_OPERATION_MODE_tag;

typedef union GMAC_MTL_RXQ4_MISSED_PACKET_OVERFLOW_CNT_union_tag {
  vuint32_t R;
  struct {
    vuint32_t OVFPKTCNT:11;            /* Overflow Packet Counter This field indicates the number of packets discarded by the DWC_ether_qos because of Receive queue overflow. This counter is incremented each time the DWC_ether_qos discards an incoming packet because of overflow. This counter is reset when this register is read with mci_be_i[0] at 1'b1. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t OVFCNTOVF:1;             /* Overflow Counter Overflow Bit When set, this bit indicates that the Rx Queue Overflow Packet Counter field crossed the maximum limit. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_12:4;            /* Reserved. */
    vuint32_t MISPKTCNT:11;            /* Missed Packet Counter This field indicates the number of packets missed by the DWC_ether_qos because the application asserted ari_pkt_flush_i[] for this queue. This counter is reset when this register is read with mci_be_i[0] at 1b1. This counter is incremented by 1 when the DMA discards the packet because of buffer unavailability. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t MISCNTOVF:1;             /* Missed Packet Counter Overflow Bit When set, this bit indicates that the Rx Queue Missed Packet Counter crossed the maximum limit. Access restriction applies. Clears on read. Self-set to 1 on internal event. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ4_MISSED_PACKET_OVERFLOW_CNT_tag;

typedef union GMAC_MTL_RXQ4_DEBUG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RWCSTS:1;                /* MTL Rx Queue Write Controller Active Status When high, this bit indicates that the MTL Rx queue Write controller is active, and it is transferring a received packet to the Rx Queue. */
    vuint32_t RRCSTS:2;                /* MTL Rx Queue Read Controller State This field gives the state of the Rx queue Read controller: */
    vuint32_t _unused_3:1;             /* Reserved. */
    vuint32_t RXQSTS:2;                /* MTL Rx Queue Fill-Level Status This field gives the status of the fill-level of the Rx Queue: */
    vuint32_t _unused_6:10;            /* Reserved. */
    vuint32_t PRXQ:14;                 /* Number of Packets in Receive Queue This field indicates the current number of packets in the Rx Queue. The theoretical maximum value for this field is 256KB/16B = 16K Packets, that is, Max_Queue_Size/Min_Packet_Size. */
    vuint32_t _unused_30:2;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ4_DEBUG_tag;

typedef union GMAC_MTL_RXQ4_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RXQ_WEGT:3;              /* Receive Queue Weight This field indicates the weight assigned to the Rx Queue 0. The weight is used as the number of continuous PBL or packets requests (depending on the RXQ_FRM_ARBIT) allocated to the queue in one arbitration cycle. */
    vuint32_t RXQ_FRM_ARBIT:1;         /* Receive Queue Packet Arbitration When this bit is set, the DWC_ether_qos drives the packet data to the ARI interface such that the entire packet data of currently-selected queue is transmitted before switching to other queue. When this bit is reset, the DWC_ether_qos drives the packet data to the ARI interface such that the following amount of data of currently-selected queue is transmitted before switching to other queue: - PBL amount of data (indicated by ari_qN_pbl_i[]) or - Complete data of a packet The status and the timestamp are not a part of the PBL data. Therefore, the DWC_ether_qos drives the complete status (including timestamp status) during first PBL request for the packet (in store-and-forward mode) or the last PBL request for the packet (in Threshold mode). */
    vuint32_t _unused_4:28;            /* Reserved. */
  } B;
} GMAC_MTL_RXQ4_CONTROL_tag;

typedef union GMAC_DMA_MODE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t SWR:1;                   /* Software Reset When this bit is set, the MAC and the DMA controller reset the logic and all internal registers of the DMA, MTL, and MAC. This bit is automatically cleared after the reset operation is complete in all DWC_ether_qos clock domains. Before reprogramming any DWC_ether_qos register, a value of zero should be read in this bit. This bit must be read at least 4 CSR clock cycles after it is written to 1. Note: The reset operation is complete only when all resets in all active clock domains are de-asserted. Therefore, it is essential that all PHY inputs clocks (applicable for the selected PHY interface) are present for software reset completion. The time to complete the software reset operation depends on the frequency of the slowest active clock. Access restriction applies. Setting 1 sets. Self-cleared. Setting 0 has no effect. */
    vuint32_t _unused_1:1;             /* Reserved. */
    vuint32_t _unused_2:3;             /* Reserved. */
    vuint32_t _unused_5:3;             /* Reserved. */
    vuint32_t DSPW:1;                  /* Descriptor Posted Write When this bit is set to 0, the descriptor writes are always non-posted. When this bit is set to 1, the descriptor writes are non-posted only when IOC (Interrupt on completion) is set in last descriptor, otherwise the descriptor writes are always posted. */
    vuint32_t _unused_9:1;             /* Reserved. */
    vuint32_t _unused_10:1;            /* Reserved. */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t _unused_12:3;            /* Reserved. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t INTM:2;                  /* Interrupt Mode This field defines the interrupt mode of DWC_ether_qos. The behavior of the following outputs changes depending on the following settings: - sbd_perch_tx_intr_o[] (Transmit Per Channel Interrupt) - sbd_perch_rx_intr_o[] (Receive Per Channel Interrupt) - sbd_intr_o (Common Interrupt) It also changes the behavior of the RI/TI bits in the DMA_CH0_Status. - 00: sbd_perch_* are pulse signals for each TX/RX packet transfer completion events (irrespective of whether corresponding interrupts are enabled) for which IOC bits are enabled in descriptor. sbd_intr_o is also asserted when corresponding interrupts are enabled and cleared only when software clears the corresponding RI/TI status bits. - 01: sbd_perch_* are level signals asserted on TX/RX packet transfer completion event when corresponding interrupts are enabled and de-asserted when the software clears the corresponding RI/TI status bits. The sbd_intr_o is not asserted for these TX/RX packet transfer completion events. - 10: sbd_perch_* are level signals asserted on TX/RX packet transfer completion event when corresponding interrupts are enabled and de-asserted when the software clears the corresponding RI/TI status bits. However, the signal is asserted again if the same event occurred again before it was cleared. The sbd_intr_o is not asserted for these TX/RX packet transfer completion events. - 11: Reserved For more details please refer Table "DWC_ether_qos Transfer Complete Interrupt Behavior". */
    vuint32_t _unused_18:14;           /* Reserved. */
  } B;
} GMAC_DMA_MODE_tag;

typedef union GMAC_DMA_SYSBUS_MODE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FB:1;                    /* Fixed Burst Length When this bit is set to 1, the EQOS-AXI master initiates burst transfers of specified lengths as given below. - Burst transfers of fixed burst lengths as indicated by the BLEN256, BLEN128, BLEN64, BLEN32, BLEN16, BLEN8, or BLEN4 field - Burst transfers of length 1 When this bit is set to 0, the EQOS-AXI master initiates burst transfers that are equal to or less than the maximum allowed burst length programmed in Bits[7:1]. */
    vuint32_t BLEN4:1;                 /* AXI Burst Length 4 When this bit is set to 1 or the FB bit is set to 0, the EQOS-AXI master can select a burst length of 4 on the AXI interface. When the FB bit is set to 0, setting this bit has no effect. */
    vuint32_t BLEN8:1;                 /* AXI Burst Length 8 When this bit is set to 1 or the FB bit is set to 0, the EQOS-AXI master can select a burst length of 8 on the AXI interface. When the FB bit is set to 0, setting this bit has no effect. */
    vuint32_t BLEN16:1;                /* AXI Burst Length 16 When this bit is set to 1 or the FB bit is set to 0, the EQOS-AXI master can select a burst length of 16 on the AXI interface. When the FB bit is set to 0, setting this bit has no effect. */
    vuint32_t BLEN32:1;                /* AXI Burst Length 32 When this bit is set to 1, the EQOS-AXI master can select a burst length of 32 on the AXI interface. */
    vuint32_t BLEN64:1;                /* AXI Burst Length 64 When this bit is set to 1, the EQOS-AXI master can select a burst length of 64 on the AXI interface. */
    vuint32_t BLEN128:1;               /* AXI Burst Length 128 When this bit is set to 1, the EQOS-AXI master can select a burst length of 128 on the AXI interface. */
    vuint32_t BLEN256:1;               /* AXI Burst Length 256 When this bit is set to 1, the EQOS-AXI master can select a burst length of 256 on the AXI interface. */
    vuint32_t _unused_8:2;             /* Reserved. */
    vuint32_t AALE:1;                  /* Automatic AXI LPI enable When set to 1, enables the AXI master to enter into LPI state when there is no activity in the DWC_ether_qos for number of system clock cycles programmed in the LPIEI field of AXI_LPI_Entry_Interval register. */
    vuint32_t _unused_11:1;            /* Reserved. */
    vuint32_t AAL:1;                   /* Address-Aligned Beats When this bit is set to 1, the EQOS-AXI or EQOS-AHB master performs address-aligned burst transfers on Read and Write channels. */
    vuint32_t ONEKBBE:1;               /* 1 KB Boundary Crossing Enable for the EQOS-AXI Master When set, the burst transfers performed by the EQOS-AXI master do not cross 1 KB boundary. When reset, the burst transfers performed by the EQOS-AXI master do not cross 4 KB boundary. */
    vuint32_t _unused_14:1;            /* Reserved. */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t RD_OSR_LMT:4;            /* AXI Maximum Read Outstanding Request Limit This value limits the maximum outstanding request on the AXI read interface. Maximum outstanding requests = RD_OSR_LMT + 1 Note: - Bit 18 is reserved if parameter DWC_ETHER_QOS_AXI_MAX_RD_REQ = 4 - Bit 19 is reserved if parameter DWC_ETHER_QOS_AXI_MAX_RD_REQ!= 16 */
    vuint32_t _unused_20:4;            /* Reserved. */
    vuint32_t WR_OSR_LMT:4;            /* AXI Maximum Write Outstanding Request Limit This value limits the maximum outstanding request on the AXI write interface. Maximum outstanding requests = WR_OSR_LMT + 1 Note: - Bit 26 is reserved if DWC_ETHER_QOS_AXI_MAX_WR_REQ = 4 - Bit 27 is reserved if DWC_ETHER_QOS_AXI_MAX_WR_REQ!= 16 */
    vuint32_t _unused_28:2;            /* Reserved. */
    vuint32_t LPI_XIT_PKT:1;           /* Unlock on Magic Packet or Remote Wake-Up Packet When set to 1, this bit enables the AXI master to come out of the LPI mode only when the magic packet or remote wake-up packet is received. When set to 0, this bit enables the AXI master to come out of the LPI mode when any packet is received. */
    vuint32_t EN_LPI:1;                /* Enable Low Power Interface (LPI) When set to 1, this bit enables the LPI mode supported by the EQOS-AXI configuration and accepts the LPI request from the AXI System Clock controller. When set to 0, this bit disables the LPI mode and always denies the LPI request from the AXI System Clock controller. */
  } B;
} GMAC_DMA_SYSBUS_MODE_tag;

typedef union GMAC_DMA_INTERRUPT_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t DC0IS:1;                 /* DMA Channel 0 Interrupt Status This bit indicates an interrupt event in DMA Channel 0. To reset this bit to 1'b0, the software must read the corresponding register in DMA Channel 0 to get the exact cause of the interrupt and clear its source. */
    vuint32_t DC1IS:1;                 /* DMA Channel 1 Interrupt Status This bit indicates an interrupt event in DMA Channel 1. To reset this bit to 1'b0, the software must read the corresponding register in DMA Channel 1 to get the exact cause of the interrupt and clear its source. */
    vuint32_t DC2IS:1;                 /* DMA Channel 2 Interrupt Status This bit indicates an interrupt event in DMA Channel 2. To reset this bit to 1'b0, the software must read the corresponding register in DMA Channel 2 to get the exact cause of the interrupt and clear its source. */
    vuint32_t DC3IS:1;                 /* DMA Channel 3 Interrupt Status This bit indicates an interrupt event in DMA Channel 3. To reset this bit to 1'b0, the software must read the corresponding register in DMA Channel 3 to get the exact cause of the interrupt and clear its source. */
    vuint32_t DC4IS:1;                 /* DMA Channel 4 Interrupt Status This bit indicates an interrupt event in DMA Channel 4. To reset this bit to 1'b0, the software must read the corresponding register in DMA Channel 4 to get the exact cause of the interrupt and clear its source. */
    vuint32_t _unused_5:1;             /* Reserved. */
    vuint32_t _unused_6:1;             /* Reserved. */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t _unused_8:8;             /* Reserved. */
    vuint32_t MTLIS:1;                 /* MTL Interrupt Status This bit indicates an interrupt event in the MTL. To reset this bit to 1'b0, the software must read the corresponding register in the MTL to get the exact cause of the interrupt and clear its source. */
    vuint32_t MACIS:1;                 /* MAC Interrupt Status This bit indicates an interrupt event in the MAC. To reset this bit to 1'b0, the software must read the corresponding register in the MAC to get the exact cause of the interrupt and clear its source. */
    vuint32_t _unused_18:14;           /* Reserved. */
  } B;
} GMAC_DMA_INTERRUPT_STATUS_tag;

typedef union GMAC_DMA_DEBUG_STATUS0_union_tag {
  vuint32_t R;
  struct {
    vuint32_t AXWHSTS:1;               /* AXI Master Write Channel When high, this bit indicates that the write channel of the AXI master is active, and it is transferring data. */
    vuint32_t AXRHSTS:1;               /* AXI Master Read Channel Status When high, this bit indicates that the read channel of the AXI master is active, and it is transferring the data. */
    vuint32_t _unused_2:6;             /* Reserved. */
    vuint32_t RPS0:4;                  /* DMA Channel 0 Receive Process State This field indicates the Rx DMA FSM state for Channel 0. The MSB of this field always returns 0. This field does not generate an interrupt. */
    vuint32_t TPS0:4;                  /* DMA Channel 0 Transmit Process State This field indicates the Tx DMA FSM state for Channel 0. The MSB of this field always returns 0. This field does not generate an interrupt. */
    vuint32_t RPS1:4;                  /* DMA Channel 1 Receive Process State This field indicates the Rx DMA FSM state for Channel 1. The MSB of this field always returns 0. This field does not generate an interrupt. */
    vuint32_t TPS1:4;                  /* DMA Channel 1 Transmit Process State This field indicates the Tx DMA FSM state for Channel 1. The MSB of this field always returns 0. This field does not generate an interrupt. */
    vuint32_t RPS2:4;                  /* DMA Channel 2 Receive Process State This field indicates the Rx DMA FSM state for Channel 2. The MSB of this field always returns 0. This field does not generate an interrupt. */
    vuint32_t TPS2:4;                  /* DMA Channel 2 Transmit Process State This field indicates the Tx DMA FSM state for Channel 2. The MSB of this field always returns 0. This field does not generate an interrupt. */
  } B;
} GMAC_DMA_DEBUG_STATUS0_tag;

typedef union GMAC_DMA_DEBUG_STATUS1_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RPS3:4;                  /* DMA Channel 3 Receive Process State This field indicates the Rx DMA FSM state for Channel 3. The MSB of this field always returns 0. This field does not generate an interrupt. */
    vuint32_t TPS3:4;                  /* DMA Channel 3 Transmit Process State This field indicates the Tx DMA FSM state for Channel 3. The MSB of this field always returns 0. This field does not generate an interrupt. */
    vuint32_t RPS4:4;                  /* DMA Channel 4 Receive Process State This field indicates the Rx DMA FSM state for Channel 4. The MSB of this field always returns 0. This field does not generate an interrupt. */
    vuint32_t TPS4:4;                  /* DMA Channel 4 Transmit Process State This field indicates the Tx DMA FSM state for Channel 4. The MSB of this field always returns 0. This field does not generate an interrupt. */
    vuint32_t _unused_16:4;            /* Reserved. */
    vuint32_t _unused_20:4;            /* Reserved. */
    vuint32_t _unused_24:4;            /* Reserved. */
    vuint32_t _unused_28:4;            /* Reserved. */
  } B;
} GMAC_DMA_DEBUG_STATUS1_tag;

typedef union GMAC_AXI4_TX_AR_ACE_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TDRC:4;                  /* Transmit DMA Read Descriptor Cache Control This field is used to drive arcache_o[3:0] signal when Transmit DMA engines access the Descriptor. */
    vuint32_t TDRD:2;                  /* Transmit DMA Read Descriptor Domain Control This field is used to drive ardomain_o[1:0] signal when Transmit DMA engines access the Descriptor. */
    vuint32_t _unused_6:2;             /* Reserved. */
    vuint32_t TEC:4;                   /* Transmit DMA Extended Packet Buffer This field is used to drive arcache_o[3:0] signal when Transmit DMA is accessing the extended buffers (when packet is distributed across multiple buffers). */
    vuint32_t TED:2;                   /* Transmit DMA Extended Packet Buffer This field is used to drive ardomain_o[1:0] signal when Transmit DMA is accessing the extended buffers (when packet is distributed across multiple buffers). */
    vuint32_t _unused_14:2;            /* Reserved. */
    vuint32_t THC:4;                   /* Transmit DMA First Packet Buffer This field is used to drive arcache_o[3:0] signal when Transmit DMA is accessing First Buffer of the Packet (First valid buffer with FD being set in the TDES3 of the Descriptor).. */
    vuint32_t THD:2;                   /* Transmit DMA First Packet Buffer This field is used to drive ardomain_o[1:0] signal when Transmit DMA is accessing First Buffer of the Packet (First valid buffer with FD being set in the TDES3 of the Descriptor). */
    vuint32_t _unused_22:10;           /* Reserved. */
  } B;
} GMAC_AXI4_TX_AR_ACE_CONTROL_tag;

typedef union GMAC_AXI4_RX_AW_ACE_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t RDWC:4;                  /* Receive DMA Write Descriptor Cache Control This field is used to drive awcache_o[3:0] signal when Receive DMA accesses the Descriptor. */
    vuint32_t RDWD:2;                  /* Receive DMA Write Descriptor Domain Control This field is used to drive awdomain_o[1:0] signal when Receive DMA accesses the Descriptor. */
    vuint32_t _unused_6:2;             /* Reserved. */
    vuint32_t RPC:4;                   /* Receive DMA Payload Cache Control This field is used to drive awcache_o[3:0] signal when Receive DMA is accessing the Payload Buffer when Header and payload are separated. */
    vuint32_t RPD:2;                   /* Receive DMA Payload Domain Control This field is used to drive awdomain_o[1:0] signal when Receive DMA is accessing the Payload Buffer when Header and payload are separated. */
    vuint32_t _unused_14:2;            /* Reserved. */
    vuint32_t RHC:4;                   /* Receive DMA Header Cache Control This field is used to drive awcache_o[3:0] and signal when Receive DMA is accessing the header Buffer when Header and payload are separated. */
    vuint32_t RHD:2;                   /* Receive DMA Header Domain Control This field is used to drive awdomain_o[1:0] and signal when Receive DMA is accessing the header Buffer when Header and payload are separated. */
    vuint32_t _unused_22:2;            /* Reserved. */
    vuint32_t RDC:4;                   /* Receive DMA Buffer Cache Control This field is used to drive awcache_o[3:0] signal when Receive DMA is accessing the Buffer when Header and payload are NOT separated. */
    vuint32_t RDD:2;                   /* Receive DMA Buffer Domain Control This field is used to drive the awdomain_o[1:0] signal when Receive DMA is accessing the Buffer when Header and payload are NOT separated. */
    vuint32_t _unused_30:2;            /* Reserved. */
  } B;
} GMAC_AXI4_RX_AW_ACE_CONTROL_tag;

typedef union GMAC_AXI4_TXRX_AWAR_ACE_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t TDWC:4;                  /* Transmit DMA Write Descriptor Cache control This field is used to drive awcache_o[3:0] signal when Transmit DMA writes to the Descriptor. */
    vuint32_t TDWD:2;                  /* Transmit DMA Write Descriptor Domain control This field is used to drive awdomain_o[1:0] signal when Transmit DMA write to the Descriptor. */
    vuint32_t _unused_6:2;             /* Reserved. */
    vuint32_t RDRC:4;                  /* Receive DMA Read Descriptor Cache control This field is used to drive arcache_o[3:0] signal when Receive DMA engines read the Descriptor. */
    vuint32_t RDRD:2;                  /* Receive DMA Read Descriptor Domain control This field is used to drive ardomain_o[1:0] signal when Receive DMA engines read the Descriptor. */
    vuint32_t _unused_14:2;            /* Reserved. */
    vuint32_t RDP:3;                   /* DMA Read Protection control This field is used to drive arprot_m_o[2:0] signal during all read requests. */
    vuint32_t _unused_19:1;            /* Reserved. */
    vuint32_t WRP:3;                   /* DMA Write Protection control This field is used to drive awprot_m_o[2:0] signal on the AXI Write Channel. */
    vuint32_t _unused_23:9;            /* Reserved. */
  } B;
} GMAC_AXI4_TXRX_AWAR_ACE_CONTROL_tag;

typedef union GMAC_AXI_LPI_ENTRY_INTERVAL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t LPIEI:4;                 /* LPI Entry Interval Contains the number of system clock cycles, multiplied by 64, to wait for an activity in the DWC_ether_qos to enter into the AXI low power state 0 indicates 64 clock cycles */
    vuint32_t _unused_4:28;            /* Reserved. */
  } B;
} GMAC_AXI_LPI_ENTRY_INTERVAL_tag;

typedef union GMAC_DMA_TBS_CTRL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t FTOV:1;                  /* Fetch Time Offset Valid When set indicates the FTOS field is valid. When not set, indicates the Fetch Offset is not valid and the DMA engine can fetch the frames from host memory without any time restrictions. */
    vuint32_t _unused_1:3;             /* Reserved. */
    vuint32_t FGOS:3;                  /* Fetch GSN Offset The number GSN slots that must be deducted from the Launch GSN to compute the Fetch GSN. Value valid only when FTOV is set. */
    vuint32_t _unused_7:1;             /* Reserved. */
    vuint32_t FTOS:24;                 /* Fetch Time Offset The value in units of 256 nanoseconds, that has to be deducted from the Launch time to compute the Fetch Time. Max value: 999,999,999 ns, additionally should be smaller than CTR-1 value when ESTM mode is set since this value is a modulo CTR value. */
  } B;
} GMAC_DMA_TBS_CTRL_tag;

typedef union GMAC_DMA_SAFETY_INTERRUPT_STATUS_union_tag {
  vuint32_t R;
  struct {
    vuint32_t DECIS:1;                 /* DMA ECC Correctable error Interrupt Status This bit indicates an interrupt event in the DMA ECC safety feature. To get the exact cause of the interrupt the application should read the DMA_ECC_Interrupt_Status register. */
    vuint32_t DEUIS:1;                 /* DMA ECC Uncorrectable error Interrupt Status This bit indicates an interrupt event in the DMA ECC safety feature. To get the exact cause of the interrupt the application should read the DMA_ECC_Interrupt_Status register. */
    vuint32_t _unused_2:26;            /* Reserved. */
    vuint32_t MSCIS:1;                 /* MTL Safety Correctable error Interrupt Status This bit indicates a correctable error interrupt event in MTL. To get exact cause of the interrupt the software should read the MTL_Safety_Interrupt_Status register. */
    vuint32_t MSUIS:1;                 /* MTL Safety Uncorrectable error Interrupt Status This bit indicates an uncorrectable error interrupt event in MTL. To get exact cause of the interrupt the software should read the MTL_Safety_Interrupt_Status register. */
    vuint32_t _unused_30:1;            /* Reserved. */
    vuint32_t MCSIS:1;                 /* MAC Safety Uncorrectable Interrupt Status Indicates a uncorrectable Safety related Interrupt is set in the MAC module. MAC_DPP_FSM_Interrupt_Status register should be read when this bit is set, to get the cause of the Safety Interrupt in MAC. */
  } B;
} GMAC_DMA_SAFETY_INTERRUPT_STATUS_tag;

typedef union GMAC_DMA_CH0_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_0:14;            /* Reserved. */
    vuint32_t _unused_14:2;            /* Reserved. */
    vuint32_t PBLX8:1;                 /* 8xPBL mode When this bit is set, the PBL value programmed in Bits[21:16] in DMA_CH0_Tx_Control and Bits[21:16] in DMA_CH0_Rx_Control is multiplied by eight times. Therefore, the DMA transfers the data in 8, 16, 32, 64, 128, and 256 beats depending on the PBL value. */
    vuint32_t _unused_17:1;            /* Reserved. */
    vuint32_t DSL:3;                   /* Descriptor Skip Length This bit specifies the Word, Dword, or Lword number (depending on the 32-bit, 64-bit, or 128-bit bus) to skip between two unchained descriptors. The address skipping starts from the end of the current descriptor to the start of the next descriptor. When the DSL value is equal to zero, the DMA takes the descriptor table as contiguous. */
    vuint32_t _unused_21:3;            /* Reserved. */
    vuint32_t SPH:1;                   /* Split Headers When this bit is set, the DMA splits the header and payload in the Receive path. The DMA writes the header to the Buffer Address1 of RDES0. The DMA writes the payload to the buffer to which the Buffer Address2 is pointing. The software must ensure that the header fits into the Receive buffers. If the header length exceeds the receive buffer size, the DMA does not split the header and payload. This bit is available only if Enable Split Header Structure option is selected. */
    vuint32_t _unused_25:7;            /* Reserved. */
  } B;
} GMAC_DMA_CH0_CONTROL_tag;

typedef union GMAC_DMA_CH0_TX_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t ST:1;                    /* Start or Stop Transmission Command When this bit is set, transmission is placed in the Running state. The DMA checks the Transmit list at the current position for a packet to be transmitted. The DMA tries to acquire descriptor from either of the following positions: - The current position in the list This is the base address of the Transmit list set by the DMA_CH0_TxDesc_List_Address register. - The position at which the transmission was previously stopped If the DMA does not own the current descriptor, the transmission enters the Suspended state and the TBU bit of the DMA_CH0_Status register is set. The Start Transmission command is effective only when the transmission is stopped. If the command is issued before setting the DMA_CH0_TxDesc_List_Address register, the DMA behavior is unpredictable. When this bit is reset, the transmission process is placed in the Stopped state after completing the transmission of the current packet. The Next Descriptor position in the Transmit list is saved, and it becomes the current position when the transmission is restarted. To change the list address, you need to program DMA_CH0_TxDesc_List_Address register with a new value when this bit is reset. The new value is considered when this bit is set again. The stop transmission command is effective only when the transmission of the current packet is complete or the transmission is in the Suspended state. */
    vuint32_t _unused_1:3;             /* Reserved. */
    vuint32_t OSF:1;                   /* Operate on Second Packet When this bit is set, it instructs the DMA to process the second packet of the Transmit data even before the status for the first packet is obtained. */
    vuint32_t _unused_5:7;             /* Reserved. */
    vuint32_t _unused_12:1;            /* Reserved. */
    vuint32_t _unused_13:2;            /* Reserved. */
    vuint32_t IPBL:1;                  /* Ignore PBL Requirement When this bit is set, the DMA does not check for PBL number of locations in the MTL before initiating a transfer. If space is not available, the MTL may use handshaking to slow the DMA. Note: This bit/mode must not be used when multiple Transmit DMA Channels are enabled as it may block other Transmit and Receive DMA Channels from accessing the Read Data Channel of AXI bus until space is available in Transmit Queue for current transfer. */
    vuint32_t TXPBL:6;                 /* Transmit Programmable Burst Length These bits indicate the maximum number of beats to be transferred in one DMA block data transfer. The DMA always attempts max burst as specified in PBL each time it starts a burst transfer on the application bus. You can program PBL with any of the following values: 1, 2, 4, 8, 16, or 32. Any other value results in undefined behavior. To transfer more than 32 beats, perform the following steps: 1. Set the 8xPBL mode in DMA_CH0_Control register. 2. Set the TxPBL. Note: The maximum value of TxPBL must be less than or equal to half the Tx Queue size (TQS field of MTL_TxQ[n]_Operation_Mode register) in terms of beats. This is required so that the Tx Queue has space to store at least another Tx PBL worth of data while the MTL Tx Queue Controller is transferring data to MAC. For example, in 64-bit data width configurations the total locations in Tx Queue of size 512 bytes is 64, TxPBL and 8xPBL needs to be programmed to less than or equal to 32. */
    vuint32_t _unused_22:1;            /* Reserved. */
    vuint32_t _unused_23:1;            /* Reserved. */
    vuint32_t TQOS:4;                  /* Transmit QOS. This field is used to drive arqos_m_o[3:0] or awqos_m_o[3:0] output signals for all transactions of DMA Tx Channel0. */
    vuint32_t EDSE:1;                  /* Enhanced Descriptor Enable When this bit is set, the corresponding channel uses Enhanced Descriptors that are 32 Bytes for both Normal and Context Descriptors. When reset, the corresponding channel uses the descriptors that are 16 Bytes. */
    vuint32_t _unused_29:3;            /* Reserved. */
  } B;
} GMAC_DMA_CH0_TX_CONTROL_tag;

typedef union GMAC_DMA_CH0_RX_CONTROL_union_tag {
  vuint32_t R;
  struct {
    vuint32_t SR:1;                    /* Start or Stop Receive When this bit is set, the DMA tries to acquire the descriptor from the Receive list and processes the incoming packets. The DMA tries to acquire descriptor from either of the following positions: - The current position in the list This is the address set by the DMA_CH0_RxDesc_List_Address register. - The position at which the Rx process was previously stopped If the DMA does not own the current descriptor, the reception is suspended and the RBU bit of the DMA_CH0_Status register is set. The Start Receive command is effective only when the reception is stopped. If the command is issued before setting the DMA_CH0_RxDesc_List_Address register, the DMA behavior is unpredictable. When this bit is reset, the Rx DMA operation is stopped after the transfer of the current packet. The next descriptor position in the Receive list is saved, and it becomes the current position after the Rx process is restarted. The Stop Receive command is effective only when the Rx process is in the Running (waiting for Rx packet) or Suspended state. */
    vuint32_t RBSZ_X_0:3;              /* Receive Buffer size Low RBSZ[13:0] is split into two fields RBSZ_13_y and RBSZ_x_0. The RBSZ_x_0 is the lower field whose width is based on data bus width of the configuration. This field is of width 2, 3, or 4 bits for 32-bit, 64-bit, or 128-bit data bus width respectively. This field is read-only (RO). */
    vuint32_t RBSZ_13_Y:11;            /* Receive Buffer size High RBSZ[13:0] is split into two fields higher RBSZ_13_y and lower RBSZ_x_0. The RBSZ[13:0] field indicates the size of the Rx buffers specified in bytes. The maximum buffer size is limited to 16K bytes. The buffer size is applicable to payload buffers when split headers are enabled. Note: The buffer size must be a multiple of 4, 8, or 16 depending on the data bus widths (32-bit, 64-bit, or 128-bit respectively). This is required even if the value of buffer address pointer is not aligned to data bus width. Hence the lower RBSZ_x_0 bits are read-only and the value is considered as all-zero. Thus the RBSZ_13_y indicates the buffer size in terms of locations (with the width same as bus-width). */
    vuint32_t _unused_15:1;            /* Reserved. */
    vuint32_t RXPBL:6;                 /* Receive Programmable Burst Length These bits indicate the maximum number of beats to be transferred in one DMA block data transfer. The DMA always attempts max burst as specified in PBL each time it starts a burst transfer on the application bus. You can program PBL with any of the following values: 1, 2, 4, 8, 16, or 32. Any other value results in undefined behavior. To transfer more than 32 beats, perform the following steps: 1. Set the 8xPBL mode in the DMA_CH0_Control register. 2. Set the RxPBL. Note: The maximum value of RxPBL must be less than or equal to half the Rx Queue size (RQS field of MTL_RxQ[n]_Operation_Mode register) in terms of beats. This is required so that the Rx Queue has space to store at least another Rx PBL worth of data while the Rx DMA is transferring a block of data. For example, in 64-bit data width configurations the total locations in Rx Queue of size 512 bytes is 64, so RxPBL