/* File: system_ARMCR52.S
 * Purpose: Provides vector table, TCM, cache initialization and EL2 to EL1 switch
 * subroutines
 */

  .arch	armv8-r
  .syntax unified
  .thumb

  .text
  .align 2
  .globl SystemInit
  .type  SystemInit, %function
SystemInit:

  /* Vector table initialization */
  ldr    r0, =__EL1_Vectors
  mcr    p15, 0, r0, c12, c0, 0
  ldr    r0, =__EL2_Vectors
  mcr    p15, 4, r0, c12, c0, 0 /* Write to HVBAR */
  /* Clear mask bits A, F, I */
  mrs    r0, cpsr
  ldr    r1, =0xFFFFFE3F
  and    r0, r0, r1
  msr    cpsr, r0
  msr    SPSR_cxsf, r0

  mov    r6, lr                /* Save linker so jump back correct */

#ifndef DISABLE_TCM_INITIALIZATION
  /* TCM initialization */
  ldr    r0, =__TCMA_Start     /* Load new BASE address*/
  orr    r0, r0, #0x1b         /* 32k; EL0/1=ON L2=ON */
  mcr    p15, 0, r0, c9, c1, 0 /* Write to A-TCM config reg */

  ldr    r0, =__TCMB_Start     /* Load new BASE address */
  orr    r0, r0, #0x1b         /* 32k; EL0/1=ON L2=ON */
  mcr    p15, 0, r0, c9, c1, 1 /* Write to B-TCM config reg */

  ldr    r0, =__TCMC_Start     /* Load new BASE address*/
  orr    r0, r0, #0x1b         /* 32k; EL0/1=ON L2=ON */
  mcr    p15, 0, r0, c9, c1, 2 /* Write to C-TCM config reg */

  ldr    r0, =__TCMA_Start
  ldr    r1, =__TCMA_Length
  mov    r1, r1, lsr #5        /* Divide by 32 */
  bl     InitTcmLoop

  ldr    r0, =__TCMB_Start
  ldr    r1, =__TCMB_Length
  mov    r1, r1, lsr #5        /* Divide by 32 */
  bl     InitTcmLoop

  ldr    r0, =__TCMC_Start
  ldr    r1, =__TCMC_Length
  mov    r1, r1, lsr #5        /* Divide by 32 */
  bl     InitTcmLoop
#endif

#ifndef DISABLE_CACHE_INITIALIZATION
  /* Enable I cache and D cache for EL2 */
  mrc    p15, 4, r0, c1, c0, 0  /* Read HSCTRL */
  ldr    r1, =0x1004
  orr    r0, r0, r1             /* Set I and C bits */
  mcr    p15, 4, r0, c1, c0, 0  /* Write to HSCTRL reg */

  /* Enable I cache and D cache for EL1/0 */
  mrc    p15, 0, r0, c1, c0, 0  /* Read SCTRL */
  ldr    r1, =0x1004
  orr    r0, r0, r1             /* Set I and C bits */
  mcr    p15, 0, r0, c1, c0, 0  /* Write to SCTRL reg */
#endif

#if defined (__VFP_FP__) && !defined (__SOFTFP__)
  /* Permit access to VFP/NEON, registers by modifying CPACR */
  mrc     p15,0,r1,c1,c0,2
  orr     r1,r1,#0x00f00000
  mcr     p15,0,r1,c1,c0,2

  /* Ensure that subsequent instructions occur in the context of VFP/NEON access permitted */
  isb

  /* Enable VFP/NEON */
  vmrs    r1,fpexc
  orr     r1,r1,#0x40000000
  vmsr    fpexc,r1

  /* Initialise VFP/NEON registers to 0 */
  mov     r2,#0

  /* Initialise D16 registers to 0 */
  vmov    d0, r2,r2
  vmov    d1, r2,r2
  vmov    d2, r2,r2
  vmov    d3, r2,r2
  vmov    d4, r2,r2
  vmov    d5, r2,r2
  vmov    d6, r2,r2
  vmov    d7, r2,r2
  vmov    d8, r2,r2
  vmov    d9, r2,r2
  vmov    d10,r2,r2
  vmov    d11,r2,r2
  vmov    d12,r2,r2
  vmov    d13,r2,r2
  vmov    d14,r2,r2
  vmov    d15,r2,r2

#if (defined(__ARM_NEON) && (__ARM_NEON == 1))
  /* Initialise D32 registers to 0 */
  vmov    d16,r2,r2
  vmov    d17,r2,r2
  vmov    d18,r2,r2
  vmov    d19,r2,r2
  vmov    d20,r2,r2
  vmov    d21,r2,r2
  vmov    d22,r2,r2
  vmov    d23,r2,r2
  vmov    d24,r2,r2
  vmov    d25,r2,r2
  vmov    d26,r2,r2
  vmov    d27,r2,r2
  vmov    d28,r2,r2
  vmov    d29,r2,r2
  vmov    d30,r2,r2
  vmov    d31,r2,r2
#endif

  /* Initialise FPSCR to a known state */
  vmrs    r1,fpscr
  /* Mask off all bits that do not have to be preserved. Non-preserved bits can/should be zero. */
  ldr     r2,=0x00086060
  and     r1,r1,r2
  vmsr    fpscr,r1
#endif

#ifndef DISABLE_MPU_INITIALIZATION
  bl     MpuInit
#endif

  mov    lr, r6                 /* Bring back first linker saved */
  bx     lr


#ifndef DISABLE_TCM_INITIALIZATION
InitTcmLoop:
  stm    r0, {r4-r11}           /* Move 8 location once 4*8=32 bytes */
  add    r0, r0,#32             /* Increment address by 32 */
  sub    r1 ,r1, #1             /* Decrement counter by 1 */
  cmp    r1, #0                 /* Is the end of DMEM? */
  bne    InitTcmLoop            /* Restart loop if not */
  bx     lr
#endif
  .pool
  .size  SystemInit, . - SystemInit


  .equ CPSR_M_SVR,   0x03    /* Supervisor mode */
  .equ CPSR_M_32BIT, 0x10    /* 32-bit mode */
  .equ CPSR_T_BIT,   0x20    /* Thumb bit */
  .equ CPSR_M_MASK,  0x0F    /* Mode mask except M[4] */

  .align 2
  .globl SwitchEL2toEL1
  .type  SwitchEL2toEL1, %function
SwitchEL2toEL1:

  /* ARMv8-R cores are in EL2 (hypervisor mode) after reset, and we need
     to first descend to EL1 (supervisor mode) before the traditional SP
     setting code can be run */
  ldr    r0, =_start;
  msr    ELR_hyp, r0;
  mrs    r0, SPSR_hyp;
  and    r0, r0, #~(CPSR_M_32BIT|CPSR_M_MASK);
#if defined(__thumb2__) && (__thumb2__==1)
  orr    r0, r0, #(CPSR_T_BIT|CPSR_M_32BIT|CPSR_M_SVR) /* Thumb instruction set and supervisor mode */
#else
  orr    r0, r0, #(CPSR_M_32BIT|CPSR_M_SVR)            /* ARM instruction set and supervisor mode */
#endif
  msr    SPSR_hyp, r0
  eret   /* Enter PreeMain (C library entry point) */

  .pool
  .size  SwitchEL2toEL1, . - SwitchEL2toEL1
