/*
 * Start_Cores function definition
 *
 */

#include "S32S247TV.h"

#if defined(START_R52_0_1) || defined(START_R52_1_0) || defined(START_R52_1_1)
void Start_Cores(void)
{
	vuint16_t timeout;
#ifdef START_R52_0_1
	extern const uintptr_t R52_0_1_START_ADDRESS;

	MC_ME_PRTN0_CORE1_ADDR = (uint32_t)&R52_0_1_START_ADDRESS;
	MC_ME_PRTN0_CORE1_PCONF = 1;
	MC_ME_PRTN0_CORE1_PUPD = 1;
	MC_ME_CTL_KEY = 0x5AF0;
	MC_ME_CTL_KEY = 0xA50F;
	timeout = 0xFFFF;
	while (!MC_ME.PRTN0_CORE1_STAT.B.CCS && timeout--) {};
	MC_RGM.PRST_0[0].PRST_0.B.PERIPH_1_RST = 0;
	timeout = 0xFFFF;
	while (MC_RGM.PSTAT_0[0].PSTAT_0.B.PERIPH_1_STAT && (timeout--)) {};
#endif

#if defined(START_R52_1_0) || defined(START_R52_1_1)
	// Enable Cluster 1
	MC_ME.PRTN1_PCONF.R = 0x00000001; // Disable output safe stating, enable the clock to IPs
	MC_ME.PRTN1_PUPD.R = 0x00000001; // Trigger the hardware process (PCUD bit)
	MC_ME.CTL_KEY.R = 0x5AF0;
	MC_ME.CTL_KEY.R = 0xA50F;
	timeout = 0xFFFF;
	while(((MC_ME.PRTN1_STAT.R & 0x1) != 1) && timeout--);

	// Unlock Software Reset Domain control register
	RDC.RD1_CTRL_REG.B.RD1_CTRL_UNLOCK = 1;
	// Enable the interconnect interface of Software Reset Domain 1
	RDC.RD1_CTRL_REG.B.RD1_XBAR_INTERFACE_DISABLE = 0;
	// Wait for Software Reset Domain 1 status register to acknowledge interconnect interface not disabled
	timeout = 0xFFFF;
	while((((RDC.RD1_STAT_REG.R) & 0x10) !=0) && timeout--);

	// No Forced reset on PERIPH_64 (R52 Cluster 1)
	MC_RGM.PRST_0[1].PRST_0.B.PERIPH_0_RST = 0; //MC_RGM.PRST_0[1].PRST_0.R &= 0xFFFFFFFE;

	// Disable output safe stating, enable the clock to IPs
	MC_ME.PRTN1_PCONF.R = 0x00000001;
	// Trigger the hardware process (OSSUD bit)
	MC_ME.PRTN1_PUPD.B.OSSUD = 1; //MC_ME.PRTN1_PUPD.R = 0x4;
	// Write the valid key sequence
	MC_ME.CTL_KEY.R = 0x5AF0;
	MC_ME.CTL_KEY.R = 0xA50F;
	// Wait for PERIPH_64_STAT reporting not in reset
	timeout = 0xFFFF;
	while(!MC_RGM.PSTAT_0[1].PSTAT_0.B.PERIPH_0_STAT && timeout--); //while((MC_RGM.PSTAT_0[1].PSTAT_0.R & 0x1) != 0);
	// Wait for partition 1 output safe stating reporting active
	timeout = 0xFFFF;
	while(!MC_ME.PRTN1_STAT.B.OSSS && timeout--); //while(((MC_ME.PRTN1_STAT.R & 0x4) != 0x0) && timeout--);

	// Lock Software Reset Domain control register
	RDC.RD1_CTRL_REG.B.RD1_CTRL_UNLOCK = 0;
#endif

#ifdef START_R52_1_0
	extern const uintptr_t R52_1_0_START_ADDRESS;

	MC_ME_PRTN1_CORE0_ADDR = (uint32_t)&R52_1_0_START_ADDRESS;
	MC_ME_PRTN1_CORE0_PCONF = 1;
	MC_ME_PRTN1_CORE0_PUPD = 1;
	MC_ME_CTL_KEY = 0x5AF0;
	MC_ME_CTL_KEY = 0xA50F;
	timeout = 0xFFFF;
	while (!MC_ME.PRTN1_CORE0_STAT.B.CCS && timeout--) {};
	MC_RGM.PRST_0[1].PRST_0.B.PERIPH_1_RST = 0;
	timeout = 0xFFFF;
	while (MC_RGM.PSTAT_0[1].PSTAT_0.B.PERIPH_1_STAT && timeout--) {};
#endif
#ifdef START_R52_1_1
	extern const uintptr_t R52_1_1_START_ADDRESS;

	MC_ME_PRTN1_CORE1_ADDR = (uint32_t)&R52_1_1_START_ADDRESS;
	MC_ME_PRTN1_CORE1_PCONF = 1;
	MC_ME_PRTN1_CORE1_PUPD = 1;
	MC_ME_CTL_KEY = 0x5AF0;
	MC_ME_CTL_KEY = 0xA50F;
	timeout = 0xFFFF;
	while (!MC_ME.PRTN1_CORE1_STAT.B.CCS && timeout--) {};
	MC_RGM.PRST_0[1].PRST_0.B._unused_2 = 0; /* MC_RGM.PRST_0[1].PRST_0.B.PERIPH_2_RST = 0;*/
	timeout = 0xFFFF;
	while (MC_RGM.PSTAT_0[1].PSTAT_0.B._unused_2 && timeout--) {}; /* while (MC_RGM.PSTAT_0[1].PSTAT_0.B.PERIPH_2_STAT) {};*/
#endif
}
#endif
