/*
 * main implementation: use this 'C++' sample to create your own application
 *
 */

/* The register and bit field definitions for the S32S247TV */
#include "S32S247TV.h"

#ifdef SEMIHOSTING
#include <stdio.h>
#endif

extern "C" {
#include "start_cores.h"
}

#define read_mpidr() ({							\
	unsigned long long __mpidr;					\
	__asm volatile("mrc p15, 0, %0, c0, c0, 5"	\
		: "=r" (__mpidr)						\
		:										\
		: "cc");								\
	__mpidr;									\
})

#define clusterid(mpidr) ((mpidr >> 8) & 1)
#define coreid(mpidr) (mpidr & 1)

class CCounter {
private:
	static const int m_limit = 1000000;
	int m_counter;

public:
	CCounter() : m_counter(0) {
	};
	CCounter(const CCounter& counter) {
		m_counter = counter.m_counter;
	}
	void increment() {
		m_counter++;
	};
	int get() {
		return m_counter;
	};
	void set(int value) {
		m_counter = value;
	};
	int getLimit() {
		return m_limit;
	};
};

int clusterid, coreid;

CCounter* myCounter;
CCounter myAccumulator;

int main() {
	int mpidr = read_mpidr();
	clusterid = clusterid(mpidr);
	coreid = coreid(mpidr);

	Start_Cores();

	for (;;) {
		myCounter = new CCounter();
		while((myCounter->get() < myCounter->getLimit())) {
			myCounter->increment();
		}
		__asm volatile ("svc 0");
		delete myCounter;
	}

	return 0;
}

extern "C" {
	void __attribute__ ((interrupt ("SWI"))) EL1_SVC_Handler() {
		myAccumulator.set(myAccumulator.get() + myCounter->get());
#ifdef SEMIHOSTING
		printf("cluster %d, R52 core %d, counter is 0x%08x, accumulator is 0x%08x\n",
				clusterid, coreid, myCounter->get(), myAccumulator.get());
#endif
	}
}
