/* Linker script to configure memory regions. */
MEMORY
{
	R52_0_0_TCMA (rw)  : ORIGIN = 0x20000000, LENGTH = 0x8000
	R52_0_0_TCMB (rw)  : ORIGIN = 0x20100000, LENGTH = 0x8000
	R52_0_0_TCMC (rw)  : ORIGIN = 0x20200000, LENGTH = 0x8000
	R52_0_0_RAM (rw)   : ORIGIN = 0x34000000, LENGTH = 0x30000
	R52_0_0_VCRAM (rx) : ORIGIN = 0x38000000, LENGTH = 0x30000

	R52_0_1_TCMA (rw)  : ORIGIN = 0x20400000, LENGTH = 0x8000
	R52_0_1_TCMB (rw)  : ORIGIN = 0x20500000, LENGTH = 0x8000
	R52_0_1_TCMC (rw)  : ORIGIN = 0x20600000, LENGTH = 0x8000
	R52_0_1_RAM (rw)   : ORIGIN = 0x34030000, LENGTH = 0x30000
	R52_0_1_VCRAM (rx) : ORIGIN = 0x38030000, LENGTH = 0x30000

	R52_1_0_TCMA (rw)  : ORIGIN = 0x21000000, LENGTH = 0x8000
	R52_1_0_TCMB (rw)  : ORIGIN = 0x21100000, LENGTH = 0x8000
	R52_1_0_TCMC (rw)  : ORIGIN = 0x21200000, LENGTH = 0x8000
	R52_1_0_RAM (rw)   : ORIGIN = 0x34060000, LENGTH = 0x30000
	R52_1_0_VCRAM (rx) : ORIGIN = 0x38060000, LENGTH = 0x30000

	R52_1_1_TCMA (rw)  : ORIGIN = 0x21400000, LENGTH = 0x8000
	R52_1_1_TCMB (rw)  : ORIGIN = 0x21500000, LENGTH = 0x8000
	R52_1_1_TCMC (rw)  : ORIGIN = 0x21600000, LENGTH = 0x8000
	R52_1_1_RAM (rw)   : ORIGIN = 0x34090000, LENGTH = 0x30000
	R52_1_1_VCRAM (rx) : ORIGIN = 0x38090000, LENGTH = 0x30000
}

/* Linker script to place sections and symbol values. Should be used together
 * with other linker script that defines memory regions FLASH and RAM.
 * It references following symbols, which must be defined in code:
 *   Reset_Handler : Entry of reset handler
 *
 * It defines following symbols, which code can use without definition:
 *   __exidx_start
 *   __exidx_end
 *   __copy_table_start__
 *   __copy_table_end__
 *   __zero_table_start__
 *   __zero_table_end__
 *   __etext
 *   __data_start__
 *   __preinit_array_start
 *   __preinit_array_end
 *   __init_array_start
 *   __init_array_end
 *   __fini_array_start
 *   __fini_array_end
 *   __data_end__
 *   __bss_start__
 *   __bss_end__
 *   __end__
 *   end
 *   __HeapLimit
 *   __StackLimit
 *   __StackTop
 *   __stack
 */
ENTRY(__Vectors)

SECTIONS
{
	.text :
	{
		KEEP(*(.vectors))

		*(.text*)

		KEEP(*(.init))
		KEEP(*(.fini))

		/* .ctors */
		*crtbegin.o(.ctors)
		*crtbegin?.o(.ctors)
		*(EXCLUDE_FILE(*crtend?.o *crtend.o) .ctors)
		*(SORT(.ctors.*))
		*(.ctors)

		/* .dtors */
 		*crtbegin.o(.dtors)
 		*crtbegin?.o(.dtors)
 		*(EXCLUDE_FILE(*crtend?.o *crtend.o) .dtors)
 		*(SORT(.dtors.*))
 		*(.dtors)

		*(.rodata*)

		KEEP(*(.eh_frame*))
	} > R52_0_0_VCRAM AT > R52_0_0_RAM

	.ARM.extab :
	{
		*(.ARM.extab* .gnu.linkonce.armextab.*)
	} > R52_0_0_VCRAM AT > R52_0_0_RAM

	__exidx_start = .;
	.ARM.exidx :
	{
		*(.ARM.exidx* .gnu.linkonce.armexidx.*)
	} > R52_0_0_VCRAM AT > R52_0_0_RAM
	__exidx_end = .;

	.r52_0_1 : {
		. = ALIGN(8);
		_r52_0_1_raw_s = .;
		KEEP(*r52_0_1.o(.raw))
		. = ALIGN(8);
		_r52_0_1_raw_e = .;
	} > R52_0_1_RAM

	.r52_1_0 : {
		. = ALIGN(8);
		_r52_1_0_raw_s = .;
		KEEP(*r52_1_0.o(.raw))
		. = ALIGN(8);
		_r52_1_0_raw_e = .;
	} > R52_1_0_RAM

	.r52_1_1 : {
		. = ALIGN(8);
		_r52_1_1_raw_s = .;
		KEEP(*r52_1_1.o(.raw))
		. = ALIGN(8);
		_r52_1_1_raw_e = .;
	} > R52_1_1_RAM

	.data :
	{
		. = ALIGN(4);
		__etext = .;
		__data_start__ = .;
		*(vtable)
		*(.data*)

		. = ALIGN(4);
		/* preinit data */
		PROVIDE_HIDDEN (__preinit_array_start = .);
		KEEP(*(.preinit_array))
		PROVIDE_HIDDEN (__preinit_array_end = .);

		. = ALIGN(4);
		/* init data */
		PROVIDE_HIDDEN (__init_array_start = .);
		KEEP(*(SORT(.init_array.*)))
		KEEP(*(.init_array))
		PROVIDE_HIDDEN (__init_array_end = .);


		. = ALIGN(4);
		/* finit data */
		PROVIDE_HIDDEN (__fini_array_start = .);
		KEEP(*(SORT(.fini_array.*)))
		KEEP(*(.fini_array))
		PROVIDE_HIDDEN (__fini_array_end = .);

		KEEP(*(.jcr*))
		. = ALIGN(8);
		/* All data end */
		__data_end__ = .;

	} > R52_0_0_RAM

	/* Due ECC initialization sequence heap and stack should be aligned on 8 bytes */
	.bss :
	{
		. = ALIGN(8);
		__ecc_init_start__ = .;
		__bss_start__ = .;
		*(.bss*)
		*(COMMON)
		__bss_end__ = .;
	} > R52_0_0_RAM

	.heap (COPY):
	{
		__end__ = .;
		PROVIDE(end = .);
		KEEP(*(.heap*))
		__HeapLimit = .;
	} > R52_0_0_RAM

	/* .stack_dummy section doesn't contains any symbols. It is only
	 * used for linker to calculate size of stack sections, and assign
	 * values to stack symbols later. 
	 * Set stack top to end of RAM, and stack limit move down by
	 * size of stack_dummy section */
	.stack_dummy (COPY):
	{
		__StackLimit = .;	
		KEEP(*(.stack*))
		. = ALIGN(8);
		__StackTop = .;
		__ecc_init_end__ = .;
	} > R52_0_0_RAM
	PROVIDE(__stack = __StackTop);

	/* Check if data + heap + stack exceeds RAM limit */
	ASSERT(__StackLimit >= __HeapLimit, "region RAM overflowed with stack")

	__TCMA_Start  = ORIGIN(R52_0_0_TCMA);
	__TCMA_Length = LENGTH(R52_0_0_TCMA);
	__TCMB_Start  = ORIGIN(R52_0_0_TCMB);
	__TCMB_Length = LENGTH(R52_0_0_TCMB);
	__TCMC_Start  = ORIGIN(R52_0_0_TCMC);
	__TCMC_Length = LENGTH(R52_0_0_TCMC);
	R52_0_0_START_ADDRESS = ORIGIN(R52_0_0_VCRAM);
	R52_0_1_START_ADDRESS = ORIGIN(R52_0_1_VCRAM);
	R52_1_0_START_ADDRESS = ORIGIN(R52_1_0_VCRAM);
	R52_1_1_START_ADDRESS = ORIGIN(R52_1_1_VCRAM);
}
