/*******************************************************************************
 * Copyright 2016-2018 NXP
 *
 * Copyright (c) 2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution.
 *******************************************************************************/
package com.freescale.sa.configurator.ui.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TreeViewContentProvider implements ITreeContentProvider {
	
	/* Tree functions */
	private boolean hasChildren = true;
	static boolean hasRoot = false;

	public static void setHasRoot(boolean _hasRoot) {
		hasRoot = _hasRoot;
	}
	
	/**
	 * Returns an array with the children for arg0 or null.
	 * 
	 * @param arg0
	 * 			The parent for children.
	 */
	public Object[] getChildren(Object arg0) {
		Object[] nodes = null;
		if (arg0 instanceof TreeDataNode) {
			TreeDataNode root = (TreeDataNode) arg0;
			/*
			 * This TreeDataNode is recursive, do not show it's children
			 */
			if (root.isRecursive()) {
				hasChildren = false;
				return null;
			}
			nodes = root.getChildren(root.getId()).toArray();

			/* Check the number children */
			hasChildren = (nodes.length > 0) ? true : false;
			return nodes;
		}
		hasChildren = false;
		return null;
	}
	
	public Object getParent(Object arg0) {
		return null;
	}

	public boolean hasChildren(Object arg0) {
		getChildren(arg0);
		return hasChildren;
	}

	/* Table Functions */

	public Object[] getElements(Object arg0) {
		if (arg0 instanceof TreeDataNode) {
			TreeDataNode node = (TreeDataNode) arg0;

			if (!hasRoot) {
				setHasRoot(true);
				List<TreeDataNode> root = new ArrayList<TreeDataNode>();

				root.add(node);
				return root.toArray();
			}
			return node.getChildren(node.getId()).toArray();
		}
		else if (arg0 instanceof Vector<?>) {
			Vector<?> vec = (Vector<?>)arg0;
			return vec.toArray();
		}
		else if (arg0 instanceof ArrayList<?>) {
			ArrayList<?> vec = (ArrayList<?>)arg0;
			return vec.toArray();
		}
		
		return null;
	}

	/**
	 * Disposes any resources
	 */
	public void dispose() {// We don't create any resources, so we don't dispose any
	}

	/**
	 * Called when the input changes
	 * 
	 * @param arg0
	 *            the parent viewer
	 * @param arg1
	 *            the old input
	 * @param arg2
	 *            the new input
	 */
	public void inputChanged(Viewer arg0, Object arg1, Object arg2) {// Nothing to do
	}
}
