/*******************************************************************************
 * Copyright (c) 2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution.
 *******************************************************************************/
package com.freescale.sa.configurator.ui.tree;

import java.util.ArrayList;
import java.util.List;

public class TreeDataNode {

    private long nodeId;
    private String host;
    private String uiName;
    private String configFile;
    private int level = 0;
    private TreeDataNode parentNode;
    private boolean grayedOut;
    private ITreeDataNodeContainer container;
    public static final String LABEL_SEPARATOR = " : "; //$NON-NLS-1$

    public TreeDataNode(String host, String configFile, long id, TreeDataNode parent,
                        ITreeDataNodeContainer container, int level, boolean grayed) {
        this.host = host;
        this.uiName = host;
        this.configFile = configFile;
        this.nodeId = id;
        this.level = level;
        this.parentNode = parent;
        this.container = container;
        this.grayedOut = grayed;
    }

    public TreeDataNode(String host, String uiName, String configFile, long id,
                        TreeDataNode parent, ITreeDataNodeContainer container, int level,
                        boolean grayed) {
        this.host = host;
        this.uiName = uiName;
        this.configFile = configFile;
        this.nodeId = id;
        this.level = level;
        this.parentNode = parent;
        this.container = container;
        this.grayedOut = grayed;
    }

    /**
     * @return the level
     */
    public int getLevel() {
        return level;
    }

    /**
     * @param level
     *            the level to set
     */
    public void setLevel(int level) {
        this.level = level;
    }

    public String getName() {
        if (configFile == null)
            return host;
        if (host == null)
            return configFile;
        return host + LABEL_SEPARATOR + configFile;
    }

    public String getUiName() {
        if (uiName == null)
            return getName();
        return uiName;
    }

    public long getId() {
        return this.nodeId;
    }

    public boolean isRecursive() {
        /* Check if the nodeId is in the parents tree */
        TreeDataNode parent = this.parentNode;

        while (parent != null) {
            if (parent.nodeId == this.nodeId) {
                return true;
            }
            parent = parent.parentNode;
        }
        return false;
    }

    /**
     * @return the parentNode
     */
    public TreeDataNode getParentNode() {
        return parentNode;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getConfigFile() {
        return configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    /**
     * @param parentNode
     *            the parentNode to set
     */
    public void setparentNode(TreeDataNode parentNode) {
        this.parentNode = parentNode;
    }

    /**
     * @return the grayedOut
     */
    public boolean isExcludedSymbol() {
        return grayedOut;
    }

    /**
     * Returns a list with the children for arg0 for the parent that has the ID
     * equal to l.
     * 
     * @param l
     *            The ID of the parent.
     * 
     *            TODO: this methods creates new TreeDataNode objects. Should we
     *            use references from allElements instead?
     */
    public List<TreeDataNode> getChildren(long l) {
        List<TreeDataNode> children = new ArrayList<TreeDataNode>();

        for (TreeDataNode element : container.getAllElements()) {
            if ((element.parentNode != null) && (element.parentNode.nodeId == l)) {

                TreeDataNode node = new TreeDataNode(element.host, element.uiName,
                                                     element.configFile, element.nodeId, this,
                                                     container, level + 1, element.grayedOut);

                children.add(node);

            }

        }
        return children;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((configFile == null) ? 0 : configFile.hashCode());
        result = prime * result + ((container == null) ? 0 : container.hashCode());
        result = prime * result + (grayedOut ? 1231 : 1237);
        result = prime * result + ((host == null) ? 0 : host.hashCode());
        result = prime * result + level;
        result = prime * result + (int) (nodeId ^ (nodeId >>> 32));
        result = prime * result + ((parentNode == null) ? 0 : parentNode.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TreeDataNode other = (TreeDataNode) obj;
        if (configFile == null) {
            if (other.configFile != null)
                return false;
        } else if (!configFile.equals(other.configFile))
            return false;
        if (container == null) {
            if (other.container != null)
                return false;
        } else if (!container.equals(other.container))
            return false;
        if (grayedOut != other.grayedOut)
            return false;
        if (host == null) {
            if (other.host != null)
                return false;
        } else if (!host.equals(other.host))
            return false;
        if (level != other.level)
            return false;
        if (nodeId != other.nodeId)
            return false;
        if (parentNode == null) {
            if (other.parentNode != null)
                return false;
        } else if (!parentNode.equals(other.parentNode))
            return false;
        return true;
    }

    public boolean isEnabled() {
        return grayedOut;
    }
}
