/*******************************************************************************
 * Copyright  2014, 2015 Freescale Semiconductor.
 * All rights reserved.
 *******************************************************************************/
package com.freescale.sa.configurator.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

/**
 * Singleton that manages the 'tabcontents' extensions.
 * 
 */
public class TabContentsManager {
	
	static Logger LOGGER = Logger
			.getLogger(TabContentsManager.class);

	// The name of the extension point.
	public static final String EXTPT_NAME = "tabcontents"; //$NON-NLS-1$
	public static final String EXTPT_ELEMENT_ARCH = "architecture"; //$NON-NLS-1$
	
	private static TabContentsManager instance = new TabContentsManager();

	private List<TabContentsContributor> tabContentsContributors = new ArrayList<TabContentsContributor>();

	/**
	 * The XML element that describes the tabcontents extension point.
	 */
	protected IConfigurationElement configurationElement;

	/**
	 * Constructor.
	 */
	private TabContentsManager() {
		IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(
				Activator.PLUGIN_ID, EXTPT_NAME);
		if (ep == null) {
			LOGGER.error("No tabcontent extensions have been defined."); //$NON-NLS-1$
			return;
		}

		// Load all the 'tabcontents' extensions.
		for (IConfigurationElement element : ep.getConfigurationElements()) {
			TabContentsContributor tabCont = new TabContentsContributor(element);
			tabContentsContributors.add(tabCont);
		}
	}

	/**
	 * @return the tab contents manager.
	 */
	public static TabContentsManager getDefault() {
		return instance;
	}

	public TabContentsContributor getTabContentsContributorForArch(String archLabel,
			String simType) throws CoreException {

		for (TabContentsContributor contributor : getAllTabContentsContributors()) {
			if (contributor.getArchitecture().contains(archLabel)) {
				return contributor;
			}
		}

		String msg = MessageFormat
				.format(Messages.TabContentsManager_ArchitectureNotSupported,
						(archLabel != null) ? archLabel : "null"); //$NON-NLS-1$ //$NON-NLS-2$
		IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, msg);
		throw new CoreException(status);
	}

	/**
	 * Return the list of known tab contents contributors.
	 * 
	 * @return
	 */
	public List<TabContentsContributor> getAllTabContentsContributors() {
		return tabContentsContributors;
	}
	
}
