/*******************************************************************************
 * Copyright  2014, 2015 Freescale Semiconductor.
 * All rights reserved.
 *******************************************************************************/
package com.freescale.sa.configurator.ui;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

import com.freescale.sa.configurator.config.IAnalysisConfigurationContents;

/**
 * Encapsulates a tabContents extension.
 */

public class TabContentsContributor {
	
	protected final static Logger LOGGER = Logger
			.getLogger(TabContentsContributor.class);

	private String architecture;
	private IAnalysisConfigurationContents tabContents;

	public TabContentsContributor(IConfigurationElement configElmt) {
		architecture = configElmt
				.getAttribute(TabContentsManager.EXTPT_ELEMENT_ARCH);

		try {
			tabContents = (IAnalysisConfigurationContents) configElmt
					.createExecutableExtension("contentProvider");
		} catch (CoreException e) {
			LOGGER.error(e.getMessage());
		}
	}

	/**
	 * @return the architecture
	 */
	public String getArchitecture() {
		return architecture;
	}

	/**
	 * @return the tabContents
	 */
	public IAnalysisConfigurationContents getTabContents() {
		return tabContents;
	}
	
	public boolean isValid(String processorName)
	{
	    if (tabContents != null) {
	        return tabContents.isValid( processorName);
	    }
	    return false;
	}

}