/*******************************************************************************
 * Copyright (c) 2018 NXP. All rights reserved.
 * Copyright (c) 2014-2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.configurator.ui;

import org.eclipse.debug.core.ILaunchConfiguration;

public interface ITargetSettingsManager {
	
	public void setManuallyTraceControl(boolean ManuallyTraceControl);
	public boolean getManuallyTraceControl();
	
	/**
     * Load instance of trace configuration.
     * 
     * @param launchConfig
     *            Launch configuration for which instance of trace configuration
     *            should be loaded.
     */
	public void loadConfigurationFromEngine(ILaunchConfiguration launchConfig);
	
    /**
     * Write configuration attributes to trace configuration. Attributes from
     * manager are written to trace configuration.
     */
    public void writeConfigurationAttributes();
	
	/***
	 * Reads the configuration attributes from the engine. 
	 */
	public void readConfigurationAttributes();
	
	public void saveConfigurationToEngine();
	
	/**
	* Returns the SA results output path as configured in the platform configuration file.
	*/
	public String getResultsOutputPath();
	   
	/**
	* Sets the SA results output path to the given location.
	* @param path
	*            the new results output path
	*            
	*/
	public void setResultsOutputPath(String path);
}
