/*******************************************************************************
 * Copyright (c) 2014, 2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution.
 *******************************************************************************/
package com.freescale.sa.configurator.ui;

import java.util.List;

import org.eclipse.core.runtime.IPath;

/**
 * This interface should be implemented by all objects that allow customization
 * of a platform configuration file (e.g., renaming).
 * 
 */
public interface ICustomizablePlatformConfig {
	/**
	 * Make any updates necessary after the name of a platform configuration has changed.
	 * 
	 * @param newName
	 *            The new name to use (it should not contain the extension; this
	 *            one is appended automatically - '.platformConfig').
	 */
	void updatePlatformConfigName(String newName);

	/**
	 * @return the folder where the platform configuration file is stored.
	 */
	IPath getPlatformConfigStorageFolder();

	/**
	 * Make any updates necessary after the creation of a new platform
	 * configuration file.
	 * 
	 * @param newFileName
	 *            the name of the new platform configuration file
	 * @param boardName
	 *            the board or processor name
	 */
	void addNewPlatformConfig(String newFileName, String boardName);
	
	
	/**
	 * Get supported boards.
	 * 
	 * @return a list with supported boards.
	 */
	List<String> getSupportedBoards();

}
