/*******************************************************************************
 * Copyright (c) 2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution.
 *******************************************************************************/
package com.freescale.sa.configurator.export;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;

import com.freescale.sa.configurator.ui.Messages;
import com.freescale.sa.configurator.ui.dialogs.OutputFolderControls;

public class ExportLocalFolderControls extends OutputFolderControls {

	public ExportLocalFolderControls(Composite parent) {
		super(false, parent);
	}
	
	public void setUpdatePlatformConfig(boolean updatePlatformConfig) {
		// N/A for export. We don't modify the platform config file.
	}
	
	protected void setupOutputFolderLabel() {
		m_outputFolderLabel.setText(Messages.Export_Folder_Text_Label);
		m_outputFolderLabel.setToolTipText(Messages.Export_Folder_Text_Tooltip);
	}
	
	protected void setupBrowseButton(Composite outputFolderComposite) {
		m_browseOutputFolderButton
		.addSelectionListener(new BrowseButtonAdapter(
				outputFolderComposite));
	}
	
	/**
	 * 
	 * Selection adapter for the button used to browse for the SA output folder.
	 */
	private class BrowseButtonAdapter extends SelectionAdapter {

		private Composite parentComposite;

		public BrowseButtonAdapter(Composite parentComposite) {
			this.parentComposite = parentComposite;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see
		 * org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse
		 * .swt.events.SelectionEvent)
		 */
		@Override
		public void widgetSelected(SelectionEvent e) {
			super.widgetSelected(e);

			DirectoryDialog dialog = new DirectoryDialog(
					parentComposite.getShell());
			dialog.setFilterPath(m_outputFolderText.getText());
			dialog.setText(Messages.Export_Folder_Dialog_Title);
			dialog.setMessage(Messages.Export_Folder_Dialog_Message);

			String oldPath = m_outputFolderText.getText();
			String newPath = dialog.open();

			if ((newPath != null) && (!newPath.equalsIgnoreCase(oldPath))) {
				IPath saOutputDirPath = new Path(newPath);
				setNewPath(saOutputDirPath, parentComposite);
			}
		}
	}
}
