/*******************************************************************************
 * Copyright (c) 2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.configurator.export;

import java.util.ArrayList;

/**
 * This class holds the manager logic for enable / disable export button.
 * @author B51891
 *
 */
public class ExportConfigDialogControlManager {

	// ArrayList of manager registered clients.
	private ArrayList<ExportConfigDialogControlClient> exportClients = new ArrayList<ExportConfigDialogControlClient>();

	/**
	 * Add a client to array.
	 */
	public void registerClient(ExportConfigDialogControlClient client) {
		exportClients.add(client);
	}

	/**
	 * Enable export button only when all clients are true.
	 * @return
	 */
	public Boolean enableExportButton() {
		for (ExportConfigDialogControlClient entry : exportClients) {
			if (!entry.getState()) {
				return false;
			}
		}
		return true;
	}

	/**
	 * Remove clients from array.
	 */
	public void unregisterAllClients() {
		exportClients.clear();
	}
}
