/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.configurator.config;

import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

/**
 * This interface holds all the methods that should be implemented by objects
 * that might trigger a modification in the RSE.
 */
public interface IRseUpdateTrigger {

	public static enum LaunchPropType {
		SPECIFY_CCS_EXE_NAME, CCS_EXE_NAME
	};
	
	/**
	 * @param config
	 *            the launch configuration working copy.
	 * @return The command line to launch ccssim2. For some targets (e.g.,
	 *         simulator) ccssim2 must be called with certain arguments to
	 *         enable trace.
	 */
	String getCcsExePath(ILaunchConfigurationWorkingCopy config);

	/**
	 * Update the port in the launch configuration.
	 * 
	 * @param config
	 *            the launch configuration working copy.
	 */
	void updatePortInTraceConfig(ILaunchConfigurationWorkingCopy config);

	/**
	 * @return the launch configuration working copy associated with the
	 *         implementing object.
	 */
	ILaunchConfigurationWorkingCopy getLaunchConfigWorkingCopy();
	
	/**
	 * Use this method to enable/disable product specific features 
	 */
	void enableDisableFeature(ILaunchConfigurationWorkingCopy launch, boolean enable);
	
}
