/*******************************************************************************
 * Copyright (c) 2014, 2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.configurator.config;

import java.io.File;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Composite;

import com.freescale.sa.configurator.ui.AnalysisLaunchConfigurationTab;

public interface IAnalysisConfigurationContents {
	/* Set parent Tab; to be used only when SA config is called from Launch configuration tab */
	public void setParentTab(AnalysisLaunchConfigurationTab parentTab);
	
	/* Set parent Tab; to be used only when SA config is called from Trace Commander */
	public void setParent(Composite parent);
	
	/* Main method to call from a SA config implementator; it builds the controls in parent composite */
	public Composite createControls(Composite parent);
	
	/* Main method to call from a Trace Commander config implementator; it builds the controls in parent composite */
	public void createTraceCommanderControls(Composite comp);
	
	/* Set defaults settings */
	public void setDefaults(ILaunchConfigurationWorkingCopy config);
	
	/* Initialize controls from a certain config */
	public void initializeFrom(ILaunchConfiguration config);
	
	/* Initialize controls from a certain platform configuration file */
	public void initializeFrom(File platformConfig);
	
	/* Refresh from a config */
	public void refreshFromConfig(ILaunchConfiguration config);
	
	/* Update a config */
	public void updateConfig(ILaunchConfigurationWorkingCopy config);
	
	/* Apply action */
	public void performApply(ILaunchConfigurationWorkingCopy config);
	
	/* Validate a config */
	public boolean isValid(ILaunchConfiguration config);
	
	/* Update launch config dialog */
	public void updateLaunchConfigurationDialog();

	public void createConfigControls(Composite comp);

	public void createConfigControls(Composite comp, File platformConfig);
	
	/* Validate a processor name */
    public boolean isValid(String processorName);

}
