/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.configurator.config;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.freescale.sa.configurator.ui.Messages;

/**
 * Generic SA config content class.
 */
public class GenericConfigurationContents extends AnalysisConfigurationContents {

	private String m_message = null;

	public GenericConfigurationContents(String message) {
		super();
		m_message = message;
	}

	public GenericConfigurationContents() {
		super();
	}

	@Override
	public Composite createControls(Composite parent) {
		// This will be called for unsupported platforms. It will display a
		// grayed "Enable Analysis" check-box.
		createCommonSAConfigControls(parent);

		m_analysisTypeGroup.dispose();
		m_traceConfigGroup.dispose();
		m_projectConfigGroup.dispose();

		Label noTargetSupport_overview = new Label(m_OverviewComposite,
				SWT.BOLD);
		if (m_message == null) {
			// use default
			noTargetSupport_overview
					.setText(Messages.SAConfigurationTargetNotSupported);
		} else {
			noTargetSupport_overview.setText(m_message);
		}

		if (!item_overview.isDisposed()) {
			item_overview.setControl(m_OverviewComposite);
		}
		Label noTargetSupport_basic = new Label(m_BasicComposite, SWT.BOLD);
		if (m_message == null) {
			// use default
			noTargetSupport_basic
					.setText(Messages.SAConfigurationTargetNotSupported);
		} else {
			noTargetSupport_basic.setText(m_message);
		}
		item_basic.setControl(m_BasicComposite);

		return m_ParentComposite;
	}

	@Override
	public void setDefaults(ILaunchConfigurationWorkingCopy config) {
		// Nothing for now.

	}

	@Override
	public void initializeFrom(ILaunchConfiguration config) {
		// Nothing for now.

	}

	@Override
	public void refreshFromConfig(ILaunchConfiguration config) {
		// Nothing for now.

	}

	@Override
	public void updateConfig(ILaunchConfigurationWorkingCopy config) {
		// Nothing for now.

	}

	@Override
	public void performApply(ILaunchConfigurationWorkingCopy config) {
		// Nothing for now.

	}

	@Override
	public boolean isValid(ILaunchConfiguration config) {
		// Nothing for now.
		return true;
	}

	@Override
	public void updateLaunchConfigurationDialog() {
		// Nothing for now.

	}

}
