/*******************************************************************************
 * Copyright (c) 2000, 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Jan Vanacek (Freescale) - extracted constants from SWT into independent class for RAP framework
 *******************************************************************************/

package com.nxp.swtools.derivative.swt;

/**
 * SWT constants which are missing in RAP.
 * 
 * @author Jan Vanacek (B45337)
 *
 */
public class SwtConstants {
	
	/**
	 * The mouse hover event type (value is 32).
	 * 
	 * @see org.eclipse.swt.widgets.Widget#addListener
	 * @see org.eclipse.swt.widgets.Display#addFilter
	 * @see org.eclipse.swt.widgets.Event
	 * 
	 * @see org.eclipse.swt.widgets.Control#addMouseTrackListener
	 * @see org.eclipse.swt.events.MouseTrackListener#mouseHover
	 * @see org.eclipse.swt.events.MouseEvent
	 */
	public static final int MOUSE_HOVER = 32;
	
	
	/** 
	 * The erase item event type (value is 40).
	 *
	 * 
	 * @see org.eclipse.swt.widgets.Widget#addListener
	 * @see org.eclipse.swt.widgets.Display#addFilter
	 * @see org.eclipse.swt.widgets.Event
	 * 
	 * @since 3.2
	 */
	public static final int ERASE_ITEM = 40;
	
	/**
	 * The measure item event type (value is 41).
	 * 
	 * @see org.eclipse.swt.widgets.Widget#addListener
	 * @see org.eclipse.swt.widgets.Display#addFilter
	 * @see org.eclipse.swt.widgets.Event
	 * 
	 * @since 3.2
	 */
	public static final int MEASURE_ITEM = 41;
	
	/**
	 * The paint item event type (value is 42).
	 * 
	 * @see org.eclipse.swt.widgets.Widget#addListener
	 * @see org.eclipse.swt.widgets.Display#addFilter
	 * @see org.eclipse.swt.widgets.Event
	 * 
	 * @since 3.2
	 */
	public static final int PAINT_ITEM = 42;

	/**
	 * Traversal event detail field value indicating that the
	 * key which designates that focus should be given to the
	 * previous tab item was pressed; typically, this is either
	 * the LEFT-ARROW or UP-ARROW keys
	 * (value is 1&lt;&lt;5).
	 *
	 * @since 1.2
	 */
	public static final int TRAVERSE_ARROW_PREVIOUS = 1 << 5;

	/**
	 * Traversal event detail field value indicating that the
	 * key which designates that focus should be given to the
	 * previous tab item was pressed; typically, this is either
	 * the RIGHT-ARROW or DOWN-ARROW keys
	 * (value is 1&lt;&lt;6).
	 *
	 * @since 1.2
	 */
	public static final int TRAVERSE_ARROW_NEXT = 1 << 6;
	
	/**
	 * Winding rule for filling operations (value is 2).
	 * 
	 * @since 3.1
	 */
	public static final int FILL_WINDING = 2;
	
	// **************	NOT SWT CONSTANTS	************** 
	
	/**
	 * Don't recreate the tooltip as long the mouse doesn't leave the area
	 * triggering the tooltip creation
	 */
	public static final int Tooltip_NO_RECREATE = 1 << 1;
	
	/**
	 * Console view identifier (value <code>"org.eclipse.ui.console.ConsoleView"</code>).
	 */
	public static final String IConsoleConstants_ID_CONSOLE_VIEW= "org.eclipse.ui.console.ConsoleView"; //$NON-NLS-1$
	
	/**
	 * Controls whether the use of <em>markup</em> in tooltip text is enabled. To enable
	 * markup in tooltip text, this constant must be passed to <code>setData()</code> with
	 * a value of <code>Boolean.TRUE</code>. The call to <code>setData()</code>
	 * must be placed directly after the control is created. Once, the markup in tooltip text
	 * is enabled it's not possible to disable it.
	 *
	 * @see Control#setData(String,Object)
	 * @see RWT#MARKUP_ENABLED
	 * @since 2.2
	 */
	public static final String RWT_TOOLTIP_MARKUP_ENABLED = "org.eclipse.rap.rwt.tooltipMarkupEnabled"; //$NON-NLS-1$
	
	  /**
	   * Controls whether the use of <em>markup</em> in text is enabled. To enable
	   * markup in text, this constant must be passed to <code>setData()</code> with
	   * a value of <code>Boolean.TRUE</code>. The call to <code>setData()</code>
	   * must be placed directly after the control is created. Once the markup in text
	   * is enabled it's not possible to disable it.
	   * <p>
	   * For example:
	   * <code><pre>
	   *   Table table = new Table( parent, SWT.NONE );
	   *   table.setData( RWT.MARKUP_ENABLED, Boolean.TRUE );
	   * </pre></code>
	   * </p>
	   * <p>
	   * When markup is enabled, certain XHTML tags can be used in the text property
	   * of the respective widget. Specifying an unsupported element will lead to an
	   * {@link IllegalArgumentException} when setting the text. The following table
	   * lists the currently supported tags:
	   * <dl>
	   * <dt>{@literal <b>text</b>}</dt>
	   * <dd>renders its content in bold font style</dd>
	   * <dt>{@literal <i>text</i>}</dt>
	   * <dd>renders its content in italic font style</dd>
	   * <dt>{@literal <br/>}</dt>
	   * <dd>inserts a line break</dd>
	   * <dt>{@literal <sub>}</dt>
	   * <dd>renders its content as subscript</dd>
	   * <dt>{@literal <sup>}</dt>
	   * <dd>renders its content as superscript</dd>
	   * <dt>{@literal <big>}</dt>
	   * <dd>renders its content with bigger font size</dd>
	   * <dt>{@literal <small>}</dt>
	   * <dd>renders its content with smaller font size</dd>
	   * <dt>{@literal <del>}</dt>
	   * <dd>renders its content as deleted text</dd>
	   * <dt>{@literal <ins>}</dt>
	   * <dd>renders its content as inserted text</dd>
	   * <dt>{@literal <em>}</dt>
	   * <dd>renders its content as emphasized text</dd>
	   * <dt>{@literal <strong>}</dt>
	   * <dd>renders its content as strong emphasized text</dd>
	   * <dt>{@literal <dfn>}</dt>
	   * <dd>renders its content as instance definition</dd>
	   * <dt>{@literal <code>}</dt>
	   * <dd>renders its content as computer code fragment</dd>
	   * <dt>{@literal <samp>}</dt>
	   * <dd>renders its content as sample program output</dd>
	   * <dt>{@literal <kbd>}</dt>
	   * <dd>renders its content as text to be entered by the user</dd>
	   * <dt>{@literal <var>}</dt>
	   * <dd>renders its content as instance of a variable or program argument</dd>
	   * <dt>{@literal <cite>}</dt>
	   * <dd>renders its content as citation</dd>
	   * <dt>{@literal <q>}</dt>
	   * <dd>renders its content as short inline quotation</dd>
	   * <dt>{@literal <abbr>}</dt>
	   * <dd>renders its content as abbreviation</dd>
	   * <dt>{@literal <span>}</dt>
	   * <dd>generic style container</dd>
	   * <dt>{@literal <img>}</dt>
	   * <dd>renders an image</dd>
	   * <dt>{@literal <a>}</dt>
	   * <dd>renders a hyperlink</dd>
	   * </dl>
	   * The visual representation of the above tags can be specified in a <code>style</code>
	   * attribute.
	   * </p>
	   * <p>
	   * <b>Used By:</b>
	   * <ul>
	   * <li><code>Table</code></li>
	   * <li><code>Tree</code></li>
	   * <li><code>List</code></li>
	   * <li><code>Label</code></li>
	   * <li><code>CLabel</code></li>
	   * <li><code>ToolTip</code></li>
	   * </ul>
	   * </p>
	   *
	   * @see Control#setData(String,Object)
	   * @see RWT#HYPERLINK
	   */
	public static final String RWT_MARKUP_ENABLED = "org.eclipse.rap.rwt.markupEnabled"; //$NON-NLS-1$
	  
	  /**
	   * Used to mark a widget as belonging to a custom variant in order to apply a
	   * different theming to it. A custom variant can be applied to any widget like this:
	   *
	   * <pre>
	   * button.setData( RWT.CUSTOM_VARIANT, "mybutton" );
	   * </pre>
	   *
	   * For more information on custom variants, see the RAP help on theming.
	   *
	   * @see Widget#setData(String,Object)
	   * @since 2.0
	   */
	public static final String RWT_CUSTOM_VARIANT = "org.eclipse.rap.rwt.customVariant"; //$NON-NLS-1$


	 /**
	   * The property to use in <code>Control.setData()</code> in order to set a custom item height.
	   * The custom item height must be specified as an <code>Integer</code> and passed to
	   * <code>setData()</code> with this constant as the key.
	   * <p>
	   * For example:
	   * <code>table.setData( RWT.CUSTOM_ITEM_HEIGHT, Integer.valueOf( 45 ) );</code>
	   * </p>
	   * <p><b>Used By:</b><ul>
	   * <li><code>Table</code></li>
	   * <li><code>Tree</code></li>
	   * <li><code>List</code></li>
	   * </ul></p>
	   *
	   * @see Control#setData(String,Object)
	   */
	public static final String RWT_CUSTOM_ITEM_HEIGHT = "org.eclipse.rap.rwt.customItemHeight"; //$NON-NLS-1$

	/** 
	* System color used to paint with alpha 0 (value is 37). 
	* <p> 
	* This pseudo-color can be used to set a transparent background on SWT 
	* controls. <br> 
	* Note that this is a <em>HINT</em> and may be overridden by the platform. 
	* For example: 
	* <ul> 
	* <li>{@link org.eclipse.swt.widgets.Combo Combo}, 
	* {@link org.eclipse.swt.widgets.List List} and 
	* {@link org.eclipse.swt.widgets.Tree Tree} support transparent background 
	* on GTK3 and Windows only.</li> 
	* <li>{@link org.eclipse.swt.widgets.Text Text} supports transparent 
	* background on Windows only whereas {@link org.eclipse.swt.widgets.Table 
	* Table} supports transparent background on GTK3 only.</li> 
	* </ul> 
	* 
	* @since 3.104 
	*/ 
	public static final int COLOR_TRANSPARENT = 37;
}