/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.criticalcode.editors;

import org.eclipse.swt.widgets.Composite;

import com.freescale.sa.model.IAnalyzer;
import com.freescale.sa.ui.common.editor.flatprofiler.FlatProfilerFileInput;
import com.freescale.sa.ui.common.editor.flatprofiler.FlatProfilerInput;
import com.freescale.sa.ui.common.editor.flatprofiler.FlatProfilerTab;

public class CriticalCodeProfilerInput extends FlatProfilerInput {
	
	public static enum SHOW_CODE_TYPE {
		ASSEMBLY, SOURCE, MIXED
	}
	
	public CriticalCodeProfilerInput(String projectName, String fileName) {
		super(projectName, fileName);
	}

	public CriticalCodeProfilerInput(String fileName) {
		super(fileName);
	}

	@Override
	public String getDisplayId() {
		return "Code Coverage"; //$NON-NLS-1$
	}

	@Override
	protected FlatProfilerTab createTab(FlatProfilerFileInput fileInput,
			String section, Composite folder, IAnalyzer analyzer) {
		return new CriticalCodeProfilerTab(fileInput, section, folder, analyzer);
	}
}
