/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.traceresults.views;


import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;

import com.freescale.sa.ui.common.flatdata.FlatDataProvider;


/**
 * This viewer displays data taken from a FlatDataProvider
 * inside one or more tables.
 */

public class TraceResultsView extends ViewPart {

	private TraceResultsFormDrawer m_form = null;
	private Composite m_parent = null;
	private TraceResultsInput m_input = null;

	/**
	 * The constructor.
	 */
	public TraceResultsView() {
		super();
		
	}

	/**
	 * Display the data from the dataProvider in to this view
	 * If the view was already open, nothing happens
	 * 
	 * @param dataProvider - provides the configuration and the data to be presented in the table
	 */
	public void setDataProvider(FlatDataProvider dataProvider) {
		if (m_form != null) {
			return;
		}
		
		m_form = new TraceResultsFormDrawer(dataProvider);
		m_form.drawForm(m_parent);
		
		setPartName(dataProvider.getName());
		m_form.getForm().setText(dataProvider.getName());
		
		m_parent.layout();
	}

	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */
	@Override
	public void createPartControl(Composite parent) {
		m_parent = parent;
		m_input = new TraceResultsInput();
		setDataProvider(m_input);
		
		// Set ID for context help.
		IWorkbenchPartSite site = getSite();
		if (site != null) {
			getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp(parent,
					UIHelp.Profile_Results_Context_Id);
		} /* don't bother if we don't get a valid site. Context help will be unavailable */
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	@Override
	public void setFocus() {
		if (m_form != null && m_form.getForm() != null) {
			m_form.getForm().setFocus();
		}
	}

    public void dispose() {
    	super.dispose();
    	if (m_form != null) {
    		m_form.dispose();
    	}
    	
    }
    
	/**
	 * Set selection.
	 * @param selection Path towards configuration file.
	 */
	public void setSelection(IFile selection) {
		if (m_form != null) {
			m_form.setSelection(selection);
		}
	 
	}
    
	/**
	 * Refresh view.
	 */
	public void refresh() {
	   if (m_form != null) {
		   m_form.refresh();
	   }
	}
}
