/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ui.traceresults.views;
import com.freescale.sa.ui.common.SAUILSPlugin;

public interface TraceResultsConstants {
	public final String PREFIX = SAUILSPlugin.PLUGIN_ID + "."; //$NON-NLS-1$

	public static final String IMPORT_DATA_FROM_TXT_FILE_ACTION_NAME = "importDataFromTxt"; //$NON-NLS-1$
	
	public static final String DEFAULT_DATE_FORMAT = "yyyy.MM.dd hh:mm:ss aaa"; //$NON-NLS-1$
	public static final String TABLE_PLATFORM_COLUMN_NAME = "platform"; //$NON-NLS-1$
	public static final String TABLE_PROJECT_COLUMN_NAME = "project"; //$NON-NLS-1$
	public static final String TABLE_RESULT_COLUMN_NAME = "result"; //$NON-NLS-1$
	public static final String TABLE_TRACE_CFG_COLUMN_NAME = "trace configuration"; //$NON-NLS-1$
	
	public static final String TIMELINE_EXTENSION = "com.freescale.sa.ui.timeline"; //$NON-NLS-1$
	public static final String PERFORMANCE_EXTENSION = "com.freescale.sa.ui.hierarchicalprofiler"; //$NON-NLS-1$
	public static final String CALL_TREE_EXTENSION = "com.freescale.sa.ui.calltree"; //$NON-NLS-1$
	public static final String CRITICALCODE_EXTENSION = "com.freescale.sa.ui.criticalcode"; //$NON-NLS-1$
	public static final String COUNTERPOINTS_EXTENSION = "com.freescale.sa.ui.counterpoints"; //$NON-NLS-1$
	public static final String IOKRA_ID = "com.freescale.sa.ui.traceviewer.okraTraceDecoder"; //$NON-NLS-1$
	
	public final String STORAGE_CONTINUOUS_MODE = "Continuous"; //$NON-NLS-1$
	public final String STORAGE_OVERWRITE_MODE = "Overwrite"; //$NON-NLS-1$
	public final String STORAGE_SAMPLING_MODE = "Statistical"; //$NON-NLS-1$
	
	public final String STORAGE_GENERAL_CONFIG_CB_NAME = "General Config"; //$NON-NLS-1$
	public final String STORAGE_DATA_TRACE_CB_NAME = "Data Trace"; //$NON-NLS-1$
	public final String STORAGE_PROGRAM_TRACE_CB_NAME = "Program Trace"; //$NON-NLS-1$
	public final String STORAGE_TARGET_NAME_ATTR_NAME = "Target Name"; //$NON-NLS-1$
	public final String STORAGE_ENABLED_ATTR_NAME = "Enabled"; //$NON-NLS-1$
	public final String STORAGE_TYPE_ATTR_NAME = "Type"; //$NON-NLS-1$
	public final String STORAGE_HAS_METRICS_ATTR_NAME = "Has Metrics"; //$NON-NLS-1$

	public final String RESULTS_CW_BLOCK = "S32DS"; //$NON-NLS-1$
	public final String RESULTS_PLATFORM_NAME = "Platform Configuration"; //$NON-NLS-1$
	public final String RESULTS_DATA_STREAM = "Data Stream"; //$NON-NLS-1$
	public final String RESULTS_PROJECT_NAME = "Project Name"; //$NON-NLS-1$
	public final String RESULTS_COMMENT = "Comment"; //$NON-NLS-1$
	
	public final String RESULTS_DATA_STREAM_STATISTICAL = "Statistical"; //$NON-NLS-1$

	public static final String STORAGE_INPUT_PATH = "Input:Input Path"; //$NON-NLS-1$
	public static final String STORAGE_INPUT_BASE_FILENAME = "Input:Base File Name"; //$NON-NLS-1$
	public static final String TIME_VALUE_ATTR = STORAGE_GENERAL_CONFIG_CB_NAME
			+ ":Time Value Type"; //$NON-NLS-1$
	public static final String TIME_RADIX_ATTR = STORAGE_GENERAL_CONFIG_CB_NAME
			+ ":Time Radix"; //$NON-NLS-1$
	public static final String CPU_FREQ_ATTR = STORAGE_GENERAL_CONFIG_CB_NAME
			+ ":CPU clock frequency"; //$NON-NLS-1$
	public static final String TIME_UNIT_ATTR = STORAGE_GENERAL_CONFIG_CB_NAME
	+ ":Time Unit"; //$NON-NLS-1$
	public static final String TARGET_ATTR = STORAGE_GENERAL_CONFIG_CB_NAME + ":" //$NON-NLS-1$
			+ STORAGE_TARGET_NAME_ATTR_NAME;
	public static final String STORAGE_HAS_METRICS_ATTR = STORAGE_PROGRAM_TRACE_CB_NAME
			+ ":" + STORAGE_HAS_METRICS_ATTR_NAME;  //$NON-NLS-1$
	public static final String STORAGE_OUTPUT_BASE_FILENAME = "Output:Base File Name"; //$NON-NLS-1$

}
