/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution.
 *******************************************************************************/

package com.freescale.sa.ui.traceresults.views;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

import com.freescale.sa.configurator.ui.Messages;
import com.freescale.sa.ui.common.utils.SaUiLsUtils;
import com.freescale.sa.ui.common.utils.StorageUtils.ResourceFolder;
import com.freescale.sa.ui.common.utils.StorageUtils.ResourceFolders;

public class SelectOutputFolderDialogContent extends Composite {

	private Table table;
	private Button addButton;
	private Button removeButton;
	private ResourceFolders folders;
	
	/**
	 * Helper function to overcome SWTBot issue with native windows.
	 * @return
	 */
	private String openDirectoryDialog(Composite parent) {
		if (SaUiLsUtils.isInTestMode()) {			
			InputDialog dialog = new InputDialog(parent.getShell(), "InputDialog",//$NON-NLS-1$
					"Please enter the file path", "", null);//$NON-NLS-1$ //$NON-NLS-2$
			if (dialog.open() == IStatus.OK) { // open dialog and wait for return status code.
				return dialog.getValue();
			} else {
				return null;
			}
		} else {
			DirectoryDialog dialog = new DirectoryDialog(parent
					.getShell());
			dialog.setText(Messages.Output_Folder_Dialog_Title);
			dialog.setMessage(Messages.Output_Folder_Dialog_Message);
	
			return dialog.open();
		}
	}

	/**
	 * Create the composite.
	 * 
	 * @param parent
	 * @param style
	 */
	public SelectOutputFolderDialogContent(Composite parent, int style,
			ResourceFolders foldersArg) {
		super(parent, style);
		this.folders = foldersArg;

		setLayout(new GridLayout(2, false));
		setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, true, 1, 1));

		Composite tableComposite = new Composite(this, SWT.FILL);
		GridData data = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 3);
		data.heightHint = 200;
		data.widthHint = 350;
		tableComposite.setLayoutData(data);

		table = new Table(tableComposite, SWT.BORDER | SWT.FULL_SELECTION
				| SWT.CHECK | SWT.V_SCROLL | SWT.H_SCROLL | SWT.MULTI);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		TableColumn column = new TableColumn(table, SWT.NONE);
		column.setText(com.freescale.sa.ui.traceresults.views.Messages.SelectOutputFolderDialog_Path);

		TableColumnLayout tableColumnLayout = new TableColumnLayout();
		tableColumnLayout.setColumnData(column, new ColumnWeightData(350));
		tableComposite.setLayout(tableColumnLayout);

		for (ResourceFolder folder : folders.getFolders()) {
			addTableItem(folder);
		}

		table.addListener(SWT.Selection, new Listener() {
			@Override
			public void handleEvent(Event event) {
				if (!(event.item instanceof TableItem)) {
					return;
				}

				TableItem tableItem = (TableItem) event.item;

				if (event.detail == SWT.CHECK) {
					Boolean checked = tableItem.getChecked();
					if (!(tableItem.getData() instanceof ResourceFolder)) {
						return;
					}

					ResourceFolder folder = (ResourceFolder) tableItem
							.getData();
					if (checked) {
						folder.setEnabled(true);
					} else {
						folder.setEnabled(false);
					}
				} else {
					removeButton.setEnabled(true);
				}
			}
		});

		addButton = new Button(this, SWT.NONE);
		GridData gd_addButton = new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1);
		gd_addButton.widthHint = 81;
		addButton.setLayoutData(gd_addButton);
		addButton.setText(com.freescale.sa.ui.traceresults.views.Messages.SelectOutputFolderDialog_Add_Button);
		
		final Composite addButtonParent = addButton.getParent();
		addButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				String newPath = openDirectoryDialog(addButtonParent);

				if (newPath != null) {
					addNewResourcePath(newPath);
				}
			}
		});

		removeButton = new Button(this, SWT.NONE);
		removeButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));
		removeButton.setEnabled(false);
		removeButton.setText(com.freescale.sa.ui.traceresults.views.Messages.SelectOutputFolderDialog_Remove_Button);
		removeButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TableItem[] items = table.getSelection();
				if (items == null) {
					return;
				}
				
				for (TableItem item : items) {
					/* Remove entries from folders */
					if (item.getData() != null && item.getData() instanceof ResourceFolder) {
						folders.getFolders().remove((ResourceFolder)item.getData());
					}
					
					/* Remove data from UI */
					Integer itemIndex = table.indexOf(item);
					table.remove(itemIndex);
				}
				
				removeButton.setEnabled(false);
			}
		});
		new Label(this, SWT.NONE);
	}
	
	/**
	 * Adds a table intem in <code>table<code> based on a <code>ResourceFolder</code>
	 * @param folder	The entry to be added
	 */
	private void addTableItem(ResourceFolder folder) {
		TableItem item = new TableItem(table, SWT.NONE);
		item.setChecked(folder.getEnabled());
		item.setText(folder.getPath());
		item.setData(folder);
	}

	/**
	 * Adds a new path to <code>folders</code> only if it isn't present
	 * 
	 * @param path
	 *            The path to be added
	 */
	private void addNewResourcePath(String path) {
		boolean found = false;
		if (path == null) {
			return;
		}

		for (ResourceFolder folder : folders.getFolders()) {
			if (folder.getPath().compareToIgnoreCase(path) == 0) {
				found = true;
			}
		}

		if (!found) {
			ResourceFolder folder = new ResourceFolder(true, path);
			folders.getFolders().add(folder);
			addTableItem(folder);
		}
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

}
