/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution.
 *******************************************************************************/
package com.freescale.sa.ui.traceresults.views;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

import com.freescale.sa.ui.common.utils.StorageUtils;
import com.freescale.sa.ui.common.utils.StorageUtils.ResourceFolders;

/**
 * Dialog for creating a new platform configuration file.
 */
public class SelectOutputFolderDialog extends TitleAreaDialog {
	private ResourceFolders folders;

	/**
	 * Constructor.
	 * 
	 * @param parentShell
	 *            the parent shell
	 */
	public SelectOutputFolderDialog(Shell parentShell) {
		super(parentShell);

		folders = new ResourceFolders();
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		folders = StorageUtils.getCustomFolders();
		new SelectOutputFolderDialogContent(parent, SWT.NONE, folders);
		return parent;
	}

	@Override
	public boolean isHelpAvailable() {
		// Don't want help for this window.
		return false;
	}

	@Override
	protected void okPressed() {
		StorageUtils.updateNames(folders);
		super.okPressed();
	}

	@Override
	public void create() {
		super.create();
		setTitle(Messages.SelectOutputFolderDialog_Title);
		setMessage(Messages.SelectOutputFolderDialog_Default_Message);
		// by default the OK button is disable so the user can't create a new
		// file with empty name
	}

	@Override
	protected void configureShell(Shell theShell) {
		super.configureShell(theShell);
		theShell.setText(Messages.SelectOutputFolderDialog_Shell_Title);
	}
}
