/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.traceresults.utils;

import java.util.Vector;

import org.eclipse.core.runtime.Path;

public class TraceResultsLock {	
	public static class ResultsPair {
		public String storageDir;
		public String baseFileName;
		
		public boolean equals(Object resultsPair) {
			if (resultsPair instanceof ResultsPair) {
				Path storagePath = new Path(storageDir);
				Path otherStoragePath = new Path(((ResultsPair)resultsPair).storageDir);
				return storagePath.equals(otherStoragePath) && baseFileName.equals(((ResultsPair)resultsPair).baseFileName);
			}
			return false;
		}
		
		public int hashCode() {
			// Instances of this class are not intended to be inserted into a HashMap/HashTable.
			// Implement this method if you need its functionality.  
			assert false : "hashCode not designed"; //$NON-NLS-1$
			return 42; // Any arbitrary constant will do. 
		}
		
		public ResultsPair(String _storageDir, String _baseFileName) {
			storageDir = _storageDir;
			baseFileName = _baseFileName;
		}
	}
	
	private static Vector<ResultsPair> traceResultsVector = new Vector<ResultsPair>();
	
	public static synchronized void releaseLock(String storageDir, String baseFileName) {
		ResultsPair resultsPair = new ResultsPair(storageDir, baseFileName);
		for (int i = 0; i < traceResultsVector.size(); i++)
			if (resultsPair.equals(traceResultsVector.elementAt(i))) {
				traceResultsVector.remove(i);
				return;
			}
	}
	
	public static synchronized boolean tryLock(String storageDir, String baseFileName) { 
		ResultsPair resultsPair = new ResultsPair(storageDir, baseFileName);
		for (int i = 0; i < traceResultsVector.size(); i++)
			if (resultsPair.equals(traceResultsVector.elementAt(i))) {
				return false;
			}
		traceResultsVector.add(resultsPair);
		return true;
	}
}
