/*******************************************************************************
 * Copyright (c) 2014-2016 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ui.traceresults.utils;

import java.util.Vector;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

import com.freescale.sa.SaConstants;
import com.freescale.sa.util.CommonConstants;

/**
 * Helper class for Analysis results plug-in.
 * 
 * @author B20491
 * 
 */
public class ResultsUtils {
	
	/**
     * Get launch configuration name and arch id from a raw trace config file
     * (an archived data producer).
	 * 
	 * @param rawTraceConfigPath
	 *            The fill path in the file system of the raw trace config file.
	 * @return The ID of the architecture.
	 */
	public static synchronized String[] getLaunchNameAndArchIdFromRawTraceConfig(String rawTraceConfigPath) {
		String launchName = ""; //$NON-NLS-1$
		String archId = CommonConstants.STORAGE_ANY_TARGET;
		
		if (!rawTraceConfigPath.endsWith(SaConstants.raw_trace_config_extension)) {
			return null;
		}
				
		String[] rezult = {launchName, archId};
		
		return rezult;
	}
	
	/**
	 * Get all the target configurations (*.traceConfig; i.e., archived producer
	 * configs) from the project's list of resources.
	 * 
	 * The configuration is stored this way for SC and MCU (for PA it's
	 * different).
	 * 
	 * @param project
	 *            The current project.
	 * @return The vector of files associates with the target configs.
	 */
	public static Vector<IResource> getTargetConfigsInProject(IProject project) {

		Vector<IResource> traceCfgFiles = new Vector<IResource>();

		if (project.isOpen()) {
			try {

				IResource[] projMembers = project.members();
				for (IResource resource : projMembers) {
                    if (resource.getType() == IResource.FILE && resource.getParent() != null
							&& resource.getParent().getType() == IResource.PROJECT) {
						String ext = resource.getFileExtension();
						if ((ext != null)
								&& ((ext.compareToIgnoreCase(CommonConstants.DP_ARCHIVE_EXT) == 0)
										|| (ext.compareToIgnoreCase(CommonConstants.DP_PL_ARCHIVE_EXT) == 0))) {
							traceCfgFiles.add(resource);
						}
					}
				}
			} catch (CoreException e) {
				e.printStackTrace();
			}
		}
		return traceCfgFiles;
	}
}
