/*******************************************************************************
 * Copyright (c) 2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.timeline;


import org.eclipse.osgi.util.NLS;


public final class UIResourceBundle extends NLS {

	static final String BUNDLE_NAME = "com.freescale.sa.ui.resources.UI"; //$NON-NLS-1$
	private static UIResourceBundle instance;

	private UIResourceBundle() {// Do not instantiate
	}
	
	static {
		NLS.initializeMessages(BUNDLE_NAME, UIResourceBundle.class);
	}
	
	public static UIResourceBundle getInstance() {
		if (instance == null) {
			instance = new UIResourceBundle();
		}
		return instance;
	}

	/**
	 * Gets the corresponding string object from the resource object.
	 *
	 * @param key            the key to search with
	 * @return               the corresponding string object result; null if
	 *                       there is no match for the key
	 */
	public String getString(String key) {
		 	
		if (key == null) {
			return null;
		}
		String DOT = "."; //$NON-NLS-1$
		String UNDERLLINE = "_"; //$NON-NLS-1$
		String str = ""; //$NON-NLS-1$

		try {
			// for the old code 
			if (key.contains(DOT)) {
				key = key.replace(DOT, UNDERLLINE);
			}
	        	        	
			str = (String)this.getClass().getField(key).get(this);
			if (str != null) {
				str = str.trim();
			}
		} catch (NoSuchFieldException ex) {
			str = null;
		} catch (SecurityException ex) {
			str = null;
		} catch (IllegalAccessException ex) {
			str = null;
		}
	
		return str;
	}
}
