package com.freescale.sa.ui.timeline;

import java.io.File;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IURIEditorInput;

import com.freescale.sa.ui.common.ITraceEditorInput;

public class TimelineInputFile implements ITraceEditorInput {

	private boolean m_exists;
	private ImageDescriptor m_imageDescriptor;
	private String m_name;
	private IPersistableElement m_persistable;
	private String m_tooltip;
	private String m_storageDirectory;
	private String m_path;
	
	public TimelineInputFile(IEditorInput inputFile){
		m_exists = inputFile.exists();
		m_imageDescriptor = inputFile.getImageDescriptor();
		m_name = inputFile.getName();
		m_persistable = inputFile.getPersistable();
		m_tooltip = inputFile.getToolTipText();
				
		if (inputFile instanceof IURIEditorInput) {
			String path = (new File(((IURIEditorInput)inputFile).getURI())).getAbsolutePath();
			m_path = path;
			m_storageDirectory = path.substring(0, path.length() - m_name.length() - 1);
		} else if (inputFile instanceof TimelineInputFile) {
			m_storageDirectory = ((TimelineInputFile) inputFile).getStorageDirectory();
			m_path = ((TimelineInputFile) inputFile).getPath();
		} else if (inputFile instanceof IPathEditorInput) {
			String path = ((IPathEditorInput) inputFile).getPath().toOSString();
			m_path = path;
			m_storageDirectory = path.substring(0, path.length() - m_name.length() - 1);
		}
		
	}
	
	@Override
	public boolean exists() {
		return m_exists;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return m_imageDescriptor;
	}

	@Override
	public String getName() {
		return m_name;
	}

	@Override
	public IPersistableElement getPersistable() {
		return m_persistable;
	}

	@Override
	public String getToolTipText() {
		return m_tooltip;
	}

	@Override
	public String getStorageDirectory() {
		return m_storageDirectory;
	}
	
	public String getPath () {
		return m_path;
	}

	@SuppressWarnings("rawtypes")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

}
