/*******************************************************************************
 * Copyright (c) 2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ui.timeline;

import org.eclipse.swt.graphics.RGB;

/**
 * Class that manages custom events (other than functions)
 * that are displayed into the timeline view
 * @author R70188
 *
 */
public class TimelineCustomEvent {
	
	private RGB m_color;
	private String m_name;
	
	/**
	 * Public constructor
	 * @param color the color used to pain the custom event
	 * @param name the name of the event as it will be represented on the timeline
	 */
	public TimelineCustomEvent(String name, RGB color) {
		m_color = color;
		m_name = name;
	}

	/**
	 * Gets the color of the custom event
	 * @return
	 */
	public RGB getColor() {
		return m_color;
	}
	
	/**
	 * Gets the name of the custom event
	 * @return
	 */
	public String getName() {
		return m_name;
	}
}
