/*******************************************************************************
 * Copyright (c) 2016 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.timeline;

import java.math.BigInteger;
import java.util.List;

/**
 * This function holds all functions contained by the kernel image. We have only
 * one context info because the kernel image is the same for all kernel
 * contexts.
 *
 * @author B46903
 *
 */
public class KernelTimelineFunctionInfo extends TimelineFunctionInfoBase {
    private TimelineContextInfo kernelFunctions;

    public KernelTimelineFunctionInfo() {
        kernelFunctions = new TimelineContextInfo();
    }

    @Override
    public void addFunction(TimelineFunction function) {
        kernelFunctions.addFunction(function);
    }

    @Override
    public TimelineFunction findFunction(BigInteger address, String source, String context) {
        return getFunctionFromTimelineContext(kernelFunctions, address);
    }

    @Override
    public Integer getSize() {
        return kernelFunctions.getSize();
    }

    @Override
    public Integer getFunctionCount(String source, String context) {
        return kernelFunctions.getSize();
    }

    @Override
    public List<TimelineFunction> getFunctions(String source, String context) {
        return kernelFunctions.getFunctions();
    }

    @Override
    public TimelineFunction getFunction(int index, String source, String context) {
        return kernelFunctions.getFunction(index);
    }
}
