/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.timeline;

import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;

import com.freescale.sa.ui.common.TraceAction;

/**
 * Action class that will allow the user o set the CPU frequency. To transform
 * cycles to real time (e.g.: seconds), the CPU frequency is needed/ By default
 * an average value is used, but this gives the user the possibility to set an
 * accurate value if he has means to determine it.
 */
public class FrequencyAction extends TraceAction {

	private double m_freqSelection = -1;
	private TimeUnitGroup m_parentTimeUnitGroup;

	/**
	 * Ctor.
	 * 
	 * @param initialFrequency
	 *            initialy frequency
	 * @param parentTimeUnitGroup
	 *            the TimeUnitGroup that created this action
	 */
	public FrequencyAction(double initialFrequency,
			TimeUnitGroup parentTimeUnitGroup) {
		super(UIMessages.ConfigTimeUnit_CpuFreq, IAction.AS_PUSH_BUTTON);
		m_parentTimeUnitGroup = parentTimeUnitGroup;
		m_freqSelection = initialFrequency;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.action.Action#run()
	 */
	public void run() {
		new SetFrequencyDialog(Display.getDefault().getActiveShell(),
				m_configurableParents, m_freqSelection,
				this).open();
		//super.run();
	}

	/**
	 * Set frequency to the given value.
	 * 
	 * @param selectedFreq
	 *            the new frequency value
	 */
	public void setFreqSelection(Double selectedFreq) {
		m_freqSelection = selectedFreq;
		m_parentTimeUnitGroup.setFreqSelection(selectedFreq);

	}
}
