/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.util;


public class OS {
	static Boolean mWindows = null;
	static Boolean mWindowsVista = null;
	static Boolean mMac = null;

	static synchronized public boolean isWindows() {
		if (mWindows == null) {
			mWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1; //$NON-NLS-1$ //$NON-NLS-2$
		}
		return mWindows;
	}

	static public boolean isLinux() {
		return !isWindows() && !isMac();
	}

	static synchronized public boolean isMac() {
		if (mMac == null) {
			mMac = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1; //$NON-NLS-1$ //$NON-NLS-2$
		}
		return mMac;
	}

	static public String getOSDesc() {
		return System.getProperty("os.name") + " (" + System.getProperty("os.version") + "-"  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				+ System.getProperty("os.arch") + ")";  //$NON-NLS-1$ //$NON-NLS-2$
	}
}
