/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.util;


import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

import com.freescale.sa.Messages;


/**
 * Message dialog with don't prompt again option.
 */
public class MessageDialogWithDontPromptAgainOption extends MessageDialog {
	
	// Custom area is 'Don't prompt again' button area.
	Button dontPromptAgainBtn;
	final static int DONT_PROMPT_AGAIN_BTN_WIDTH = 150;
	boolean dontPromptAgain = false;
	
	/**
	 * Message dialog with don't prompt again option.
	 * @param parentShell Parent shell.
	 * @param dialogTitle Title of message dialog
	 * @param dialogMessage Message from dialog.
	 */
	public MessageDialogWithDontPromptAgainOption(Shell parentShell,
			String dialogTitle, String dialogMessage) {
		super(parentShell, dialogTitle, null, dialogMessage,
				MessageDialog.INFORMATION, new String[] { IDialogConstants.OK_LABEL }, 0);
	}
	
	@Override
    protected Control createCustomArea(Composite parent) {
									
		GridData dontPromptAgainGridData = new GridData();
		dontPromptAgainGridData.widthHint = DONT_PROMPT_AGAIN_BTN_WIDTH;
		dontPromptAgainBtn = new Button(parent, SWT.CHECK);
		dontPromptAgainBtn.setLayoutData(dontPromptAgainGridData);
		dontPromptAgainBtn.setText(Messages.msg_info_dont_prompt_again);
		dontPromptAgainBtn.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				dontPromptAgain = dontPromptAgainBtn.getSelection();
				
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// Nothing to do here.
				
			}
		});
		
        return parent;
    }
	
	/**
	 * Dont't prompt again state.
	 * @return True if user chooses not to be prompted again,
	 * false otherwise.
	 */
	public boolean getDontPromptAgain() {
		return dontPromptAgain;
	}
	
	
}
