/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.util;


import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Text;


/**
 * Helper class to handle changes for hex text fields (check validity).
 * 
 * @author B05639
 * 
 */
public abstract class IpAddressFieldModifyListener implements ModifyListener {
	private Text m_IpAddrTextField = null;
	private String m_ErrTooltip = "Please enter a valid IP address"; //$NON-NLS-1$
	private String m_NoErrTooltip = CommonConstants.EMPTY_STRING;
	private static final String PATTERN = 
	        "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\." +
	        "([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\." +
	        "([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\." +
	        "([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";

	/**
	 * Constructor.
	 * 
	 * @param ipAddrTextField
	 *            The IP address text field that registered for this listener.
	 * @param noErrTooltip
	 *            The tooltip to display in case the field is valid.
	 */
	public IpAddressFieldModifyListener(Text ipAddrTextField, String noErrTooltip) {
		m_IpAddrTextField = ipAddrTextField;
		m_NoErrTooltip = noErrTooltip;
	}
	
	public boolean validateIPAddress(final String ip){          

	      Pattern pattern = Pattern.compile(PATTERN);
	      Matcher matcher = pattern.matcher(ip);
	      return matcher.matches();             
	}
	
	public boolean validateText() {
		boolean errMsg = false;

		errMsg = validateIPAddress(m_IpAddrTextField.getText());
		
		if (!errMsg) {
			// field is invalid
			m_IpAddrTextField.setToolTipText(m_ErrTooltip);
			m_IpAddrTextField.setBackground(new Color(m_IpAddrTextField.getDisplay(), CommonConstants.RGB_RED_ERROR));
			return false;
		} else {
			m_IpAddrTextField.setToolTipText(m_NoErrTooltip);
			m_IpAddrTextField.setBackground(new Color(m_IpAddrTextField.getDisplay(), CommonConstants.RGB_WHITE));
			return true;
		}
	}
}
