/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.util;


import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Text;


/**
 * Helper class to handle changes for hex text fields (check validity).
 * 
 * @author B05639
 * 
 */
public abstract class HexFieldModifyListener implements ModifyListener {
	private Text m_HexTextField = null;
	private String m_NoErrTooltip = CommonConstants.EMPTY_STRING; 
	private int m_FieldSize = 0;
	private String m_minHexVal = null;
	private String m_maxHexVal  = null;

	/**
	 * Constructor.
	 * 
	 * @param hexTextField
	 *            The hex text field that registered for this listener.
	 * @param noErrTooltip
	 *            The tooltip to display in case the field is valid.
	 * @param size
	 *            The size of the text fields (in no of bits).
	 */
	public HexFieldModifyListener(Text hexTextField, String noErrTooltip,
			int size) {
		m_HexTextField = hexTextField;
		m_NoErrTooltip = noErrTooltip;
		m_FieldSize = size;
	}
	
	/**
	 * Constructor.
	 * 
	 * @param hexTextField
	 *            The hex text field that registered for this listener.
	 * @param noErrTooltip
	 *            The tooltip to display in case the field is valid.
	 * @param size
	 *            The size of the text fields (in no of bits).
	 * @param minHexVal
	 * 			  The minimum hex value valid for the hex value.
	 * 			  Null or empty string if no constraint on
	 *            on minimum value.
	 * @param maxHexVal
	 * 			  The maximum hex value valid for the hex value.
	 *  		  Null or empty string if no constraint on
	 *            on maximum value.
	 */
	public HexFieldModifyListener(Text hexTextField, String noErrTooltip,
			int size, String minHexVal, String maxHexVal) {
		m_HexTextField = hexTextField;
		m_NoErrTooltip = noErrTooltip;
		m_FieldSize = size;
		m_minHexVal = minHexVal;
		m_maxHexVal = maxHexVal;
	}

	public boolean validateText() {
		String errMsg = CommonConstants.EMPTY_STRING; 

		errMsg = Utils.verifyHexField(m_HexTextField.getText(), m_FieldSize, m_minHexVal, m_maxHexVal);
		
		if (errMsg.length() != 0) {
			// field is invalid
			m_HexTextField.setToolTipText(errMsg);
			m_HexTextField.setBackground(new Color(m_HexTextField.getDisplay(), CommonConstants.RGB_RED_ERROR));
			return false;
		} else {
			m_HexTextField.setToolTipText(m_NoErrTooltip);
			m_HexTextField.setBackground(new Color(m_HexTextField.getDisplay(), CommonConstants.RGB_WHITE));
			return true;
		}
	}
}
