/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.util;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Text;

/**
 * Modify listener for a text field that contains a value of type double. It's
 * main purpose is to check it's validity (e.g.: the value in included in the
 * appropriate range).
 */
public abstract class DoubleFieldModifyListener implements ModifyListener {
	private Text textField = null;
	private String noErrTooltip = CommonConstants.EMPTY_STRING;
	private double minVal = 0;
	private double maxVal = 0;

	/**
	 * 
	 * @param textField
	 *            The text field that registered for this listener.
	 * @param noErrTooltip
	 *            The tooltip to display in case the field is valid.
	 * @param mivVal
	 *            The lower limit of the valid value range.
	 * @param maxVal
	 *            The upper limit of the valid value range.
	 */
	public DoubleFieldModifyListener(Text textField, String noErrTooltip,
			double minVal, double maxVal) {
		this.textField = textField;
		this.noErrTooltip = noErrTooltip;
		this.minVal = minVal;
		this.maxVal = maxVal;

	}

	/**
	 * Check if the text field for the double value contains a valid value. If
	 * it is not valid, the text field will be colored red and the tooltip will
	 * indicate the cause of the error.
	 * 
	 * @return true if the value is valid, false otherwise.
	 */
	public boolean validateText() {
		boolean valid = true;

		String errMsg = CommonConstants.EMPTY_STRING;

		errMsg = Utils.verifyDoubleField(textField.getText(), minVal, maxVal);
		if (errMsg.length() != 0) {
			// field is invalid
			textField.setToolTipText(errMsg);
			textField.setBackground(new Color(textField.getDisplay(),
					CommonConstants.RGB_RED_ERROR));
			valid = false;
		} else {
			textField.setToolTipText(noErrTooltip);
			textField.setBackground(new Color(textField.getDisplay(),
					CommonConstants.RGB_WHITE));
		}

		return valid;

	}

}
