/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.util;


import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Text;


/**
 * @author b05639
 * 
 *         Modify listener for a text field that contains a decimal value. It's
 *         main purpose is to check it's validity (e.g.: the value in included
 *         in the appropriate range).
 */
public abstract class DecFieldModifyListener implements ModifyListener {
	private Text m_TextField = null;
	private String m_NoErrTooltip = CommonConstants.EMPTY_STRING;
	private long m_MinVal = 0;
	private long m_MaxVal = 0;

	/**
	 * 
	 * @param textField
	 *            The text field that registered for this listener.
	 * @param noErrTooltip
	 *            The tooltip to display in case the field is valid.
	 * @param mivVal
	 *            The lower limit of the valid value range.
	 * @param maxVal
	 *            The upper limit of the valid value range.
	 */
	public DecFieldModifyListener(Text textField, String noErrTooltip,
			long minVal, long maxVal) {
		m_TextField = textField;
		m_NoErrTooltip = noErrTooltip;
		m_MinVal = minVal;
		m_MaxVal = maxVal;

	}

	/**
	 * Check if the text field for the decimal value contains a valid value. If
	 * it is not valid, the text field will be colored red and the tooltip will
	 * indicate the cause of the error.
	 * 
	 * @return true if the value is valid, false otherwise.
	 */
	public boolean validateText() {
		boolean valid = true;

		String errMsg = CommonConstants.EMPTY_STRING; 

		errMsg = Utils.verifyDecField(m_TextField.getText(), m_MinVal, m_MaxVal);
		if (errMsg.length() != 0) {
			// field is invalid
			m_TextField.setToolTipText(errMsg);
			m_TextField.setBackground(new Color(m_TextField.getDisplay(), CommonConstants.RGB_RED_ERROR));
			valid = false;
		} else {
			m_TextField.setToolTipText(m_NoErrTooltip);
			m_TextField.setBackground(new Color(m_TextField.getDisplay(), CommonConstants.RGB_WHITE));
		}

		return valid;
	}
}
