/*******************************************************************************
 * Copyright (c) 2014, 2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.util;

import java.io.File;
import java.io.FileFilter;

/**
 * File filter for extension
 */
public class CustomFileFilter implements FileFilter {
	
	private String m_extension;

	public CustomFileFilter(String extension) {
		super();
		
		m_extension = extension;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.FilenameFilter#accept(java.io.File, java.lang.String)
	 */
	@Override
	public boolean accept(File file) {
		if (!m_extension.equals(CommonConstants.EMPTY_STRING)) {
			String extension = getFileExtension(file);
			return (extension
					.equalsIgnoreCase(m_extension));
		} else {
			return file.isDirectory();
		}
	}
	
	/**
	 * Get extension of the given file.
	 * 
	 * @param file
	 *            The file.
	 * @return The extension of the file.
	 */
	private String getFileExtension(File file) {
		String fileName = file.getName();
		int extensionPos = fileName.lastIndexOf('.');
		String extension = fileName.substring(extensionPos + 1);
		return extension;
	}

}
