/*******************************************************************************
 * Copyright (c) 2016-2018 NXP Semiconductor, Inc. All rights reserved.
/*******************************************************************************
 * Copyright (c) 2014-2016 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.swt.graphics.RGB;

/**
 * 
 * Constants
 */
public class CommonConstants {

	public final static String EMPTY_STRING = ""; //$NON-NLS-1$
	public final static String MAX_64 = "0xFFFFFFFFFFFFFFFF"; //$NON-NLS-1$
	public final static String MIN_64 = "0x0"; //$NON-NLS-1$
	public final static String PROCESSOR_NOT_FOUND = ""; //$NON-NLS-1$
	public final static String SIMULATOR_NONE = "None"; //$NON-NLS-1$
	public final static String AUTODETECTED = "Autodetected"; //$NON-NLS-1$
	/**
	 * RGB code for the 'red' color that will be used as background for UI
	 * fields with errors. It is the one reccomanded by Pedro Larios at the
	 * trace target config UI review.
	 */
	public static final RGB RGB_RED_ERROR = new RGB(255, 127, 127);

	/**
	 * RGB code for the 'white' color that will be used as background for UI
	 * vlaid fields.
	 */
	public static final RGB RGB_WHITE = new RGB(255, 255, 255);

	/**
	 * Launch config attributes identifiers. They should be synchronized with
	 * the ones in IAnalysisConstants from the "launch" plugin.
	 */
	public static final String LAUNCH_SIM_TYPE_ATTR = "com.freescale.cdt.debug.cw.CW_SHADOWED_PREF.Embedded Initialization.simulator"; //$NON-NLS-1$
	public static final String LAUNCH_CORE_IDX_ATTR = "com.freescale.cdt.debug.cw.CW_SHADOWED_PREF.Embedded Initialization.coreIndex"; //$NON-NLS-1$
	public static final String LAUNCH_TARGET_ARM_PROCESSOR_ATTR = "com.freescale.cdt.debug.cw.CW_SHADOWED_PREF.ARM Debugger Target.processor"; //$NON-NLS-1$
	public static final String LAUNCH_PROJECT_ATTR = "org.eclipse.cdt.launch.PROJECT_ATTR"; //$NON-NLS-1$
	public static final String LAUNCH_ELF_FILE_ATTR = "org.eclipse.cdt.launch.PROGRAM_NAME"; //$NON-NLS-1$

	public static final String TRACE_COMMANDER_EXTENSION_POINT = "com.freescale.sa.tracecommander"; //$NON-NLS-1$
	
	//s32 debugger launchconfig attributes constants
	public static final String S32_LAUNCH_DEVICE_ATTR = "com.nxp.s32ds.debug.ide.s32debugger.core.device"; //$NON-NLS-1$
	public static final String S32_LAUNCH_CORE_ATTR = "com.nxp.s32ds.debug.ide.s32debugger.core.core"; //$NON-NLS-1$
	public static final String S32_DEBUG_PROBE = "S32 Debug Probe"; //$NON-NLS-1$
	public static final String S32_LAUNCH_SERVER_ADDR_ATTR = "com.nxp.s32ds.debug.ide.s32debugger.core.serverPortNumber"; //$NON-NLS-1$
	public static final String S32_LAUNCH_DEFAULT_DEVICE_ATTR = "Select device";
	
	// The result path should not be greater than 256 characters (including
	// extension of files)
	public static final int MAX_LENGTH = 260;

	public static final String DDR_TRACE_BUFFER_NAME = "DDR"; //$NON-NLS-1$
	public static final String DTC_TRACE_BUFFER_NAME = "DTC"; //$NON-NLS-1$
	public static final String S_DTC_TRACE_BUFFER_NAME = "S-DTC"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_TRACE_GENERATORS_DESCRIPTION_ATTR = "Description"; //$NON-NLS-1$

	// Attributes in platform config.
	public static final String PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME = "Trace Generators"; //$NON-NLS-1$
	public static final String CORE_TRACE_GEN_NAME = "CORE"; //$NON-NLS-1$
	public static final String PXDI_TRACE_GEN_NAME = "PXDI"; //$NON-NLS-1$
	public static final String DDDI_TRACE_GEN_NAME = "DDDI"; //$NON-NLS-1$
	public static final String NOC_TRACE_GEN_NAME = "NOC"; //$NON-NLS-1$
	public static final String STM_TRACE_GEN_NAME = "STM"; //$NON-NLS-1$
	public static final String NOC_MAIN_TRACE_GEN_NAME = "NOC:MAIN"; //$NON-NLS-1$
	public static final String NOC_HSIO_TRACE_GEN_NAME = "NOC:HSIO"; //$NON-NLS-1$
	public static final String NOC_MAIN_TYPE = "NOC_MAIN"; //$NON-NLS-1$
	public static final String NOC_HSIO_TYPE = "NOC_HSIO"; //$NON-NLS-1$
	public static final String MAIN_TRACE_GEN_NAME = "MAIN"; //$NON-NLS-1$
	public static final String HSIO_TRACE_GEN_NAME = "HSIO"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_START_TRACE_ON_LAUNCH_ATTR_NAME = "Start Trace On Launch"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_MANUALLY_UPLOAD_ATTR_NAME = "Upload Manually"; //$NON-NLS-1$

	public static final String PROBE_SIMULATOR_NAME = "ARMv8 Simulator"; //$NON-NLS-1$

	// All config attributes are grouped in "Core X" config blocks, where X is
	// the core index. The 'path' of a config attribute should be prefixed with
	// the correct name of the core config block.
	public static final String PLATFORM_CONFIG_CORE_START_TRACE_ON_LAUNCH_ATTR_PATH = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":Core %s:" + PLATFORM_CONFIG_START_TRACE_ON_LAUNCH_ATTR_NAME; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_CORE_ENABLE_TRACE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":Core %s:Enable Trace"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_CORE_TIMESTAMP_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":Core %s:Timestamp"; //$NON-NLS-1$	
	public static final String PLATFORM_CONFIG_CORE_TRACE_MODE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":Core %s:TraceMode"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_CORE_TRACE_SCENARIO_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":Core %s:TraceScenario"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_CORE_TRACE_ID_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":Core %s:TraceID"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_CORE_DATA_STREAM_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":Core %s:DataStreams"; //$NON-NLS-1$

	public static final String PLATFORM_CONFIG_START_TRACE_ON_LAUNCH_ATTR_PATH = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + CORE_TRACE_GEN_NAME + ":%s:" + PLATFORM_CONFIG_START_TRACE_ON_LAUNCH_ATTR_NAME; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_UI_NAME_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + CORE_TRACE_GEN_NAME + ":%s:UI Name"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ENABLE_TRACE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + CORE_TRACE_GEN_NAME + ":%s:Enable Trace"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_DEPENDENCY_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + CORE_TRACE_GEN_NAME + ":%s:Dependency"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_TIMESTAMP_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + CORE_TRACE_GEN_NAME + ":%s:Timestamp"; //$NON-NLS-1$	
	public static final String PLATFORM_CONFIG_TRACE_MODE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + CORE_TRACE_GEN_NAME + ":%s:TraceMode"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_TRACE_SCENARIO_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + CORE_TRACE_GEN_NAME + ":%s:TraceScenario"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_TRACE_ID_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + CORE_TRACE_GEN_NAME + ":%s:TraceID"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_DATA_STREAM_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + CORE_TRACE_GEN_NAME + ":%s:DataStreams"; //$NON-NLS-1$
	public static final String PLATFORM_ARMV8_CONFIG_CORE_ENABLE_TRACE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":CORE:Core %s:Enable Trace"; //$NON-NLS-1$	

	public static final String PLATFORM_CONFIG_DATA_TRACE_START_ADDR_ATTR = CommonConstants.PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":%s:Data Trace Start Address"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_DATA_TRACE_RANGE_SIZE_ATTR = CommonConstants.PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":%s:Data Trace Range Size"; //$NON-NLS-1$

	public static final String PLATFORM_CONFIG_DDDI_TIMESTAMP_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + DDDI_TRACE_GEN_NAME + ":%s:Timestamp"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_DDDI_UI_NAME_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + DDDI_TRACE_GEN_NAME + ":%s:UI Name"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_DDDI_DEPENDENCY_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + DDDI_TRACE_GEN_NAME + ":%s:Dependency"; //$NON-NLS-1$	
	public static final String PLATFORM_CONFIG_ENABLE_DDDI_TRACE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + DDDI_TRACE_GEN_NAME + ":%s:Enable Trace"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_MASTER_DDDI_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + DDDI_TRACE_GEN_NAME + ":%s:Master DDDI"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_TRACE_MODE_DDDI_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + DDDI_TRACE_GEN_NAME + ":%s:Trace Mode"; //$NON-NLS-1$

	public static final String PLATFORM_CONFIG_MASTER_PXDI_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + PXDI_TRACE_GEN_NAME + ":%s:Master PXDI"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_PXDI_UI_NAME_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + PXDI_TRACE_GEN_NAME + ":%s:UI Name"; //$NON-NLS-1$	
	public static final String PLATFORM_CONFIG_DEPENDENCY_PXDI_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + PXDI_TRACE_GEN_NAME + ":%s:Dependency"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ENABLE_PXDI_TRACE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + PXDI_TRACE_GEN_NAME + ":%s:Enable Trace"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_DEBUG_PROBE_PXDI_TRACE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + PXDI_TRACE_GEN_NAME + ":%s:Debug Probe Select"; //$NON-NLS-1$

	public static final String PLATFORM_CONFIG_ENABLE_NOC_TRACE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + NOC_TRACE_GEN_NAME + ":%s:Enable Trace"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_NOC_UI_NAME_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + NOC_TRACE_GEN_NAME + ":%s:UI Name"; //$NON-NLS-1$		
	public static final String PLATFORM_CONFIG_NOC_DEPENDENCY_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + NOC_TRACE_GEN_NAME + ":%s:Dependency"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ENABLE_NOC_PAYLOAD_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + NOC_TRACE_GEN_NAME + ":%s:Enable Payload"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ENABLE_NOC_STATISTICS_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + NOC_TRACE_GEN_NAME + ":%s:Enable Statistics"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ENABLE_NOC_INTRUSIVE_MODE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + NOC_TRACE_GEN_NAME + ":%s:Enable Intrusive Mode"; //$NON-NLS-1$

	public static final String PLATFORM_CONFIG_ENABLE_NOC_MAIN_TRACE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + NOC_MAIN_TRACE_GEN_NAME + ":%s:Enable Trace"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_NOC_MAIN_UI_NAME_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + NOC_MAIN_TRACE_GEN_NAME + ":%s:UI Name"; //$NON-NLS-1$		
	public static final String PLATFORM_CONFIG_ENABLE_NOC_HSIO_TRACE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + NOC_HSIO_TRACE_GEN_NAME + ":%s:Enable Trace"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_NOC_HSIO_UI_NAME_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + NOC_HSIO_TRACE_GEN_NAME + ":%s:UI Name"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_DEPENDENCY_NOC_HSIO_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + NOC_HSIO_TRACE_GEN_NAME + ":%s:Dependency"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_DEPENDENCY_NOC_MAIN_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + NOC_MAIN_TRACE_GEN_NAME + ":%s:Dependency"; //$NON-NLS-1$

	public static final String PLATFORM_CONFIG_DEPENDENCY_STM_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + STM_TRACE_GEN_NAME + ":%s:Dependency"; //$NON-NLS-1$	
	public static final String PLATFORM_CONFIG_STM_UI_NAME_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + STM_TRACE_GEN_NAME + ":%s:UI Name"; //$NON-NLS-1$	
	public static final String PLATFORM_CONFIG_ENABLE_STM_TRACE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + STM_TRACE_GEN_NAME + ":%s:Enable Trace"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ENABLE_STM_TIMESTAMP_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + STM_TRACE_GEN_NAME + ":%s:Timestamp"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_STM_BANK_SEL_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + STM_TRACE_GEN_NAME + ":%s:Bank Event ID"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_STM_ENABLE_HW_EVENTS_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + STM_TRACE_GEN_NAME + ":%s:Enable Hw Events Trace"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ENABLE_STM_HW_EVT_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":" + STM_TRACE_GEN_NAME + ":%s:Enable Hardware Events"; //$NON-NLS-1$

	public static final String PLATFORM_CONFIG_TRACE_ENABLE_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":%s:%s:Enable Trace"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_TRACE_UI_NAME_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":%s:%s:UI Name"; //$NON-NLS-1$

	public static final String RESULTS_OUTPUT_FOLDER_ATTR = "Results:Output Folder"; //$NON-NLS-1$
	public static final String RESULTS_PLATFORM_CONFIGURATION_ATTR = "S32DS:Platform Configuration"; //$NON-NLS-1$
	public static final String RESULTS_LAUNCH_NAME_ATTR = "S32DS:Launch Name"; //$NON-NLS-1$
	public static final String RESULTS_SOURCE_MAPPING_CONFIG_BLOCK_NAME = "SourceMapping"; //$NON-NLS-1$
	public static final String RESULTS_DATA_STREAM_CONFIG_BLOCK_NAME = "S32DS:Data Stream"; //$NON-NLS-1$
	public static final String RESULTS_TARGET_IMAGE_BLOCK_NAME = "Target Images:Image "; //$NON-NLS-1$

	public static final String PLATFORM_CONFIG_ACTIVE_LAUNCH_CFG_ATTR = "Target Access:LaunchName"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ACTIVE_TARGET_ACCESS_METHOD_ATTR = "Target Access:Target Access Method"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ACTIVE_TARGET_ACCESS_SERVER_ADDR_ATTR = "Target Access:ServerAddress"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ACTIVE_TARGET_ACCESS_SOC_ATTR = "Target Access:SOC"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ACTIVE_TARGET_ACCESS_TRACE_COMPLEX_GEN_ATTR = "Target Access:TraceComplexGeneration"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ACTIVE_TARGET_ACCESS_MEM_SPACE_ATTR = "Target Access:MemSpace"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ACTIVE_TARGET_ACCESS_CORE_ATTR = "Target Access:Core"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ACTIVE_TARGET_ACCESS_CONNECTION_ATTR = "Target Access:Connection"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ACTIVE_TARGET_ACCESS_SERVER_PORT_ATTR = "Target Access:ServerPort"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ACTIVE_TARGET_ACCESS_USER_CODE_ATTR = "Target Access:EnableUserCode"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ACTIVE_DATA_STREAM_NAME = "Core %s"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ACTIVE_CORE_NAME = "Core %s"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ACTIVE_DDDI_NAME = "DDDI %s"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ACTIVE_PXDI_NAME = "PXDI %s"; //$NON-NLS-1$
	public static final String TARGET_ACCESS_SERVER_DEFAULT_ADDR_ATTR = "127.0.0.1"; //$NON-NLS-1$

	// %s in the string below should be replaced with the name of the data
	// stream
	public static final String PLATFORM_CONFIG_RAW_TRACE_PATH = "Data Streams:%s:Raw Trace path"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_TRACE_COLLECTION_MODE = "Data Streams:TraceCollectionMode"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_TRACE_COLLECTION_MODE_PATH = "Data Streams:%s:TraceCollectionMode"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_DATA_STREAMS_UI_NAME = "Data Streams:%s:UI Name"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_ENABLE_LOGGING_ATTR = PLATFORM_CONFIG_TRACE_GENERATORS_CB_NAME
			+ ":Core %s:Enable Logging"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_DDR_TRACE_BUFFER_SIZE = "Data Streams:DDR:Trace Buffer Size"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_DDR_TRACE_BUFFER_BASE_ADDRESS = "Data Streams:DDR:Trace Buffer Base Address"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_TRACE_LOCATION = "Data Streams:TraceLocation"; //$NON-NLS-1$

	public static final String PLATFORM_OUTPUT_FOLDER = "Results:Output Folder"; //$NON-NLS-1$

	public static final String PXDI_CB_FUNNEL_NAME = "PXDI Funnel";
	public static final String GPP_CB_FUNNEL_NAME = "GPP Funnel";
	public static final String HSIO_CB_FUNNEL_NAME = "HSIO Funnel";
	public static final String SOC_CB_FUNNEL_NAME = "SoC Funnel";
	public static final String MAIN_OBSERVER_CB_NAME = "main_observer_main_AtbEndPoint";
	public static final String HSIO_OBSERVER_CB_NAME = "ww_observer_main_AtbEndPoint";
	public static final String GPP_CLUSTER_FUNNEL_NAME = "GPP Cluster Funnel";
	public static final String NOC_MODULES_NAME = "NoC Modules";
	public static final String SOC_MODULES_NAME = "SoC Modules";

	public static final String TARGET_CONFIG_ONE_BUFFER_ATTR = "OneBuffer"; //$NON-NLS-1$
	public static final String TARGET_CONFIG_OVERWRITE_ATTR = "Overwrite"; //$NON-NLS-1$

	public static final String DataStreamsName = "Data Streams"; //$NON-NLS-1$
	public static final String TraceLocationName = "Trace Location"; //$NON-NLS-1$

	/* Target Access Methods */
	public static final String TARGET_ACCESS_LTA = "LTA"; //$NON-NLS-1$
	public static final String TARGET_ACCESS_GTA = "GTA"; //$NON-NLS-1$
	public static final String TARGET_ACCESS_SCS = "SCS"; //$NON-NLS-1$
	public static final String TARGET_ACCESS_LOGGER = "Logger"; //$NON-NLS-1$

	public static final int CORES_PER_CLUSTER = 4;
	public static final String CLUSTER_SEP = " Cores "; //$NON-NLS-1$
	public static final String[] CLUSTER_CORES = new String[] {
			"0-3 ", "4-7 ", "8-11 ", "12-15 " }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$

	public static final String PLATFORM_CONFIG_PROFILING_AND_SIMULATOR_ENABLE_PERFORMANCE = "Profiling and Simulator Trace:Enable Performance"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_PROFILING_AND_SIMULATOR_ENABLE_SAMPLING = "Profiling and Simulator Trace:Enable Sampling"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_PROFILING_AND_SIMULATOR_PERFORMANCE_PROCESSING_SCENARIO = "Profiling and Simulator Trace:Performance Processing Scenario Simulator"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_PROFILING_AND_SIMULATOR_PORT = "Profiling and Simulator Trace:Simulator Port"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_PROFILING_AND_SIMULATOR_SAMPLING_RATE = "Profiling and Simulator Trace:Sampling Rate"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_PROFILING_AND_SIMULATOR_SAMPLING_CORE_ID = "Profiling and Simulator Trace:Sampling Core ID"; //$NON-NLS-1$

	/**
	 * The extension used for the data producer archived.
	 */
	public static final String DP_ARCHIVE_EXT = "traceConfig"; //$NON-NLS-1$
	public static final String DP_PL_ARCHIVE_EXT = "platformConfig"; //$NON-NLS-1$

    public static final List<String> SUPPORTED_LIBS = Collections.unmodifiableList(Arrays.asList("elb", //$NON-NLS-1$
                                                                                                 "a")); //$NON-NLS-1$
    
	public static final String STORAGE_ANY_TARGET = "Any"; //$NON-NLS-1$

	public static final String PLATFORM_CONFIG_OUTPUT_PATH_ATTR = "General Settings:Results Output Path"; //$NON-NLS-1$
    public static final String GENERAL_CONFIG_BLOCK = "General config"; //$NON-NLS-1$
	public static final String PLATFORM_CONFIG_MANUALLY_TRACE_CONTROL_ATTR_PATH = GENERAL_CONFIG_BLOCK + ":Manually Trace Control"; //$NON-NLS-1$
    public static final String PROBE_ID_ATTR_PATH = GENERAL_CONFIG_BLOCK + ":Probe ID"; //$NON-NLS-1$

	public static final String T2G_STRINGS_UTIL = "strings";//$NON-NLS-1$    
    public static final String ARCH_NAME = "ARMv8"; //$NON-NLS-1$
    
	// Soc_Name
    public static final String LS1043_SOC_NAME = "LS1043A"; //$NON-NLS-1$
    public static final String S32V234_SOC_NAME = "S32V234"; //$NON-NLS-1$
    public static final String S32V232_SOC_NAME = "S32V232"; //$NON-NLS-1$

    /**
     * Probe ID (TMC or DTC)
     */
    public static final String TMC_PROBE_ID = "TMC"; //$NON-NLS-1$
}
