/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.util;


/**
 * Exception class to be used when an attribute is not found in a configuration. 
 */
public class AttrNotFoundException extends Exception {

	private static final long serialVersionUID = -2161782792962873466L;

	/** The name of the class that caught the error. */
	private String classname;

	/** The name of the method that caught the error. */
	private String method;

	/**
	 * A string of useful data. First of all a message which describes the
	 * situation, but also values of variables within the class or method.
	 */
	private String message;

	/**
	 * An instance of "AttrNotFoundException", or null if this is the first in
	 * the linked list.
	 */
	private AttrNotFoundException previous = null;
	private String separator = "\n"; //$NON-NLS-1$

	public AttrNotFoundException(String classname, String method,
			String message, AttrNotFoundException previous) {
		//this.id = id;
		this.classname = classname;
		this.method = method;
		this.message = message;
		this.previous = previous;
	}

	public String traceBack() {
		return traceBack("\n"); //$NON-NLS-1$
	}

	public String traceBack(String sep) {
		this.separator = sep;
		int level = 0;
		AttrNotFoundException e = this;
		String text = line("Calling sequence (top to bottom)"); //$NON-NLS-1$
		while (e != null) {
			level++;
			text += line("--level " + level //$NON-NLS-1$
					+ "--------------------------------------"); //$NON-NLS-1$
			text += line("Class/Method: " + e.classname + "/" + e.method); //$NON-NLS-1$ //$NON-NLS-2$
			//text += line("Id          : " + e.id);
			text += line("Message     : " + e.message); //$NON-NLS-1$
			e = e.previous;
		}
		return text;
	}

	private String line(String s) {
		return s + separator;
	}
}
