/*******************************************************************************
 * Copyright (c) 2016 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.relocation;

import com.freescale.sa.util.CommonConstants;

public class SourceCodeCorrelation extends BaseSourceCodeCorrelation {
    private String pid;
    private String context;
    private String loadAddress;
    private String newAppPathName;

    public SourceCodeCorrelation() {
        this(CommonConstants.EMPTY_STRING, CommonConstants.EMPTY_STRING,
                CommonConstants.EMPTY_STRING, CommonConstants.EMPTY_STRING,
                CommonConstants.EMPTY_STRING);
    }

    public SourceCodeCorrelation(String pid, String context,
            String loadAddress, String appPathName) {
        this.setPid(pid);
        this.setContext(context);
        this.setLoadAddress(loadAddress);
        this.appPathName = appPathName;
    }

    public SourceCodeCorrelation(String pid, String context,
            String loadAddress, String appPathName, String newAppPathName) {
        this.setPid(pid);
        this.setContext(context);
        this.setLoadAddress(loadAddress);
        this.appPathName = CommonConstants.EMPTY_STRING;
        this.newAppPathName = newAppPathName;
    }

    public SourceCodeCorrelation(final SourceCodeCorrelation rhs) {
        this(rhs.getPid(), rhs.getContext(), rhs.getLoadAddress(),
                rhs.appPathName);
    }

    public String getLoadAddress() {
        return loadAddress;
    }

    public void setLoadAddress(String loadAddress) {
        this.loadAddress = loadAddress;
    }

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getNewAppPathName() {
        return newAppPathName;
    }

    public void setNewAppPathName(String newAppPathName) {
        this.newAppPathName = newAppPathName;
    }

}
