/*******************************************************************************
 * Copyright (c) 2015-2016 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/


/**
 * Interface for Okra Recommendation Engine Extension point
 * @author b20977
 *
 */

package com.freescale.sa.model;

import org.eclipse.swt.widgets.Shell;


public interface IOkraRecEngine {
	public enum OkraRecEngReturn {
		REC_ENG_OK,
		REC_ENG_CANCELLED,
		REC_ENG_CANNOT_ANALYZE,
	};
	
	/**
	 * Invokes recommendation engine to extract valid recommendations.
	 * 
	 * @param gemsFile   - resources database file
	 * @param outputFile - results database file
	 * @param shell		 - shell that will be used for progress monitor 
	 * @return true if operation succeeded and false otherwise
	 */
	public OkraRecEngReturn callRecEngine(String gemsFile, String outputFile, Shell shell);
	
	/**
	 * Invokes recommendation engine to save information about an executable file.
	 * 
	 * @param gemsFile        - resources database file
	 * @param elfPath_string  - path of the executable file.
	 */
	public void saveExecutableInfoInGems(String gemsFile, String elfPath_string);
	
}
